//Auto-generated by kalyptus. DO NOT EDIT.
namespace KParts {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  The part manager is an object which knows about a collection of parts
    ///  (even nested ones) and handles activation/deactivation.
    ///  Applications that want to embed parts without merging GUIs
    ///  only use a KParts.PartManager. Those who want to merge GUIs use a
    ///  KParts.MainWindow for example, in addition to a part manager.
    ///  Parts know about the part manager to add nested parts to it.
    ///  See also KParts.Part.Manager() and KParts.Part.SetManager().
    ///   See <see cref="IPartManagerSignals"></see> for signals emitted by PartManager
    /// </remarks>        <short>    The part manager is an object which knows about a collection of parts  (even nested ones) and handles activation/deactivation.</short>
    [SmokeClass("KParts::PartManager")]
    public class PartManager : QObject, IDisposable {
        protected PartManager(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(PartManager), this);
        }
        public enum SelectionPolicy {
            Direct = 0,
            TriState = 1,
        }
        /// <remarks>
        ///  This extends QFocusEvent.Reason with the non-focus-event reasons for partmanager to activate a part.
        ///  To test for "any focusin reason", use < ReasonLeftClick
        ///  NoReason usually means: explicit activation with <see cref="#setActivePart"></see>.
        ///      </remarks>        <short>    This extends QFocusEvent.Reason with the non-focus-event reasons for partmanager to activate a part.</short>
        public enum Reason {
            ReasonLeftClick = 100,
            ReasonMidClick = 101,
            ReasonRightClick = 102,
            NoReason = 103,
        }
        [Q_PROPERTY("KParts::PartManager::SelectionPolicy", "selectionPolicy")]
        public KParts.PartManager.SelectionPolicy selectionPolicy {
            get { return (KParts.PartManager.SelectionPolicy) interceptor.Invoke("selectionPolicy", "selectionPolicy()", typeof(KParts.PartManager.SelectionPolicy)); }
            set { interceptor.Invoke("setSelectionPolicy$", "setSelectionPolicy(KParts::PartManager::SelectionPolicy)", typeof(void), typeof(KParts.PartManager.SelectionPolicy), value); }
        }
        [Q_PROPERTY("bool", "allowNestedParts")]
        public bool AllowNestedParts {
            get { return (bool) interceptor.Invoke("allowNestedParts", "allowNestedParts()", typeof(bool)); }
            set { interceptor.Invoke("setAllowNestedParts$", "setAllowNestedParts(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "ignoreScrollBars")]
        public bool IgnoreScrollBars {
            get { return (bool) interceptor.Invoke("ignoreScrollBars", "ignoreScrollBars()", typeof(bool)); }
            set { interceptor.Invoke("setIgnoreScrollBars$", "setIgnoreScrollBars(bool)", typeof(void), typeof(bool), value); }
        }
        /// <remarks>
        ///  Constructs a part manager.
        /// <param> name="parent" The toplevel widget (window / dialog) the
        ///                partmanager should monitor for activation/selection
        ///                events
        ///      </param></remarks>        <short>    Constructs a part manager.</short>
        public PartManager(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("PartManager#", "PartManager(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Constructs a part manager.
        /// <param> name="topLevel" The toplevel widget (window / dialog ) the
        ///                  partmanager should monitor for activation/selection
        ///                  events
        /// </param><param> name="parent" The parent QObject.
        ///      </param></remarks>        <short>    Constructs a part manager.</short>
        public PartManager(QWidget topLevel, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("PartManager##", "PartManager(QWidget*, QObject*)", typeof(void), typeof(QWidget), topLevel, typeof(QObject), parent);
        }
        /// <remarks>
        ///  Specifies which mouse buttons the partmanager should react upon.
        ///  By default it reacts on all mouse buttons (LMB/MMB/RMB).
        /// <param> name="buttonMask" a combination of Qt.ButtonState values e.g. Qt.LeftButton | Qt.MidButton
        ///      </param></remarks>        <short>    Specifies which mouse buttons the partmanager should react upon.</short>
        public void SetActivationButtonMask(short buttonMask) {
            interceptor.Invoke("setActivationButtonMask$", "setActivationButtonMask(short int)", typeof(void), typeof(short), buttonMask);
        }
        /// <remarks>
        /// </remarks>        <short>   </short>
        ///         <see> setActivationButtonMask</see>
        public short ActivationButtonMask() {
            return (short) interceptor.Invoke("activationButtonMask", "activationButtonMask() const", typeof(short));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [SmokeMethod("eventFilter(QObject*, QEvent*)")]
        public override bool EventFilter(QObject arg1, QEvent ev) {
            return (bool) interceptor.Invoke("eventFilter##", "eventFilter(QObject*, QEvent*)", typeof(bool), typeof(QObject), arg1, typeof(QEvent), ev);
        }
        /// <remarks>
        ///  Adds a part to the manager.
        ///  Sets it to the active part automatically if <code>setActive</code> is true (default ).
        ///  Behavior fix in KDE3.4: the part's widget is shown only if setActive is true,
        ///  it used to be shown in all cases before.
        ///      </remarks>        <short>    Adds a part to the manager.</short>
        [SmokeMethod("addPart(KParts::Part*, bool)")]
        public virtual void AddPart(KParts.Part part, bool setActive) {
            interceptor.Invoke("addPart#$", "addPart(KParts::Part*, bool)", typeof(void), typeof(KParts.Part), part, typeof(bool), setActive);
        }
        [SmokeMethod("addPart(KParts::Part*)")]
        public virtual void AddPart(KParts.Part part) {
            interceptor.Invoke("addPart#", "addPart(KParts::Part*)", typeof(void), typeof(KParts.Part), part);
        }
        /// <remarks>
        ///  Removes a part from the manager (this does not delete the object) .
        ///  Sets the active part to 0 if <code>part</code> is the activePart() .
        ///      </remarks>        <short>    Removes a part from the manager (this does not delete the object) .</short>
        [SmokeMethod("removePart(KParts::Part*)")]
        public virtual void RemovePart(KParts.Part part) {
            interceptor.Invoke("removePart#", "removePart(KParts::Part*)", typeof(void), typeof(KParts.Part), part);
        }
        /// <remarks>
        ///  Replaces <code>oldPart</code> with <code>newPart</code>, and sets <code>newPart</code> as active if
        ///  <code>setActive</code> is true.
        ///  This is an optimised version of removePart + addPart
        ///      </remarks>        <short>    Replaces <code>oldPart</code> with <code>newPart</code>, and sets <code>newPart</code> as active if  <code>setActive</code> is true.</short>
        [SmokeMethod("replacePart(KParts::Part*, KParts::Part*, bool)")]
        public virtual void ReplacePart(KParts.Part oldPart, KParts.Part newPart, bool setActive) {
            interceptor.Invoke("replacePart##$", "replacePart(KParts::Part*, KParts::Part*, bool)", typeof(void), typeof(KParts.Part), oldPart, typeof(KParts.Part), newPart, typeof(bool), setActive);
        }
        [SmokeMethod("replacePart(KParts::Part*, KParts::Part*)")]
        public virtual void ReplacePart(KParts.Part oldPart, KParts.Part newPart) {
            interceptor.Invoke("replacePart##", "replacePart(KParts::Part*, KParts::Part*)", typeof(void), typeof(KParts.Part), oldPart, typeof(KParts.Part), newPart);
        }
        /// <remarks>
        ///  Sets the active part.
        ///  The active part receives activation events.
        ///  <code>widget</code> can be used to specify which widget was responsible for the activation.
        ///  This is important if you have multiple views for a document/part , like in KOffice .
        ///      </remarks>        <short>    Sets the active part.</short>
        [SmokeMethod("setActivePart(KParts::Part*, QWidget*)")]
        public virtual void SetActivePart(KParts.Part part, QWidget widget) {
            interceptor.Invoke("setActivePart##", "setActivePart(KParts::Part*, QWidget*)", typeof(void), typeof(KParts.Part), part, typeof(QWidget), widget);
        }
        [SmokeMethod("setActivePart(KParts::Part*)")]
        public virtual void SetActivePart(KParts.Part part) {
            interceptor.Invoke("setActivePart#", "setActivePart(KParts::Part*)", typeof(void), typeof(KParts.Part), part);
        }
        /// <remarks>
        ///  Returns the active part.
        /// </remarks>        <short>    Returns the active part.</short>
        [SmokeMethod("activePart() const")]
        public virtual KParts.Part ActivePart() {
            return (KParts.Part) interceptor.Invoke("activePart", "activePart() const", typeof(KParts.Part));
        }
        /// <remarks>
        ///  Returns the active widget of the current active part (see activePart ).
        ///      </remarks>        <short>    Returns the active widget of the current active part (see activePart ).</short>
        [SmokeMethod("activeWidget() const")]
        public virtual QWidget ActiveWidget() {
            return (QWidget) interceptor.Invoke("activeWidget", "activeWidget() const", typeof(QWidget));
        }
        /// <remarks>
        ///  Sets the selected part.
        ///  The selected part receives selection events.
        ///  <code>widget</code> can be used to specify which widget was responsible for the selection.
        ///  This is important if you have multiple views for a document/part , like in KOffice .
        ///      </remarks>        <short>    Sets the selected part.</short>
        [SmokeMethod("setSelectedPart(KParts::Part*, QWidget*)")]
        public virtual void SetSelectedPart(KParts.Part part, QWidget widget) {
            interceptor.Invoke("setSelectedPart##", "setSelectedPart(KParts::Part*, QWidget*)", typeof(void), typeof(KParts.Part), part, typeof(QWidget), widget);
        }
        [SmokeMethod("setSelectedPart(KParts::Part*)")]
        public virtual void SetSelectedPart(KParts.Part part) {
            interceptor.Invoke("setSelectedPart#", "setSelectedPart(KParts::Part*)", typeof(void), typeof(KParts.Part), part);
        }
        /// <remarks>
        ///  Returns the current selected part.
        ///      </remarks>        <short>    Returns the current selected part.</short>
        [SmokeMethod("selectedPart() const")]
        public virtual KParts.Part SelectedPart() {
            return (KParts.Part) interceptor.Invoke("selectedPart", "selectedPart() const", typeof(KParts.Part));
        }
        /// <remarks>
        ///  Returns the selected widget of the current selected part (see selectedPart ).
        ///      </remarks>        <short>    Returns the selected widget of the current selected part (see selectedPart ).</short>
        [SmokeMethod("selectedWidget() const")]
        public virtual QWidget SelectedWidget() {
            return (QWidget) interceptor.Invoke("selectedWidget", "selectedWidget() const", typeof(QWidget));
        }
        /// <remarks>
        ///  Returns the list of parts being managed by the partmanager.
        ///      </remarks>        <short>    Returns the list of parts being managed by the partmanager.</short>
        public List<KParts.Part> Parts() {
            return (List<KParts.Part>) interceptor.Invoke("parts", "parts() const", typeof(List<KParts.Part>));
        }
        /// <remarks>
        ///  Adds the <code>topLevel</code> widget to the list of managed toplevel widgets.
        ///  Usually a PartManager only listens for events (for activation/selection)
        ///  for one toplevel widget (and its children) , the one specified in the
        ///  constructor. Sometimes however (like for example when using the KDE dockwidget
        ///  library) , it is necessary to extend this.
        ///      </remarks>        <short>    Adds the <code>topLevel</code> widget to the list of managed toplevel widgets.</short>
        public void AddManagedTopLevelWidget(QWidget topLevel) {
            interceptor.Invoke("addManagedTopLevelWidget#", "addManagedTopLevelWidget(const QWidget*)", typeof(void), typeof(QWidget), topLevel);
        }
        /// <remarks>
        ///  Removes the <code>topLevel</code> widget from the list of managed toplevel widgets.
        /// </remarks>        <short>    Removes the <code>topLevel</code> widget from the list of managed toplevel widgets.</short>
        ///         <see> addManagedTopLevelWidget</see>
        public void RemoveManagedTopLevelWidget(QWidget topLevel) {
            interceptor.Invoke("removeManagedTopLevelWidget#", "removeManagedTopLevelWidget(const QWidget*)", typeof(void), typeof(QWidget), topLevel);
        }
        /// <remarks>
        /// </remarks>        <return> the reason for the last activePartChanged signal emitted.
        /// </return>
        ///         <short>   </short>
        ///         <see> Reason</see>
        public int reason() {
            return (int) interceptor.Invoke("reason", "reason() const", typeof(int));
        }
        /// <remarks>
        ///  Changes the active instance when the active part changes.
        ///  The active instance is used by KBugReport and KAboutDialog.
        ///  Override if you really need to - usually you don't need to.
        ///      </remarks>        <short>    Changes the active instance when the active part changes.</short>
        [SmokeMethod("setActiveComponent(const KComponentData&)")]
        protected virtual void SetActiveComponent(KComponentData instance) {
            interceptor.Invoke("setActiveComponent#", "setActiveComponent(const KComponentData&)", typeof(void), typeof(KComponentData), instance);
        }
        /// <remarks>
        ///  Removes a part when it is destroyed.
        /// </remarks>        <short>    Removes a part when it is destroyed.</short>
        [Q_SLOT("void slotObjectDestroyed()")]
        protected void SlotObjectDestroyed() {
            interceptor.Invoke("slotObjectDestroyed", "slotObjectDestroyed()", typeof(void));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [Q_SLOT("void slotWidgetDestroyed()")]
        protected void SlotWidgetDestroyed() {
            interceptor.Invoke("slotWidgetDestroyed", "slotWidgetDestroyed()", typeof(void));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [Q_SLOT("void slotManagedTopLevelWidgetDestroyed()")]
        protected void SlotManagedTopLevelWidgetDestroyed() {
            interceptor.Invoke("slotManagedTopLevelWidgetDestroyed", "slotManagedTopLevelWidgetDestroyed()", typeof(void));
        }
        ~PartManager() {
            interceptor.Invoke("~PartManager", "~PartManager()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~PartManager", "~PartManager()", typeof(void));
        }
        protected new IPartManagerSignals Emit {
            get { return (IPartManagerSignals) Q_EMIT; }
        }
    }

    public interface IPartManagerSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when a new part has been added.
        /// </remarks>        <short>    Emitted when a new part has been added.</short>
        ///         <see> addPart</see>
        [Q_SIGNAL("void partAdded(KParts::Part*)")]
        void PartAdded(KParts.Part part);
        /// <remarks>
        ///  Emitted when a part has been removed.
        /// </remarks>        <short>    Emitted when a part has been removed.</short>
        ///         <see> removePart</see>
        [Q_SIGNAL("void partRemoved(KParts::Part*)")]
        void PartRemoved(KParts.Part part);
        /// <remarks>
        ///  Emitted when the active part has changed.
        /// </remarks>        <short>    Emitted when the active part has changed.</short>
        ///         <see> setActivePart</see>
        [Q_SIGNAL("void activePartChanged(KParts::Part*)")]
        void ActivePartChanged(KParts.Part newPart);
    }
}
