# Find OpenSync
#
#  OPENSYNC_FOUND - system has OpenSync
#  OPENSYNC_INCLUDE_DIRS - the OpenSync include directory
#  OPENSYNC_LDFLAGS - The libraries needed to use OpenSync

INCLUDE(FindPkgConfig)

if (OPENSYNC_INCLUDE_DIRS AND OPENSYNC_LDFLAGS)

  # in cache already
  SET(OPENSYNC_FOUND TRUE)

else (OPENSYNC_INCLUDE_DIRS AND OPENSYNC_LDFLAGS)

  SET(OPENSYNC_FOUND FALSE)
  IF (NOT WIN32)
    # use pkg-config to get the directories and then use these values
    # in the FIND_PATH() and FIND_LIBRARY() calls
    PKG_CHECK_MODULES(OPENSYNC opensync-1.0>=0.33)
  ENDIF(NOT WIN32)

  include(FindPackageHandleStandardArgs)
  FIND_PACKAGE_HANDLE_STANDARD_ARGS(OPENSYNC DEFAULT_MSG OPENSYNC_LDFLAGS OPENSYNC_INCLUDE_DIRS)

  MARK_AS_ADVANCED(OPENSYNC_INCLUDE_DIRS OPENSYNC_LDFLAGS)

endif (OPENSYNC_INCLUDE_DIRS AND OPENSYNC_LDFLAGS)
