/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001-2006 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmtexturemapedit.h"
#include "pmtexturemap.h"
#include "pmlineedits.h"

#include <qlayout.h>
#include <qlabel.h>
#include <QVBoxLayout>
#include <QList>
#include <QHBoxLayout>
#include <klocale.h>
#include <kmessagebox.h>


PMTextureMapEdit::PMTextureMapEdit( QWidget* parent )
      : Base( parent )
{
   m_pDisplayedObject = 0;
   m_numValues = 0;
}

void PMTextureMapEdit::createTopWidgets( )
{
   Base::createTopWidgets( );
   QBoxLayout* tl = topLayout( );
   tl->addWidget( new QLabel( i18n( "Map values:" ), this ) );
   m_pNoChildLabel = new QLabel( i18n( "(No Child Objects)" ), this );
   m_pPureLinkLabel = new QLabel( i18n( "(Pure Link)" ), this );
   tl->addWidget( m_pNoChildLabel );
   tl->addWidget( m_pPureLinkLabel );
   QHBoxLayout* hl = new QHBoxLayout( );
   tl->addLayout( hl );
   m_pEditLayout = new QVBoxLayout( );
   hl->addLayout( m_pEditLayout );
   hl->addStretch( 1 );
}

void PMTextureMapEdit::displayObject( PMObject* o )
{
   QString str;

   if( o->isA( "TextureMapBase" ) )
   {
      bool readOnly = o->isReadOnly( );
      m_pDisplayedObject = ( PMTextureMapBase* ) o;
      QList<double> mv = m_pDisplayedObject->mapValues( );
      QList<double>::Iterator vit = mv.begin( );
      QList<PMFloatEdit*>::Iterator eit = m_edits.begin( );
      PMFloatEdit* edit;
		int i;

      m_numValues = mv.count();
		if( m_edits.count( ) < mv.count( ) )
		{
			for( i = m_edits.count( ); i < mv.count( ); i++ )
			{
            edit = new PMFloatEdit( this );
            m_pEditLayout->addWidget( edit );
            m_edits.append( edit );
            edit->setValidation( true, 0.0, true, 1.0 );
            connect( edit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
			}
		}
		if( m_edits.count( ) > mv.count( ) )
			for( i = mv.count( ); i < m_edits.count( ); i++ )
				m_edits[i]->hide( );

      for( i = 0; vit != mv.end( ); ++vit, i++ )
      {
			m_edits[i]->setValue( *vit );
			m_edits[i]->show( );
			m_edits[i]->setReadOnly( readOnly );
		}
      if( m_numValues == 0 )
      {
         if( o->linkedObject( ) )
         {
            m_pPureLinkLabel->show( );
            m_pNoChildLabel->hide( );
         }
         else
         {
            m_pPureLinkLabel->hide( );
            m_pNoChildLabel->show( );
         }
      }
      else
      {
         m_pNoChildLabel->hide( );
         m_pPureLinkLabel->hide( );
      }
   }
   else
      kError( PMArea ) << "PMTextureMapEdit: Can't display object\n";
   Base::displayObject( o );
   enableLinkEdit( m_numValues == 0 );
}

void PMTextureMapEdit::saveContents( )
{
   if( m_pDisplayedObject )
   {
      if( m_numValues > 0 )
      {
         QList<PMFloatEdit*>::Iterator it;
         int i = 0;
         QList<double> values;
         
         for( it = m_edits.begin( ); ( i < m_numValues ) && it != m_edits.end( ); ++i, ++it )
            values.append( ( *it )->value( ) );
         m_pDisplayedObject->setMapValues( values );
      }
      Base::saveContents( );
   }
}

bool PMTextureMapEdit::isDataValid( )
{
	QList<PMFloatEdit*>::Iterator it;
   int i = 0;
   double last = 0.0;

	for( it = m_edits.begin( ); ( i < m_numValues ) && it != m_edits.end( ); ++i, ++it )
   {
      if( !( *it )->isDataValid( ) )
         return false;
      if( ( *it )->value( ) < last )
      {
         KMessageBox::error( this, i18n( "The map values have to be increasing." ),
                             i18n( "Error" ) );
         ( *it )->setFocus( );
         return false;
      }
      last = ( *it )->value( );
   }
   return Base::isDataValid( );
}

#include "pmtexturemapedit.moc"
