import org.kde.qt.*;

public class Tut10 extends QWidget {
	public Tut10() {
		QPushButton quit = new QPushButton("&Quit", this, "quit");
		quit.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), qApp(), SLOT("quit()"));

		LCDRange angle = new LCDRange(this, "angle");
		angle.setRange(5, 70);

		LCDRange force = new LCDRange(this, "force");
		force.setRange(10, 50);

		CannonField cannonField = new CannonField(this, "cannonField");

		connect(angle, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setAngle(int)"));
		connect(cannonField, SIGNAL("angleChanged(int)"),
						angle, SLOT("setValue(int)"));

		connect(force, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setForce(int)"));
		connect(cannonField, SIGNAL("forceChanged(int)"),
						force, SLOT("setValue(int)"));

		QGridLayout grid = new QGridLayout(this, 2, 2, 10, -1, null);
		grid.addWidget(quit, 0, 0);
		grid.addWidget(cannonField, 1, 1);
		grid.setColStretch(1, 10);

		QVBoxLayout leftBox = new QVBoxLayout();
		grid.addLayout(leftBox, 1, 0);
		leftBox.addWidget(angle);
		leftBox.addWidget(force);

		angle.setValue(60);
		force.setValue(25);
		angle.setFocus();
	}
	
	public static void main(String[] args) {
		QApplication.setColorSpec(QApplication.CustomColor);
		QApplication a = new QApplication(args);
		Tut10 w = new Tut10();
		w.setGeometry( 100, 100, 500, 355 );
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.kde.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
