// QtSignalMap.cs - Hashtable wrapper for prettier code.
//
// Copyright (C) 2002  Nick Zigarovich (nick@chemlab.org)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// NOTES
// o By inheriting from QObject, we can use the child tracking features to
//   ensure that instances of signal maps are deleted by their parents when
//   the parent Dispose()es.
//
// FIXME
// o Override Dispose() and make sure everything gets cleaned up on deletion.

namespace Qt {
	using System;
	using System.Collections;
	using Qt;

	internal class QtSignalMap: QtSupport {
		private Hashtable signalMap;
		private string name;

		public string Name {
			get { return name; }
		}

		public QtSignalMap (QObject parent): this (parent, "QtSignalMap") {}

		public QtSignalMap (QObject parent, string name): base (QNull.Instance)
		{
			this.name = name;
			signalMap = new Hashtable ();
		}

		internal override void Delete () {}

		public void Add (QtSignal signal)
		{
			signalMap[signal.Identifier] = signal;
		}

		public QtSignal Remove (string name)
		{
			QtSignal ret = signalMap[name] as QtSignal;
			signalMap.Remove (name);
			return ret;
		}

		public bool Contains (string name)
		{
			return signalMap.ContainsKey (name);
		}

		public QtSignal this[string idx] {
			get {
				if (signalMap.ContainsKey (idx))
					return signalMap[idx] as QtSignal;
				else
					return null;
			}

			set { signalMap[idx] = value; }
		}

		public IDictionaryEnumerator GetEnumerator ()
		{
			return signalMap.GetEnumerator ();
		}

		public void DumpMap()
		{
			if (signalMap.Count == 0) {
				ErrMsg ("** {0}: No signals to dump.", name);
				ErrMsg ("");
			}
			else {
				IDictionaryEnumerator ide = signalMap.GetEnumerator();

				while (ide.MoveNext ()) {
					(ide.Value as QtSignal).DumpConnections ();
					ErrMsg ("");
				}
			}
		}
	}
}
