
#ifndef |NAMEBIG|_H
#define |NAMEBIG|_H

// include files for QT
#include <qstring.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>

#include <qextmdimainfrm.h>

// application specific includes
#include "|NAMELITTLE|view.h"
#include "|NAMELITTLE|doc.h"
#include "resource.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class |NAME|View is
  * created which creates your view.
  */

class |NAME| : public QextMdiMainFrm
{
  Q_OBJECT
  
public:
    /** construtor */
    |NAME|();
    /** destructor */
    ~|NAME|();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();
    /** this creates the toolbars. Change the toobar look and add new toolbars in this
     * function */
    void initToolBar();
    /** setup the statusbar */
    void initStatusBar();
    /** setup the document*/
    void initDoc();
    /** setup the mainview*/
    void initView();
  
    /** overloaded for Message box on last window exit */
    bool queryExit();
  
public slots:
  
    /** switch argument for Statusbar help entries on slot selection */
    void statusCallback(int id_);
    /** open a new application window */
  
    /** generate a new document in the actual view */
    void slotFileNew();
    /** open a document */
    void slotFileOpen();
    /** save a document */
    void slotFileSave();
    /** save a document under a different filename*/
    void slotFileSaveAs();
    /** close the actual file */
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** exits the application */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     * it from the document */
    void slotEditCut();
    /** put the marked text/object into the clipboard*/
    void slotEditCopy();
    /** paste the clipboard into the document*/
    void slotEditPaste();
    /** toggle the toolbar*/
    void slotViewToolBar();
    /** toggle the statusbar*/
    void slotViewStatusBar();
    /** toggle the taskbar*/
    void slotViewTaskBar();

    /** shows an about dlg*/
    void slotHelpAbout();
  
    /** change the status message of the whole statusbar temporary */
    void slotStatusHelpMsg(const QString &text);
  
   /** undocks all view windows (unix-like) */
   virtual void switchToToplevelMode();
   /** docks all view windows (Windows-like) */
   virtual void switchToChildframeMode();

protected: // Protected methods
   /** just fits the system menu button position to the menu position */
   virtual void resizeEvent ( QResizeEvent * );

private:

   /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class.
    */
   |NAME|View *view;
   /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
   |NAME|Doc *doc;
  
   /** file_menu contains all items of the menubar entry "File" */
   QPopupMenu *fileMenu;
   /** edit_menu contains all items of the menubar entry "Edit" */
   QPopupMenu *editMenu;
   /** view_menu contains all items of the menubar entry "View" */
   QPopupMenu *viewMenu;
   /** view_menu contains all items of the menubar entry "Help" */
   QPopupMenu *helpMenu;
  
   QToolBar *fileToolbar;
	int m_currentNumber;	// view number
};
#endif

