/*
 * translate.c - simple bindings for various disk related functions.
 * blatently stolen from anaconda/isys/isys.c
 *
 * Copyright 1999-2002 Red Hat, Inc.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <libintl.h>

#include <Python.h>


static PyObject * py_bind_textdomain_codeset(PyObject * o, PyObject * args);


static PyMethodDef translateModuleMethods[] = {
    { "bind_textdomain_codeset", (PyCFunction) py_bind_textdomain_codeset,
      METH_VARARGS, NULL},
    { NULL }
};



static PyObject *
py_bind_textdomain_codeset(PyObject * o, PyObject * args) {
    char *domain, *codeset, *ret;
	
    if (!PyArg_ParseTuple(args, "ss", &domain, &codeset))
	return NULL;

    ret = bind_textdomain_codeset(domain, codeset);

    if (ret)
	return PyString_FromString(ret);

    PyErr_SetFromErrno(PyExc_SystemError);
    return NULL;
}


void init_translate(void) {
    PyObject * m, * d;

    m = Py_InitModule("_translate", translateModuleMethods);
    d = PyModule_GetDict(m);
}
