#!/usr/bin/python

"""Test suite for rhpl.Conf"""

## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Harald Hoyer <harald@redhat.com>

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys
sys.path.append("../")

import unittest
import Conf
import os

## class TestTemplate(unittest.TestCase):
##     def setUp(self):
##         """Set up the test environment"""
##         pass
    
##     def tearDown(self):
##         """Clean up the test environment"""
##         pass

ShellTestFile = """
# Please read /usr/share/doc/initscripts-*/sysconfig.txt
# for the documentation of these parameters.
USERCTL=yes
PEERDNS=yes
ONBOOT=no
TYPE=ISDN
DEVICE=ippp0
BOOTPROTO=dialup
DEFROUTE=yes
PERSIST=off
SECURE=off
BUNDLING=off
HUPTIMEOUT=600
DIALMODE=manual
ENCAP=syncppp
USER=Arcor
PHONE_OUT=0192070
AUTH='+pap -chap'
PROVIDER=Arcor
DEMAND=no
CALLBACK=off
CCP=off
PC=off
AC=off
BSDCOMP=off
VJ=off
VJCCOMP=off"""

class TestConf1(unittest.TestCase):    
    def setUp(self):
        """Set up the test environment"""
        file = open("test.conf", "w")
        file.write(ShellTestFile)
        file.close()
        pass
    
    def tearDown(self):
        """Clean up the test environment"""
        os.unlink("test.conf")
        pass

    def testLoad(self):        
        """Test the loading of a sample config file"""
        import string
        conf = Conf.Conf("test.conf")
        lines = string.split(ShellTestFile, '\n')
        numlines = len(lines)
        
        self.assert_(len(conf.lines) == numlines,
                     "No lines after loading %d != %d" % \
                     (len(conf.lines), numlines))

## class TestConf2(unittest.TestCase):    
##     def setUp(self):
##         """Set up the test environment"""
##         file = open("test.conf", "w")
##         file.write(ShellTestFile)
##         file.close()
##         self.conf = Conf.Conf("test.conf")
    
##     def tearDown(self):
##         """Clean up the test environment"""
##         os.unlink("test.conf")

##     def test1(self):        
##         pass
        
   
class TestConfShellVar(unittest.TestCase): pass
class TestConfShellVarClone(unittest.TestCase): pass
class TestConfESNetwork(unittest.TestCase): pass


HostsTestFile = """
# Do not remove the following line, or various programs
# that require network functionality will fail.
127.0.0.1	localhost.localdomain	localhost
# comment 1
127.0.0.1 	t
# comment 2
127.0.0.2 	test test1 test2
# comment 3
127.0.0.3 	t
"""
HostsNum = 4

class TestConfEHosts(unittest.TestCase):    
    def setUp(self):
        """Set up the test environment"""
        file = open("test.conf", "w")
        file.write(HostsTestFile)
        file.close()
        pass
    
    def tearDown(self):
        """Clean up the test environment"""
        os.unlink("test.conf")
        pass

    def test00Load(self):        
        """Test the loading of a sample hosts config file"""
        conf = Conf.ConfEHosts(filename = "test.conf")
        conf.read()

        # keys handling seems to be different
        self.assert_(len(conf.keys()) == HostsNum,
                     "Does not have %d keys! %d != %d" % (HostsNum,
                                                          len(conf.keys()),
                                                          HostsNum))

        assert conf["127.0.0.1"][0] != 'localhost.localdomain'
        assert conf["127.0.0.1"][0] == 't'
        assert conf["127.0.0.1"][1] == []
        assert len(conf["127.0.0.1"]) == 2
        assert conf["127.0.0.2"][0] == 'test'
        assert conf["127.0.0.2"][1][0] == 'test1'
        assert conf["127.0.0.2"][1][1] == 'test2'
        assert conf["127.0.0.3"][0] == 't'
        

class TestConfFHosts(unittest.TestCase):
    def setUp(self):
        """ConfFHosts: Set up the test environment"""
        file = open("test.conf", "w")
        file.write(HostsTestFile)
        file.close()
        pass
    
    def tearDown(self):
        """ConfFHosts: Clean up the test environment"""
        os.unlink("test.conf")
        pass

    def test00Load(self):        
        """ConfFHosts: Test the loading of a sample config file"""
        conf = Conf.ConfFHosts("test.conf")
        conf.read()

        # keys handling seems to be different
        self.assert_(len(conf.keys()) == HostsNum,
                     "Does not have %d keys! %d != %d" % (HostsNum,
                                                          len(conf.keys()),
                                                          HostsNum))

        assert conf["t"][0] != '127.0.0.1'
        assert conf["test"][0] == '127.0.0.2'
        assert conf["test"][1][0] == 'test1'
        assert conf["test"][1][1] == 'test2'
        assert conf["t"][0] == '127.0.0.3'
        assert conf["t"][1] == []
        assert len(conf["t"]) == 2
        
    def test01Modify(self):
        """ConfFHosts: Test the modifying methodes of ConfFHosts"""
        conf = Conf.ConfFHosts("test.conf")
        conf["test"] = ('127.0.0.20', ["test10", "test20"])
        assert conf["test"][0] == '127.0.0.20'
        assert conf["test"][1][0] == 'test10'
        assert conf["test"][1][1] == 'test20'
        conf["test"] = '127.0.0.30'
        assert conf["test"][0] == '127.0.0.30'
        assert conf["test"][1] == []
        conf["test"] = ('127.0.0.2', ("test1", "test2"))
        assert conf["test"][0] == '127.0.0.2'
        assert conf["test"][1][0] == 'test1'
        assert conf["test"][1][1] == 'test2'

    def test02Save(self):
        """ConfFHosts: Test the save() method of ConfFHosts"""
        conf = Conf.ConfFHosts("test.conf")
        conf.read()
        conf['test'] = ("127.0.0.2", ("testalias",))
        conf.write()
        file = open("test.conf", "r")
        lines = file.readlines()
        file.close()
        for line in lines:
            if line[:9] == "127.0.0.2":
                break
            prevline = line

        assert prevline[:11] == "# comment 2"
                
class TestConfEResolv(unittest.TestCase): pass
class TestConfESStaticRoutes(unittest.TestCase): pass
class TestConfChat(unittest.TestCase): pass
class TestConfChatFile(unittest.TestCase): pass
class TestConfChatFileClone(unittest.TestCase): pass
class TestConfDIP(unittest.TestCase): pass
class TestConfModules(unittest.TestCase): pass
class TestConfModInfo(unittest.TestCase): pass
class TestConfPw(unittest.TestCase): pass
class TestConfPwO(unittest.TestCase): pass
class TestConfPasswd(unittest.TestCase): pass
class TestConfShadow(unittest.TestCase): pass
class TestConfGroup(unittest.TestCase): pass
class TestConfSysctl(unittest.TestCase): pass

if __name__ == '__main__':
    unittest.main()
        
__author__ = "Harald Hoyer <harald@redhat.com>"
__date__ = "$Date$"
__version__ = "$Revision$"
