/* wptJPG.h - Routins four showing JPG picture files
 *	Copyright (C) 2001 Dr.Yovav Gad <Sources@SuperMain.com>
 *	Copyright (C) 2005 Timo Schulz
 *
 * This file is part of PTD.
 *
 * PTD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * PTD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PTD; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#ifndef WPT_JPG_H
#define WPT_JPG_H 1

class CJPG
{
public:
    CJPG ();	
    virtual ~CJPG ();

    void FreePictureData ();
    BOOL Load (LPCSTR sFilePathName);
    BOOL LoadPictureData (BYTE* pBuffer, int nSize);
    BOOL Show (HDC pDC, POINT *LeftTop, POINT *WidthHeight, int MagnifyX, int MagnifyY);
    BOOL UpdateSizeOnDC (HDC pDC);

    IPicture* m_IPicture; /* Same As LPPICTURE (typedef IPicture __RPC_FAR *LPPICTURE)*/

    LONG      m_Height; /* Height (In Pixels Ignor What Current Device Context Uses) */
    LONG      m_Weight; /* Size Of The Image Object In Bytes (File OR Resource) */
    LONG      m_Width;  /* Width (In Pixels Ignor What Current Device Context Uses) */
};

#endif /*WPT_JPG_H*/