/* w32-glibc.c - Missing W32 stuff from the GLIBC  
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This programis distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>

/*********************************************
 ********** missing string functions *********
 *********************************************/
#ifndef HAVE_STPCPY
char *
stpcpy (char *a, const char *b)
{
    while( *b )
	*a++ = *b++;
    *a = 0;
    
    return a;
}
#endif

#ifndef HAVE_STRSEP
/* code taken from glibc-2.2.1/sysdeps/generic/strsep.c */
char *
strsep (char **stringp, const char *delim)
{
    char *begin, *end;
    begin = *stringp;

    if (begin == NULL)
        return NULL;

    /* A frequent case is when the delimiter string contains only one
       character.  Here we don't need to call the expensive `strpbrk'
       function and instead work using `strchr'.  */
    if (delim[0] == '\0' || delim[1] == '\0') {
        char ch = delim[0];
        if (ch == '\0')
            end = NULL;
        else {
            if (*begin == ch)
                end = begin;                         
            else if (*begin == '\0')
                end = NULL;
            else
                end = strchr (begin + 1, ch);
        }  
    }
    else /* Find the end of the token.  */
        end = strpbrk (begin, delim);
    if ( end ){
        /* Terminate the token and set *STRINGP past NUL character.  */
        *end++ = '\0';
        *stringp = end;
    }
    else
        /* No more delimiters; this is the last token.  */
        *stringp = NULL;

    return begin;
}

const char *
memistr( const char *buf, size_t buflen, const char *sub )
{
    const char *t, *s ;
    size_t n;

    for( t=buf, n=buflen, s=sub ; n ; t++, n-- ) {
	if( toupper(*t) == toupper(*s) ) {
	    for( buf=t++, buflen = n--, s++;
		 n && toupper(*t) == toupper(*s); t++, s++, n-- )
		;
	    if( !*s )
		return buf;
	    t = buf; n = buflen; s = sub ;
	}
    }
    return NULL ;
} /* memistr */
#endif


FILE *
my_fopen (const char * fname, const char * mode)
{
    FILE * fp;
    char * p;

    if (*fname == '"') {
	p = calloc (1, strlen (fname));
	if (!p)
	    return NULL;
	memcpy (p, fname+1, strlen (fname) - 2);
    }
    else {
	p = strdup (fname);
	if (!p)
	    return NULL;
    }
    fp = fopen (p, mode);
    free (p);
    return fp;
}