/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.cipher;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Iterator;

public class Serpent
extends BaseCipher {
    private static final String NAME = "serpent";
    private static final int DEFAULT_KEY_SIZE = 32;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int ROUNDS = 32;
    private static final int PHI = -1640531527;
    private static final byte[] KAT_KEY = Util.toBytesFromString("008000000000000000000000000000000000000000000000");
    private static final byte[] KAT_CT = Util.toBytesFromString("5587B5BCB9EE5A28BA2BACC418005240");
    private static Boolean valid;

    public Serpent() {
        super(NAME, 16, 32);
    }

    private static final void transform(int[] x) {
        x[0] = x[0] << 13 | x[0] >>> 19;
        x[2] = x[2] << 3 | x[2] >>> 29;
        x[1] = x[1] ^ x[0] ^ x[2];
        x[3] = x[3] ^ x[2] ^ x[0] << 3;
        x[1] = x[1] << 1 | x[1] >>> 31;
        x[3] = x[3] << 7 | x[3] >>> 25;
        x[0] = x[0] ^ x[1] ^ x[3];
        x[2] = x[2] ^ x[3] ^ x[1] << 7;
        x[0] = x[0] << 5 | x[0] >>> 27;
        x[2] = x[2] << 22 | x[2] >>> 10;
    }

    private static final void transformInv(int[] x, int[] key, int off) {
        x[0] = x[0] ^ key[off++];
        x[1] = x[1] ^ key[off++];
        x[2] = x[2] ^ key[off++];
        x[3] = x[3] ^ key[off++];
        x[2] = x[2] >>> 22 | x[2] << 10;
        x[0] = x[0] >>> 5 | x[0] << 27;
        x[2] = x[2] ^ x[3] ^ x[1] << 7;
        x[0] = x[0] ^ x[1] ^ x[3];
        x[3] = x[3] >>> 7 | x[3] << 25;
        x[1] = x[1] >>> 1 | x[1] << 31;
        x[3] = x[3] ^ x[2] ^ x[0] << 3;
        x[1] = x[1] ^ x[0] ^ x[2];
        x[2] = x[2] >>> 3 | x[2] << 29;
        x[0] = x[0] >>> 13 | x[0] << 19;
    }

    private static final void sbox0(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r1 ^ r2;
        r1 = r1 & (r3 ^= r0) ^ r0;
        r0 = (r0 | r3) ^ r4;
        r4 ^= r3;
        r3 ^= r2;
        r2 = (r2 | r1) ^ r4;
        r4 = ~r4 | r1;
        r1 ^= r3 ^ r4;
        w[off] = r1 ^ (r3 |= r0);
        w[off + 1] = r4 ^ r3;
        w[off + 2] = r2;
        w[off + 3] = r0;
    }

    private static final void sboxI0(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r1;
        r1 = (r1 | r0) ^ (r2 ^= 0xFFFFFFFF);
        r2 |= (r4 ^= 0xFFFFFFFF);
        r2 ^= (r0 ^= r4);
        r4 ^= (r0 &= r3);
        r0 = (r0 | (r1 ^= r3)) ^ r2;
        r3 = r3 ^ r4 ^ r0 ^ r1;
        r2 = (r2 ^ r1) & r3;
        w[off] = r0;
        w[off + 1] = r4 ^ r2;
        w[off + 2] = r1;
        w[off + 3] = r3;
    }

    private static final void sbox1(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r0 ^= 0xFFFFFFFF;
        r2 ^= 0xFFFFFFFF;
        r0 |= r3;
        r3 ^= (r2 ^= (r0 &= r1));
        r1 ^= r0;
        r0 ^= r4;
        r4 |= r1;
        r2 = (r2 | r0) & r4;
        w[off] = r2;
        w[off + 1] = (r0 ^= (r1 ^= r3)) & r2 ^ r4;
        w[off + 2] = r3;
        w[off + 3] = r1 & r2 ^ r0;
    }

    private static final void sboxI1(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r1;
        r1 ^= r3;
        r3 = r3 & r1 ^ r0;
        r4 ^= r2;
        r0 = (r0 | r1) ^ r4 | (r2 ^= r3);
        r1 = (r1 | r3) ^ (r0 ^= (r1 ^= r3));
        w[off] = r4 = ~r4 ^ r1;
        w[off + 1] = r0;
        w[off + 2] = r3 ^ ((r1 | r0) ^ r0 | r4);
        w[off + 3] = r2;
    }

    private static final void sbox2(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r0;
        r0 = r0 & r2 ^ r3;
        r2 = r2 ^ r1 ^ r0;
        r3 = (r3 | r4) ^ r1;
        r1 = r3;
        r3 = (r3 | (r4 ^= r2)) ^ r0;
        w[off] = r2;
        w[off + 1] = r3;
        w[off + 2] = r1 ^ r3 ^ (r4 ^= (r0 &= r1));
        w[off + 3] = ~r4;
    }

    private static final void sboxI2(int r0, int r1, int r2, int r3, int[] w, int off) {
        r2 ^= r3;
        int r4 = r3 ^= r0;
        r3 = r3 & r2 ^ r1;
        r1 = (r1 | r2) ^ r4;
        r4 &= r3;
        r4 = r4 & r0 ^ (r2 ^= r3);
        r2 = (r2 & r1 | r0) ^ (r3 ^= 0xFFFFFFFF);
        r0 = (r0 ^ r3) & r1;
        w[off] = r1;
        w[off + 1] = r4;
        w[off + 2] = r2;
        w[off + 3] = r3 ^ r4 ^ r0;
    }

    private static final void sbox3(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r0;
        r0 |= r3;
        r3 ^= r1;
        r1 &= r4;
        r4 = r4 ^ r2 | r1;
        r2 ^= r3;
        r3 = r3 & r0 ^ r4;
        r4 = r4 & (r0 ^= r1) ^ r2;
        r1 = (r1 ^ r3 | r0) ^ r2;
        w[off] = (r1 | r3) ^ (r0 ^= r3);
        w[off + 1] = r1;
        w[off + 2] = r3;
        w[off + 3] = r4;
    }

    private static final void sboxI3(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r2;
        r4 = r4 & r2 ^ (r0 ^= (r2 ^= r1));
        r0 &= r1;
        r1 ^= r3;
        r0 ^= r3;
        r3 = r3 & (r2 ^= (r3 |= r4)) ^ (r1 ^= r4);
        r1 = (r1 ^ r0 | r2) ^ r4;
        w[off] = r2;
        w[off + 1] = r1;
        w[off + 2] = r3;
        w[off + 3] = r0 ^ r3 ^ r1;
    }

    private static final void sbox4(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r1 ^= r3;
        r1 = r1 & (r3 ^= r0) ^ (r2 ^= (r3 ^= 0xFFFFFFFF));
        r2 = r2 & r4 ^ (r0 ^= (r4 ^= r3));
        r4 = (r4 | r1) ^ r0;
        w[off] = r1;
        w[off + 1] = r4 ^ r2 & (r3 ^= (r0 &= r1));
        w[off + 2] = ~((r0 | r3) ^ r2);
        w[off + 3] = r3;
    }

    private static final void sboxI4(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r2;
        r2 = r2 & r3 ^ r1;
        r1 = (r1 | r3) & r0;
        r4 = r4 ^ r2 ^ r1;
        r1 &= r2;
        r3 = r3 & (r0 ^= 0xFFFFFFFF) ^ r2;
        w[off] = r0 ^= (r1 ^= (r3 ^= r4));
        w[off + 1] = (r3 ^= r0) ^ r0;
        w[off + 2] = (r2 & r0 ^ r4 | r3) ^ r1;
        w[off + 3] = r4;
    }

    private static final void sbox5(int r0, int r1, int r2, int r3, int[] w, int off) {
        r0 ^= r1;
        int r4 = r1 ^= r3;
        r1 &= r0;
        r2 |= r4;
        r4 ^= r3;
        r3 = r3 & (r1 ^= (r2 ^= (r3 ^= 0xFFFFFFFF))) ^ r0;
        r4 = r4 ^ r1 ^ r2;
        w[off] = r1;
        w[off + 1] = r3;
        w[off + 2] = r0 & r3 ^ r4;
        w[off + 3] = ~(r2 ^ r0) ^ (r4 | r3);
    }

    private static final void sboxI5(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r3;
        r3 = (r3 | r0) ^ (r2 ^= (r1 ^= 0xFFFFFFFF));
        r2 = (r2 | r1) & r0 ^ (r4 ^= r3);
        r4 = (r4 | r0) ^ r1 ^ r2;
        r1 = r1 & r2 ^ r3;
        r3 &= r4;
        w[off] = r1;
        w[off + 1] = ~(r4 ^= r1);
        w[off + 2] = r3 ^ r4 ^ r0;
        w[off + 3] = r2;
    }

    private static final void sbox6(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r3;
        r3 = r3 & r0 ^ (r2 ^= 0xFFFFFFFF);
        r2 = (r2 | r4) ^ (r0 ^= r4);
        r4 ^= (r0 |= (r1 ^= r3));
        r0 = (r0 | r3) ^ (r2 ^= r1);
        r4 = r4 ^ r3 ^ r0;
        w[off] = r0;
        w[off + 1] = r1;
        w[off + 2] = r4;
        w[off + 3] = r2 & r4 ^ ~r3;
    }

    private static final void sboxI6(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r2;
        r0 ^= r2;
        r2 &= r0;
        r4 ^= r3;
        r2 = ~r2 ^ (r3 ^= r1);
        r4 |= r0;
        r3 ^= r4;
        r4 ^= r1;
        r1 = r1 & r3 ^ (r0 ^= r2);
        r0 = r0 ^ r3 | r2;
        w[off] = r1;
        w[off + 1] = r2;
        w[off + 2] = r4 ^ r0;
        w[off + 3] = r3 ^ r1;
    }

    private static final void sbox7(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r1;
        r1 = (r1 | r2) ^ r3;
        r4 ^= r2;
        r3 = (r3 | r4) & r0;
        r4 ^= (r2 ^= r1);
        r3 ^= r1;
        r1 = (r1 | r4) ^ r0;
        r0 = (r0 | r4) ^ r2;
        w[off] = r4 ^ (~(r2 ^= (r1 ^= r4)) | r0);
        w[off + 1] = r3;
        w[off + 2] = r1 & r0 ^ r4;
        w[off + 3] = r0;
    }

    private static final void sboxI7(int r0, int r1, int r2, int r3, int[] w, int off) {
        int r4 = r2;
        r2 = ~(r2 ^ r0);
        r0 &= r3;
        r4 |= r3;
        r3 ^= r1;
        r1 |= r0;
        r0 ^= r2;
        r1 ^= (r2 &= r4);
        r2 ^= r0;
        r0 = (r0 | r2) ^ (r3 &= r4);
        w[off] = r3 ^ (r4 ^= r1) ^ r2;
        w[off + 1] = r0;
        w[off + 2] = r1;
        w[off + 3] = (r4 | r0) ^ r2;
    }

    public Object clone() {
        return new Serpent();
    }

    public Iterator blockSizes() {
        return Collections.singleton(new Integer(16)).iterator();
    }

    public Iterator keySizes() {
        return new Iterator(){
            int i = 0;
            Integer[] keySizes = new Integer[]{new Integer(16), new Integer(24), new Integer(32)};

            public boolean hasNext() {
                return this.i < this.keySizes.length;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.keySizes[this.i++];
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object makeKey(byte[] key, int blockSize) throws InvalidKeyException {
        int t;
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new InvalidKeyException("Key length is not 16, 24, or 32 bytes");
        }
        int[] w = new int[132];
        int i = 0;
        int j = key.length - 4;
        while (i < 8 && j >= 0) {
            w[i] = (key[j] & 0xFF) << 24 | (key[j + 1] & 0xFF) << 16 | (key[j + 2] & 0xFF) << 8 | key[j + 3] & 0xFF;
            j -= 4;
            ++i;
        }
        if (i != 8) {
            w[i] = 1;
        }
        i = 8;
        while (i < 16) {
            t = w[i - 8] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ i - 8;
            w[i] = t << 11 | t >>> 21;
            ++i;
        }
        i = 0;
        while (i < 8) {
            w[i] = w[i + 8];
            ++i;
        }
        i = 8;
        while (i < w.length) {
            t = w[i - 8] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ i;
            w[i] = t << 11 | t >>> 21;
            ++i;
        }
        Serpent.sbox3(w[0], w[1], w[2], w[3], w, 0);
        Serpent.sbox2(w[4], w[5], w[6], w[7], w, 4);
        Serpent.sbox1(w[8], w[9], w[10], w[11], w, 8);
        Serpent.sbox0(w[12], w[13], w[14], w[15], w, 12);
        Serpent.sbox7(w[16], w[17], w[18], w[19], w, 16);
        Serpent.sbox6(w[20], w[21], w[22], w[23], w, 20);
        Serpent.sbox5(w[24], w[25], w[26], w[27], w, 24);
        Serpent.sbox4(w[28], w[29], w[30], w[31], w, 28);
        Serpent.sbox3(w[32], w[33], w[34], w[35], w, 32);
        Serpent.sbox2(w[36], w[37], w[38], w[39], w, 36);
        Serpent.sbox1(w[40], w[41], w[42], w[43], w, 40);
        Serpent.sbox0(w[44], w[45], w[46], w[47], w, 44);
        Serpent.sbox7(w[48], w[49], w[50], w[51], w, 48);
        Serpent.sbox6(w[52], w[53], w[54], w[55], w, 52);
        Serpent.sbox5(w[56], w[57], w[58], w[59], w, 56);
        Serpent.sbox4(w[60], w[61], w[62], w[63], w, 60);
        Serpent.sbox3(w[64], w[65], w[66], w[67], w, 64);
        Serpent.sbox2(w[68], w[69], w[70], w[71], w, 68);
        Serpent.sbox1(w[72], w[73], w[74], w[75], w, 72);
        Serpent.sbox0(w[76], w[77], w[78], w[79], w, 76);
        Serpent.sbox7(w[80], w[81], w[82], w[83], w, 80);
        Serpent.sbox6(w[84], w[85], w[86], w[87], w, 84);
        Serpent.sbox5(w[88], w[89], w[90], w[91], w, 88);
        Serpent.sbox4(w[92], w[93], w[94], w[95], w, 92);
        Serpent.sbox3(w[96], w[97], w[98], w[99], w, 96);
        Serpent.sbox2(w[100], w[101], w[102], w[103], w, 100);
        Serpent.sbox1(w[104], w[105], w[106], w[107], w, 104);
        Serpent.sbox0(w[108], w[109], w[110], w[111], w, 108);
        Serpent.sbox7(w[112], w[113], w[114], w[115], w, 112);
        Serpent.sbox6(w[116], w[117], w[118], w[119], w, 116);
        Serpent.sbox5(w[120], w[121], w[122], w[123], w, 120);
        Serpent.sbox4(w[124], w[125], w[126], w[127], w, 124);
        Serpent.sbox3(w[128], w[129], w[130], w[131], w, 128);
        return w;
    }

    public void encrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        int[] key = (int[])K;
        int[] x = new int[4];
        x[3] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        x[2] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        x[1] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        x[0] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        Serpent.sbox0(key[0] ^ x[0], key[1] ^ x[1], key[2] ^ x[2], key[3] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox1(key[4] ^ x[0], key[5] ^ x[1], key[6] ^ x[2], key[7] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox2(key[8] ^ x[0], key[9] ^ x[1], key[10] ^ x[2], key[11] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox3(key[12] ^ x[0], key[13] ^ x[1], key[14] ^ x[2], key[15] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox4(key[16] ^ x[0], key[17] ^ x[1], key[18] ^ x[2], key[19] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox5(key[20] ^ x[0], key[21] ^ x[1], key[22] ^ x[2], key[23] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox6(key[24] ^ x[0], key[25] ^ x[1], key[26] ^ x[2], key[27] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox7(key[28] ^ x[0], key[29] ^ x[1], key[30] ^ x[2], key[31] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox0(key[32] ^ x[0], key[33] ^ x[1], key[34] ^ x[2], key[35] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox1(key[36] ^ x[0], key[37] ^ x[1], key[38] ^ x[2], key[39] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox2(key[40] ^ x[0], key[41] ^ x[1], key[42] ^ x[2], key[43] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox3(key[44] ^ x[0], key[45] ^ x[1], key[46] ^ x[2], key[47] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox4(key[48] ^ x[0], key[49] ^ x[1], key[50] ^ x[2], key[51] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox5(key[52] ^ x[0], key[53] ^ x[1], key[54] ^ x[2], key[55] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox6(key[56] ^ x[0], key[57] ^ x[1], key[58] ^ x[2], key[59] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox7(key[60] ^ x[0], key[61] ^ x[1], key[62] ^ x[2], key[63] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox0(key[64] ^ x[0], key[65] ^ x[1], key[66] ^ x[2], key[67] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox1(key[68] ^ x[0], key[69] ^ x[1], key[70] ^ x[2], key[71] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox2(key[72] ^ x[0], key[73] ^ x[1], key[74] ^ x[2], key[75] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox3(key[76] ^ x[0], key[77] ^ x[1], key[78] ^ x[2], key[79] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox4(key[80] ^ x[0], key[81] ^ x[1], key[82] ^ x[2], key[83] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox5(key[84] ^ x[0], key[85] ^ x[1], key[86] ^ x[2], key[87] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox6(key[88] ^ x[0], key[89] ^ x[1], key[90] ^ x[2], key[91] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox7(key[92] ^ x[0], key[93] ^ x[1], key[94] ^ x[2], key[95] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox0(key[96] ^ x[0], key[97] ^ x[1], key[98] ^ x[2], key[99] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox1(key[100] ^ x[0], key[101] ^ x[1], key[102] ^ x[2], key[103] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox2(key[104] ^ x[0], key[105] ^ x[1], key[106] ^ x[2], key[107] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox3(key[108] ^ x[0], key[109] ^ x[1], key[110] ^ x[2], key[111] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox4(key[112] ^ x[0], key[113] ^ x[1], key[114] ^ x[2], key[115] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox5(key[116] ^ x[0], key[117] ^ x[1], key[118] ^ x[2], key[119] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox6(key[120] ^ x[0], key[121] ^ x[1], key[122] ^ x[2], key[123] ^ x[3], x, 0);
        Serpent.transform(x);
        Serpent.sbox7(key[124] ^ x[0], key[125] ^ x[1], key[126] ^ x[2], key[127] ^ x[3], x, 0);
        x[0] = x[0] ^ key[128];
        x[1] = x[1] ^ key[129];
        x[2] = x[2] ^ key[130];
        x[3] = x[3] ^ key[131];
        int j = x.length - 1;
        while (j >= 0) {
            out[o++] = (byte)(x[j] >>> 24);
            out[o++] = (byte)(x[j] >>> 16);
            out[o++] = (byte)(x[j] >>> 8);
            out[o++] = (byte)x[j];
            --j;
        }
    }

    public void decrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        int[] key = (int[])K;
        int[] x = new int[4];
        x[3] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        x[2] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        x[1] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        x[0] = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        Serpent.sboxI7(key[128] ^ x[0], key[129] ^ x[1], key[130] ^ x[2], key[131] ^ x[3], x, 0);
        Serpent.transformInv(x, key, 124);
        Serpent.sboxI6(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 120);
        Serpent.sboxI5(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 116);
        Serpent.sboxI4(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 112);
        Serpent.sboxI3(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 108);
        Serpent.sboxI2(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 104);
        Serpent.sboxI1(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 100);
        Serpent.sboxI0(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 96);
        Serpent.sboxI7(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 92);
        Serpent.sboxI6(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 88);
        Serpent.sboxI5(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 84);
        Serpent.sboxI4(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 80);
        Serpent.sboxI3(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 76);
        Serpent.sboxI2(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 72);
        Serpent.sboxI1(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 68);
        Serpent.sboxI0(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 64);
        Serpent.sboxI7(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 60);
        Serpent.sboxI6(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 56);
        Serpent.sboxI5(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 52);
        Serpent.sboxI4(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 48);
        Serpent.sboxI3(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 44);
        Serpent.sboxI2(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 40);
        Serpent.sboxI1(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 36);
        Serpent.sboxI0(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 32);
        Serpent.sboxI7(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 28);
        Serpent.sboxI6(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 24);
        Serpent.sboxI5(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 20);
        Serpent.sboxI4(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 16);
        Serpent.sboxI3(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 12);
        Serpent.sboxI2(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 8);
        Serpent.sboxI1(x[0], x[1], x[2], x[3], x, 0);
        Serpent.transformInv(x, key, 4);
        Serpent.sboxI0(x[0], x[1], x[2], x[3], x, 0);
        x[0] = x[0] ^ key[0];
        x[1] = x[1] ^ key[1];
        x[2] = x[2] ^ key[2];
        x[3] = x[3] ^ key[3];
        int j = x.length - 1;
        while (j >= 0) {
            out[o++] = (byte)(x[j] >>> 24);
            out[o++] = (byte)(x[j] >>> 16);
            out[o++] = (byte)(x[j] >>> 8);
            out[o++] = (byte)x[j];
            --j;
        }
    }

    public boolean selfTest() {
        if (valid == null) {
            boolean result = super.selfTest();
            if (result) {
                result = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = new Boolean(result);
        }
        return valid;
    }
}

