/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorCache {
    public static final VectorCache theCache = new VectorCache(EDatabase.clientDatabase());
    private final EDatabase database;
    private final ArrayList<VectorCellGroup> cachedCells = new ArrayList();
    private final HashMap<CellId, List<VectorBase>> addPolyToCell = new HashMap();
    private final HashMap<CellId, List<VectorLine>> addInstToCell = new HashMap();
    private final ArrayList<VectorManhattanBuilder> boxBuilders = new ArrayList();
    private final ArrayList<VectorManhattanBuilder> pureBoxBuilders = new ArrayList();
    private VarContext varContext;
    private double curScale;
    private boolean clearFadeImages;
    private boolean clearCache;
    private final Point tempPt1 = new Point();
    private final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private EGraphics instanceGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private final EditWindow0 dummyWnd = new EditWindow0(){

        public VarContext getVarContext() {
            return VectorCache.this.varContext;
        }

        public double getScale() {
            return VectorCache.this.curScale;
        }
    };
    private static final Variable.Key NCCKEY = Variable.newKey("ATTR_NCC");
    private static final PrimitivePort busPinPort = Schematics.tech.busPinNode.getPort(0);
    public static Comparator<VectorBase> shapeByLayer = new Comparator<VectorBase>(){

        @Override
        public int compare(VectorBase vb1, VectorBase vb2) {
            Layer.Function fun;
            int level1 = 1000;
            int level2 = 1000;
            boolean isContact1 = false;
            boolean isContact2 = false;
            if (vb1.layer != null) {
                fun = vb1.layer.getFunction();
                level1 = fun.getLevel();
                isContact1 = fun.isContact();
            }
            if (vb2.layer != null) {
                fun = vb2.layer.getFunction();
                level2 = fun.getLevel();
                isContact2 = fun.isContact();
            }
            if (isContact1 != isContact2) {
                return isContact1 ? -1 : 1;
            }
            return level1 - level2;
        }
    };

    VectorCellGroup findCellGroup(CellId cellId) {
        int cellIndex = cellId.cellIndex;
        while (cellIndex >= this.cachedCells.size()) {
            this.cachedCells.add(null);
        }
        VectorCellGroup vcg = this.cachedCells.get(cellIndex);
        if (vcg == null) {
            vcg = new VectorCellGroup(cellId);
            this.cachedCells.set(cellIndex, vcg);
        }
        return vcg;
    }

    public VectorCache(EDatabase database) {
        this.database = database;
    }

    VectorCell findVectorCell(CellId cellId, Orientation orient) {
        VectorCellGroup vcg = this.findCellGroup(cellId);
        VectorCell vc = vcg.orientations.get(orient = orient.canonic());
        if (vc == null) {
            vc = new VectorCell(vcg, orient);
            vcg.orientations.put(orient, vc);
        }
        return vc;
    }

    VectorCell drawCell(Cell cell, Orientation prevTrans, VarContext context, double scale) {
        VectorCell vc = this.findVectorCell(cell.getId(), prevTrans);
        if (vc.vcg.isParameterized || !vc.valid) {
            this.varContext = vc.vcg.isParameterized ? context : null;
            this.curScale = scale;
            vc.init(cell);
        }
        return vc;
    }

    public void addBoxToCell(double lX, double lY, double hX, double hY, Layer layer, CellId cellId) {
        List<VectorBase> addToThisCell = this.addPolyToCell.get(cellId);
        if (addToThisCell == null) {
            addToThisCell = new ArrayList<VectorBase>();
            this.addPolyToCell.put(cellId, addToThisCell);
        }
        EGraphics graphics = null;
        if (layer != null) {
            graphics = layer.getGraphics();
        }
        VectorManhattan vm = new VectorManhattan(lX, lY, hX, hY, layer, graphics, false);
        addToThisCell.add(vm);
    }

    public void addInstanceToCell(double lX, double lY, double hX, double hY, CellId cellId) {
        List<VectorLine> addToThisCell = this.addInstToCell.get(cellId);
        if (addToThisCell == null) {
            addToThisCell = new ArrayList<VectorLine>();
            this.addInstToCell.put(cellId, addToThisCell);
        }
        addToThisCell.add(new VectorLine(lX, lY, hX, lY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(hX, lY, hX, hY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(hX, hY, lX, hY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(lX, hY, lX, lY, 0, null, this.instanceGraphics));
    }

    private static boolean isCellParameterized(CellBackup cellBackup) {
        Variable var;
        Iterator<Variable> vIt;
        Iterator<Variable> vIt2 = cellBackup.d.getVariables();
        while (vIt2.hasNext()) {
            Variable var2 = vIt2.next();
            if (!var2.getTextDescriptor().isParam() || var2.getKey() == NCCKEY) continue;
            return true;
        }
        for (ImmutableNodeInst n : cellBackup.nodes) {
            vIt = n.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (var.getCode() == AbstractTextDescriptor.Code.NONE) continue;
                return true;
            }
        }
        for (ImmutableArcInst a : cellBackup.arcs) {
            vIt = a.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (var.getCode() == AbstractTextDescriptor.Code.NONE) continue;
                return true;
            }
        }
        for (ImmutableExport e : cellBackup.exports) {
            if (e.originalPortId != busPinPort) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRedraw(Set<CellId> changedCells) {
        boolean clearFadeImages;
        boolean clearCache;
        VectorCache vectorCache = this;
        synchronized (vectorCache) {
            clearCache = this.clearCache;
            this.clearCache = false;
            clearFadeImages = this.clearFadeImages;
            this.clearFadeImages = false;
        }
        Snapshot snapshot = this.database.backup();
        int size = this.cachedCells.size();
        for (int cellIndex = 0; cellIndex < size; ++cellIndex) {
            VectorCellGroup vcg = this.cachedCells.get(cellIndex);
            if (vcg == null) continue;
            if (clearCache) {
                vcg.clear();
            }
            if (clearFadeImages) {
                for (VectorCell vc : vcg.orientations.values()) {
                    vc.fadeImageColors = null;
                    vc.fadeImage = false;
                }
            }
            vcg.updateBounds(snapshot);
            if (!changedCells.contains(vcg.cellId) && vcg.cellBackup == snapshot.getCell(cellIndex)) continue;
            this.cellChanged(vcg.cellId);
        }
    }

    private void cellChanged(CellId cellId) {
        Cell cell;
        VectorCellGroup vcg = null;
        if (cellId.cellIndex < this.cachedCells.size()) {
            vcg = this.cachedCells.get(cellId.cellIndex);
        }
        if ((cell = this.database.getCell(cellId)) != null && vcg != null && vcg.changedExports()) {
            vcg.updateExports();
            Iterator<CellUsage> it = cell.getUsagesOf();
            while (it.hasNext()) {
                CellUsage u = it.next();
                this.cellChanged(u.parentId);
            }
        }
        if (vcg != null) {
            vcg.clear();
        }
    }

    public synchronized void clearCache() {
        this.clearCache = true;
    }

    public synchronized void clearFadeImages() {
        this.clearFadeImages = true;
    }

    private static int databaseToGrid(double x) {
        double xg = x * 400.0;
        return (int)(xg >= 0.0 ? xg + 0.5 : xg - 0.5);
    }

    private void addBoxesFromBuilder(VectorCell vc, Technology tech, ArrayList<VectorManhattanBuilder> boxBuilders, boolean pureArray) {
        for (int layerIndex = 0; layerIndex < boxBuilders.size(); ++layerIndex) {
            VectorManhattanBuilder b = boxBuilders.get(layerIndex);
            if (b.size == 0) continue;
            Layer layer = tech.getLayer(layerIndex);
            VectorManhattan vm = new VectorManhattan(b.toArray(), layer, layer.getGraphics(), pureArray);
            vc.filledShapes.add(vm);
        }
    }

    private void drawNode(NodeInst ni, AffineTransform trans, VectorCell vc) {
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        if (ni.isCellInstance()) {
            PortInst pi;
            Cell subCell = (Cell)np;
            Point2D.Double ctrShift = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            localTrans.transform(ctrShift, ctrShift);
            VectorSubCell vsc = new VectorSubCell(ni, ctrShift);
            vc.subCells.add(vsc);
            Iterator<Object> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                pi = con.getPortInst();
                vsc.shownPorts.set(pi.getPortProto().getId().getChronIndex());
            }
            it = ni.getExports();
            while (it.hasNext()) {
                Export exp = (Export)it.next();
                pi = exp.getOriginalPort();
                vsc.shownPorts.set(pi.getPortProto().getId().getChronIndex());
            }
            int numPolys = ni.numDisplayableVariables(true);
            Poly[] polys = new Poly[numPolys];
            Rectangle2D rect = ni.getUntransformedBounds();
            ni.addDisplayableVariables(rect, polys, 0, this.dummyWnd, true);
            this.drawPolys(polys, localTrans, vc, false, 3, false);
        } else {
            PrimitiveNode prim = (PrimitiveNode)np;
            int textType = 3;
            if (prim == Generic.tech.invisiblePinNode) {
                textType = 5;
            }
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni, this.dummyWnd, this.varContext, false, false, null);
            boolean hideOnLowLevel = ni.isVisInside() || np == Generic.tech.cellCenterNode;
            boolean pureLayer = ni.getFunction() == PrimitiveNode.Function.NODE;
            this.drawPolys(polys, localTrans, vc, hideOnLowLevel, textType, pureLayer);
        }
        Iterator<Export> it = ni.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            Poly poly = e.getNamePoly();
            Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
            TextDescriptor descript = poly.getTextDescriptor();
            Poly.Type style = descript.getPos().getPolyType();
            style = Poly.rotateType(style, ni);
            VectorText vt = new VectorText(poly.getBounds2D(), style, descript, null, 2, e, null, null);
            vc.topOnlyShapes.add(vt);
            int numPolys = e.numDisplayableVariables(true);
            if (numPolys <= 0) continue;
            Poly[] polys = new Poly[numPolys];
            e.addDisplayableVariables(rect, polys, 0, this.dummyWnd, true);
            this.drawPolys(polys, trans, vc, true, 2, false);
        }
    }

    private void drawArc(ArcInst ai, AffineTransform trans, VectorCell vc) {
        Rectangle2D arcBounds = ai.getBounds();
        Rectangle2D dbBounds = new Rectangle2D.Double(arcBounds.getX(), arcBounds.getY(), arcBounds.getWidth(), arcBounds.getHeight());
        Poly p = new Poly(dbBounds);
        p.transform(trans);
        dbBounds = p.getBounds2D();
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        Poly[] polys = tech.getShapeOfArc(ai, this.dummyWnd);
        this.drawPolys(polys, trans, vc, false, 4, false);
    }

    private void drawPolys(Poly[] polys, AffineTransform trans, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            poly.transform(trans);
            this.renderPoly(poly, vc, hideOnLowLevel, textType, pureLayer);
        }
    }

    private void renderPoly(Poly poly, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        ArrayList<VectorBase> shapes;
        Point2D[] points = poly.getPoints();
        Layer layer = poly.getLayer();
        EGraphics graphics = null;
        if (layer != null) {
            graphics = layer.getGraphics();
        }
        Poly.Type style = poly.getStyle();
        ArrayList<VectorBase> filledShapes = hideOnLowLevel ? vc.topOnlyShapes : vc.filledShapes;
        ArrayList<VectorBase> arrayList = shapes = hideOnLowLevel ? vc.topOnlyShapes : vc.shapes;
        if (style == Poly.Type.FILLED) {
            Rectangle2D bounds = poly.getBox();
            if (bounds != null) {
                double lX = bounds.getMinX();
                double hX = bounds.getMaxX();
                double lY = bounds.getMinY();
                double hY = bounds.getMaxY();
                float minSize = (float)Math.min(hX - lX, hY - lY);
                int layerIndex = -1;
                if (layer != null) {
                    if (layer.getTechnology() == vc.vcg.cellBackup.d.tech) {
                        layerIndex = layer.getIndex();
                    }
                    Layer.Function fun = layer.getFunction();
                    if (!pureLayer && (fun.isImplant() || fun.isSubstrate())) {
                        minSize /= 10.0f;
                    }
                }
                if (layerIndex >= 0) {
                    VectorCache.putBox(layerIndex, pureLayer ? this.pureBoxBuilders : this.boxBuilders, lX, lY, hX, hY);
                } else {
                    VectorManhattan vm = new VectorManhattan(lX, lY, hX, hY, layer, graphics, pureLayer);
                    filledShapes.add(vm);
                }
                vc.maxFeatureSize = Math.max(vc.maxFeatureSize, minSize);
                return;
            }
            VectorPolygon vp = new VectorPolygon(points, layer, graphics);
            filledShapes.add(vp);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            VectorLine vl1 = new VectorLine(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphics);
            VectorLine vl2 = new VectorLine(points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), 0, layer, graphics);
            VectorLine vl3 = new VectorLine(points[2].getX(), points[2].getY(), points[3].getX(), points[3].getY(), 0, layer, graphics);
            VectorLine vl4 = new VectorLine(points[3].getX(), points[3].getY(), points[0].getX(), points[0].getY(), 0, layer, graphics);
            VectorLine vl5 = new VectorLine(points[0].getX(), points[0].getY(), points[2].getX(), points[2].getY(), 0, layer, graphics);
            VectorLine vl6 = new VectorLine(points[1].getX(), points[1].getY(), points[3].getX(), points[3].getY(), 0, layer, graphics);
            shapes.add(vl1);
            shapes.add(vl2);
            shapes.add(vl3);
            shapes.add(vl4);
            shapes.add(vl5);
            shapes.add(vl6);
            return;
        }
        if (style.isText()) {
            Rectangle2D bounds = poly.getBounds2D();
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            VectorText vt = new VectorText(bounds, style, descript, str, textType, null, layer, graphics);
            shapes.add(vt);
            vc.maxFeatureSize = Math.max(vc.maxFeatureSize, vt.height);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point2D oldPt = points[j - 1];
                Point2D newPt = points[j];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphics);
                shapes.add(vl);
            }
            if (style == Poly.Type.CLOSED) {
                Point2D oldPt = points[points.length - 1];
                Point2D newPt = points[0];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphics);
                shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point2D oldPt = points[j];
                Point2D newPt = points[j + 1];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), 0, layer, graphics);
                shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphics);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 1, layer, graphics);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.DISC) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 2, layer, graphics);
            filledShapes.add(vci);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            VectorCircleArc vca = new VectorCircleArc(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), style == Poly.Type.THICKCIRCLEARC, layer, graphics);
            shapes.add(vca);
            return;
        }
        if (style == Poly.Type.CROSS) {
            VectorCross vcr = new VectorCross(points[0].getX(), points[0].getY(), true, layer, graphics);
            shapes.add(vcr);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            VectorCross vcr = new VectorCross(points[0].getX(), points[0].getY(), false, layer, graphics);
            shapes.add(vcr);
            return;
        }
    }

    private static void putBox(int layerIndex, ArrayList<VectorManhattanBuilder> boxBuilders, double lX, double lY, double hX, double hY) {
        while (layerIndex >= boxBuilders.size()) {
            boxBuilders.add(new VectorManhattanBuilder());
        }
        VectorManhattanBuilder b = boxBuilders.get(layerIndex);
        b.add(lX, lY, hX, hY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VectorCell {
        final VectorCellGroup vcg;
        final Orientation orient;
        int[] outlinePoints = new int[8];
        int lX;
        int lY;
        int hX;
        int hY;
        ArrayList<VectorText> portShapes;
        boolean valid;
        ArrayList<VectorBase> filledShapes = new ArrayList();
        ArrayList<VectorBase> shapes = new ArrayList();
        ArrayList<VectorBase> topOnlyShapes = new ArrayList();
        ArrayList<VectorSubCell> subCells = new ArrayList();
        boolean hasFadeColor;
        int fadeColor;
        float maxFeatureSize;
        boolean fadeImage;
        int fadeOffsetX;
        int fadeOffsetY;
        int[] fadeImageColors;
        int fadeImageWid;
        int fadeImageHei;

        VectorCell(VectorCellGroup vcg, Orientation orient) {
            this.vcg = vcg;
            this.orient = orient;
            this.updateBounds();
        }

        private void init(Cell cell) {
            List addTheseInsts;
            this.vcg.init();
            this.updateBounds();
            this.clear();
            this.maxFeatureSize = 0.0f;
            AffineTransform trans = this.orient.pureRotate();
            this.vcg.updateExports();
            for (VectorManhattanBuilder b : VectorCache.this.boxBuilders) {
                b.clear();
            }
            for (VectorManhattanBuilder b : VectorCache.this.pureBoxBuilders) {
                b.clear();
            }
            Iterator<ArcInst> arcs = cell.getArcs();
            while (arcs.hasNext()) {
                ArcInst ai = arcs.next();
                VectorCache.this.drawArc(ai, trans, this);
            }
            Iterator<NodeInst> nodes = cell.getNodes();
            while (nodes.hasNext()) {
                NodeInst ni = nodes.next();
                VectorCache.this.drawNode(ni, trans, this);
            }
            int numPolys = cell.numDisplayableVariables(true);
            Poly[] polys = new Poly[numPolys];
            cell.addDisplayableVariables(VectorCache.this.CENTERRECT, polys, 0, VectorCache.this.dummyWnd, true);
            VectorCache.this.drawPolys(polys, DBMath.MATID, this, true, 1, false);
            List addThesePolys = (List)VectorCache.this.addPolyToCell.get(cell);
            if (addThesePolys != null) {
                for (VectorBase vb : addThesePolys) {
                    this.filledShapes.add(vb);
                }
            }
            if ((addTheseInsts = (List)VectorCache.this.addInstToCell.get(cell)) != null) {
                for (VectorLine vl : addTheseInsts) {
                    this.shapes.add(vl);
                }
            }
            VectorCache.this.addBoxesFromBuilder(this, cell.getTechnology(), VectorCache.this.boxBuilders, false);
            VectorCache.this.addBoxesFromBuilder(this, cell.getTechnology(), VectorCache.this.pureBoxBuilders, true);
            Collections.sort(this.filledShapes, shapeByLayer);
            Collections.sort(this.shapes, shapeByLayer);
            Collections.sort(this.topOnlyShapes, shapeByLayer);
            if (cell.getView() == View.ICON) {
                this.maxFeatureSize = 0.0f;
            }
            this.valid = true;
        }

        private void updateBounds() {
            this.lY = Integer.MAX_VALUE;
            this.lX = Integer.MAX_VALUE;
            this.hY = Integer.MIN_VALUE;
            this.hX = Integer.MIN_VALUE;
            ERectangle bounds = this.vcg.bounds;
            if (bounds == null) {
                return;
            }
            double[] points = new double[8];
            points[0] = points[6] = bounds.getMinX();
            points[1] = points[3] = bounds.getMinY();
            points[2] = points[4] = bounds.getMaxX();
            points[5] = points[7] = bounds.getMaxY();
            this.orient.pureRotate().transform(points, 0, points, 0, 4);
            for (int i = 0; i < 4; ++i) {
                int x = VectorCache.databaseToGrid(points[i * 2]);
                int y = VectorCache.databaseToGrid(points[i * 2 + 1]);
                this.lX = Math.min(this.lX, x);
                this.lY = Math.min(this.lY, y);
                this.hX = Math.max(this.hX, x);
                this.hY = Math.max(this.hY, y);
                this.outlinePoints[i * 2] = x;
                this.outlinePoints[i * 2 + 1] = y;
            }
        }

        private void clearPortShapes() {
            this.portShapes = null;
        }

        ArrayList<VectorText> getPortShapes() {
            if (this.portShapes == null) {
                this.initPortShapes();
            }
            return this.portShapes;
        }

        private void initPortShapes() {
            this.portShapes = new ArrayList();
            Cell cell = VectorCache.this.database.getCell(this.vcg.cellId);
            AffineTransform trans = this.orient.pureRotate();
            int numPorts = cell.getNumPorts();
            for (int i = 0; i < numPorts; ++i) {
                Export pp = cell.getPort(i);
                Poly portPoly = pp.getOriginalPort().getPoly();
                portPoly.transform(trans);
                TextDescriptor descript = portPoly.getTextDescriptor();
                TextDescriptor portDescript = pp.getTextDescriptor(Export.EXPORT_NAME);
                Poly.Type style = Poly.Type.FILLED;
                if (descript != null) {
                    portDescript = portDescript.withColorIndex(descript.getColorIndex());
                    style = descript.getPos().getPolyType();
                }
                VectorText vt = new VectorText(portPoly.getBounds2D(), style, descript, null, 7, pp, null, null);
                this.portShapes.add(vt);
            }
        }

        private void clear() {
            this.fadeImage = false;
            this.hasFadeColor = false;
            this.valid = false;
            this.filledShapes.clear();
            this.shapes.clear();
            this.topOnlyShapes.clear();
            this.subCells.clear();
            this.fadeImageColors = null;
        }
    }

    static class VectorCellExport {
        String exportName;
        Point2D exportCtr;

        VectorCellExport() {
        }
    }

    class VectorCellGroup {
        CellId cellId;
        ERectangle bounds;
        float cellArea;
        float cellMinSize;
        CellBackup cellBackup;
        boolean isParameterized;
        Cell cell;
        HashMap<Orientation, VectorCell> orientations = new HashMap();
        List<VectorCellExport> exports;

        VectorCellGroup(CellId cellId) {
            this.cellId = cellId;
            this.init();
            this.updateExports();
        }

        private void init() {
            this.updateBounds(VectorCache.this.database.backup());
            CellBackup cellBackup = VectorCache.this.database.backup().getCell(this.cellId);
            if (this.cellBackup == cellBackup) {
                return;
            }
            this.cellBackup = cellBackup;
            this.clear();
            this.cell = VectorCache.this.database.getCell(this.cellId);
            this.isParameterized = VectorCache.isCellParameterized(cellBackup);
        }

        private void updateBounds(Snapshot snapshot) {
            ERectangle newBounds = snapshot.getCellBounds(this.cellId);
            if (newBounds == this.bounds) {
                return;
            }
            this.bounds = newBounds;
            if (this.bounds != null) {
                this.cellArea = (float)(this.bounds.getWidth() * this.bounds.getHeight());
                this.cellMinSize = (float)Math.min(this.bounds.getWidth(), this.bounds.getHeight());
            } else {
                this.cellArea = 0.0f;
                this.cellMinSize = 0.0f;
            }
            for (VectorCell vc : this.orientations.values()) {
                vc.updateBounds();
            }
        }

        private boolean changedExports() {
            Cell cell = VectorCache.this.database.getCell(this.cellId);
            if (cell == null) {
                return this.exports != null;
            }
            if (this.exports == null) {
                return true;
            }
            ERectangle cellBounds = cell.getBounds();
            Iterator<VectorCellExport> cIt = this.exports.iterator();
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (!cIt.hasNext()) {
                    return true;
                }
                VectorCellExport vce = cIt.next();
                if (!vce.exportName.equals(e.getName())) {
                    return true;
                }
                Poly poly = e.getOriginalPort().getPoly();
                if (vce.exportCtr.getX() == poly.getCenterX() && vce.exportCtr.getY() == poly.getCenterY()) continue;
                return true;
            }
            return cIt.hasNext();
        }

        private void updateExports() {
            Cell cell = VectorCache.this.database.getCell(this.cellId);
            if (cell == null) {
                this.exports = null;
                return;
            }
            this.exports = new ArrayList<VectorCellExport>();
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                VectorCellExport vce = new VectorCellExport();
                vce.exportName = e.getName();
                Poly poly = e.getOriginalPort().getPoly();
                vce.exportCtr = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                this.exports.add(vce);
            }
            for (VectorCell vc : this.orientations.values()) {
                vc.clearPortShapes();
            }
        }

        void clear() {
            for (VectorCell vc : this.orientations.values()) {
                vc.clear();
            }
            if (this.exports != null) {
                this.exports.clear();
            }
        }

        VectorCell getAnyCell() {
            for (VectorCell vc : this.orientations.values()) {
                if (!vc.valid) continue;
                return vc;
            }
            return null;
        }
    }

    static class VectorSubCell {
        NodeInst ni;
        Orientation pureRotate;
        Cell subCell;
        int offsetX;
        int offsetY;
        BitSet shownPorts = new BitSet();

        VectorSubCell(NodeInst ni, Point2D offset) {
            this.ni = ni;
            this.pureRotate = ni.getOrient();
            this.subCell = (Cell)ni.getProto();
            this.offsetX = VectorCache.databaseToGrid(offset.getX());
            this.offsetY = VectorCache.databaseToGrid(offset.getY());
        }
    }

    static class VectorCross
    extends VectorBase {
        int x;
        int y;
        boolean small;

        VectorCross(double x, double y, boolean small, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.x = VectorCache.databaseToGrid(x);
            this.y = VectorCache.databaseToGrid(y);
            this.small = small;
        }
    }

    static class VectorText
    extends VectorBase {
        static final int TEXTTYPECELL = 1;
        static final int TEXTTYPEEXPORT = 2;
        static final int TEXTTYPENODE = 3;
        static final int TEXTTYPEARC = 4;
        static final int TEXTTYPEANNOTATION = 5;
        static final int TEXTTYPEINSTANCE = 6;
        static final int TEXTTYPEPORT = 7;
        Rectangle bounds;
        Poly.Type style;
        TextDescriptor descript;
        String str;
        float height;
        int textType;
        Export e;

        VectorText(Rectangle2D bounds, Poly.Type style, TextDescriptor descript, String str, int textType, Export e, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            AbstractTextDescriptor.Size tds;
            this.bounds = new Rectangle(VectorCache.databaseToGrid(bounds.getX()), VectorCache.databaseToGrid(bounds.getY()), VectorCache.databaseToGrid(bounds.getWidth()), VectorCache.databaseToGrid(bounds.getHeight()));
            this.style = style;
            this.descript = descript;
            this.str = str;
            this.textType = textType;
            this.e = e;
            this.height = 1.0f;
            if (descript != null && !(tds = descript.getSize()).isAbsolute()) {
                this.height = (float)tds.getSize();
            }
        }
    }

    static class VectorCircleArc
    extends VectorBase {
        int cX;
        int cY;
        int eX1;
        int eY1;
        int eX2;
        int eY2;
        boolean thick;

        VectorCircleArc(double cX, double cY, double eX1, double eY1, double eX2, double eY2, boolean thick, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.cX = VectorCache.databaseToGrid(cX);
            this.cY = VectorCache.databaseToGrid(cY);
            this.eX1 = VectorCache.databaseToGrid(eX1);
            this.eY1 = VectorCache.databaseToGrid(eY1);
            this.eX2 = VectorCache.databaseToGrid(eX2);
            this.eY2 = VectorCache.databaseToGrid(eY2);
            this.thick = thick;
        }
    }

    static class VectorCircle
    extends VectorBase {
        int cX;
        int cY;
        int eX;
        int eY;
        int nature;

        VectorCircle(double cX, double cY, double eX, double eY, int nature, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.cX = VectorCache.databaseToGrid(cX);
            this.cY = VectorCache.databaseToGrid(cY);
            this.eX = VectorCache.databaseToGrid(eX);
            this.eY = VectorCache.databaseToGrid(eY);
            this.nature = nature;
        }

        boolean isFilled() {
            return this.nature == 2;
        }
    }

    static class VectorLine
    extends VectorBase {
        int fX;
        int fY;
        int tX;
        int tY;
        int texture;

        VectorLine(double fX, double fY, double tX, double tY, int texture, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.fX = VectorCache.databaseToGrid(fX);
            this.fY = VectorCache.databaseToGrid(fY);
            this.tX = VectorCache.databaseToGrid(tX);
            this.tY = VectorCache.databaseToGrid(tY);
            this.texture = texture;
        }
    }

    static class VectorPolygon
    extends VectorBase {
        Point[] points;

        VectorPolygon(Point2D[] points, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.points = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                Point2D p = points[i];
                this.points[i] = new Point(VectorCache.databaseToGrid(p.getX()), VectorCache.databaseToGrid(p.getY()));
            }
        }

        boolean isFilled() {
            return true;
        }
    }

    static class VectorManhattanBuilder {
        int size;
        int[] coords = new int[4];

        VectorManhattanBuilder() {
        }

        private void add(double lX, double lY, double hX, double hY) {
            if (this.size * 4 >= this.coords.length) {
                int[] newCoords = new int[this.coords.length * 2];
                System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
                this.coords = newCoords;
            }
            int i = this.size * 4;
            this.coords[i] = VectorCache.databaseToGrid(lX);
            this.coords[i + 1] = VectorCache.databaseToGrid(lY);
            this.coords[i + 2] = VectorCache.databaseToGrid(hX);
            this.coords[i + 3] = VectorCache.databaseToGrid(hY);
            ++this.size;
        }

        int[] toArray() {
            int[] a = new int[this.size * 4];
            System.arraycopy(this.coords, 0, a, 0, a.length);
            return a;
        }

        private void clear() {
            this.size = 0;
        }
    }

    static class VectorManhattan
    extends VectorBase {
        int[] coords;
        boolean pureLayer;

        VectorManhattan(int[] coords, Layer layer, EGraphics graphics, boolean pureLayer) {
            super(layer, graphics);
            this.coords = coords;
            this.pureLayer = pureLayer;
        }

        VectorManhattan(double c1X, double c1Y, double c2X, double c2Y, Layer layer, EGraphics graphics, boolean pureLayer) {
            this(new int[]{VectorCache.databaseToGrid(c1X), VectorCache.databaseToGrid(c1Y), VectorCache.databaseToGrid(c2X), VectorCache.databaseToGrid(c2Y)}, layer, graphics, pureLayer);
        }

        boolean isFilled() {
            return true;
        }
    }

    static abstract class VectorBase {
        Layer layer;
        EGraphics graphics;

        VectorBase(Layer layer, EGraphics graphics) {
            this.layer = layer;
            this.graphics = graphics;
        }

        boolean isFilled() {
            return false;
        }
    }
}

