/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyMerge
extends GeometryHandler {
    @Override
    public void add(Layer key, Object value) {
        Layer layer = key;
        PolyBase poly = null;
        if (value instanceof PolyBase) {
            poly = (PolyBase)value;
        } else if (value instanceof Shape) {
            poly = new PolyBase(((Shape)value).getBounds2D());
        } else {
            return;
        }
        this.addPolygon(layer, poly);
    }

    public void addPolygon(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            area = new Area();
            this.layers.put(layer, area);
        }
        Area additionalArea = new Area(poly);
        area.add(additionalArea);
    }

    @Override
    public void subtract(Object layer, Object poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return;
        }
        Area subtractArea = new Area((PolyBase)poly);
        area.subtract(subtractArea);
    }

    @Override
    public void addAll(GeometryHandler subMerge, AffineTransform trans) {
        PolyMerge other = (PolyMerge)subMerge;
        this.addMerge(other, trans);
    }

    public void addMerge(PolyMerge other, AffineTransform trans) {
        for (Layer subLayer : other.layers.keySet()) {
            Area subArea = (Area)other.layers.get(subLayer);
            Area area = (Area)this.layers.get(subLayer);
            if (area == null) {
                area = new Area();
                this.layers.put(subLayer, area);
            }
            Area newArea = subArea.createTransformedArea(trans);
            area.add(newArea);
        }
    }

    public boolean intersects(Layer layer, PolyBase poly) {
        Area layerArea = (Area)this.layers.get(layer);
        if (layerArea == null) {
            return false;
        }
        Rectangle2D box = poly.getBox();
        if (box != null) {
            return layerArea.intersects(box);
        }
        Area intersectArea = new Area(poly);
        intersectArea.intersect(layerArea);
        return !intersectArea.isEmpty();
    }

    public void intersectLayers(Layer sourceA, Layer sourceB, Layer dest) {
        Area sourceAreaB;
        Area destArea = null;
        Area sourceAreaA = (Area)this.layers.get(sourceA);
        if (sourceAreaA != null && (sourceAreaB = (Area)this.layers.get(sourceB)) != null) {
            destArea = new Area(sourceAreaA);
            destArea.intersect(sourceAreaB);
            if (destArea.isEmpty()) {
                destArea = null;
            }
        }
        if (destArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, destArea);
        }
    }

    public void subtractLayers(Layer sourceA, Layer sourceB, Layer dest) {
        Area sourceAreaB;
        Area destArea = null;
        Area sourceAreaA = (Area)this.layers.get(sourceA);
        if (sourceAreaA != null && (sourceAreaB = (Area)this.layers.get(sourceB)) != null) {
            destArea = new Area(sourceAreaA);
            destArea.subtract(sourceAreaB);
            if (destArea.isEmpty()) {
                destArea = null;
            }
        }
        if (destArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, destArea);
        }
    }

    public void insetLayer(Layer source, Layer dest, double amount) {
        Area sourceArea = (Area)this.layers.get(source);
        if (sourceArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, (Area)sourceArea.clone());
            if (amount == 0.0) {
                return;
            }
            List<PolyBase> orig = PolyMerge.getAreaPoints(sourceArea, source, true);
            Point2D[] subtractPoints = new Point2D[4];
            for (PolyBase poly : orig) {
                Point2D[] points = poly.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    Point2D thisPt;
                    Point2D lastPt;
                    int last = i - 1;
                    if (last < 0) {
                        last = points.length - 1;
                    }
                    if (DBMath.areEquals(lastPt = points[last], thisPt = points[i])) continue;
                    int angle = DBMath.figureAngle(lastPt, thisPt);
                    int perpAngle = (angle + 2700) % 3600;
                    double offsetX = DBMath.cos(perpAngle) * amount;
                    double offsetY = DBMath.sin(perpAngle) * amount;
                    Point2D.Double insetLastPt = new Point2D.Double(lastPt.getX() + offsetX, lastPt.getY() + offsetY);
                    Point2D.Double insetThisPt = new Point2D.Double(thisPt.getX() + offsetX, thisPt.getY() + offsetY);
                    subtractPoints[0] = lastPt;
                    subtractPoints[1] = thisPt;
                    subtractPoints[2] = insetThisPt;
                    subtractPoints[3] = insetLastPt;
                    PolyBase subtractPoly = new PolyBase(subtractPoints);
                    this.subtract(dest, subtractPoly);
                }
            }
        }
    }

    public void deleteLayer(Layer layer) {
        this.layers.remove(layer);
    }

    public boolean isEmpty(Layer layer) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return true;
        }
        return area.isEmpty();
    }

    public boolean contains(Layer layer, Rectangle2D rect) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        if (area.contains(rect)) {
            return true;
        }
        Area rectArea = new Area(rect);
        rectArea.subtract(area);
        if (rectArea.isEmpty()) {
            return true;
        }
        double remainingArea = this.getAreaOfArea(rectArea);
        return DBMath.areEquals(remainingArea, 0.0);
    }

    public boolean contains(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        Area polyArea = new Area(poly);
        polyArea.subtract(area);
        if (polyArea.isEmpty()) {
            return true;
        }
        double remainingArea = this.getAreaOfArea(polyArea);
        return DBMath.areEquals(remainingArea, 0.0);
    }

    private double getAreaOfArea(Area area) {
        List<PolyBase> pointList = PolyMerge.getAreaPoints(area, null, true);
        double totalArea = 0.0;
        for (PolyBase p : pointList) {
            totalArea += p.getArea();
        }
        return totalArea;
    }

    public boolean contains(Layer layer, Point2D pt) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        return area.contains(pt);
    }

    @Override
    public Collection<PolyBase> getObjects(Object layer, boolean modified, boolean simple) {
        return this.getMergedPoints((Layer)layer, simple);
    }

    public List<PolyBase> getMergedPoints(Layer layer, boolean simple) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return null;
        }
        return PolyMerge.getAreaPoints(area, layer, simple);
    }

    public static List<PolyBase> getAreaPoints(Area area, Layer layer, boolean simple) {
        return PolyBase.getPointsInArea(area, layer, simple, true, null);
    }
}

