/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.HelpMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class Main {
    private static boolean DEBUG;
    public static boolean LOCALDEBUGFLAG;
    public static boolean NOTHREADING;
    public static boolean BATCHMODE;
    static /* synthetic */ Class class$com$sun$electric$tool$user$ui$TopLevel;

    private Main() {
    }

    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsList.add(args[i]);
        }
        if (Main.hasCommandLineOption(argsList, "-v")) {
            System.out.println(Version.getVersion());
            System.exit(0);
        }
        MacOSXInterface.registerMacOSXApplication();
        if (Main.hasCommandLineOption(argsList, "-version")) {
            System.out.println(Version.getApplicationInformation());
            System.out.println("\t" + Version.getVersionInformation());
            System.out.println("\t" + Version.getAuthorInformation());
            System.out.println("\t" + Version.getCopyrightInformation());
            System.out.println("\t" + Version.getWarrantyInformation());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-help")) {
            System.out.println("Usage (without plugins):");
            System.out.println("\tjava -jar electric.jar [electric-options]");
            System.out.println("Usage (with plugins):");
            System.out.println("\tjava -classpath electric.jar<delim>{list of plugins} com.sun.electric.Launcher [electric-options]");
            System.out.println("\t\twhere <delim> is OS-dependant separator (colon or semicolon)");
            System.out.println("\nOptions:");
            System.out.println("\t-mdi: multiple document interface mode");
            System.out.println("\t-sdi: single document interface mode");
            System.out.println("\t-NOMINMEM: ignore minimum memory provided for JVM");
            System.out.println("\t-s <script name>: bean shell script to execute");
            System.out.println("\t-version: version information");
            System.out.println("\t-v: brief version information");
            System.out.println("\t-debug: debug mode. Extra information is available");
            System.out.println("\t-NOTHREADING: turn off Job threading.");
            System.out.println("\t-batch: running in batch mode.");
            System.out.println("\t-pulldowns: list all pulldown menus in Electric");
            System.out.println("\t-help: this message");
            System.exit(0);
        }
        ActivityLogger.initialize(true, true, false);
        EventProcessor ep = new EventProcessor();
        MacOSXInterface.registerMacOSXApplication();
        SplashWindow sw = null;
        if (Main.hasCommandLineOption(argsList, "-debug")) {
            DEBUG = true;
        }
        if (Main.hasCommandLineOption(argsList, "-gilda")) {
            LOCALDEBUGFLAG = true;
        }
        if (Main.hasCommandLineOption(argsList, "-NOTHREADING")) {
            NOTHREADING = true;
        }
        if (Main.hasCommandLineOption(argsList, "-batch")) {
            BATCHMODE = true;
        }
        if (!BATCHMODE) {
            sw = new SplashWindow();
        }
        boolean mdiMode = Main.hasCommandLineOption(argsList, "-mdi");
        boolean sdiMode = Main.hasCommandLineOption(argsList, "-sdi");
        TopLevel.Mode mode = null;
        if (mdiMode) {
            mode = TopLevel.Mode.MDI;
        }
        if (sdiMode) {
            mode = TopLevel.Mode.SDI;
        }
        TopLevel.OSInitialize(mode);
        if (Main.hasCommandLineOption(argsList, "-pulldowns")) {
            Main.dumpPulldownMenus();
        }
        new InitDatabase(argsList, sw);
    }

    private static boolean hasCommandLineOption(List argsList, String option) {
        for (int i = 0; i < argsList.size(); ++i) {
            if (!((String)argsList.get(i)).equals(option)) continue;
            argsList.remove(i);
            return true;
        }
        return false;
    }

    private static String getCommandLineOption(List argsList, String option) {
        for (int i = 0; i < argsList.size() - 1; ++i) {
            if (!((String)argsList.get(i)).equals(option)) continue;
            argsList.remove(i);
            if (((String)argsList.get(i)).startsWith("-")) {
                System.out.println("Bad command line option: " + option + " " + argsList.get(i + 1));
                return null;
            }
            return (String)argsList.remove(i);
        }
        return null;
    }

    private static void openCommandLineLibs(List argsList) {
        ArrayList<URL> fileURLs = new ArrayList<URL>();
        for (int i = 0; i < argsList.size(); ++i) {
            String arg = (String)argsList.get(i);
            if (arg.startsWith("-")) {
                System.out.println("Command line option " + arg + " not understood, ignoring.");
                continue;
            }
            URL url = TextUtils.makeURLToFile(arg);
            if (url == null) continue;
            fileURLs.add(url);
        }
        FileMenu.ReadInitialELIBs job = new FileMenu.ReadInitialELIBs(fileURLs);
    }

    private static void dumpPulldownMenus() {
        Date now = new Date();
        System.out.println("Pulldown menus in Electric as of " + TextUtils.formatDate(now));
        TopLevel top = TopLevel.getCurrentJFrame();
        MenuBar menuBar = top.getTheMenuBar();
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            MenuBar.Menu menu = (MenuBar.Menu)menuBar.getMenu(i);
            Main.printIndented("\n" + menu.getText() + ":", 0);
            Main.addMenu(menu, 1);
        }
    }

    private static void printIndented(String str, int depth) {
        for (int i = 0; i < depth * 3; ++i) {
            System.out.print(" ");
        }
        System.out.println(str);
    }

    private static void addMenu(MenuBar.Menu menu, int depth) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem == null) {
                Main.printIndented("----------", depth);
                continue;
            }
            Main.printIndented(menuItem.getText(), depth);
            if (!(menuItem instanceof JMenu)) continue;
            Main.addMenu((MenuBar.Menu)menuItem, depth + 1);
        }
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    private static void runThreadStatusTimer() {
        int delay = 600000;
        Timer timer = new Timer(delay, new ThreadStatusTask());
        timer.start();
    }

    static {
        NOTHREADING = false;
        BATCHMODE = false;
    }

    static class MacOSXInterface
    extends ApplicationAdapter {
        private static MacOSXInterface adapter = null;
        private static Application application = null;

        private MacOSXInterface() {
        }

        public void handleAbout(ApplicationEvent ae) {
            ae.setHandled(true);
            HelpMenu.aboutCommand();
        }

        public void handlePreferences(ApplicationEvent ae) {
            ae.setHandled(true);
            PreferencesFrame.preferencesCommand();
        }

        public void handleQuit(ApplicationEvent ae) {
            ae.setHandled(false);
            FileMenu.quitCommand();
        }

        public static void registerMacOSXApplication() {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Electric");
            if (application == null) {
                application = new Application();
            }
            if (adapter == null) {
                adapter = new MacOSXInterface();
            }
            application.addApplicationListener(adapter);
            application.setEnabledPreferencesMenu(true);
        }
    }

    public static class ThreadStatusTask
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Thread t = Thread.currentThread();
            ThreadGroup group = t.getThreadGroup();
            while (group.getParent() != null) {
                group = group.getParent();
            }
            Thread[] threads = new Thread[200];
            int numThreads = group.enumerate(threads, true);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < numThreads; ++i) {
                buf.append("Thread[" + i + "] " + threads[i] + ": alive: " + threads[i].isAlive() + ", interrupted: " + threads[i].isInterrupted() + "\n");
            }
            ActivityLogger.logThreadMessage(buf.toString());
        }
    }

    public static class EventProcessor
    extends EventQueue {
        public EventProcessor() {
            Toolkit kit = Toolkit.getDefaultToolkit();
            kit.getSystemEventQueue().push(this);
        }

        protected void dispatchEvent(AWTEvent e) {
            block2: {
                try {
                    super.dispatchEvent(e);
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                    ActivityLogger.logException(ex);
                    if (!(ex instanceof Error)) break block2;
                    throw (Error)ex;
                }
            }
        }
    }

    private static class InitDatabase
    extends Job {
        List argsList;
        SplashWindow sw;

        protected InitDatabase(List argsList, SplashWindow sw) {
            super("Init database", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.argsList = argsList;
            this.sw = sw;
            this.startJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doIt() {
            try {
                Undo.changesQuiet(true);
                Technology.initAllTechnologies();
                Tool.initAllTools();
                Layout con = Layout.getConstraint();
                Constraints.setCurrent(con);
            }
            finally {
                Undo.changesQuiet(false);
            }
            if (Main.hasCommandLineOption(this.argsList, "-NOMINMEM")) {
                // empty if block
            }
            String beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
            Main.openCommandLineLibs(this.argsList);
            SwingUtilities.invokeLater(new Runnable(this, beanShellScript){
                private final /* synthetic */ String val$beanShellScript;
                private final /* synthetic */ InitDatabase this$0;
                {
                    this.this$0 = this$0;
                    this.val$beanShellScript = val$beanShellScript;
                }

                public void run() {
                    if (this.this$0.sw != null) {
                        this.this$0.sw.removeNotify();
                    }
                    TopLevel.InitializeWindows();
                    if (this.val$beanShellScript != null) {
                        EvalJavaBsh.runScript(this.val$beanShellScript);
                    }
                }
            });
            return true;
        }
    }

    private static class WindowsEvents
    implements WindowListener {
        SplashWindow sw;

        WindowsEvents(SplashWindow sw) {
            this.sw = sw;
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
            this.sw.toFront();
        }
    }

    private static class SplashWindow
    extends JFrame {
        public SplashWindow() {
            this.setUndecorated(true);
            this.setTitle("Electric Splash");
            this.setIconImage(TopLevel.getFrameIcon().getImage());
            JPanel whole = new JPanel();
            whole.setBorder(BorderFactory.createLineBorder(new Color(0, 170, 0), 5));
            whole.setLayout(new BorderLayout());
            JLabel l = new JLabel(Resources.getResource(class$com$sun$electric$tool$user$ui$TopLevel == null ? (class$com$sun$electric$tool$user$ui$TopLevel = Main.class$("com.sun.electric.tool.user.ui.TopLevel")) : class$com$sun$electric$tool$user$ui$TopLevel, "SplashImage.gif"));
            whole.add((Component)l, "Center");
            JLabel v = new JLabel("Version " + Version.getVersion(), 0);
            whole.add((Component)v, "South");
            Font font = new Font(User.getDefaultFont(), 1, 24);
            v.setFont(font);
            v.setForeground(Color.BLACK);
            v.setBackground(Color.WHITE);
            this.getContentPane().add((Component)whole, "South");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            WindowsEvents windowsEvents = new WindowsEvents(this);
            this.addWindowListener(windowsEvents);
            this.setVisible(true);
        }
    }
}

