/*
 * Decompiled with CFR 0.152.
 */
package rdr;

import java.io.InputStream;
import rdr.EndOfStream;
import rdr.Exception;
import rdr.IOException;
import rdr.InStream;

public class JavaInStream
extends InStream {
    static final int defaultBufSize = 8192;
    static final int minBulkSize = 1024;
    private InputStream jis;
    private int ptrOffset;
    private int bufSize;
    boolean timing;
    long timeWaitedIn100us;
    long timedKbits;

    public JavaInStream(InputStream inputStream, int n) {
        this.jis = inputStream;
        this.bufSize = n;
        this.b = new byte[this.bufSize];
        this.ptrOffset = 0;
        this.end = 0;
        this.ptr = 0;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
    }

    public JavaInStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        if (n2 < 1024) {
            super.readBytes(byArray, n, n2);
            return;
        }
        int n3 = this.end - this.ptr;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(this.b, this.ptr, byArray, n, n3);
        n += n3;
        n2 -= n3;
        this.ptr += n3;
        while (n2 > 0) {
            n3 = this.read(byArray, n, n2);
            n += n3;
            n2 -= n3;
            this.ptrOffset += n3;
        }
    }

    public int pos() {
        return this.ptrOffset + this.ptr;
    }

    public void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public long timeWaited() {
        return this.timeWaitedIn100us;
    }

    protected int overrun(int n, int n2) {
        if (n > this.bufSize) {
            throw new Exception("JavaInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.ptrOffset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < n) {
            int n3 = this.read(this.b, this.end, this.bufSize - this.end);
            this.end += n3;
        }
        if (n * n2 > this.end) {
            n2 = this.end / n;
        }
        return n2;
    }

    private int read(byte[] byArray, int n, int n2) {
        try {
            int n3;
            long l = 0L;
            if (this.timing) {
                l = System.currentTimeMillis();
            }
            if ((n3 = this.jis.read(byArray, n, n2)) < 0) {
                throw new EndOfStream();
            }
            if (this.timing) {
                int n4;
                long l2 = System.currentTimeMillis();
                long l3 = (l2 - l) * 10L;
                if (l3 > (long)((n4 = n3 * 8 / 1000) * 1000)) {
                    l3 = n4 * 1000;
                }
                if (l3 < (long)(n4 / 4)) {
                    l3 = n4 / 4;
                }
                this.timeWaitedIn100us += l3;
                this.timedKbits += (long)n4;
            }
            return n3;
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
    }
}

