/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_GIR_PARSER (vala_gir_parser_get_type ())
#define VALA_GIR_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_PARSER, ValaGirParser))
#define VALA_GIR_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_PARSER, ValaGirParserClass))
#define VALA_IS_GIR_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_PARSER))
#define VALA_IS_GIR_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_PARSER))
#define VALA_GIR_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_PARSER, ValaGirParserClass))

typedef struct _ValaGirParser ValaGirParser;
typedef struct _ValaGirParserClass ValaGirParserClass;
typedef struct _ValaGirParserPrivate ValaGirParserPrivate;

#define VALA_TYPE_MARKUP_READER (vala_markup_reader_get_type ())
#define VALA_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReader))
#define VALA_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))
#define VALA_IS_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MARKUP_READER))
#define VALA_IS_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MARKUP_READER))
#define VALA_MARKUP_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))

typedef struct _ValaMarkupReader ValaMarkupReader;
typedef struct _ValaMarkupReaderClass ValaMarkupReaderClass;

#define VALA_TYPE_MARKUP_TOKEN_TYPE (vala_markup_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define __g_list_free_vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_vala_code_node_unref (var), NULL)))

#define VALA_GIR_PARSER_TYPE_METHOD_INFO (vala_gir_parser_method_info_get_type ())
#define VALA_GIR_PARSER_METHOD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METHOD_INFO, ValaGirParserMethodInfo))
#define VALA_GIR_PARSER_METHOD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METHOD_INFO, ValaGirParserMethodInfoClass))
#define VALA_GIR_PARSER_IS_METHOD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METHOD_INFO))
#define VALA_GIR_PARSER_IS_METHOD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METHOD_INFO))
#define VALA_GIR_PARSER_METHOD_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METHOD_INFO, ValaGirParserMethodInfoClass))

typedef struct _ValaGirParserMethodInfo ValaGirParserMethodInfo;
typedef struct _ValaGirParserMethodInfoClass ValaGirParserMethodInfoClass;
#define _vala_gir_parser_method_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_method_info_unref (var), NULL)))
typedef struct _ValaGirParserMethodInfoPrivate ValaGirParserMethodInfoPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMethodInfo ValaGirParserParamSpecMethodInfo;

struct _ValaGirParser {
	ValaCodeVisitor parent_instance;
	ValaGirParserPrivate * priv;
};

struct _ValaGirParserClass {
	ValaCodeVisitorClass parent_class;
};

typedef enum  {
	VALA_MARKUP_TOKEN_TYPE_NONE,
	VALA_MARKUP_TOKEN_TYPE_START_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_END_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_TEXT,
	VALA_MARKUP_TOKEN_TYPE_EOF
} ValaMarkupTokenType;

struct _ValaGirParserPrivate {
	char* _package_name;
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaNamespace* glib_ns;
	ValaSourceFile* current_source_file;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	char** cheader_filenames;
	gint cheader_filenames_length1;
	gint cheader_filenames_size;
	GeeHashMap* attributes_map;
	GeeHashMap* gtype_callbacks;
};

struct _ValaGirParserMethodInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMethodInfoPrivate * priv;
	ValaFormalParameter* param;
	float vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
};

struct _ValaGirParserMethodInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMethodInfo *self);
};

struct _ValaGirParserParamSpecMethodInfo {
	GParamSpec parent_instance;
};


static gpointer vala_gir_parser_method_info_parent_class = NULL;
static gpointer vala_gir_parser_parent_class = NULL;

GType vala_gir_parser_get_type (void);
GType vala_markup_reader_get_type (void);
GType vala_markup_token_type_get_type (void);
#define VALA_GIR_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_PARSER, ValaGirParserPrivate))
enum  {
	VALA_GIR_PARSER_DUMMY_PROPERTY
};
void vala_gir_parser_parse (ValaGirParser* self, ValaCodeContext* context);
void vala_gir_parser_parse_file (ValaGirParser* self, ValaSourceFile* source_file);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
ValaMarkupReader* vala_markup_reader_new (const char* filename);
ValaMarkupReader* vala_markup_reader_construct (GType object_type, const char* filename);
static void vala_gir_parser_next (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
const char* vala_markup_reader_get_name (ValaMarkupReader* self);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self, const char* name);
static void vala_gir_parser_end_element (ValaGirParser* self, const char* name);
static ValaNamespace* vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static void vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
char* vala_markup_reader_get_attribute (ValaMarkupReader* self, const char* attr);
static void vala_gir_parser_set_package_name (ValaGirParser* self, const char* value);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static char* vala_gir_parser_transform_namespace_name (ValaGirParser* self, const char* gir_module_name);
static void _g_list_free_vala_code_node_unref (GList* self);
static ValaStruct* vala_gir_parser_parse_alias (ValaGirParser* self);
static ValaEnum* vala_gir_parser_parse_enumeration (ValaGirParser* self);
static ValaEnum* vala_gir_parser_parse_bitfield (ValaGirParser* self);
static ValaMethod* vala_gir_parser_parse_method (ValaGirParser* self, const char* element_name);
static ValaDelegate* vala_gir_parser_parse_callback (ValaGirParser* self);
static ValaStruct* vala_gir_parser_parse_record (ValaGirParser* self);
static ValaClass* vala_gir_parser_parse_class (ValaGirParser* self);
static ValaInterface* vala_gir_parser_parse_interface (ValaGirParser* self);
static ValaStruct* vala_gir_parser_parse_boxed (ValaGirParser* self);
static ValaStruct* vala_gir_parser_parse_union (ValaGirParser* self);
static ValaConstant* vala_gir_parser_parse_constant (ValaGirParser* self);
static void vala_gir_parser_postprocess_gtype_callbacks (ValaGirParser* self, ValaNamespace* ns);
static ValaDataType* vala_gir_parser_parse_type_from_name (ValaGirParser* self, const char* type_name);
static ValaEnumValue* vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self, char** ctype, gint* array_length_index);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self, char** ctype);
static ValaFormalParameter* vala_gir_parser_parse_parameter (ValaGirParser* self, gint* array_length_idx, gint* closure_idx, gint* destroy_idx);
static ValaField* vala_gir_parser_parse_field (ValaGirParser* self);
static ValaMethod* vala_gir_parser_parse_constructor (ValaGirParser* self, const char* parent_ctype);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static ValaSignal* vala_gir_parser_parse_signal (ValaGirParser* self);
static gpointer vala_gir_parser_method_info_ref (gpointer instance);
static void vala_gir_parser_method_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_method_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
static void vala_gir_parser_value_set_method_info (GValue* value, gpointer v_object);
static gpointer vala_gir_parser_value_get_method_info (const GValue* value);
static GType vala_gir_parser_method_info_get_type (void);
static ValaGirParserMethodInfo* vala_gir_parser_method_info_new (ValaFormalParameter* param, gint array_length_idx, gint closure_idx, gint destroy_idx);
static ValaGirParserMethodInfo* vala_gir_parser_method_info_construct (GType object_type, ValaFormalParameter* param, gint array_length_idx, gint closure_idx, gint destroy_idx);
void vala_gir_parser_parse_metadata (ValaGirParser* self, const char* metadata_filename);
ValaGirParser* vala_gir_parser_new (void);
ValaGirParser* vala_gir_parser_construct (GType object_type);
const char* vala_gir_parser_get_package_name (ValaGirParser* self);
enum  {
	VALA_GIR_PARSER_METHOD_INFO_DUMMY_PROPERTY
};
static void vala_gir_parser_method_info_finalize (ValaGirParserMethodInfo* obj);
static void vala_gir_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gir_parser_parse (ValaGirParser* self, ValaCodeContext* context) {
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp2_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	self->priv->context = (_tmp0_ = _vala_code_context_ref0 (context), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	self->priv->glib_ns = (_tmp2_ = (_tmp1_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (context)), "GLib"), VALA_IS_NAMESPACE (_tmp1_) ? ((ValaNamespace*) _tmp1_) : NULL), _vala_code_node_unref0 (self->priv->glib_ns), _tmp2_);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
}


static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGirParser * self;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_parser_parse_file (ValaGirParser* self, ValaSourceFile* source_file) {
	ValaSourceFile* _tmp0_;
	ValaMarkupReader* _tmp1_;
	GeeArrayList* remove_queue;
	ValaMarkupReader* _tmp12_;
	ValaSourceFile* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	self->priv->current_source_file = (_tmp0_ = _vala_source_file_ref0 (source_file), _vala_source_file_unref0 (self->priv->current_source_file), _tmp0_);
	self->priv->reader = (_tmp1_ = vala_markup_reader_new (vala_source_file_get_filename (source_file)), _g_object_unref0 (self->priv->reader), _tmp1_);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_parse_repository (self);
	remove_queue = gee_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	{
		GeeList* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _node_it;
		_node_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_source_file_get_nodes (source_file))), _gee_collection_object_unref0 (_tmp2_), _tmp3_);
		while (TRUE) {
			ValaCodeNode* node;
			if (!gee_iterator_next (_node_it)) {
				break;
			}
			node = (ValaCodeNode*) gee_iterator_get (_node_it);
			if (VALA_IS_CLASS (node)) {
				ValaClass* cl;
				ValaSymbol* _tmp4_;
				ValaNamespace* ns;
				char* _tmp5_;
				ValaSymbol* _tmp6_;
				ValaStruct* _tmp7_;
				ValaStruct* class_struct;
				cl = _vala_code_node_ref0 (VALA_CLASS (node));
				ns = _vala_code_node_ref0 ((_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) cl), VALA_IS_NAMESPACE (_tmp4_) ? ((ValaNamespace*) _tmp4_) : NULL));
				class_struct = (_tmp7_ = (_tmp6_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), _tmp5_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) cl), "Class", NULL)), VALA_IS_STRUCT (_tmp6_) ? ((ValaStruct*) _tmp6_) : NULL), _g_free0 (_tmp5_), _tmp7_);
				if (class_struct != NULL) {
					vala_namespace_remove_struct (ns, VALA_STRUCT (class_struct));
					gee_collection_add ((GeeCollection*) remove_queue, (ValaCodeNode*) class_struct);
				}
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (class_struct);
			} else {
				if (VALA_IS_INTERFACE (node)) {
					ValaInterface* iface;
					ValaSymbol* _tmp8_;
					ValaNamespace* ns;
					char* _tmp9_;
					ValaSymbol* _tmp10_;
					ValaStruct* _tmp11_;
					ValaStruct* iface_struct;
					iface = _vala_code_node_ref0 (VALA_INTERFACE (node));
					ns = _vala_code_node_ref0 ((_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) iface), VALA_IS_NAMESPACE (_tmp8_) ? ((ValaNamespace*) _tmp8_) : NULL));
					iface_struct = (_tmp11_ = (_tmp10_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), _tmp9_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) iface), "Iface", NULL)), VALA_IS_STRUCT (_tmp10_) ? ((ValaStruct*) _tmp10_) : NULL), _g_free0 (_tmp9_), _tmp11_);
					if (iface_struct != NULL) {
						vala_namespace_remove_struct (ns, VALA_STRUCT (iface_struct));
						gee_collection_add ((GeeCollection*) remove_queue, (ValaCodeNode*) iface_struct);
					}
					_vala_code_node_unref0 (iface);
					_vala_code_node_unref0 (ns);
					_vala_code_node_unref0 (iface_struct);
				}
			}
			_vala_code_node_unref0 (node);
		}
		_gee_collection_object_unref0 (_node_it);
	}
	{
		GeeIterator* _node_it;
		_node_it = gee_iterable_iterator ((GeeIterable*) remove_queue);
		while (TRUE) {
			ValaCodeNode* node;
			if (!gee_iterator_next (_node_it)) {
				break;
			}
			node = (ValaCodeNode*) gee_iterator_get (_node_it);
			vala_source_file_remove_node (source_file, node);
			_vala_code_node_unref0 (node);
		}
		_gee_collection_object_unref0 (_node_it);
	}
	self->priv->reader = (_tmp12_ = NULL, _g_object_unref0 (self->priv->reader), _tmp12_);
	self->priv->current_source_file = (_tmp13_ = NULL, _vala_source_file_unref0 (self->priv->current_source_file), _tmp13_);
	_gee_collection_object_unref0 (remove_queue);
}


static void vala_gir_parser_next (ValaGirParser* self) {
	g_return_if_fail (self != NULL);
	self->priv->current_token = vala_markup_reader_read_token (self->priv->reader, &self->priv->begin, &self->priv->end);
}


static void vala_gir_parser_start_element (ValaGirParser* self, const char* name) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (self->priv->current_token != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), name) != 0;
	}
	if (_tmp0_) {
		char* _tmp2_;
		ValaSourceReference* _tmp1_;
		vala_report_error (_tmp1_ = vala_gir_parser_get_current_src (self), _tmp2_ = g_strdup_printf ("expected start element of `%s'", name));
		_g_free0 (_tmp2_);
		_vala_source_reference_unref0 (_tmp1_);
	}
}


static void vala_gir_parser_end_element (ValaGirParser* self, const char* name) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (self->priv->current_token != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), name) != 0;
	}
	if (_tmp0_) {
		char* _tmp2_;
		ValaSourceReference* _tmp1_;
		vala_report_error (_tmp1_ = vala_gir_parser_get_current_src (self), _tmp2_ = g_strdup_printf ("expected end element of `%s'", name));
		_g_free0 (_tmp2_);
		_vala_source_reference_unref0 (_tmp1_);
	}
	vala_gir_parser_next (self);
}


static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self) {
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = vala_source_reference_new (self->priv->current_source_file, self->priv->begin.line, self->priv->begin.column, self->priv->end.line, self->priv->end.column);
	return result;
}


static void vala_gir_parser_parse_repository (ValaGirParser* self) {
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	vala_gir_parser_next (self);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "namespace") == 0) {
			ValaNamespace* ns;
			ns = vala_gir_parser_parse_namespace (self);
			if (ns != NULL) {
				vala_namespace_add_namespace (vala_code_context_get_root (self->priv->context), ns);
			}
			_vala_code_node_unref0 (ns);
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "package") == 0) {
					vala_gir_parser_parse_package (self);
				} else {
					if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						char* _tmp1_;
						ValaSourceReference* _tmp0_;
						vala_report_error (_tmp0_ = vala_gir_parser_get_current_src (self), _tmp1_ = g_strdup_printf ("unknown child element `%s' in `repository'", vala_markup_reader_get_name (self->priv->reader)));
						_g_free0 (_tmp1_);
						_vala_source_reference_unref0 (_tmp0_);
						break;
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}


static void vala_gir_parser_parse_include (ValaGirParser* self) {
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
}


static void vala_gir_parser_parse_package (ValaGirParser* self) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "package");
	vala_gir_parser_set_package_name (self, _tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"));
	_g_free0 (_tmp0_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void vala_gir_parser_parse_c_include (ValaGirParser* self) {
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_vala_array_add1 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->cheader_filenames_size, vala_markup_reader_get_attribute (self->priv->reader, "name"));
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}


static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


static ValaNamespace* vala_gir_parser_parse_namespace (ValaGirParser* self) {
	ValaNamespace* result;
	gboolean new_namespace;
	char* _tmp0_;
	char* _tmp1_;
	char* namespace_name;
	ValaSymbol* _tmp2_;
	ValaNamespace* ns;
	char* cprefix;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "namespace");
	new_namespace = FALSE;
	namespace_name = (_tmp1_ = vala_gir_parser_transform_namespace_name (self, _tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name")), _g_free0 (_tmp0_), _tmp1_);
	ns = (_tmp2_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (self->priv->context)), namespace_name), VALA_IS_NAMESPACE (_tmp2_) ? ((ValaNamespace*) _tmp2_) : NULL);
	if (ns == NULL) {
		ValaNamespace* _tmp3_;
		ns = (_tmp3_ = vala_namespace_new (namespace_name, NULL), _vala_code_node_unref0 (ns), _tmp3_);
		new_namespace = TRUE;
	} else {
		if (vala_symbol_get_external_package ((ValaSymbol*) ns)) {
			GList* _tmp4_;
			ValaSourceReference* _tmp5_;
			((ValaCodeNode*) ns)->attributes = (_tmp4_ = NULL, __g_list_free_vala_code_node_unref0 (((ValaCodeNode*) ns)->attributes), _tmp4_);
			vala_code_node_set_source_reference ((ValaCodeNode*) ns, _tmp5_ = vala_gir_parser_get_current_src (self));
			_vala_source_reference_unref0 (_tmp5_);
		}
	}
	cprefix = vala_markup_reader_get_attribute (self->priv->reader, "c:prefix");
	if (cprefix != NULL) {
		char* _tmp7_;
		char* _tmp6_;
		vala_namespace_add_cprefix (ns, cprefix);
		vala_namespace_set_lower_case_cprefix (ns, _tmp7_ = g_strconcat (_tmp6_ = vala_symbol_camel_case_to_lower_case (cprefix), "_", NULL));
		_g_free0 (_tmp7_);
		_g_free0 (_tmp6_);
	}
	{
		char** c_header_collection;
		int c_header_collection_length1;
		int c_header_it;
		c_header_collection = self->priv->cheader_filenames;
		c_header_collection_length1 = self->priv->cheader_filenames_length1;
		for (c_header_it = 0; c_header_it < self->priv->cheader_filenames_length1; c_header_it = c_header_it + 1) {
			char* c_header;
			c_header = g_strdup (c_header_collection[c_header_it]);
			{
				vala_namespace_add_cheader_filename (ns, c_header);
				_g_free0 (c_header);
			}
		}
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaSymbol* sym;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		sym = NULL;
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "alias") == 0) {
			ValaSymbol* _tmp8_;
			sym = (_tmp8_ = (ValaSymbol*) vala_gir_parser_parse_alias (self), _vala_code_node_unref0 (sym), _tmp8_);
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "enumeration") == 0) {
				ValaSymbol* _tmp9_;
				sym = (_tmp9_ = (ValaSymbol*) vala_gir_parser_parse_enumeration (self), _vala_code_node_unref0 (sym), _tmp9_);
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "bitfield") == 0) {
					ValaSymbol* _tmp10_;
					sym = (_tmp10_ = (ValaSymbol*) vala_gir_parser_parse_bitfield (self), _vala_code_node_unref0 (sym), _tmp10_);
				} else {
					if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "function") == 0) {
						ValaSymbol* _tmp11_;
						sym = (_tmp11_ = (ValaSymbol*) vala_gir_parser_parse_method (self, "function"), _vala_code_node_unref0 (sym), _tmp11_);
					} else {
						if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "callback") == 0) {
							ValaSymbol* _tmp12_;
							sym = (_tmp12_ = (ValaSymbol*) vala_gir_parser_parse_callback (self), _vala_code_node_unref0 (sym), _tmp12_);
						} else {
							if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "record") == 0) {
								ValaSymbol* _tmp13_;
								sym = (_tmp13_ = (ValaSymbol*) vala_gir_parser_parse_record (self), _vala_code_node_unref0 (sym), _tmp13_);
							} else {
								if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "class") == 0) {
									ValaSymbol* _tmp14_;
									sym = (_tmp14_ = (ValaSymbol*) vala_gir_parser_parse_class (self), _vala_code_node_unref0 (sym), _tmp14_);
								} else {
									if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "interface") == 0) {
										ValaSymbol* _tmp15_;
										sym = (_tmp15_ = (ValaSymbol*) vala_gir_parser_parse_interface (self), _vala_code_node_unref0 (sym), _tmp15_);
									} else {
										if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "glib:boxed") == 0) {
											ValaSymbol* _tmp16_;
											sym = (_tmp16_ = (ValaSymbol*) vala_gir_parser_parse_boxed (self), _vala_code_node_unref0 (sym), _tmp16_);
										} else {
											if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "union") == 0) {
												ValaSymbol* _tmp17_;
												sym = (_tmp17_ = (ValaSymbol*) vala_gir_parser_parse_union (self), _vala_code_node_unref0 (sym), _tmp17_);
											} else {
												if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "constant") == 0) {
													ValaSymbol* _tmp18_;
													sym = (_tmp18_ = (ValaSymbol*) vala_gir_parser_parse_constant (self), _vala_code_node_unref0 (sym), _tmp18_);
												} else {
													char* _tmp20_;
													ValaSourceReference* _tmp19_;
													vala_report_error (_tmp19_ = vala_gir_parser_get_current_src (self), _tmp20_ = g_strdup_printf ("unknown child element `%s' in `namespace'", vala_markup_reader_get_name (self->priv->reader)));
													_g_free0 (_tmp20_);
													_vala_source_reference_unref0 (_tmp19_);
													_vala_code_node_unref0 (sym);
													break;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		if (VALA_IS_CLASS (sym)) {
			vala_namespace_add_class (ns, VALA_CLASS (sym));
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				vala_namespace_add_interface (ns, VALA_INTERFACE (sym));
			} else {
				if (VALA_IS_STRUCT (sym)) {
					vala_namespace_add_struct (ns, VALA_STRUCT (sym));
				} else {
					if (VALA_IS_ENUM (sym)) {
						vala_namespace_add_enum (ns, VALA_ENUM (sym));
					} else {
						if (VALA_IS_DELEGATE (sym)) {
							vala_namespace_add_delegate (ns, VALA_DELEGATE (sym));
						} else {
							if (VALA_IS_METHOD (sym)) {
								vala_namespace_add_method (ns, VALA_METHOD (sym));
							} else {
								if (VALA_IS_CONSTANT (sym)) {
									vala_namespace_add_constant (ns, VALA_CONSTANT (sym));
								} else {
									if (sym == NULL) {
										_vala_code_node_unref0 (sym);
										continue;
									}
								}
							}
						}
					}
				}
			}
		}
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) sym);
		_vala_code_node_unref0 (sym);
	}
	vala_gir_parser_end_element (self, "namespace");
	vala_gir_parser_postprocess_gtype_callbacks (self, ns);
	if (!new_namespace) {
		ValaNamespace* _tmp21_;
		ns = (_tmp21_ = NULL, _vala_code_node_unref0 (ns), _tmp21_);
	}
	result = ns;
	_g_free0 (namespace_name);
	_g_free0 (cprefix);
	return result;
}


static ValaStruct* vala_gir_parser_parse_alias (ValaGirParser* self) {
	ValaStruct* result;
	ValaSourceReference* _tmp1_;
	char* _tmp0_;
	ValaStruct* _tmp2_;
	ValaStruct* st;
	ValaDataType* _tmp4_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "alias");
	st = (_tmp2_ = vala_struct_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), _tmp1_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_struct_set_base_type (st, _tmp4_ = vala_gir_parser_parse_type_from_name (self, _tmp3_ = vala_markup_reader_get_attribute (self->priv->reader, "target")));
	_vala_code_node_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	vala_symbol_set_external ((ValaSymbol*) st, TRUE);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "alias");
	result = st;
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static ValaEnum* vala_gir_parser_parse_enumeration (ValaGirParser* self) {
	ValaEnum* result;
	ValaSourceReference* _tmp1_;
	char* _tmp0_;
	ValaEnum* _tmp2_;
	ValaEnum* en;
	char* enum_cname;
	char* common_prefix;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "enumeration");
	en = (_tmp2_ = vala_enum_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), _tmp1_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	enum_cname = vala_markup_reader_get_attribute (self->priv->reader, "c:type");
	if (enum_cname != NULL) {
		vala_enum_set_cname (en, enum_cname);
	}
	vala_gir_parser_next (self);
	common_prefix = NULL;
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "member") == 0) {
			ValaEnumValue* ev;
			char* cname;
			ev = vala_gir_parser_parse_enumeration_member (self);
			vala_enum_add_value (en, ev);
			cname = vala_enum_value_get_cname (ev);
			if (common_prefix == NULL) {
				char* _tmp3_;
				common_prefix = (_tmp3_ = g_strdup (cname), _g_free0 (common_prefix), _tmp3_);
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					char* _tmp5_;
					if (g_utf8_strlen (common_prefix, -1) > 0) {
						_tmp4_ = !g_str_has_suffix (common_prefix, "_");
					} else {
						_tmp4_ = FALSE;
					}
					if (!_tmp4_) {
						break;
					}
					common_prefix = (_tmp5_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp5_);
				}
			} else {
				while (TRUE) {
					char* _tmp6_;
					if (!(!g_str_has_prefix (cname, common_prefix))) {
						break;
					}
					common_prefix = (_tmp6_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp6_);
				}
			}
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				char* _tmp10_;
				if (g_utf8_strlen (common_prefix, -1) > 0) {
					gboolean _tmp8_ = FALSE;
					if (!g_str_has_suffix (common_prefix, "_")) {
						_tmp8_ = TRUE;
					} else {
						gboolean _tmp9_ = FALSE;
						if (g_unichar_isdigit (g_utf8_get_char (g_utf8_offset_to_pointer (cname, string_get_length (common_prefix))))) {
							_tmp9_ = (g_utf8_strlen (cname, -1) - g_utf8_strlen (common_prefix, -1)) <= 1;
						} else {
							_tmp9_ = FALSE;
						}
						_tmp8_ = _tmp9_;
					}
					_tmp7_ = _tmp8_;
				} else {
					_tmp7_ = FALSE;
				}
				if (!_tmp7_) {
					break;
				}
				common_prefix = (_tmp10_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp10_);
			}
			_vala_code_node_unref0 (ev);
			_g_free0 (cname);
		} else {
			break;
		}
	}
	vala_enum_set_cprefix (en, common_prefix);
	vala_gir_parser_end_element (self, "enumeration");
	result = en;
	_g_free0 (enum_cname);
	_g_free0 (common_prefix);
	return result;
}


static ValaEnum* vala_gir_parser_parse_bitfield (ValaGirParser* self) {
	ValaEnum* result;
	ValaSourceReference* _tmp1_;
	char* _tmp0_;
	ValaEnum* _tmp2_;
	ValaEnum* en;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "bitfield");
	en = (_tmp2_ = vala_enum_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), _tmp1_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "member") == 0) {
			ValaEnumValue* _tmp3_;
			vala_enum_add_value (en, _tmp3_ = vala_gir_parser_parse_enumeration_member (self));
			_vala_code_node_unref0 (_tmp3_);
		} else {
			break;
		}
	}
	vala_gir_parser_end_element (self, "bitfield");
	result = en;
	return result;
}


static ValaEnumValue* vala_gir_parser_parse_enumeration_member (ValaGirParser* self) {
	ValaEnumValue* result;
	char* _tmp4_;
	gint _tmp3__length1;
	char** _tmp3_;
	char** _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	ValaEnumValue* _tmp5_;
	ValaEnumValue* ev;
	char* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "member");
	ev = (_tmp5_ = vala_enum_value_new (_tmp4_ = g_strjoinv ("_", (_tmp3_ = _tmp2_ = g_strsplit (_tmp1_ = g_utf8_strup (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), -1), "-", 0), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)), NULL, NULL), _g_free0 (_tmp4_), _tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp5_);
	vala_enum_value_set_cname (ev, _tmp6_ = vala_markup_reader_get_attribute (self->priv->reader, "c:identifier"));
	_g_free0 (_tmp6_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "member");
	result = ev;
	return result;
}


static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self, char** ctype) {
	ValaDataType* result;
	char* transfer;
	char* allow_none;
	ValaDataType* _tmp0_;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	if (ctype != NULL) {
		*ctype = NULL;
	}
	vala_gir_parser_start_element (self, "return-value");
	transfer = vala_markup_reader_get_attribute (self->priv->reader, "transfer-ownership");
	allow_none = vala_markup_reader_get_attribute (self->priv->reader, "allow-none");
	vala_gir_parser_next (self);
	_tmp0_ = NULL;
	if ((ctype) != NULL) {
		ValaDataType* _tmp4_;
		char* _tmp3_;
		ValaDataType* _tmp2_;
		char* _tmp1_ = NULL;
		_tmp0_ = (_tmp4_ = (_tmp2_ = vala_gir_parser_parse_type (self, &_tmp1_, NULL), *ctype = (_tmp3_ = _tmp1_, _g_free0 (*ctype), _tmp3_), _tmp2_), _vala_code_node_unref0 (_tmp0_), _tmp4_);
	} else {
		ValaDataType* _tmp5_;
		_tmp0_ = (_tmp5_ = vala_gir_parser_parse_type (self, NULL, NULL), _vala_code_node_unref0 (_tmp0_), _tmp5_);
	}
	type = _vala_code_node_ref0 (_tmp0_);
	if (_vala_strcmp0 (transfer, "full") == 0) {
		vala_data_type_set_value_owned (type, TRUE);
	}
	if (_vala_strcmp0 (allow_none, "1") == 0) {
		vala_data_type_set_nullable (type, TRUE);
	}
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (transfer);
	_g_free0 (allow_none);
	_vala_code_node_unref0 (_tmp0_);
	return result;
}


static ValaFormalParameter* vala_gir_parser_parse_parameter (ValaGirParser* self, gint* array_length_idx, gint* closure_idx, gint* destroy_idx) {
	ValaFormalParameter* result;
	ValaFormalParameter* param;
	char* name;
	char* direction;
	char* transfer;
	char* allow_none;
	char* closure;
	char* destroy;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	param = NULL;
	if ((array_length_idx) != NULL) {
		*array_length_idx = -1;
	}
	if ((closure_idx) != NULL) {
		*closure_idx = -1;
	}
	if ((destroy_idx) != NULL) {
		*destroy_idx = -1;
	}
	vala_gir_parser_start_element (self, "parameter");
	name = vala_markup_reader_get_attribute (self->priv->reader, "name");
	direction = vala_markup_reader_get_attribute (self->priv->reader, "direction");
	transfer = vala_markup_reader_get_attribute (self->priv->reader, "transfer-ownership");
	allow_none = vala_markup_reader_get_attribute (self->priv->reader, "allow-none");
	closure = vala_markup_reader_get_attribute (self->priv->reader, "closure");
	destroy = vala_markup_reader_get_attribute (self->priv->reader, "destroy");
	if (closure != NULL) {
		_tmp0_ = (closure_idx) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		*closure_idx = atoi (closure);
	}
	if (destroy != NULL) {
		_tmp1_ = (destroy_idx) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		*destroy_idx = atoi (destroy);
	}
	vala_gir_parser_next (self);
	if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "varargs") == 0) {
		ValaFormalParameter* _tmp3_;
		ValaSourceReference* _tmp2_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		param = (_tmp3_ = vala_formal_parameter_new_with_ellipsis (_tmp2_ = vala_gir_parser_get_current_src (self)), _vala_code_node_unref0 (param), _tmp3_);
		_vala_source_reference_unref0 (_tmp2_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		ValaDataType* type;
		ValaFormalParameter* _tmp5_;
		ValaSourceReference* _tmp4_;
		type = vala_gir_parser_parse_type (self, NULL, array_length_idx);
		if (_vala_strcmp0 (transfer, "full") == 0) {
			vala_data_type_set_value_owned (type, TRUE);
		}
		if (_vala_strcmp0 (allow_none, "1") == 0) {
			vala_data_type_set_nullable (type, TRUE);
		}
		param = (_tmp5_ = vala_formal_parameter_new (name, type, _tmp4_ = vala_gir_parser_get_current_src (self)), _vala_code_node_unref0 (param), _tmp5_);
		_vala_source_reference_unref0 (_tmp4_);
		if (_vala_strcmp0 (direction, "out") == 0) {
			vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			if (_vala_strcmp0 (direction, "inout") == 0) {
				vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_vala_code_node_unref0 (type);
	}
	vala_gir_parser_end_element (self, "parameter");
	result = param;
	_g_free0 (name);
	_g_free0 (direction);
	_g_free0 (transfer);
	_g_free0 (allow_none);
	_g_free0 (closure);
	_g_free0 (destroy);
	return result;
}


static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self, char** ctype, gint* array_length_index) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (ctype != NULL) {
		*ctype = NULL;
	}
	if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "array") == 0) {
		gboolean _tmp0_ = FALSE;
		char* _tmp1_;
		gboolean _tmp2_;
		ValaDataType* element_type;
		vala_gir_parser_start_element (self, "array");
		if ((_tmp2_ = (_tmp1_ = vala_markup_reader_get_attribute (self->priv->reader, "length")) != NULL, _g_free0 (_tmp1_), _tmp2_)) {
			_tmp0_ = (array_length_index) != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			char* _tmp3_;
			*array_length_index = atoi (_tmp3_ = vala_markup_reader_get_attribute (self->priv->reader, "length"));
			_g_free0 (_tmp3_);
		}
		vala_gir_parser_next (self);
		element_type = vala_gir_parser_parse_type (self, NULL, NULL);
		vala_gir_parser_end_element (self, "array");
		result = (ValaDataType*) vala_array_type_new (element_type, 1, NULL);
		_vala_code_node_unref0 (element_type);
		return result;
	} else {
		char* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* type;
		vala_gir_parser_start_element (self, "type");
		type = (_tmp5_ = vala_gir_parser_parse_type_from_name (self, _tmp4_ = vala_markup_reader_get_attribute (self->priv->reader, "name")), _g_free0 (_tmp4_), _tmp5_);
		if ((ctype) != NULL) {
			char* _tmp6_;
			*ctype = (_tmp6_ = vala_markup_reader_get_attribute (self->priv->reader, "c:type"), _g_free0 (*ctype), _tmp6_);
		}
		vala_gir_parser_next (self);
		while (TRUE) {
			ValaDataType* _tmp7_;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp7_ = vala_gir_parser_parse_type (self, NULL, NULL);
			_vala_code_node_unref0 (_tmp7_);
		}
		vala_gir_parser_end_element (self, "type");
		result = type;
		return result;
	}
}


static ValaDataType* vala_gir_parser_parse_type_from_name (ValaGirParser* self, const char* type_name) {
	ValaDataType* result;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	type = NULL;
	if (_vala_strcmp0 (type_name, "none") == 0) {
		ValaDataType* _tmp0_;
		type = (_tmp0_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (type), _tmp0_);
	} else {
		if (_vala_strcmp0 (type_name, "any") == 0) {
			ValaDataType* _tmp2_;
			ValaVoidType* _tmp1_;
			type = (_tmp2_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp1_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (type), _tmp2_);
			_vala_code_node_unref0 (_tmp1_);
		} else {
			if (_vala_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaDataType* _tmp5_;
				ValaUnresolvedType* _tmp4_;
				ValaUnresolvedSymbol* _tmp3_;
				type = (_tmp5_ = (ValaDataType*) vala_array_type_new ((ValaDataType*) (_tmp4_ = vala_unresolved_type_new_from_symbol (_tmp3_ = vala_unresolved_symbol_new (NULL, "string", NULL), NULL)), 1, NULL), _vala_code_node_unref0 (type), _tmp5_);
				_vala_code_node_unref0 (_tmp4_);
				_vala_code_node_unref0 (_tmp3_);
			} else {
				char** _tmp7_;
				gint type_components_size;
				gint type_components_length1;
				char** _tmp6_;
				char** type_components;
				if (_vala_strcmp0 (type_name, "utf8") == 0) {
					type_name = "string";
				} else {
					if (_vala_strcmp0 (type_name, "boolean") == 0) {
						type_name = "bool";
					} else {
						if (_vala_strcmp0 (type_name, "GLib.offset") == 0) {
							type_name = "int64";
						} else {
							if (_vala_strcmp0 (type_name, "GType") == 0) {
								type_name = "GLib.Type";
							} else {
								if (_vala_strcmp0 (type_name, "GObject.String") == 0) {
									type_name = "GLib.StringBuilder";
								} else {
									if (_vala_strcmp0 (type_name, "GObject.Class") == 0) {
										type_name = "GLib.ObjectClass";
									} else {
										if (_vala_strcmp0 (type_name, "GLib.unichar") == 0) {
											type_name = "unichar";
										} else {
											if (_vala_strcmp0 (type_name, "GLib.Data") == 0) {
												type_name = "GLib.Datalist";
											}
										}
									}
								}
							}
						}
					}
				}
				type_components = (_tmp7_ = _tmp6_ = g_strsplit (type_name, ".", 0), type_components_length1 = _vala_array_length (_tmp6_), type_components_size = type_components_length1, _tmp7_);
				if (type_components[1] != NULL) {
					char* namespace_name;
					char* transformed_type_name;
					ValaDataType* _tmp10_;
					ValaUnresolvedSymbol* _tmp9_;
					ValaUnresolvedSymbol* _tmp8_;
					namespace_name = vala_gir_parser_transform_namespace_name (self, type_components[0]);
					transformed_type_name = g_strdup (type_components[1]);
					type = (_tmp10_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (_tmp9_ = vala_unresolved_symbol_new (_tmp8_ = vala_unresolved_symbol_new (NULL, namespace_name, NULL), transformed_type_name, NULL), NULL), _vala_code_node_unref0 (type), _tmp10_);
					_vala_code_node_unref0 (_tmp9_);
					_vala_code_node_unref0 (_tmp8_);
					_g_free0 (namespace_name);
					_g_free0 (transformed_type_name);
				} else {
					ValaDataType* _tmp12_;
					ValaUnresolvedSymbol* _tmp11_;
					type = (_tmp12_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (_tmp11_ = vala_unresolved_symbol_new (NULL, type_name, NULL), NULL), _vala_code_node_unref0 (type), _tmp12_);
					_vala_code_node_unref0 (_tmp11_);
				}
				type_components = (_vala_array_free (type_components, type_components_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = type;
	return result;
}


static char* vala_gir_parser_transform_namespace_name (ValaGirParser* self, const char* gir_module_name) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_module_name != NULL, NULL);
	if (_vala_strcmp0 (gir_module_name, "GObject") == 0) {
		result = g_strdup ("GLib");
		return result;
	} else {
		if (_vala_strcmp0 (gir_module_name, "Gio") == 0) {
			result = g_strdup ("GLib");
			return result;
		} else {
			if (_vala_strcmp0 (gir_module_name, "GModule") == 0) {
				result = g_strdup ("GLib");
				return result;
			}
		}
	}
	result = g_strdup (gir_module_name);
	return result;
}


static ValaStruct* vala_gir_parser_parse_record (ValaGirParser* self) {
	ValaStruct* result;
	ValaSourceReference* _tmp1_;
	char* _tmp0_;
	ValaStruct* _tmp2_;
	ValaStruct* st;
	char* glib_is_gtype_struct_for;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "record");
	st = (_tmp2_ = vala_struct_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), _tmp1_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	vala_symbol_set_external ((ValaSymbol*) st, TRUE);
	glib_is_gtype_struct_for = vala_markup_reader_get_attribute (self->priv->reader, "glib:is-gtype-struct-for");
	vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "field") == 0) {
			ValaField* _tmp3_;
			vala_struct_add_field (st, _tmp3_ = vala_gir_parser_parse_field (self));
			_vala_code_node_unref0 (_tmp3_);
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "callback") == 0) {
				if (glib_is_gtype_struct_for != NULL) {
					GeeArrayList* callbacks;
					ValaMethod* _tmp5_;
					callbacks = (GeeArrayList*) gee_map_get ((GeeMap*) self->priv->gtype_callbacks, glib_is_gtype_struct_for);
					if (callbacks == NULL) {
						GeeArrayList* _tmp4_;
						callbacks = (_tmp4_ = gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _gee_collection_object_unref0 (callbacks), _tmp4_);
						gee_map_set ((GeeMap*) self->priv->gtype_callbacks, glib_is_gtype_struct_for, callbacks);
					}
					gee_collection_add ((GeeCollection*) callbacks, _tmp5_ = vala_gir_parser_parse_method (self, "callback"));
					_vala_code_node_unref0 (_tmp5_);
					_gee_collection_object_unref0 (callbacks);
				} else {
					ValaDelegate* _tmp6_;
					_tmp6_ = vala_gir_parser_parse_callback (self);
					_vala_code_node_unref0 (_tmp6_);
				}
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "constructor") == 0) {
					ValaMethod* _tmp7_;
					_tmp7_ = vala_gir_parser_parse_constructor (self, NULL);
					_vala_code_node_unref0 (_tmp7_);
				} else {
					if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "method") == 0) {
						ValaMethod* _tmp8_;
						vala_struct_add_method (st, _tmp8_ = vala_gir_parser_parse_method (self, "method"));
						_vala_code_node_unref0 (_tmp8_);
					} else {
						if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "union") == 0) {
							ValaStruct* s;
							GeeList* s_fields;
							s = vala_gir_parser_parse_union (self);
							s_fields = vala_struct_get_fields (s);
							{
								GeeIterator* _f_it;
								_f_it = gee_iterable_iterator ((GeeIterable*) s_fields);
								while (TRUE) {
									ValaField* f;
									char* _tmp12_;
									char* _tmp11_;
									char* _tmp10_;
									char* _tmp9_;
									char* _tmp14_;
									char* _tmp13_;
									if (!gee_iterator_next (_f_it)) {
										break;
									}
									f = (ValaField*) gee_iterator_get (_f_it);
									vala_field_set_cname (f, _tmp12_ = g_strconcat (_tmp10_ = g_strconcat (_tmp9_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) s, FALSE), ".", NULL), _tmp11_ = vala_field_get_cname (f), NULL));
									_g_free0 (_tmp12_);
									_g_free0 (_tmp11_);
									_g_free0 (_tmp10_);
									_g_free0 (_tmp9_);
									vala_symbol_set_name ((ValaSymbol*) f, _tmp14_ = g_strconcat (_tmp13_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) s), "_", NULL), vala_symbol_get_name ((ValaSymbol*) f), NULL));
									_g_free0 (_tmp14_);
									_g_free0 (_tmp13_);
									vala_struct_add_field (st, f);
									_vala_code_node_unref0 (f);
								}
								_gee_collection_object_unref0 (_f_it);
							}
							_vala_code_node_unref0 (s);
							_gee_collection_object_unref0 (s_fields);
						} else {
							char* _tmp16_;
							ValaSourceReference* _tmp15_;
							vala_report_error (_tmp15_ = vala_gir_parser_get_current_src (self), _tmp16_ = g_strdup_printf ("unknown child element `%s' in `record'", vala_markup_reader_get_name (self->priv->reader)));
							_g_free0 (_tmp16_);
							_vala_source_reference_unref0 (_tmp15_);
							break;
						}
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "record");
	result = st;
	_g_free0 (glib_is_gtype_struct_for);
	return result;
}


static void vala_gir_parser_postprocess_gtype_callbacks (ValaGirParser* self, ValaNamespace* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _gtype_name_it;
		_gtype_name_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->gtype_callbacks))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			char* gtype_name;
			ValaSymbol* _tmp2_;
			ValaObjectTypeSymbol* gtype;
			GeeArrayList* callbacks;
			if (!gee_iterator_next (_gtype_name_it)) {
				break;
			}
			gtype_name = (char*) gee_iterator_get (_gtype_name_it);
			gtype = (_tmp2_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), gtype_name), VALA_IS_OBJECT_TYPE_SYMBOL (_tmp2_) ? ((ValaObjectTypeSymbol*) _tmp2_) : NULL);
			callbacks = (GeeArrayList*) gee_map_get ((GeeMap*) self->priv->gtype_callbacks, gtype_name);
			{
				GeeIterator* _m_it;
				_m_it = gee_iterable_iterator ((GeeIterable*) callbacks);
				while (TRUE) {
					ValaMethod* m;
					ValaSymbol* symbol;
					if (!gee_iterator_next (_m_it)) {
						break;
					}
					m = (ValaMethod*) gee_iterator_get (_m_it);
					symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) gtype), vala_symbol_get_name ((ValaSymbol*) m));
					if (symbol == NULL) {
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (symbol);
						continue;
					} else {
						if (VALA_IS_METHOD (symbol)) {
							ValaMethod* meth;
							meth = _vala_code_node_ref0 (VALA_METHOD (symbol));
							if (VALA_IS_CLASS (gtype)) {
								vala_method_set_is_virtual (meth, TRUE);
							} else {
								if (VALA_IS_INTERFACE (gtype)) {
									vala_method_set_is_abstract (meth, TRUE);
								}
							}
							_vala_code_node_unref0 (meth);
						} else {
							if (VALA_IS_SIGNAL (symbol)) {
								ValaSignal* sig;
								sig = _vala_code_node_ref0 (VALA_SIGNAL (symbol));
								vala_signal_set_is_virtual (sig, TRUE);
								_vala_code_node_unref0 (sig);
							} else {
								char* _tmp4_;
								ValaSourceReference* _tmp3_;
								vala_report_error (_tmp3_ = vala_gir_parser_get_current_src (self), _tmp4_ = g_strdup_printf ("unknown member type `%s' in `%s'", vala_symbol_get_name ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) gtype)));
								_g_free0 (_tmp4_);
								_vala_source_reference_unref0 (_tmp3_);
							}
						}
					}
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (symbol);
				}
				_gee_collection_object_unref0 (_m_it);
			}
			_g_free0 (gtype_name);
			_vala_code_node_unref0 (gtype);
			_gee_collection_object_unref0 (callbacks);
		}
		_gee_collection_object_unref0 (_gtype_name_it);
	}
}


static ValaClass* vala_gir_parser_parse_class (ValaGirParser* self) {
	ValaClass* result;
	ValaSourceReference* _tmp1_;
	char* _tmp0_;
	ValaClass* _tmp2_;
	ValaClass* cl;
	char* cname;
	char* parent;
	GeeArrayList* signals;
	GeeArrayList* methods;
	GeeArrayList* vmethods;
	GeeArrayList* fields;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "class");
	cl = (_tmp2_ = vala_class_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), _tmp1_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_external ((ValaSymbol*) cl, TRUE);
	cname = vala_markup_reader_get_attribute (self->priv->reader, "c:type");
	if (cname != NULL) {
		vala_class_set_cname (cl, cname);
	}
	parent = vala_markup_reader_get_attribute (self->priv->reader, "parent");
	if (parent != NULL) {
		ValaDataType* _tmp3_;
		vala_class_add_base_type (cl, _tmp3_ = vala_gir_parser_parse_type_from_name (self, parent));
		_vala_code_node_unref0 (_tmp3_);
	}
	vala_gir_parser_next (self);
	signals = gee_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	methods = gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	vmethods = gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	fields = gee_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "implements") == 0) {
			ValaDataType* _tmp5_;
			char* _tmp4_;
			vala_gir_parser_start_element (self, "implements");
			vala_class_add_base_type (cl, _tmp5_ = vala_gir_parser_parse_type_from_name (self, _tmp4_ = vala_markup_reader_get_attribute (self->priv->reader, "name")));
			_vala_code_node_unref0 (_tmp5_);
			_g_free0 (_tmp4_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "constant") == 0) {
				ValaConstant* _tmp6_;
				vala_class_add_constant (cl, _tmp6_ = vala_gir_parser_parse_constant (self));
				_vala_code_node_unref0 (_tmp6_);
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "field") == 0) {
					ValaField* _tmp7_;
					gee_collection_add ((GeeCollection*) fields, _tmp7_ = vala_gir_parser_parse_field (self));
					_vala_code_node_unref0 (_tmp7_);
				} else {
					if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "property") == 0) {
						ValaProperty* _tmp8_;
						vala_class_add_property (cl, _tmp8_ = vala_gir_parser_parse_property (self));
						_vala_code_node_unref0 (_tmp8_);
					} else {
						if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "constructor") == 0) {
							ValaMethod* _tmp9_;
							vala_class_add_method (cl, _tmp9_ = vala_gir_parser_parse_constructor (self, cname));
							_vala_code_node_unref0 (_tmp9_);
						} else {
							if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "function") == 0) {
								ValaMethod* _tmp10_;
								gee_collection_add ((GeeCollection*) methods, _tmp10_ = vala_gir_parser_parse_method (self, "function"));
								_vala_code_node_unref0 (_tmp10_);
							} else {
								if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "method") == 0) {
									ValaMethod* _tmp11_;
									gee_collection_add ((GeeCollection*) methods, _tmp11_ = vala_gir_parser_parse_method (self, "method"));
									_vala_code_node_unref0 (_tmp11_);
								} else {
									if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "virtual-method") == 0) {
										ValaMethod* _tmp12_;
										gee_collection_add ((GeeCollection*) vmethods, _tmp12_ = vala_gir_parser_parse_method (self, "virtual-method"));
										_vala_code_node_unref0 (_tmp12_);
									} else {
										if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "union") == 0) {
											ValaStruct* s;
											GeeList* s_fields;
											s = vala_gir_parser_parse_union (self);
											s_fields = vala_struct_get_fields (s);
											{
												GeeIterator* _f_it;
												_f_it = gee_iterable_iterator ((GeeIterable*) s_fields);
												while (TRUE) {
													ValaField* f;
													char* _tmp16_;
													char* _tmp15_;
													char* _tmp14_;
													char* _tmp13_;
													char* _tmp18_;
													char* _tmp17_;
													if (!gee_iterator_next (_f_it)) {
														break;
													}
													f = (ValaField*) gee_iterator_get (_f_it);
													vala_field_set_cname (f, _tmp16_ = g_strconcat (_tmp14_ = g_strconcat (_tmp13_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) s, FALSE), ".", NULL), _tmp15_ = vala_field_get_cname (f), NULL));
													_g_free0 (_tmp16_);
													_g_free0 (_tmp15_);
													_g_free0 (_tmp14_);
													_g_free0 (_tmp13_);
													vala_symbol_set_name ((ValaSymbol*) f, _tmp18_ = g_strconcat (_tmp17_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) s), "_", NULL), vala_symbol_get_name ((ValaSymbol*) f), NULL));
													_g_free0 (_tmp18_);
													_g_free0 (_tmp17_);
													gee_collection_add ((GeeCollection*) fields, f);
													_vala_code_node_unref0 (f);
												}
												_gee_collection_object_unref0 (_f_it);
											}
											_vala_code_node_unref0 (s);
											_gee_collection_object_unref0 (s_fields);
										} else {
											if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "glib:signal") == 0) {
												ValaSignal* _tmp19_;
												gee_collection_add ((GeeCollection*) signals, _tmp19_ = vala_gir_parser_parse_signal (self));
												_vala_code_node_unref0 (_tmp19_);
											} else {
												char* _tmp21_;
												ValaSourceReference* _tmp20_;
												vala_report_error (_tmp20_ = vala_gir_parser_get_current_src (self), _tmp21_ = g_strdup_printf ("unknown child element `%s' in `class'", vala_markup_reader_get_name (self->priv->reader)));
												_g_free0 (_tmp21_);
												_vala_source_reference_unref0 (_tmp20_);
												break;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		GeeIterator* _sig_it;
		_sig_it = gee_iterable_iterator ((GeeIterable*) signals);
		while (TRUE) {
			ValaSignal* sig;
			ValaSymbol* symbol;
			if (!gee_iterator_next (_sig_it)) {
				break;
			}
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) cl), vala_symbol_get_name ((ValaSymbol*) sig));
			if (symbol == NULL) {
				vala_class_add_signal (cl, sig);
			} else {
				if (VALA_IS_PROPERTY (symbol)) {
				} else {
					char* _tmp23_;
					ValaSourceReference* _tmp22_;
					vala_report_error (_tmp22_ = vala_gir_parser_get_current_src (self), _tmp23_ = g_strdup_printf ("duplicate member `%s' in `%s'", vala_symbol_get_name ((ValaSymbol*) sig), vala_symbol_get_name ((ValaSymbol*) cl)));
					_g_free0 (_tmp23_);
					_vala_source_reference_unref0 (_tmp22_);
				}
			}
			_vala_code_node_unref0 (sig);
			_vala_code_node_unref0 (symbol);
		}
		_gee_collection_object_unref0 (_sig_it);
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) vmethods);
		while (TRUE) {
			ValaMethod* m;
			ValaSymbol* symbol;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) cl), vala_symbol_get_name ((ValaSymbol*) m));
			if (symbol == NULL) {
				vala_class_add_method (cl, m);
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					ValaSignal* sig;
					sig = _vala_code_node_ref0 (VALA_SIGNAL (symbol));
					vala_signal_set_is_virtual (sig, TRUE);
					_vala_code_node_unref0 (sig);
				} else {
					gboolean _tmp24_ = FALSE;
					if (VALA_IS_PROPERTY (symbol)) {
						_tmp24_ = TRUE;
					} else {
						_tmp24_ = VALA_IS_FIELD (symbol);
					}
					if (_tmp24_) {
					} else {
						char* _tmp26_;
						ValaSourceReference* _tmp25_;
						vala_report_error (_tmp25_ = vala_gir_parser_get_current_src (self), _tmp26_ = g_strdup_printf ("duplicate member `%s' in `%s'", vala_symbol_get_name ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) cl)));
						_g_free0 (_tmp26_);
						_vala_source_reference_unref0 (_tmp25_);
					}
				}
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (symbol);
		}
		_gee_collection_object_unref0 (_m_it);
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) methods);
		while (TRUE) {
			ValaMethod* m;
			ValaSymbol* symbol;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) cl), vala_symbol_get_name ((ValaSymbol*) m));
			if (symbol == NULL) {
				vala_class_add_method (cl, m);
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					ValaSignal* sig;
					sig = _vala_code_node_ref0 (VALA_SIGNAL (symbol));
					vala_signal_set_has_emitter (sig, TRUE);
					_vala_code_node_unref0 (sig);
				} else {
					gboolean _tmp27_ = FALSE;
					if (VALA_IS_PROPERTY (symbol)) {
						_tmp27_ = TRUE;
					} else {
						_tmp27_ = VALA_IS_FIELD (symbol);
					}
					if (_tmp27_) {
					} else {
						if (VALA_IS_METHOD (symbol)) {
						} else {
							char* _tmp29_;
							ValaSourceReference* _tmp28_;
							vala_report_error (_tmp28_ = vala_gir_parser_get_current_src (self), _tmp29_ = g_strdup_printf ("duplicate member `%s' in `%s'", vala_symbol_get_name ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) cl)));
							_g_free0 (_tmp29_);
							_vala_source_reference_unref0 (_tmp28_);
						}
					}
				}
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (symbol);
		}
		_gee_collection_object_unref0 (_m_it);
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) fields);
		while (TRUE) {
			ValaField* f;
			ValaSymbol* symbol;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) cl), vala_symbol_get_name ((ValaSymbol*) f));
			if (symbol == NULL) {
				vala_class_add_field (cl, f);
			}
			_vala_code_node_unref0 (f);
			_vala_code_node_unref0 (symbol);
		}
		_gee_collection_object_unref0 (_f_it);
	}
	vala_gir_parser_end_element (self, "class");
	result = cl;
	_g_free0 (cname);
	_g_free0 (parent);
	_gee_collection_object_unref0 (signals);
	_gee_collection_object_unref0 (methods);
	_gee_collection_object_unref0 (vmethods);
	_gee_collection_object_unref0 (fields);
	return result;
}


static ValaInterface* vala_gir_parser_parse_interface (ValaGirParser* self) {
	ValaInterface* result;
	ValaSourceReference* _tmp1_;
	char* _tmp0_;
	ValaInterface* _tmp2_;
	ValaInterface* iface;
	char* cname;
	GeeArrayList* methods;
	GeeArrayList* vmethods;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "interface");
	iface = (_tmp2_ = vala_interface_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), _tmp1_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_external ((ValaSymbol*) iface, TRUE);
	cname = vala_markup_reader_get_attribute (self->priv->reader, "c:type");
	if (cname != NULL) {
		vala_interface_set_cname (iface, cname);
	}
	vala_gir_parser_next (self);
	methods = gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	vmethods = gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "prerequisite") == 0) {
			ValaDataType* _tmp4_;
			char* _tmp3_;
			vala_gir_parser_start_element (self, "prerequisite");
			vala_interface_add_prerequisite (iface, _tmp4_ = vala_gir_parser_parse_type_from_name (self, _tmp3_ = vala_markup_reader_get_attribute (self->priv->reader, "name")));
			_vala_code_node_unref0 (_tmp4_);
			_g_free0 (_tmp3_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "field") == 0) {
				ValaField* _tmp5_;
				_tmp5_ = vala_gir_parser_parse_field (self);
				_vala_code_node_unref0 (_tmp5_);
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "property") == 0) {
					ValaProperty* _tmp6_;
					vala_interface_add_property (iface, _tmp6_ = vala_gir_parser_parse_property (self));
					_vala_code_node_unref0 (_tmp6_);
				} else {
					if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "virtual-method") == 0) {
						ValaMethod* _tmp7_;
						gee_collection_add ((GeeCollection*) vmethods, _tmp7_ = vala_gir_parser_parse_method (self, "virtual-method"));
						_vala_code_node_unref0 (_tmp7_);
					} else {
						if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "function") == 0) {
							ValaMethod* _tmp8_;
							gee_collection_add ((GeeCollection*) methods, _tmp8_ = vala_gir_parser_parse_method (self, "function"));
							_vala_code_node_unref0 (_tmp8_);
						} else {
							if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "method") == 0) {
								ValaMethod* _tmp9_;
								gee_collection_add ((GeeCollection*) methods, _tmp9_ = vala_gir_parser_parse_method (self, "method"));
								_vala_code_node_unref0 (_tmp9_);
							} else {
								if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "glib:signal") == 0) {
									ValaSignal* _tmp10_;
									vala_interface_add_signal (iface, _tmp10_ = vala_gir_parser_parse_signal (self));
									_vala_code_node_unref0 (_tmp10_);
								} else {
									char* _tmp12_;
									ValaSourceReference* _tmp11_;
									vala_report_error (_tmp11_ = vala_gir_parser_get_current_src (self), _tmp12_ = g_strdup_printf ("unknown child element `%s' in `interface'", vala_markup_reader_get_name (self->priv->reader)));
									_g_free0 (_tmp12_);
									_vala_source_reference_unref0 (_tmp11_);
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) vmethods);
		while (TRUE) {
			ValaMethod* m;
			ValaSymbol* symbol;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m));
			if (symbol == NULL) {
				vala_interface_add_method (iface, m);
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					ValaSignal* sig;
					sig = _vala_code_node_ref0 (VALA_SIGNAL (symbol));
					vala_signal_set_is_virtual (sig, TRUE);
					_vala_code_node_unref0 (sig);
				} else {
					char* _tmp14_;
					ValaSourceReference* _tmp13_;
					vala_report_error (_tmp13_ = vala_gir_parser_get_current_src (self), _tmp14_ = g_strdup_printf ("duplicate member `%s' in `%s'", vala_symbol_get_name ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) iface)));
					_g_free0 (_tmp14_);
					_vala_source_reference_unref0 (_tmp13_);
				}
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (symbol);
		}
		_gee_collection_object_unref0 (_m_it);
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) methods);
		while (TRUE) {
			ValaMethod* m;
			ValaSymbol* symbol;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			symbol = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m));
			if (symbol == NULL) {
				vala_interface_add_method (iface, m);
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					ValaSignal* sig;
					sig = _vala_code_node_ref0 (VALA_SIGNAL (symbol));
					vala_signal_set_has_emitter (sig, TRUE);
					_vala_code_node_unref0 (sig);
				} else {
					if (VALA_IS_METHOD (symbol)) {
					} else {
						char* _tmp16_;
						ValaSourceReference* _tmp15_;
						vala_report_error (_tmp15_ = vala_gir_parser_get_current_src (self), _tmp16_ = g_strdup_printf ("duplicate member `%s' in `%s'", vala_symbol_get_name ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) iface)));
						_g_free0 (_tmp16_);
						_vala_source_reference_unref0 (_tmp15_);
					}
				}
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (symbol);
		}
		_gee_collection_object_unref0 (_m_it);
	}
	vala_gir_parser_end_element (self, "interface");
	result = iface;
	_g_free0 (cname);
	_gee_collection_object_unref0 (methods);
	_gee_collection_object_unref0 (vmethods);
	return result;
}


static ValaField* vala_gir_parser_parse_field (ValaGirParser* self) {
	ValaField* result;
	char* name;
	char* allow_none;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaField* _tmp1_;
	ValaField* field;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "field");
	name = vala_markup_reader_get_attribute (self->priv->reader, "name");
	allow_none = vala_markup_reader_get_attribute (self->priv->reader, "allow-none");
	vala_gir_parser_next (self);
	type = vala_gir_parser_parse_type (self, NULL, NULL);
	field = (_tmp1_ = vala_field_new (name, type, NULL, _tmp0_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp0_), _tmp1_);
	vala_symbol_set_access ((ValaSymbol*) field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (_vala_strcmp0 (allow_none, "1") == 0) {
		vala_data_type_set_nullable (type, TRUE);
	}
	vala_gir_parser_end_element (self, "field");
	result = field;
	_g_free0 (name);
	_g_free0 (allow_none);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self) {
	ValaProperty* result;
	gint _tmp2__length1;
	char** _tmp2_;
	char** _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	char* name;
	char* readable;
	char* writable;
	char* construct_;
	char* construct_only;
	ValaDataType* type;
	ValaSourceReference* _tmp4_;
	ValaProperty* _tmp5_;
	ValaProperty* prop;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	name = (_tmp3_ = g_strjoinv ("_", (_tmp2_ = _tmp1_ = g_strsplit (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), "-", 0), _tmp2__length1 = _vala_array_length (_tmp1_), _tmp2_)), _tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL), _g_free0 (_tmp0_), _tmp3_);
	readable = vala_markup_reader_get_attribute (self->priv->reader, "readable");
	writable = vala_markup_reader_get_attribute (self->priv->reader, "writable");
	construct_ = vala_markup_reader_get_attribute (self->priv->reader, "construct");
	construct_only = vala_markup_reader_get_attribute (self->priv->reader, "construct-only");
	vala_gir_parser_next (self);
	type = vala_gir_parser_parse_type (self, NULL, NULL);
	prop = (_tmp5_ = vala_property_new (name, type, NULL, NULL, _tmp4_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp4_), _tmp5_);
	vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (_vala_strcmp0 (readable, "0") != 0) {
		ValaPropertyAccessor* _tmp7_;
		ValaDataType* _tmp6_;
		vala_property_set_get_accessor (prop, _tmp7_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp6_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, NULL));
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp6_);
	}
	if (_vala_strcmp0 (writable, "1") == 0) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = _vala_strcmp0 (construct_only, "1") == 0;
	}
	if (_tmp8_) {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaPropertyAccessor* _tmp12_;
		ValaDataType* _tmp11_;
		if (_vala_strcmp0 (construct_only, "1") != 0) {
			_tmp9_ = _vala_strcmp0 (writable, "1") == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_vala_strcmp0 (construct_only, "1") == 0) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = _vala_strcmp0 (construct_, "1") == 0;
		}
		vala_property_set_set_accessor (prop, _tmp12_ = vala_property_accessor_new (FALSE, _tmp9_, _tmp10_, _tmp11_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, NULL));
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp11_);
	}
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_g_free0 (name);
	_g_free0 (readable);
	_g_free0 (writable);
	_g_free0 (construct_);
	_g_free0 (construct_only);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaDelegate* vala_gir_parser_parse_callback (ValaGirParser* self) {
	ValaDelegate* result;
	char* name;
	ValaDataType* return_type;
	gboolean _tmp0_ = FALSE;
	ValaSourceReference* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaDelegate* d;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "callback");
	name = vala_markup_reader_get_attribute (self->priv->reader, "name");
	vala_gir_parser_next (self);
	return_type = NULL;
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "return-value") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDataType* _tmp1_;
		return_type = (_tmp1_ = vala_gir_parser_parse_return_value (self, NULL), _vala_code_node_unref0 (return_type), _tmp1_);
	} else {
		ValaDataType* _tmp2_;
		return_type = (_tmp2_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (return_type), _tmp2_);
	}
	d = (_tmp4_ = vala_delegate_new (name, return_type, _tmp3_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp3_), _tmp4_);
	vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp5_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "parameters") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		while (TRUE) {
			ValaFormalParameter* _tmp6_;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			vala_delegate_add_parameter (d, _tmp6_ = vala_gir_parser_parse_parameter (self, NULL, NULL, NULL));
			_vala_code_node_unref0 (_tmp6_);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	vala_gir_parser_end_element (self, "callback");
	result = d;
	_g_free0 (name);
	_vala_code_node_unref0 (return_type);
	return result;
}


static ValaMethod* vala_gir_parser_parse_constructor (ValaGirParser* self, const char* parent_ctype) {
	ValaMethod* result;
	char* name;
	char* throws_string;
	char* ctype;
	ValaDataType* _tmp3_;
	char* _tmp2_;
	ValaDataType* _tmp1_;
	char* _tmp0_ = NULL;
	ValaSourceReference* _tmp4_;
	ValaCreationMethod* _tmp5_;
	ValaCreationMethod* m;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "constructor");
	name = vala_markup_reader_get_attribute (self->priv->reader, "name");
	throws_string = vala_markup_reader_get_attribute (self->priv->reader, "throws");
	vala_gir_parser_next (self);
	ctype = NULL;
	_tmp3_ = (_tmp1_ = vala_gir_parser_parse_return_value (self, &_tmp0_), ctype = (_tmp2_ = _tmp0_, _g_free0 (ctype), _tmp2_), _tmp1_);
	_vala_code_node_unref0 (_tmp3_);
	m = (_tmp5_ = vala_creation_method_new (NULL, name, _tmp4_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp4_), _tmp5_);
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_method_set_has_construct_function ((ValaMethod*) m, FALSE);
	if (ctype != NULL) {
		gboolean _tmp7_ = FALSE;
		if (parent_ctype == NULL) {
			_tmp7_ = TRUE;
		} else {
			char* _tmp8_;
			_tmp7_ = _vala_strcmp0 (ctype, _tmp8_ = g_strconcat (parent_ctype, "*", NULL)) != 0;
			_g_free0 (_tmp8_);
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		vala_creation_method_set_custom_return_type_cname (m, ctype);
	}
	if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) m), "new_")) {
		vala_symbol_set_name ((ValaSymbol*) m, g_utf8_offset_to_pointer (vala_symbol_get_name ((ValaSymbol*) m), g_utf8_strlen ("new_", -1)));
	}
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp9_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "parameters") == 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		while (TRUE) {
			ValaFormalParameter* _tmp10_;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			vala_method_add_parameter ((ValaMethod*) m, _tmp10_ = vala_gir_parser_parse_parameter (self, NULL, NULL, NULL));
			_vala_code_node_unref0 (_tmp10_);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	if (_vala_strcmp0 (throws_string, "1") == 0) {
		ValaErrorType* _tmp11_;
		vala_code_node_add_error_type ((ValaCodeNode*) m, (ValaDataType*) (_tmp11_ = vala_error_type_new (NULL, NULL, NULL)));
		_vala_code_node_unref0 (_tmp11_);
	}
	vala_gir_parser_end_element (self, "constructor");
	result = (ValaMethod*) m;
	_g_free0 (name);
	_g_free0 (throws_string);
	_g_free0 (ctype);
	return result;
}


static ValaMethod* vala_gir_parser_parse_method (ValaGirParser* self, const char* element_name) {
	ValaMethod* result;
	char* name;
	char* throws_string;
	char* invoker;
	ValaDataType* return_type;
	gboolean _tmp0_ = FALSE;
	ValaSourceReference* _tmp3_;
	ValaMethod* _tmp4_;
	ValaMethod* m;
	gboolean _tmp5_ = FALSE;
	GeeArrayList* parameters;
	GeeArrayList* array_length_parameters;
	GeeArrayList* closure_parameters;
	GeeArrayList* destroy_parameters;
	gboolean _tmp6_ = FALSE;
	gint i;
	gint j;
	gint add;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint last;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element_name != NULL, NULL);
	vala_gir_parser_start_element (self, element_name);
	name = vala_markup_reader_get_attribute (self->priv->reader, "name");
	throws_string = vala_markup_reader_get_attribute (self->priv->reader, "throws");
	invoker = vala_markup_reader_get_attribute (self->priv->reader, "invoker");
	vala_gir_parser_next (self);
	return_type = NULL;
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "return-value") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDataType* _tmp1_;
		return_type = (_tmp1_ = vala_gir_parser_parse_return_value (self, NULL), _vala_code_node_unref0 (return_type), _tmp1_);
	} else {
		ValaDataType* _tmp2_;
		return_type = (_tmp2_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (return_type), _tmp2_);
	}
	m = (_tmp4_ = vala_method_new (name, return_type, _tmp3_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp3_), _tmp4_);
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (_vala_strcmp0 (element_name, "virtual-method") == 0) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = _vala_strcmp0 (element_name, "callback") == 0;
	}
	if (_tmp5_) {
		vala_method_set_is_virtual (m, TRUE);
		if (invoker != NULL) {
			vala_symbol_set_name ((ValaSymbol*) m, invoker);
		}
	} else {
		if (_vala_strcmp0 (element_name, "function") == 0) {
			vala_method_set_binding (m, MEMBER_BINDING_STATIC);
		}
	}
	parameters = gee_array_list_new (VALA_GIR_PARSER_TYPE_METHOD_INFO, (GBoxedCopyFunc) vala_gir_parser_method_info_ref, vala_gir_parser_method_info_unref, g_direct_equal);
	array_length_parameters = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	closure_parameters = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	destroy_parameters = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp6_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "parameters") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean first;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		first = TRUE;
		while (TRUE) {
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			ValaFormalParameter* param;
			gboolean _tmp7_ = FALSE;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			param = vala_gir_parser_parse_parameter (self, &array_length_idx, &closure_idx, &destroy_idx);
			if (array_length_idx != (-1)) {
				gee_collection_add ((GeeCollection*) array_length_parameters, GINT_TO_POINTER (array_length_idx));
			}
			if (closure_idx != (-1)) {
				gee_collection_add ((GeeCollection*) closure_parameters, GINT_TO_POINTER (closure_idx));
			}
			if (destroy_idx != (-1)) {
				gee_collection_add ((GeeCollection*) destroy_parameters, GINT_TO_POINTER (destroy_idx));
			}
			if (_vala_strcmp0 (element_name, "callback") != 0) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = !first;
			}
			if (_tmp7_) {
				ValaGirParserMethodInfo* _tmp8_;
				gee_collection_add ((GeeCollection*) parameters, _tmp8_ = vala_gir_parser_method_info_new (param, array_length_idx, closure_idx, destroy_idx));
				_vala_gir_parser_method_info_unref0 (_tmp8_);
			} else {
				first = FALSE;
			}
			_vala_code_node_unref0 (param);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	i = 0;
	j = 1;
	add = 0;
	if (_vala_strcmp0 (element_name, "method") == 0) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = _vala_strcmp0 (element_name, "virtual-method") == 0;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = _vala_strcmp0 (element_name, "callback") == 0;
	}
	if (_tmp9_) {
		add = 1;
	}
	last = -1;
	{
		GeeIterator* _info_it;
		_info_it = gee_iterable_iterator ((GeeIterable*) parameters);
		while (TRUE) {
			ValaGirParserMethodInfo* info;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			if (!gee_iterator_next (_info_it)) {
				break;
			}
			info = (ValaGirParserMethodInfo*) gee_iterator_get (_info_it);
			if (!gee_collection_contains ((GeeCollection*) array_length_parameters, GINT_TO_POINTER (i + add))) {
				_tmp12_ = !gee_collection_contains ((GeeCollection*) closure_parameters, GINT_TO_POINTER (i + add));
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				_tmp11_ = !gee_collection_contains ((GeeCollection*) destroy_parameters, GINT_TO_POINTER (i + add));
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				float last_idx;
				info->vala_idx = (float) j;
				info->keep = TRUE;
				last_idx = 0.0F;
				if (last != (-1)) {
					ValaGirParserMethodInfo* _tmp13_;
					last_idx = (_tmp13_ = (ValaGirParserMethodInfo*) gee_list_get ((GeeList*) parameters, last))->vala_idx;
					_vala_gir_parser_method_info_unref0 (_tmp13_);
				}
				{
					gint k;
					k = last + 1;
					{
						gboolean _tmp14_;
						_tmp14_ = TRUE;
						while (TRUE) {
							ValaGirParserMethodInfo* _tmp15_;
							if (!_tmp14_) {
								k++;
							}
							_tmp14_ = FALSE;
							if (!(k < i)) {
								break;
							}
							(_tmp15_ = (ValaGirParserMethodInfo*) gee_list_get ((GeeList*) parameters, k))->vala_idx = last_idx + (((j - last_idx) / (i - last)) * (k - last));
							_vala_gir_parser_method_info_unref0 (_tmp15_);
						}
					}
				}
				last = i + 1;
				j++;
			}
			i++;
			_vala_gir_parser_method_info_unref0 (info);
		}
		_gee_collection_object_unref0 (_info_it);
	}
	{
		GeeIterator* _info_it;
		_info_it = gee_iterable_iterator ((GeeIterable*) parameters);
		while (TRUE) {
			ValaGirParserMethodInfo* info;
			if (!gee_iterator_next (_info_it)) {
				break;
			}
			info = (ValaGirParserMethodInfo*) gee_iterator_get (_info_it);
			if (info->keep) {
				gboolean _tmp18_ = FALSE;
				vala_method_add_parameter (m, info->param);
				if (info->array_length_idx != (-1)) {
					ValaGirParserMethodInfo* _tmp17_;
					if ((info->array_length_idx - add) >= gee_collection_get_size ((GeeCollection*) parameters)) {
						ValaSourceReference* _tmp16_;
						vala_report_error (_tmp16_ = vala_gir_parser_get_current_src (self), "invalid array_length index");
						_vala_source_reference_unref0 (_tmp16_);
						_vala_gir_parser_method_info_unref0 (info);
						continue;
					}
					vala_formal_parameter_set_carray_length_parameter_position (info->param, (double) (_tmp17_ = (ValaGirParserMethodInfo*) gee_list_get ((GeeList*) parameters, info->array_length_idx - add))->vala_idx);
					_vala_gir_parser_method_info_unref0 (_tmp17_);
				}
				if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (info->param))) {
					_tmp18_ = info->array_length_idx == (-1);
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					vala_formal_parameter_set_no_array_length (info->param, TRUE);
				}
				if (info->closure_idx != (-1)) {
					ValaGirParserMethodInfo* _tmp20_;
					if ((info->closure_idx - add) >= gee_collection_get_size ((GeeCollection*) parameters)) {
						ValaSourceReference* _tmp19_;
						vala_report_error (_tmp19_ = vala_gir_parser_get_current_src (self), "invalid closure index");
						_vala_source_reference_unref0 (_tmp19_);
						_vala_gir_parser_method_info_unref0 (info);
						continue;
					}
					vala_formal_parameter_set_cdelegate_target_parameter_position (info->param, (double) (_tmp20_ = (ValaGirParserMethodInfo*) gee_list_get ((GeeList*) parameters, info->closure_idx - add))->vala_idx);
					_vala_gir_parser_method_info_unref0 (_tmp20_);
				}
			}
			_vala_gir_parser_method_info_unref0 (info);
		}
		_gee_collection_object_unref0 (_info_it);
	}
	if (_vala_strcmp0 (throws_string, "1") == 0) {
		ValaErrorType* _tmp21_;
		vala_code_node_add_error_type ((ValaCodeNode*) m, (ValaDataType*) (_tmp21_ = vala_error_type_new (NULL, NULL, NULL)));
		_vala_code_node_unref0 (_tmp21_);
	}
	vala_gir_parser_end_element (self, element_name);
	result = m;
	_g_free0 (name);
	_g_free0 (throws_string);
	_g_free0 (invoker);
	_vala_code_node_unref0 (return_type);
	_gee_collection_object_unref0 (parameters);
	_gee_collection_object_unref0 (array_length_parameters);
	_gee_collection_object_unref0 (closure_parameters);
	_gee_collection_object_unref0 (destroy_parameters);
	return result;
}


static ValaSignal* vala_gir_parser_parse_signal (ValaGirParser* self) {
	ValaSignal* result;
	gint _tmp2__length1;
	char** _tmp2_;
	char** _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	char* name;
	ValaDataType* return_type;
	gboolean _tmp4_ = FALSE;
	ValaSignal* sig;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "glib:signal");
	name = (_tmp3_ = g_strjoinv ("_", (_tmp2_ = _tmp1_ = g_strsplit (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), "-", 0), _tmp2__length1 = _vala_array_length (_tmp1_), _tmp2_)), _tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL), _g_free0 (_tmp0_), _tmp3_);
	vala_gir_parser_next (self);
	return_type = NULL;
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp4_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "return-value") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaDataType* _tmp5_;
		return_type = (_tmp5_ = vala_gir_parser_parse_return_value (self, NULL), _vala_code_node_unref0 (return_type), _tmp5_);
	} else {
		ValaDataType* _tmp6_;
		return_type = (_tmp6_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (return_type), _tmp6_);
	}
	sig = vala_signal_new (name, return_type, NULL, NULL);
	vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_external ((ValaSymbol*) sig, TRUE);
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp7_ = _vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "parameters") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		while (TRUE) {
			ValaFormalParameter* _tmp8_;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			vala_signal_add_parameter (sig, _tmp8_ = vala_gir_parser_parse_parameter (self, NULL, NULL, NULL));
			_vala_code_node_unref0 (_tmp8_);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	vala_gir_parser_end_element (self, "glib:signal");
	result = sig;
	_g_free0 (name);
	_vala_code_node_unref0 (return_type);
	return result;
}


static ValaStruct* vala_gir_parser_parse_boxed (ValaGirParser* self) {
	ValaStruct* result;
	char* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* st;
	char* cname;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "glib:boxed");
	st = (_tmp1_ = vala_struct_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "glib:name"), NULL, NULL), _g_free0 (_tmp0_), _tmp1_);
	vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_external ((ValaSymbol*) st, TRUE);
	cname = vala_markup_reader_get_attribute (self->priv->reader, "c:type");
	if (cname != NULL) {
		vala_struct_set_cname (st, cname);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "field") == 0) {
			ValaField* _tmp2_;
			vala_struct_add_field (st, _tmp2_ = vala_gir_parser_parse_field (self));
			_vala_code_node_unref0 (_tmp2_);
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "constructor") == 0) {
				ValaMethod* _tmp3_;
				_tmp3_ = vala_gir_parser_parse_constructor (self, NULL);
				_vala_code_node_unref0 (_tmp3_);
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "method") == 0) {
					ValaMethod* _tmp4_;
					vala_struct_add_method (st, _tmp4_ = vala_gir_parser_parse_method (self, "method"));
					_vala_code_node_unref0 (_tmp4_);
				} else {
					char* _tmp6_;
					ValaSourceReference* _tmp5_;
					vala_report_error (_tmp5_ = vala_gir_parser_get_current_src (self), _tmp6_ = g_strdup_printf ("unknown child element `%s' in `class'", vala_markup_reader_get_name (self->priv->reader)));
					_g_free0 (_tmp6_);
					_vala_source_reference_unref0 (_tmp5_);
					break;
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "glib:boxed");
	result = st;
	_g_free0 (cname);
	return result;
}


static ValaStruct* vala_gir_parser_parse_union (ValaGirParser* self) {
	ValaStruct* result;
	char* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* st;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "union");
	st = (_tmp1_ = vala_struct_new (_tmp0_ = vala_markup_reader_get_attribute (self->priv->reader, "name"), NULL, NULL), _g_free0 (_tmp0_), _tmp1_);
	vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_external ((ValaSymbol*) st, TRUE);
	vala_gir_parser_next (self);
	while (TRUE) {
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "field") == 0) {
			ValaField* _tmp2_;
			vala_struct_add_field (st, _tmp2_ = vala_gir_parser_parse_field (self));
			_vala_code_node_unref0 (_tmp2_);
		} else {
			if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "constructor") == 0) {
				ValaMethod* _tmp3_;
				_tmp3_ = vala_gir_parser_parse_constructor (self, NULL);
				_vala_code_node_unref0 (_tmp3_);
			} else {
				if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "method") == 0) {
					ValaMethod* _tmp4_;
					vala_struct_add_method (st, _tmp4_ = vala_gir_parser_parse_method (self, "method"));
					_vala_code_node_unref0 (_tmp4_);
				} else {
					if (_vala_strcmp0 (vala_markup_reader_get_name (self->priv->reader), "record") == 0) {
						ValaStruct* s;
						GeeList* fs;
						s = vala_gir_parser_parse_record (self);
						fs = vala_struct_get_fields (s);
						{
							GeeIterator* _f_it;
							_f_it = gee_iterable_iterator ((GeeIterable*) fs);
							while (TRUE) {
								ValaField* f;
								char* _tmp8_;
								char* _tmp7_;
								char* _tmp6_;
								char* _tmp5_;
								char* _tmp10_;
								char* _tmp9_;
								if (!gee_iterator_next (_f_it)) {
									break;
								}
								f = (ValaField*) gee_iterator_get (_f_it);
								vala_field_set_cname (f, _tmp8_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) s, FALSE), ".", NULL), _tmp7_ = vala_field_get_cname (f), NULL));
								_g_free0 (_tmp8_);
								_g_free0 (_tmp7_);
								_g_free0 (_tmp6_);
								_g_free0 (_tmp5_);
								vala_symbol_set_name ((ValaSymbol*) f, _tmp10_ = g_strconcat (_tmp9_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) s), "_", NULL), vala_symbol_get_name ((ValaSymbol*) f), NULL));
								_g_free0 (_tmp10_);
								_g_free0 (_tmp9_);
								vala_struct_add_field (st, f);
								_vala_code_node_unref0 (f);
							}
							_gee_collection_object_unref0 (_f_it);
						}
						_vala_code_node_unref0 (s);
						_gee_collection_object_unref0 (fs);
					} else {
						char* _tmp12_;
						ValaSourceReference* _tmp11_;
						vala_report_error (_tmp11_ = vala_gir_parser_get_current_src (self), _tmp12_ = g_strdup_printf ("unknown child element `%s' in `union'", vala_markup_reader_get_name (self->priv->reader)));
						_g_free0 (_tmp12_);
						_vala_source_reference_unref0 (_tmp11_);
						break;
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "union");
	result = st;
	return result;
}


static ValaConstant* vala_gir_parser_parse_constant (ValaGirParser* self) {
	ValaConstant* result;
	char* name;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaConstant* _tmp1_;
	ValaConstant* c;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "constant");
	name = vala_markup_reader_get_attribute (self->priv->reader, "name");
	vala_gir_parser_next (self);
	type = vala_gir_parser_parse_type (self, NULL, NULL);
	c = (_tmp1_ = vala_constant_new (name, type, NULL, _tmp0_ = vala_gir_parser_get_current_src (self), NULL), _vala_source_reference_unref0 (_tmp0_), _tmp1_);
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	vala_gir_parser_end_element (self, "constant");
	result = c;
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


void vala_gir_parser_parse_metadata (ValaGirParser* self, const char* metadata_filename) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata_filename != NULL);
	_inner_error_ = NULL;
	if (g_file_test (metadata_filename, G_FILE_TEST_EXISTS)) {
		{
			char* metadata;
			char* _tmp2_;
			gboolean _tmp1_;
			char* _tmp0_ = NULL;
			metadata = NULL;
			_tmp1_ = g_file_get_contents (metadata_filename, &_tmp0_, NULL, &_inner_error_);
			metadata = (_tmp2_ = _tmp0_, _g_free0 (metadata), _tmp2_);
			_tmp1_;
			if (_inner_error_ != NULL) {
				_g_free0 (metadata);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch2_g_file_error;
				}
				goto __finally2;
			}
			{
				char** _tmp3_;
				char** line_collection;
				int line_collection_length1;
				int line_it;
				line_collection = _tmp3_ = g_strsplit (metadata, "\n", 0);
				line_collection_length1 = _vala_array_length (_tmp3_);
				for (line_it = 0; line_it < _vala_array_length (_tmp3_); line_it = line_it + 1) {
					char* line;
					line = g_strdup (line_collection[line_it]);
					{
						char** _tmp5_;
						gint tokens_size;
						gint tokens_length1;
						char** _tmp4_;
						char** tokens;
						if (g_str_has_prefix (line, "#")) {
							_g_free0 (line);
							continue;
						}
						tokens = (_tmp5_ = _tmp4_ = g_strsplit (line, " ", 2), tokens_length1 = _vala_array_length (_tmp4_), tokens_size = tokens_length1, _tmp5_);
						if (NULL == tokens[0]) {
							_g_free0 (line);
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							continue;
						}
						{
							char** _tmp6_;
							char** attribute_collection;
							int attribute_collection_length1;
							int attribute_it;
							attribute_collection = _tmp6_ = g_strsplit (tokens[1], " ", 0);
							attribute_collection_length1 = _vala_array_length (_tmp6_);
							for (attribute_it = 0; attribute_it < _vala_array_length (_tmp6_); attribute_it = attribute_it + 1) {
								char* attribute;
								attribute = g_strdup (attribute_collection[attribute_it]);
								{
									char** _tmp8_;
									gint pair_size;
									gint pair_length1;
									char** _tmp7_;
									char** pair;
									gboolean _tmp9_ = FALSE;
									char* key;
									char* _tmp10_;
									pair = (_tmp8_ = _tmp7_ = g_strsplit (attribute, "=", 2), pair_length1 = _vala_array_length (_tmp7_), pair_size = pair_length1, _tmp8_);
									if (pair[0] == NULL) {
										_tmp9_ = TRUE;
									} else {
										_tmp9_ = pair[1] == NULL;
									}
									if (_tmp9_) {
										_g_free0 (attribute);
										pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
										continue;
									}
									key = g_strdup_printf ("%s/@%s", tokens[0], pair[0]);
									gee_map_set ((GeeMap*) self->priv->attributes_map, key, _tmp10_ = string_substring (pair[1], (glong) 1, string_get_length (pair[1]) - 2));
									_g_free0 (_tmp10_);
									_g_free0 (attribute);
									pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (key);
								}
							}
							attribute_collection = (_vala_array_free (attribute_collection, attribute_collection_length1, (GDestroyNotify) g_free), NULL);
						}
						_g_free0 (line);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp11_;
				vala_report_error (NULL, _tmp11_ = g_strdup_printf ("Unable to read metadata file: %s", e->message));
				_g_free0 (_tmp11_);
				_g_error_free0 (e);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		char* _tmp12_;
		vala_report_error (NULL, _tmp12_ = g_strdup_printf ("Metadata file `%s' not found", metadata_filename));
		_g_free0 (_tmp12_);
	}
}


ValaGirParser* vala_gir_parser_construct (GType object_type) {
	ValaGirParser* self;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGirParser* vala_gir_parser_new (void) {
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}


const char* vala_gir_parser_get_package_name (ValaGirParser* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_package_name;
	return result;
}


static void vala_gir_parser_set_package_name (ValaGirParser* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_package_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_package_name), _tmp0_);
}


static ValaGirParserMethodInfo* vala_gir_parser_method_info_construct (GType object_type, ValaFormalParameter* param, gint array_length_idx, gint closure_idx, gint destroy_idx) {
	ValaGirParserMethodInfo* self;
	ValaFormalParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserMethodInfo*) g_type_create_instance (object_type);
	self->param = (_tmp0_ = _vala_code_node_ref0 (param), _vala_code_node_unref0 (self->param), _tmp0_);
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = FALSE;
	return self;
}


static ValaGirParserMethodInfo* vala_gir_parser_method_info_new (ValaFormalParameter* param, gint array_length_idx, gint closure_idx, gint destroy_idx) {
	return vala_gir_parser_method_info_construct (VALA_GIR_PARSER_TYPE_METHOD_INFO, param, array_length_idx, closure_idx, destroy_idx);
}


static void vala_gir_parser_value_method_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_gir_parser_value_method_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_gir_parser_method_info_unref (value->data[0].v_pointer);
	}
}


static void vala_gir_parser_value_method_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_method_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_gir_parser_value_method_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_gir_parser_value_method_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaGirParserMethodInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_method_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_gir_parser_value_method_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaGirParserMethodInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_method_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* vala_gir_parser_param_spec_method_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaGirParserParamSpecMethodInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METHOD_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer vala_gir_parser_value_get_method_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METHOD_INFO), NULL);
	return value->data[0].v_pointer;
}


static void vala_gir_parser_value_set_method_info (GValue* value, gpointer v_object) {
	ValaGirParserMethodInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METHOD_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METHOD_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_method_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_method_info_unref (old);
	}
}


static void vala_gir_parser_method_info_class_init (ValaGirParserMethodInfoClass * klass) {
	vala_gir_parser_method_info_parent_class = g_type_class_peek_parent (klass);
	VALA_GIR_PARSER_METHOD_INFO_CLASS (klass)->finalize = vala_gir_parser_method_info_finalize;
}


static void vala_gir_parser_method_info_instance_init (ValaGirParserMethodInfo * self) {
	self->ref_count = 1;
}


static void vala_gir_parser_method_info_finalize (ValaGirParserMethodInfo* obj) {
	ValaGirParserMethodInfo * self;
	self = VALA_GIR_PARSER_METHOD_INFO (obj);
	_vala_code_node_unref0 (self->param);
}


static GType vala_gir_parser_method_info_get_type (void) {
	static GType vala_gir_parser_method_info_type_id = 0;
	if (vala_gir_parser_method_info_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_method_info_init, vala_gir_parser_value_method_info_free_value, vala_gir_parser_value_method_info_copy_value, vala_gir_parser_value_method_info_peek_pointer, "p", vala_gir_parser_value_method_info_collect_value, "p", vala_gir_parser_value_method_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMethodInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_method_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMethodInfo), 0, (GInstanceInitFunc) vala_gir_parser_method_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_gir_parser_method_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMethodInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return vala_gir_parser_method_info_type_id;
}


static gpointer vala_gir_parser_method_info_ref (gpointer instance) {
	ValaGirParserMethodInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void vala_gir_parser_method_info_unref (gpointer instance) {
	ValaGirParserMethodInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METHOD_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void vala_gir_parser_class_init (ValaGirParserClass * klass) {
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gir_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGirParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gir_parser_real_visit_source_file;
}


static void vala_gir_parser_instance_init (ValaGirParser * self) {
	self->priv = VALA_GIR_PARSER_GET_PRIVATE (self);
	self->priv->attributes_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	self->priv->gtype_callbacks = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) gee_collection_object_ref, gee_collection_object_unref, g_str_hash, g_str_equal, g_direct_equal);
}


static void vala_gir_parser_finalize (ValaCodeVisitor* obj) {
	ValaGirParser * self;
	self = VALA_GIR_PARSER (obj);
	_g_free0 (self->priv->_package_name);
	_g_object_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_code_node_unref0 (self->priv->glib_ns);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_gee_collection_object_unref0 (self->priv->attributes_map);
	_gee_collection_object_unref0 (self->priv->gtype_callbacks);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}


GType vala_gir_parser_get_type (void) {
	static GType vala_gir_parser_type_id = 0;
	if (vala_gir_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
		vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
	}
	return vala_gir_parser_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




