/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlparser.h>
#include <gidlmodule.h>
#include <stdio.h>
#include <gidlnode.h>
#include <gmetadata.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_idl_module_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_idl_module_free (var), NULL)))
#define __g_list_free_vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_vala_code_node_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	GeeMap* codenode_attributes_map;
	GeeMap* codenode_attributes_patterns;
	GeeSet* current_type_symbol_set;
	GeeMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;

GType vala_gidl_parser_get_type (void);
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_list_free_g_idl_module_free (GList* self);
static char** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const char* codenode, int* result_length1);
static char* vala_gidl_parser_eval (ValaGIdlParser* self, const char* s);
static char* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const char* type_name, ValaNamespace* ns);
static char* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const char* const_name, ValaNamespace* ns);
static void _g_list_free_vala_code_node_unref (GList* self);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaNamespace* ns, GIdlModule* module);
static ValaTypeSymbol* vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const char* cname);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const char* n);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const char* type_name);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const char* name, const char* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static char* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const char* name);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	GeeMap* _tmp0_;
	ValaCodeContext* _tmp1_;
	GeeMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	self->priv->cname_type_map = (_tmp0_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_str_hash, g_str_equal, g_direct_equal), _gee_collection_object_unref0 (self->priv->cname_type_map), _tmp0_);
	self->priv->context = (_tmp1_ = _vala_code_context_ref0 (context), _vala_code_context_unref0 (self->priv->context), _tmp1_);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	self->priv->cname_type_map = (_tmp2_ = NULL, _gee_collection_object_unref0 (self->priv->cname_type_map), _tmp2_);
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	if ((_tmp1_ = !gee_map_contains (self->priv->cname_type_map, _tmp0_ = vala_typesymbol_get_cname (t, FALSE)), _g_free0 (_tmp0_), _tmp1_)) {
		char* _tmp2_;
		gee_map_set (self->priv->cname_type_map, _tmp2_ = vala_typesymbol_get_cname (t, FALSE), t);
		_g_free0 (_tmp2_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gi")) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void _g_list_free_g_idl_module_free (GList* self) {
	g_list_foreach (self, (GFunc) g_idl_module_free, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	char* metadata_filename;
	ValaSourceFile* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_inner_error_ = NULL;
	metadata_filename = (_tmp1_ = g_strdup_printf ("%s.metadata", _tmp0_ = g_strndup (vala_source_file_get_filename (source_file), strlen (vala_source_file_get_filename (source_file)) - strlen (".gi"))), _g_free0 (_tmp0_), _tmp1_);
	self->priv->current_source_file = (_tmp2_ = _vala_source_file_ref0 (source_file), _vala_source_file_unref0 (self->priv->current_source_file), _tmp2_);
	self->priv->codenode_attributes_map = (_tmp3_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), _gee_collection_object_unref0 (self->priv->codenode_attributes_map), _tmp3_);
	self->priv->codenode_attributes_patterns = (_tmp4_ = (GeeMap*) gee_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_hash, (GEqualFunc) g_pattern_spec_equal, g_direct_equal), _gee_collection_object_unref0 (self->priv->codenode_attributes_patterns), _tmp4_);
	if (g_file_test (metadata_filename, G_FILE_TEST_EXISTS)) {
		{
			char* metadata;
			char* _tmp7_;
			gboolean _tmp6_;
			char* _tmp5_ = NULL;
			metadata = NULL;
			_tmp6_ = g_file_get_contents (metadata_filename, &_tmp5_, NULL, &_inner_error_);
			metadata = (_tmp7_ = _tmp5_, _g_free0 (metadata), _tmp7_);
			_tmp6_;
			if (_inner_error_ != NULL) {
				_g_free0 (metadata);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				goto __finally0;
			}
			{
				char** _tmp8_;
				char** line_collection;
				int line_collection_length1;
				int line_it;
				line_collection = _tmp8_ = g_strsplit (metadata, "\n", 0);
				line_collection_length1 = _vala_array_length (_tmp8_);
				for (line_it = 0; line_it < _vala_array_length (_tmp8_); line_it = line_it + 1) {
					char* line;
					line = g_strdup (line_collection[line_it]);
					{
						char** _tmp10_;
						gint tokens_size;
						gint tokens_length1;
						char** _tmp9_;
						char** tokens;
						if (g_str_has_prefix (line, "#")) {
							_g_free0 (line);
							continue;
						}
						tokens = (_tmp10_ = _tmp9_ = g_strsplit (line, " ", 2), tokens_length1 = _vala_array_length (_tmp9_), tokens_size = tokens_length1, _tmp10_);
						if (NULL == tokens[0]) {
							_g_free0 (line);
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							continue;
						}
						if (NULL != g_utf8_strchr (tokens[0], (gssize) (-1), (gunichar) '*')) {
							GPatternSpec* pattern;
							pattern = g_pattern_spec_new (tokens[0]);
							gee_map_set (self->priv->codenode_attributes_patterns, pattern, tokens[0]);
						}
						gee_map_set (self->priv->codenode_attributes_map, tokens[0], tokens[1]);
						_g_free0 (line);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp11_;
				vala_report_error (NULL, _tmp11_ = g_strdup_printf ("Unable to read metadata file: %s", e->message));
				_g_free0 (_tmp11_);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		GList* modules;
		ValaSourceReference* _tmp12_;
		modules = g_idl_parse_file (vala_source_file_get_filename (source_file), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			goto __finally1;
		}
		self->priv->current_source_reference = (_tmp12_ = vala_source_reference_new (source_file, 0, 0, 0, 0), _vala_source_reference_unref0 (self->priv->current_source_reference), _tmp12_);
		{
			GList* module_collection;
			GList* module_it;
			module_collection = modules;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module;
				module = (GIdlModule*) module_it->data;
				{
					ValaNamespace* ns;
					ns = vala_gidl_parser_parse_module (self, module);
					if (ns != NULL) {
						vala_namespace_add_namespace (vala_code_context_get_root (self->priv->context), ns);
					}
					_vala_code_node_unref0 (ns);
				}
			}
		}
		__g_list_free_g_idl_module_free0 (modules);
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "error parsing GIDL file: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static char* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const char* type_name, ValaNamespace* ns) {
	char* result;
	char** _tmp1_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp0_;
	char** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_), attributes_length1 = _tmp0_, attributes_size = attributes_length1, _tmp1_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint nv_size;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), nv_size = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "name") == 0) {
						result = vala_gidl_parser_eval (self, nv[1]);
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	if (g_str_has_prefix (type_name, vala_symbol_get_name ((ValaSymbol*) ns))) {
		result = g_strdup (g_utf8_offset_to_pointer (type_name, g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) ns), -1)));
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) ns), "GLib") == 0) {
			_tmp4_ = g_str_has_prefix (type_name, "G");
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = g_strdup (g_utf8_offset_to_pointer (type_name, (glong) 1));
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			char* best_match;
			best_match = NULL;
			{
				GeeList* _tmp5_;
				GeeIterator* _tmp6_;
				GeeIterator* _cprefix_it;
				_cprefix_it = (_tmp6_ = gee_iterable_iterator ((GeeIterable*) (_tmp5_ = vala_namespace_get_cprefixes (ns))), _gee_collection_object_unref0 (_tmp5_), _tmp6_);
				while (TRUE) {
					char* cprefix;
					if (!gee_iterator_next (_cprefix_it)) {
						break;
					}
					cprefix = (char*) gee_iterator_get (_cprefix_it);
					if (g_str_has_prefix (type_name, cprefix)) {
						gboolean _tmp7_ = FALSE;
						if (best_match == NULL) {
							_tmp7_ = TRUE;
						} else {
							_tmp7_ = g_utf8_strlen (cprefix, -1) > g_utf8_strlen (best_match, -1);
						}
						if (_tmp7_) {
							char* _tmp8_;
							best_match = (_tmp8_ = g_strdup (cprefix), _g_free0 (best_match), _tmp8_);
						}
					}
					_g_free0 (cprefix);
				}
				_gee_collection_object_unref0 (_cprefix_it);
			}
			if (best_match != NULL) {
				result = g_strdup (g_utf8_offset_to_pointer (type_name, g_utf8_strlen (best_match, -1)));
				_g_free0 (best_match);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_g_free0 (best_match);
		}
	}
	result = g_strdup (type_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static char* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const char* const_name, ValaNamespace* ns) {
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	if ((_tmp2_ = g_str_has_prefix (const_name, _tmp1_ = g_strconcat (_tmp0_ = g_utf8_strup (vala_symbol_get_name ((ValaSymbol*) ns), -1), "_", NULL)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_)) {
		result = g_strdup (g_utf8_offset_to_pointer (const_name, g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) ns), -1) + 1));
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) ns), "GLib") == 0) {
			_tmp3_ = g_str_has_prefix (const_name, "G_");
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = g_strdup (g_utf8_offset_to_pointer (const_name, (glong) 2));
			return result;
		}
	}
	result = g_strdup (const_name);
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result;
	ValaSymbol* sym;
	ValaNamespace* ns;
	ValaNamespace* _tmp3_;
	char** _tmp5_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp4_;
	char** attributes;
	ValaNamespace* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	sym = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (self->priv->context)), module->name);
	ns = NULL;
	if (VALA_IS_NAMESPACE (sym)) {
		ValaNamespace* _tmp0_;
		ns = (_tmp0_ = _vala_code_node_ref0 (VALA_NAMESPACE (sym)), _vala_code_node_unref0 (ns), _tmp0_);
		if (vala_symbol_get_external_package ((ValaSymbol*) ns)) {
			GList* _tmp1_;
			((ValaCodeNode*) ns)->attributes = (_tmp1_ = NULL, __g_list_free_vala_code_node_unref0 (((ValaCodeNode*) ns)->attributes), _tmp1_);
			vala_code_node_set_source_reference ((ValaCodeNode*) ns, self->priv->current_source_reference);
		}
	} else {
		ValaNamespace* _tmp2_;
		ns = (_tmp2_ = vala_namespace_new (module->name, self->priv->current_source_reference), _vala_code_node_unref0 (ns), _tmp2_);
	}
	self->priv->current_namespace = (_tmp3_ = _vala_code_node_ref0 (ns), _vala_code_node_unref0 (self->priv->current_namespace), _tmp3_);
	attributes = (_tmp5_ = vala_gidl_parser_get_attributes (self, vala_symbol_get_name ((ValaSymbol*) ns), &_tmp4_), attributes_length1 = _tmp4_, attributes_size = attributes_length1, _tmp5_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp7_;
					gint nv_size;
					gint nv_length1;
					char** _tmp6_;
					char** nv;
					nv = (_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp6_), nv_size = nv_length1, _tmp7_);
					if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
						char* _tmp8_;
						vala_namespace_set_cheader_filename (ns, _tmp8_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp8_);
					} else {
						if (_vala_strcmp0 (nv[0], "cprefix") == 0) {
							char** _tmp12_;
							gint cprefixes_size;
							gint cprefixes_length1;
							char** _tmp10_;
							char* _tmp9_;
							char** _tmp11_;
							char** cprefixes;
							cprefixes = (_tmp12_ = (_tmp11_ = _tmp10_ = g_strsplit (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp9_), _tmp11_), cprefixes_length1 = _vala_array_length (_tmp10_), cprefixes_size = cprefixes_length1, _tmp12_);
							{
								char** name_collection;
								int name_collection_length1;
								int name_it;
								name_collection = cprefixes;
								name_collection_length1 = cprefixes_length1;
								for (name_it = 0; name_it < cprefixes_length1; name_it = name_it + 1) {
									char* name;
									name = g_strdup (name_collection[name_it]);
									{
										vala_namespace_add_cprefix (ns, name);
										_g_free0 (name);
									}
								}
							}
							cprefixes = (_vala_array_free (cprefixes, cprefixes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (_vala_strcmp0 (nv[0], "lower_case_cprefix") == 0) {
								char* _tmp13_;
								vala_namespace_set_lower_case_cprefix (ns, _tmp13_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp13_);
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	{
		GList* node_collection;
		GList* node_it;
		node_collection = module->entries;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node;
			node = (GIdlNode*) node_it->data;
			{
				if (node->type == G_IDL_NODE_CALLBACK) {
					ValaDelegate* cb;
					char* _tmp14_;
					cb = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
					if (cb == NULL) {
						_vala_code_node_unref0 (cb);
						continue;
					}
					vala_symbol_set_name ((ValaSymbol*) cb, _tmp14_ = vala_gidl_parser_fix_type_name (self, vala_symbol_get_name ((ValaSymbol*) cb), ns));
					_g_free0 (_tmp14_);
					vala_namespace_add_delegate (ns, cb);
					vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cb);
					_vala_code_node_unref0 (cb);
				} else {
					if (node->type == G_IDL_NODE_STRUCT) {
						vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, ns, module);
					} else {
						if (node->type == G_IDL_NODE_UNION) {
							vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, ns, module);
						} else {
							if (node->type == G_IDL_NODE_BOXED) {
								vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, ns, module);
							} else {
								if (node->type == G_IDL_NODE_ENUM) {
									ValaTypeSymbol* en;
									char* _tmp15_;
									en = vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node);
									if (en == NULL) {
										_vala_code_node_unref0 (en);
										continue;
									}
									vala_symbol_set_name ((ValaSymbol*) en, _tmp15_ = vala_gidl_parser_fix_type_name (self, vala_symbol_get_name ((ValaSymbol*) en), ns));
									_g_free0 (_tmp15_);
									if (VALA_IS_ERROR_DOMAIN (en)) {
										ValaTypeSymbol* _tmp16_;
										vala_namespace_add_error_domain (ns, (_tmp16_ = en, VALA_IS_ERROR_DOMAIN (_tmp16_) ? ((ValaErrorDomain*) _tmp16_) : NULL));
									} else {
										ValaTypeSymbol* _tmp17_;
										vala_namespace_add_enum (ns, (_tmp17_ = en, VALA_IS_ENUM (_tmp17_) ? ((ValaEnum*) _tmp17_) : NULL));
									}
									vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) en);
									_vala_code_node_unref0 (en);
								} else {
									if (node->type == G_IDL_NODE_FLAGS) {
										ValaTypeSymbol* _tmp18_;
										ValaEnum* en;
										char* _tmp19_;
										en = (_tmp18_ = vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node), VALA_IS_ENUM (_tmp18_) ? ((ValaEnum*) _tmp18_) : NULL);
										if (en == NULL) {
											_vala_code_node_unref0 (en);
											continue;
										}
										vala_symbol_set_name ((ValaSymbol*) en, _tmp19_ = vala_gidl_parser_fix_type_name (self, vala_symbol_get_name ((ValaSymbol*) en), ns));
										_g_free0 (_tmp19_);
										vala_enum_set_is_flags (en, TRUE);
										vala_namespace_add_enum (ns, en);
										vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) en);
										_vala_code_node_unref0 (en);
									} else {
										if (node->type == G_IDL_NODE_OBJECT) {
											vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, ns, module);
										} else {
											if (node->type == G_IDL_NODE_INTERFACE) {
												vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, ns, module);
											} else {
												if (node->type == G_IDL_NODE_CONSTANT) {
													ValaConstant* c;
													c = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
													if (c != NULL) {
														char* _tmp20_;
														vala_symbol_set_name ((ValaSymbol*) c, _tmp20_ = vala_gidl_parser_fix_const_name (self, vala_symbol_get_name ((ValaSymbol*) c), ns));
														_g_free0 (_tmp20_);
														vala_namespace_add_constant (ns, c);
														vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) c);
													}
													_vala_code_node_unref0 (c);
												} else {
													if (node->type == G_IDL_NODE_FUNCTION) {
														ValaMethod* m;
														m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
														if (m != NULL) {
															vala_method_set_binding (m, MEMBER_BINDING_STATIC);
															vala_namespace_add_method (ns, m);
															vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) m);
														}
														_vala_code_node_unref0 (m);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	self->priv->current_namespace = (_tmp21_ = NULL, _vala_code_node_unref0 (self->priv->current_namespace), _tmp21_);
	if (VALA_IS_NAMESPACE (sym)) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (ns);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = ns;
	_vala_code_node_unref0 (sym);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result;
	GIdlNode* node;
	ValaDataType* return_type;
	ValaDelegate* cb;
	gboolean check_has_target;
	char** _tmp1_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp0_;
	char** attributes;
	guint remaining_params;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	return_type = vala_gidl_parser_parse_param (self, f_node->result, NULL);
	cb = vala_delegate_new (node->name, return_type, self->priv->current_source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) cb, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	check_has_target = TRUE;
	attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp0_), attributes_length1 = _tmp0_, attributes_size = attributes_length1, _tmp1_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint nv_size;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), nv_size = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						char* _tmp4_;
						gboolean _tmp5_;
						if ((_tmp5_ = _vala_strcmp0 (_tmp4_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp4_), _tmp5_)) {
							result = NULL;
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (return_type);
							_vala_code_node_unref0 (cb);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					} else {
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp6_;
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cb, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp6_);
						} else {
							if (_vala_strcmp0 (nv[0], "has_target") == 0) {
								char* _tmp7_;
								gboolean _tmp8_;
								if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp7_), _tmp8_)) {
									check_has_target = FALSE;
								} else {
									char* _tmp9_;
									gboolean _tmp10_;
									if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp9_), _tmp10_)) {
										vala_delegate_set_has_target (cb, TRUE);
									}
								}
							} else {
								if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
									char* _tmp11_;
									gboolean _tmp12_;
									if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
										vala_data_type_set_value_owned (return_type, TRUE);
									}
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	remaining_params = g_list_length (f_node->parameters);
	{
		GList* param_collection;
		GList* param_it;
		param_collection = f_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				param_node = (GIdlNode*) param;
				if (check_has_target) {
					_tmp14_ = remaining_params == 1;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gboolean _tmp15_ = FALSE;
					if (_vala_strcmp0 (param_node->name, "user_data") == 0) {
						_tmp15_ = TRUE;
					} else {
						_tmp15_ = _vala_strcmp0 (param_node->name, "data") == 0;
					}
					_tmp13_ = _tmp15_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					vala_delegate_set_has_target (cb, TRUE);
				} else {
					char* param_name;
					ValaParameterDirection direction = 0;
					ValaDataType* param_type;
					ValaFormalParameter* p;
					gboolean hide_param;
					gboolean show_param;
					char** _tmp20_;
					gint _tmp19_;
					char* _tmp18_;
					gboolean _tmp35_ = FALSE;
					param_name = g_strdup (param_node->name);
					if (_vala_strcmp0 (param_name, "string") == 0) {
						char* _tmp16_;
						param_name = (_tmp16_ = g_strdup ("str"), _g_free0 (param_name), _tmp16_);
					} else {
						if (_vala_strcmp0 (param_name, "self") == 0) {
							char* _tmp17_;
							param_name = (_tmp17_ = g_strdup ("_self"), _g_free0 (param_name), _tmp17_);
						}
					}
					param_type = vala_gidl_parser_parse_param (self, param, &direction);
					p = vala_formal_parameter_new (param_name, param_type, NULL);
					vala_formal_parameter_set_direction (p, direction);
					hide_param = FALSE;
					show_param = FALSE;
					attributes = (_tmp20_ = vala_gidl_parser_get_attributes (self, _tmp18_ = g_strdup_printf ("%s.%s", node->name, param_node->name), &_tmp19_), attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL), attributes_length1 = _tmp19_, attributes_size = attributes_length1, _tmp20_);
					_g_free0 (_tmp18_);
					if (attributes != NULL) {
						{
							char** attr_collection;
							int attr_collection_length1;
							int attr_it;
							attr_collection = attributes;
							attr_collection_length1 = attributes_length1;
							for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
								char* attr;
								attr = g_strdup (attr_collection[attr_it]);
								{
									char** _tmp22_;
									gint nv_size;
									gint nv_length1;
									char** _tmp21_;
									char** nv;
									nv = (_tmp22_ = _tmp21_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp21_), nv_size = nv_length1, _tmp22_);
									if (_vala_strcmp0 (nv[0], "hidden") == 0) {
										char* _tmp23_;
										gboolean _tmp24_;
										if ((_tmp24_ = _vala_strcmp0 (_tmp23_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp23_), _tmp24_)) {
											hide_param = TRUE;
										} else {
											char* _tmp25_;
											gboolean _tmp26_;
											if ((_tmp26_ = _vala_strcmp0 (_tmp25_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp25_), _tmp26_)) {
												show_param = TRUE;
											}
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_out") == 0) {
											char* _tmp27_;
											gboolean _tmp28_;
											if ((_tmp28_ = _vala_strcmp0 (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
												vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "is_ref") == 0) {
												char* _tmp29_;
												gboolean _tmp30_;
												if ((_tmp30_ = _vala_strcmp0 (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp29_), _tmp30_)) {
													vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "takes_ownership") == 0) {
													char* _tmp31_;
													gboolean _tmp32_;
													if ((_tmp32_ = _vala_strcmp0 (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "nullable") == 0) {
														char* _tmp33_;
														gboolean _tmp34_;
														if ((_tmp34_ = _vala_strcmp0 (_tmp33_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp33_), _tmp34_)) {
															vala_data_type_set_nullable (param_type, TRUE);
														}
													}
												}
											}
										}
									}
									_g_free0 (attr);
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								}
							}
						}
					}
					if (show_param) {
						_tmp35_ = TRUE;
					} else {
						_tmp35_ = !hide_param;
					}
					if (_tmp35_) {
						vala_delegate_add_parameter (cb, p);
					}
					_g_free0 (param_name);
					_vala_code_node_unref0 (param_type);
					_vala_code_node_unref0 (p);
				}
				remaining_params--;
			}
		}
	}
	result = cb;
	_vala_code_node_unref0 (return_type);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const char* cname) {
	gboolean result;
	char** _tmp1_;
	gint st_attributes_size;
	gint st_attributes_length1;
	gint _tmp0_;
	char** st_attributes;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	st_attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_), st_attributes_length1 = _tmp0_, st_attributes_size = st_attributes_length1, _tmp1_);
	if (st_attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = st_attributes;
			attr_collection_length1 = st_attributes_length1;
			for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint nv_size;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					gboolean _tmp4_ = FALSE;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), nv_size = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "is_value_type") == 0) {
						char* _tmp5_;
						_tmp4_ = _vala_strcmp0 (_tmp5_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
						_g_free0 (_tmp5_);
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						result = FALSE;
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaNamespace* ns, GIdlModule* module) {
	GIdlNode* node;
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	if (st_node->deprecated) {
		return;
	}
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	if (!vala_gidl_parser_is_reference_type (self, node->name)) {
		ValaSymbol* _tmp0_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp20_;
		ValaTypeSymbol* _tmp21_;
		st = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp1_;
			char** _tmp3_;
			gint st_attributes_size;
			gint st_attributes_length1;
			gint _tmp2_;
			char** st_attributes;
			st = (_tmp1_ = vala_struct_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (st), _tmp1_);
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			st_attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_), st_attributes_length1 = _tmp2_, st_attributes_size = st_attributes_length1, _tmp3_);
			if (st_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp5_;
							gint nv_size;
							gint nv_length1;
							char** _tmp4_;
							char** nv;
							nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), nv_size = nv_length1, _tmp5_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp6_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) st, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp6_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp7_;
									gboolean _tmp8_;
									if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp7_), _tmp8_)) {
										_g_free0 (attr);
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									if (_vala_strcmp0 (nv[0], "simple_type") == 0) {
										char* _tmp9_;
										gboolean _tmp10_;
										if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp9_), _tmp10_)) {
											vala_struct_set_simple_type (st, TRUE);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "immutable") == 0) {
											char* _tmp11_;
											gboolean _tmp12_;
											if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
												vala_struct_set_is_immutable (st, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "has_type_id") == 0) {
												char* _tmp13_;
												gboolean _tmp14_;
												if ((_tmp14_ = _vala_strcmp0 (_tmp13_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp13_), _tmp14_)) {
													vala_struct_set_has_type_id (st, FALSE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "type_id") == 0) {
													char* _tmp15_;
													vala_struct_set_type_id (st, _tmp15_ = vala_gidl_parser_eval (self, nv[1]));
													_g_free0 (_tmp15_);
												} else {
													if (_vala_strcmp0 (nv[0], "has_copy_function") == 0) {
														char* _tmp16_;
														gboolean _tmp17_;
														if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp16_), _tmp17_)) {
															vala_struct_set_has_copy_function (st, FALSE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "has_destroy_function") == 0) {
															char* _tmp18_;
															gboolean _tmp19_;
															if ((_tmp19_ = _vala_strcmp0 (_tmp18_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp18_), _tmp19_)) {
																vala_struct_set_has_destroy_function (st, FALSE);
															}
														}
													}
												}
											}
										}
									}
								}
							}
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_namespace_add_struct (ns, st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp20_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st), _vala_code_node_unref0 (self->priv->current_data_type), _tmp20_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_struct_add_method (st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_struct_add_field (st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		self->priv->current_data_type = (_tmp21_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp21_);
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		char* ref_function;
		char* unref_function;
		char* copy_function;
		char* free_function;
		ValaSymbol* _tmp22_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp46_;
		ValaTypeSymbol* _tmp57_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		cl = (_tmp22_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp22_) ? ((ValaClass*) _tmp22_) : NULL);
		if (cl == NULL) {
			char* base_class;
			ValaClass* _tmp23_;
			char** _tmp25_;
			gint cl_attributes_size;
			gint cl_attributes_length1;
			gint _tmp24_;
			char** cl_attributes;
			base_class = NULL;
			cl = (_tmp23_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp23_);
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			cl_attributes = (_tmp25_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp24_), cl_attributes_length1 = _tmp24_, cl_attributes_size = cl_attributes_length1, _tmp25_);
			if (cl_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp27_;
							gint nv_size;
							gint nv_length1;
							char** _tmp26_;
							char** nv;
							nv = (_tmp27_ = _tmp26_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp26_), nv_size = nv_length1, _tmp27_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp28_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp28_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp28_);
							} else {
								if (_vala_strcmp0 (nv[0], "base_class") == 0) {
									char* _tmp29_;
									base_class = (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (base_class), _tmp29_);
								} else {
									if (_vala_strcmp0 (nv[0], "hidden") == 0) {
										char* _tmp30_;
										gboolean _tmp31_;
										if ((_tmp31_ = _vala_strcmp0 (_tmp30_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
											_g_free0 (attr);
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (ref_function);
											_g_free0 (unref_function);
											_g_free0 (copy_function);
											_g_free0 (free_function);
											_vala_code_node_unref0 (cl);
											_g_free0 (name);
											return;
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_immutable") == 0) {
											char* _tmp32_;
											gboolean _tmp33_;
											if ((_tmp33_ = _vala_strcmp0 (_tmp32_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp32_), _tmp33_)) {
												vala_class_set_is_immutable (cl, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "const_cname") == 0) {
												char* _tmp34_;
												vala_class_set_const_cname (cl, _tmp34_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp34_);
											} else {
												if (_vala_strcmp0 (nv[0], "is_fundamental") == 0) {
													char* _tmp35_;
													gboolean _tmp36_;
													if ((_tmp36_ = _vala_strcmp0 (_tmp35_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp35_), _tmp36_)) {
														vala_class_set_is_compact (cl, FALSE);
													}
												} else {
													gboolean _tmp37_ = FALSE;
													if (_vala_strcmp0 (nv[0], "abstract") == 0) {
														_tmp37_ = base_class != NULL;
													} else {
														_tmp37_ = FALSE;
													}
													if (_tmp37_) {
														char* _tmp38_;
														gboolean _tmp39_;
														if ((_tmp39_ = _vala_strcmp0 (_tmp38_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp38_), _tmp39_)) {
															vala_class_set_is_abstract (cl, TRUE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "free_function") == 0) {
															char* _tmp40_;
															free_function = (_tmp40_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (free_function), _tmp40_);
														} else {
															if (_vala_strcmp0 (nv[0], "ref_function") == 0) {
																char* _tmp41_;
																ref_function = (_tmp41_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ref_function), _tmp41_);
															} else {
																if (_vala_strcmp0 (nv[0], "unref_function") == 0) {
																	char* _tmp42_;
																	unref_function = (_tmp42_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (unref_function), _tmp42_);
																} else {
																	if (_vala_strcmp0 (nv[0], "copy_function") == 0) {
																		char* _tmp43_;
																		copy_function = (_tmp43_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (copy_function), _tmp43_);
																	} else {
																		if (_vala_strcmp0 (nv[0], "ref_function_void") == 0) {
																			char* _tmp44_;
																			gboolean _tmp45_;
																			if ((_tmp45_ = _vala_strcmp0 (_tmp44_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp44_), _tmp45_)) {
																				ref_function_void = TRUE;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_namespace_add_class (ns, cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* parent;
				parent = vala_gidl_parser_parse_type_string (self, base_class);
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			_g_free0 (base_class);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp46_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp46_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						gboolean _tmp47_ = FALSE;
						if (ref_function == NULL) {
							_tmp47_ = _vala_strcmp0 (member->name, "ref") == 0;
						} else {
							_tmp47_ = FALSE;
						}
						if (_tmp47_) {
							char* _tmp48_;
							ValaDataType* _tmp49_;
							ref_function = (_tmp48_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (ref_function), _tmp48_);
							ref_function_void = VALA_IS_VOID_TYPE (_tmp49_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL));
							_vala_code_node_unref0 (_tmp49_);
						} else {
							gboolean _tmp50_ = FALSE;
							if (unref_function == NULL) {
								_tmp50_ = _vala_strcmp0 (member->name, "unref") == 0;
							} else {
								_tmp50_ = FALSE;
							}
							if (_tmp50_) {
								char* _tmp51_;
								unref_function = (_tmp51_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (unref_function), _tmp51_);
							} else {
								gboolean _tmp52_ = FALSE;
								if (free_function == NULL) {
									gboolean _tmp53_ = FALSE;
									if (_vala_strcmp0 (member->name, "free") == 0) {
										_tmp53_ = TRUE;
									} else {
										_tmp53_ = _vala_strcmp0 (member->name, "destroy") == 0;
									}
									_tmp52_ = _tmp53_;
								} else {
									_tmp52_ = FALSE;
								}
								if (_tmp52_) {
									char* _tmp54_;
									free_function = (_tmp54_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (free_function), _tmp54_);
								} else {
									gboolean _tmp55_ = FALSE;
									ValaMethod* m;
									if (copy_function == NULL) {
										_tmp55_ = _vala_strcmp0 (member->name, "copy") == 0;
									} else {
										_tmp55_ = FALSE;
									}
									if (_tmp55_) {
										char* _tmp56_;
										copy_function = (_tmp56_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (copy_function), _tmp56_);
									}
									m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									if (m != NULL) {
										vala_class_add_method (cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_class_add_field (cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		self->priv->current_data_type = (_tmp57_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp57_);
		_g_free0 (ref_function);
		_g_free0 (unref_function);
		_g_free0 (copy_function);
		_g_free0 (free_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaNamespace* ns, GIdlModule* module) {
	GIdlNode* node;
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	if (un_node->deprecated) {
		return;
	}
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	if (!vala_gidl_parser_is_reference_type (self, node->name)) {
		ValaSymbol* _tmp0_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		st = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp1_;
			char** _tmp3_;
			gint st_attributes_size;
			gint st_attributes_length1;
			gint _tmp2_;
			char** st_attributes;
			st = (_tmp1_ = vala_struct_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (st), _tmp1_);
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			st_attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_), st_attributes_length1 = _tmp2_, st_attributes_size = st_attributes_length1, _tmp3_);
			if (st_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp5_;
							gint nv_size;
							gint nv_length1;
							char** _tmp4_;
							char** nv;
							nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), nv_size = nv_length1, _tmp5_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp6_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) st, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp6_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp7_;
									gboolean _tmp8_;
									if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp7_), _tmp8_)) {
										_g_free0 (attr);
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								}
							}
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_namespace_add_struct (ns, st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp9_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st), _vala_code_node_unref0 (self->priv->current_data_type), _tmp9_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_struct_add_method (st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_struct_add_field (st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		self->priv->current_data_type = (_tmp10_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp10_);
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp11_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp20_;
		gboolean ref_function_void;
		char* ref_function;
		char* unref_function;
		char* copy_function;
		char* free_function;
		ValaTypeSymbol* _tmp27_;
		cl = (_tmp11_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp11_) ? ((ValaClass*) _tmp11_) : NULL);
		if (cl == NULL) {
			ValaClass* _tmp12_;
			char** _tmp14_;
			gint cl_attributes_size;
			gint cl_attributes_length1;
			gint _tmp13_;
			char** cl_attributes;
			cl = (_tmp12_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp12_);
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			cl_attributes = (_tmp14_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp13_), cl_attributes_length1 = _tmp13_, cl_attributes_size = cl_attributes_length1, _tmp14_);
			if (cl_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp16_;
							gint nv_size;
							gint nv_length1;
							char** _tmp15_;
							char** nv;
							nv = (_tmp16_ = _tmp15_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp15_), nv_size = nv_length1, _tmp16_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp17_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp17_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp17_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp18_;
									gboolean _tmp19_;
									if ((_tmp19_ = _vala_strcmp0 (_tmp18_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp18_), _tmp19_)) {
										_g_free0 (attr);
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_namespace_add_class (ns, cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp20_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp20_);
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (_vala_strcmp0 (member->name, "ref") == 0) {
							char* _tmp21_;
							ValaDataType* _tmp22_;
							ref_function = (_tmp21_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (ref_function), _tmp21_);
							ref_function_void = VALA_IS_VOID_TYPE (_tmp22_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL));
							_vala_code_node_unref0 (_tmp22_);
						} else {
							if (_vala_strcmp0 (member->name, "unref") == 0) {
								char* _tmp23_;
								unref_function = (_tmp23_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (unref_function), _tmp23_);
							} else {
								gboolean _tmp24_ = FALSE;
								if (_vala_strcmp0 (member->name, "free") == 0) {
									_tmp24_ = TRUE;
								} else {
									_tmp24_ = _vala_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp24_) {
									char* _tmp25_;
									free_function = (_tmp25_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (free_function), _tmp25_);
								} else {
									ValaMethod* m;
									if (_vala_strcmp0 (member->name, "copy") == 0) {
										char* _tmp26_;
										copy_function = (_tmp26_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (copy_function), _tmp26_);
									}
									m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									if (m != NULL) {
										vala_class_add_method (cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_class_add_field (cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		self->priv->current_data_type = (_tmp27_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp27_);
		_vala_code_node_unref0 (cl);
		_g_free0 (ref_function);
		_g_free0 (unref_function);
		_g_free0 (copy_function);
		_g_free0 (free_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaNamespace* ns, GIdlModule* module) {
	GIdlNode* node;
	char* name;
	char** _tmp1_;
	gint node_attributes_size;
	gint node_attributes_length1;
	gint _tmp0_;
	char** node_attributes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	node_attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp0_), node_attributes_length1 = _tmp0_, node_attributes_size = node_attributes_length1, _tmp1_);
	if (node_attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = node_attributes;
			attr_collection_length1 = node_attributes_length1;
			for (attr_it = 0; attr_it < node_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint nv_size;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), nv_size = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	if (!vala_gidl_parser_is_reference_type (self, node->name)) {
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		st = (_tmp4_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_;
			char** _tmp7_;
			gint st_attributes_size;
			gint st_attributes_length1;
			gint _tmp6_;
			char** st_attributes;
			char* _tmp17_;
			st = (_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (st), _tmp5_);
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			st_attributes = (_tmp7_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp6_), st_attributes_length1 = _tmp6_, st_attributes_size = st_attributes_length1, _tmp7_);
			if (st_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp9_;
							gint nv_size;
							gint nv_length1;
							char** _tmp8_;
							char** nv;
							nv = (_tmp9_ = _tmp8_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp8_), nv_size = nv_length1, _tmp9_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp10_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) st, _tmp10_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp10_);
							} else {
								if (_vala_strcmp0 (nv[0], "immutable") == 0) {
									char* _tmp11_;
									gboolean _tmp12_;
									if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
										vala_struct_set_is_immutable (st, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "has_copy_function") == 0) {
										char* _tmp13_;
										gboolean _tmp14_;
										if ((_tmp14_ = _vala_strcmp0 (_tmp13_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp13_), _tmp14_)) {
											vala_struct_set_has_copy_function (st, FALSE);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "has_destroy_function") == 0) {
											char* _tmp15_;
											gboolean _tmp16_;
											if ((_tmp16_ = _vala_strcmp0 (_tmp15_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp15_), _tmp16_)) {
												vala_struct_set_has_destroy_function (st, FALSE);
											}
										}
									}
								}
							}
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_namespace_add_struct (ns, st);
			vala_struct_set_type_id (st, _tmp17_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) st, "TYPE_"));
			_g_free0 (_tmp17_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp18_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st), _vala_code_node_unref0 (self->priv->current_data_type), _tmp18_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_struct_add_method (st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_struct_add_field (st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		self->priv->current_data_type = (_tmp19_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp19_);
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp20_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp31_;
		gboolean ref_function_void;
		char* ref_function;
		char* unref_function;
		char* copy_function;
		char* free_function;
		ValaTypeSymbol* _tmp38_;
		cl = (_tmp20_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp20_) ? ((ValaClass*) _tmp20_) : NULL);
		if (cl == NULL) {
			ValaClass* _tmp21_;
			char** _tmp23_;
			gint cl_attributes_size;
			gint cl_attributes_length1;
			gint _tmp22_;
			char** cl_attributes;
			char* _tmp30_;
			cl = (_tmp21_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp21_);
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			cl_attributes = (_tmp23_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp22_), cl_attributes_length1 = _tmp22_, cl_attributes_size = cl_attributes_length1, _tmp23_);
			if (cl_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp25_;
							gint nv_size;
							gint nv_length1;
							char** _tmp24_;
							char** nv;
							nv = (_tmp25_ = _tmp24_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp24_), nv_size = nv_length1, _tmp25_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp26_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp26_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp26_);
							} else {
								if (_vala_strcmp0 (nv[0], "is_immutable") == 0) {
									char* _tmp27_;
									gboolean _tmp28_;
									if ((_tmp28_ = _vala_strcmp0 (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
										vala_class_set_is_immutable (cl, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "const_cname") == 0) {
										char* _tmp29_;
										vala_class_set_const_cname (cl, _tmp29_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp29_);
									}
								}
							}
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_namespace_add_class (ns, cl);
			vala_class_set_type_id (cl, _tmp30_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, "TYPE_"));
			_g_free0 (_tmp30_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp31_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp31_);
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (_vala_strcmp0 (member->name, "ref") == 0) {
							char* _tmp32_;
							ValaDataType* _tmp33_;
							ref_function = (_tmp32_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (ref_function), _tmp32_);
							ref_function_void = VALA_IS_VOID_TYPE (_tmp33_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL));
							_vala_code_node_unref0 (_tmp33_);
						} else {
							if (_vala_strcmp0 (member->name, "unref") == 0) {
								char* _tmp34_;
								unref_function = (_tmp34_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (unref_function), _tmp34_);
							} else {
								gboolean _tmp35_ = FALSE;
								if (_vala_strcmp0 (member->name, "free") == 0) {
									_tmp35_ = TRUE;
								} else {
									_tmp35_ = _vala_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp35_) {
									char* _tmp36_;
									free_function = (_tmp36_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (free_function), _tmp36_);
								} else {
									ValaMethod* m;
									if (_vala_strcmp0 (member->name, "copy") == 0) {
										char* _tmp37_;
										copy_function = (_tmp37_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (copy_function), _tmp37_);
									}
									m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									if (m != NULL) {
										vala_class_add_method (cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_class_add_field (cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		self->priv->current_data_type = (_tmp38_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp38_);
		_vala_code_node_unref0 (cl);
		_g_free0 (ref_function);
		_g_free0 (unref_function);
		_g_free0 (copy_function);
		_g_free0 (free_function);
	}
	_g_free0 (name);
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static ValaTypeSymbol* vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node) {
	ValaTypeSymbol* result;
	GIdlNode* node;
	ValaEnum* en;
	gboolean _tmp0_ = FALSE;
	char* common_prefix;
	gboolean is_errordomain;
	GeeArrayList* cheader_filenames;
	char** _tmp10_;
	gint en_attributes_size;
	gint en_attributes_length1;
	gint _tmp9_;
	char** en_attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en_node != NULL, NULL);
	node = (GIdlNode*) en_node;
	en = vala_enum_new (node->name, self->priv->current_source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (en_node->gtype_name != NULL) {
		_tmp0_ = _vala_strcmp0 (en_node->gtype_name, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	vala_enum_set_has_type_id (en, _tmp0_);
	common_prefix = NULL;
	{
		GList* value_collection;
		GList* value_it;
		value_collection = en_node->values;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value;
			value = (GIdlNode*) value_it->data;
			{
				if (common_prefix == NULL) {
					char* _tmp1_;
					common_prefix = (_tmp1_ = g_strdup (value->name), _g_free0 (common_prefix), _tmp1_);
					while (TRUE) {
						gboolean _tmp2_ = FALSE;
						char* _tmp3_;
						if (g_utf8_strlen (common_prefix, -1) > 0) {
							_tmp2_ = !g_str_has_suffix (common_prefix, "_");
						} else {
							_tmp2_ = FALSE;
						}
						if (!_tmp2_) {
							break;
						}
						common_prefix = (_tmp3_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp3_);
					}
				} else {
					while (TRUE) {
						char* _tmp4_;
						if (!(!g_str_has_prefix (value->name, common_prefix))) {
							break;
						}
						common_prefix = (_tmp4_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp4_);
					}
				}
				while (TRUE) {
					gboolean _tmp5_ = FALSE;
					char* _tmp8_;
					if (g_utf8_strlen (common_prefix, -1) > 0) {
						gboolean _tmp6_ = FALSE;
						if (!g_str_has_suffix (common_prefix, "_")) {
							_tmp6_ = TRUE;
						} else {
							gboolean _tmp7_ = FALSE;
							if (g_unichar_isdigit (g_utf8_get_char (g_utf8_offset_to_pointer (value->name, string_get_length (common_prefix))))) {
								_tmp7_ = (g_utf8_strlen (value->name, -1) - g_utf8_strlen (common_prefix, -1)) <= 1;
							} else {
								_tmp7_ = FALSE;
							}
							_tmp6_ = _tmp7_;
						}
						_tmp5_ = _tmp6_;
					} else {
						_tmp5_ = FALSE;
					}
					if (!_tmp5_) {
						break;
					}
					common_prefix = (_tmp8_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp8_);
				}
			}
		}
	}
	is_errordomain = FALSE;
	cheader_filenames = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	en_attributes = (_tmp10_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp9_), en_attributes_length1 = _tmp9_, en_attributes_size = en_attributes_length1, _tmp10_);
	if (en_attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = en_attributes;
			attr_collection_length1 = en_attributes_length1;
			for (attr_it = 0; attr_it < en_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp12_;
					gint nv_size;
					gint nv_length1;
					char** _tmp11_;
					char** nv;
					nv = (_tmp12_ = _tmp11_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp11_), nv_size = nv_length1, _tmp12_);
					if (_vala_strcmp0 (nv[0], "common_prefix") == 0) {
						char* _tmp13_;
						common_prefix = (_tmp13_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (common_prefix), _tmp13_);
					} else {
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp14_;
							char* _tmp15_;
							gee_collection_add ((GeeCollection*) cheader_filenames, _tmp14_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp14_);
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) en, _tmp15_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp15_);
						} else {
							if (_vala_strcmp0 (nv[0], "hidden") == 0) {
								char* _tmp16_;
								gboolean _tmp17_;
								if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
									result = NULL;
									_g_free0 (attr);
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (en);
									_g_free0 (common_prefix);
									_gee_collection_object_unref0 (cheader_filenames);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									return result;
								}
							} else {
								if (_vala_strcmp0 (nv[0], "rename_to") == 0) {
									char* _tmp18_;
									vala_symbol_set_name ((ValaSymbol*) en, _tmp18_ = vala_gidl_parser_eval (self, nv[1]));
									_g_free0 (_tmp18_);
								} else {
									if (_vala_strcmp0 (nv[0], "errordomain") == 0) {
										char* _tmp19_;
										gboolean _tmp20_;
										if ((_tmp20_ = _vala_strcmp0 (_tmp19_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp19_), _tmp20_)) {
											is_errordomain = TRUE;
										}
									} else {
										if (_vala_strcmp0 (nv[0], "to_string") == 0) {
											ValaUnresolvedType* return_type;
											ValaUnresolvedSymbol* _tmp21_;
											ValaMethod* m;
											char* _tmp22_;
											return_type = vala_unresolved_type_new ();
											vala_unresolved_type_set_unresolved_symbol (return_type, _tmp21_ = vala_unresolved_symbol_new (NULL, "string", NULL));
											_vala_code_node_unref0 (_tmp21_);
											vala_data_type_set_value_owned ((ValaDataType*) return_type, FALSE);
											m = vala_method_new ("to_string", (ValaDataType*) return_type, self->priv->current_source_reference, NULL);
											vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
											vala_method_set_cname (m, _tmp22_ = vala_gidl_parser_eval (self, nv[1]));
											_g_free0 (_tmp22_);
											vala_enum_add_method (en, m);
											_vala_code_node_unref0 (return_type);
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	vala_enum_set_cprefix (en, common_prefix);
	{
		GList* value2_collection;
		GList* value2_it;
		value2_collection = en_node->values;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2;
			value2 = (GIdlNode*) value2_it->data;
			{
				ValaEnumValue* ev;
				ev = vala_enum_value_new (g_utf8_offset_to_pointer (value2->name, g_utf8_strlen (common_prefix, -1)), NULL, NULL);
				vala_enum_add_value (en, ev);
				_vala_code_node_unref0 (ev);
			}
		}
	}
	if (is_errordomain) {
		ValaErrorDomain* ed;
		ed = vala_error_domain_new (vala_symbol_get_name ((ValaSymbol*) en), self->priv->current_source_reference, NULL);
		vala_symbol_set_access ((ValaSymbol*) ed, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_error_domain_set_cprefix (ed, common_prefix);
		{
			GeeIterator* _filename_it;
			_filename_it = gee_iterable_iterator ((GeeIterable*) cheader_filenames);
			while (TRUE) {
				char* filename;
				if (!gee_iterator_next (_filename_it)) {
					break;
				}
				filename = (char*) gee_iterator_get (_filename_it);
				vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) ed, filename);
				_g_free0 (filename);
			}
			_gee_collection_object_unref0 (_filename_it);
		}
		{
			GeeList* _tmp23_;
			GeeIterator* _tmp24_;
			GeeIterator* _ev_it;
			_ev_it = (_tmp24_ = gee_iterable_iterator ((GeeIterable*) (_tmp23_ = vala_enum_get_values (en))), _gee_collection_object_unref0 (_tmp23_), _tmp24_);
			while (TRUE) {
				ValaEnumValue* ev;
				ValaErrorCode* _tmp25_;
				if (!gee_iterator_next (_ev_it)) {
					break;
				}
				ev = (ValaEnumValue*) gee_iterator_get (_ev_it);
				vala_error_domain_add_code (ed, _tmp25_ = vala_error_code_new (vala_symbol_get_name ((ValaSymbol*) ev), NULL, NULL));
				_vala_code_node_unref0 (_tmp25_);
				_vala_code_node_unref0 (ev);
			}
			_gee_collection_object_unref0 (_ev_it);
		}
		result = (ValaTypeSymbol*) ed;
		_vala_code_node_unref0 (en);
		_g_free0 (common_prefix);
		_gee_collection_object_unref0 (cheader_filenames);
		en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = (ValaTypeSymbol*) en;
	_g_free0 (common_prefix);
	_gee_collection_object_unref0 (cheader_filenames);
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module) {
	char* name;
	char* base_class;
	ValaSymbol* _tmp0_;
	ValaClass* cl;
	ValaTypeSymbol* _tmp16_;
	GeeSet* _tmp17_;
	GeeHashMap* current_type_func_map;
	GeeHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp24_;
	GeeSet* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	name = vala_gidl_parser_fix_type_name (self, ((GIdlNode*) node)->name, ns);
	base_class = NULL;
	cl = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL);
	if (cl == NULL) {
		ValaClass* _tmp1_;
		char** _tmp3_;
		gint attributes_size;
		gint attributes_length1;
		gint _tmp2_;
		char** attributes;
		cl = (_tmp1_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp1_);
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp2_), attributes_length1 = _tmp2_, attributes_size = attributes_length1, _tmp3_);
		if (attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp5_;
						gint nv_size;
						gint nv_length1;
						char** _tmp4_;
						char** nv;
						nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), nv_size = nv_length1, _tmp5_);
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp6_;
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp6_);
						} else {
							if (_vala_strcmp0 (nv[0], "base_class") == 0) {
								char* _tmp7_;
								base_class = (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (base_class), _tmp7_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp8_;
									gboolean _tmp9_;
									if ((_tmp9_ = _vala_strcmp0 (_tmp8_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp8_), _tmp9_)) {
										_g_free0 (attr);
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (name);
										_g_free0 (base_class);
										_vala_code_node_unref0 (cl);
										return;
									}
								} else {
									if (_vala_strcmp0 (nv[0], "type_check_function") == 0) {
										char* _tmp10_;
										vala_class_set_type_check_function (cl, _tmp10_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp10_);
									} else {
										if (_vala_strcmp0 (nv[0], "abstract") == 0) {
											char* _tmp11_;
											gboolean _tmp12_;
											if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
												vala_class_set_is_abstract (cl, TRUE);
											}
										}
									}
								}
							}
						}
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
		vala_namespace_add_class (ns, cl);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	if (base_class != NULL) {
		ValaDataType* parent;
		parent = vala_gidl_parser_parse_type_string (self, base_class);
		vala_class_add_base_type (cl, parent);
		_vala_code_node_unref0 (parent);
	} else {
		if (node->parent != NULL) {
			ValaDataType* parent;
			parent = vala_gidl_parser_parse_type_string (self, node->parent);
			vala_class_add_base_type (cl, parent);
			_vala_code_node_unref0 (parent);
		} else {
			ValaUnresolvedSymbol* _tmp13_;
			ValaUnresolvedSymbol* _tmp14_;
			ValaUnresolvedSymbol* gobject_symbol;
			ValaUnresolvedType* _tmp15_;
			gobject_symbol = (_tmp14_ = vala_unresolved_symbol_new (_tmp13_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "Object", NULL), _vala_code_node_unref0 (_tmp13_), _tmp14_);
			vala_class_add_base_type (cl, (ValaDataType*) (_tmp15_ = vala_unresolved_type_new_from_symbol (gobject_symbol, NULL)));
			_vala_code_node_unref0 (_tmp15_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	{
		GList* iface_name_collection;
		GList* iface_name_it;
		iface_name_collection = node->interfaces;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			char* iface_name;
			iface_name = g_strdup ((const char*) iface_name_it->data);
			{
				ValaDataType* iface;
				iface = vala_gidl_parser_parse_type_string (self, iface_name);
				vala_class_add_base_type (cl, iface);
				_g_free0 (iface_name);
				_vala_code_node_unref0 (iface);
			}
		}
	}
	self->priv->current_data_type = (_tmp16_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp16_);
	self->priv->current_type_symbol_set = (_tmp17_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), _gee_collection_object_unref0 (self->priv->current_type_symbol_set), _tmp17_);
	current_type_func_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gee_map_set ((GeeMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					gee_map_set ((GeeMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					if (!gee_map_contains ((GeeMap*) current_type_vfunc_map, member->name)) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_class_add_method (cl, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) gee_map_get ((GeeMap*) current_type_func_map, member->name), FALSE);
						if (m != NULL) {
							vala_class_add_method (cl, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop;
							prop = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							if (prop != NULL) {
								vala_class_add_property (cl, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig;
								sig = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								if (sig != NULL) {
									vala_class_add_signal (cl, sig);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FIELD) {
					if (!gee_collection_contains ((GeeCollection*) self->priv->current_type_symbol_set, member->name)) {
						ValaField* f;
						f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
						if (f != NULL) {
							vala_class_add_field (cl, f);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		GeeList* _tmp18_;
		GeeIterator* _tmp19_;
		GeeIterator* _prop_it;
		_prop_it = (_tmp19_ = gee_iterable_iterator ((GeeIterable*) (_tmp18_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), _gee_collection_object_unref0 (_tmp18_), _tmp19_);
		while (TRUE) {
			ValaProperty* prop;
			char* getter;
			gboolean _tmp20_ = FALSE;
			char* setter;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			getter = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop));
			if (vala_property_get_get_accessor (prop) != NULL) {
				_tmp20_ = !gee_collection_contains ((GeeCollection*) self->priv->current_type_symbol_set, getter);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			setter = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop));
			if (vala_property_get_set_accessor (prop) != NULL) {
				_tmp22_ = vala_property_accessor_get_writable (vala_property_get_set_accessor (prop));
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				_tmp21_ = !gee_collection_contains ((GeeCollection*) self->priv->current_type_symbol_set, setter);
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			if (vala_property_get_no_accessor_method (prop)) {
				_tmp23_ = vala_property_get_get_accessor (prop) != NULL;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				vala_data_type_set_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)), TRUE);
			}
			_vala_code_node_unref0 (prop);
			_g_free0 (getter);
			_g_free0 (setter);
		}
		_gee_collection_object_unref0 (_prop_it);
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) cl);
	self->priv->current_data_type = (_tmp24_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp24_);
	self->priv->current_type_symbol_set = (_tmp25_ = NULL, _gee_collection_object_unref0 (self->priv->current_type_symbol_set), _tmp25_);
	_g_free0 (name);
	_g_free0 (base_class);
	_vala_code_node_unref0 (cl);
	_gee_collection_object_unref0 (current_type_func_map);
	_gee_collection_object_unref0 (current_type_vfunc_map);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module) {
	char* name;
	ValaSymbol* _tmp0_;
	ValaInterface* iface;
	ValaTypeSymbol* _tmp8_;
	GeeHashMap* current_type_func_map;
	GeeHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	name = vala_gidl_parser_fix_type_name (self, node->gtype_name, ns);
	iface = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_INTERFACE (_tmp0_) ? ((ValaInterface*) _tmp0_) : NULL);
	if (iface == NULL) {
		ValaInterface* _tmp1_;
		char** _tmp3_;
		gint attributes_size;
		gint attributes_length1;
		gint _tmp2_;
		char** attributes;
		iface = (_tmp1_ = vala_interface_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (iface), _tmp1_);
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp2_), attributes_length1 = _tmp2_, attributes_size = attributes_length1, _tmp3_);
		if (attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp5_;
						gint nv_size;
						gint nv_length1;
						char** _tmp4_;
						char** nv;
						nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), nv_size = nv_length1, _tmp5_);
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp6_;
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) iface, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp6_);
						} else {
							if (_vala_strcmp0 (nv[0], "lower_case_csuffix") == 0) {
								char* _tmp7_;
								vala_interface_set_lower_case_csuffix (iface, _tmp7_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp7_);
							}
						}
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
		{
			GList* prereq_name_collection;
			GList* prereq_name_it;
			prereq_name_collection = node->prerequisites;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				char* prereq_name;
				prereq_name = g_strdup ((const char*) prereq_name_it->data);
				{
					ValaDataType* prereq;
					prereq = vala_gidl_parser_parse_type_string (self, prereq_name);
					vala_interface_add_prerequisite (iface, prereq);
					_g_free0 (prereq_name);
					_vala_code_node_unref0 (prereq);
				}
			}
		}
		vala_namespace_add_interface (ns, iface);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) iface);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	self->priv->current_data_type = (_tmp8_ = _vala_code_node_ref0 ((ValaTypeSymbol*) iface), _vala_code_node_unref0 (self->priv->current_data_type), _tmp8_);
	current_type_func_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gee_map_set ((GeeMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					gee_map_set ((GeeMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					if (!gee_map_contains ((GeeMap*) current_type_vfunc_map, member->name)) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, TRUE);
						if (m != NULL) {
							vala_interface_add_method (iface, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) gee_map_get ((GeeMap*) current_type_func_map, member->name), TRUE);
						if (m != NULL) {
							vala_interface_add_method (iface, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop;
							prop = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							if (prop != NULL) {
								vala_interface_add_property (iface, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig;
								sig = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								if (sig != NULL) {
									vala_interface_add_signal (iface, sig);
									vala_signal_set_is_virtual (sig, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) iface);
	self->priv->current_data_type = (_tmp9_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp9_);
	_g_free0 (name);
	_vala_code_node_unref0 (iface);
	_gee_collection_object_unref0 (current_type_func_map);
	_gee_collection_object_unref0 (current_type_vfunc_map);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _m_it;
		_m_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_methods (type_symbol))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_coroutine (m)) {
				char* finish_method_base;
				char* _tmp4_;
				ValaSymbol* _tmp5_;
				ValaMethod* _tmp6_;
				ValaMethod* finish_method;
				finish_method_base = NULL;
				if (g_str_has_suffix (vala_symbol_get_name ((ValaSymbol*) m), "_async")) {
					char* _tmp2_;
					finish_method_base = (_tmp2_ = string_substring (vala_symbol_get_name ((ValaSymbol*) m), (glong) 0, string_get_length (vala_symbol_get_name ((ValaSymbol*) m)) - string_get_length ("_async")), _g_free0 (finish_method_base), _tmp2_);
				} else {
					char* _tmp3_;
					finish_method_base = (_tmp3_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) m)), _g_free0 (finish_method_base), _tmp3_);
				}
				finish_method = (_tmp6_ = (_tmp5_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) type_symbol), _tmp4_ = g_strconcat (finish_method_base, "_finish", NULL)), VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL), _g_free0 (_tmp4_), _tmp6_);
				if (finish_method != NULL) {
					ValaDataType* _tmp7_;
					vala_method_set_return_type (m, _tmp7_ = vala_data_type_copy (vala_method_get_return_type (finish_method)));
					_vala_code_node_unref0 (_tmp7_);
					{
						GeeList* _tmp8_;
						GeeIterator* _tmp9_;
						GeeIterator* _param_it;
						_param_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = vala_method_get_parameters (finish_method))), _gee_collection_object_unref0 (_tmp8_), _tmp9_);
						while (TRUE) {
							ValaFormalParameter* param;
							if (!gee_iterator_next (_param_it)) {
								break;
							}
							param = (ValaFormalParameter*) gee_iterator_get (_param_it);
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
								ValaFormalParameter* async_param;
								ValaSymbol* _tmp10_;
								gboolean _tmp11_;
								async_param = vala_formal_parameter_copy (param);
								if ((_tmp11_ = (_tmp10_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) param))) != NULL, _vala_code_node_unref0 (_tmp10_), _tmp11_)) {
									char* _tmp12_;
									vala_symbol_set_name ((ValaSymbol*) async_param, _tmp12_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) async_param), "_out", NULL));
									_g_free0 (_tmp12_);
								}
								vala_method_add_parameter (m, async_param);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_gee_collection_object_unref0 (_param_it);
					}
					{
						GeeList* _tmp13_;
						GeeIterator* _tmp14_;
						GeeIterator* _error_type_it;
						_error_type_it = (_tmp14_ = gee_iterable_iterator ((GeeIterable*) (_tmp13_ = vala_code_node_get_error_types ((ValaCodeNode*) finish_method))), _gee_collection_object_unref0 (_tmp13_), _tmp14_);
						while (TRUE) {
							ValaDataType* error_type;
							ValaDataType* _tmp15_;
							if (!gee_iterator_next (_error_type_it)) {
								break;
							}
							error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
							vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp15_ = vala_data_type_copy (error_type));
							_vala_code_node_unref0 (_tmp15_);
							_vala_code_node_unref0 (error_type);
						}
						_gee_collection_object_unref0 (_error_type_it);
					}
				}
				_g_free0 (finish_method_base);
				_vala_code_node_unref0 (finish_method);
			}
			_vala_code_node_unref0 (m);
		}
		_gee_collection_object_unref0 (_m_it);
	}
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaDataType* result;
	ValaParameterDirection dir;
	ValaUnresolvedType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	dir = VALA_PARAMETER_DIRECTION_IN;
	type = vala_unresolved_type_new ();
	if (type_node->tag == TYPE_TAG_VOID) {
		if (type_node->is_pointer) {
			ValaVoidType* _tmp0_;
			ValaDataType* _tmp1_;
			result = (_tmp1_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp0_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp0_), _tmp1_);
			_vala_code_node_unref0 (type);
			return result;
		} else {
			result = (ValaDataType*) vala_void_type_new (NULL);
			_vala_code_node_unref0 (type);
			return result;
		}
	} else {
		if (type_node->tag == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedSymbol* _tmp2_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp2_ = vala_unresolved_symbol_new (NULL, "bool", NULL));
			_vala_code_node_unref0 (_tmp2_);
		} else {
			if (type_node->tag == TYPE_TAG_INT8) {
				ValaUnresolvedSymbol* _tmp3_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp3_ = vala_unresolved_symbol_new (NULL, "char", NULL));
				_vala_code_node_unref0 (_tmp3_);
			} else {
				if (type_node->tag == TYPE_TAG_UINT8) {
					ValaUnresolvedSymbol* _tmp4_;
					vala_unresolved_type_set_unresolved_symbol (type, _tmp4_ = vala_unresolved_symbol_new (NULL, "uchar", NULL));
					_vala_code_node_unref0 (_tmp4_);
				} else {
					if (type_node->tag == TYPE_TAG_INT16) {
						ValaUnresolvedSymbol* _tmp5_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp5_ = vala_unresolved_symbol_new (NULL, "int16", NULL));
						_vala_code_node_unref0 (_tmp5_);
					} else {
						if (type_node->tag == TYPE_TAG_UINT16) {
							ValaUnresolvedSymbol* _tmp6_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp6_ = vala_unresolved_symbol_new (NULL, "uint16", NULL));
							_vala_code_node_unref0 (_tmp6_);
						} else {
							if (type_node->tag == TYPE_TAG_INT32) {
								ValaUnresolvedSymbol* _tmp7_;
								vala_unresolved_type_set_unresolved_symbol (type, _tmp7_ = vala_unresolved_symbol_new (NULL, "int32", NULL));
								_vala_code_node_unref0 (_tmp7_);
							} else {
								if (type_node->tag == TYPE_TAG_UINT32) {
									ValaUnresolvedSymbol* _tmp8_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp8_ = vala_unresolved_symbol_new (NULL, "uint32", NULL));
									_vala_code_node_unref0 (_tmp8_);
								} else {
									if (type_node->tag == TYPE_TAG_INT64) {
										ValaUnresolvedSymbol* _tmp9_;
										vala_unresolved_type_set_unresolved_symbol (type, _tmp9_ = vala_unresolved_symbol_new (NULL, "int64", NULL));
										_vala_code_node_unref0 (_tmp9_);
									} else {
										if (type_node->tag == TYPE_TAG_UINT64) {
											ValaUnresolvedSymbol* _tmp10_;
											vala_unresolved_type_set_unresolved_symbol (type, _tmp10_ = vala_unresolved_symbol_new (NULL, "uint64", NULL));
											_vala_code_node_unref0 (_tmp10_);
										} else {
											if (type_node->tag == TYPE_TAG_INT) {
												ValaUnresolvedSymbol* _tmp11_;
												vala_unresolved_type_set_unresolved_symbol (type, _tmp11_ = vala_unresolved_symbol_new (NULL, "int", NULL));
												_vala_code_node_unref0 (_tmp11_);
											} else {
												if (type_node->tag == TYPE_TAG_UINT) {
													ValaUnresolvedSymbol* _tmp12_;
													vala_unresolved_type_set_unresolved_symbol (type, _tmp12_ = vala_unresolved_symbol_new (NULL, "uint", NULL));
													_vala_code_node_unref0 (_tmp12_);
												} else {
													if (type_node->tag == TYPE_TAG_LONG) {
														ValaUnresolvedSymbol* _tmp13_;
														vala_unresolved_type_set_unresolved_symbol (type, _tmp13_ = vala_unresolved_symbol_new (NULL, "long", NULL));
														_vala_code_node_unref0 (_tmp13_);
													} else {
														if (type_node->tag == TYPE_TAG_ULONG) {
															ValaUnresolvedSymbol* _tmp14_;
															vala_unresolved_type_set_unresolved_symbol (type, _tmp14_ = vala_unresolved_symbol_new (NULL, "ulong", NULL));
															_vala_code_node_unref0 (_tmp14_);
														} else {
															if (type_node->tag == TYPE_TAG_SSIZE) {
																ValaUnresolvedSymbol* _tmp15_;
																vala_unresolved_type_set_unresolved_symbol (type, _tmp15_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL));
																_vala_code_node_unref0 (_tmp15_);
															} else {
																if (type_node->tag == TYPE_TAG_SIZE) {
																	ValaUnresolvedSymbol* _tmp16_;
																	vala_unresolved_type_set_unresolved_symbol (type, _tmp16_ = vala_unresolved_symbol_new (NULL, "size_t", NULL));
																	_vala_code_node_unref0 (_tmp16_);
																} else {
																	if (type_node->tag == TYPE_TAG_FLOAT) {
																		ValaUnresolvedSymbol* _tmp17_;
																		vala_unresolved_type_set_unresolved_symbol (type, _tmp17_ = vala_unresolved_symbol_new (NULL, "float", NULL));
																		_vala_code_node_unref0 (_tmp17_);
																	} else {
																		if (type_node->tag == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedSymbol* _tmp18_;
																			vala_unresolved_type_set_unresolved_symbol (type, _tmp18_ = vala_unresolved_symbol_new (NULL, "double", NULL));
																			_vala_code_node_unref0 (_tmp18_);
																		} else {
																			if (type_node->tag == TYPE_TAG_UTF8) {
																				ValaUnresolvedSymbol* _tmp19_;
																				vala_unresolved_type_set_unresolved_symbol (type, _tmp19_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																				_vala_code_node_unref0 (_tmp19_);
																			} else {
																				if (type_node->tag == TYPE_TAG_FILENAME) {
																					ValaUnresolvedSymbol* _tmp20_;
																					vala_unresolved_type_set_unresolved_symbol (type, _tmp20_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																					_vala_code_node_unref0 (_tmp20_);
																				} else {
																					if (type_node->tag == TYPE_TAG_ARRAY) {
																						ValaDataType* element_type;
																						ValaUnresolvedType* _tmp22_;
																						ValaDataType* _tmp21_;
																						element_type = vala_gidl_parser_parse_type (self, type_node->parameter_type1, NULL);
																						type = (_tmp22_ = _vala_code_node_ref0 ((_tmp21_ = element_type, VALA_IS_UNRESOLVED_TYPE (_tmp21_) ? ((ValaUnresolvedType*) _tmp21_) : NULL)), _vala_code_node_unref0 (type), _tmp22_);
																						if (type == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							return result;
																						}
																						result = (ValaDataType*) vala_array_type_new (element_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) element_type));
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						return result;
																					} else {
																						if (type_node->tag == TYPE_TAG_LIST) {
																							ValaUnresolvedSymbol* _tmp24_;
																							ValaUnresolvedSymbol* _tmp23_;
																							vala_unresolved_type_set_unresolved_symbol (type, _tmp24_ = vala_unresolved_symbol_new (_tmp23_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "List", NULL));
																							_vala_code_node_unref0 (_tmp24_);
																							_vala_code_node_unref0 (_tmp23_);
																						} else {
																							if (type_node->tag == TYPE_TAG_SLIST) {
																								ValaUnresolvedSymbol* _tmp26_;
																								ValaUnresolvedSymbol* _tmp25_;
																								vala_unresolved_type_set_unresolved_symbol (type, _tmp26_ = vala_unresolved_symbol_new (_tmp25_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "SList", NULL));
																								_vala_code_node_unref0 (_tmp26_);
																								_vala_code_node_unref0 (_tmp25_);
																							} else {
																								if (type_node->tag == TYPE_TAG_HASH) {
																									ValaUnresolvedSymbol* _tmp28_;
																									ValaUnresolvedSymbol* _tmp27_;
																									vala_unresolved_type_set_unresolved_symbol (type, _tmp28_ = vala_unresolved_symbol_new (_tmp27_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "HashTable", NULL));
																									_vala_code_node_unref0 (_tmp28_);
																									_vala_code_node_unref0 (_tmp27_);
																								} else {
																									if (type_node->tag == TYPE_TAG_ERROR) {
																										ValaUnresolvedSymbol* _tmp30_;
																										ValaUnresolvedSymbol* _tmp29_;
																										vala_unresolved_type_set_unresolved_symbol (type, _tmp30_ = vala_unresolved_symbol_new (_tmp29_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "Error", NULL));
																										_vala_code_node_unref0 (_tmp30_);
																										_vala_code_node_unref0 (_tmp29_);
																									} else {
																										if (type_node->is_interface) {
																											char* n;
																											gboolean _tmp32_ = FALSE;
																											n = g_strdup (type_node->interface);
																											if (_vala_strcmp0 (n, "") == 0) {
																												result = NULL;
																												_g_free0 (n);
																												_vala_code_node_unref0 (type);
																												return result;
																											}
																											if (g_str_has_prefix (n, "const-")) {
																												char* _tmp31_;
																												n = (_tmp31_ = g_strdup (g_utf8_offset_to_pointer (n, g_utf8_strlen ("const-", -1))), _g_free0 (n), _tmp31_);
																											}
																											if (type_node->is_pointer) {
																												gboolean _tmp33_ = FALSE;
																												if (_vala_strcmp0 (n, "gchar") == 0) {
																													_tmp33_ = TRUE;
																												} else {
																													_tmp33_ = _vala_strcmp0 (n, "char") == 0;
																												}
																												_tmp32_ = _tmp33_;
																											} else {
																												_tmp32_ = FALSE;
																											}
																											if (_tmp32_) {
																												ValaUnresolvedSymbol* _tmp34_;
																												vala_unresolved_type_set_unresolved_symbol (type, _tmp34_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																												_vala_code_node_unref0 (_tmp34_);
																												if (g_str_has_suffix (type_node->unparsed, "**")) {
																													dir = VALA_PARAMETER_DIRECTION_OUT;
																												}
																											} else {
																												if (_vala_strcmp0 (n, "gunichar") == 0) {
																													ValaUnresolvedSymbol* _tmp35_;
																													vala_unresolved_type_set_unresolved_symbol (type, _tmp35_ = vala_unresolved_symbol_new (NULL, "unichar", NULL));
																													_vala_code_node_unref0 (_tmp35_);
																												} else {
																													if (_vala_strcmp0 (n, "gchar") == 0) {
																														ValaUnresolvedSymbol* _tmp36_;
																														vala_unresolved_type_set_unresolved_symbol (type, _tmp36_ = vala_unresolved_symbol_new (NULL, "char", NULL));
																														_vala_code_node_unref0 (_tmp36_);
																													} else {
																														gboolean _tmp37_ = FALSE;
																														if (_vala_strcmp0 (n, "guchar") == 0) {
																															_tmp37_ = TRUE;
																														} else {
																															_tmp37_ = _vala_strcmp0 (n, "guint8") == 0;
																														}
																														if (_tmp37_) {
																															ValaUnresolvedSymbol* _tmp38_;
																															vala_unresolved_type_set_unresolved_symbol (type, _tmp38_ = vala_unresolved_symbol_new (NULL, "uchar", NULL));
																															_vala_code_node_unref0 (_tmp38_);
																															if (type_node->is_pointer) {
																																result = (ValaDataType*) vala_array_type_new ((ValaDataType*) type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type));
																																_g_free0 (n);
																																_vala_code_node_unref0 (type);
																																return result;
																															}
																														} else {
																															if (_vala_strcmp0 (n, "gushort") == 0) {
																																ValaUnresolvedSymbol* _tmp39_;
																																vala_unresolved_type_set_unresolved_symbol (type, _tmp39_ = vala_unresolved_symbol_new (NULL, "ushort", NULL));
																																_vala_code_node_unref0 (_tmp39_);
																															} else {
																																if (_vala_strcmp0 (n, "gshort") == 0) {
																																	ValaUnresolvedSymbol* _tmp40_;
																																	vala_unresolved_type_set_unresolved_symbol (type, _tmp40_ = vala_unresolved_symbol_new (NULL, "short", NULL));
																																	_vala_code_node_unref0 (_tmp40_);
																																} else {
																																	gboolean _tmp41_ = FALSE;
																																	if (_vala_strcmp0 (n, "gconstpointer") == 0) {
																																		_tmp41_ = TRUE;
																																	} else {
																																		_tmp41_ = _vala_strcmp0 (n, "void") == 0;
																																	}
																																	if (_tmp41_) {
																																		ValaVoidType* _tmp42_;
																																		ValaDataType* _tmp43_;
																																		result = (_tmp43_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp42_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp42_), _tmp43_);
																																		_g_free0 (n);
																																		_vala_code_node_unref0 (type);
																																		return result;
																																	} else {
																																		gboolean _tmp44_ = FALSE;
																																		if (_vala_strcmp0 (n, "goffset") == 0) {
																																			_tmp44_ = TRUE;
																																		} else {
																																			_tmp44_ = _vala_strcmp0 (n, "off_t") == 0;
																																		}
																																		if (_tmp44_) {
																																			ValaUnresolvedSymbol* _tmp45_;
																																			vala_unresolved_type_set_unresolved_symbol (type, _tmp45_ = vala_unresolved_symbol_new (NULL, "int64", NULL));
																																			_vala_code_node_unref0 (_tmp45_);
																																		} else {
																																			if (_vala_strcmp0 (n, "value_array") == 0) {
																																				ValaUnresolvedSymbol* _tmp47_;
																																				ValaUnresolvedSymbol* _tmp46_;
																																				vala_unresolved_type_set_unresolved_symbol (type, _tmp47_ = vala_unresolved_symbol_new (_tmp46_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "ValueArray", NULL));
																																				_vala_code_node_unref0 (_tmp47_);
																																				_vala_code_node_unref0 (_tmp46_);
																																			} else {
																																				if (_vala_strcmp0 (n, "time_t") == 0) {
																																					ValaUnresolvedSymbol* _tmp48_;
																																					vala_unresolved_type_set_unresolved_symbol (type, _tmp48_ = vala_unresolved_symbol_new (NULL, "ulong", NULL));
																																					_vala_code_node_unref0 (_tmp48_);
																																				} else {
																																					if (_vala_strcmp0 (n, "socklen_t") == 0) {
																																						ValaUnresolvedSymbol* _tmp49_;
																																						vala_unresolved_type_set_unresolved_symbol (type, _tmp49_ = vala_unresolved_symbol_new (NULL, "uint32", NULL));
																																						_vala_code_node_unref0 (_tmp49_);
																																					} else {
																																						if (_vala_strcmp0 (n, "mode_t") == 0) {
																																							ValaUnresolvedSymbol* _tmp50_;
																																							vala_unresolved_type_set_unresolved_symbol (type, _tmp50_ = vala_unresolved_symbol_new (NULL, "uint", NULL));
																																							_vala_code_node_unref0 (_tmp50_);
																																						} else {
																																							gboolean _tmp51_ = FALSE;
																																							if (_vala_strcmp0 (n, "gint") == 0) {
																																								_tmp51_ = TRUE;
																																							} else {
																																								_tmp51_ = _vala_strcmp0 (n, "pid_t") == 0;
																																							}
																																							if (_tmp51_) {
																																								ValaUnresolvedSymbol* _tmp52_;
																																								vala_unresolved_type_set_unresolved_symbol (type, _tmp52_ = vala_unresolved_symbol_new (NULL, "int", NULL));
																																								_vala_code_node_unref0 (_tmp52_);
																																							} else {
																																								gboolean _tmp53_ = FALSE;
																																								if (_vala_strcmp0 (n, "unsigned") == 0) {
																																									_tmp53_ = TRUE;
																																								} else {
																																									_tmp53_ = _vala_strcmp0 (n, "unsigned-int") == 0;
																																								}
																																								if (_tmp53_) {
																																									ValaUnresolvedSymbol* _tmp54_;
																																									vala_unresolved_type_set_unresolved_symbol (type, _tmp54_ = vala_unresolved_symbol_new (NULL, "uint", NULL));
																																									_vala_code_node_unref0 (_tmp54_);
																																								} else {
																																									if (_vala_strcmp0 (n, "FILE") == 0) {
																																										ValaUnresolvedSymbol* _tmp56_;
																																										ValaUnresolvedSymbol* _tmp55_;
																																										vala_unresolved_type_set_unresolved_symbol (type, _tmp56_ = vala_unresolved_symbol_new (_tmp55_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "FileStream", NULL));
																																										_vala_code_node_unref0 (_tmp56_);
																																										_vala_code_node_unref0 (_tmp55_);
																																									} else {
																																										if (_vala_strcmp0 (n, "struct") == 0) {
																																											ValaVoidType* _tmp57_;
																																											ValaDataType* _tmp58_;
																																											result = (_tmp58_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp57_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp57_), _tmp58_);
																																											_g_free0 (n);
																																											_vala_code_node_unref0 (type);
																																											return result;
																																										} else {
																																											if (_vala_strcmp0 (n, "iconv_t") == 0) {
																																												ValaVoidType* _tmp59_;
																																												ValaDataType* _tmp60_;
																																												result = (_tmp60_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp59_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp59_), _tmp60_);
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												return result;
																																											} else {
																																												if (_vala_strcmp0 (n, "GType") == 0) {
																																													ValaUnresolvedSymbol* _tmp62_;
																																													ValaUnresolvedSymbol* _tmp61_;
																																													vala_unresolved_type_set_unresolved_symbol (type, _tmp62_ = vala_unresolved_symbol_new (_tmp61_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "Type", NULL));
																																													_vala_code_node_unref0 (_tmp62_);
																																													_vala_code_node_unref0 (_tmp61_);
																																													if (type_node->is_pointer) {
																																														result = (ValaDataType*) vala_array_type_new ((ValaDataType*) type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type));
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														return result;
																																													}
																																												} else {
																																													if (_vala_strcmp0 (n, "GStrv") == 0) {
																																														ValaUnresolvedSymbol* _tmp63_;
																																														vala_unresolved_type_set_unresolved_symbol (type, _tmp63_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																																														_vala_code_node_unref0 (_tmp63_);
																																														result = (ValaDataType*) vala_array_type_new ((ValaDataType*) type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type));
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														return result;
																																													} else {
																																														ValaDataType* named_type;
																																														ValaUnresolvedType* _tmp65_;
																																														ValaDataType* _tmp64_;
																																														named_type = vala_gidl_parser_parse_type_string (self, n);
																																														type = (_tmp65_ = _vala_code_node_ref0 ((_tmp64_ = named_type, VALA_IS_UNRESOLVED_TYPE (_tmp64_) ? ((ValaUnresolvedType*) _tmp64_) : NULL)), _vala_code_node_unref0 (type), _tmp65_);
																																														if (type == NULL) {
																																															result = named_type;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															return result;
																																														}
																																														if (vala_gidl_parser_is_simple_type (self, n)) {
																																															if (type_node->is_pointer) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														} else {
																																															if (g_str_has_suffix (type_node->unparsed, "**")) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														}
																																														_vala_code_node_unref0 (named_type);
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (n);
																										} else {
																											fprintf (stdout, "%d\n", (gint) type_node->tag);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((direction) != NULL) {
		*direction = dir;
	}
	result = (ValaDataType*) type;
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const char* type_name) {
	gboolean result;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* st;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	st = (_tmp0_ = (ValaTypeSymbol*) gee_map_get (self->priv->cname_type_map, type_name), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
	if (st != NULL) {
		_tmp1_ = vala_struct_is_simple_type (st);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const char* n) {
	ValaDataType* result;
	ValaUnresolvedType* type;
	ValaTypeSymbol* dt;
	char** _tmp5_;
	gint type_attributes_size;
	gint type_attributes_length1;
	gint _tmp4_;
	char** type_attributes;
	char* ns_name;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (_vala_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_;
		ValaDataType* _tmp1_;
		result = (_tmp1_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp0_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp0_), _tmp1_);
		return result;
	}
	type = vala_unresolved_type_new ();
	dt = (ValaTypeSymbol*) gee_map_get (self->priv->cname_type_map, n);
	if (dt != NULL) {
		ValaUnresolvedSymbol* parent_symbol;
		ValaUnresolvedSymbol* _tmp3_;
		parent_symbol = NULL;
		if (vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) dt)) != NULL) {
			ValaUnresolvedSymbol* _tmp2_;
			parent_symbol = (_tmp2_ = vala_unresolved_symbol_new (NULL, vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) dt)), NULL), _vala_code_node_unref0 (parent_symbol), _tmp2_);
		}
		vala_unresolved_type_set_unresolved_symbol (type, _tmp3_ = vala_unresolved_symbol_new (parent_symbol, vala_symbol_get_name ((ValaSymbol*) dt), NULL));
		_vala_code_node_unref0 (_tmp3_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	type_attributes = (_tmp5_ = vala_gidl_parser_get_attributes (self, n, &_tmp4_), type_attributes_length1 = _tmp4_, type_attributes_size = type_attributes_length1, _tmp5_);
	ns_name = NULL;
	if (NULL != type_attributes) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = type_attributes;
			attr_collection_length1 = type_attributes_length1;
			for (attr_it = 0; attr_it < type_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp7_;
					gint nv_size;
					gint nv_length1;
					char** _tmp6_;
					char** nv;
					nv = (_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp6_), nv_size = nv_length1, _tmp7_);
					if (_vala_strcmp0 (nv[0], "cprefix") == 0) {
						ValaUnresolvedSymbol* _tmp9_;
						char* _tmp8_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp9_ = vala_unresolved_symbol_new (NULL, g_utf8_offset_to_pointer (n, g_utf8_strlen (_tmp8_ = vala_gidl_parser_eval (self, nv[1]), -1)), NULL));
						_vala_code_node_unref0 (_tmp9_);
						_g_free0 (_tmp8_);
					} else {
						if (_vala_strcmp0 (nv[0], "name") == 0) {
							ValaUnresolvedSymbol* _tmp11_;
							char* _tmp10_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp11_ = vala_unresolved_symbol_new (NULL, _tmp10_ = vala_gidl_parser_eval (self, nv[1]), NULL));
							_vala_code_node_unref0 (_tmp11_);
							_g_free0 (_tmp10_);
						} else {
							if (_vala_strcmp0 (nv[0], "namespace") == 0) {
								char* _tmp12_;
								ns_name = (_tmp12_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ns_name), _tmp12_);
							} else {
								if (_vala_strcmp0 (nv[0], "rename_to") == 0) {
									ValaUnresolvedSymbol* _tmp14_;
									char* _tmp13_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp14_ = vala_unresolved_symbol_new (NULL, _tmp13_ = vala_gidl_parser_eval (self, nv[1]), NULL));
									_vala_code_node_unref0 (_tmp14_);
									_g_free0 (_tmp13_);
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	if (vala_unresolved_type_get_unresolved_symbol (type) != NULL) {
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol (type)), "pointer") == 0) {
			ValaVoidType* _tmp15_;
			ValaDataType* _tmp16_;
			result = (_tmp16_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp15_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp15_), _tmp16_);
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (dt);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (ns_name);
			return result;
		}
		if (ns_name != NULL) {
			ValaUnresolvedSymbol* _tmp17_;
			vala_unresolved_symbol_set_inner (vala_unresolved_type_get_unresolved_symbol (type), _tmp17_ = vala_unresolved_symbol_new (NULL, ns_name, NULL));
			_vala_code_node_unref0 (_tmp17_);
		}
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (dt);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (ns_name);
		return result;
	}
	if (g_str_has_prefix (n, vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace))) {
		ValaUnresolvedSymbol* _tmp19_;
		ValaUnresolvedSymbol* _tmp18_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp19_ = vala_unresolved_symbol_new (_tmp18_ = vala_unresolved_symbol_new (NULL, vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace), NULL), g_utf8_offset_to_pointer (n, g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace), -1)), NULL));
		_vala_code_node_unref0 (_tmp19_);
		_vala_code_node_unref0 (_tmp18_);
	} else {
		if (g_str_has_prefix (n, "G")) {
			ValaUnresolvedSymbol* _tmp21_;
			ValaUnresolvedSymbol* _tmp20_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp21_ = vala_unresolved_symbol_new (_tmp20_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), g_utf8_offset_to_pointer (n, (glong) 1), NULL));
			_vala_code_node_unref0 (_tmp21_);
			_vala_code_node_unref0 (_tmp20_);
		} else {
			char** _tmp23_;
			gint name_parts_size;
			gint name_parts_length1;
			char** _tmp22_;
			char** name_parts;
			name_parts = (_tmp23_ = _tmp22_ = g_strsplit (n, ".", 2), name_parts_length1 = _vala_array_length (_tmp22_), name_parts_size = name_parts_length1, _tmp23_);
			if (name_parts[1] == NULL) {
				ValaUnresolvedSymbol* _tmp24_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp24_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL));
				_vala_code_node_unref0 (_tmp24_);
			} else {
				ValaUnresolvedSymbol* _tmp26_;
				ValaUnresolvedSymbol* _tmp25_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp26_ = vala_unresolved_symbol_new (_tmp25_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL), name_parts[1], NULL));
				_vala_code_node_unref0 (_tmp26_);
				_vala_code_node_unref0 (_tmp25_);
			}
			name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = (ValaDataType*) type;
	_vala_code_node_unref0 (dt);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ns_name);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaDataType* result;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	type = vala_gidl_parser_parse_type (self, param->type, direction);
	result = type;
	return result;
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const char* name, const char* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result;
	ValaDataType* return_type;
	ValaMethod* m;
	gboolean _tmp1_ = FALSE;
	gboolean add_ellipsis;
	gboolean suppress_throws;
	char** _tmp19_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp18_;
	char** attributes;
	gboolean first;
	ValaFormalParameter* last_param;
	ValaDataType* last_param_type;
	gboolean _tmp130_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_;
		return_type = (_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL), _vala_code_node_unref0 (return_type), _tmp0_);
	}
	m = NULL;
	if (!is_interface) {
		gboolean _tmp2_ = FALSE;
		if (is_constructor) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_str_has_prefix (name, "new");
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaMethod* _tmp3_;
		gboolean _tmp4_ = FALSE;
		m = (_tmp3_ = (ValaMethod*) vala_creation_method_new (NULL, name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (m), _tmp3_);
		vala_method_set_has_construct_function (m, FALSE);
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) m), "new") == 0) {
			vala_symbol_set_name ((ValaSymbol*) m, NULL);
		} else {
			if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) m), "new_")) {
				vala_symbol_set_name ((ValaSymbol*) m, g_utf8_offset_to_pointer (vala_symbol_get_name ((ValaSymbol*) m), g_utf8_strlen ("new_", -1)));
			}
		}
		if (VALA_IS_CLASS (self->priv->current_data_type)) {
			_tmp4_ = res != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			char* _tmp6_;
			char* _tmp5_;
			gboolean _tmp7_;
			if ((_tmp7_ = _vala_strcmp0 (_tmp6_ = g_strdup_printf ("%s*", _tmp5_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE)), res->type->unparsed) != 0, _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_)) {
				vala_creation_method_set_custom_return_type_cname (VALA_CREATION_METHOD (m), res->type->unparsed);
			}
		}
	} else {
		ValaMethod* _tmp8_;
		m = (_tmp8_ = vala_method_new (name, return_type, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (m), _tmp8_);
	}
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (self->priv->current_type_symbol_set != NULL) {
		gee_collection_add ((GeeCollection*) self->priv->current_type_symbol_set, name);
	}
	if (self->priv->current_data_type != NULL) {
		char** _tmp13_;
		gint sig_attributes_size;
		gint sig_attributes_length1;
		gint _tmp11_;
		char* _tmp10_;
		char* _tmp9_;
		char** _tmp12_;
		char** sig_attributes;
		sig_attributes = (_tmp13_ = (_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_ = g_strdup_printf ("%s::%s", _tmp9_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), name), &_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp12_), sig_attributes_length1 = _tmp11_, sig_attributes_size = sig_attributes_length1, _tmp13_);
		if (sig_attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = sig_attributes;
				attr_collection_length1 = sig_attributes_length1;
				for (attr_it = 0; attr_it < sig_attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp15_;
						gint nv_size;
						gint nv_length1;
						char** _tmp14_;
						char** nv;
						gboolean _tmp16_ = FALSE;
						nv = (_tmp15_ = _tmp14_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp14_), nv_size = nv_length1, _tmp15_);
						if (_vala_strcmp0 (nv[0], "has_emitter") == 0) {
							char* _tmp17_;
							_tmp16_ = _vala_strcmp0 (_tmp17_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
							_g_free0 (_tmp17_);
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							result = NULL;
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (return_type);
							_vala_code_node_unref0 (m);
							return result;
						}
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	attributes = (_tmp19_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp18_), attributes_length1 = _tmp18_, attributes_size = attributes_length1, _tmp19_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp21_;
					gint nv_size;
					gint nv_length1;
					char** _tmp20_;
					char** nv;
					nv = (_tmp21_ = _tmp20_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp20_), nv_size = nv_length1, _tmp21_);
					if (_vala_strcmp0 (nv[0], "name") == 0) {
						char* _tmp22_;
						vala_method_set_cname (m, vala_symbol_get_name ((ValaSymbol*) m));
						vala_symbol_set_name ((ValaSymbol*) m, _tmp22_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp22_);
					} else {
						if (_vala_strcmp0 (nv[0], "hidden") == 0) {
							char* _tmp23_;
							gboolean _tmp24_;
							if ((_tmp24_ = _vala_strcmp0 (_tmp23_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp23_), _tmp24_)) {
								result = NULL;
								_g_free0 (attr);
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (return_type);
								_vala_code_node_unref0 (m);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								return result;
							}
						} else {
							if (_vala_strcmp0 (nv[0], "ellipsis") == 0) {
								char* _tmp25_;
								gboolean _tmp26_;
								if ((_tmp26_ = _vala_strcmp0 (_tmp25_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp25_), _tmp26_)) {
									add_ellipsis = TRUE;
								}
							} else {
								if (_vala_strcmp0 (nv[0], "printf_format") == 0) {
									char* _tmp27_;
									gboolean _tmp28_;
									if ((_tmp28_ = _vala_strcmp0 (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
										vala_method_set_printf_format (m, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
										char* _tmp29_;
										gboolean _tmp30_;
										if ((_tmp30_ = _vala_strcmp0 (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp29_), _tmp30_)) {
											vala_data_type_set_value_owned (return_type, TRUE);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "nullable") == 0) {
											char* _tmp31_;
											gboolean _tmp32_;
											if ((_tmp32_ = _vala_strcmp0 (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
												vala_data_type_set_nullable (return_type, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "sentinel") == 0) {
												char* _tmp33_;
												vala_method_set_sentinel (m, _tmp33_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp33_);
											} else {
												if (_vala_strcmp0 (nv[0], "is_array") == 0) {
													char* _tmp34_;
													gboolean _tmp35_;
													if ((_tmp35_ = _vala_strcmp0 (_tmp34_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp34_), _tmp35_)) {
														ValaDataType* _tmp36_;
														return_type = (_tmp36_ = (ValaDataType*) vala_array_type_new (return_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) return_type)), _vala_code_node_unref0 (return_type), _tmp36_);
														vala_method_set_return_type (m, return_type);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "throws") == 0) {
														char* _tmp37_;
														gboolean _tmp38_;
														if ((_tmp38_ = _vala_strcmp0 (_tmp37_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp37_), _tmp38_)) {
															suppress_throws = TRUE;
														}
													} else {
														if (_vala_strcmp0 (nv[0], "no_array_length") == 0) {
															char* _tmp39_;
															gboolean _tmp40_;
															if ((_tmp40_ = _vala_strcmp0 (_tmp39_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp39_), _tmp40_)) {
																vala_method_set_no_array_length (m, TRUE);
															}
														} else {
															if (_vala_strcmp0 (nv[0], "array_null_terminated") == 0) {
																char* _tmp41_;
																gboolean _tmp42_;
																if ((_tmp42_ = _vala_strcmp0 (_tmp41_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp41_), _tmp42_)) {
																	vala_method_set_no_array_length (m, TRUE);
																	vala_method_set_array_null_terminated (m, TRUE);
																}
															} else {
																if (_vala_strcmp0 (nv[0], "type_name") == 0) {
																	char* _tmp43_;
																	ValaUnresolvedSymbol* _tmp44_;
																	ValaUnresolvedSymbol* sym;
																	sym = (_tmp44_ = vala_unresolved_symbol_new (NULL, _tmp43_ = vala_gidl_parser_eval (self, nv[1]), NULL), _g_free0 (_tmp43_), _tmp44_);
																	if (VALA_IS_UNRESOLVED_TYPE (return_type)) {
																		vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (return_type), sym);
																	} else {
																		ValaDataType* _tmp45_;
																		vala_method_set_return_type (m, return_type = (_tmp45_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (sym, vala_code_node_get_source_reference ((ValaCodeNode*) return_type)), _vala_code_node_unref0 (return_type), _tmp45_));
																	}
																	_vala_code_node_unref0 (sym);
																} else {
																	if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
																		char** _tmp49_;
																		gint type_args_size;
																		gint type_args_length1;
																		char** _tmp47_;
																		char* _tmp46_;
																		char** _tmp48_;
																		char** type_args;
																		type_args = (_tmp49_ = (_tmp48_ = _tmp47_ = g_strsplit (_tmp46_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp46_), _tmp48_), type_args_length1 = _vala_array_length (_tmp47_), type_args_size = type_args_length1, _tmp49_);
																		{
																			char** type_arg_collection;
																			int type_arg_collection_length1;
																			int type_arg_it;
																			type_arg_collection = type_args;
																			type_arg_collection_length1 = type_args_length1;
																			for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																				char* type_arg;
																				type_arg = g_strdup (type_arg_collection[type_arg_it]);
																				{
																					ValaUnresolvedSymbol* _tmp50_;
																					ValaUnresolvedType* _tmp51_;
																					ValaUnresolvedType* arg_type;
																					arg_type = (_tmp51_ = vala_unresolved_type_new_from_symbol (_tmp50_ = vala_unresolved_symbol_new (NULL, type_arg, NULL), NULL), _vala_code_node_unref0 (_tmp50_), _tmp51_);
																					vala_data_type_set_value_owned ((ValaDataType*) arg_type, TRUE);
																					vala_data_type_add_type_argument (return_type, (ValaDataType*) arg_type);
																					_g_free0 (type_arg);
																					_vala_code_node_unref0 (arg_type);
																				}
																			}
																		}
																		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
																	} else {
																		if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
																			char* _tmp52_;
																			vala_member_add_cheader_filename ((ValaMember*) m, _tmp52_ = vala_gidl_parser_eval (self, nv[1]));
																			_g_free0 (_tmp52_);
																		} else {
																			if (_vala_strcmp0 (nv[0], "abstract") == 0) {
																				char* _tmp53_;
																				gboolean _tmp54_;
																				if ((_tmp54_ = _vala_strcmp0 (_tmp53_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp53_), _tmp54_)) {
																					vala_method_set_is_abstract (m, TRUE);
																				}
																			} else {
																				if (_vala_strcmp0 (nv[0], "virtual") == 0) {
																					char* _tmp55_;
																					gboolean _tmp56_;
																					if ((_tmp56_ = _vala_strcmp0 (_tmp55_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp55_), _tmp56_)) {
																						vala_method_set_is_virtual (m, TRUE);
																					}
																				} else {
																					if (_vala_strcmp0 (nv[0], "vfunc_name") == 0) {
																						char* _tmp57_;
																						vala_method_set_vfunc_name (m, _tmp57_ = vala_gidl_parser_eval (self, nv[1]));
																						_g_free0 (_tmp57_);
																					} else {
																						if (_vala_strcmp0 (nv[0], "async") == 0) {
																							char* _tmp58_;
																							gboolean _tmp59_;
																							if ((_tmp59_ = _vala_strcmp0 (_tmp58_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp58_), _tmp59_)) {
																								vala_method_set_coroutine (m, TRUE);
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	vala_method_set_cname (m, symbol);
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp72_ = FALSE;
				gboolean _tmp74_ = FALSE;
				char* param_name;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type;
				ValaFormalParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gboolean set_array_length_pos;
				double array_length_pos;
				gboolean set_delegate_target_pos;
				double delegate_target_pos;
				gboolean array_requested;
				char** _tmp80_;
				gint _tmp79_;
				char* _tmp78_;
				gboolean _tmp123_ = FALSE;
				gboolean _tmp127_ = FALSE;
				ValaFormalParameter* _tmp128_;
				ValaDataType* _tmp129_;
				param_node = (GIdlNode*) param;
				if (first) {
					gboolean _tmp60_ = FALSE;
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_ = FALSE;
					first = FALSE;
					if (!VALA_IS_CREATION_METHOD (m)) {
						_tmp62_ = self->priv->current_data_type != NULL;
					} else {
						_tmp62_ = FALSE;
					}
					if (_tmp62_) {
						_tmp61_ = param->type->is_interface;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						gboolean _tmp63_ = FALSE;
						if (_vala_strcmp0 (param_node->name, "self") == 0) {
							_tmp63_ = TRUE;
						} else {
							char* _tmp64_;
							_tmp63_ = g_str_has_suffix (param->type->interface, _tmp64_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE));
							_g_free0 (_tmp64_);
						}
						_tmp60_ = _tmp63_;
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						continue;
					} else {
						gboolean _tmp65_ = FALSE;
						gboolean _tmp66_ = FALSE;
						gboolean _tmp67_ = FALSE;
						if (!VALA_IS_CREATION_METHOD (m)) {
							_tmp67_ = self->priv->current_data_type != NULL;
						} else {
							_tmp67_ = FALSE;
						}
						if (_tmp67_) {
							_tmp66_ = param->type->is_interface;
						} else {
							_tmp66_ = FALSE;
						}
						if (_tmp66_) {
							gboolean _tmp68_ = FALSE;
							if (_vala_strcmp0 (param_node->name, "klass") == 0) {
								_tmp68_ = TRUE;
							} else {
								char* _tmp70_;
								char* _tmp69_;
								_tmp68_ = g_str_has_suffix (param->type->interface, _tmp70_ = g_strdup_printf ("%sClass", _tmp69_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE)));
								_g_free0 (_tmp70_);
								_g_free0 (_tmp69_);
							}
							_tmp65_ = _tmp68_;
						} else {
							_tmp65_ = FALSE;
						}
						if (_tmp65_) {
							vala_method_set_binding (m, MEMBER_BINDING_CLASS);
							if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) m), "class_")) {
								char* _tmp71_;
								vala_symbol_set_name ((ValaSymbol*) m, _tmp71_ = string_substring (vala_symbol_get_name ((ValaSymbol*) m), g_utf8_strlen ("class_", -1), g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) m), -1) - g_utf8_strlen ("class_", -1)));
								_g_free0 (_tmp71_);
							}
							continue;
						} else {
							vala_method_set_binding (m, MEMBER_BINDING_STATIC);
						}
					}
				}
				if (_vala_strcmp0 (param->type->interface, "GAsyncReadyCallback") == 0) {
					gboolean _tmp73_ = FALSE;
					if (g_str_has_suffix (symbol, "_async")) {
						_tmp73_ = TRUE;
					} else {
						_tmp73_ = vala_method_get_coroutine (m);
					}
					_tmp72_ = _tmp73_;
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					vala_method_set_coroutine (m, TRUE);
					continue;
				}
				if (suppress_throws == FALSE) {
					_tmp74_ = vala_gidl_parser_param_is_exception (self, param);
				} else {
					_tmp74_ = FALSE;
				}
				if (_tmp74_) {
					ValaDataType* _tmp75_;
					vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp75_ = vala_gidl_parser_parse_type (self, param->type, NULL));
					_vala_code_node_unref0 (_tmp75_);
					continue;
				}
				param_name = g_strdup (param_node->name);
				if (_vala_strcmp0 (param_name, "result") == 0) {
					char* _tmp76_;
					param_name = (_tmp76_ = g_strdup ("_result"), _g_free0 (param_name), _tmp76_);
				} else {
					if (_vala_strcmp0 (param_name, "string") == 0) {
						char* _tmp77_;
						param_name = (_tmp77_ = g_strdup ("str"), _g_free0 (param_name), _tmp77_);
					}
				}
				param_type = vala_gidl_parser_parse_param (self, param, &direction);
				p = vala_formal_parameter_new (param_name, param_type, NULL);
				vala_formal_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (double) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (double) 0;
				array_requested = FALSE;
				attributes = (_tmp80_ = vala_gidl_parser_get_attributes (self, _tmp78_ = g_strdup_printf ("%s.%s", symbol, param_node->name), &_tmp79_), attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL), attributes_length1 = _tmp79_, attributes_size = attributes_length1, _tmp80_);
				_g_free0 (_tmp78_);
				if (attributes != NULL) {
					{
						char** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							char* attr;
							attr = g_strdup (attr_collection[attr_it]);
							{
								char** _tmp82_;
								gint nv_size;
								gint nv_length1;
								char** _tmp81_;
								char** nv;
								nv = (_tmp82_ = _tmp81_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp81_), nv_size = nv_length1, _tmp82_);
								if (_vala_strcmp0 (nv[0], "is_array") == 0) {
									char* _tmp83_;
									gboolean _tmp84_;
									if ((_tmp84_ = _vala_strcmp0 (_tmp83_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp83_), _tmp84_)) {
										ValaDataType* _tmp85_;
										param_type = (_tmp85_ = (ValaDataType*) vala_array_type_new (param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) param_type)), _vala_code_node_unref0 (param_type), _tmp85_);
										vala_formal_parameter_set_parameter_type (p, param_type);
										vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										array_requested = TRUE;
									}
								} else {
									if (_vala_strcmp0 (nv[0], "is_out") == 0) {
										char* _tmp86_;
										gboolean _tmp87_;
										if ((_tmp87_ = _vala_strcmp0 (_tmp86_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp86_), _tmp87_)) {
											gboolean _tmp88_ = FALSE;
											vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											if (!array_requested) {
												_tmp88_ = VALA_IS_ARRAY_TYPE (param_type);
											} else {
												_tmp88_ = FALSE;
											}
											if (_tmp88_) {
												ValaArrayType* array_type;
												ValaDataType* _tmp89_;
												array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
												param_type = (_tmp89_ = _vala_code_node_ref0 (vala_array_type_get_element_type (array_type)), _vala_code_node_unref0 (param_type), _tmp89_);
												vala_formal_parameter_set_parameter_type (p, param_type);
												_vala_code_node_unref0 (array_type);
											}
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_ref") == 0) {
											char* _tmp90_;
											gboolean _tmp91_;
											if ((_tmp91_ = _vala_strcmp0 (_tmp90_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp90_), _tmp91_)) {
												gboolean _tmp92_ = FALSE;
												vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												if (!array_requested) {
													_tmp92_ = VALA_IS_ARRAY_TYPE (param_type);
												} else {
													_tmp92_ = FALSE;
												}
												if (_tmp92_) {
													ValaArrayType* array_type;
													ValaDataType* _tmp93_;
													array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
													param_type = (_tmp93_ = _vala_code_node_ref0 (vala_array_type_get_element_type (array_type)), _vala_code_node_unref0 (param_type), _tmp93_);
													vala_formal_parameter_set_parameter_type (p, param_type);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											if (_vala_strcmp0 (nv[0], "nullable") == 0) {
												char* _tmp94_;
												gboolean _tmp95_;
												if ((_tmp95_ = _vala_strcmp0 (_tmp94_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp94_), _tmp95_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
													char* _tmp96_;
													gboolean _tmp97_;
													if ((_tmp97_ = _vala_strcmp0 (_tmp96_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp96_), _tmp97_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "takes_ownership") == 0) {
														char* _tmp98_;
														gboolean _tmp99_;
														if ((_tmp99_ = _vala_strcmp0 (_tmp98_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp98_), _tmp99_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "value_owned") == 0) {
															char* _tmp100_;
															gboolean _tmp101_;
															if ((_tmp101_ = _vala_strcmp0 (_tmp100_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp100_), _tmp101_)) {
																vala_data_type_set_value_owned (param_type, FALSE);
															} else {
																char* _tmp102_;
																gboolean _tmp103_;
																if ((_tmp103_ = _vala_strcmp0 (_tmp102_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp102_), _tmp103_)) {
																	vala_data_type_set_value_owned (param_type, TRUE);
																}
															}
														} else {
															if (_vala_strcmp0 (nv[0], "hidden") == 0) {
																char* _tmp104_;
																gboolean _tmp105_;
																if ((_tmp105_ = _vala_strcmp0 (_tmp104_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp104_), _tmp105_)) {
																	hide_param = TRUE;
																} else {
																	char* _tmp106_;
																	gboolean _tmp107_;
																	if ((_tmp107_ = _vala_strcmp0 (_tmp106_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp106_), _tmp107_)) {
																		show_param = TRUE;
																	}
																}
															} else {
																if (_vala_strcmp0 (nv[0], "no_array_length") == 0) {
																	char* _tmp108_;
																	gboolean _tmp109_;
																	if ((_tmp109_ = _vala_strcmp0 (_tmp108_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp108_), _tmp109_)) {
																		vala_formal_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (_vala_strcmp0 (nv[0], "array_null_terminated") == 0) {
																		char* _tmp110_;
																		gboolean _tmp111_;
																		if ((_tmp111_ = _vala_strcmp0 (_tmp110_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp110_), _tmp111_)) {
																			vala_formal_parameter_set_no_array_length (p, TRUE);
																			vala_formal_parameter_set_array_null_terminated (p, TRUE);
																		}
																	} else {
																		if (_vala_strcmp0 (nv[0], "array_length_pos") == 0) {
																			char* _tmp112_;
																			set_array_length_pos = TRUE;
																			array_length_pos = g_ascii_strtod (_tmp112_ = vala_gidl_parser_eval (self, nv[1]), NULL);
																			_g_free0 (_tmp112_);
																		} else {
																			if (_vala_strcmp0 (nv[0], "delegate_target_pos") == 0) {
																				char* _tmp113_;
																				set_delegate_target_pos = TRUE;
																				delegate_target_pos = g_ascii_strtod (_tmp113_ = vala_gidl_parser_eval (self, nv[1]), NULL);
																				_g_free0 (_tmp113_);
																			} else {
																				if (_vala_strcmp0 (nv[0], "type_name") == 0) {
																					ValaUnresolvedSymbol* _tmp115_;
																					char* _tmp114_;
																					vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), _tmp115_ = vala_unresolved_symbol_new (NULL, _tmp114_ = vala_gidl_parser_eval (self, nv[1]), NULL));
																					_vala_code_node_unref0 (_tmp115_);
																					_g_free0 (_tmp114_);
																				} else {
																					if (_vala_strcmp0 (nv[0], "ctype") == 0) {
																						char* _tmp116_;
																						vala_formal_parameter_set_ctype (p, _tmp116_ = vala_gidl_parser_eval (self, nv[1]));
																						_g_free0 (_tmp116_);
																					} else {
																						if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
																							char** _tmp120_;
																							gint type_args_size;
																							gint type_args_length1;
																							char** _tmp118_;
																							char* _tmp117_;
																							char** _tmp119_;
																							char** type_args;
																							type_args = (_tmp120_ = (_tmp119_ = _tmp118_ = g_strsplit (_tmp117_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp117_), _tmp119_), type_args_length1 = _vala_array_length (_tmp118_), type_args_size = type_args_length1, _tmp120_);
																							{
																								char** type_arg_collection;
																								int type_arg_collection_length1;
																								int type_arg_it;
																								type_arg_collection = type_args;
																								type_arg_collection_length1 = type_args_length1;
																								for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																									char* type_arg;
																									type_arg = g_strdup (type_arg_collection[type_arg_it]);
																									{
																										ValaUnresolvedSymbol* _tmp121_;
																										ValaUnresolvedType* _tmp122_;
																										ValaUnresolvedType* arg_type;
																										arg_type = (_tmp122_ = vala_unresolved_type_new_from_symbol (_tmp121_ = vala_unresolved_symbol_new (NULL, type_arg, NULL), NULL), _vala_code_node_unref0 (_tmp121_), _tmp122_);
																										vala_data_type_set_value_owned ((ValaDataType*) arg_type, TRUE);
																										vala_data_type_add_type_argument (param_type, (ValaDataType*) arg_type);
																										_g_free0 (type_arg);
																										_vala_code_node_unref0 (arg_type);
																									}
																								}
																							}
																							type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								_g_free0 (attr);
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				if (last_param != NULL) {
					char* _tmp124_;
					_tmp123_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), _tmp124_ = g_strconcat ("n_", vala_symbol_get_name ((ValaSymbol*) last_param), NULL)) == 0;
					_g_free0 (_tmp124_);
				} else {
					_tmp123_ = FALSE;
				}
				if (_tmp123_) {
					if (!VALA_IS_ARRAY_TYPE (last_param_type)) {
						ValaDataType* _tmp125_;
						last_param_type = (_tmp125_ = (ValaDataType*) vala_array_type_new (last_param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) last_param_type)), _vala_code_node_unref0 (last_param_type), _tmp125_);
						vala_formal_parameter_set_parameter_type (last_param, last_param_type);
						vala_formal_parameter_set_direction (last_param, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp126_ = FALSE;
					if (last_param != NULL) {
						_tmp126_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "user_data") == 0;
					} else {
						_tmp126_ = FALSE;
					}
					if (_tmp126_) {
						hide_param = TRUE;
					}
				}
				if (show_param) {
					_tmp127_ = TRUE;
				} else {
					_tmp127_ = !hide_param;
				}
				if (_tmp127_) {
					vala_method_add_parameter (m, p);
					if (set_array_length_pos) {
						vala_formal_parameter_set_carray_length_parameter_position (p, array_length_pos);
					}
					if (set_delegate_target_pos) {
						vala_formal_parameter_set_cdelegate_target_parameter_position (p, delegate_target_pos);
					}
				}
				last_param = (_tmp128_ = _vala_code_node_ref0 (p), _vala_code_node_unref0 (last_param), _tmp128_);
				last_param_type = (_tmp129_ = _vala_code_node_ref0 (param_type), _vala_code_node_unref0 (last_param_type), _tmp129_);
				_g_free0 (param_name);
				_vala_code_node_unref0 (param_type);
				_vala_code_node_unref0 (p);
			}
		}
	}
	if (first) {
		vala_method_set_binding (m, MEMBER_BINDING_STATIC);
	}
	if (last_param != NULL) {
		_tmp130_ = g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) last_param), "first_");
	} else {
		_tmp130_ = FALSE;
	}
	if (_tmp130_) {
		vala_formal_parameter_set_ellipsis (last_param, TRUE);
	} else {
		if (add_ellipsis) {
			ValaFormalParameter* _tmp131_;
			vala_method_add_parameter (m, _tmp131_ = vala_formal_parameter_new_with_ellipsis (NULL));
			_vala_code_node_unref0 (_tmp131_);
		}
	}
	result = m;
	_vala_code_node_unref0 (return_type);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (last_param);
	_vala_code_node_unref0 (last_param_type);
	return result;
}


static char* string_chomp (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result;
	char* s;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	if (!param->type->is_error) {
		result = FALSE;
		return result;
	}
	s = string_chomp (param->type->unparsed);
	if (g_str_has_suffix (s, "**")) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result;
	GIdlNode* node;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	if (f->deprecated) {
		result = NULL;
		return result;
	}
	result = vala_gidl_parser_create_method (self, node->name, f->symbol, f->result, f->parameters, f->is_constructor, is_interface);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result;
	GIdlNode* node;
	char* _tmp0_;
	char* _tmp1_;
	char* symbol;
	GList* _tmp3_;
	ValaMethod* m;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	symbol = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self->priv->current_data_type), node->name), _g_free0 (_tmp0_), _tmp1_);
	if (func != NULL) {
		char* _tmp2_;
		symbol = (_tmp2_ = g_strdup (func->symbol), _g_free0 (symbol), _tmp2_);
	}
	_tmp3_ = NULL;
	if (func != NULL) {
		_tmp3_ = func->parameters;
	} else {
		_tmp3_ = v->parameters;
	}
	m = vala_gidl_parser_create_method (self, node->name, symbol, v->result, _tmp3_, FALSE, is_interface);
	if (m != NULL) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		char** _tmp7_;
		gint attributes_size;
		gint attributes_length1;
		gint _tmp6_;
		char** attributes;
		vala_method_set_binding (m, MEMBER_BINDING_INSTANCE);
		if (vala_method_get_is_abstract (m)) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = is_interface;
		}
		vala_method_set_is_virtual (m, !_tmp4_);
		if (vala_method_get_is_abstract (m)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = is_interface;
		}
		vala_method_set_is_abstract (m, _tmp5_);
		attributes = (_tmp7_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp6_), attributes_length1 = _tmp6_, attributes_size = attributes_length1, _tmp7_);
		if (attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp9_;
						gint nv_size;
						gint nv_length1;
						char** _tmp8_;
						char** nv;
						nv = (_tmp9_ = _tmp8_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp8_), nv_size = nv_length1, _tmp9_);
						if (_vala_strcmp0 (nv[0], "virtual") == 0) {
							char* _tmp10_;
							gboolean _tmp11_;
							if ((_tmp11_ = _vala_strcmp0 (_tmp10_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp10_), _tmp11_)) {
								vala_method_set_is_virtual (m, FALSE);
								vala_method_set_is_abstract (m, FALSE);
							}
						}
						_g_free0 (attr);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
		if (func == NULL) {
			((ValaCodeNode*) m)->attributes = g_list_append (((ValaCodeNode*) m)->attributes, vala_attribute_new ("NoWrapper", NULL));
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static char* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const char* name) {
	char* result;
	GString* str;
	char* i;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	str = g_string_new ("");
	i = g_strdup (name);
	while (TRUE) {
		gunichar c;
		char* _tmp0_;
		if (!(g_utf8_strlen (i, -1) > 0)) {
			break;
		}
		c = g_utf8_get_char (i);
		if (c == '-') {
			g_string_append_c (str, '_');
		} else {
			g_string_append_unichar (str, c);
		}
		i = (_tmp0_ = g_strdup (g_utf8_next_char (i)), _g_free0 (i), _tmp0_);
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
	_g_free0 (i);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp2_;
	char* _tmp1_;
	ValaProperty* _tmp3_;
	ValaProperty* prop;
	gboolean _tmp4_ = FALSE;
	char** _tmp13_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp11_;
	char* _tmp10_;
	char* _tmp9_;
	char** _tmp12_;
	char** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	if (prop_node->deprecated) {
		result = NULL;
		return result;
	}
	if (!prop_node->readable) {
		_tmp0_ = !prop_node->writable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	prop = (_tmp3_ = vala_property_new (_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name), _tmp2_ = vala_gidl_parser_parse_type (self, prop_node->type, NULL), NULL, NULL, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_property_set_interface_only (prop, TRUE);
	if (prop_node->type->is_interface) {
		_tmp4_ = _vala_strcmp0 (prop_node->type->interface, "GStrv") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		vala_property_set_no_array_length (prop, TRUE);
		vala_property_set_array_null_terminated (prop, TRUE);
	}
	if (prop_node->readable) {
		ValaPropertyAccessor* _tmp6_;
		ValaDataType* _tmp5_;
		vala_property_set_get_accessor (prop, _tmp6_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp5_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, NULL));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp5_);
	}
	if (prop_node->writable) {
		ValaPropertyAccessor* _tmp8_;
		ValaDataType* _tmp7_;
		vala_property_set_set_accessor (prop, _tmp8_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp7_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, NULL));
		_vala_code_node_unref0 (_tmp8_);
		_vala_code_node_unref0 (_tmp7_);
		if (prop_node->construct_only) {
			vala_property_accessor_set_construction (vala_property_get_set_accessor (prop), TRUE);
		} else {
			vala_property_accessor_set_writable (vala_property_get_set_accessor (prop), TRUE);
			vala_property_accessor_set_construction (vala_property_get_set_accessor (prop), prop_node->construct);
		}
	}
	attributes = (_tmp13_ = (_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_ = g_strdup_printf ("%s:%s", _tmp9_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), node->name), &_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp12_), attributes_length1 = _tmp11_, attributes_size = attributes_length1, _tmp13_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp15_;
					gint nv_size;
					gint nv_length1;
					char** _tmp14_;
					char** nv;
					nv = (_tmp15_ = _tmp14_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp14_), nv_size = nv_length1, _tmp15_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						char* _tmp16_;
						gboolean _tmp17_;
						if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
							result = NULL;
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					} else {
						if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
							char** _tmp21_;
							gint type_args_size;
							gint type_args_length1;
							char** _tmp19_;
							char* _tmp18_;
							char** _tmp20_;
							char** type_args;
							type_args = (_tmp21_ = (_tmp20_ = _tmp19_ = g_strsplit (_tmp18_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp18_), _tmp20_), type_args_length1 = _vala_array_length (_tmp19_), type_args_size = type_args_length1, _tmp21_);
							{
								char** type_arg_collection;
								int type_arg_collection_length1;
								int type_arg_it;
								type_arg_collection = type_args;
								type_arg_collection_length1 = type_args_length1;
								for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
									char* type_arg;
									type_arg = g_strdup (type_arg_collection[type_arg_it]);
									{
										ValaUnresolvedSymbol* _tmp22_;
										ValaUnresolvedType* _tmp23_;
										ValaUnresolvedType* arg_type;
										arg_type = (_tmp23_ = vala_unresolved_type_new_from_symbol (_tmp22_ = vala_unresolved_symbol_new (NULL, type_arg, NULL), NULL), _vala_code_node_unref0 (_tmp22_), _tmp23_);
										vala_data_type_set_value_owned ((ValaDataType*) arg_type, TRUE);
										vala_data_type_add_type_argument (vala_property_get_property_type (prop), (ValaDataType*) arg_type);
										_g_free0 (type_arg);
										_vala_code_node_unref0 (arg_type);
									}
								}
							}
							type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (_vala_strcmp0 (nv[0], "accessor_method") == 0) {
								char* _tmp24_;
								gboolean _tmp25_;
								if ((_tmp25_ = _vala_strcmp0 (_tmp24_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp24_), _tmp25_)) {
									vala_property_set_no_accessor_method (prop, TRUE);
								}
							} else {
								if (_vala_strcmp0 (nv[0], "owned_get") == 0) {
									char* _tmp26_;
									gboolean _tmp27_;
									if ((_tmp27_ = _vala_strcmp0 (_tmp26_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp26_), _tmp27_)) {
										vala_data_type_set_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)), TRUE);
									}
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	if (self->priv->current_type_symbol_set != NULL) {
		gee_collection_add ((GeeCollection*) self->priv->current_type_symbol_set, vala_symbol_get_name ((ValaSymbol*) prop));
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result;
	GIdlNode* node;
	ValaDataType* type;
	ValaConstant* c;
	char** _tmp1_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp0_;
	char** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	type = vala_gidl_parser_parse_type (self, const_node->type, NULL);
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	c = vala_constant_new (node->name, type, NULL, self->priv->current_source_reference, NULL);
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp0_), attributes_length1 = _tmp0_, attributes_size = attributes_length1, _tmp1_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint nv_size;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), nv_size = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
						char* _tmp4_;
						vala_member_add_cheader_filename ((ValaMember*) c, _tmp4_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp4_);
					} else {
						if (_vala_strcmp0 (nv[0], "hidden") == 0) {
							char* _tmp5_;
							gboolean _tmp6_;
							if ((_tmp6_ = _vala_strcmp0 (_tmp5_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp5_), _tmp6_)) {
								result = NULL;
								_g_free0 (attr);
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (type);
								_vala_code_node_unref0 (c);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								return result;
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	_vala_code_node_unref0 (type);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result;
	GIdlNode* node;
	gboolean unhidden;
	ValaDataType* type;
	char* cheader_filename;
	char* ctype;
	gboolean array_null_terminated;
	char** _tmp4_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char** _tmp3_;
	char** attributes;
	gboolean _tmp26_ = FALSE;
	char* field_name;
	ValaField* field;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	type = vala_gidl_parser_parse_type (self, field_node->type, NULL);
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_null_terminated = FALSE;
	attributes = (_tmp4_ = (_tmp3_ = vala_gidl_parser_get_attributes (self, _tmp1_ = g_strdup_printf ("%s.%s", _tmp0_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), node->name), &_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_), attributes_length1 = _tmp2_, attributes_size = attributes_length1, _tmp4_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp6_;
					gint nv_size;
					gint nv_length1;
					char** _tmp5_;
					char** nv;
					nv = (_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp5_), nv_size = nv_length1, _tmp6_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						char* _tmp7_;
						gboolean _tmp8_;
						if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp7_), _tmp8_)) {
							result = NULL;
							_g_free0 (attr);
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (type);
							_g_free0 (cheader_filename);
							_g_free0 (ctype);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						if (_vala_strcmp0 (nv[0], "is_array") == 0) {
							char* _tmp9_;
							gboolean _tmp10_;
							if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp9_), _tmp10_)) {
								ValaDataType* _tmp11_;
								type = (_tmp11_ = (ValaDataType*) vala_array_type_new (type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type)), _vala_code_node_unref0 (type), _tmp11_);
							}
						} else {
							if (_vala_strcmp0 (nv[0], "weak") == 0) {
								char* _tmp12_;
								gboolean _tmp13_;
								if ((_tmp13_ = _vala_strcmp0 (_tmp12_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp12_), _tmp13_)) {
									vala_data_type_set_value_owned (type, TRUE);
								}
							} else {
								if (_vala_strcmp0 (nv[0], "type_name") == 0) {
									ValaUnresolvedSymbol* _tmp15_;
									char* _tmp14_;
									vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (type), _tmp15_ = vala_unresolved_symbol_new (NULL, _tmp14_ = vala_gidl_parser_eval (self, nv[1]), NULL));
									_vala_code_node_unref0 (_tmp15_);
									_g_free0 (_tmp14_);
								} else {
									if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
										char** _tmp19_;
										gint type_args_size;
										gint type_args_length1;
										char** _tmp17_;
										char* _tmp16_;
										char** _tmp18_;
										char** type_args;
										type_args = (_tmp19_ = (_tmp18_ = _tmp17_ = g_strsplit (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp16_), _tmp18_), type_args_length1 = _vala_array_length (_tmp17_), type_args_size = type_args_length1, _tmp19_);
										{
											char** type_arg_collection;
											int type_arg_collection_length1;
											int type_arg_it;
											type_arg_collection = type_args;
											type_arg_collection_length1 = type_args_length1;
											for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
												char* type_arg;
												type_arg = g_strdup (type_arg_collection[type_arg_it]);
												{
													ValaUnresolvedSymbol* _tmp20_;
													ValaUnresolvedType* _tmp21_;
													ValaUnresolvedType* arg_type;
													arg_type = (_tmp21_ = vala_unresolved_type_new_from_symbol (_tmp20_ = vala_unresolved_symbol_new (NULL, type_arg, NULL), NULL), _vala_code_node_unref0 (_tmp20_), _tmp21_);
													vala_data_type_set_value_owned ((ValaDataType*) arg_type, TRUE);
													vala_data_type_add_type_argument (type, (ValaDataType*) arg_type);
													_g_free0 (type_arg);
													_vala_code_node_unref0 (arg_type);
												}
											}
										}
										type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
									} else {
										if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
											char* _tmp22_;
											cheader_filename = (_tmp22_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (cheader_filename), _tmp22_);
										} else {
											if (_vala_strcmp0 (nv[0], "ctype") == 0) {
												char* _tmp23_;
												ctype = (_tmp23_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ctype), _tmp23_);
											} else {
												if (_vala_strcmp0 (nv[0], "array_null_terminated") == 0) {
													char* _tmp24_;
													gboolean _tmp25_;
													if ((_tmp25_ = _vala_strcmp0 (_tmp24_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
														array_null_terminated = TRUE;
													}
												}
											}
										}
									}
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	if (g_str_has_prefix (node->name, "_")) {
		_tmp26_ = !unhidden;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		result = NULL;
		_vala_code_node_unref0 (type);
		_g_free0 (cheader_filename);
		_g_free0 (ctype);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (self->priv->current_type_symbol_set != NULL) {
		gee_collection_add ((GeeCollection*) self->priv->current_type_symbol_set, node->name);
	}
	field_name = g_strdup (node->name);
	if (_vala_strcmp0 (field_name, "string") == 0) {
		char* _tmp27_;
		field_name = (_tmp27_ = g_strdup ("str"), _g_free0 (field_name), _tmp27_);
	}
	field = vala_field_new (field_name, type, NULL, self->priv->current_source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (_vala_strcmp0 (field_name, node->name) != 0) {
		vala_field_set_cname (field, node->name);
	}
	if (ctype != NULL) {
		vala_field_set_ctype (field, ctype);
	}
	if (cheader_filename != NULL) {
		vala_member_add_cheader_filename ((ValaMember*) field, cheader_filename);
	}
	vala_field_set_no_array_length (field, TRUE);
	if (array_null_terminated) {
		vala_field_set_array_null_terminated (field, TRUE);
	}
	result = field;
	_vala_code_node_unref0 (type);
	_g_free0 (cheader_filename);
	_g_free0 (ctype);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (field_name);
	return result;
}


static char** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const char* codenode, int* result_length1) {
	char** result;
	char* attributes;
	char** _tmp6_;
	char** _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	attributes = (char*) gee_map_get (self->priv->codenode_attributes_map, codenode);
	if (attributes == NULL) {
		gboolean dot_required;
		gboolean colon_required;
		GeeSet* pattern_specs;
		dot_required = NULL != g_utf8_strchr (codenode, (gssize) (-1), (gunichar) '.');
		colon_required = NULL != g_utf8_strchr (codenode, (gssize) (-1), (gunichar) ':');
		pattern_specs = gee_map_get_keys (self->priv->codenode_attributes_patterns);
		{
			GeeIterator* _pattern_it;
			_pattern_it = gee_iterable_iterator ((GeeIterable*) pattern_specs);
			while (TRUE) {
				GPatternSpec* pattern;
				char* pspec;
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_ = FALSE;
				if (!gee_iterator_next (_pattern_it)) {
					break;
				}
				pattern = gee_iterator_get (_pattern_it);
				pspec = (char*) gee_map_get (self->priv->codenode_attributes_patterns, pattern);
				if (dot_required) {
					_tmp1_ = NULL == g_utf8_strchr (pspec, (gssize) (-1), (gunichar) '.');
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					_tmp0_ = TRUE;
				} else {
					gboolean _tmp2_ = FALSE;
					if (colon_required) {
						_tmp2_ = NULL == g_utf8_strchr (pspec, (gssize) (-1), (gunichar) ':');
					} else {
						_tmp2_ = FALSE;
					}
					_tmp0_ = _tmp2_;
				}
				if (_tmp0_) {
					_g_free0 (pspec);
					continue;
				}
				if (g_pattern_match_string (pattern, codenode)) {
					gint _tmp3_;
					char** _tmp4_;
					result = (_tmp4_ = vala_gidl_parser_get_attributes (self, pspec, &_tmp3_), *result_length1 = _tmp3_, _tmp4_);
					_g_free0 (pspec);
					_gee_collection_object_unref0 (_pattern_it);
					_gee_collection_object_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_gee_collection_object_unref0 (_pattern_it);
		}
		_gee_collection_object_unref0 (pattern_specs);
	}
	if (attributes == NULL) {
		gpointer _tmp5_;
		result = (_tmp5_ = NULL, *result_length1 = 0, _tmp5_);
		_g_free0 (attributes);
		return result;
	}
	result = (_tmp7_ = _tmp6_ = g_strsplit (attributes, " ", 0), *result_length1 = _vala_array_length (_tmp6_), _tmp7_);
	_g_free0 (attributes);
	return result;
	_g_free0 (attributes);
}


static char* vala_gidl_parser_eval (ValaGIdlParser* self, const char* s) {
	char* result;
	char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = NULL;
	if (strlen (s) >= 2) {
		_tmp2_ = g_str_has_prefix (s, "\"");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_str_has_suffix (s, "\"");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp3_;
		_tmp0_ = (_tmp3_ = g_strndup (g_utf8_offset_to_pointer (s, (glong) 1), strlen (s) - 2), _g_free0 (_tmp0_), _tmp3_);
	} else {
		char* _tmp4_;
		_tmp0_ = (_tmp4_ = g_strdup (s), _g_free0 (_tmp0_), _tmp4_);
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp2_;
	char* _tmp1_;
	ValaSignal* _tmp3_;
	ValaSignal* sig;
	char** _tmp8_;
	gint attributes_size;
	gint attributes_length1;
	gint _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	char** _tmp7_;
	char** attributes;
	gboolean first;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	if (sig_node->deprecated) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sig_node->result == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	sig = (_tmp3_ = vala_signal_new (_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name), _tmp2_ = vala_gidl_parser_parse_param (self, sig_node->result, NULL), self->priv->current_source_reference, NULL), _vala_code_node_unref0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	attributes = (_tmp8_ = (_tmp7_ = vala_gidl_parser_get_attributes (self, _tmp5_ = g_strdup_printf ("%s::%s", _tmp4_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), vala_symbol_get_name ((ValaSymbol*) sig)), &_tmp6_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp7_), attributes_length1 = _tmp6_, attributes_size = attributes_length1, _tmp8_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp10_;
					gint nv_size;
					gint nv_length1;
					char** _tmp9_;
					char** nv;
					nv = (_tmp10_ = _tmp9_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp9_), nv_size = nv_length1, _tmp10_);
					if (_vala_strcmp0 (nv[0], "name") == 0) {
						char* _tmp11_;
						vala_signal_set_cname (sig, vala_symbol_get_name ((ValaSymbol*) sig));
						vala_symbol_set_name ((ValaSymbol*) sig, _tmp11_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp11_);
					} else {
						gboolean _tmp12_ = FALSE;
						if (_vala_strcmp0 (nv[0], "has_emitter") == 0) {
							char* _tmp13_;
							_tmp12_ = _vala_strcmp0 (_tmp13_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
							_g_free0 (_tmp13_);
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							vala_signal_set_has_emitter (sig, TRUE);
						} else {
							if (_vala_strcmp0 (nv[0], "hidden") == 0) {
								char* _tmp14_;
								gboolean _tmp15_;
								if ((_tmp15_ = _vala_strcmp0 (_tmp14_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp14_), _tmp15_)) {
									result = NULL;
									_g_free0 (attr);
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									return result;
								}
							}
						}
					}
					_g_free0 (attr);
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	vala_signal_set_is_virtual (sig, TRUE);
	first = TRUE;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = sig_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type;
				ValaFormalParameter* p;
				char** _tmp19_;
				gint _tmp18_;
				char* _tmp17_;
				char* _tmp16_;
				if (first) {
					first = FALSE;
					continue;
				}
				param_node = (GIdlNode*) param;
				param_type = vala_gidl_parser_parse_param (self, param, &direction);
				p = vala_formal_parameter_new (param_node->name, param_type, NULL);
				vala_formal_parameter_set_direction (p, direction);
				vala_signal_add_parameter (sig, p);
				attributes = (_tmp19_ = vala_gidl_parser_get_attributes (self, _tmp17_ = g_strdup_printf ("%s::%s.%s", _tmp16_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), vala_symbol_get_name ((ValaSymbol*) sig), param_node->name), &_tmp18_), attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL), attributes_length1 = _tmp18_, attributes_size = attributes_length1, _tmp19_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp16_);
				if (attributes != NULL) {
					char* ns_name;
					ns_name = NULL;
					{
						char** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							char* attr;
							attr = g_strdup (attr_collection[attr_it]);
							{
								char** _tmp21_;
								gint nv_size;
								gint nv_length1;
								char** _tmp20_;
								char** nv;
								nv = (_tmp21_ = _tmp20_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp20_), nv_size = nv_length1, _tmp21_);
								if (_vala_strcmp0 (nv[0], "is_array") == 0) {
									char* _tmp22_;
									gboolean _tmp23_;
									if ((_tmp23_ = _vala_strcmp0 (_tmp22_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp22_), _tmp23_)) {
										ValaDataType* _tmp24_;
										param_type = (_tmp24_ = (ValaDataType*) vala_array_type_new (param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) param_type)), _vala_code_node_unref0 (param_type), _tmp24_);
										vala_formal_parameter_set_parameter_type (p, param_type);
										vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "is_out") == 0) {
										char* _tmp25_;
										gboolean _tmp26_;
										if ((_tmp26_ = _vala_strcmp0 (_tmp25_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp25_), _tmp26_)) {
											vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_ref") == 0) {
											char* _tmp27_;
											gboolean _tmp28_;
											if ((_tmp28_ = _vala_strcmp0 (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
												vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "nullable") == 0) {
												char* _tmp29_;
												gboolean _tmp30_;
												if ((_tmp30_ = _vala_strcmp0 (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp29_), _tmp30_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
													char* _tmp31_;
													gboolean _tmp32_;
													if ((_tmp32_ = _vala_strcmp0 (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "type_name") == 0) {
														ValaUnresolvedSymbol* _tmp34_;
														char* _tmp33_;
														vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), _tmp34_ = vala_unresolved_symbol_new (NULL, _tmp33_ = vala_gidl_parser_eval (self, nv[1]), NULL));
														_vala_code_node_unref0 (_tmp34_);
														_g_free0 (_tmp33_);
													} else {
														if (_vala_strcmp0 (nv[0], "namespace_name") == 0) {
															char* _tmp35_;
															ns_name = (_tmp35_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ns_name), _tmp35_);
														}
													}
												}
											}
										}
									}
								}
								_g_free0 (attr);
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
					if (ns_name != NULL) {
						ValaUnresolvedSymbol* _tmp36_;
						vala_unresolved_symbol_set_inner (vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type)), _tmp36_ = vala_unresolved_symbol_new (NULL, ns_name, NULL));
						_vala_code_node_unref0 (_tmp36_);
					}
					_g_free0 (ns_name);
				}
				_vala_code_node_unref0 (param_type);
				_vala_code_node_unref0 (p);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gidl_parser_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gidl_parser_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gidl_parser_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gidl_parser_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gidl_parser_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gidl_parser_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gidl_parser_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = VALA_GIDL_PARSER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_gee_collection_object_unref0 (self->priv->codenode_attributes_map);
	_gee_collection_object_unref0 (self->priv->codenode_attributes_patterns);
	_gee_collection_object_unref0 (self->priv->current_type_symbol_set);
	_gee_collection_object_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


GType vala_gidl_parser_get_type (void) {
	static GType vala_gidl_parser_type_id = 0;
	if (vala_gidl_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
	}
	return vala_gidl_parser_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




