/* cogl-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Cogl", lower_case_cprefix = "cogl_")]
namespace Cogl {
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct Angle : int32 {
	}
	[CCode (type_id = "COGL_TYPE_COLOR", cheader_filename = "cogl/cogl.h")]
	public struct Color {
		public uint8 red;
		public uint8 green;
		public uint8 blue;
		public uint8 alpha;
		public uint32 padding0;
		public uint32 padding1;
		public uint32 padding2;
		public Cogl.Color copy ();
		public void free ();
		public float get_alpha ();
		public uint8 get_alpha_byte ();
		public float get_alpha_float ();
		public float get_blue ();
		public uint8 get_blue_byte ();
		public float get_blue_float ();
		public float get_green ();
		public uint8 get_green_byte ();
		public float get_green_float ();
		public float get_red ();
		public uint8 get_red_byte ();
		public float get_red_float ();
		public void set_from_4f (float red, float green, float blue, float alpha);
		public void set_from_4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
	}
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct Fixed : int32 {
	}
	[CCode (type_id = "COGL_TYPE_HANDLE", cheader_filename = "cogl/cogl.h")]
	public struct Handle {
		public int ignoreme;
		public Cogl.Handle @ref ();
		public void unref ();
	}
	[CCode (type_id = "COGL_TYPE_MATRIX", cheader_filename = "cogl/cogl.h")]
	public struct Matrix {
		public float xx;
		public float yx;
		public float zx;
		public float wx;
		public float xy;
		public float yy;
		public float zy;
		public float wy;
		public float xz;
		public float yz;
		public float zz;
		public float wz;
		public float xw;
		public float yw;
		public float zw;
		public float ww;
		public weak float[] _padding0;
		public ulong _padding1;
		public ulong _padding2;
		public ulong _padding3;
	}
	[CCode (type_id = "COGL_TYPE_TEXTURE_VERTEX", cheader_filename = "cogl/cogl.h")]
	public struct TextureVertex {
		public float x;
		public float y;
		public float z;
		public float tx;
		public float ty;
		public Cogl.Color color;
	}
	[CCode (cprefix = "COGL_ATTRIBUTE_TYPE_", cheader_filename = "cogl/cogl.h")]
	public enum AttributeType {
		BYTE,
		UNSIGNED_BYTE,
		SHORT,
		UNSIGNED_SHORT,
		FLOAT
	}
	[CCode (cprefix = "COGL_BUFFER_BIT_", cheader_filename = "cogl/cogl.h")]
	public enum BufferBit {
		COLOR,
		DEPTH,
		STENCIL
	}
	[CCode (cprefix = "COGL_BUFFER_TARGET_", cheader_filename = "cogl/cogl.h")]
	public enum BufferTarget {
		[CCode (cname = "COGL_WINDOW_BUFFER")]
		WINDOW_BUFFER,
		[CCode (cname = "COGL_OFFSCREEN_BUFFER")]
		OFFSCREEN_BUFFER
	}
	[CCode (cprefix = "COGL_DEBUG_FLAGS_", cheader_filename = "cogl/cogl.h")]
	public enum DebugFlags {
		[CCode (cname = "COGL_DEBUG_MISC")]
		MISC,
		[CCode (cname = "COGL_DEBUG_TEXTURE")]
		TEXTURE,
		[CCode (cname = "COGL_DEBUG_MATERIAL")]
		MATERIAL,
		[CCode (cname = "COGL_DEBUG_SHADER")]
		SHADER,
		[CCode (cname = "COGL_DEBUG_OFFSCREEN")]
		OFFSCREEN,
		[CCode (cname = "COGL_DEBUG_DRAW")]
		DRAW,
		[CCode (cname = "COGL_DEBUG_PANGO")]
		PANGO,
		[CCode (cname = "COGL_DEBUG_RECTANGLES")]
		RECTANGLES,
		[CCode (cname = "COGL_DEBUG_HANDLE")]
		HANDLE,
		[CCode (cname = "COGL_DEBUG_BLEND_STRINGS")]
		BLEND_STRINGS
	}
	[CCode (cprefix = "COGL_FEATURE_FLAGS_", cheader_filename = "cogl/cogl.h")]
	public enum FeatureFlags {
		[CCode (cname = "COGL_FEATURE_TEXTURE_RECTANGLE")]
		TEXTURE_RECTANGLE,
		[CCode (cname = "COGL_FEATURE_TEXTURE_NPOT")]
		TEXTURE_NPOT,
		[CCode (cname = "COGL_FEATURE_TEXTURE_YUV")]
		TEXTURE_YUV,
		[CCode (cname = "COGL_FEATURE_TEXTURE_READ_PIXELS")]
		TEXTURE_READ_PIXELS,
		[CCode (cname = "COGL_FEATURE_SHADERS_GLSL")]
		SHADERS_GLSL,
		[CCode (cname = "COGL_FEATURE_OFFSCREEN")]
		OFFSCREEN,
		[CCode (cname = "COGL_FEATURE_OFFSCREEN_MULTISAMPLE")]
		OFFSCREEN_MULTISAMPLE,
		[CCode (cname = "COGL_FEATURE_OFFSCREEN_BLIT")]
		OFFSCREEN_BLIT,
		[CCode (cname = "COGL_FEATURE_FOUR_CLIP_PLANES")]
		FOUR_CLIP_PLANES,
		[CCode (cname = "COGL_FEATURE_STENCIL_BUFFER")]
		STENCIL_BUFFER,
		[CCode (cname = "COGL_FEATURE_VBOS")]
		VBOS
	}
	[CCode (cprefix = "COGL_FOG_MODE_", cheader_filename = "cogl/cogl.h")]
	public enum FogMode {
		LINEAR,
		EXPONENTIAL,
		EXPONENTIAL_SQUARED
	}
	[CCode (cprefix = "COGL_INDICES_TYPE_UNSIGNED_", cheader_filename = "cogl/cogl.h")]
	public enum IndicesType {
		BYTE,
		SHORT,
		INT
	}
	[CCode (cprefix = "COGL_MATERIAL_ALPHA_FUNC_", cheader_filename = "cogl/cogl.h")]
	public enum MaterialAlphaFunc {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cprefix = "COGL_MATERIAL_FILTER_", cheader_filename = "cogl/cogl.h")]
	public enum MaterialFilter {
		NEAREST,
		LINEAR,
		NEAREST_MIPMAP_NEAREST,
		LINEAR_MIPMAP_NEAREST,
		NEAREST_MIPMAP_LINEAR,
		LINEAR_MIPMAP_LINEAR
	}
	[CCode (cprefix = "COGL_MATERIAL_LAYER_TYPE_", cheader_filename = "cogl/cogl.h")]
	public enum MaterialLayerType {
		TEXTURE
	}
	[CCode (cprefix = "COGL_PIXEL_FORMAT_", cheader_filename = "cogl/cogl.h")]
	public enum PixelFormat {
		ANY,
		A_8,
		RGB_565,
		RGBA_4444,
		RGBA_5551,
		YUV,
		G_8,
		RGB_888,
		BGR_888,
		RGBA_8888,
		BGRA_8888,
		ARGB_8888,
		ABGR_8888,
		RGBA_8888_PRE,
		BGRA_8888_PRE,
		ARGB_8888_PRE,
		ABGR_8888_PRE,
		RGBA_4444_PRE,
		RGBA_5551_PRE
	}
	[CCode (cprefix = "COGL_SHADER_TYPE_", cheader_filename = "cogl/cogl.h")]
	public enum ShaderType {
		VERTEX,
		FRAGMENT
	}
	[CCode (cprefix = "COGL_TEXTURE_FLAGS_", cheader_filename = "cogl/cogl.h")]
	public enum TextureFlags {
		[CCode (cname = "COGL_TEXTURE_NONE")]
		NONE,
		[CCode (cname = "COGL_TEXTURE_NO_AUTO_MIPMAP")]
		NO_AUTO_MIPMAP,
		[CCode (cname = "COGL_TEXTURE_NO_SLICING")]
		NO_SLICING
	}
	[CCode (cprefix = "COGL_VERTICES_MODE_", cheader_filename = "cogl/cogl.h")]
	public enum VerticesMode {
		POINTS,
		LINE_STRIP,
		LINE_LOOP,
		LINES,
		TRIANGLE_STRIP,
		TRIANGLE_FAN,
		TRIANGLES
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void FuncPtr ();
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLACTIVETEXTUREPROC (GL.enum texture);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLATTACHOBJECTARBPROC (GL.handleARB containerObj, GL.handleARB obj);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBINDBUFFERARBPROC (GL.enum target, GL.uint buffer);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBINDFRAMEBUFFEREXTPROC (GL.enum target, GL.uint framebuffer);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBINDRENDERBUFFEREXTPROC (GL.enum target, GL.uint renderbuffer);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBLENDCOLORPROC (GL.clampf red, GL.clampf green, GL.clampf blue, GL.clampf alpha);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBLENDEQUATIONPROC (GL.enum mode);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBLENDEQUATIONSEPARATEPROC (GL.enum modeRGB, GL.enum modeAlpha);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBLENDFUNCSEPARATEPROC (GL.enum srcRGB, GL.enum dstRGB, GL.enum srcAlpha, GL.enum dstAlpha);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLBLITFRAMEBUFFEREXTPROC (GL.int srcX0, GL.int srcY0, GL.int srcX1, GL.int srcY1, GL.int dstX0, GL.int dstY0, GL.int dstX1, GL.int dstY1, GL.bitfield mask, GL.enum filter);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate GL.enum PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC (GL.enum target);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLCLIENTACTIVETEXTUREPROC (GL.enum texture);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLCOMPILESHADERARBPROC (GL.handleARB shaderObj);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate GL.handleARB PFNGLCREATEPROGRAMOBJECTARBPROC ();
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate GL.handleARB PFNGLCREATESHADEROBJECTARBPROC (GL.enum shaderType);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLDELETEBUFFERSARBPROC (GL.sizei n, GL.uint buffers);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLDELETEFRAMEBUFFERSEXTPROC (GL.sizei n, GL.uint framebuffers);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLDELETEOBJECTARBPROC (GL.handleARB obj);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLDELETERENDERBUFFERSEXTPROC (GL.sizei n, GL.uint renderbuffers);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLDISABLEVERTEXATTRIBARRAYARBPROC (GL.uint index);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLDRAWRANGEELEMENTSPROC (GL.enum mode, GL.uint start, GL.uint end, GL.sizei count, GL.enum type, void indices);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLENABLEVERTEXATTRIBARRAYARBPROC (GL.uint index);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC (GL.enum target, GL.enum attachment, GL.enum renderbuffertarget, GL.uint renderbuffer);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLFRAMEBUFFERTEXTURE2DEXTPROC (GL.enum target, GL.enum attachment, GL.enum textarget, GL.uint texture, GL.int level);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLGENBUFFERSARBPROC (GL.uint n, GL.uint buffers);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLGENERATEMIPMAPEXTPROC (GL.enum target);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLGENFRAMEBUFFERSEXTPROC (GL.sizei n, GL.uint framebuffers);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLGENRENDERBUFFERSEXTPROC (GL.sizei n, GL.uint renderbuffers);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLGETINFOLOGARBPROC (GL.handleARB obj, GL.sizei maxLength, GL.sizei length, GL.charARB infoLog);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLGETOBJECTPARAMETERIVARBPROC (GL.handleARB obj, GL.enum pname, GL.int @params);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate GL.int PFNGLGETUNIFORMLOCATIONARBPROC (GL.handleARB programObj, GL.charARB name);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLLINKPROGRAMARBPROC (GL.handleARB programObj);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void* PFNGLMAPBUFFERARBPROC (GL.enum target, GL.enum access);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLRENDERBUFFERSTORAGEEXTPROC (GL.enum target, GL.enum internalformat, GL.sizei width, GL.sizei height);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC (GL.enum target, GL.sizei samples, GL.enum internalformat, GL.sizei width, GL.sizei height);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLSHADERSOURCEARBPROC (GL.handleARB shaderObj, GL.sizei count, GL.charARB string, GL.int length);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM1FARBPROC (GL.int location, GL.float v0);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM1FVARBPROC (GL.int location, GL.sizei count, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM1IARBPROC (GL.int location, GL.int v0);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM1IVARBPROC (GL.int location, GL.sizei count, GL.int value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM2FARBPROC (GL.int location, GL.float v0, GL.float v1);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM2FVARBPROC (GL.int location, GL.sizei count, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM2IARBPROC (GL.int location, GL.int v0, GL.int v1);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM2IVARBPROC (GL.int location, GL.sizei count, GL.int value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM3FARBPROC (GL.int location, GL.float v0, GL.float v1, GL.float v2);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM3FVARBPROC (GL.int location, GL.sizei count, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM3IARBPROC (GL.int location, GL.int v0, GL.int v1, GL.int v2);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM3IVARBPROC (GL.int location, GL.sizei count, GL.int value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM4FARBPROC (GL.int location, GL.float v0, GL.float v1, GL.float v2, GL.float v3);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM4FVARBPROC (GL.int location, GL.sizei count, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM4IARBPROC (GL.int location, GL.int v0, GL.int v1, GL.int v2, GL.int v3);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORM4IVARBPROC (GL.int location, GL.sizei count, GL.int value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORMMATRIX2FVARBPROC (GL.int location, GL.sizei count, GL.boolean transpose, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORMMATRIX3FVARBPROC (GL.int location, GL.sizei count, GL.boolean transpose, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUNIFORMMATRIX4FVARBPROC (GL.int location, GL.sizei count, GL.boolean transpose, GL.float value);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate GL.boolean PFNGLUNMAPBUFFERARBPROC (GL.enum target);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLUSEPROGRAMOBJECTARBPROC (GL.handleARB programObj);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void PFNGLVERTEXATTRIBPOINTERARBPROC (GL.uint index, GL.int size, GL.enum type, GL.boolean normalized, GL.sizei stride, void pointer);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int AFIRST_BIT;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int A_BIT;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int BGR_BIT;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int CGL_TEXTURE_RECTANGLE_ARB;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int CGL_UNSIGNED_SHORT_8_8_MESA;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int CGL_UNSIGNED_SHORT_8_8_REV_MESA;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int CGL_YCBCR_MESA;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int CLUTTER_COGL_HAS_GL;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_0_5;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_1;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_2_PI;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_BITS;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_EPSILON;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_MAX;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_MIN;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_PI;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_PI_2;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_PI_4;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int FIXED_Q;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int PIXEL_FORMAT_24;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int PIXEL_FORMAT_32;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int PREMULT_BIT;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int RADIANS_TO_DEGREES;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int SQRTI_ARG_10_PERCENT;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int SQRTI_ARG_5_PERCENT;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int SQRTI_ARG_MAX;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int TEXTURE_MAX_WASTE;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int UNORDERED_MASK;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public const int UNPREMULT_MASK;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed angle_cos (Cogl.Angle angle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed angle_sin (Cogl.Angle angle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed angle_tan (Cogl.Angle angle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool bitmap_get_size_from_file (string filename, out int width, out int height);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle bitmap_new_from_file (string filename) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool check_extension (string name, string ext);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clear (Cogl.Color color, ulong buffers);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_ensure ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_pop ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_push (float x_offset, float y_offset, float width, float height);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_push_from_path ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_push_from_path_preserve ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_push_window_rect (float x_offset, float y_offset, float width, float height);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_stack_restore ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void clip_stack_save ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle create_program ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle create_shader (Cogl.ShaderType shader_type);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void disable_fog ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed double_to_fixed (double value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static int double_to_int (double value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint double_to_unit (double value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool features_available (Cogl.FeatureFlags features);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_atan2 (Cogl.Fixed a, Cogl.Fixed b);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_atani (Cogl.Fixed a);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_cos (Cogl.Fixed angle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_div (Cogl.Fixed a, Cogl.Fixed b);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_log2 (uint x);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_mul (Cogl.Fixed a, Cogl.Fixed b);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_mul_div (Cogl.Fixed a, Cogl.Fixed b, Cogl.Fixed c);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint fixed_pow (uint x, Cogl.Fixed y);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint fixed_pow2 (Cogl.Fixed x);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_sin (Cogl.Fixed angle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_sqrt (Cogl.Fixed x);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Fixed fixed_tan (Cogl.Fixed angle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool get_backface_culling_enabled ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void get_bitmasks (out int red, out int green, out int blue, out int alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool get_depth_test_enable ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.FeatureFlags get_features ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void get_modelview_matrix (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static GLib.OptionGroup get_option_group ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.FuncPtr get_proc_address (string name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void get_projection_matrix (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void get_viewport (float v);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool is_material (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool is_offscreen (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool is_program (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool is_shader (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool is_texture (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_get_ambient (Cogl.Handle material, Cogl.Color ambient);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_get_color (Cogl.Handle material, Cogl.Color color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_get_diffuse (Cogl.Handle material, Cogl.Color diffuse);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_get_emission (Cogl.Handle material, Cogl.Color emission);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static unowned GLib.List material_get_layers (Cogl.Handle material_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static float material_get_shininess (Cogl.Handle material);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_get_specular (Cogl.Handle material, Cogl.Color specular);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.MaterialFilter material_layer_get_mag_filter (Cogl.Handle layer_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.MaterialFilter material_layer_get_min_filter (Cogl.Handle layer_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle material_layer_get_texture (Cogl.Handle layer_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.MaterialLayerType material_layer_get_type (Cogl.Handle layer_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle material_new ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle material_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_remove_layer (Cogl.Handle material, int layer_index);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_alpha_test_function (Cogl.Handle material, Cogl.MaterialAlphaFunc alpha_func, float alpha_reference);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_ambient (Cogl.Handle material, Cogl.Color ambient);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_ambient_and_diffuse (Cogl.Handle material, Cogl.Color color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool material_set_blend (Cogl.Handle material, string blend_string) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_blend_constant (Cogl.Handle material, Cogl.Color constant_color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_color (Cogl.Handle material, Cogl.Color color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_color4f (Cogl.Handle material, float red, float green, float blue, float alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_color4ub (Cogl.Handle material, uint8 red, uint8 green, uint8 blue, uint8 alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_diffuse (Cogl.Handle material, Cogl.Color diffuse);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_emission (Cogl.Handle material, Cogl.Color emission);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_layer (Cogl.Handle material, int layer_index, Cogl.Handle texture);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool material_set_layer_combine (Cogl.Handle material, int layer_index, string blend_string) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_layer_combine_constant (Cogl.Handle material, int layer_index, Cogl.Color constant);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_layer_filters (Cogl.Handle handle, int layer_index, Cogl.MaterialFilter min_filter, Cogl.MaterialFilter mag_filter);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_layer_matrix (Cogl.Handle material, int layer_index, Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_shininess (Cogl.Handle material, float shininess);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_set_specular (Cogl.Handle material, Cogl.Color specular);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void material_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_frustum (Cogl.Matrix matrix, float left, float right, float bottom, float top, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static float matrix_get_array (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_init_from_array (Cogl.Matrix matrix, out float array);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_init_identity (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_multiply (Cogl.Matrix result, Cogl.Matrix a, Cogl.Matrix b);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_ortho (Cogl.Matrix matrix, float left, float right, float bottom, float top, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_perspective (Cogl.Matrix matrix, float fov_y, float aspect, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_rotate (Cogl.Matrix matrix, float angle, float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_scale (Cogl.Matrix matrix, float sx, float sy, float sz);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_transform_point (Cogl.Matrix matrix, out float x, out float y, out float z, out float w);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void matrix_translate (Cogl.Matrix matrix, float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle offscreen_new_to_texture (Cogl.Handle texhandle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle offscreen_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void offscreen_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void ortho (float left, float right, float bottom, float top, float near, float far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_arc (float center_x, float center_y, float radius_x, float radius_y, float angle_1, float angle_2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_close ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_curve_to (float x_1, float y_1, float x_2, float y_2, float x_3, float y_3);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_ellipse (float center_x, float center_y, float radius_x, float radius_y);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_fill ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_fill_preserve ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_line (float x_1, float y_1, float x_2, float y_2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_line_to (float x, float y);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_move_to (float x, float y);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_new ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_polygon (out float coords, int num_points);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_polyline (out float coords, int num_points);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_rectangle (float x_1, float y_1, float x_2, float y_2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_rel_curve_to (float x_1, float y_1, float x_2, float y_2, float x_3, float y_3);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_rel_line_to (float x, float y);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_rel_move_to (float x, float y);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_round_rectangle (float x_1, float y_1, float x_2, float y_2, float radius, float arc_step);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_stroke ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void path_stroke_preserve ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void perspective (float fovy, float aspect, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void polygon (Cogl.TextureVertex vertices, uint n_vertices, bool use_color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void pop_draw_buffer ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void pop_matrix ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_attach_shader (Cogl.Handle program_handle, Cogl.Handle shader_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static int program_get_uniform_location (Cogl.Handle handle, string uniform_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_link (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle program_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_uniform_1f (int uniform_no, float value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_uniform_1i (int uniform_no, int value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_uniform_int (int uniform_no, int size, int count, out int value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_uniform_matrix (int uniform_no, int size, int count, bool transpose, out float value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void program_use (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void push_draw_buffer ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void push_matrix ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rectangle (float x_1, float y_1, float x_2, float y_2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rectangle_with_multitexture_coords (float x1, float y1, float x2, float y2, out float tex_coords, int tex_coords_len);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rectangle_with_texture_coords (float x1, float y1, float x2, float y2, float tx1, float ty1, float tx2, float ty2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rectangles (out float verts, uint n_rects);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rectangles_with_texture_coords (out float verts, uint n_rects);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rotate (float angle, float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void scale (float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_backface_culling_enabled (bool setting);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_depth_test_enable (bool setting);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_draw_buffer (Cogl.BufferTarget target, Cogl.Handle offscreen);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_fog (Cogl.Color fog_color, Cogl.FogMode mode, float density, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_modelview_matrix (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_projection_matrix (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_source (Cogl.Handle material);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_source_color (Cogl.Color color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_source_color4f (float red, float green, float blue, float alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_source_color4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_source_texture (Cogl.Handle texture_handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void shader_compile (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static string shader_get_info_log (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.ShaderType shader_get_type (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool shader_is_compiled (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle shader_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void shader_source (Cogl.Handle shader, string source);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void shader_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static int sqrti (int x);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static int texture_get_data (Cogl.Handle handle, Cogl.PixelFormat format, uint rowstride, [CCode (array_length = false)] uint8[] data);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.PixelFormat texture_get_format (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint texture_get_height (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static int texture_get_max_waste (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint texture_get_rowstride (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint texture_get_width (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool texture_is_sliced (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle texture_new_from_bitmap (Cogl.Handle bmp_handle, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle texture_new_from_data (uint width, uint height, Cogl.TextureFlags flags, Cogl.PixelFormat format, Cogl.PixelFormat internal_format, uint rowstride, [CCode (array_length = false)] uint8[] data);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle texture_new_from_file (string filename, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle texture_new_with_size (uint width, uint height, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle texture_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool texture_set_region (Cogl.Handle handle, int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, int width, int height, Cogl.PixelFormat format, uint rowstride, [CCode (array_length = false)] uint8[] data);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void texture_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void translate (float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_add (Cogl.Handle handle, string attribute_name, uint8 n_components, Cogl.AttributeType type, bool normalized, uint16 stride, void* pointer);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_delete (Cogl.Handle handle, string attribute_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_delete_indices (Cogl.Handle handle, int indices_id);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_disable (Cogl.Handle handle, string attribute_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_draw (Cogl.Handle handle, Cogl.VerticesMode mode, int first, int count);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_draw_elements (Cogl.Handle handle, Cogl.VerticesMode mode, Cogl.Handle indices, int min_index, int max_index, int indices_offset, int count);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_enable (Cogl.Handle handle, string attribute_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint vertex_buffer_get_n_vertices (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle vertex_buffer_indices_get_for_quads (uint n_indices);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle vertex_buffer_indices_new (Cogl.IndicesType indices_type, void* indices_array, int indices_len);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle vertex_buffer_new (uint n_vertices);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Handle vertex_buffer_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_submit (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void vertex_buffer_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void viewport (uint width, uint height);
}
