/* valaccodegenerator.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>


#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
typedef struct _ValaCCodeGeneratorPrivate ValaCCodeGeneratorPrivate;

#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
#define _vala_ccode_module_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_module_unref (var), NULL)))

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;

#define VALA_TYPE_DBUS_MODULE (vala_dbus_module_get_type ())
#define VALA_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModule))
#define VALA_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))
#define VALA_IS_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_MODULE))
#define VALA_IS_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_MODULE))
#define VALA_DBUS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))

typedef struct _ValaDBusModule ValaDBusModule;
typedef struct _ValaDBusModuleClass ValaDBusModuleClass;

#define VALA_TYPE_DBUS_CLIENT_MODULE (vala_dbus_client_module_get_type ())
#define VALA_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModule))
#define VALA_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))
#define VALA_IS_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_IS_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_DBUS_CLIENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))

typedef struct _ValaDBusClientModule ValaDBusClientModule;
typedef struct _ValaDBusClientModuleClass ValaDBusClientModuleClass;

#define VALA_TYPE_DBUS_SERVER_MODULE (vala_dbus_server_module_get_type ())
#define VALA_DBUS_SERVER_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_SERVER_MODULE, ValaDBusServerModule))
#define VALA_DBUS_SERVER_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_SERVER_MODULE, ValaDBusServerModuleClass))
#define VALA_IS_DBUS_SERVER_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_SERVER_MODULE))
#define VALA_IS_DBUS_SERVER_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_SERVER_MODULE))
#define VALA_DBUS_SERVER_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_SERVER_MODULE, ValaDBusServerModuleClass))

typedef struct _ValaDBusServerModule ValaDBusServerModule;
typedef struct _ValaDBusServerModuleClass ValaDBusServerModuleClass;

struct _ValaCCodeGenerator {
	ValaCodeGenerator parent_instance;
	ValaCCodeGeneratorPrivate * priv;
	ValaCCodeModule* head;
};

struct _ValaCCodeGeneratorClass {
	ValaCodeGeneratorClass parent_class;
};


static gpointer vala_ccode_generator_parent_class = NULL;

GType vala_ccode_generator_get_type (void);
gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
enum  {
	VALA_CCODE_GENERATOR_DUMMY_PROPERTY
};
ValaCCodeGenerator* vala_ccode_generator_new (void);
ValaCCodeGenerator* vala_ccode_generator_construct (GType object_type);
ValaDBusServerModule* vala_dbus_server_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusServerModule* vala_dbus_server_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
GType vala_ccode_base_module_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
GType vala_gobject_module_get_type (void);
GType vala_gsignal_module_get_type (void);
GType vala_gasync_module_get_type (void);
GType vala_dbus_module_get_type (void);
GType vala_dbus_client_module_get_type (void);
GType vala_dbus_server_module_get_type (void);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_module_emit (ValaCCodeModule* self, ValaCodeContext* context);
static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context);
void vala_ccode_module_visit_source_file (ValaCCodeModule* self, ValaSourceFile* source_file);
static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
void vala_ccode_module_visit_class (ValaCCodeModule* self, ValaClass* cl);
static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
void vala_ccode_module_visit_interface (ValaCCodeModule* self, ValaInterface* iface);
static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
void vala_ccode_module_visit_struct (ValaCCodeModule* self, ValaStruct* st);
static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
void vala_ccode_module_visit_enum (ValaCCodeModule* self, ValaEnum* en);
static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
void vala_ccode_module_visit_error_domain (ValaCCodeModule* self, ValaErrorDomain* edomain);
static void vala_ccode_generator_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
void vala_ccode_module_visit_delegate (ValaCCodeModule* self, ValaDelegate* d);
static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
void vala_ccode_module_visit_member (ValaCCodeModule* self, ValaMember* m);
static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
void vala_ccode_module_visit_constant (ValaCCodeModule* self, ValaConstant* c);
static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
void vala_ccode_module_visit_field (ValaCCodeModule* self, ValaField* f);
static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
void vala_ccode_module_visit_creation_method (ValaCCodeModule* self, ValaCreationMethod* m);
static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
void vala_ccode_module_visit_formal_parameter (ValaCCodeModule* self, ValaFormalParameter* p);
static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
void vala_ccode_module_visit_property (ValaCCodeModule* self, ValaProperty* prop);
static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
void vala_ccode_module_visit_property_accessor (ValaCCodeModule* self, ValaPropertyAccessor* acc);
static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
void vala_ccode_module_visit_signal (ValaCCodeModule* self, ValaSignal* sig);
static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
void vala_ccode_module_visit_constructor (ValaCCodeModule* self, ValaConstructor* c);
static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
void vala_ccode_module_visit_destructor (ValaCCodeModule* self, ValaDestructor* d);
static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
void vala_ccode_module_visit_block (ValaCCodeModule* self, ValaBlock* b);
static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
void vala_ccode_module_visit_empty_statement (ValaCCodeModule* self, ValaEmptyStatement* stmt);
static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
void vala_ccode_module_visit_declaration_statement (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
void vala_ccode_module_visit_local_variable (ValaCCodeModule* self, ValaLocalVariable* local);
static void vala_ccode_generator_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
void vala_ccode_module_visit_initializer_list (ValaCCodeModule* self, ValaInitializerList* list);
static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
void vala_ccode_module_visit_end_full_expression (ValaCCodeModule* self, ValaExpression* expr);
static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
void vala_ccode_module_visit_expression_statement (ValaCCodeModule* self, ValaExpressionStatement* stmt);
static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
void vala_ccode_module_visit_if_statement (ValaCCodeModule* self, ValaIfStatement* stmt);
static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
void vala_ccode_module_visit_switch_statement (ValaCCodeModule* self, ValaSwitchStatement* stmt);
static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
void vala_ccode_module_visit_switch_section (ValaCCodeModule* self, ValaSwitchSection* section);
static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
void vala_ccode_module_visit_switch_label (ValaCCodeModule* self, ValaSwitchLabel* label);
static void vala_ccode_generator_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label);
void vala_ccode_module_visit_loop (ValaCCodeModule* self, ValaLoop* stmt);
static void vala_ccode_generator_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt);
void vala_ccode_module_visit_foreach_statement (ValaCCodeModule* self, ValaForeachStatement* stmt);
static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
void vala_ccode_module_visit_break_statement (ValaCCodeModule* self, ValaBreakStatement* stmt);
static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
void vala_ccode_module_visit_continue_statement (ValaCCodeModule* self, ValaContinueStatement* stmt);
static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
void vala_ccode_module_visit_return_statement (ValaCCodeModule* self, ValaReturnStatement* stmt);
static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
void vala_ccode_module_visit_yield_statement (ValaCCodeModule* self, ValaYieldStatement* stmt);
static void vala_ccode_generator_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
void vala_ccode_module_visit_throw_statement (ValaCCodeModule* self, ValaThrowStatement* stmt);
static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
void vala_ccode_module_visit_try_statement (ValaCCodeModule* self, ValaTryStatement* stmt);
static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
void vala_ccode_module_visit_catch_clause (ValaCCodeModule* self, ValaCatchClause* clause);
static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
void vala_ccode_module_visit_lock_statement (ValaCCodeModule* self, ValaLockStatement* stmt);
static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
void vala_ccode_module_visit_delete_statement (ValaCCodeModule* self, ValaDeleteStatement* stmt);
static void vala_ccode_generator_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt);
void vala_ccode_module_visit_expression (ValaCCodeModule* self, ValaExpression* expr);
static void vala_ccode_generator_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr);
void vala_ccode_module_visit_array_creation_expression (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
void vala_ccode_module_visit_boolean_literal (ValaCCodeModule* self, ValaBooleanLiteral* expr);
static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
void vala_ccode_module_visit_character_literal (ValaCCodeModule* self, ValaCharacterLiteral* expr);
static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
void vala_ccode_module_visit_integer_literal (ValaCCodeModule* self, ValaIntegerLiteral* expr);
static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
void vala_ccode_module_visit_real_literal (ValaCCodeModule* self, ValaRealLiteral* expr);
static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
void vala_ccode_module_visit_string_literal (ValaCCodeModule* self, ValaStringLiteral* expr);
static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
void vala_ccode_module_visit_null_literal (ValaCCodeModule* self, ValaNullLiteral* expr);
static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
void vala_ccode_module_visit_member_access (ValaCCodeModule* self, ValaMemberAccess* expr);
static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
void vala_ccode_module_visit_method_call (ValaCCodeModule* self, ValaMethodCall* expr);
static void vala_ccode_generator_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr);
void vala_ccode_module_visit_element_access (ValaCCodeModule* self, ValaElementAccess* expr);
static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
void vala_ccode_module_visit_base_access (ValaCCodeModule* self, ValaBaseAccess* expr);
static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
void vala_ccode_module_visit_postfix_expression (ValaCCodeModule* self, ValaPostfixExpression* expr);
static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
void vala_ccode_module_visit_object_creation_expression (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
void vala_ccode_module_visit_sizeof_expression (ValaCCodeModule* self, ValaSizeofExpression* expr);
static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
void vala_ccode_module_visit_typeof_expression (ValaCCodeModule* self, ValaTypeofExpression* expr);
static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
void vala_ccode_module_visit_unary_expression (ValaCCodeModule* self, ValaUnaryExpression* expr);
static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
void vala_ccode_module_visit_cast_expression (ValaCCodeModule* self, ValaCastExpression* expr);
static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
void vala_ccode_module_visit_pointer_indirection (ValaCCodeModule* self, ValaPointerIndirection* expr);
static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
void vala_ccode_module_visit_addressof_expression (ValaCCodeModule* self, ValaAddressofExpression* expr);
static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
void vala_ccode_module_visit_reference_transfer_expression (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
void vala_ccode_module_visit_binary_expression (ValaCCodeModule* self, ValaBinaryExpression* expr);
static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
void vala_ccode_module_visit_type_check (ValaCCodeModule* self, ValaTypeCheck* expr);
static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
void vala_ccode_module_visit_lambda_expression (ValaCCodeModule* self, ValaLambdaExpression* l);
static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
void vala_ccode_module_visit_assignment (ValaCCodeModule* self, ValaAssignment* a);
static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static void vala_ccode_generator_finalize (ValaCodeVisitor* obj);



ValaCCodeGenerator* vala_ccode_generator_construct (GType object_type) {
	ValaCCodeGenerator* self;
	self = (ValaCCodeGenerator*) vala_code_generator_construct (object_type);
	return self;
}


ValaCCodeGenerator* vala_ccode_generator_new (void) {
	return vala_ccode_generator_construct (VALA_TYPE_CCODE_GENERATOR);
}


static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context) {
	ValaCCodeGenerator * self;
	ValaCCodeModule* _tmp2_;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (context != NULL);
	if (vala_code_context_get_profile (context) == VALA_PROFILE_GOBJECT) {
		ValaCCodeModule* _tmp0_;
		self->head = (_tmp0_ = (ValaCCodeModule*) vala_dbus_server_module_new (self, self->head), _vala_ccode_module_unref0 (self->head), _tmp0_);
	} else {
		ValaCCodeModule* _tmp1_;
		self->head = (_tmp1_ = (ValaCCodeModule*) vala_ccode_delegate_module_new (self, self->head), _vala_ccode_module_unref0 (self->head), _tmp1_);
	}
	vala_ccode_module_emit (self->head, context);
	self->head = (_tmp2_ = NULL, _vala_ccode_module_unref0 (self->head), _tmp2_);
}


static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (source_file != NULL);
	vala_ccode_module_visit_source_file (self->head, source_file);
}


static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (cl != NULL);
	vala_ccode_module_visit_class (self->head, cl);
}


static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (iface != NULL);
	vala_ccode_module_visit_interface (self->head, iface);
}


static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (st != NULL);
	vala_ccode_module_visit_struct (self->head, st);
}


static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (en != NULL);
	vala_ccode_module_visit_enum (self->head, en);
}


static void vala_ccode_generator_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (edomain != NULL);
	vala_ccode_module_visit_error_domain (self->head, edomain);
}


static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (d != NULL);
	vala_ccode_module_visit_delegate (self->head, d);
}


static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (m != NULL);
	vala_ccode_module_visit_member (self->head, m);
}


static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (c != NULL);
	vala_ccode_module_visit_constant (self->head, c);
}


static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (f != NULL);
	vala_ccode_module_visit_field (self->head, f);
}


static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (m != NULL);
	vala_ccode_module_visit_method (self->head, m);
}


static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (m != NULL);
	vala_ccode_module_visit_creation_method (self->head, m);
}


static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (p != NULL);
	vala_ccode_module_visit_formal_parameter (self->head, p);
}


static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (prop != NULL);
	vala_ccode_module_visit_property (self->head, prop);
}


static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (acc != NULL);
	vala_ccode_module_visit_property_accessor (self->head, acc);
}


static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (sig != NULL);
	vala_ccode_module_visit_signal (self->head, sig);
}


static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (c != NULL);
	vala_ccode_module_visit_constructor (self->head, c);
}


static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (d != NULL);
	vala_ccode_module_visit_destructor (self->head, d);
}


static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (b != NULL);
	vala_ccode_module_visit_block (self->head, b);
}


static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_empty_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_declaration_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (local != NULL);
	vala_ccode_module_visit_local_variable (self->head, local);
}


static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (list != NULL);
	vala_ccode_module_visit_initializer_list (self->head, list);
}


static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_end_full_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_expression_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_if_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_switch_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (section != NULL);
	vala_ccode_module_visit_switch_section (self->head, section);
}


static void vala_ccode_generator_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (label != NULL);
	vala_ccode_module_visit_switch_label (self->head, label);
}


static void vala_ccode_generator_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_loop (self->head, stmt);
}


static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_foreach_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_break_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_continue_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_return_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_yield_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_throw_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_try_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (clause != NULL);
	vala_ccode_module_visit_catch_clause (self->head, clause);
}


static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_lock_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_delete_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_array_creation_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_boolean_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_character_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_integer_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_real_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_string_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_null_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_member_access (self->head, expr);
}


static void vala_ccode_generator_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_method_call (self->head, expr);
}


static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_element_access (self->head, expr);
}


static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_base_access (self->head, expr);
}


static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_postfix_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_object_creation_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_sizeof_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_typeof_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_unary_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_cast_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_pointer_indirection (self->head, expr);
}


static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_addressof_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_reference_transfer_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_binary_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_type_check (self->head, expr);
}


static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (l != NULL);
	vala_ccode_module_visit_lambda_expression (self->head, l);
}


static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	ValaCCodeGenerator * self;
	self = (ValaCCodeGenerator*) base;
	g_return_if_fail (a != NULL);
	vala_ccode_module_visit_assignment (self->head, a);
}


static void vala_ccode_generator_class_init (ValaCCodeGeneratorClass * klass) {
	vala_ccode_generator_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_ccode_generator_finalize;
	VALA_CODE_GENERATOR_CLASS (klass)->emit = vala_ccode_generator_real_emit;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_ccode_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_ccode_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_ccode_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_ccode_generator_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_ccode_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_ccode_generator_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_ccode_generator_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_ccode_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_ccode_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_ccode_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_ccode_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_ccode_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_ccode_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_ccode_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_ccode_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_ccode_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_ccode_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_ccode_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = vala_ccode_generator_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_ccode_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_ccode_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = vala_ccode_generator_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_ccode_generator_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_ccode_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_ccode_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_ccode_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_ccode_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = vala_ccode_generator_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_label = vala_ccode_generator_real_visit_switch_label;
	VALA_CODE_VISITOR_CLASS (klass)->visit_loop = vala_ccode_generator_real_visit_loop;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = vala_ccode_generator_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_ccode_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_ccode_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = vala_ccode_generator_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_yield_statement = vala_ccode_generator_real_visit_yield_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_ccode_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_ccode_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_ccode_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_ccode_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delete_statement = vala_ccode_generator_real_visit_delete_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression = vala_ccode_generator_real_visit_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_ccode_generator_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_ccode_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_ccode_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_ccode_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_ccode_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_ccode_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_ccode_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_ccode_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method_call = vala_ccode_generator_real_visit_method_call;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_ccode_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_ccode_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_ccode_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = vala_ccode_generator_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_ccode_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_ccode_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_ccode_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_ccode_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_ccode_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_ccode_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_ccode_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_ccode_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = vala_ccode_generator_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_ccode_generator_real_visit_assignment;
}


static void vala_ccode_generator_instance_init (ValaCCodeGenerator * self) {
}


static void vala_ccode_generator_finalize (ValaCodeVisitor* obj) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (obj);
	_vala_ccode_module_unref0 (self->head);
	VALA_CODE_VISITOR_CLASS (vala_ccode_generator_parent_class)->finalize (obj);
}


GType vala_ccode_generator_get_type (void) {
	static GType vala_ccode_generator_type_id = 0;
	if (vala_ccode_generator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeGenerator), 0, (GInstanceInitFunc) vala_ccode_generator_instance_init, NULL };
		vala_ccode_generator_type_id = g_type_register_static (VALA_TYPE_CODE_GENERATOR, "ValaCCodeGenerator", &g_define_type_info, 0);
	}
	return vala_ccode_generator_type_id;
}




