/* valadbusinterfaceregisterfunction.vala
 *
 * Copyright (C) 2009 Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Didier Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>


#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;
typedef struct _ValaTypeRegisterFunctionPrivate ValaTypeRegisterFunctionPrivate;

#define VALA_TYPE_INTERFACE_REGISTER_FUNCTION (vala_interface_register_function_get_type ())
#define VALA_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunction))
#define VALA_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))

typedef struct _ValaInterfaceRegisterFunction ValaInterfaceRegisterFunction;
typedef struct _ValaInterfaceRegisterFunctionClass ValaInterfaceRegisterFunctionClass;
typedef struct _ValaInterfaceRegisterFunctionPrivate ValaInterfaceRegisterFunctionPrivate;

#define VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION (vala_dbus_interface_register_function_get_type ())
#define VALA_DBUS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, ValaDBusInterfaceRegisterFunction))
#define VALA_DBUS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, ValaDBusInterfaceRegisterFunctionClass))
#define VALA_IS_DBUS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_DBUS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION))
#define VALA_DBUS_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, ValaDBusInterfaceRegisterFunctionClass))

typedef struct _ValaDBusInterfaceRegisterFunction ValaDBusInterfaceRegisterFunction;
typedef struct _ValaDBusInterfaceRegisterFunctionClass ValaDBusInterfaceRegisterFunctionClass;
typedef struct _ValaDBusInterfaceRegisterFunctionPrivate ValaDBusInterfaceRegisterFunctionPrivate;

/**
 * C function to register a type at runtime.
 */
struct _ValaTypeRegisterFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTypeRegisterFunctionPrivate * priv;
};

struct _ValaTypeRegisterFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTypeRegisterFunction *self);
	ValaTypeSymbol* (*get_type_declaration) (ValaTypeRegisterFunction* self);
	char* (*get_type_struct_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_instance_struct_size) (ValaTypeRegisterFunction* self);
	char* (*get_instance_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_parent_type_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_init_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_peek_pointer_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_free_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_copy_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_lcopy_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_collect_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_type_flags) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_declaration) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_statements) (ValaTypeRegisterFunction* self);
	ValaSymbolAccessibility (*get_accessibility) (ValaTypeRegisterFunction* self);
};

/**
 * C function to register an interface at runtime.
 */
struct _ValaInterfaceRegisterFunction {
	ValaTypeRegisterFunction parent_instance;
	ValaInterfaceRegisterFunctionPrivate * priv;
};

struct _ValaInterfaceRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent_class;
};

/**
 * C function to register an interface at runtime.
 */
struct _ValaDBusInterfaceRegisterFunction {
	ValaInterfaceRegisterFunction parent_instance;
	ValaDBusInterfaceRegisterFunctionPrivate * priv;
};

struct _ValaDBusInterfaceRegisterFunctionClass {
	ValaInterfaceRegisterFunctionClass parent_class;
};


static gpointer vala_dbus_interface_register_function_parent_class = NULL;

gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_interface_register_function_get_type (void);
GType vala_dbus_interface_register_function_get_type (void);
enum  {
	VALA_DBUS_INTERFACE_REGISTER_FUNCTION_DUMMY_PROPERTY
};
ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaInterfaceRegisterFunction* vala_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
ValaDBusInterfaceRegisterFunction* vala_dbus_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaDBusInterfaceRegisterFunction* vala_dbus_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
ValaInterface* vala_interface_register_function_get_interface_reference (ValaInterfaceRegisterFunction* self);
static ValaCCodeFragment* vala_dbus_interface_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);



ValaDBusInterfaceRegisterFunction* vala_dbus_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context) {
	ValaDBusInterfaceRegisterFunction* self;
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = (ValaDBusInterfaceRegisterFunction*) vala_interface_register_function_construct (object_type, iface, context);
	return self;
}


ValaDBusInterfaceRegisterFunction* vala_dbus_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context) {
	return vala_dbus_interface_register_function_construct (VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, iface, context);
}


static ValaCCodeFragment* vala_dbus_interface_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base) {
	ValaDBusInterfaceRegisterFunction * self;
	ValaCCodeFragment* result;
	ValaCCodeFragment* frag;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* quark_dbus_proxy;
	ValaCCodeConstant* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* func;
	ValaCCodeIdentifier* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeIdentifier* _tmp10_;
	char* _tmp9_;
	char* _tmp8_;
	ValaCCodeExpressionStatement* _tmp12_;
	self = (ValaDBusInterfaceRegisterFunction*) base;
	frag = VALA_TYPEREGISTER_FUNCTION_CLASS (vala_dbus_interface_register_function_parent_class)->get_type_interface_init_statements ((ValaTypeRegisterFunction*) VALA_INTERFACE_REGISTER_FUNCTION (self));
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	quark_dbus_proxy = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (quark_dbus_proxy, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_constant_new ("\"ValaDBusInterfaceProxyType\"")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	func = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("g_type_set_qdata"))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp4_);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (func, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = g_strdup_printf ("%s_type_id", _tmp5_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) vala_interface_register_function_get_interface_reference ((ValaInterfaceRegisterFunction*) self), NULL)))));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp5_ = (g_free (_tmp5_), NULL);
	vala_ccode_function_call_add_argument (func, (ValaCCodeExpression*) quark_dbus_proxy);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (func, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new (_tmp9_ = g_strdup_printf ("%s_dbus_proxy_get_type", _tmp8_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) vala_interface_register_function_get_interface_reference ((ValaInterfaceRegisterFunction*) self), NULL)))))));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp12_ = NULL;
	vala_ccode_fragment_append (frag, (ValaCCodeNode*) (_tmp12_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) func)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	result = frag;
	(quark_dbus_proxy == NULL) ? NULL : (quark_dbus_proxy = (vala_ccode_node_unref (quark_dbus_proxy), NULL));
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	return result;
}


static void vala_dbus_interface_register_function_class_init (ValaDBusInterfaceRegisterFunctionClass * klass) {
	vala_dbus_interface_register_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_dbus_interface_register_function_real_get_type_interface_init_statements;
}


static void vala_dbus_interface_register_function_instance_init (ValaDBusInterfaceRegisterFunction * self) {
}


GType vala_dbus_interface_register_function_get_type (void) {
	static GType vala_dbus_interface_register_function_type_id = 0;
	if (vala_dbus_interface_register_function_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusInterfaceRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_interface_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusInterfaceRegisterFunction), 0, (GInstanceInitFunc) vala_dbus_interface_register_function_instance_init, NULL };
		vala_dbus_interface_register_function_type_id = g_type_register_static (VALA_TYPE_INTERFACE_REGISTER_FUNCTION, "ValaDBusInterfaceRegisterFunction", &g_define_type_info, 0);
	}
	return vala_dbus_interface_register_function_type_id;
}




