/* hildon-1.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Hildon", lower_case_cprefix = "hildon_")]
namespace Hildon {
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class AnimationActor : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public AnimationActor ();
		public void send_message (uint32 message_type, uint32 l0, uint32 l1, uint32 l2, uint32 l3, uint32 l4);
		public void set_anchor (int x, int y);
		public void set_anchor_from_gravity (uint gravity);
		public void set_depth (int depth);
		public void set_opacity (int opacity);
		public void set_parent (Gtk.Window parent);
		public void set_position (int x, int y);
		public void set_position_full (int x, int y, int depth);
		public void set_rotation (int axis, double degrees, int x, int y, int z);
		public void set_rotationx (int axis, int32 degrees, int x, int y, int z);
		public void set_scale (double x_scale, double y_scale);
		public void set_scalex (int32 x_scale, int32 y_scale);
		public void set_show (int show);
		public void set_show_full (int show, int opacity);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class AppMenu : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public AppMenu ();
		public void add_filter (Gtk.Button filter);
		public void append (Gtk.Button item);
		public unowned GLib.List get_filters ();
		public unowned GLib.List get_items ();
		public void insert (Gtk.Button item, int position);
		public void popup (Gtk.Window parent_window);
		public void prepend (Gtk.Button item);
		public void reorder_child (Gtk.Button item, int position);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Banner : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		public void set_fraction (double fraction);
		public void set_icon (string icon_name);
		public void set_icon_from_file (string icon_file);
		public void set_markup (string markup);
		public void set_text (string text);
		public void set_timeout (uint timeout);
		public static unowned Gtk.Widget show_animation (Gtk.Widget widget, string animation_name, string text);
		public static unowned Gtk.Widget show_information (Gtk.Widget widget, string? icon_name, string text);
		public static unowned Gtk.Widget show_information_override_dnd (Gtk.Widget widget, string text);
		public static unowned Gtk.Widget show_information_with_markup (Gtk.Widget widget, string? icon_name, string markup);
		public static unowned Gtk.Widget show_informationf (Gtk.Widget widget, string icon_name, string format);
		public static unowned Gtk.Widget show_progress (Gtk.Widget widget, Gtk.ProgressBar bar, string text);
		[NoAccessorMethod]
		public bool is_timed { get; construct; }
		[NoAccessorMethod]
		public Gtk.Window parent_window { owned get; construct; }
		[NoAccessorMethod]
		public uint timeout { get; construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class BreadCrumbTrail : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public BreadCrumbTrail ();
		public void clear ();
		public void pop ();
		public void push (Hildon.BreadCrumb item, void* id, GLib.DestroyNotify destroy);
		public void push_icon (string text, Gtk.Widget icon, void* id, GLib.DestroyNotify destroy);
		public void push_text (string text, void* id, GLib.DestroyNotify destroy);
		public virtual signal bool crumb_clicked (void* id);
		public virtual signal void move_parent ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Button : Gtk.Button, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Button (Hildon.SizeType size, Hildon.ButtonArrangement arrangement);
		public void add_image_size_group (Gtk.SizeGroup size_group);
		public void add_size_groups (Gtk.SizeGroup title_size_group, Gtk.SizeGroup value_size_group, Gtk.SizeGroup image_size_group);
		public void add_title_size_group (Gtk.SizeGroup size_group);
		public void add_value_size_group (Gtk.SizeGroup size_group);
		public unowned Gtk.Widget get_image ();
		public Hildon.ButtonStyle get_style ();
		public unowned string get_title ();
		public unowned string get_value ();
		public void set_alignment (float xalign, float yalign, float xscale, float yscale);
		public void set_image (Gtk.Widget image);
		public void set_image_alignment (float xalign, float yalign);
		public void set_image_position (Gtk.PositionType position);
		public void set_style (Hildon.ButtonStyle style);
		public void set_text (string title, string value);
		public void set_title (string title);
		public void set_title_alignment (float xalign, float yalign);
		public void set_value (string value);
		public void set_value_alignment (float xalign, float yalign);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Button.with_text (Hildon.SizeType size, Hildon.ButtonArrangement arrangement, string title, string value);
		public Hildon.ButtonArrangement arrangement { construct; }
		public Hildon.SizeType size { construct; }
		public Hildon.ButtonStyle style { get; set; }
		public string title { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Calendar : Gtk.Widget, Atk.Implementor, Gtk.Buildable {
		[CCode (array_length = false)]
		public weak int[] day_month;
		public Hildon.CalendarDisplayOptions display_flags;
		public int focus_col;
		public int focus_row;
		public weak Gdk.GC gc;
		[CCode (array_length = false)]
		public weak char[] grow_space;
		public weak Gtk.Style header_style;
		public int highlight_col;
		public int highlight_row;
		public weak Gtk.Style label_style;
		[CCode (array_length = false)]
		public weak int[] marked_date;
		[CCode (array_length = false)]
		public weak Gdk.Color[] marked_date_color;
		public int num_marked_dates;
		public int selected_day;
		public weak Gdk.GC xor_gc;
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Calendar ();
		public void clear_marks ();
		public void freeze ();
		public void get_date (uint year, uint month, uint day);
		public Hildon.CalendarDisplayOptions get_display_options ();
		public bool mark_day (uint day);
		public void select_day (uint day);
		public bool select_month (uint month, uint year);
		public void set_display_options (Hildon.CalendarDisplayOptions flags);
		public void thaw ();
		public bool unmark_day (uint day);
		[NoAccessorMethod]
		public int day { get; set; }
		[NoAccessorMethod]
		public int max_year { get; set; }
		[NoAccessorMethod]
		public int min_year { get; set; }
		[NoAccessorMethod]
		public int month { get; set; }
		[NoAccessorMethod]
		public bool no_month_change { get; set; }
		[NoAccessorMethod]
		public bool show_day_names { get; set; }
		[NoAccessorMethod]
		public bool show_heading { get; set; }
		[NoAccessorMethod]
		public bool show_week_numbers { get; set; }
		[NoAccessorMethod]
		public int week_start { get; set; }
		[NoAccessorMethod]
		public int year { get; set; }
		public virtual signal void day_selected ();
		public virtual signal void day_selected_double_click ();
		public virtual signal void erroneous_date ();
		public virtual signal void month_changed ();
		public virtual signal void next_month ();
		public virtual signal void next_year ();
		public virtual signal void prev_month ();
		public virtual signal void prev_year ();
		public virtual signal void selected_date ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class CalendarPopup : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public CalendarPopup (Gtk.Window parent, uint year, uint month, uint day);
		public void get_date (uint year, uint month, uint day);
		public void set_date (uint year, uint month, uint day);
		[NoAccessorMethod]
		public int day { get; set; }
		[NoAccessorMethod]
		public uint max_year { set; }
		[NoAccessorMethod]
		public uint min_year { set; }
		[NoAccessorMethod]
		public int month { get; set; }
		[NoAccessorMethod]
		public int year { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Caption : Gtk.EventBox, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Caption (Gtk.SizeGroup group, string value, Gtk.Widget control, Gtk.Widget icon, Hildon.CaptionStatus flag);
		public bool get_child_expand ();
		public unowned Gtk.Widget get_icon_image ();
		public Hildon.CaptionIconPosition get_icon_position ();
		public unowned string get_label ();
		public float get_label_alignment ();
		public unowned string get_separator ();
		public unowned Gtk.SizeGroup get_size_group ();
		public Hildon.CaptionStatus get_status ();
		public bool is_mandatory ();
		public void set_child_expand (bool expand);
		public void set_icon_image (Gtk.Widget icon);
		public void set_icon_position (Hildon.CaptionIconPosition pos);
		public void set_label (string label);
		public void set_label_alignment (float alignment);
		public void set_label_markup (string markup);
		public void set_separator (string separator);
		public void set_size_group (Gtk.SizeGroup new_group);
		public void set_status (Hildon.CaptionStatus flag);
		[NoAccessorMethod]
		public Gtk.Widget icon { owned get; set; }
		public Hildon.CaptionIconPosition icon_position { get; set; }
		public string label { get; set; }
		[NoAccessorMethod]
		public string markup { set; }
		public string separator { get; set; }
		public Gtk.SizeGroup size_group { get; set; }
		public Hildon.CaptionStatus status { get; set; }
		public virtual signal void activate ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class CheckButton : Gtk.Button, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public CheckButton (Hildon.SizeType size);
		public bool get_active ();
		public void set_active (bool is_active);
		[NoAccessorMethod]
		public Hildon.SizeType size { set; }
		public virtual signal void toggled ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class CodeDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public CodeDialog ();
		public void clear_code ();
		public unowned string get_code ();
		public void set_help_text (string text);
		public void set_input_sensitive (bool sensitive);
		public virtual signal void input ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class ColorButton : Gtk.Button, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public ColorButton ();
		public void get_color (out Gdk.Color color);
		public bool get_popup_shown ();
		public void popdown ();
		public void set_color (Gdk.Color color);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public ColorButton.with_color (Gdk.Color color);
		public Gdk.Color color { get; set; }
		public bool popup_shown { get; }
		public virtual signal void setup_dialog (Hildon.ColorChooserDialog p0);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class ColorChooser : Gtk.Widget, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public ColorChooser ();
		public void get_color (out Gdk.Color color);
		public virtual void set_color (Gdk.Color color);
		public Gdk.Color color { get; set; }
		public virtual signal void color_changed ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class ColorChooserDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public ColorChooserDialog ();
		public void get_color (out Gdk.Color color);
		public void set_color (Gdk.Color color);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Controlbar : Gtk.Scale, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Controlbar ();
		public int get_max ();
		public int get_min ();
		public int get_value ();
		public void set_max (int max);
		public void set_min (int min);
		public void set_range (int min, int max);
		public void set_value (int value);
		public int max { get; set; }
		public int min { get; set; }
		public int value { get; set; }
		public virtual signal void end_reached (bool end);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class DateButton : Hildon.PickerButton, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public DateButton (Hildon.SizeType size, Hildon.ButtonArrangement arrangement);
		public void get_date (uint year, uint month, uint day);
		public void set_date (uint year, uint month, uint day);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public DateButton.with_year_range (Hildon.SizeType size, Hildon.ButtonArrangement arrangement, int min_year, int max_year);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class DateEditor : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public DateEditor ();
		public void get_date (uint year, uint month, uint day);
		public uint get_day ();
		public uint get_month ();
		public uint get_year ();
		public void set_date (uint year, uint month, uint day);
		public bool set_day (uint day);
		public bool set_month (uint month);
		public bool set_year (uint year);
		public uint day { get; set; }
		[NoAccessorMethod]
		public uint max_year { get; set; }
		[NoAccessorMethod]
		public uint min_year { get; set; }
		public uint month { get; set; }
		public uint year { get; set; }
		public virtual signal bool date_error (Hildon.DateTimeError type);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class DateSelector : Hildon.TouchSelector, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public DateSelector ();
		public void get_date (uint year, uint month, uint day);
		public bool select_current_date (uint year, uint month, uint day);
		public void select_day (uint day);
		public bool select_month (uint month, uint year);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public DateSelector.with_year_range (int min_year, int max_year);
		[NoAccessorMethod]
		public int max_year { get; construct; }
		[NoAccessorMethod]
		public int min_year { get; construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Dialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Dialog ();
		public unowned Gtk.Widget add_button (string button_text, int response_id);
		public void add_buttons (...);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Dialog.with_buttons (string title, Gtk.Window parent, Gtk.DialogFlags flags, ...);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class EditToolbar : Gtk.HBox, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public EditToolbar ();
		public void set_button_label (string label);
		public void set_label (string label);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public EditToolbar.with_text (string label, string button);
		public virtual signal void arrow_clicked ();
		public virtual signal void button_clicked ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Entry : Gtk.Entry, Atk.Implementor, Gtk.Buildable, Gtk.Editable, Gtk.CellEditable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Entry (Hildon.SizeType size);
		public unowned string get_text ();
		public void set_placeholder (string text);
		public void set_text (string text);
		[NoAccessorMethod]
		public Hildon.SizeType size { set construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class FindToolbar : Gtk.Toolbar, Atk.Implementor, Gtk.Buildable, Gtk.ToolShell {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public FindToolbar (string label);
		public int get_active ();
		public bool get_active_iter (out Gtk.TreeIter iter);
		public int32 get_last_index ();
		public void highlight_entry (bool get_focus);
		public void set_active (int index);
		public void set_active_iter (Gtk.TreeIter iter);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public FindToolbar.with_model (string label, Gtk.ListStore model, int column);
		[NoAccessorMethod]
		public int column { get; set; }
		[NoAccessorMethod]
		public int history_limit { get; set construct; }
		[NoAccessorMethod]
		public string label { owned get; set construct; }
		[NoAccessorMethod]
		public Gtk.ListStore list { owned get; set; }
		[NoAccessorMethod]
		public int max_characters { get; set construct; }
		[NoAccessorMethod]
		public string prefix { owned get; set; }
		public virtual signal void close ();
		public virtual signal bool history_append ();
		public virtual signal void invalid_input ();
		public virtual signal void search ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class FontSelectionDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public FontSelectionDialog (Gtk.Window parent, string title);
		public unowned string get_preview_text ();
		public void set_preview_text (string text);
		[NoAccessorMethod]
		public bool bold { get; set; }
		[NoAccessorMethod]
		public bool bold_set { get; set construct; }
		[NoAccessorMethod]
		public Gdk.Color color { get; set; }
		[NoAccessorMethod]
		public bool color_set { get; set construct; }
		[NoAccessorMethod]
		public string family { owned get; set; }
		[NoAccessorMethod]
		public bool family_set { get; set construct; }
		[NoAccessorMethod]
		public double font_scaling { get; set; }
		[NoAccessorMethod]
		public bool italic { get; set; }
		[NoAccessorMethod]
		public bool italic_set { get; set construct; }
		[NoAccessorMethod]
		public int position { get; set; }
		[NoAccessorMethod]
		public bool position_set { get; set construct; }
		public string preview_text { get; set; }
		[NoAccessorMethod]
		public int size { get; set; }
		[NoAccessorMethod]
		public bool size_set { get; set construct; }
		[NoAccessorMethod]
		public bool strikethrough { get; set; }
		[NoAccessorMethod]
		public bool strikethrough_set { get; set construct; }
		[NoAccessorMethod]
		public bool underline { get; set; }
		[NoAccessorMethod]
		public bool underline_set { get; set construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class GetPasswordDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public GetPasswordDialog (Gtk.Window parent, bool get_old);
		public unowned string get_password ();
		public void set_caption (string new_caption);
		public void set_max_characters (int max_characters);
		public void set_message (string message);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public GetPasswordDialog.with_default (Gtk.Window parent, string password, bool get_old);
		[NoAccessorMethod]
		public string caption_label { owned get; set; }
		[NoAccessorMethod]
		public bool get_old { get; construct; }
		[NoAccessorMethod]
		public int max_characters { get; set; }
		[NoAccessorMethod]
		public string message { owned get; set; }
		[NoAccessorMethod]
		public bool numbers_only { get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class HVolumebar : Hildon.Volumebar, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public HVolumebar ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class LoginDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public LoginDialog (Gtk.Window parent);
		public unowned string get_password ();
		public unowned string get_username ();
		public void set_message (string msg);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public LoginDialog.with_default (Gtk.Window parent, string name, string password);
		[NoAccessorMethod]
		public string message { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Note : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Note.cancel_with_progress_bar (Gtk.Window parent, string description, Gtk.ProgressBar progressbar);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Note.confirmation (Gtk.Window parent, string description);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Note.confirmation_add_buttons (Gtk.Window parent, string description);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Note.confirmation_with_icon_name (Gtk.Window parent, string description, string icon_name);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Note.information (Gtk.Window parent, string description);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Note.information_with_icon_name (Gtk.Window parent, string description, string icon_name);
		public void set_button_text (string text);
		public void set_button_texts (string text_ok, string text_cancel);
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string icon { owned get; set; }
		[NoAccessorMethod]
		public Hildon.NoteType note_type { get; set construct; }
		[NoAccessorMethod]
		public Gtk.ProgressBar progressbar { owned get; set; }
		[NoAccessorMethod]
		public string stock_icon { owned get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class NumberEditor : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public NumberEditor (int min, int max);
		public int get_value ();
		public void set_range (int min, int max);
		public void set_value (int value);
		public int value { get; set; }
		public virtual signal bool range_error (Hildon.NumberEditorErrorType type);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class PannableArea : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PannableArea ();
		public void add_with_viewport (Gtk.Widget child);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PannableArea.full (int mode, bool enabled, double vel_min, double vel_max, double decel, uint sps);
		public unowned Gtk.Adjustment get_hadjustment ();
		public Hildon.SizeRequestPolicy get_size_request_policy ();
		public unowned Gtk.Adjustment get_vadjustment ();
		public void jump_to (int x, int y);
		public void jump_to_child (Gtk.Widget child);
		public void scroll_to (int x, int y);
		public void scroll_to_child (Gtk.Widget child);
		public void set_size_request_policy (Hildon.SizeRequestPolicy size_request_policy);
		[NoAccessorMethod]
		public uint bounce_steps { get; set construct; }
		[NoAccessorMethod]
		public double deceleration { get; set construct; }
		[NoAccessorMethod]
		public uint direction_error_margin { get; set construct; }
		[NoAccessorMethod]
		public double drag_inertia { get; set construct; }
		[NoAccessorMethod]
		public bool enabled { get; set construct; }
		[NoAccessorMethod]
		public uint force { get; set construct; }
		public Gtk.Adjustment hadjustment { get; }
		[NoAccessorMethod]
		public int hovershoot_max { get; set construct; }
		[NoAccessorMethod]
		public Gtk.PolicyType hscrollbar_policy { get; set construct; }
		[NoAccessorMethod]
		public bool initial_hint { get; set construct; }
		[NoAccessorMethod]
		public bool low_friction_mode { get; set construct; }
		[NoAccessorMethod]
		public Hildon.PannableAreaMode mode { get; set construct; }
		[NoAccessorMethod]
		public Hildon.MovementMode mov_mode { get; set construct; }
		[NoAccessorMethod]
		public uint panning_threshold { get; set construct; }
		[NoAccessorMethod]
		public double scroll_time { get; set construct; }
		[NoAccessorMethod]
		public uint scrollbar_fade_delay { get; set construct; }
		public Hildon.SizeRequestPolicy size_request_policy { get; set construct; }
		[NoAccessorMethod]
		public uint sps { get; set construct; }
		public Gtk.Adjustment vadjustment { get; }
		[NoAccessorMethod]
		public double velocity_fast_factor { get; set construct; }
		[NoAccessorMethod]
		public double velocity_max { get; set construct; }
		[NoAccessorMethod]
		public double velocity_min { get; set construct; }
		[NoAccessorMethod]
		public double velocity_overshooting_max { get; set construct; }
		[NoAccessorMethod]
		public int vovershoot_max { get; set construct; }
		[NoAccessorMethod]
		public Gtk.PolicyType vscrollbar_policy { get; set construct; }
		public virtual signal void horizontal_movement (int direction, double x, double y);
		public virtual signal void panning_finished ();
		public virtual signal bool panning_started ();
		public virtual signal void vertical_movement (int direction, double x, double y);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class PickerButton : Hildon.Button, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PickerButton (Hildon.SizeType size, Hildon.ButtonArrangement arrangement);
		public int get_active ();
		public unowned string get_done_button_text ();
		public unowned Hildon.TouchSelector get_selector ();
		public void set_active (int index);
		public void set_done_button_text (string done_button_text);
		public void set_selector (Hildon.TouchSelector selector);
		public string done_button_text { get; set; }
		[NoAccessorMethod]
		public Hildon.TouchSelector touch_selector { owned get; set; }
		public virtual signal void value_changed ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class PickerDialog : Hildon.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PickerDialog (Gtk.Window parent);
		public unowned string get_done_label ();
		public unowned Hildon.TouchSelector get_selector ();
		public void set_done_label (string label);
		public virtual bool set_selector (Hildon.TouchSelector selector);
		[NoAccessorMethod]
		public bool center_on_show { get; set construct; }
		[NoAccessorMethod]
		public string done_button_text { owned get; set construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Program : GLib.Object {
		public void add_window (Hildon.Window window);
		public bool get_can_hibernate ();
		public unowned Hildon.AppMenu get_common_app_menu ();
		public unowned Gtk.Menu get_common_menu ();
		public unowned Gtk.Toolbar get_common_toolbar ();
		public static unowned Hildon.Program get_instance ();
		public bool get_is_topmost ();
		public void go_to_root_window ();
		public unowned Hildon.StackableWindow peek_window_stack ();
		public unowned Hildon.StackableWindow pop_window_stack ();
		public void remove_window (Hildon.Window window);
		public void set_can_hibernate (bool can_hibernate);
		public void set_common_app_menu (Hildon.AppMenu menu);
		public void set_common_menu (Gtk.Menu menu);
		public void set_common_toolbar (Gtk.Toolbar toolbar);
		public bool can_hibernate { get; set; }
		public bool is_topmost { get; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class RangeEditor : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public RangeEditor ();
		public int get_higher ();
		public int get_lower ();
		public int get_max ();
		public int get_min ();
		public void get_range (int start, int end);
		public unowned string get_separator ();
		public void set_higher (int value);
		public void set_limits (int start, int end);
		public void set_lower (int value);
		public void set_max (int value);
		public void set_min (int value);
		public void set_range (int start, int end);
		public void set_separator (string separator);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public RangeEditor.with_separator (string separator);
		public int higher { get; set construct; }
		public int lower { get; set construct; }
		public int max { get; set construct; }
		public int min { get; set construct; }
		public string separator { get; set construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class RemoteTexture : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public RemoteTexture ();
		public void send_message (uint32 message_type, uint32 l0, uint32 l1, uint32 l2, uint32 l3, uint32 l4);
		public void set_image (uint32 key, uint width, uint height, uint bpp);
		public void set_offset (double x, double y);
		public void set_opacity (int opacity);
		public void set_parent (Gtk.Window parent);
		public void set_position (int x, int y, int width, int height);
		public void set_scale (double x_scale, double y_scale);
		public void set_show (int show);
		public void set_show_full (int show, int opacity);
		public void update_area (int x, int y, int width, int height);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Seekbar : Gtk.Scale, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Seekbar ();
		public uint get_fraction ();
		public int get_position ();
		public int get_total_time ();
		public void set_fraction (uint fraction);
		public void set_position (int time);
		public void set_total_time (int time);
		public double fraction { get; set; }
		public double position { get; set; }
		public double total_time { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class SetPasswordDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public SetPasswordDialog (Gtk.Window parent, bool modify_protection);
		public unowned string get_password ();
		public bool get_protected ();
		public void set_message (string message);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public SetPasswordDialog.with_default (Gtk.Window parent, string password, bool modify_protection);
		[NoAccessorMethod]
		public string message { owned get; set; }
		[NoAccessorMethod]
		public bool modify_protection { get; construct; }
		[NoAccessorMethod]
		public string password { owned get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class SortDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public SortDialog (Gtk.Window parent);
		public int add_sort_key (string sort_key);
		public int add_sort_key_reversed (string sort_key);
		public int get_sort_key ();
		public Gtk.SortType get_sort_order ();
		public void set_sort_key (int key);
		public void set_sort_order (Gtk.SortType order);
		public int sort_key { get; set; }
		public Gtk.SortType sort_order { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class StackableWindow : Hildon.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public StackableWindow ();
		public unowned Hildon.WindowStack get_stack ();
		public void set_main_menu (Hildon.AppMenu menu);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TextView : Gtk.TextView, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TextView ();
		public unowned Gtk.TextBuffer get_buffer ();
		public void set_buffer (Gtk.TextBuffer buffer);
		public void set_placeholder (string text);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TimeButton : Hildon.PickerButton, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TimeButton (Hildon.SizeType size, Hildon.ButtonArrangement arrangement);
		public void get_time (uint hours, uint minutes);
		public void set_time (uint hours, uint minutes);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TimeButton.step (Hildon.SizeType size, Hildon.ButtonArrangement arrangement, uint minutes_step);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TimeEditor : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TimeEditor ();
		public uint get_duration_max ();
		public uint get_duration_min ();
		public bool get_duration_mode ();
		public void get_duration_range (uint min_seconds, uint max_seconds);
		public bool get_show_hours ();
		public bool get_show_seconds ();
		public uint get_ticks ();
		public void get_time (uint hours, uint minutes, uint seconds);
		public static void get_time_separators (Gtk.Label hm_sep_label, Gtk.Label ms_sep_label);
		public void set_duration_max (uint duration_max);
		public void set_duration_min (uint duration_min);
		public void set_duration_mode (bool duration_mode);
		public void set_duration_range (uint min_seconds, uint max_seconds);
		public void set_show_hours (bool show_hours);
		public void set_show_seconds (bool show_seconds);
		public void set_ticks (uint ticks);
		public void set_time (uint hours, uint minutes, uint seconds);
		public uint duration_max { get; set; }
		public uint duration_min { get; set; }
		public bool duration_mode { get; set; }
		public bool show_hours { get; set; }
		public bool show_seconds { get; set; }
		public uint ticks { get; set; }
		public virtual signal bool time_error (Hildon.DateTimeError type);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TimePicker : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TimePicker (Gtk.Window parent);
		public void get_time (uint hours, uint minutes);
		public void set_time (uint hours, uint minutes);
		[NoAccessorMethod]
		public uint minutes { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TimeSelector : Hildon.TouchSelector, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TimeSelector ();
		public void get_time (uint hours, uint minutes);
		public bool set_time (uint hours, uint minutes);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TimeSelector.step (uint minutes_step);
		[NoAccessorMethod]
		public uint minutes_step { get; construct; }
		[NoAccessorMethod]
		public Hildon.TimeSelectorFormatPolicy time_format_policy { get; set construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TouchSelector : Gtk.VBox, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TouchSelector ();
		public unowned Hildon.TouchSelectorColumn append_column (Gtk.TreeModel model, Gtk.CellRenderer cell_renderer);
		public void append_text (string text);
		public unowned Hildon.TouchSelectorColumn append_text_column (Gtk.TreeModel model, bool center);
		public void center_on_selected ();
		public int get_active (int column);
		public unowned Hildon.TouchSelectorColumn get_column (int column);
		public Hildon.TouchSelectorSelectionMode get_column_selection_mode ();
		public unowned string get_current_text ();
		public Hildon.UIMode get_hildon_ui_mode ();
		public unowned Gtk.TreePath get_last_activated_row (int column);
		public unowned Gtk.TreeModel get_model (int column);
		public int get_num_columns ();
		public unowned Hildon.TouchSelectorPrintFunc get_print_func ();
		public bool get_selected (int column, Gtk.TreeIter iter);
		public unowned GLib.List get_selected_rows (int column);
		public void insert_text (int position, string text);
		public void optimal_size_request (Gtk.Requisition requisition);
		public void prepend_text (string text);
		public bool remove_column (int column);
		public void select_iter (int column, Gtk.TreeIter iter, bool scroll_to);
		public void set_active (int column, int index);
		public void set_column_attributes (int num_column, Gtk.CellRenderer cell_renderer);
		public void set_column_selection_mode (Hildon.TouchSelectorSelectionMode mode);
		public bool set_hildon_ui_mode (Hildon.UIMode mode);
		public virtual void set_model (int column, Gtk.TreeModel model);
		public void set_print_func (Hildon.TouchSelectorPrintFunc func);
		public void set_print_func_full (Hildon.TouchSelectorPrintFunc func, GLib.DestroyNotify destroy_func);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TouchSelector.text ();
		public void unselect_all (int column);
		public void unselect_iter (int column, Gtk.TreeIter iter);
		[NoAccessorMethod]
		public bool has_multiple_selection { get; }
		public Hildon.UIMode hildon_ui_mode { get; set; }
		[NoAccessorMethod]
		public bool initial_scroll { get; set construct; }
		public virtual signal void changed (int column);
		public virtual signal void columns_changed ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TouchSelectorColumn : GLib.Object, Gtk.CellLayout {
		public int get_text_column ();
		public void set_text_column (int text_column);
		public int text_column { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class TouchSelectorEntry : Hildon.TouchSelector, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TouchSelectorEntry ();
		public unowned Hildon.Entry get_entry ();
		public Hildon.GtkInputMode get_input_mode ();
		public int get_text_column ();
		public void set_input_mode (Hildon.GtkInputMode input_mode);
		public void set_text_column (int text_column);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public TouchSelectorEntry.text ();
		public int text_column { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class VVolumebar : Hildon.Volumebar, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public VVolumebar ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Volumebar : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		public unowned Gtk.Adjustment get_adjustment ();
		public double get_level ();
		public bool get_mute ();
		public void set_level (double level);
		public void set_mute (bool mute);
		public void set_range_insensitive_message (string message);
		public void set_range_insensitive_messagef (string format);
		[NoAccessorMethod]
		public bool has_mute { get; set construct; }
		public double level { get; set; }
		public bool mute { get; set; }
		public virtual signal void level_changed ();
		public virtual signal void mute_toggled ();
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class VolumebarRange : Gtk.Scale, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public VolumebarRange (Gtk.Orientation orientation);
		public double get_level ();
		public void set_level (double level);
		public double level { get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class WeekdayPicker : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public WeekdayPicker ();
		public bool isset_day (GLib.DateWeekday day);
		public void set_all ();
		public void set_day (GLib.DateWeekday day);
		public void toggle_day (GLib.DateWeekday day);
		public void unset_all ();
		public void unset_day (GLib.DateWeekday day);
		public virtual signal void selection_changed (int p0);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class Window : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Window ();
		public void add_toolbar (Gtk.Toolbar toolbar);
		public void add_with_scrollbar (Gtk.Widget child);
		public unowned Hildon.AppMenu get_app_menu ();
		public bool get_is_topmost ();
		public unowned Gtk.Menu get_main_menu ();
		public unowned string get_markup ();
		public unowned Gtk.Menu get_menu ();
		public void remove_toolbar (Gtk.Toolbar toolbar);
		public void set_app_menu (Hildon.AppMenu menu);
		public void set_edit_toolbar (Hildon.EditToolbar toolbar);
		public void set_main_menu (Gtk.Menu menu);
		public void set_markup (string markup);
		public void set_menu (Gtk.Menu menu);
		[NoWrapper]
		public virtual bool toggle_menu (uint button, uint32 time);
		public bool is_topmost { get; }
		public string markup { get; set; }
		public virtual signal void clipboard_operation (int operation);
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class WindowStack : GLib.Object {
		[CCode (has_construct_function = false)]
		public WindowStack ();
		public static unowned Hildon.WindowStack get_default ();
		public unowned GLib.List get_windows ();
		public unowned Gtk.Widget peek ();
		public void pop (int nwindows, GLib.List popped_windows);
		public unowned Gtk.Widget pop_1 ();
		public void pop_and_push (int nwindows, GLib.List popped_windows, Hildon.StackableWindow win1);
		public void pop_and_push_list (int nwindows, GLib.List popped_windows, GLib.List list);
		public void push (Hildon.StackableWindow win1);
		public void push_1 (Hildon.StackableWindow win);
		public void push_list (GLib.List list);
		public int size ();
		[NoAccessorMethod]
		public Gtk.WindowGroup window_group { owned get; construct; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public class WizardDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public WizardDialog (Gtk.Window parent, string wizard_name, Gtk.Notebook notebook);
		public void set_forward_page_func (Hildon.WizardDialogPageFunc page_func, void* data, GLib.DestroyNotify destroy);
		[NoAccessorMethod]
		public bool autotitle { get; set; }
		[NoAccessorMethod]
		public string wizard_name { owned get; set; }
		[NoAccessorMethod]
		public Gtk.Notebook wizard_notebook { owned get; set; }
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public interface BreadCrumb : Gtk.Widget {
		public void activated ();
		public abstract void get_natural_size (int width, int height);
		public signal void crumb_activated ();
	}
	[CCode (cprefix = "HILDON_BUTTON_ARRANGEMENT_", cheader_filename = "hildon/hildon.h")]
	public enum ButtonArrangement {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cprefix = "HILDON_BUTTON_STYLE_", cheader_filename = "hildon/hildon.h")]
	public enum ButtonStyle {
		NORMAL,
		PICKER
	}
	[CCode (cprefix = "HILDON_CALENDAR_", cheader_filename = "hildon/hildon.h")]
	[Flags]
	public enum CalendarDisplayOptions {
		SHOW_HEADING,
		SHOW_DAY_NAMES,
		NO_MONTH_CHANGE,
		SHOW_WEEK_NUMBERS,
		WEEK_START_MONDAY
	}
	[CCode (cprefix = "HILDON_CAPTION_POSITION_", cheader_filename = "hildon/hildon.h")]
	public enum CaptionIconPosition {
		LEFT,
		RIGHT
	}
	[CCode (cprefix = "HILDON_CAPTION_", cheader_filename = "hildon/hildon.h")]
	public enum CaptionStatus {
		OPTIONAL,
		MANDATORY
	}
	[CCode (cprefix = "HILDON_DATE_TIME_ERROR_", cheader_filename = "hildon/hildon.h")]
	public enum DateTimeError {
		NO_ERROR,
		MAX_HOURS,
		MAX_MINS,
		MAX_SECS,
		MAX_DAY,
		MAX_MONTH,
		MAX_YEAR,
		MIN_HOURS,
		MIN_MINS,
		MIN_SECS,
		MIN_DAY,
		MIN_MONTH,
		MIN_YEAR,
		EMPTY_HOURS,
		EMPTY_MINS,
		EMPTY_SECS,
		EMPTY_DAY,
		EMPTY_MONTH,
		EMPTY_YEAR,
		MIN_DURATION,
		MAX_DURATION,
		INVALID_CHAR,
		INVALID_DATE,
		INVALID_TIME
	}
	[CCode (cprefix = "HILDON_GTK_INPUT_MODE_", has_type_id = "0", cheader_filename = "gtk/gtk.h")]
	public enum GtkInputMode {
		ALPHA,
		NUMERIC,
		SPECIAL,
		HEXA,
		TELE,
		FULL,
		MULTILINE,
		INVISIBLE,
		AUTOCAP,
		DICTIONARY
	}
	[CCode (cprefix = "HILDON_", has_type_id = "0", cheader_filename = "gtk/gtk.h")]
	public enum Mode {
		DIABLO,
		FREMANTLE
	}
	[CCode (cprefix = "HILDON_MOVEMENT_", cheader_filename = "hildon/hildon.h")]
	public enum MovementDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cprefix = "HILDON_MOVEMENT_MODE_", cheader_filename = "hildon/hildon.h")]
	[Flags]
	public enum MovementMode {
		HORIZ,
		VERT,
		BOTH
	}
	[CCode (cprefix = "HILDON_NOTE_TYPE_", cheader_filename = "hildon/hildon.h")]
	public enum NoteType {
		CONFIRMATION,
		CONFIRMATION_BUTTON,
		INFORMATION,
		INFORMATION_THEME,
		PROGRESSBAR
	}
	[CCode (cprefix = "HILDON_NUMBER_EDITOR_ERROR_", cheader_filename = "hildon/hildon.h")]
	public enum NumberEditorErrorType {
		MAXIMUM_VALUE_EXCEED,
		MINIMUM_VALUE_EXCEED,
		ERRONEOUS_VALUE
	}
	[CCode (cprefix = "HILDON_PANNABLE_AREA_MODE_", cheader_filename = "hildon/hildon.h")]
	public enum PannableAreaMode {
		PUSH,
		ACCEL,
		AUTO
	}
	[CCode (cprefix = "HILDON_PORTRAIT_MODE_", cheader_filename = "hildon/hildon.h")]
	[Flags]
	public enum PortraitFlags {
		REQUEST,
		SUPPORT
	}
	[CCode (cprefix = "HILDON_SIZE_REQUEST_", cheader_filename = "hildon/hildon.h")]
	public enum SizeRequestPolicy {
		MINIMUM,
		CHILDREN
	}
	[CCode (cprefix = "HILDON_SIZE_", has_type_id = "0", cheader_filename = "gtk/gtk.h")]
	public enum SizeType {
		AUTO_WIDTH,
		HALFSCREEN_WIDTH,
		FULLSCREEN_WIDTH,
		AUTO_HEIGHT,
		FINGER_HEIGHT,
		THUMB_HEIGHT,
		AUTO
	}
	[CCode (cprefix = "HILDON_TIME_SELECTOR_FORMAT_POLICY_", cheader_filename = "hildon/hildon.h")]
	public enum TimeSelectorFormatPolicy {
		AMPM,
		@24H,
		AUTOMATIC
	}
	[CCode (cprefix = "HILDON_TOUCH_SELECTOR_SELECTION_MODE_", cheader_filename = "hildon/hildon.h")]
	public enum TouchSelectorSelectionMode {
		SINGLE,
		MULTIPLE
	}
	[CCode (cprefix = "HILDON_UI_MODE_", has_type_id = "0", cheader_filename = "gtk/gtk.h")]
	public enum UIMode {
		NORMAL,
		EDIT
	}
	[CCode (cprefix = "HILDON_WINDOW_CO_", cheader_filename = "hildon/hildon.h")]
	public enum WindowClipboardOperation {
		COPY,
		CUT,
		PASTE
	}
	[CCode (cprefix = "HILDON_WIZARD_DIALOG_", cheader_filename = "hildon/hildon.h")]
	public enum WizardDialogResponse {
		CANCEL,
		PREVIOUS,
		NEXT,
		FINISH
	}
	[CCode (cheader_filename = "hildon/hildon.h")]
	public delegate unowned string TouchSelectorPrintFunc (Hildon.TouchSelector selector);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public delegate bool WizardDialogPageFunc (Gtk.Notebook notebook, int current_page);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_CENTER_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_E_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_NE_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_NW_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_N_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_SE_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_SW_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_S_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_W_GRAVITY;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_X_AXIS;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_Y_AXIS;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int AA_Z_AXIS;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MARGIN_DEFAULT;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MARGIN_DOUBLE;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MARGIN_HALF;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MARGIN_TRIPLE;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int WINDOW_LONG_PRESS_TIME;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public const int WINDOW_TITLEBAR_HEIGHT;
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned string format_file_size_for_display (int64 size);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static int get_icon_pixel_size (Gtk.IconSize size);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_button_new (Hildon.SizeType size);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_hscale_new ();
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_icon_view_new (Hildon.UIMode mode);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_icon_view_new_with_model (Hildon.UIMode mode, Gtk.TreeModel model);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_icon_view_set_ui_mode (Gtk.IconView iconview, Hildon.UIMode mode);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_init ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_menu_new ();
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_radio_button_new (Hildon.SizeType size, GLib.SList group);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_radio_button_new_from_widget (Hildon.SizeType size, Gtk.RadioButton radio_group_member);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_toggle_button_new (Hildon.SizeType size);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_tree_view_new (Hildon.UIMode mode);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_tree_view_new_with_model (Hildon.UIMode mode, Gtk.TreeModel model);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_tree_view_set_ui_mode (Gtk.TreeView treeview, Hildon.UIMode mode);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget gtk_vscale_new ();
	[CCode (cheader_filename = "gtk/gtk.h")]
	public static void gtk_widget_set_theme_size (Gtk.Widget widget, Hildon.SizeType size);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_window_set_do_not_disturb (Gtk.Window window, bool dndflag);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_window_set_portrait_flags (Gtk.Window window, Hildon.PortraitFlags portrait_flags);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_window_set_progress_indicator (Gtk.Window window, uint state);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void gtk_window_take_screenshot (Gtk.Window window, bool take);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static bool helper_event_button_is_finger (Gdk.EventButton event);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void helper_set_insensitive_message (Gtk.Widget widget, string message);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void helper_set_insensitive_messagef (Gtk.Widget widget, string format);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static ulong helper_set_logical_color (Gtk.Widget widget, Gtk.RcFlags rcflags, Gtk.StateType state, string logicalcolorname);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static ulong helper_set_logical_font (Gtk.Widget widget, string logicalfontname);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void helper_set_thumb_scrollbar (Gtk.ScrolledWindow win, bool thumb);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void init ();
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static unowned Gtk.Widget pannable_get_child_widget_at (Hildon.PannableArea area, double x, double y);
	[CCode (cheader_filename = "hildon/hildon.h")]
	public static void play_system_sound (string sample);
}
