/* valacodenode.c generated by valac, the Vala compiler
 * generated from valacodenode.vala, do not modify */

/* valacodenode.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <valaccode.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define __g_list_free_vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_vala_code_node_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
typedef struct _ValaParamSpecCodeNode ValaParamSpecCodeNode;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaCodeNodePrivate {
	ValaCodeNode* _parent_node;
	ValaSourceReference* _source_reference;
	gboolean _checked;
	gboolean _error;
	ValaList* _error_types;
	ValaCCodeNode* _ccodenode;
};

struct _ValaParamSpecCodeNode {
	GParamSpec parent_instance;
};


static ValaList* vala_code_node__empty_type_list;
static ValaList* vala_code_node__empty_type_list = NULL;
static gint vala_code_node_last_temp_nr;
static gint vala_code_node_last_temp_nr = 0;
static gpointer vala_code_node_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
#define VALA_CODE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_NODE, ValaCodeNodePrivate))
enum  {
	VALA_CODE_NODE_DUMMY_PROPERTY
};
static void _g_list_free_vala_code_node_unref (GList* self);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type);
void vala_code_node_add_error_types (ValaCodeNode* self, ValaList* error_types);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_code_node_real_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_code_node_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_code_node_real_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static gboolean vala_code_node_real_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
void vala_code_node_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
static void vala_code_node_real_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
static void vala_code_node_real_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
const char* vala_attribute_get_name (ValaAttribute* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_source_reference_to_string (ValaSourceReference* self);
char* vala_code_node_to_string (ValaCodeNode* self);
static char* vala_code_node_real_to_string (ValaCodeNode* self);
void vala_code_node_get_defined_variables (ValaCodeNode* self, ValaCollection* collection);
static void vala_code_node_real_get_defined_variables (ValaCodeNode* self, ValaCollection* collection);
void vala_code_node_get_used_variables (ValaCodeNode* self, ValaCollection* collection);
static void vala_code_node_real_get_used_variables (ValaCodeNode* self, ValaCollection* collection);
char* vala_code_node_get_temp_name (ValaCodeNode* self);
ValaCodeNode* vala_code_node_construct (GType object_type);
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
const char* vala_code_node_get_type_name (ValaCodeNode* self);
ValaCCodeNode* vala_code_node_get_ccodenode (ValaCodeNode* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
const char* vala_source_file_get_filename (ValaSourceFile* self);
gint vala_source_reference_get_first_line (ValaSourceReference* self);
void vala_code_node_set_ccodenode (ValaCodeNode* self, ValaCCodeNode* value);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_get_tree_can_fail (ValaCodeNode* self);
static void vala_code_node_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vala_code_node_get_error_types (ValaCodeNode* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_error_types != NULL) {
		result = _vala_collection_object_ref0 (self->priv->_error_types);
		return result;
	}
	if (vala_code_node__empty_type_list == NULL) {
		ValaList* _tmp1_;
		ValaArrayList* _tmp0_;
		vala_code_node__empty_type_list = (_tmp1_ = (ValaList*) vala_read_only_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, (ValaList*) (_tmp0_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal))), _vala_collection_object_unref0 (vala_code_node__empty_type_list), _tmp1_);
		_vala_collection_object_unref0 (_tmp0_);
	}
	result = _vala_collection_object_ref0 (vala_code_node__empty_type_list);
	return result;
}


void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	if (self->priv->_error_types == NULL) {
		ValaList* _tmp0_;
		self->priv->_error_types = (_tmp0_ = (ValaList*) vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->_error_types), _tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_error_types, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, self);
}


void vala_code_node_add_error_types (ValaCodeNode* self, ValaList* error_types) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_types != NULL);
	{
		ValaIterator* _error_type_it;
		_error_type_it = vala_iterable_iterator ((ValaIterable*) error_types);
		while (TRUE) {
			ValaDataType* error_type;
			if (!vala_iterator_next (_error_type_it)) {
				break;
			}
			error_type = (ValaDataType*) vala_iterator_get (_error_type_it);
			vala_code_node_add_error_type (self, error_type);
			_vala_code_node_unref0 (error_type);
		}
		_vala_collection_object_unref0 (_error_type_it);
	}
}


static void vala_code_node_real_accept (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
}


void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	VALA_CODE_NODE_GET_CLASS (self)->accept (self, visitor);
}


static void vala_code_node_real_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
}


void vala_code_node_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	VALA_CODE_NODE_GET_CLASS (self)->accept_children (self, visitor);
}


static gboolean vala_code_node_real_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (analyzer != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer) {
	return VALA_CODE_NODE_GET_CLASS (self)->check (self, analyzer);
}


static void vala_code_node_real_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
}


void vala_code_node_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type) {
	VALA_CODE_NODE_GET_CLASS (self)->replace_type (self, old_type, new_type);
}


static void vala_code_node_real_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
}


void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node) {
	VALA_CODE_NODE_GET_CLASS (self)->replace_expression (self, old_node, new_node);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name) {
	ValaAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = self->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), name) == 0) {
					result = a;
					return result;
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
	result = NULL;
	return result;
}


static char* vala_code_node_real_to_string (ValaCodeNode* self) {
	char* result;
	GString* str;
	g_return_val_if_fail (self != NULL, NULL);
	str = g_string_new ("");
	g_string_append (str, "/* ");
	if (self->priv->_source_reference != NULL) {
		char* _tmp0_;
		g_string_append (g_string_append (str, "@"), _tmp0_ = vala_source_reference_to_string (self->priv->_source_reference));
		_g_free0 (_tmp0_);
	}
	result = g_strdup (g_string_append (str, " */")->str);
	_g_string_free0 (str);
	return result;
}


char* vala_code_node_to_string (ValaCodeNode* self) {
	return VALA_CODE_NODE_GET_CLASS (self)->to_string (self);
}


static void vala_code_node_real_get_defined_variables (ValaCodeNode* self, ValaCollection* collection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection != NULL);
}


void vala_code_node_get_defined_variables (ValaCodeNode* self, ValaCollection* collection) {
	VALA_CODE_NODE_GET_CLASS (self)->get_defined_variables (self, collection);
}


static void vala_code_node_real_get_used_variables (ValaCodeNode* self, ValaCollection* collection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection != NULL);
}


void vala_code_node_get_used_variables (ValaCodeNode* self, ValaCollection* collection) {
	VALA_CODE_NODE_GET_CLASS (self)->get_used_variables (self, collection);
}


char* vala_code_node_get_temp_name (ValaCodeNode* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strconcat (".", _tmp0_ = g_strdup_printf ("%i", vala_code_node_last_temp_nr = vala_code_node_last_temp_nr + 1), NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


ValaCodeNode* vala_code_node_construct (GType object_type) {
	ValaCodeNode* self;
	self = (ValaCodeNode*) g_type_create_instance (object_type);
	return self;
}


ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self) {
	ValaCodeNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent_node;
	return result;
}


void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value) {
	g_return_if_fail (self != NULL);
	self->priv->_parent_node = value;
}


ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self) {
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_reference;
	return result;
}


static gpointer _vala_source_reference_ref0 (gpointer self) {
	return self ? vala_source_reference_ref (self) : NULL;
}


void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value) {
	ValaSourceReference* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_reference = (_tmp0_ = _vala_source_reference_ref0 (value), _vala_source_reference_unref0 (self->priv->_source_reference), _tmp0_);
}


const char* vala_code_node_get_type_name (ValaCodeNode* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_type_name (G_TYPE_FROM_INSTANCE (self));
	return result;
}


ValaCCodeNode* vala_code_node_get_ccodenode (ValaCodeNode* self) {
	ValaCCodeNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ccodenode;
	return result;
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


void vala_code_node_set_ccodenode (ValaCodeNode* self, ValaCCodeNode* value) {
	gboolean _tmp0_ = FALSE;
	ValaCCodeNode* _tmp3_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = self->priv->_source_reference != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeLineDirective* _tmp2_;
		char* _tmp1_;
		vala_ccode_node_set_line (value, _tmp2_ = vala_ccode_line_directive_new (_tmp1_ = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (self->priv->_source_reference))), vala_source_reference_get_first_line (self->priv->_source_reference)));
		_vala_ccode_node_unref0 (_tmp2_);
		_g_free0 (_tmp1_);
	}
	self->priv->_ccodenode = (_tmp3_ = _vala_ccode_node_ref0 (value), _vala_ccode_node_unref0 (self->priv->_ccodenode), _tmp3_);
}


gboolean vala_code_node_get_checked (ValaCodeNode* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_checked;
	return result;
}


void vala_code_node_set_checked (ValaCodeNode* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_checked = value;
}


gboolean vala_code_node_get_error (ValaCodeNode* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error;
	return result;
}


void vala_code_node_set_error (ValaCodeNode* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error = value;
}


gboolean vala_code_node_get_tree_can_fail (ValaCodeNode* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_error_types != NULL) {
		_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_error_types) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_value_code_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_node_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_node (GValue* value, gpointer v_object) {
	ValaCodeNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_node_unref (old);
	}
}


static void vala_code_node_class_init (ValaCodeNodeClass * klass) {
	vala_code_node_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_code_node_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeNodePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_code_node_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_code_node_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->check = vala_code_node_real_check;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_code_node_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_code_node_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_code_node_real_to_string;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_code_node_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_code_node_real_get_used_variables;
}


static void vala_code_node_instance_init (ValaCodeNode * self) {
	self->priv = VALA_CODE_NODE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_code_node_finalize (ValaCodeNode* obj) {
	ValaCodeNode * self;
	self = VALA_CODE_NODE (obj);
	_vala_source_reference_unref0 (self->priv->_source_reference);
	__g_list_free_vala_code_node_unref0 (self->attributes);
	_vala_collection_object_unref0 (self->priv->_error_types);
	_vala_ccode_node_unref0 (self->priv->_ccodenode);
}


GType vala_code_node_get_type (void) {
	static GType vala_code_node_type_id = 0;
	if (vala_code_node_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_node_init, vala_value_code_node_free_value, vala_value_code_node_copy_value, vala_value_code_node_peek_pointer, "p", vala_value_code_node_collect_value, "p", vala_value_code_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeNode), 0, (GInstanceInitFunc) vala_code_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_code_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_code_node_type_id;
}


gpointer vala_code_node_ref (gpointer instance) {
	ValaCodeNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_node_unref (gpointer instance) {
	ValaCodeNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




