/* valamethodcall.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <valaccode.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;
typedef struct _ValaMethodCallPrivate ValaMethodCallPrivate;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_METHOD_TYPE (vala_method_type_get_type ())
#define VALA_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodType))
#define VALA_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))
#define VALA_IS_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_TYPE))
#define VALA_IS_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_TYPE))
#define VALA_METHOD_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))

typedef struct _ValaMethodType ValaMethodType;
typedef struct _ValaMethodTypeClass ValaMethodTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * Base class for all code nodes that might be used as an expression.
 */
struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
	GeeArrayList* temp_vars;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
};

/**
 * Represents an invocation expression in the source code.
 */
struct _ValaMethodCall {
	ValaExpression parent_instance;
	ValaMethodCallPrivate * priv;
	ValaExpression* _call;
};

struct _ValaMethodCallClass {
	ValaExpressionClass parent_class;
};

struct _ValaMethodCallPrivate {
	ValaCCodeExpression* _delegate_target;
	GeeList* argument_list;
	GeeList* array_sizes;
};

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* uint64_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};

/**
 * Interface for all statement types.
 */
struct _ValaStatementIface {
	GTypeInterface parent_iface;
};



gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_method_call_get_type (void);
#define VALA_METHOD_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_CALL, ValaMethodCallPrivate))
enum  {
	VALA_METHOD_CALL_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
void vala_method_call_set_call (ValaMethodCall* self, ValaExpression* value);
ValaMethodCall* vala_method_call_new (ValaExpression* call, ValaSourceReference* source_reference);
ValaMethodCall* vala_method_call_construct (GType object_type, ValaExpression* call, ValaSourceReference* source_reference);
ValaMethodCall* vala_method_call_new (ValaExpression* call, ValaSourceReference* source_reference);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_method_call_add_argument (ValaMethodCall* self, ValaExpression* arg);
GeeList* vala_method_call_get_argument_list (ValaMethodCall* self);
void vala_method_call_append_array_size (ValaMethodCall* self, ValaCCodeExpression* size);
GeeList* vala_method_call_get_array_sizes (ValaMethodCall* self);
void vala_code_visitor_visit_method_call (ValaCodeVisitor* self, ValaMethodCall* expr);
void vala_code_visitor_visit_expression (ValaCodeVisitor* self, ValaExpression* expr);
static void vala_method_call_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaExpression* vala_method_call_get_call (ValaMethodCall* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
static void vala_method_call_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
GType vala_member_access_get_type (void);
gboolean vala_member_access_get_prototype_access (ValaMemberAccess* self);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
ValaExpression* vala_member_access_get_inner (ValaMemberAccess* self);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
ValaMethod* vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self);
GType vala_creation_method_get_type (void);
gboolean vala_creation_method_get_chain_up (ValaCreationMethod* self);
void vala_creation_method_set_chain_up (ValaCreationMethod* self, gboolean value);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
GType vala_typesymbol_get_type (void);
GType vala_struct_get_type (void);
ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference);
ValaObjectCreationExpression* vala_object_creation_expression_construct (GType object_type, ValaMemberAccess* member_name, ValaSourceReference* source_reference);
GType vala_object_creation_expression_get_type (void);
void vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, gboolean value);
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
GType vala_namespace_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
GType vala_interface_get_type (void);
GType vala_enum_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_error_code_get_type (void);
GType vala_delegate_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_formal_parameter_get_type (void);
GType vala_property_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_signal_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
gboolean vala_data_type_is_invokable (ValaDataType* self);
GeeList* vala_data_type_get_parameters (ValaDataType* self);
gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self);
gboolean vala_formal_parameter_get_params_array (ValaFormalParameter* self);
ValaDataType* vala_formal_parameter_get_parameter_type (ValaFormalParameter* self);
GType vala_array_type_get_type (void);
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_expression_set_formal_target_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_formal_target_type (ValaExpression* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaCodeNode* node_reference);
GType vala_method_type_get_type (void);
ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self);
gboolean vala_method_get_printf_format (ValaMethod* self);
char* vala_string_literal_eval (ValaStringLiteral* self);
ValaVoidType* vala_void_type_new (ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_void_type_get_type (void);
ValaPointerType* vala_pointer_type_new (ValaDataType* base_type, ValaSourceReference* source_reference);
ValaPointerType* vala_pointer_type_construct (GType object_type, ValaDataType* base_type, ValaSourceReference* source_reference);
GType vala_pointer_type_get_type (void);
ValaDataType* vala_data_type_get_return_type (ValaDataType* self);
void vala_expression_set_formal_value_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_formal_value_type (ValaExpression* self);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
GeeList* vala_code_node_get_error_types (ValaCodeNode* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type);
GType vala_delegate_type_get_type (void);
ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self);
gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args);
ValaBlock* vala_expression_prepare_condition_split (ValaExpression* self, ValaSemanticAnalyzer* analyzer);
char* vala_code_node_get_temp_name (ValaCodeNode* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_local_variable_set_floating (ValaLocalVariable* self, gboolean value);
ValaDeclarationStatement* vala_declaration_statement_new (ValaSymbol* declaration, ValaSourceReference* source_reference);
ValaDeclarationStatement* vala_declaration_statement_construct (GType object_type, ValaSymbol* declaration, ValaSourceReference* source_reference);
GType vala_statement_get_type (void);
void vala_expression_insert_statement (ValaExpression* self, ValaBlock* block, ValaStatement* stmt);
ValaMemberAccess* vala_member_access_new_simple (const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct_simple (GType object_type, const char* member_name, ValaSourceReference* source_reference);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_local_variable_set_initializer (ValaLocalVariable* self, ValaExpression* value);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
void vala_block_remove_local_variable (ValaBlock* self, ValaLocalVariable* local);
void vala_block_add_local_variable (ValaBlock* self, ValaLocalVariable* local);
static gboolean vala_method_call_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_get_defined_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
void vala_code_node_get_used_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
ValaCCodeExpression* vala_method_call_get_delegate_target (ValaMethodCall* self);
void vala_method_call_set_delegate_target (ValaMethodCall* self, ValaCCodeExpression* value);
static gpointer vala_method_call_parent_class = NULL;
static void vala_method_call_finalize (ValaCodeNode* obj);



/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall* vala_method_call_construct (GType object_type, ValaExpression* call, ValaSourceReference* source_reference) {
	ValaMethodCall* self;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}


ValaMethodCall* vala_method_call_new (ValaExpression* call, ValaSourceReference* source_reference) {
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_method_call_add_argument (ValaMethodCall* self, ValaExpression* arg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	gee_collection_add ((GeeCollection*) self->priv->argument_list, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
GeeList* vala_method_call_get_argument_list (ValaMethodCall* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->argument_list);
}


/**
 * Add an array size C code expression.
 */
void vala_method_call_append_array_size (ValaMethodCall* self, ValaCCodeExpression* size) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	gee_collection_add ((GeeCollection*) self->priv->array_sizes, size);
}


/**
 * Get the C code expression for array sizes for all dimensions
 * ascending from left to right.
 */
GeeList* vala_method_call_get_array_sizes (ValaMethodCall* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, self->priv->array_sizes);
}


static void vala_method_call_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void vala_method_call_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_method_call_get_call (self), visitor);
	{
		GeeIterator* _expr_it;
		_expr_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (gee_iterator_next (_expr_it)) {
			ValaExpression* expr;
			expr = (ValaExpression*) gee_iterator_get (_expr_it);
			vala_code_node_accept ((ValaCodeNode*) expr, visitor);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
		}
		(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
	}
}


static void vala_method_call_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaMethodCall * self;
	gint index;
	gboolean _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_method_call_get_call (self) == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	index = gee_list_index_of (self->priv->argument_list, old_node);
	_tmp0_ = FALSE;
	if (index >= 0) {
		_tmp0_ = vala_code_node_get_parent_node ((ValaCodeNode*) new_node) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gee_list_set (self->priv->argument_list, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean vala_method_call_real_is_pure (ValaExpression* base) {
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	return FALSE;
}


static gboolean vala_method_call_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaMethodCall * self;
	ValaDataType* target_object_type;
	ValaDataType* _tmp8_;
	ValaDataType* mtype;
	gboolean _tmp12_;
	GeeList* params;
	gboolean _tmp22_;
	ValaExpression* last_arg;
	GeeList* args;
	GeeIterator* arg_it;
	gboolean _tmp30_;
	ValaDataType* ret_type;
	GeeList* _tmp88_;
	ValaDataType* _tmp92_;
	gboolean may_throw;
	GeeList* _tmp99_;
	gboolean _tmp100_;
	gboolean _tmp111_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (!vala_code_node_check ((ValaCodeNode*) vala_method_call_get_call (self), analyzer)) {
		/* if method resolving didn't succeed, skip this check */
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		return FALSE;
	}
	/* type of target object*/
	target_object_type = NULL;
	if (VALA_IS_MEMBER_ACCESS (vala_method_call_get_call (self))) {
		ValaMemberAccess* _tmp2_;
		ValaMemberAccess* ma;
		_tmp2_ = NULL;
		ma = (_tmp2_ = VALA_MEMBER_ACCESS (vala_method_call_get_call (self)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		if (vala_member_access_get_prototype_access (ma)) {
			char* _tmp4_;
			char* _tmp3_;
			gboolean _tmp5_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp4_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp3_ = vala_symbol_get_full_name (vala_expression_get_symbol_reference (vala_method_call_get_call (self)))));
			_tmp4_ = (g_free (_tmp4_), NULL);
			_tmp3_ = (g_free (_tmp3_), NULL);
			return (_tmp5_ = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), _tmp5_);
		}
		if (vala_member_access_get_inner (ma) != NULL) {
			ValaDataType* _tmp7_;
			ValaDataType* _tmp6_;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			target_object_type = (_tmp7_ = (_tmp6_ = vala_expression_get_value_type (vala_member_access_get_inner (ma)), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), _tmp7_);
		}
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	}
	_tmp8_ = NULL;
	mtype = (_tmp8_ = vala_expression_get_value_type (vala_method_call_get_call (self)), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
	if (VALA_IS_OBJECT_TYPE (mtype)) {
		ValaMethod* _tmp9_;
		ValaCreationMethod* cm;
		/* constructor chain-up*/
		_tmp9_ = NULL;
		cm = (_tmp9_ = vala_semantic_analyzer_find_current_method (analyzer), VALA_IS_CREATION_METHOD (_tmp9_) ? ((ValaCreationMethod*) _tmp9_) : NULL);
		if (cm == NULL) {
			gboolean _tmp10_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "use `new' operator to create new objects");
			return (_tmp10_ = FALSE, (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), _tmp10_);
		} else {
			if (vala_creation_method_get_chain_up (cm)) {
				gboolean _tmp11_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Multiple constructor calls in the same constructor are not permitted");
				return (_tmp11_ = FALSE, (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), _tmp11_);
			}
		}
		vala_creation_method_set_chain_up (cm, TRUE);
		(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	}
	_tmp12_ = FALSE;
	if (VALA_IS_MEMBER_ACCESS (vala_method_call_get_call (self))) {
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp13_ = FALSE;
		_tmp14_ = FALSE;
		if (VALA_IS_CREATION_METHOD (vala_expression_get_symbol_reference (vala_method_call_get_call (self)))) {
			_tmp14_ = VALA_IS_STRUCT (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_method_call_get_call (self))));
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = VALA_IS_STRUCT (vala_expression_get_symbol_reference (vala_method_call_get_call (self)));
		}
		_tmp12_ = _tmp13_;
	} else {
		_tmp12_ = FALSE;
	}
	/* check for struct construction*/
	if (_tmp12_) {
		ValaObjectCreationExpression* struct_creation_expression;
		gboolean _tmp17_;
		struct_creation_expression = vala_object_creation_expression_new (VALA_MEMBER_ACCESS (vala_method_call_get_call (self)), vala_code_node_get_source_reference ((ValaCodeNode*) self));
		vala_object_creation_expression_set_struct_creation (struct_creation_expression, TRUE);
		{
			GeeList* _tmp15_;
			GeeIterator* _tmp16_;
			GeeIterator* _arg_it;
			_tmp15_ = NULL;
			_tmp16_ = NULL;
			_arg_it = (_tmp16_ = gee_iterable_iterator ((GeeIterable*) (_tmp15_ = vala_method_call_get_argument_list (self))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (gee_collection_object_unref (_tmp15_), NULL)), _tmp16_);
			while (gee_iterator_next (_arg_it)) {
				ValaExpression* arg;
				arg = (ValaExpression*) gee_iterator_get (_arg_it);
				vala_object_creation_expression_add_argument (struct_creation_expression, arg);
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
		}
		vala_expression_set_target_type ((ValaExpression*) struct_creation_expression, vala_expression_get_target_type ((ValaExpression*) self));
		gee_collection_add ((GeeCollection*) analyzer->replaced_nodes, (ValaCodeNode*) self);
		vala_code_node_replace_expression (vala_code_node_get_parent_node ((ValaCodeNode*) self), (ValaExpression*) self, (ValaExpression*) struct_creation_expression);
		vala_code_node_check ((ValaCodeNode*) struct_creation_expression, analyzer);
		return (_tmp17_ = TRUE, (struct_creation_expression == NULL) ? NULL : (struct_creation_expression = (vala_code_node_unref (struct_creation_expression), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), _tmp17_);
	} else {
		gboolean _tmp18_;
		_tmp18_ = FALSE;
		if (VALA_IS_MEMBER_ACCESS (vala_method_call_get_call (self))) {
			_tmp18_ = VALA_IS_CREATION_METHOD (vala_expression_get_symbol_reference (vala_method_call_get_call (self)));
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaMethod* _tmp19_;
			ValaCreationMethod* cm;
			/* constructor chain-up*/
			_tmp19_ = NULL;
			cm = (_tmp19_ = vala_semantic_analyzer_find_current_method (analyzer), VALA_IS_CREATION_METHOD (_tmp19_) ? ((ValaCreationMethod*) _tmp19_) : NULL);
			if (cm == NULL) {
				gboolean _tmp20_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "use `new' operator to create new objects");
				return (_tmp20_ = FALSE, (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), _tmp20_);
			} else {
				if (vala_creation_method_get_chain_up (cm)) {
					gboolean _tmp21_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Multiple constructor calls in the same constructor are not permitted");
					return (_tmp21_ = FALSE, (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), _tmp21_);
				}
			}
			vala_creation_method_set_chain_up (cm, TRUE);
			(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
		}
	}
	params = NULL;
	_tmp22_ = FALSE;
	if (mtype != NULL) {
		_tmp22_ = vala_data_type_is_invokable (mtype);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GeeList* _tmp23_;
		_tmp23_ = NULL;
		params = (_tmp23_ = vala_data_type_get_parameters (mtype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp23_);
	} else {
		if (VALA_IS_CLASS (vala_expression_get_symbol_reference (vala_method_call_get_call (self)))) {
			gboolean _tmp24_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "use `new' operator to create new objects");
			return (_tmp24_ = FALSE, (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp24_);
		} else {
			gboolean _tmp25_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "invocation not supported in this context");
			return (_tmp25_ = FALSE, (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp25_);
		}
	}
	last_arg = NULL;
	args = vala_method_call_get_argument_list (self);
	arg_it = gee_iterable_iterator ((GeeIterable*) args);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_ellipsis (param)) {
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (vala_formal_parameter_get_params_array (param)) {
				ValaArrayType* _tmp26_;
				ValaArrayType* array_type;
				_tmp26_ = NULL;
				array_type = (_tmp26_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp26_ == NULL) ? NULL : vala_code_node_ref (_tmp26_));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					/* store expected type for callback parameters */
					vala_expression_set_target_type (arg, vala_array_type_get_element_type (array_type));
					vala_data_type_set_value_owned (vala_expression_get_target_type (arg), vala_data_type_get_value_owned ((ValaDataType*) array_type));
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (gee_iterator_next (arg_it)) {
				ValaExpression* arg;
				ValaDataType* _tmp27_;
				ValaExpression* _tmp29_;
				ValaExpression* _tmp28_;
				arg = (ValaExpression*) gee_iterator_get (arg_it);
				/* store expected type for callback parameters */
				vala_expression_set_formal_target_type (arg, vala_formal_parameter_get_parameter_type (param));
				_tmp27_ = NULL;
				vala_expression_set_target_type (arg, _tmp27_ = vala_data_type_get_actual_type (vala_expression_get_formal_target_type (arg), target_object_type, (ValaCodeNode*) self));
				(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_code_node_unref (_tmp27_), NULL));
				_tmp29_ = NULL;
				_tmp28_ = NULL;
				last_arg = (_tmp29_ = (_tmp28_ = arg, (_tmp28_ == NULL) ? NULL : vala_code_node_ref (_tmp28_)), (last_arg == NULL) ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)), _tmp29_);
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp30_ = FALSE;
	if (VALA_IS_METHOD_TYPE (mtype)) {
		_tmp30_ = vala_method_get_printf_format (vala_method_type_get_method_symbol (VALA_METHOD_TYPE (mtype)));
	} else {
		_tmp30_ = FALSE;
	}
	/* printf arguments*/
	if (_tmp30_) {
		ValaStringLiteral* format_literal;
		format_literal = NULL;
		if (last_arg != NULL) {
			ValaStringLiteral* _tmp33_;
			ValaStringLiteral* _tmp32_;
			ValaExpression* _tmp31_;
			/* use last argument as format string*/
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			_tmp31_ = NULL;
			format_literal = (_tmp33_ = (_tmp32_ = (_tmp31_ = last_arg, VALA_IS_STRING_LITERAL (_tmp31_) ? ((ValaStringLiteral*) _tmp31_) : NULL), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_)), (format_literal == NULL) ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)), _tmp33_);
		} else {
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp34_;
			ValaMemberAccess* ma;
			/* use instance as format string for string.printf (...)*/
			_tmp35_ = NULL;
			_tmp34_ = NULL;
			ma = (_tmp35_ = (_tmp34_ = vala_method_call_get_call (self), VALA_IS_MEMBER_ACCESS (_tmp34_) ? ((ValaMemberAccess*) _tmp34_) : NULL), (_tmp35_ == NULL) ? NULL : vala_code_node_ref (_tmp35_));
			if (ma != NULL) {
				ValaStringLiteral* _tmp38_;
				ValaStringLiteral* _tmp37_;
				ValaExpression* _tmp36_;
				_tmp38_ = NULL;
				_tmp37_ = NULL;
				_tmp36_ = NULL;
				format_literal = (_tmp38_ = (_tmp37_ = (_tmp36_ = vala_member_access_get_inner (ma), VALA_IS_STRING_LITERAL (_tmp36_) ? ((ValaStringLiteral*) _tmp36_) : NULL), (_tmp37_ == NULL) ? NULL : vala_code_node_ref (_tmp37_)), (format_literal == NULL) ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)), _tmp38_);
			}
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		if (format_literal != NULL) {
			char* format;
			gboolean unsupported_format;
			const char* format_it;
			gunichar c;
			gboolean _tmp84_;
			format = vala_string_literal_eval (format_literal);
			unsupported_format = FALSE;
			format_it = format;
			c = g_utf8_get_char (format_it);
			while (c != '\0') {
				gint length;
				ValaDataType* param_type;
				gboolean _tmp45_;
				gboolean _tmp46_;
				if (c != '%') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
					continue;
				}
				format_it = g_utf8_next_char (format_it);
				c = g_utf8_get_char (format_it);
				while (TRUE) {
					gboolean _tmp39_;
					gboolean _tmp40_;
					gboolean _tmp41_;
					gboolean _tmp42_;
					_tmp39_ = FALSE;
					_tmp40_ = FALSE;
					_tmp41_ = FALSE;
					_tmp42_ = FALSE;
					if (c == '#') {
						_tmp42_ = TRUE;
					} else {
						_tmp42_ = c == '0';
					}
					if (_tmp42_) {
						_tmp41_ = TRUE;
					} else {
						_tmp41_ = c == '-';
					}
					if (_tmp41_) {
						_tmp40_ = TRUE;
					} else {
						_tmp40_ = c == ' ';
					}
					if (_tmp40_) {
						_tmp39_ = TRUE;
					} else {
						_tmp39_ = c == '+';
					}
					if (!_tmp39_) {
						break;
					}
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
				}
				while (TRUE) {
					gboolean _tmp43_;
					_tmp43_ = FALSE;
					if (c >= '0') {
						_tmp43_ = c <= '9';
					} else {
						_tmp43_ = FALSE;
					}
					if (!_tmp43_) {
						break;
					}
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
				}
				/* precision*/
				if (c == '.') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
					while (TRUE) {
						gboolean _tmp44_;
						_tmp44_ = FALSE;
						if (c >= '0') {
							_tmp44_ = c <= '9';
						} else {
							_tmp44_ = FALSE;
						}
						if (!_tmp44_) {
							break;
						}
						format_it = g_utf8_next_char (format_it);
						c = g_utf8_get_char (format_it);
					}
				}
				/* length modifier*/
				length = 0;
				if (c == 'h') {
					length = -1;
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
					if (c == 'h') {
						length = -2;
						format_it = g_utf8_next_char (format_it);
						c = g_utf8_get_char (format_it);
					}
				} else {
					if (c == 'l') {
						length = 1;
						format_it = g_utf8_next_char (format_it);
						c = g_utf8_get_char (format_it);
					} else {
						if (c == 'z') {
							length = 2;
							format_it = g_utf8_next_char (format_it);
							c = g_utf8_get_char (format_it);
						}
					}
				}
				/* conversion specifier*/
				param_type = NULL;
				_tmp45_ = FALSE;
				_tmp46_ = FALSE;
				if (c == 'd') {
					_tmp46_ = TRUE;
				} else {
					_tmp46_ = c == 'i';
				}
				if (_tmp46_) {
					_tmp45_ = TRUE;
				} else {
					_tmp45_ = c == 'c';
				}
				if (_tmp45_) {
					/* integer*/
					if (length == (-2)) {
						ValaDataType* _tmp48_;
						ValaDataType* _tmp47_;
						_tmp48_ = NULL;
						_tmp47_ = NULL;
						param_type = (_tmp48_ = (_tmp47_ = analyzer->int8_type, (_tmp47_ == NULL) ? NULL : vala_code_node_ref (_tmp47_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp48_);
					} else {
						if (length == (-1)) {
							ValaDataType* _tmp50_;
							ValaDataType* _tmp49_;
							_tmp50_ = NULL;
							_tmp49_ = NULL;
							param_type = (_tmp50_ = (_tmp49_ = analyzer->short_type, (_tmp49_ == NULL) ? NULL : vala_code_node_ref (_tmp49_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp50_);
						} else {
							if (length == 0) {
								ValaDataType* _tmp52_;
								ValaDataType* _tmp51_;
								_tmp52_ = NULL;
								_tmp51_ = NULL;
								param_type = (_tmp52_ = (_tmp51_ = analyzer->int_type, (_tmp51_ == NULL) ? NULL : vala_code_node_ref (_tmp51_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp52_);
							} else {
								if (length == 1) {
									ValaDataType* _tmp54_;
									ValaDataType* _tmp53_;
									_tmp54_ = NULL;
									_tmp53_ = NULL;
									param_type = (_tmp54_ = (_tmp53_ = analyzer->long_type, (_tmp53_ == NULL) ? NULL : vala_code_node_ref (_tmp53_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp54_);
								} else {
									if (length == 2) {
										ValaDataType* _tmp56_;
										ValaDataType* _tmp55_;
										_tmp56_ = NULL;
										_tmp55_ = NULL;
										param_type = (_tmp56_ = (_tmp55_ = analyzer->ssize_t_type, (_tmp55_ == NULL) ? NULL : vala_code_node_ref (_tmp55_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp56_);
									}
								}
							}
						}
					}
				} else {
					gboolean _tmp57_;
					gboolean _tmp58_;
					gboolean _tmp59_;
					_tmp57_ = FALSE;
					_tmp58_ = FALSE;
					_tmp59_ = FALSE;
					if (c == 'o') {
						_tmp59_ = TRUE;
					} else {
						_tmp59_ = c == 'u';
					}
					if (_tmp59_) {
						_tmp58_ = TRUE;
					} else {
						_tmp58_ = c == 'x';
					}
					if (_tmp58_) {
						_tmp57_ = TRUE;
					} else {
						_tmp57_ = c == 'X';
					}
					if (_tmp57_) {
						/* unsigned integer*/
						if (length == (-2)) {
							ValaDataType* _tmp61_;
							ValaDataType* _tmp60_;
							_tmp61_ = NULL;
							_tmp60_ = NULL;
							param_type = (_tmp61_ = (_tmp60_ = analyzer->uchar_type, (_tmp60_ == NULL) ? NULL : vala_code_node_ref (_tmp60_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp61_);
						} else {
							if (length == (-1)) {
								ValaDataType* _tmp63_;
								ValaDataType* _tmp62_;
								_tmp63_ = NULL;
								_tmp62_ = NULL;
								param_type = (_tmp63_ = (_tmp62_ = analyzer->ushort_type, (_tmp62_ == NULL) ? NULL : vala_code_node_ref (_tmp62_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp63_);
							} else {
								if (length == 0) {
									ValaDataType* _tmp65_;
									ValaDataType* _tmp64_;
									_tmp65_ = NULL;
									_tmp64_ = NULL;
									param_type = (_tmp65_ = (_tmp64_ = analyzer->uint_type, (_tmp64_ == NULL) ? NULL : vala_code_node_ref (_tmp64_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp65_);
								} else {
									if (length == 1) {
										ValaDataType* _tmp67_;
										ValaDataType* _tmp66_;
										_tmp67_ = NULL;
										_tmp66_ = NULL;
										param_type = (_tmp67_ = (_tmp66_ = analyzer->ulong_type, (_tmp66_ == NULL) ? NULL : vala_code_node_ref (_tmp66_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp67_);
									} else {
										if (length == 2) {
											ValaDataType* _tmp69_;
											ValaDataType* _tmp68_;
											_tmp69_ = NULL;
											_tmp68_ = NULL;
											param_type = (_tmp69_ = (_tmp68_ = analyzer->size_t_type, (_tmp68_ == NULL) ? NULL : vala_code_node_ref (_tmp68_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp69_);
										}
									}
								}
							}
						}
					} else {
						gboolean _tmp70_;
						gboolean _tmp71_;
						gboolean _tmp72_;
						gboolean _tmp73_;
						gboolean _tmp74_;
						gboolean _tmp75_;
						gboolean _tmp76_;
						_tmp70_ = FALSE;
						_tmp71_ = FALSE;
						_tmp72_ = FALSE;
						_tmp73_ = FALSE;
						_tmp74_ = FALSE;
						_tmp75_ = FALSE;
						_tmp76_ = FALSE;
						if (c == 'e') {
							_tmp76_ = TRUE;
						} else {
							_tmp76_ = c == 'E';
						}
						if (_tmp76_) {
							_tmp75_ = TRUE;
						} else {
							_tmp75_ = c == 'f';
						}
						if (_tmp75_) {
							_tmp74_ = TRUE;
						} else {
							_tmp74_ = c == 'F';
						}
						if (_tmp74_) {
							_tmp73_ = TRUE;
						} else {
							_tmp73_ = c == 'g';
						}
						if (_tmp73_) {
							_tmp72_ = TRUE;
						} else {
							_tmp72_ = c == 'G';
						}
						if (_tmp72_) {
							_tmp71_ = TRUE;
						} else {
							_tmp71_ = c == 'a';
						}
						if (_tmp71_) {
							_tmp70_ = TRUE;
						} else {
							_tmp70_ = c == 'A';
						}
						if (_tmp70_) {
							ValaDataType* _tmp78_;
							ValaDataType* _tmp77_;
							/* double*/
							_tmp78_ = NULL;
							_tmp77_ = NULL;
							param_type = (_tmp78_ = (_tmp77_ = analyzer->double_type, (_tmp77_ == NULL) ? NULL : vala_code_node_ref (_tmp77_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp78_);
						} else {
							if (c == 's') {
								ValaDataType* _tmp80_;
								ValaDataType* _tmp79_;
								/* string*/
								_tmp80_ = NULL;
								_tmp79_ = NULL;
								param_type = (_tmp80_ = (_tmp79_ = analyzer->string_type, (_tmp79_ == NULL) ? NULL : vala_code_node_ref (_tmp79_)), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp80_);
							} else {
								if (c == 'p') {
									ValaDataType* _tmp82_;
									ValaVoidType* _tmp81_;
									/* pointer*/
									_tmp82_ = NULL;
									_tmp81_ = NULL;
									param_type = (_tmp82_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp81_ = vala_void_type_new (NULL)), NULL), (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), _tmp82_);
									(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_code_node_unref (_tmp81_), NULL));
								} else {
									if (c == '%') {
									} else {
										/* literal %*/
										unsupported_format = TRUE;
										(param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL));
										break;
									}
								}
							}
						}
					}
				}
				if (c != '\0') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
				}
				if (param_type != NULL) {
					if (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = (ValaExpression*) gee_iterator_get (arg_it);
						vala_expression_set_target_type (arg, param_type);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					} else {
						gboolean _tmp83_;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Too few arguments for specified format");
						return (_tmp83_ = FALSE, (param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)), format = (g_free (format), NULL), (format_literal == NULL) ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), (last_arg == NULL) ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)), (args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp83_);
					}
				}
				(param_type == NULL) ? NULL : (param_type = (vala_code_node_unref (param_type), NULL));
			}
			_tmp84_ = FALSE;
			if (!unsupported_format) {
				_tmp84_ = gee_iterator_next (arg_it);
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				gboolean _tmp85_;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Too many arguments for specified format");
				return (_tmp85_ = FALSE, format = (g_free (format), NULL), (format_literal == NULL) ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), (last_arg == NULL) ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)), (args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp85_);
			}
			format = (g_free (format), NULL);
		}
		(format_literal == NULL) ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL));
	}
	{
		GeeList* _tmp86_;
		GeeIterator* _tmp87_;
		GeeIterator* _arg_it;
		_tmp86_ = NULL;
		_tmp87_ = NULL;
		_arg_it = (_tmp87_ = gee_iterable_iterator ((GeeIterable*) (_tmp86_ = vala_method_call_get_argument_list (self))), (_tmp86_ == NULL) ? NULL : (_tmp86_ = (gee_collection_object_unref (_tmp86_), NULL)), _tmp87_);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_check ((ValaCodeNode*) arg, analyzer);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	ret_type = vala_data_type_get_return_type (mtype);
	_tmp88_ = NULL;
	params = (_tmp88_ = vala_data_type_get_parameters (mtype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp88_);
	if (VALA_IS_VOID_TYPE (ret_type)) {
		gboolean _tmp89_;
		gboolean _tmp90_;
		_tmp89_ = FALSE;
		_tmp90_ = FALSE;
		if (!VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self))) {
			_tmp90_ = !VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self));
		} else {
			_tmp90_ = FALSE;
		}
		if (_tmp90_) {
			_tmp89_ = !VALA_IS_YIELD_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self));
		} else {
			_tmp89_ = FALSE;
		}
		/* void return type*/
		if (_tmp89_) {
			gboolean _tmp91_;
			/* A void method invocation can be in the initializer or
			 iterator of a for statement*/
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "invocation of void method not allowed as expression");
			return (_tmp91_ = FALSE, (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), (last_arg == NULL) ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)), (args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), (ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)), _tmp91_);
		}
	}
	vala_expression_set_formal_value_type ((ValaExpression*) self, ret_type);
	_tmp92_ = NULL;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp92_ = vala_data_type_get_actual_type (vala_expression_get_formal_value_type ((ValaExpression*) self), target_object_type, (ValaCodeNode*) self));
	(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_code_node_unref (_tmp92_), NULL));
	may_throw = FALSE;
	if (VALA_IS_METHOD_TYPE (mtype)) {
		ValaMethod* _tmp93_;
		ValaMethod* m;
		_tmp93_ = NULL;
		m = (_tmp93_ = vala_method_type_get_method_symbol (VALA_METHOD_TYPE (mtype)), (_tmp93_ == NULL) ? NULL : vala_code_node_ref (_tmp93_));
		{
			GeeList* _tmp94_;
			GeeIterator* _tmp95_;
			GeeIterator* _error_type_it;
			_tmp94_ = NULL;
			_tmp95_ = NULL;
			_error_type_it = (_tmp95_ = gee_iterable_iterator ((GeeIterable*) (_tmp94_ = vala_code_node_get_error_types ((ValaCodeNode*) m))), (_tmp94_ == NULL) ? NULL : (_tmp94_ = (gee_collection_object_unref (_tmp94_), NULL)), _tmp95_);
			while (gee_iterator_next (_error_type_it)) {
				ValaDataType* error_type;
				ValaDataType* call_error_type;
				error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
				may_throw = TRUE;
				/* ensure we can trace back which expression may throw errors of this type*/
				call_error_type = vala_data_type_copy (error_type);
				vala_code_node_set_source_reference ((ValaCodeNode*) call_error_type, vala_code_node_get_source_reference ((ValaCodeNode*) self));
				vala_code_node_add_error_type ((ValaCodeNode*) self, call_error_type);
				(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
				(call_error_type == NULL) ? NULL : (call_error_type = (vala_code_node_unref (call_error_type), NULL));
			}
			(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (mtype)) {
			ValaDelegate* _tmp96_;
			ValaDelegate* d;
			_tmp96_ = NULL;
			d = (_tmp96_ = vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (mtype)), (_tmp96_ == NULL) ? NULL : vala_code_node_ref (_tmp96_));
			{
				GeeList* _tmp97_;
				GeeIterator* _tmp98_;
				GeeIterator* _error_type_it;
				_tmp97_ = NULL;
				_tmp98_ = NULL;
				_error_type_it = (_tmp98_ = gee_iterable_iterator ((GeeIterable*) (_tmp97_ = vala_code_node_get_error_types ((ValaCodeNode*) d))), (_tmp97_ == NULL) ? NULL : (_tmp97_ = (gee_collection_object_unref (_tmp97_), NULL)), _tmp98_);
				while (gee_iterator_next (_error_type_it)) {
					ValaDataType* error_type;
					ValaDataType* call_error_type;
					error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
					may_throw = TRUE;
					/* ensure we can trace back which expression may throw errors of this type*/
					call_error_type = vala_data_type_copy (error_type);
					vala_code_node_set_source_reference ((ValaCodeNode*) call_error_type, vala_code_node_get_source_reference ((ValaCodeNode*) self));
					vala_code_node_add_error_type ((ValaCodeNode*) self, call_error_type);
					(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
					(call_error_type == NULL) ? NULL : (call_error_type = (vala_code_node_unref (call_error_type), NULL));
				}
				(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
			}
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp99_ = NULL;
	if ((_tmp100_ = !vala_semantic_analyzer_check_arguments (analyzer, (ValaExpression*) self, mtype, params, _tmp99_ = vala_method_call_get_argument_list (self)), (_tmp99_ == NULL) ? NULL : (_tmp99_ = (gee_collection_object_unref (_tmp99_), NULL)), _tmp100_)) {
		gboolean _tmp101_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		return (_tmp101_ = FALSE, (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), (last_arg == NULL) ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)), (args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), (ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)), _tmp101_);
	}
	if (may_throw) {
		gboolean _tmp102_;
		_tmp102_ = FALSE;
		if (VALA_IS_LOCAL_VARIABLE (vala_code_node_get_parent_node ((ValaCodeNode*) self))) {
			_tmp102_ = TRUE;
		} else {
			_tmp102_ = VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self));
		}
		if (_tmp102_) {
		} else {
			ValaBlock* _tmp103_;
			ValaBlock* old_insert_block;
			ValaBlock* _tmp104_;
			ValaCodeNode* _tmp105_;
			ValaCodeNode* old_parent_node;
			char* _tmp106_;
			ValaLocalVariable* _tmp107_;
			ValaLocalVariable* local;
			ValaDeclarationStatement* decl;
			ValaExpression* temp_access;
			ValaBlock* _tmp108_;
			ValaBlock* block;
			ValaBlock* _tmp110_;
			ValaBlock* _tmp109_;
			/* simple statements, no side effects after method call*/
			_tmp103_ = NULL;
			old_insert_block = (_tmp103_ = analyzer->insert_block, (_tmp103_ == NULL) ? NULL : vala_code_node_ref (_tmp103_));
			_tmp104_ = NULL;
			analyzer->insert_block = (_tmp104_ = vala_expression_prepare_condition_split ((ValaExpression*) self, analyzer), (analyzer->insert_block == NULL) ? NULL : (analyzer->insert_block = (vala_code_node_unref (analyzer->insert_block), NULL)), _tmp104_);
			/* store parent_node as we need to replace the expression in the old parent node later on*/
			_tmp105_ = NULL;
			old_parent_node = (_tmp105_ = vala_code_node_get_parent_node ((ValaCodeNode*) self), (_tmp105_ == NULL) ? NULL : vala_code_node_ref (_tmp105_));
			_tmp106_ = NULL;
			_tmp107_ = NULL;
			local = (_tmp107_ = vala_local_variable_new (vala_expression_get_value_type ((ValaExpression*) self), _tmp106_ = vala_code_node_get_temp_name ((ValaCodeNode*) self), NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self)), _tmp106_ = (g_free (_tmp106_), NULL), _tmp107_);
			/* use floating variable to avoid unnecessary (and sometimes impossible) copies*/
			vala_local_variable_set_floating (local, TRUE);
			decl = vala_declaration_statement_new ((ValaSymbol*) local, vala_code_node_get_source_reference ((ValaCodeNode*) self));
			vala_expression_insert_statement ((ValaExpression*) self, analyzer->insert_block, (ValaStatement*) decl);
			temp_access = (ValaExpression*) vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), vala_code_node_get_source_reference ((ValaCodeNode*) self));
			vala_expression_set_target_type (temp_access, vala_expression_get_target_type ((ValaExpression*) self));
			/* don't set initializer earlier as this changes parent_node and parent_statement*/
			vala_local_variable_set_initializer (local, (ValaExpression*) self);
			vala_code_node_check ((ValaCodeNode*) decl, analyzer);
			vala_code_node_check ((ValaCodeNode*) temp_access, analyzer);
			/* move temp variable to insert block to ensure the
			 variable is in the same block as the declaration
			 otherwise there will be scoping issues in the generated code*/
			_tmp108_ = NULL;
			block = (_tmp108_ = VALA_BLOCK (vala_semantic_analyzer_get_current_symbol (analyzer)), (_tmp108_ == NULL) ? NULL : vala_code_node_ref (_tmp108_));
			vala_block_remove_local_variable (block, local);
			vala_block_add_local_variable (analyzer->insert_block, local);
			_tmp110_ = NULL;
			_tmp109_ = NULL;
			analyzer->insert_block = (_tmp110_ = (_tmp109_ = old_insert_block, (_tmp109_ == NULL) ? NULL : vala_code_node_ref (_tmp109_)), (analyzer->insert_block == NULL) ? NULL : (analyzer->insert_block = (vala_code_node_unref (analyzer->insert_block), NULL)), _tmp110_);
			vala_code_node_replace_expression (old_parent_node, (ValaExpression*) self, temp_access);
			(old_insert_block == NULL) ? NULL : (old_insert_block = (vala_code_node_unref (old_insert_block), NULL));
			(old_parent_node == NULL) ? NULL : (old_parent_node = (vala_code_node_unref (old_parent_node), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			(temp_access == NULL) ? NULL : (temp_access = (vala_code_node_unref (temp_access), NULL));
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
		}
	}
	return (_tmp111_ = !vala_code_node_get_error ((ValaCodeNode*) self), (target_object_type == NULL) ? NULL : (target_object_type = (vala_code_node_unref (target_object_type), NULL)), (mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), (last_arg == NULL) ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)), (args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), (ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)), _tmp111_);
}


static void vala_method_call_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	vala_code_node_get_defined_variables ((ValaCodeNode*) vala_method_call_get_call (self), collection);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_get_defined_variables ((ValaCodeNode*) arg, collection);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
}


static void vala_method_call_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	vala_code_node_get_used_variables ((ValaCodeNode*) vala_method_call_get_call (self), collection);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_get_used_variables ((ValaCodeNode*) arg, collection);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
}


ValaExpression* vala_method_call_get_call (ValaMethodCall* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->_call;
}


void vala_method_call_set_call (ValaMethodCall* self, ValaExpression* value) {
	ValaExpression* _tmp2_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->_call = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (self->_call == NULL) ? NULL : (self->_call = (vala_code_node_unref (self->_call), NULL)), _tmp2_);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->_call, (ValaCodeNode*) self);
}


ValaCCodeExpression* vala_method_call_get_delegate_target (ValaMethodCall* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_delegate_target;
}


void vala_method_call_set_delegate_target (ValaMethodCall* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_delegate_target = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_)), (self->priv->_delegate_target == NULL) ? NULL : (self->priv->_delegate_target = (vala_ccode_node_unref (self->priv->_delegate_target), NULL)), _tmp2_);
}


static void vala_method_call_class_init (ValaMethodCallClass * klass) {
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_method_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodCallPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_method_call_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_method_call_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_method_call_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_method_call_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->check = vala_method_call_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_method_call_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_method_call_real_get_used_variables;
}


static void vala_method_call_instance_init (ValaMethodCall * self) {
	self->priv = VALA_METHOD_CALL_GET_PRIVATE (self);
	self->priv->argument_list = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->array_sizes = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_method_call_finalize (ValaCodeNode* obj) {
	ValaMethodCall * self;
	self = VALA_METHOD_CALL (obj);
	(self->priv->_delegate_target == NULL) ? NULL : (self->priv->_delegate_target = (vala_ccode_node_unref (self->priv->_delegate_target), NULL));
	(self->_call == NULL) ? NULL : (self->_call = (vala_code_node_unref (self->_call), NULL));
	(self->priv->argument_list == NULL) ? NULL : (self->priv->argument_list = (gee_collection_object_unref (self->priv->argument_list), NULL));
	(self->priv->array_sizes == NULL) ? NULL : (self->priv->array_sizes = (gee_collection_object_unref (self->priv->array_sizes), NULL));
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


GType vala_method_call_get_type (void) {
	static GType vala_method_call_type_id = 0;
	if (vala_method_call_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	}
	return vala_method_call_type_id;
}




