/* valasourcefile.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASOURCEFILE_H__
#define __VALA_VALASOURCEFILE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <gee/set.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFilePrivate ValaSourceFilePrivate;
typedef struct _ValaParamSpecSourceFile ValaParamSpecSourceFile;

#define VALA_TYPE_SOURCE_FILE_DEPENDENCY_TYPE (vala_source_file_dependency_type_get_type ())

/**
 * Represents a Vala source or VAPI package file.
 */
struct _ValaSourceFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaSourceFilePrivate * priv;
};

struct _ValaSourceFileClass {
	GTypeClass parent_class;
	void (*finalize) (ValaSourceFile *self);
};

struct _ValaParamSpecSourceFile {
	GParamSpec parent_instance;
};

typedef enum  {
	VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_FULL,
	VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_SHALLOW,
	VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE
} ValaSourceFileDependencyType;


ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, const char* filename, gboolean pkg, const char* content);
ValaSourceFile* vala_source_file_new (ValaCodeContext* context, const char* filename, gboolean pkg, const char* content);
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
void vala_source_file_clear_using_directives (ValaSourceFile* self);
GeeList* vala_source_file_get_using_directives (ValaSourceFile* self);
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node);
void vala_source_file_remove_node (ValaSourceFile* self, ValaCodeNode* node);
GeeList* vala_source_file_get_nodes (ValaSourceFile* self);
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_source_file_accept_children (ValaSourceFile* self, ValaCodeVisitor* visitor);
char* vala_source_file_get_relative_filename (ValaSourceFile* self);
char* vala_source_file_get_cheader_filename (ValaSourceFile* self);
char* vala_source_file_get_csource_filename (ValaSourceFile* self);
char* vala_source_file_get_cinclude_filename (ValaSourceFile* self);
void vala_source_file_add_symbol_dependency (ValaSourceFile* self, ValaSymbol* sym, ValaSourceFileDependencyType dep_type);
void vala_source_file_add_type_dependency (ValaSourceFile* self, ValaDataType* type, ValaSourceFileDependencyType dep_type);
GeeList* vala_source_file_get_header_external_includes (ValaSourceFile* self);
void vala_source_file_add_header_internal_include (ValaSourceFile* self, const char* include);
GeeList* vala_source_file_get_header_internal_includes (ValaSourceFile* self);
GeeList* vala_source_file_get_source_external_includes (ValaSourceFile* self);
GeeList* vala_source_file_get_source_internal_includes (ValaSourceFile* self);
GeeList* vala_source_file_get_header_internal_full_dependencies (ValaSourceFile* self);
GeeList* vala_source_file_get_header_internal_dependencies (ValaSourceFile* self);
GeeSet* vala_source_file_get_source_symbol_dependencies (ValaSourceFile* self);
char* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
gboolean vala_source_file_check (ValaSourceFile* self, ValaSemanticAnalyzer* analyzer);
const char* vala_source_file_get_filename (ValaSourceFile* self);
void vala_source_file_set_filename (ValaSourceFile* self, const char* value);
const char* vala_source_file_get_comment (ValaSourceFile* self);
void vala_source_file_set_comment (ValaSourceFile* self, const char* value);
gboolean vala_source_file_get_external_package (ValaSourceFile* self);
void vala_source_file_set_external_package (ValaSourceFile* self, gboolean value);
ValaSourceFileCycle* vala_source_file_get_cycle (ValaSourceFile* self);
void vala_source_file_set_cycle (ValaSourceFile* self, ValaSourceFileCycle* value);
gboolean vala_source_file_get_is_cycle_head (ValaSourceFile* self);
void vala_source_file_set_is_cycle_head (ValaSourceFile* self, gboolean value);
gint vala_source_file_get_mark (ValaSourceFile* self);
void vala_source_file_set_mark (ValaSourceFile* self, gint value);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
void vala_source_file_set_context (ValaSourceFile* self, ValaCodeContext* value);
const char* vala_source_file_get_content (ValaSourceFile* self);
void vala_source_file_set_content (ValaSourceFile* self, const char* value);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_source_file (const GValue* value);
void vala_value_set_source_file (GValue* value, gpointer v_object);
GType vala_source_file_get_type (void);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GType vala_source_file_dependency_type_get_type (void);


G_END_DECLS

#endif
