/* valaconstructor.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACONSTRUCTOR_H__
#define __VALA_VALACONSTRUCTOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valasymbol.h>
#include <vala/valamember.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructorPrivate ValaConstructorPrivate;

/**
 * Represents a class or instance constructor.
 */
struct _ValaConstructor {
	ValaSymbol parent_instance;
	ValaConstructorPrivate * priv;
};

struct _ValaConstructorClass {
	ValaSymbolClass parent_class;
};


ValaConstructor* vala_constructor_construct (GType object_type, ValaSourceReference* source);
ValaConstructor* vala_constructor_new (ValaSourceReference* source);
ValaBlock* vala_constructor_get_body (ValaConstructor* self);
void vala_constructor_set_body (ValaConstructor* self, ValaBlock* value);
ValaFormalParameter* vala_constructor_get_this_parameter (ValaConstructor* self);
void vala_constructor_set_this_parameter (ValaConstructor* self, ValaFormalParameter* value);
MemberBinding vala_constructor_get_binding (ValaConstructor* self);
void vala_constructor_set_binding (ValaConstructor* self, MemberBinding value);
GType vala_constructor_get_type (void);


G_END_DECLS

#endif
