/* valaccodemethodmodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodmodule.h>
#include <float.h>
#include <math.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valatypesymbol.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valainterface.h>
#include <vala/valastructvaluetype.h>
#include <vala/valaenum.h>
#include <vala/valaenumvaluetype.h>
#include <vala/valaclasstype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valatypeparameter.h>
#include <vala/valaattribute.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <gee/collection.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valatrystatement.h>
#include <gee/hashmap.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valalocalvariable.h>
#include <vala/valamemberaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodelabel.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valareferencetype.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecomment.h>
#include <vala/valaintegertype.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <vala/valacodecontext.h>
#include <vala/valastatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaccodedeclarationspace.h>




enum  {
	VALA_CCODE_METHOD_MODULE_DUMMY_PROPERTY
};
static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method);
static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m);
static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value);
static gboolean vala_ccode_method_module_is_gtypeinstance_creation_method (ValaCCodeMethodModule* self, ValaMethod* m);
static void vala_ccode_method_module_real_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_ccode_method_module_real_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, GeeMap* cparam_map, GeeMap* carg_map);
static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition);
static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym);
static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params);
static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m);
static gpointer vala_ccode_method_module_parent_class = NULL;



ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodModule*) vala_ccode_struct_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_module_construct (VALA_TYPE_CCODE_METHOD_MODULE, codegen, next);
}


static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method) {
	ValaCCodeMethodModule * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (method != NULL, FALSE);
	_tmp0 = NULL;
	return (_tmp1 = (_tmp0 = vala_code_node_get_attribute ((ValaCodeNode*) method, "NoWrapper")) == NULL, (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)), _tmp1);
}


static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaAttribute* attr;
	char* _tmp1;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (m != NULL, NULL);
	attr = vala_code_node_get_attribute ((ValaCodeNode*) m, "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = type, (attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL)), _tmp0);
		}
		type = (g_free (type), NULL);
	}
	_tmp1 = NULL;
	return (_tmp1 = NULL, (attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL)), _tmp1);
}


static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value) {
	char* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, m);
	if (type == NULL) {
		const char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (_tmp0 = default_value, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), type = (g_free (type), NULL), _tmp1);
	}
	return type;
}


static gboolean vala_ccode_method_module_is_gtypeinstance_creation_method (ValaCCodeMethodModule* self, ValaMethod* m) {
	gboolean result;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	gboolean _tmp3;
	gboolean _tmp4;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	result = FALSE;
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		_tmp3 = cl != NULL;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = !vala_class_get_is_compact (cl);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		result = TRUE;
	}
	return (_tmp4 = result, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
}


static void vala_ccode_method_module_real_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaDataType* _tmp0;
	ValaDataType* creturn_type;
	char* _tmp5;
	char* _tmp4;
	gboolean _tmp6;
	GeeList* _tmp16;
	gboolean _tmp17;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (cfunc != NULL);
	g_return_if_fail (cparam_map != NULL);
	_tmp0 = NULL;
	creturn_type = (_tmp0 = vala_method_get_return_type (m), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp2;
		ValaTypeSymbol* _tmp1;
		ValaClass* cl;
		_tmp2 = NULL;
		_tmp1 = NULL;
		cl = (_tmp2 = (_tmp1 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_CLASS (_tmp1) ? ((ValaClass*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		if (cl != NULL) {
			ValaDataType* _tmp3;
			/* object creation methods return the new object in C
			 in Vala they have no return type*/
			_tmp3 = NULL;
			creturn_type = (_tmp3 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) cl), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp3);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_set_return_type (cfunc, _tmp5 = vala_ccode_method_module_get_creturn_type (self, m, _tmp4 = vala_data_type_get_cname (creturn_type)));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp6 = FALSE;
	if (!vala_method_get_no_array_length (m)) {
		_tmp6 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp6 = FALSE;
	}
	if (_tmp6) {
		ValaArrayType* _tmp7;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp7 = NULL;
		array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp8;
				ValaCCodeFormalParameter* _tmp9;
				ValaCCodeFormalParameter* cparam;
				_tmp8 = NULL;
				_tmp9 = NULL;
				cparam = (_tmp9 = vala_ccode_formal_parameter_new (_tmp8 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp8 = (g_free (_tmp8), NULL), _tmp9);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp10;
					_tmp10 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
				}
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp11;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp12;
			ValaDelegate* d;
			/* return delegate target if appropriate*/
			_tmp11 = NULL;
			deleg_type = (_tmp11 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11));
			_tmp12 = NULL;
			d = (_tmp12 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp13;
				ValaCCodeFormalParameter* _tmp14;
				ValaCCodeFormalParameter* cparam;
				_tmp13 = NULL;
				_tmp14 = NULL;
				cparam = (_tmp14 = vala_ccode_formal_parameter_new (_tmp13 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void*"), _tmp13 = (g_free (_tmp13), NULL), _tmp14);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp15;
					_tmp15 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
				}
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp16 = NULL;
	if ((_tmp17 = gee_collection_get_size ((GeeCollection*) (_tmp16 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp16 == NULL) ? NULL : (_tmp16 = (gee_collection_object_unref (_tmp16), NULL)), _tmp17)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
		if (carg_map != NULL) {
			ValaCCodeIdentifier* _tmp18;
			_tmp18 = NULL;
			gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		}
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
}


void vala_ccode_method_module_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map) {
	VALA_CCODE_METHOD_MODULE_GET_CLASS (self)->generate_method_result_declaration (self, m, cfunc, cparam_map, carg_map);
}


ValaCCodeStatement* vala_ccode_method_module_complete_async (ValaCCodeMethodModule* self) {
	ValaCCodeBlock* complete_block;
	ValaCCodeBlock* direct_block;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* direct_call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeMemberAccess* _tmp3;
	ValaCCodeMemberAccess* async_result_expr;
	ValaCCodeExpressionStatement* _tmp4;
	ValaCCodeBlock* idle_block;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* idle_call;
	ValaCCodeExpressionStatement* _tmp7;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeMemberAccess* state;
	ValaCCodeConstant* zero;
	ValaCCodeBinaryExpression* state_is_zero;
	ValaCCodeIfStatement* dispatch;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* unref;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeReturnStatement* _tmp14;
	ValaCCodeConstant* _tmp13;
	ValaCCodeStatement* _tmp15;
	g_return_val_if_fail (self != NULL, NULL);
	complete_block = vala_ccode_block_new ();
	direct_block = vala_ccode_block_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	direct_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_simple_async_result_complete"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	async_result_expr = (_tmp3 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("data")), "_async_result"), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	vala_ccode_function_call_add_argument (direct_call, (ValaCCodeExpression*) async_result_expr);
	_tmp4 = NULL;
	vala_ccode_block_add_statement (direct_block, (ValaCCodeNode*) (_tmp4 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) direct_call)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	idle_block = vala_ccode_block_new ();
	_tmp5 = NULL;
	_tmp6 = NULL;
	idle_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("g_simple_async_result_complete_in_idle"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) async_result_expr);
	_tmp7 = NULL;
	vala_ccode_block_add_statement (idle_block, (ValaCCodeNode*) (_tmp7 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) idle_call)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp8 = NULL;
	_tmp9 = NULL;
	state = (_tmp9 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("data")), "state"), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9);
	zero = vala_ccode_constant_new ("0");
	state_is_zero = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) state, (ValaCCodeExpression*) zero);
	dispatch = vala_ccode_if_statement_new ((ValaCCodeExpression*) state_is_zero, (ValaCCodeStatement*) idle_block, (ValaCCodeStatement*) direct_block);
	vala_ccode_block_add_statement (complete_block, (ValaCCodeNode*) dispatch);
	_tmp10 = NULL;
	_tmp11 = NULL;
	unref = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_object_unref"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	vala_ccode_function_call_add_argument (unref, (ValaCCodeExpression*) async_result_expr);
	_tmp12 = NULL;
	vala_ccode_block_add_statement (complete_block, (ValaCCodeNode*) (_tmp12 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) unref)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_block_add_statement (complete_block, (ValaCCodeNode*) (_tmp14 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new ("FALSE")))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp15 = NULL;
	return (_tmp15 = (ValaCCodeStatement*) complete_block, (direct_block == NULL) ? NULL : (direct_block = (vala_ccode_node_unref (direct_block), NULL)), (direct_call == NULL) ? NULL : (direct_call = (vala_ccode_node_unref (direct_call), NULL)), (async_result_expr == NULL) ? NULL : (async_result_expr = (vala_ccode_node_unref (async_result_expr), NULL)), (idle_block == NULL) ? NULL : (idle_block = (vala_ccode_node_unref (idle_block), NULL)), (idle_call == NULL) ? NULL : (idle_call = (vala_ccode_node_unref (idle_call), NULL)), (state == NULL) ? NULL : (state = (vala_ccode_node_unref (state), NULL)), (zero == NULL) ? NULL : (zero = (vala_ccode_node_unref (zero), NULL)), (state_is_zero == NULL) ? NULL : (state_is_zero = (vala_ccode_node_unref (state_is_zero), NULL)), (dispatch == NULL) ? NULL : (dispatch = (vala_ccode_node_unref (dispatch), NULL)), (unref == NULL) ? NULL : (unref = (vala_ccode_node_unref (unref), NULL)), _tmp15);
}


static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* old_type_symbol;
	ValaSymbol* _tmp1;
	ValaSymbol* old_symbol;
	ValaMethod* _tmp2;
	ValaMethod* old_method;
	ValaDataType* _tmp3;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gboolean old_in_creation_method;
	gint old_next_temp_var_id;
	GeeMap* _tmp4;
	GeeMap* old_variable_name_map;
	ValaTryStatement* _tmp5;
	ValaTryStatement* old_try;
	ValaSymbol* _tmp9;
	ValaSymbol* _tmp8;
	ValaMethod* _tmp11;
	ValaMethod* _tmp10;
	ValaDataType* _tmp13;
	ValaDataType* _tmp12;
	GeeMap* _tmp14;
	ValaTryStatement* _tmp15;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp19;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaTypeSymbol* _tmp48;
	ValaTypeSymbol* _tmp47;
	ValaSymbol* _tmp50;
	ValaSymbol* _tmp49;
	ValaMethod* _tmp52;
	ValaMethod* _tmp51;
	ValaDataType* _tmp54;
	ValaDataType* _tmp53;
	GeeMap* _tmp56;
	GeeMap* _tmp55;
	ValaTryStatement* _tmp58;
	ValaTryStatement* _tmp57;
	ValaCCodeFunction* _tmp60;
	char* _tmp59;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean _tmp61;
	gboolean _tmp62;
	gboolean visible;
	gboolean _tmp67;
	gboolean _tmp238;
	gboolean _tmp239;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	old_symbol = (_tmp1 = ((ValaCCodeBaseModule*) self)->current_symbol, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	old_method = (_tmp2 = ((ValaCCodeBaseModule*) self)->current_method, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	old_return_type = (_tmp3 = ((ValaCCodeBaseModule*) self)->current_return_type, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	old_method_inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	old_in_creation_method = ((ValaCCodeBaseModule*) self)->in_creation_method;
	old_next_temp_var_id = ((ValaCCodeBaseModule*) self)->next_temp_var_id;
	_tmp4 = NULL;
	old_variable_name_map = (_tmp4 = ((ValaCCodeBaseModule*) self)->variable_name_map, (_tmp4 == NULL) ? NULL : gee_collection_object_ref (_tmp4));
	_tmp5 = NULL;
	old_try = (_tmp5 = ((ValaCCodeBaseModule*) self)->current_try, (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	if (VALA_IS_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		ValaTypeSymbol* _tmp7;
		ValaTypeSymbol* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp7 = (_tmp6 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp7);
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp9 = (_tmp8 = (ValaSymbol*) m, (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	((ValaCCodeBaseModule*) self)->current_method = (_tmp11 = (_tmp10 = m, (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	((ValaCCodeBaseModule*) self)->current_return_type = (_tmp13 = (_tmp12 = vala_method_get_return_type (m), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12)), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp13);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = 0;
	_tmp14 = NULL;
	((ValaCCodeBaseModule*) self)->variable_name_map = (_tmp14 = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), (((ValaCCodeBaseModule*) self)->variable_name_map == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->variable_name_map = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->variable_name_map), NULL)), _tmp14);
	_tmp15 = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp15 = NULL, (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp15);
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	vala_ccode_base_module_check_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp17;
		ValaTypeSymbol* _tmp16;
		ValaClass* cl;
		gboolean _tmp18;
		((ValaCCodeBaseModule*) self)->in_creation_method = TRUE;
		_tmp17 = NULL;
		_tmp16 = NULL;
		cl = (_tmp17 = (_tmp16 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_CLASS (_tmp16) ? ((ValaClass*) _tmp16) : NULL), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
		_tmp18 = FALSE;
		if (cl != NULL) {
			_tmp18 = !vala_class_get_is_compact (cl);
		} else {
			_tmp18 = FALSE;
		}
		if (_tmp18) {
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		((ValaCCodeBaseModule*) self)->in_creation_method = FALSE;
	}
	_tmp19 = NULL;
	creturn_type = (_tmp19 = ((ValaCCodeBaseModule*) self)->current_return_type, (_tmp19 == NULL) ? NULL : vala_code_node_ref (_tmp19));
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_CREATION_METHOD (m)) {
		gboolean _tmp20;
		_tmp20 = FALSE;
		if (in_gobject_creation_method) {
			_tmp20 = vala_method_get_body (m) != NULL;
		} else {
			_tmp20 = FALSE;
		}
		if (_tmp20) {
			ValaCCodeBlock* cblock;
			cblock = vala_ccode_block_new ();
			if (!vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m))) {
				gboolean _tmp28;
				/* set construct properties*/
				{
					GeeList* _tmp21;
					GeeIterator* _tmp22;
					GeeIterator* _stmt_it;
					/* set construct properties*/
					_tmp21 = NULL;
					_tmp22 = NULL;
					_stmt_it = (_tmp22 = gee_iterable_iterator ((GeeIterable*) (_tmp21 = vala_block_get_statements (vala_method_get_body (m)))), (_tmp21 == NULL) ? NULL : (_tmp21 = (gee_collection_object_unref (_tmp21), NULL)), _tmp22);
					/* set construct properties*/
					while (gee_iterator_next (_stmt_it)) {
						ValaCodeNode* stmt;
						ValaExpressionStatement* _tmp24;
						ValaCodeNode* _tmp23;
						ValaExpressionStatement* expr_stmt;
						/* set construct properties*/
						stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
						_tmp24 = NULL;
						_tmp23 = NULL;
						expr_stmt = (_tmp24 = (_tmp23 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp23) ? ((ValaExpressionStatement*) _tmp23) : NULL), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
						if (expr_stmt != NULL) {
							ValaProperty* prop;
							gboolean _tmp25;
							prop = vala_expression_statement_assigned_property (expr_stmt);
							_tmp25 = FALSE;
							if (prop != NULL) {
								_tmp25 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
							} else {
								_tmp25 = FALSE;
							}
							if (_tmp25) {
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
									{
										GeeList* _tmp26;
										GeeIterator* _tmp27;
										GeeIterator* _cstmt_it;
										_tmp26 = NULL;
										_tmp27 = NULL;
										_cstmt_it = (_tmp27 = gee_iterable_iterator ((GeeIterable*) (_tmp26 = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))))), (_tmp26 == NULL) ? NULL : (_tmp26 = (gee_collection_object_unref (_tmp26), NULL)), _tmp27);
										while (gee_iterator_next (_cstmt_it)) {
											ValaCCodeNode* cstmt;
											cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
										}
										(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
									}
								} else {
									vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
								}
							}
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						}
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
					}
					(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
				}
				_tmp28 = FALSE;
				if (vala_creation_method_get_n_construction_params (VALA_CREATION_METHOD (m)) > 0) {
					_tmp28 = TRUE;
				} else {
					GeeList* _tmp29;
					_tmp29 = NULL;
					_tmp28 = gee_collection_get_size ((GeeCollection*) (_tmp29 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
					(_tmp29 == NULL) ? NULL : (_tmp29 = (gee_collection_object_unref (_tmp29), NULL));
				}
				vala_ccode_method_module_add_object_creation (self, cblock, _tmp28);
			} else {
				char* _tmp31;
				char* _tmp30;
				ValaCCodeDeclaration* _tmp32;
				ValaCCodeDeclaration* cdeclaration;
				ValaCCodeVariableDeclarator* _tmp33;
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp32 = NULL;
				cdeclaration = (_tmp32 = vala_ccode_declaration_new (_tmp31 = g_strdup_printf ("%s *", _tmp30 = vala_typesymbol_get_cname ((ValaTypeSymbol*) VALA_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol), FALSE))), _tmp31 = (g_free (_tmp31), NULL), _tmp30 = (g_free (_tmp30), NULL), _tmp32);
				_tmp33 = NULL;
				vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) (_tmp33 = vala_ccode_variable_declarator_new ("self", NULL)));
				(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdeclaration);
				(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
			}
			/* other initialization code*/
			{
				GeeList* _tmp34;
				GeeIterator* _tmp35;
				GeeIterator* _stmt_it;
				/* other initialization code*/
				_tmp34 = NULL;
				_tmp35 = NULL;
				_stmt_it = (_tmp35 = gee_iterable_iterator ((GeeIterable*) (_tmp34 = vala_block_get_statements (vala_method_get_body (m)))), (_tmp34 == NULL) ? NULL : (_tmp34 = (gee_collection_object_unref (_tmp34), NULL)), _tmp35);
				/* other initialization code*/
				while (gee_iterator_next (_stmt_it)) {
					ValaCodeNode* stmt;
					ValaExpressionStatement* _tmp37;
					ValaCodeNode* _tmp36;
					ValaExpressionStatement* expr_stmt;
					/* other initialization code*/
					stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
					_tmp37 = NULL;
					_tmp36 = NULL;
					expr_stmt = (_tmp37 = (_tmp36 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp36) ? ((ValaExpressionStatement*) _tmp36) : NULL), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
					if (expr_stmt != NULL) {
						ValaProperty* prop;
						gboolean _tmp38;
						prop = vala_expression_statement_assigned_property (expr_stmt);
						_tmp38 = FALSE;
						if (prop != NULL) {
							_tmp38 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
						} else {
							_tmp38 = FALSE;
						}
						if (_tmp38) {
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
							continue;
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					}
					if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
						{
							GeeList* _tmp39;
							GeeIterator* _tmp40;
							GeeIterator* _cstmt_it;
							_tmp39 = NULL;
							_tmp40 = NULL;
							_cstmt_it = (_tmp40 = gee_iterable_iterator ((GeeIterable*) (_tmp39 = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))))), (_tmp39 == NULL) ? NULL : (_tmp39 = (gee_collection_object_unref (_tmp39), NULL)), _tmp40);
							while (gee_iterator_next (_cstmt_it)) {
								ValaCCodeNode* cstmt;
								cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
							}
							(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
						}
					} else {
						vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
					}
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
				}
				(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
			}
			{
				GeeList* _tmp41;
				GeeIterator* _tmp42;
				GeeIterator* _local_it;
				_tmp41 = NULL;
				_tmp42 = NULL;
				_local_it = (_tmp42 = gee_iterable_iterator ((GeeIterable*) (_tmp41 = vala_block_get_local_variables (vala_method_get_body (m)))), (_tmp41 == NULL) ? NULL : (_tmp41 = (gee_collection_object_unref (_tmp41), NULL)), _tmp42);
				while (gee_iterator_next (_local_it)) {
					ValaLocalVariable* local;
					gboolean _tmp43;
					local = (ValaLocalVariable*) gee_iterator_get (_local_it);
					_tmp43 = FALSE;
					if (!vala_local_variable_get_floating (local)) {
						_tmp43 = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_local_variable_get_variable_type (local));
					} else {
						_tmp43 = FALSE;
					}
					if (_tmp43) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* _tmp46;
						ValaCCodeExpression* _tmp45;
						ValaCCodeExpression* _tmp44;
						ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
						vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
						_tmp46 = NULL;
						_tmp45 = NULL;
						_tmp44 = NULL;
						vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp46 = vala_ccode_expression_statement_new (_tmp45 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, _tmp44 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
						(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
						(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
						(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
						(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
					}
					(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
				}
				(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
			}
			vala_code_node_set_ccodenode ((ValaCodeNode*) vala_method_get_body (m), (ValaCCodeNode*) cblock);
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		}
		((ValaCCodeBaseModule*) self)->in_creation_method = old_in_creation_method;
	}
	inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	_tmp48 = NULL;
	_tmp47 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp48 = (_tmp47 = old_type_symbol, (_tmp47 == NULL) ? NULL : vala_code_node_ref (_tmp47)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp48);
	_tmp50 = NULL;
	_tmp49 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp50 = (_tmp49 = old_symbol, (_tmp49 == NULL) ? NULL : vala_code_node_ref (_tmp49)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp50);
	_tmp52 = NULL;
	_tmp51 = NULL;
	((ValaCCodeBaseModule*) self)->current_method = (_tmp52 = (_tmp51 = old_method, (_tmp51 == NULL) ? NULL : vala_code_node_ref (_tmp51)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp52);
	_tmp54 = NULL;
	_tmp53 = NULL;
	((ValaCCodeBaseModule*) self)->current_return_type = (_tmp54 = (_tmp53 = old_return_type, (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53)), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp54);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = old_method_inner_error;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = old_next_temp_var_id;
	_tmp56 = NULL;
	_tmp55 = NULL;
	((ValaCCodeBaseModule*) self)->variable_name_map = (_tmp56 = (_tmp55 = old_variable_name_map, (_tmp55 == NULL) ? NULL : gee_collection_object_ref (_tmp55)), (((ValaCCodeBaseModule*) self)->variable_name_map == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->variable_name_map = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->variable_name_map), NULL)), _tmp56);
	_tmp58 = NULL;
	_tmp57 = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp58 = (_tmp57 = old_try, (_tmp57 == NULL) ? NULL : vala_code_node_ref (_tmp57)), (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp58);
	_tmp60 = NULL;
	_tmp59 = NULL;
	((ValaCCodeBaseModule*) self)->function = (_tmp60 = vala_ccode_function_new (_tmp59 = vala_method_get_real_cname (m), "void"), (((ValaCCodeBaseModule*) self)->function == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->function = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->function), NULL)), _tmp60);
	_tmp59 = (g_free (_tmp59), NULL);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | VALA_CCODE_MODIFIERS_INLINE);
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	_tmp61 = FALSE;
	_tmp62 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp62 = TRUE;
	} else {
		_tmp62 = vala_method_get_is_virtual (m);
	}
	if (_tmp62) {
		_tmp61 = !vala_method_get_coroutine (m);
	} else {
		_tmp61 = FALSE;
	}
	if (_tmp61) {
		char* _tmp64;
		char* _tmp63;
		ValaCCodeDeclaration* _tmp65;
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp66;
		_tmp64 = NULL;
		_tmp63 = NULL;
		_tmp65 = NULL;
		vdecl = (_tmp65 = vala_ccode_declaration_new (_tmp64 = vala_ccode_method_module_get_creturn_type (self, m, _tmp63 = vala_data_type_get_cname (creturn_type))), _tmp64 = (g_free (_tmp64), NULL), _tmp63 = (g_free (_tmp63), NULL), _tmp65);
		_tmp66 = NULL;
		vdeclarator = (_tmp66 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp66);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, (GeeMap*) cparam_map, ((ValaCCodeBaseModule*) self)->function, vdeclarator, NULL, NULL, 3);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp67 = FALSE;
	if (!vala_method_get_is_abstract (m)) {
		_tmp67 = TRUE;
	} else {
		gboolean _tmp68;
		_tmp68 = FALSE;
		if (vala_method_get_is_abstract (m)) {
			_tmp68 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
		} else {
			_tmp68 = FALSE;
		}
		_tmp67 = _tmp68;
	}
	/* generate *_real_* functions for virtual methods
	 also generate them for abstract methods of classes to prevent faulty subclassing*/
	if (_tmp67) {
		gboolean _tmp69;
		gboolean _tmp70;
		_tmp69 = FALSE;
		_tmp70 = FALSE;
		if (visible) {
			_tmp70 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp70 = FALSE;
		}
		if (_tmp70) {
			_tmp69 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp69 = FALSE;
		}
		if (_tmp69) {
			ValaCCodeFunction* _tmp71;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp71 = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->header_declarations, (ValaCCodeNode*) (_tmp71 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
			(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
		} else {
			ValaCCodeFunction* _tmp72;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | VALA_CCODE_MODIFIERS_STATIC);
			_tmp72 = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp72 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
			(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			gboolean _tmp92;
			gboolean _tmp222;
			vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_get_body (m))));
			vala_ccode_node_set_line ((ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) cinit);
			if (vala_method_get_coroutine (m)) {
				char* _tmp74;
				char* _tmp73;
				ValaCCodeFunction* _tmp75;
				ValaCCodeFunction* co_function;
				ValaCCodeFormalParameter* _tmp79;
				char* _tmp78;
				char* _tmp77;
				char* _tmp76;
				ValaCCodeFunction* _tmp80;
				ValaCCodeMemberAccess* _tmp82;
				ValaCCodeIdentifier* _tmp81;
				ValaCCodeSwitchStatement* _tmp83;
				ValaCCodeSwitchStatement* cswitch;
				ValaCCodeLabel* _tmp84;
				ValaCCodeExpressionStatement* _tmp87;
				ValaCCodeFunctionCall* _tmp86;
				ValaCCodeIdentifier* _tmp85;
				ValaCCodeCaseStatement* _tmp89;
				ValaCCodeConstant* _tmp88;
				ValaCCodeStatement* _tmp90;
				ValaCCodeBlock* _tmp91;
				_tmp74 = NULL;
				_tmp73 = NULL;
				_tmp75 = NULL;
				co_function = (_tmp75 = vala_ccode_function_new (_tmp74 = g_strconcat (_tmp73 = vala_method_get_real_cname (m), "_co", NULL), "gboolean"), _tmp74 = (g_free (_tmp74), NULL), _tmp73 = (g_free (_tmp73), NULL), _tmp75);
				/* data struct to hold parameters, local variables, and the return value*/
				_tmp79 = NULL;
				_tmp78 = NULL;
				_tmp77 = NULL;
				_tmp76 = NULL;
				vala_ccode_function_add_parameter (co_function, _tmp79 = vala_ccode_formal_parameter_new ("data", _tmp78 = g_strconcat (_tmp77 = vala_symbol_lower_case_to_camel_case (_tmp76 = vala_method_get_cname (m)), "Data*", NULL)));
				(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
				_tmp78 = (g_free (_tmp78), NULL);
				_tmp77 = (g_free (_tmp77), NULL);
				_tmp76 = (g_free (_tmp76), NULL);
				vala_ccode_function_set_modifiers (co_function, vala_ccode_function_get_modifiers (co_function) | VALA_CCODE_MODIFIERS_STATIC);
				_tmp80 = NULL;
				vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp80 = vala_ccode_function_copy (co_function)));
				(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
				_tmp82 = NULL;
				_tmp81 = NULL;
				_tmp83 = NULL;
				cswitch = (_tmp83 = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new ("data")), "state"))), (_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)), (_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)), _tmp83);
				/* let gcc know that this can't happen*/
				_tmp84 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp84 = vala_ccode_label_new ("default")));
				(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
				_tmp87 = NULL;
				_tmp86 = NULL;
				_tmp85 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp87 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp86 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("g_assert_not_reached")))))));
				(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
				(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
				(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
				/* initial coroutine state*/
				_tmp89 = NULL;
				_tmp88 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp89 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp88 = vala_ccode_constant_new ("0")))));
				(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
				(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
				/* coroutine body*/
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function));
				/* epilogue*/
				_tmp90 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp90 = vala_ccode_method_module_complete_async (self)));
				(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
				_tmp91 = NULL;
				vala_ccode_function_set_block (co_function, _tmp91 = vala_ccode_block_new ());
				(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
				vala_ccode_block_add_statement (vala_ccode_function_get_block (co_function), (ValaCCodeNode*) cswitch);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) co_function);
				(co_function == NULL) ? NULL : (co_function = (vala_ccode_node_unref (co_function), NULL));
				(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
			}
			_tmp92 = FALSE;
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
				_tmp92 = !vala_method_get_coroutine (m);
			} else {
				_tmp92 = FALSE;
			}
			if (_tmp92) {
				ValaClass* _tmp93;
				ValaClass* cl;
				gboolean _tmp94;
				_tmp93 = NULL;
				cl = (_tmp93 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp93 == NULL) ? NULL : vala_code_node_ref (_tmp93));
				_tmp94 = FALSE;
				if (vala_method_get_overrides (m)) {
					_tmp94 = TRUE;
				} else {
					gboolean _tmp95;
					gboolean _tmp96;
					_tmp95 = FALSE;
					_tmp96 = FALSE;
					if (vala_method_get_base_interface_method (m) != NULL) {
						_tmp96 = !vala_method_get_is_abstract (m);
					} else {
						_tmp96 = FALSE;
					}
					if (_tmp96) {
						_tmp95 = !vala_method_get_is_virtual (m);
					} else {
						_tmp95 = FALSE;
					}
					_tmp94 = _tmp95;
				}
				if (_tmp94) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaObjectType* self_target_type;
					ValaCCodeIdentifier* _tmp103;
					ValaCCodeExpression* _tmp104;
					ValaCCodeExpression* cself;
					char* _tmp106;
					char* _tmp105;
					ValaCCodeDeclaration* _tmp107;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp108;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp98;
						ValaMethod* _tmp97;
						ValaReferenceType* _tmp99;
						_tmp98 = NULL;
						_tmp97 = NULL;
						base_method = (_tmp98 = (_tmp97 = vala_method_get_base_method (m), (_tmp97 == NULL) ? NULL : vala_code_node_ref (_tmp97)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp98);
						_tmp99 = NULL;
						base_expression_type = (_tmp99 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), (base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)), _tmp99);
					} else {
						ValaMethod* _tmp101;
						ValaMethod* _tmp100;
						ValaReferenceType* _tmp102;
						_tmp101 = NULL;
						_tmp100 = NULL;
						base_method = (_tmp101 = (_tmp100 = vala_method_get_base_interface_method (m), (_tmp100 == NULL) ? NULL : vala_code_node_ref (_tmp100)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp101);
						_tmp102 = NULL;
						base_expression_type = (_tmp102 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), (base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)), _tmp102);
					}
					self_target_type = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp103 = NULL;
					_tmp104 = NULL;
					cself = (_tmp104 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp103 = vala_ccode_identifier_new ("base")), (ValaDataType*) base_expression_type, (ValaDataType*) self_target_type, NULL), (_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)), _tmp104);
					_tmp106 = NULL;
					_tmp105 = NULL;
					_tmp107 = NULL;
					cdecl_ = (_tmp107 = vala_ccode_declaration_new (_tmp106 = g_strdup_printf ("%s *", _tmp105 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp106 = (g_free (_tmp106), NULL), _tmp105 = (g_free (_tmp105), NULL), _tmp107);
					_tmp108 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp108 = vala_ccode_variable_declarator_new ("self", cself)));
					(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					(base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL));
					(self_target_type == NULL) ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL));
					(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				} else {
					gboolean _tmp109;
					_tmp109 = FALSE;
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
						_tmp109 = !VALA_IS_CREATION_METHOD (m);
					} else {
						_tmp109 = FALSE;
					}
					if (_tmp109) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, (ValaTypeSymbol*) cl, TRUE, "self");
						if (ccheckstmt != NULL) {
							vala_ccode_node_set_line ((ValaCCodeNode*) ccheckstmt, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ccheckstmt);
						}
						(ccheckstmt == NULL) ? NULL : (ccheckstmt = (vala_ccode_node_unref (ccheckstmt), NULL));
					}
				}
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
			{
				GeeList* _tmp110;
				GeeIterator* _tmp111;
				GeeIterator* _param_it;
				_tmp110 = NULL;
				_tmp111 = NULL;
				_param_it = (_tmp111 = gee_iterable_iterator ((GeeIterable*) (_tmp110 = vala_method_get_parameters (m))), (_tmp110 == NULL) ? NULL : (_tmp110 = (gee_collection_object_unref (_tmp110), NULL)), _tmp111);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					ValaTypeSymbol* _tmp112;
					ValaTypeSymbol* t;
					gboolean _tmp113;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					if (vala_formal_parameter_get_ellipsis (param)) {
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						break;
					}
					_tmp112 = NULL;
					t = (_tmp112 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), (_tmp112 == NULL) ? NULL : vala_code_node_ref (_tmp112));
					_tmp113 = FALSE;
					if (t != NULL) {
						_tmp113 = vala_typesymbol_is_reference_type (t);
					} else {
						_tmp113 = FALSE;
					}
					if (_tmp113) {
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
							ValaCCodeStatement* type_check;
							type_check = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, t, !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param)), vala_symbol_get_name ((ValaSymbol*) param));
							if (type_check != NULL) {
								vala_ccode_node_set_line ((ValaCCodeNode*) type_check, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) type_check);
							}
							(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
						} else {
							ValaCCodeConstant* _tmp116;
							ValaCCodeUnaryExpression* _tmp115;
							ValaCCodeIdentifier* _tmp114;
							ValaCCodeAssignment* _tmp117;
							ValaCCodeAssignment* a;
							ValaCCodeExpressionStatement* _tmp118;
							/* ensure that the passed reference for output parameter is cleared*/
							_tmp116 = NULL;
							_tmp115 = NULL;
							_tmp114 = NULL;
							_tmp117 = NULL;
							a = (_tmp117 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp115 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))), (ValaCCodeExpression*) (_tmp116 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)), (_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL)), (_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL)), _tmp117);
							_tmp118 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp118 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) a)));
							(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
							(a == NULL) ? NULL : (a = (vala_ccode_node_unref (a), NULL));
						}
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			if (inner_error) {
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				if (vala_method_get_coroutine (m)) {
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GError *", "inner_error");
				} else {
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp120;
					ValaCCodeConstant* _tmp119;
					/* no initialization necessary, closure struct is zeroed*/
					cdecl_ = vala_ccode_declaration_new ("GError *");
					_tmp120 = NULL;
					_tmp119 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp120 = vala_ccode_variable_declarator_new ("inner_error", (ValaCCodeExpression*) (_tmp119 = vala_ccode_constant_new ("NULL")))));
					(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
					(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				}
			}
			if (!vala_method_get_coroutine (m)) {
				gboolean _tmp121;
				_tmp121 = FALSE;
				if (vala_code_node_get_source_reference ((ValaCodeNode*) m) != NULL) {
					_tmp121 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)) != NULL;
				} else {
					_tmp121 = FALSE;
				}
				if (_tmp121) {
					ValaCCodeComment* _tmp122;
					_tmp122 = NULL;
					vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp122 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)))));
					(_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL));
				}
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
			}
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					gboolean _tmp123;
					n_params = vala_creation_method_get_n_construction_params (VALA_CREATION_METHOD (m));
					_tmp123 = FALSE;
					if (n_params > 0) {
						_tmp123 = TRUE;
					} else {
						GeeList* _tmp124;
						_tmp124 = NULL;
						_tmp123 = gee_collection_get_size ((GeeCollection*) (_tmp124 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
						(_tmp124 == NULL) ? NULL : (_tmp124 = (gee_collection_object_unref (_tmp124), NULL));
					}
					if (_tmp123) {
						ValaCCodeIdentifier* _tmp125;
						ValaCCodeFunctionCall* _tmp126;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp127;
						ValaCCodeConstant* _tmp130;
						char* _tmp129;
						GeeList* _tmp128;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp131;
						ValaCCodeDeclaration* _tmp132;
						ValaCCodeVariableDeclarator* _tmp134;
						ValaCCodeIdentifier* _tmp133;
						/* declare construction parameter array*/
						_tmp125 = NULL;
						_tmp126 = NULL;
						cparamsinit = (_tmp126 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp125 = vala_ccode_identifier_new ("g_new0"))), (_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL)), _tmp126);
						_tmp127 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp127 = vala_ccode_identifier_new ("GParameter")));
						(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL));
						_tmp130 = NULL;
						_tmp129 = NULL;
						_tmp128 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp130 = vala_ccode_constant_new (_tmp129 = g_strdup_printf ("%i", n_params + (3 * gee_collection_get_size ((GeeCollection*) (_tmp128 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))))))));
						(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
						_tmp129 = (g_free (_tmp129), NULL);
						(_tmp128 == NULL) ? NULL : (_tmp128 = (gee_collection_object_unref (_tmp128), NULL));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp131 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp131 = vala_ccode_variable_declarator_new ("__params", (ValaCCodeExpression*) cparamsinit)));
						(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
						_tmp132 = NULL;
						cdecl_ = (_tmp132 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp132);
						_tmp134 = NULL;
						_tmp133 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp134 = vala_ccode_variable_declarator_new ("__params_it", (ValaCCodeExpression*) (_tmp133 = vala_ccode_identifier_new ("__params")))));
						(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
						(_tmp133 == NULL) ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
						(cparamsinit == NULL) ? NULL : (cparamsinit = (vala_ccode_node_unref (cparamsinit), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeList* _tmp135;
						GeeIterator* _tmp136;
						GeeIterator* _type_param_it;
						/* type, dup func, and destroy func properties for generic types */
						_tmp135 = NULL;
						_tmp136 = NULL;
						_type_param_it = (_tmp136 = gee_iterable_iterator ((GeeIterable*) (_tmp135 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp135 == NULL) ? NULL : (_tmp135 = (gee_collection_object_unref (_tmp135), NULL)), _tmp136);
						/* type, dup func, and destroy func properties for generic types */
						while (gee_iterator_next (_type_param_it)) {
							ValaTypeParameter* type_param;
							ValaCCodeConstant* prop_name;
							ValaCCodeIdentifier* param_name;
							ValaCCodeConstant* _tmp139;
							char* _tmp138;
							char* _tmp137;
							ValaCCodeIdentifier* _tmp142;
							char* _tmp141;
							char* _tmp140;
							ValaCCodeExpressionStatement* _tmp145;
							ValaCCodeExpression* _tmp144;
							ValaIntegerType* _tmp143;
							ValaCCodeConstant* _tmp148;
							char* _tmp147;
							char* _tmp146;
							ValaCCodeIdentifier* _tmp151;
							char* _tmp150;
							char* _tmp149;
							ValaCCodeExpressionStatement* _tmp155;
							ValaCCodeExpression* _tmp154;
							ValaPointerType* _tmp153;
							ValaVoidType* _tmp152;
							ValaCCodeConstant* _tmp158;
							char* _tmp157;
							char* _tmp156;
							ValaCCodeIdentifier* _tmp161;
							char* _tmp160;
							char* _tmp159;
							ValaCCodeExpressionStatement* _tmp165;
							ValaCCodeExpression* _tmp164;
							ValaPointerType* _tmp163;
							ValaVoidType* _tmp162;
							/* type, dup func, and destroy func properties for generic types */
							type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
							prop_name = NULL;
							param_name = NULL;
							_tmp139 = NULL;
							_tmp138 = NULL;
							_tmp137 = NULL;
							prop_name = (_tmp139 = vala_ccode_constant_new (_tmp138 = g_strdup_printf ("\"%s-type\"", _tmp137 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp139);
							_tmp138 = (g_free (_tmp138), NULL);
							_tmp137 = (g_free (_tmp137), NULL);
							_tmp142 = NULL;
							_tmp141 = NULL;
							_tmp140 = NULL;
							param_name = (_tmp142 = vala_ccode_identifier_new (_tmp141 = g_strdup_printf ("%s_type", _tmp140 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp142);
							_tmp141 = (g_free (_tmp141), NULL);
							_tmp140 = (g_free (_tmp140), NULL);
							_tmp145 = NULL;
							_tmp144 = NULL;
							_tmp143 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp145 = vala_ccode_expression_statement_new (_tmp144 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp143 = vala_integer_type_new (VALA_STRUCT (((ValaCCodeBaseModule*) self)->gtype_type), NULL, NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
							(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
							(_tmp143 == NULL) ? NULL : (_tmp143 = (vala_code_node_unref (_tmp143), NULL));
							_tmp148 = NULL;
							_tmp147 = NULL;
							_tmp146 = NULL;
							prop_name = (_tmp148 = vala_ccode_constant_new (_tmp147 = g_strdup_printf ("\"%s-dup-func\"", _tmp146 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp148);
							_tmp147 = (g_free (_tmp147), NULL);
							_tmp146 = (g_free (_tmp146), NULL);
							_tmp151 = NULL;
							_tmp150 = NULL;
							_tmp149 = NULL;
							param_name = (_tmp151 = vala_ccode_identifier_new (_tmp150 = g_strdup_printf ("%s_dup_func", _tmp149 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp151);
							_tmp150 = (g_free (_tmp150), NULL);
							_tmp149 = (g_free (_tmp149), NULL);
							_tmp155 = NULL;
							_tmp154 = NULL;
							_tmp153 = NULL;
							_tmp152 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp155 = vala_ccode_expression_statement_new (_tmp154 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp153 = vala_pointer_type_new ((ValaDataType*) (_tmp152 = vala_void_type_new (NULL)), NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp155 == NULL) ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL));
							(_tmp154 == NULL) ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL));
							(_tmp153 == NULL) ? NULL : (_tmp153 = (vala_code_node_unref (_tmp153), NULL));
							(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_code_node_unref (_tmp152), NULL));
							_tmp158 = NULL;
							_tmp157 = NULL;
							_tmp156 = NULL;
							prop_name = (_tmp158 = vala_ccode_constant_new (_tmp157 = g_strdup_printf ("\"%s-destroy-func\"", _tmp156 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp158);
							_tmp157 = (g_free (_tmp157), NULL);
							_tmp156 = (g_free (_tmp156), NULL);
							_tmp161 = NULL;
							_tmp160 = NULL;
							_tmp159 = NULL;
							param_name = (_tmp161 = vala_ccode_identifier_new (_tmp160 = g_strdup_printf ("%s_destroy_func", _tmp159 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp161);
							_tmp160 = (g_free (_tmp160), NULL);
							_tmp159 = (g_free (_tmp159), NULL);
							_tmp165 = NULL;
							_tmp164 = NULL;
							_tmp163 = NULL;
							_tmp162 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp165 = vala_ccode_expression_statement_new (_tmp164 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp163 = vala_pointer_type_new ((ValaDataType*) (_tmp162 = vala_void_type_new (NULL)), NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp165 == NULL) ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL));
							(_tmp164 == NULL) ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL));
							(_tmp163 == NULL) ? NULL : (_tmp163 = (vala_code_node_unref (_tmp163), NULL));
							(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_code_node_unref (_tmp162), NULL));
							(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
							(prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL));
							(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
						}
						(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
					}
				} else {
					if (vala_ccode_method_module_is_gtypeinstance_creation_method (self, m)) {
						ValaClass* _tmp166;
						ValaClass* cl;
						char* _tmp168;
						char* _tmp167;
						ValaCCodeDeclaration* _tmp169;
						ValaCCodeDeclaration* cdeclaration;
						ValaCCodeVariableDeclarator* cdecl_;
						_tmp166 = NULL;
						cl = (_tmp166 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp166 == NULL) ? NULL : vala_code_node_ref (_tmp166));
						_tmp168 = NULL;
						_tmp167 = NULL;
						_tmp169 = NULL;
						cdeclaration = (_tmp169 = vala_ccode_declaration_new (_tmp168 = g_strconcat (_tmp167 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp168 = (g_free (_tmp168), NULL), _tmp167 = (g_free (_tmp167), NULL), _tmp169);
						cdecl_ = vala_ccode_variable_declarator_new ("self", NULL);
						vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) cdecl_);
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdeclaration);
						if (!vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m))) {
							ValaCCodeIdentifier* _tmp170;
							ValaCCodeFunctionCall* _tmp171;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp172;
							ValaCCodeCastExpression* _tmp175;
							char* _tmp174;
							char* _tmp173;
							/* TODO implicitly chain up to base class as in add_object_creation*/
							_tmp170 = NULL;
							_tmp171 = NULL;
							ccall = (_tmp171 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp170 = vala_ccode_identifier_new ("g_type_create_instance"))), (_tmp170 == NULL) ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL)), _tmp171);
							_tmp172 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp172 = vala_ccode_identifier_new ("object_type")));
							(_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL));
							_tmp175 = NULL;
							_tmp174 = NULL;
							_tmp173 = NULL;
							vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) (_tmp175 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp174 = g_strconcat (_tmp173 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL))));
							(_tmp175 == NULL) ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL));
							_tmp174 = (g_free (_tmp174), NULL);
							_tmp173 = (g_free (_tmp173), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						}
						/* type, dup func, and destroy func fields for generic types */
						{
							GeeList* _tmp176;
							GeeIterator* _tmp177;
							GeeIterator* _type_param_it;
							/* type, dup func, and destroy func fields for generic types */
							_tmp176 = NULL;
							_tmp177 = NULL;
							_type_param_it = (_tmp177 = gee_iterable_iterator ((GeeIterable*) (_tmp176 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp176 == NULL) ? NULL : (_tmp176 = (gee_collection_object_unref (_tmp176), NULL)), _tmp177);
							/* type, dup func, and destroy func fields for generic types */
							while (gee_iterator_next (_type_param_it)) {
								ValaTypeParameter* type_param;
								ValaCCodeIdentifier* param_name;
								ValaCCodeAssignment* assign;
								ValaCCodeIdentifier* _tmp178;
								ValaCCodeMemberAccess* _tmp179;
								ValaCCodeMemberAccess* priv_access;
								ValaCCodeIdentifier* _tmp182;
								char* _tmp181;
								char* _tmp180;
								ValaCCodeAssignment* _tmp184;
								ValaCCodeMemberAccess* _tmp183;
								ValaCCodeExpressionStatement* _tmp185;
								ValaCCodeIdentifier* _tmp188;
								char* _tmp187;
								char* _tmp186;
								ValaCCodeAssignment* _tmp190;
								ValaCCodeMemberAccess* _tmp189;
								ValaCCodeExpressionStatement* _tmp191;
								ValaCCodeIdentifier* _tmp194;
								char* _tmp193;
								char* _tmp192;
								ValaCCodeAssignment* _tmp196;
								ValaCCodeMemberAccess* _tmp195;
								ValaCCodeExpressionStatement* _tmp197;
								/* type, dup func, and destroy func fields for generic types */
								type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
								param_name = NULL;
								assign = NULL;
								_tmp178 = NULL;
								_tmp179 = NULL;
								priv_access = (_tmp179 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp178 = vala_ccode_identifier_new ("self")), "priv"), (_tmp178 == NULL) ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)), _tmp179);
								_tmp182 = NULL;
								_tmp181 = NULL;
								_tmp180 = NULL;
								param_name = (_tmp182 = vala_ccode_identifier_new (_tmp181 = g_strdup_printf ("%s_type", _tmp180 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp182);
								_tmp181 = (g_free (_tmp181), NULL);
								_tmp180 = (g_free (_tmp180), NULL);
								_tmp184 = NULL;
								_tmp183 = NULL;
								assign = (_tmp184 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp183 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp184);
								(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
								_tmp185 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp185 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp185 == NULL) ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL));
								_tmp188 = NULL;
								_tmp187 = NULL;
								_tmp186 = NULL;
								param_name = (_tmp188 = vala_ccode_identifier_new (_tmp187 = g_strdup_printf ("%s_dup_func", _tmp186 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp188);
								_tmp187 = (g_free (_tmp187), NULL);
								_tmp186 = (g_free (_tmp186), NULL);
								_tmp190 = NULL;
								_tmp189 = NULL;
								assign = (_tmp190 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp189 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp190);
								(_tmp189 == NULL) ? NULL : (_tmp189 = (vala_ccode_node_unref (_tmp189), NULL));
								_tmp191 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp191 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp191 == NULL) ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL));
								_tmp194 = NULL;
								_tmp193 = NULL;
								_tmp192 = NULL;
								param_name = (_tmp194 = vala_ccode_identifier_new (_tmp193 = g_strdup_printf ("%s_destroy_func", _tmp192 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp194);
								_tmp193 = (g_free (_tmp193), NULL);
								_tmp192 = (g_free (_tmp192), NULL);
								_tmp196 = NULL;
								_tmp195 = NULL;
								assign = (_tmp196 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp195 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp196);
								(_tmp195 == NULL) ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL));
								_tmp197 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp197 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp197 == NULL) ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL));
								(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
								(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
								(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
								(priv_access == NULL) ? NULL : (priv_access = (vala_ccode_node_unref (priv_access), NULL));
							}
							(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					} else {
						if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
							ValaClass* _tmp198;
							ValaClass* cl;
							char* _tmp200;
							char* _tmp199;
							ValaCCodeDeclaration* _tmp201;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeIdentifier* _tmp202;
							ValaCCodeFunctionCall* _tmp203;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp205;
							char* _tmp204;
							ValaCCodeVariableDeclarator* _tmp206;
							ValaCCodeIdentifier* _tmp209;
							char* _tmp208;
							char* _tmp207;
							ValaCCodeFunctionCall* _tmp210;
							ValaCCodeFunctionCall* cinitcall;
							ValaCCodeIdentifier* _tmp211;
							ValaCCodeExpressionStatement* _tmp212;
							_tmp198 = NULL;
							cl = (_tmp198 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp198 == NULL) ? NULL : vala_code_node_ref (_tmp198));
							_tmp200 = NULL;
							_tmp199 = NULL;
							_tmp201 = NULL;
							cdecl_ = (_tmp201 = vala_ccode_declaration_new (_tmp200 = g_strconcat (_tmp199 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp200 = (g_free (_tmp200), NULL), _tmp199 = (g_free (_tmp199), NULL), _tmp201);
							_tmp202 = NULL;
							_tmp203 = NULL;
							ccall = (_tmp203 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp202 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp202 == NULL) ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL)), _tmp203);
							_tmp205 = NULL;
							_tmp204 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp205 = vala_ccode_identifier_new (_tmp204 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
							(_tmp205 == NULL) ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL));
							_tmp204 = (g_free (_tmp204), NULL);
							_tmp206 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp206 = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) ccall)));
							(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
							_tmp209 = NULL;
							_tmp208 = NULL;
							_tmp207 = NULL;
							_tmp210 = NULL;
							cinitcall = (_tmp210 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp209 = vala_ccode_identifier_new (_tmp208 = g_strdup_printf ("%s_instance_init", _tmp207 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))))), (_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL)), _tmp208 = (g_free (_tmp208), NULL), _tmp207 = (g_free (_tmp207), NULL), _tmp210);
							_tmp211 = NULL;
							vala_ccode_function_call_add_argument (cinitcall, (ValaCCodeExpression*) (_tmp211 = vala_ccode_identifier_new ("self")));
							(_tmp211 == NULL) ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL));
							_tmp212 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp212 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinitcall)));
							(_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL));
							(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
							(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(cinitcall == NULL) ? NULL : (cinitcall = (vala_ccode_node_unref (cinitcall), NULL));
						} else {
							ValaStruct* _tmp213;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp214;
							ValaCCodeFunctionCall* _tmp215;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp216;
							ValaCCodeConstant* _tmp217;
							ValaCCodeIdentifier* _tmp220;
							char* _tmp219;
							char* _tmp218;
							ValaCCodeExpressionStatement* _tmp221;
							_tmp213 = NULL;
							st = (_tmp213 = VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp213 == NULL) ? NULL : vala_code_node_ref (_tmp213));
							/* memset needs string.h*/
							((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
							_tmp214 = NULL;
							_tmp215 = NULL;
							czero = (_tmp215 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp214 = vala_ccode_identifier_new ("memset"))), (_tmp214 == NULL) ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL)), _tmp215);
							_tmp216 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp216 = vala_ccode_identifier_new ("self")));
							(_tmp216 == NULL) ? NULL : (_tmp216 = (vala_ccode_node_unref (_tmp216), NULL));
							_tmp217 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp217 = vala_ccode_constant_new ("0")));
							(_tmp217 == NULL) ? NULL : (_tmp217 = (vala_ccode_node_unref (_tmp217), NULL));
							_tmp220 = NULL;
							_tmp219 = NULL;
							_tmp218 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp220 = vala_ccode_identifier_new (_tmp219 = g_strdup_printf ("sizeof (%s)", _tmp218 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)))));
							(_tmp220 == NULL) ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL));
							_tmp219 = (g_free (_tmp219), NULL);
							_tmp218 = (g_free (_tmp218), NULL);
							_tmp221 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp221 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero)));
							(_tmp221 == NULL) ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL));
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
						}
					}
				}
			}
			_tmp222 = FALSE;
			if (vala_code_context_get_module_init_method (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == m) {
				_tmp222 = ((ValaCCodeBaseModule*) self)->in_plugin;
			} else {
				_tmp222 = FALSE;
			}
			if (_tmp222) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->module_init_fragment);
			}
			{
				GeeList* _tmp223;
				GeeIterator* _tmp224;
				GeeIterator* _precondition_it;
				_tmp223 = NULL;
				_tmp224 = NULL;
				_precondition_it = (_tmp224 = gee_iterable_iterator ((GeeIterable*) (_tmp223 = vala_method_get_preconditions (m))), (_tmp223 == NULL) ? NULL : (_tmp223 = (gee_collection_object_unref (_tmp223), NULL)), _tmp224);
				while (gee_iterator_next (_precondition_it)) {
					ValaExpression* precondition;
					ValaCCodeStatement* check_stmt;
					precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
					check_stmt = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, creturn_type, precondition);
					if (check_stmt != NULL) {
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) check_stmt);
					}
					(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
					(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
				}
				(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
			}
			(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* check_stmt;
				ValaCCodeIdentifier* _tmp225;
				ValaCCodeFunctionCall* _tmp226;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp227;
				ValaCCodeIdentifier* _tmp228;
				ValaCCodeFunctionCall* _tmp229;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp230;
				char* _tmp231;
				char* error_string;
				ValaCCodeIdentifier* _tmp232;
				ValaCCodeFunctionCall* _tmp233;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp234;
				ValaCCodeExpressionStatement* _tmp235;
				ValaCCodeReturnStatement* _tmp237;
				ValaCCodeExpression* _tmp236;
				/* generate helpful error message if a sublcass does not implement an abstract method.
				 This is only meaningful for subclasses implemented in C since the vala compiler would
				 complain during compile time of such en error.*/
				cblock = vala_ccode_block_new ();
				/* add a typecheck statement for "self"*/
				check_stmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, ((ValaCCodeBaseModule*) self)->current_type_symbol, TRUE, "self");
				if (check_stmt != NULL) {
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) check_stmt);
				}
				/* add critical warning that this method should not have been called*/
				_tmp225 = NULL;
				_tmp226 = NULL;
				type_from_instance_call = (_tmp226 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp225 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp225 == NULL) ? NULL : (_tmp225 = (vala_ccode_node_unref (_tmp225), NULL)), _tmp226);
				_tmp227 = NULL;
				vala_ccode_function_call_add_argument (type_from_instance_call, (ValaCCodeExpression*) (_tmp227 = vala_ccode_identifier_new ("self")));
				(_tmp227 == NULL) ? NULL : (_tmp227 = (vala_ccode_node_unref (_tmp227), NULL));
				_tmp228 = NULL;
				_tmp229 = NULL;
				type_name_call = (_tmp229 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp228 = vala_ccode_identifier_new ("g_type_name"))), (_tmp228 == NULL) ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL)), _tmp229);
				vala_ccode_function_call_add_argument (type_name_call, (ValaCCodeExpression*) type_from_instance_call);
				_tmp230 = NULL;
				_tmp231 = NULL;
				error_string = (_tmp231 = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", _tmp230 = vala_method_get_cname (m)), _tmp230 = (g_free (_tmp230), NULL), _tmp231);
				_tmp232 = NULL;
				_tmp233 = NULL;
				cerrorcall = (_tmp233 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp232 = vala_ccode_identifier_new ("g_critical"))), (_tmp232 == NULL) ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL)), _tmp233);
				_tmp234 = NULL;
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) (_tmp234 = vala_ccode_constant_new (error_string)));
				(_tmp234 == NULL) ? NULL : (_tmp234 = (vala_ccode_node_unref (_tmp234), NULL));
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) type_name_call);
				_tmp235 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp235 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cerrorcall)));
				(_tmp235 == NULL) ? NULL : (_tmp235 = (vala_ccode_node_unref (_tmp235), NULL));
				/* add return statement*/
				_tmp237 = NULL;
				_tmp236 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp237 = vala_ccode_return_statement_new (_tmp236 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, creturn_type, FALSE))));
				(_tmp237 == NULL) ? NULL : (_tmp237 = (vala_ccode_node_unref (_tmp237), NULL));
				(_tmp236 == NULL) ? NULL : (_tmp236 = (vala_ccode_node_unref (_tmp236), NULL));
				vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, cblock);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
				(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
				(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
				(type_from_instance_call == NULL) ? NULL : (type_from_instance_call = (vala_ccode_node_unref (type_from_instance_call), NULL));
				(type_name_call == NULL) ? NULL : (type_name_call = (vala_ccode_node_unref (type_name_call), NULL));
				error_string = (g_free (error_string), NULL);
				(cerrorcall == NULL) ? NULL : (cerrorcall = (vala_ccode_node_unref (cerrorcall), NULL));
			}
		}
	}
	_tmp238 = FALSE;
	_tmp239 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp239 = TRUE;
	} else {
		_tmp239 = vala_method_get_is_virtual (m);
	}
	if (_tmp239) {
		_tmp238 = !vala_method_get_coroutine (m);
	} else {
		_tmp238 = FALSE;
	}
	if (_tmp238) {
		GeeHashMap* _tmp240;
		GeeHashMap* carg_map;
		_tmp240 = NULL;
		cparam_map = (_tmp240 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp240);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vala_ccode_method_module_generate_vfunc (self, m, creturn_type, (GeeMap*) cparam_map, (GeeMap*) carg_map, "", 3);
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	}
	if (vala_method_get_entry_point (m)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp241;
		ValaCCodeFormalParameter* _tmp242;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp248;
		ValaCCodeIdentifier* _tmp247;
		ValaCCodeExpressionStatement* _tmp249;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp250;
		ValaCCodeFunctionCall* _tmp251;
		ValaCCodeFunctionCall* main_call;
		GeeList* _tmp252;
		gboolean _tmp253;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line ((ValaCCodeNode*) cmain, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		_tmp241 = NULL;
		vala_ccode_function_add_parameter (cmain, _tmp241 = vala_ccode_formal_parameter_new ("argc", "int"));
		(_tmp241 == NULL) ? NULL : (_tmp241 = (vala_ccode_node_unref (_tmp241), NULL));
		_tmp242 = NULL;
		vala_ccode_function_add_parameter (cmain, _tmp242 = vala_ccode_formal_parameter_new ("argv", "char **"));
		(_tmp242 == NULL) ? NULL : (_tmp242 = (vala_ccode_node_unref (_tmp242), NULL));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
			ValaCCodeIdentifier* _tmp243;
			ValaCCodeFunctionCall* _tmp244;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp245;
			ValaCCodeExpressionStatement* _tmp246;
			_tmp243 = NULL;
			_tmp244 = NULL;
			thread_init_call = (_tmp244 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp243 = vala_ccode_identifier_new ("g_thread_init"))), (_tmp243 == NULL) ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL)), _tmp244);
			vala_ccode_node_set_line ((ValaCCodeNode*) thread_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			_tmp245 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, (ValaCCodeExpression*) (_tmp245 = vala_ccode_constant_new ("NULL")));
			(_tmp245 == NULL) ? NULL : (_tmp245 = (vala_ccode_node_unref (_tmp245), NULL));
			_tmp246 = NULL;
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) (_tmp246 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) thread_init_call)));
			(_tmp246 == NULL) ? NULL : (_tmp246 = (vala_ccode_node_unref (_tmp246), NULL));
			(thread_init_call == NULL) ? NULL : (thread_init_call = (vala_ccode_node_unref (thread_init_call), NULL));
		}
		_tmp248 = NULL;
		_tmp247 = NULL;
		_tmp249 = NULL;
		type_init_call = (_tmp249 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp248 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp247 = vala_ccode_identifier_new ("g_type_init"))))), (_tmp248 == NULL) ? NULL : (_tmp248 = (vala_ccode_node_unref (_tmp248), NULL)), (_tmp247 == NULL) ? NULL : (_tmp247 = (vala_ccode_node_unref (_tmp247), NULL)), _tmp249);
		vala_ccode_node_set_line ((ValaCCodeNode*) type_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
		vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) type_init_call);
		_tmp250 = NULL;
		_tmp251 = NULL;
		main_call = (_tmp251 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp250 = vala_ccode_identifier_new (vala_ccode_function_get_name (((ValaCCodeBaseModule*) self)->function)))), (_tmp250 == NULL) ? NULL : (_tmp250 = (vala_ccode_node_unref (_tmp250), NULL)), _tmp251);
		_tmp252 = NULL;
		if ((_tmp253 = gee_collection_get_size ((GeeCollection*) (_tmp252 = vala_method_get_parameters (m))) == 1, (_tmp252 == NULL) ? NULL : (_tmp252 = (gee_collection_object_unref (_tmp252), NULL)), _tmp253)) {
			ValaCCodeIdentifier* _tmp254;
			ValaCCodeIdentifier* _tmp255;
			_tmp254 = NULL;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp254 = vala_ccode_identifier_new ("argv")));
			(_tmp254 == NULL) ? NULL : (_tmp254 = (vala_ccode_node_unref (_tmp254), NULL));
			_tmp255 = NULL;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp255 = vala_ccode_identifier_new ("argc")));
			(_tmp255 == NULL) ? NULL : (_tmp255 = (vala_ccode_node_unref (_tmp255), NULL));
		}
		if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp256;
			ValaCCodeReturnStatement* _tmp257;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			_tmp256 = NULL;
			_tmp257 = NULL;
			ret_stmt = (_tmp257 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp256 = vala_ccode_constant_new ("0"))), (_tmp256 == NULL) ? NULL : (_tmp256 = (vala_ccode_node_unref (_tmp256), NULL)), _tmp257);
			vala_ccode_node_set_line ((ValaCCodeNode*) ret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) ret_stmt);
			(main_stmt == NULL) ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL));
			(ret_stmt == NULL) ? NULL : (ret_stmt = (vala_ccode_node_unref (ret_stmt), NULL));
		} else {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			(main_stmt == NULL) ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cmain);
		(cmain == NULL) ? NULL : (cmain = (vala_ccode_node_unref (cmain), NULL));
		(main_block == NULL) ? NULL : (main_block = (vala_ccode_node_unref (main_block), NULL));
		(type_init_call == NULL) ? NULL : (type_init_call = (vala_ccode_node_unref (type_init_call), NULL));
		(main_call == NULL) ? NULL : (main_call = (vala_ccode_node_unref (main_call), NULL));
	}
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_method == NULL) ? NULL : (old_method = (vala_code_node_unref (old_method), NULL));
	(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
	(old_variable_name_map == NULL) ? NULL : (old_variable_name_map = (gee_collection_object_unref (old_variable_name_map), NULL));
	(old_try == NULL) ? NULL : (old_try = (vala_code_node_unref (old_try), NULL));
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
}


static void vala_ccode_method_module_real_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, GeeMap* cparam_map, GeeMap* carg_map) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	g_return_if_fail (cparam_map != NULL);
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeIdentifier* _tmp0;
		_tmp0 = NULL;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	}
}


void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, GeeMap* cparam_map, GeeMap* carg_map) {
	VALA_CCODE_METHOD_MODULE_GET_CLASS (self)->generate_parameter (self, param, cparam_map, carg_map);
}


static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	ValaCCodeMethodModule * self;
	gboolean _tmp0;
	gint last_pos;
	gint min_pos;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (func != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		_tmp0 = VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaClass* _tmp1;
		ValaClass* cl;
		gboolean _tmp2;
		_tmp1 = NULL;
		cl = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = FALSE;
		if (!vala_class_get_is_compact (cl)) {
			_tmp2 = vcall == NULL;
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			ValaCCodeFormalParameter* _tmp3;
			_tmp3 = NULL;
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), _tmp3 = vala_ccode_formal_parameter_new ("object_type", "GType"));
			(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		gboolean _tmp4;
		_tmp4 = FALSE;
		if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
			_tmp4 = TRUE;
		} else {
			gboolean _tmp5;
			_tmp5 = FALSE;
			if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
				_tmp5 = VALA_IS_CREATION_METHOD (m);
			} else {
				_tmp5 = FALSE;
			}
			_tmp4 = _tmp5;
		}
		if (_tmp4) {
			ValaTypeSymbol* parent_type;
			ValaDataType* this_type;
			ValaCCodeFormalParameter* instance_param;
			gboolean _tmp10;
			gboolean _tmp11;
			parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
			this_type = NULL;
			if (VALA_IS_CLASS (parent_type)) {
				ValaDataType* _tmp6;
				_tmp6 = NULL;
				this_type = (_tmp6 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp6);
			} else {
				if (VALA_IS_INTERFACE (parent_type)) {
					ValaDataType* _tmp7;
					_tmp7 = NULL;
					this_type = (_tmp7 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp7);
				} else {
					if (VALA_IS_STRUCT (parent_type)) {
						ValaDataType* _tmp8;
						_tmp8 = NULL;
						this_type = (_tmp8 = (ValaDataType*) vala_struct_value_type_new (VALA_STRUCT (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp8);
					} else {
						if (VALA_IS_ENUM (parent_type)) {
							ValaDataType* _tmp9;
							_tmp9 = NULL;
							this_type = (_tmp9 = (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp9);
						} else {
							g_assert_not_reached ();
						}
					}
				}
			}
			instance_param = NULL;
			_tmp10 = FALSE;
			_tmp11 = FALSE;
			if (vala_method_get_base_interface_method (m) != NULL) {
				_tmp11 = !vala_method_get_is_abstract (m);
			} else {
				_tmp11 = FALSE;
			}
			if (_tmp11) {
				_tmp10 = !vala_method_get_is_virtual (m);
			} else {
				_tmp10 = FALSE;
			}
			if (_tmp10) {
				ValaObjectType* base_type;
				ValaCCodeFormalParameter* _tmp13;
				char* _tmp12;
				base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))));
				_tmp13 = NULL;
				_tmp12 = NULL;
				instance_param = (_tmp13 = vala_ccode_formal_parameter_new ("base", _tmp12 = vala_data_type_get_cname ((ValaDataType*) base_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp13);
				_tmp12 = (g_free (_tmp12), NULL);
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_method_get_overrides (m)) {
					ValaObjectType* base_type;
					ValaCCodeFormalParameter* _tmp15;
					char* _tmp14;
					base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))));
					_tmp15 = NULL;
					_tmp14 = NULL;
					instance_param = (_tmp15 = vala_ccode_formal_parameter_new ("base", _tmp14 = vala_data_type_get_cname ((ValaDataType*) base_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp15);
					_tmp14 = (g_free (_tmp14), NULL);
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				} else {
					gboolean _tmp16;
					_tmp16 = FALSE;
					if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
						_tmp16 = !vala_struct_is_simple_type (VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
					} else {
						_tmp16 = FALSE;
					}
					if (_tmp16) {
						ValaCCodeFormalParameter* _tmp18;
						char* _tmp17;
						_tmp18 = NULL;
						_tmp17 = NULL;
						instance_param = (_tmp18 = vala_ccode_formal_parameter_new ("*self", _tmp17 = vala_data_type_get_cname (this_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp18);
						_tmp17 = (g_free (_tmp17), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp20;
						char* _tmp19;
						_tmp20 = NULL;
						_tmp19 = NULL;
						instance_param = (_tmp20 = vala_ccode_formal_parameter_new ("self", _tmp19 = vala_data_type_get_cname (this_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp20);
						_tmp19 = (g_free (_tmp19), NULL);
					}
				}
			}
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
			(parent_type == NULL) ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL));
			(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
			(instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL));
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
				ValaTypeSymbol* parent_type;
				ValaDataType* this_type;
				ValaDataType* _tmp21;
				char* _tmp22;
				ValaCCodeFormalParameter* _tmp23;
				ValaCCodeFormalParameter* class_param;
				parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
				this_type = NULL;
				_tmp21 = NULL;
				this_type = (_tmp21 = (ValaDataType*) vala_class_type_new (VALA_CLASS (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp21);
				_tmp22 = NULL;
				_tmp23 = NULL;
				class_param = (_tmp23 = vala_ccode_formal_parameter_new ("klass", _tmp22 = vala_data_type_get_cname (this_type)), _tmp22 = (g_free (_tmp22), NULL), _tmp23);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
				(parent_type == NULL) ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL));
				(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
				(class_param == NULL) ? NULL : (class_param = (vala_ccode_node_unref (class_param), NULL));
			}
		}
	}
	if (vala_ccode_method_module_is_gtypeinstance_creation_method (self, m)) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeList* _tmp24;
			GeeIterator* _tmp25;
			GeeIterator* _type_param_it;
			_tmp24 = NULL;
			_tmp25 = NULL;
			_type_param_it = (_tmp25 = gee_iterable_iterator ((GeeIterable*) (_tmp24 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp24 == NULL) ? NULL : (_tmp24 = (gee_collection_object_unref (_tmp24), NULL)), _tmp25);
			while (gee_iterator_next (_type_param_it)) {
				ValaTypeParameter* type_param;
				ValaCCodeFormalParameter* _tmp28;
				char* _tmp27;
				char* _tmp26;
				ValaCCodeFormalParameter* _tmp31;
				char* _tmp30;
				char* _tmp29;
				ValaCCodeFormalParameter* _tmp34;
				char* _tmp33;
				char* _tmp32;
				type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
				_tmp28 = NULL;
				_tmp27 = NULL;
				_tmp26 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), _tmp28 = vala_ccode_formal_parameter_new (_tmp27 = g_strdup_printf ("%s_type", _tmp26 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GType"));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				_tmp27 = (g_free (_tmp27), NULL);
				_tmp26 = (g_free (_tmp26), NULL);
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp29 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), _tmp31 = vala_ccode_formal_parameter_new (_tmp30 = g_strdup_printf ("%s_dup_func", _tmp29 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GBoxedCopyFunc"));
				(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
				_tmp30 = (g_free (_tmp30), NULL);
				_tmp29 = (g_free (_tmp29), NULL);
				_tmp34 = NULL;
				_tmp33 = NULL;
				_tmp32 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), _tmp34 = vala_ccode_formal_parameter_new (_tmp33 = g_strdup_printf ("%s_destroy_func", _tmp32 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GDestroyNotify"));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				_tmp33 = (g_free (_tmp33), NULL);
				_tmp32 = (g_free (_tmp32), NULL);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp37;
					char* _tmp36;
					char* _tmp35;
					ValaCCodeIdentifier* _tmp40;
					char* _tmp39;
					char* _tmp38;
					ValaCCodeIdentifier* _tmp43;
					char* _tmp42;
					char* _tmp41;
					_tmp37 = NULL;
					_tmp36 = NULL;
					_tmp35 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (_tmp36 = g_strdup_printf ("%s_type", _tmp35 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					_tmp36 = (g_free (_tmp36), NULL);
					_tmp35 = (g_free (_tmp35), NULL);
					_tmp40 = NULL;
					_tmp39 = NULL;
					_tmp38 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (_tmp39 = g_strdup_printf ("%s_dup_func", _tmp38 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
					_tmp39 = (g_free (_tmp39), NULL);
					_tmp38 = (g_free (_tmp38), NULL);
					_tmp43 = NULL;
					_tmp42 = NULL;
					_tmp41 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (_tmp42 = g_strdup_printf ("%s_destroy_func", _tmp41 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
					_tmp42 = (g_free (_tmp42), NULL);
					_tmp41 = (g_free (_tmp41), NULL);
				}
				type_param_index++;
				(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
			}
			(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
		}
	}
	{
		GeeList* _tmp44;
		GeeIterator* _tmp45;
		GeeIterator* _param_it;
		_tmp44 = NULL;
		_tmp45 = NULL;
		_param_it = (_tmp45 = gee_iterable_iterator ((GeeIterable*) (_tmp44 = vala_method_get_parameters (m))), (_tmp44 == NULL) ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL)), _tmp45);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				if ((direction & 1) == 0) {
					/* no in paramters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
			} else {
				if ((direction & 2) == 0) {
					/* no out paramters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
			}
			vala_ccode_method_module_generate_parameter (self, param, cparam_map, carg_map);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if ((direction & 2) != 0) {
		vala_ccode_method_module_generate_method_result_declaration (self, m, func, cparam_map, carg_map);
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp50;
		min_pos = -1;
		{
			GeeSet* _tmp46;
			GeeIterator* _tmp47;
			GeeIterator* _pos_it;
			_tmp46 = NULL;
			_tmp47 = NULL;
			_pos_it = (_tmp47 = gee_iterable_iterator ((GeeIterable*) (_tmp46 = gee_map_get_keys (cparam_map))), (_tmp46 == NULL) ? NULL : (_tmp46 = (gee_collection_object_unref (_tmp46), NULL)), _tmp47);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp48;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp48 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp49;
					_tmp49 = FALSE;
					if (min_pos == (-1)) {
						_tmp49 = TRUE;
					} else {
						_tmp49 = pos < min_pos;
					}
					_tmp48 = _tmp49;
				} else {
					_tmp48 = FALSE;
				}
				if (_tmp48) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp50 = NULL;
		vala_ccode_function_add_parameter (func, _tmp50 = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
		(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp51;
			_tmp51 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, _tmp51 = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
			(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
		}
		if (vcall != NULL) {
			ValaCCodeExpression* _tmp52;
			_tmp52 = NULL;
			vala_ccode_function_call_add_argument (vcall, _tmp52 = (ValaCCodeExpression*) gee_map_get (carg_map, GINT_TO_POINTER (min_pos)));
			(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
		}
		last_pos = min_pos;
	}
}


void vala_ccode_method_module_generate_vfunc (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, GeeMap* cparam_map, GeeMap* carg_map, const char* suffix, gint direction) {
	gboolean visible;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* vfunc;
	ValaCCodeBlock* vblock;
	ValaCCodeFunctionCall* vcast;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeMemberAccess* _tmp17;
	char* _tmp16;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeFunctionCall* vcall;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeStatement* cstmt;
	GeeList* _tmp30;
	gboolean _tmp31;
	gboolean _tmp39;
	gboolean _tmp40;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (return_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (carg_map != NULL);
	g_return_if_fail (suffix != NULL);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	vfunc = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strconcat (_tmp0 = vala_method_get_cname (m), suffix, NULL), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	vblock = vala_ccode_block_new ();
	{
		GeeList* _tmp3;
		GeeIterator* _tmp4;
		GeeIterator* _precondition_it;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_precondition_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_method_get_preconditions (m))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
		while (gee_iterator_next (_precondition_it)) {
			ValaExpression* precondition;
			ValaCCodeStatement* check_stmt;
			precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
			check_stmt = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, return_type, precondition);
			if (check_stmt != NULL) {
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) check_stmt);
			}
			(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
			(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
		}
		(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
	}
	vcast = NULL;
	if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		ValaInterface* _tmp5;
		ValaInterface* iface;
		ValaCCodeFunctionCall* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		char* _tmp7;
		char* _tmp6;
		_tmp5 = NULL;
		iface = (_tmp5 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		vcast = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = g_strdup_printf ("%s_GET_INTERFACE", _tmp6 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp9);
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
		(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
	} else {
		ValaClass* _tmp10;
		ValaClass* cl;
		ValaCCodeFunctionCall* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		char* _tmp12;
		char* _tmp11;
		_tmp10 = NULL;
		cl = (_tmp10 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		vcast = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (_tmp12 = g_strdup_printf ("%s_GET_CLASS", _tmp11 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp14);
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		_tmp12 = (g_free (_tmp12), NULL);
		_tmp11 = (g_free (_tmp11), NULL);
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	}
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("self")));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp18 = NULL;
	vcall = (_tmp18 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp16 = g_strconcat (vala_method_get_vfunc_name (m), suffix, NULL)))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp18);
	_tmp19 = NULL;
	gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("self")));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, cparam_map, vfunc, NULL, carg_map, vcall, direction);
	cstmt = NULL;
	if (VALA_IS_VOID_TYPE (return_type)) {
		ValaCCodeStatement* _tmp20;
		_tmp20 = NULL;
		cstmt = (_tmp20 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp20);
	} else {
		GeeList* _tmp21;
		gboolean _tmp22;
		_tmp21 = NULL;
		if ((_tmp22 = gee_collection_get_size ((GeeCollection*) (_tmp21 = vala_method_get_postconditions (m))) == 0, (_tmp21 == NULL) ? NULL : (_tmp21 = (gee_collection_object_unref (_tmp21), NULL)), _tmp22)) {
			ValaCCodeStatement* _tmp23;
			/* pass method return value */
			_tmp23 = NULL;
			cstmt = (_tmp23 = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp23);
		} else {
			char* _tmp25;
			char* _tmp24;
			ValaCCodeDeclaration* _tmp26;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp27;
			ValaCCodeStatement* _tmp29;
			ValaCCodeStatement* _tmp28;
			/* store method return value for postconditions */
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp26 = NULL;
			cdecl_ = (_tmp26 = vala_ccode_declaration_new (_tmp25 = vala_ccode_method_module_get_creturn_type (self, m, _tmp24 = vala_data_type_get_cname (return_type))), _tmp25 = (g_free (_tmp25), NULL), _tmp24 = (g_free (_tmp24), NULL), _tmp26);
			_tmp27 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp27 = vala_ccode_variable_declarator_new ("result", (ValaCCodeExpression*) vcall)));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
			_tmp29 = NULL;
			_tmp28 = NULL;
			cstmt = (_tmp29 = (_tmp28 = (ValaCCodeStatement*) cdecl_, (_tmp28 == NULL) ? NULL : vala_ccode_node_ref (_tmp28)), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp29);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
	}
	vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
	vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
	_tmp30 = NULL;
	if ((_tmp31 = gee_collection_get_size ((GeeCollection*) (_tmp30 = vala_method_get_postconditions (m))) > 0, (_tmp30 == NULL) ? NULL : (_tmp30 = (gee_collection_object_unref (_tmp30), NULL)), _tmp31)) {
		{
			GeeList* _tmp32;
			GeeIterator* _tmp33;
			GeeIterator* _postcondition_it;
			_tmp32 = NULL;
			_tmp33 = NULL;
			_postcondition_it = (_tmp33 = gee_iterable_iterator ((GeeIterable*) (_tmp32 = vala_method_get_postconditions (m))), (_tmp32 == NULL) ? NULL : (_tmp32 = (gee_collection_object_unref (_tmp32), NULL)), _tmp33);
			while (gee_iterator_next (_postcondition_it)) {
				ValaExpression* postcondition;
				ValaCCodeStatement* _tmp34;
				postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
				_tmp34 = NULL;
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) (_tmp34 = vala_ccode_method_module_create_postcondition_statement (self, postcondition)));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
			}
			(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
		}
		if (!VALA_IS_VOID_TYPE (return_type)) {
			ValaCCodeIdentifier* _tmp35;
			ValaCCodeReturnStatement* _tmp36;
			ValaCCodeReturnStatement* cret_stmt;
			_tmp35 = NULL;
			_tmp36 = NULL;
			cret_stmt = (_tmp36 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("result"))), (_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)), _tmp36);
			vala_ccode_node_set_line ((ValaCCodeNode*) cret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
			vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cret_stmt);
			(cret_stmt == NULL) ? NULL : (cret_stmt = (vala_ccode_node_unref (cret_stmt), NULL));
		}
	}
	if (visible) {
		ValaCCodeFunction* _tmp37;
		_tmp37 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->header_declarations, (ValaCCodeNode*) (_tmp37 = vala_ccode_function_copy (vfunc)));
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	} else {
		ValaCCodeFunction* _tmp38;
		vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp38 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp38 = vala_ccode_function_copy (vfunc)));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	}
	vala_ccode_function_set_block (vfunc, vblock);
	_tmp39 = FALSE;
	_tmp40 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp40 = vala_code_node_get_source_reference ((ValaCodeNode*) m) != NULL;
	} else {
		_tmp40 = FALSE;
	}
	if (_tmp40) {
		_tmp39 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)) != NULL;
	} else {
		_tmp39 = FALSE;
	}
	if (_tmp39) {
		ValaCCodeComment* _tmp41;
		_tmp41 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp41 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)))));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
	(vfunc == NULL) ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL));
	(vblock == NULL) ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL));
	(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
	(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
	(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
}


static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (vala_method_get_coroutine (m)) {
		return NULL;
	} else {
		return vala_ccode_base_module_create_type_check_statement ((ValaCCodeBaseModule*) self, (ValaCodeNode*) m, return_type, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (precondition != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) precondition)));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_return_if_fail")));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail")));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		cdefault = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeStatement* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = NULL, (cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp2);
		}
		(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
	}
	_tmp3 = NULL;
	return (_tmp3 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp3);
}


static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeStatement* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (postcondition != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_assert"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) postcondition)));
	_tmp2 = NULL;
	return (_tmp2 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassert), (cassert == NULL) ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL)), _tmp2);
}


static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypeSymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	gboolean chain_up;
	ValaCreationMethod* cm;
	gboolean _tmp7;
	gboolean _tmp8;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeDeclaration* _tmp25;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	chain_up = FALSE;
	cm = NULL;
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCreationMethod* _tmp3;
		ValaCreationMethod* _tmp2;
		ValaMethod* _tmp1;
		gboolean _tmp4;
		gboolean _tmp5;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		cm = (_tmp3 = (_tmp2 = (_tmp1 = vala_class_get_default_construction_method (vala_class_get_base_class (cl)), VALA_IS_CREATION_METHOD (_tmp1) ? ((ValaCreationMethod*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), _tmp3);
		_tmp4 = FALSE;
		_tmp5 = FALSE;
		if (cm != NULL) {
			GeeList* _tmp6;
			_tmp6 = NULL;
			_tmp5 = gee_collection_get_size ((GeeCollection*) (_tmp6 = vala_method_get_parameters ((ValaMethod*) cm))) == 0;
			(_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL));
		} else {
			_tmp5 = FALSE;
		}
		if (_tmp5) {
			_tmp4 = vala_method_get_has_construct_function ((ValaMethod*) cm);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			if (!has_params) {
				chain_up = TRUE;
			}
		}
	}
	_tmp7 = FALSE;
	_tmp8 = FALSE;
	if (!has_params) {
		_tmp8 = !chain_up;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		_tmp7 = VALA_TYPESYMBOL (vala_class_get_base_class (cl)) != ((ValaCCodeBaseModule*) self)->gobject_type;
	} else {
		_tmp7 = FALSE;
	}
	if (_tmp7) {
	}
	/* possibly report warning or error about missing base call*/
	cdecl_ = vala_ccode_variable_declarator_new ("self", NULL);
	if (chain_up) {
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeCastExpression* _tmp15;
		char* _tmp14;
		char* _tmp13;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp11 = NULL;
		ccall = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_real_cname ((ValaMethod*) cm)))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("object_type")));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) (_tmp15 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp14 = g_strdup_printf ("%s*", _tmp13 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		_tmp14 = (g_free (_tmp14), NULL);
		_tmp13 = (g_free (_tmp13), NULL);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	} else {
		ValaCCodeIdentifier* _tmp16;
		ValaCCodeFunctionCall* _tmp17;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp18;
		_tmp16 = NULL;
		_tmp17 = NULL;
		ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_object_newv"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("object_type")));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		if (has_params) {
			ValaCCodeConstant* _tmp19;
			ValaCCodeConstant* _tmp20;
			_tmp19 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("__params_it - __params")));
			(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
			_tmp20 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new ("__params")));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		} else {
			ValaCCodeConstant* _tmp21;
			ValaCCodeConstant* _tmp22;
			_tmp21 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("0")));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			_tmp22 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new ("NULL")));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		}
		vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) ccall);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp25 = NULL;
	cdeclaration = (_tmp25 = vala_ccode_declaration_new (_tmp24 = g_strdup_printf ("%s *", _tmp23 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), _tmp25);
	vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) cdecl_);
	vala_ccode_block_add_statement (b, (ValaCCodeNode*) cdeclaration);
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
}


static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m) {
	ValaCCodeMethodModule * self;
	gboolean visible;
	gboolean _tmp0;
	gboolean _tmp1;
	ValaDataType* creturn_type;
	gboolean _tmp9;
	gboolean _tmp19;
	gboolean _tmp20;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (vala_method_get_body ((ValaMethod*) m) != NULL) {
		_tmp1 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gint n_params;
		n_params = 0;
		{
			GeeList* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _stmt_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_stmt_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_block_get_statements (vala_method_get_body ((ValaMethod*) m)))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_stmt_it)) {
				ValaStatement* stmt;
				ValaExpressionStatement* _tmp5;
				ValaStatement* _tmp4;
				ValaExpressionStatement* expr_stmt;
				stmt = (ValaStatement*) gee_iterator_get (_stmt_it);
				_tmp5 = NULL;
				_tmp4 = NULL;
				expr_stmt = (_tmp5 = (_tmp4 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp4) ? ((ValaExpressionStatement*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				if (expr_stmt != NULL) {
					ValaProperty* prop;
					gboolean _tmp6;
					prop = vala_expression_statement_assigned_property (expr_stmt);
					_tmp6 = FALSE;
					if (prop != NULL) {
						_tmp6 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
					} else {
						_tmp6 = FALSE;
					}
					if (_tmp6) {
						n_params++;
					}
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				}
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
			}
			(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	vala_ccode_module_visit_method (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaMethod*) m);
	creturn_type = NULL;
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		ValaDataType* _tmp7;
		_tmp7 = NULL;
		creturn_type = (_tmp7 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp7);
	} else {
		ValaDataType* _tmp8;
		_tmp8 = NULL;
		creturn_type = (_tmp8 = (ValaDataType*) vala_void_type_new (NULL), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp8);
	}
	_tmp9 = FALSE;
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		_tmp9 = !vala_class_get_is_compact (((ValaCCodeBaseModule*) self)->current_class);
	} else {
		_tmp9 = FALSE;
	}
	if (_tmp9) {
		char* _tmp10;
		ValaCCodeFunction* _tmp11;
		ValaCCodeFunction* vfunc;
		GeeHashMap* cparam_map;
		GeeHashMap* carg_map;
		ValaCCodeBlock* vblock;
		ValaCCodeIdentifier* _tmp13;
		char* _tmp12;
		ValaCCodeFunctionCall* _tmp14;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp16;
		char* _tmp15;
		ValaCCodeStatement* cstmt;
		_tmp10 = NULL;
		_tmp11 = NULL;
		vfunc = (_tmp11 = vala_ccode_function_new (_tmp10 = vala_method_get_cname ((ValaMethod*) m), "void"), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
		vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vblock = vala_ccode_block_new ();
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp14 = NULL;
		vcall = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (_tmp12 = vala_method_get_real_cname ((ValaMethod*) m)))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp12 = (g_free (_tmp12), NULL), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))));
		(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
		_tmp15 = (g_free (_tmp15), NULL);
		vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, (ValaMethod*) m, (GeeMap*) cparam_map, vfunc, NULL, (GeeMap*) carg_map, vcall, 3);
		cstmt = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall);
		vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
		vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
		if (visible) {
			ValaCCodeFunction* _tmp17;
			_tmp17 = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->header_declarations, (ValaCCodeNode*) (_tmp17 = vala_ccode_function_copy (vfunc)));
			(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		} else {
			ValaCCodeFunction* _tmp18;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | VALA_CCODE_MODIFIERS_STATIC);
			_tmp18 = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp18 = vala_ccode_function_copy (vfunc)));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
		(vfunc == NULL) ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL));
		(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		(vblock == NULL) ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL));
		(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
	}
	_tmp19 = FALSE;
	_tmp20 = FALSE;
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		_tmp20 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		gboolean _tmp21;
		_tmp21 = FALSE;
		if (vala_creation_method_get_n_construction_params (VALA_CREATION_METHOD (m)) > 0) {
			_tmp21 = TRUE;
		} else {
			GeeList* _tmp22;
			_tmp22 = NULL;
			_tmp21 = gee_collection_get_size ((GeeCollection*) (_tmp22 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
			(_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL));
		}
		_tmp19 = _tmp21;
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeBinaryExpression* _tmp25;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeBlock* cdofreeparam;
		ValaCCodeExpressionStatement* _tmp28;
		ValaCCodeUnaryExpression* _tmp27;
		ValaCCodeIdentifier* _tmp26;
		ValaCCodeIdentifier* _tmp29;
		ValaCCodeFunctionCall* _tmp30;
		ValaCCodeFunctionCall* cunsetcall;
		ValaCCodeUnaryExpression* _tmp33;
		ValaCCodeMemberAccess* _tmp32;
		ValaCCodeIdentifier* _tmp31;
		ValaCCodeExpressionStatement* _tmp34;
		ValaCCodeWhileStatement* _tmp35;
		ValaCCodeIdentifier* _tmp36;
		ValaCCodeFunctionCall* _tmp37;
		ValaCCodeFunctionCall* cfreeparams;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeExpressionStatement* _tmp39;
		_tmp24 = NULL;
		_tmp23 = NULL;
		_tmp25 = NULL;
		ccond = (_tmp25 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("__params_it")), (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("__params"))), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), (_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)), _tmp25);
		cdofreeparam = vala_ccode_block_new ();
		_tmp28 = NULL;
		_tmp27 = NULL;
		_tmp26 = NULL;
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("__params_it")))))));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		_tmp29 = NULL;
		_tmp30 = NULL;
		cunsetcall = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("g_value_unset"))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp30);
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_function_call_add_argument (cunsetcall, (ValaCCodeExpression*) (_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp32 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("__params_it")), "value")))));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
		(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
		(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
		_tmp34 = NULL;
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp34 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cunsetcall)));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		_tmp35 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp35 = vala_ccode_while_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cdofreeparam)));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		_tmp36 = NULL;
		_tmp37 = NULL;
		cfreeparams = (_tmp37 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("g_free"))), (_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)), _tmp37);
		_tmp38 = NULL;
		vala_ccode_function_call_add_argument (cfreeparams, (ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("__params")));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
		_tmp39 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp39 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreeparams)));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
		(cdofreeparam == NULL) ? NULL : (cdofreeparam = (vala_ccode_node_unref (cdofreeparam), NULL));
		(cunsetcall == NULL) ? NULL : (cunsetcall = (vala_ccode_node_unref (cunsetcall), NULL));
		(cfreeparams == NULL) ? NULL : (cfreeparams = (vala_ccode_node_unref (cfreeparams), NULL));
	}
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		ValaCCodeExpression* cresult;
		char* _tmp40;
		gboolean _tmp41;
		ValaCCodeReturnStatement* creturn;
		cresult = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		_tmp40 = NULL;
		if ((_tmp41 = (_tmp40 = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)) != NULL, _tmp40 = (g_free (_tmp40), NULL), _tmp41)) {
			ValaCCodeExpression* _tmp43;
			char* _tmp42;
			_tmp43 = NULL;
			_tmp42 = NULL;
			cresult = (_tmp43 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cresult, _tmp42 = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)), (cresult == NULL) ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL)), _tmp43);
			_tmp42 = (g_free (_tmp42), NULL);
		}
		creturn = vala_ccode_return_statement_new (NULL);
		vala_ccode_return_statement_set_return_expression (creturn, cresult);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) creturn);
		(cresult == NULL) ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL));
		(creturn == NULL) ? NULL : (creturn = (vala_ccode_node_unref (creturn), NULL));
	}
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
}


static void vala_ccode_method_module_class_init (ValaCCodeMethodModuleClass * klass) {
	vala_ccode_method_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->method_has_wrapper = vala_ccode_method_module_real_method_has_wrapper;
	VALA_CCODE_MODULE_CLASS (klass)->get_custom_creturn_type = vala_ccode_method_module_real_get_custom_creturn_type;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_method_result_declaration = vala_ccode_method_module_real_generate_method_result_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_ccode_method_module_real_visit_method;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_method_module_real_generate_parameter;
	VALA_CCODE_MODULE_CLASS (klass)->generate_cparameters = vala_ccode_method_module_real_generate_cparameters;
	VALA_CCODE_MODULE_CLASS (klass)->visit_creation_method = vala_ccode_method_module_real_visit_creation_method;
}


static void vala_ccode_method_module_instance_init (ValaCCodeMethodModule * self) {
}


GType vala_ccode_method_module_get_type (void) {
	static GType vala_ccode_method_module_type_id = 0;
	if (vala_ccode_method_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodModule), 0, (GInstanceInitFunc) vala_ccode_method_module_instance_init, NULL };
		vala_ccode_method_module_type_id = g_type_register_static (VALA_TYPE_CCODE_STRUCT_MODULE, "ValaCCodeMethodModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_module_type_id;
}




