/* valaccodeconditionalexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeconditionalexpression.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeConditionalExpressionPrivate {
	ValaCCodeExpression* _condition;
	ValaCCodeExpression* _true_expression;
	ValaCCodeExpression* _false_expression;
};

#define VALA_CCODE_CONDITIONAL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION, ValaCCodeConditionalExpressionPrivate))
enum  {
	VALA_CCODE_CONDITIONAL_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_conditional_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_conditional_expression_real_write_inner (ValaCCodeExpression* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_conditional_expression_parent_class = NULL;
static void vala_ccode_conditional_expression_finalize (ValaCCodeNode* obj);



ValaCCodeConditionalExpression* vala_ccode_conditional_expression_construct (GType object_type, ValaCCodeExpression* cond, ValaCCodeExpression* true_expr, ValaCCodeExpression* false_expr) {
	ValaCCodeConditionalExpression* self;
	g_return_val_if_fail (cond != NULL, NULL);
	g_return_val_if_fail (true_expr != NULL, NULL);
	g_return_val_if_fail (false_expr != NULL, NULL);
	self = (ValaCCodeConditionalExpression*) g_type_create_instance (object_type);
	vala_ccode_conditional_expression_set_condition (self, cond);
	vala_ccode_conditional_expression_set_true_expression (self, true_expr);
	vala_ccode_conditional_expression_set_false_expression (self, false_expr);
	return self;
}


ValaCCodeConditionalExpression* vala_ccode_conditional_expression_new (ValaCCodeExpression* cond, ValaCCodeExpression* true_expr, ValaCCodeExpression* false_expr) {
	return vala_ccode_conditional_expression_construct (VALA_TYPE_CCODE_CONDITIONAL_EXPRESSION, cond, true_expr, false_expr);
}


static void vala_ccode_conditional_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeConditionalExpression * self;
	self = (ValaCCodeConditionalExpression*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_expression_write_inner (self->priv->_condition, writer);
	vala_ccode_writer_write_string (writer, " ? ");
	vala_ccode_expression_write_inner (self->priv->_true_expression, writer);
	vala_ccode_writer_write_string (writer, " : ");
	vala_ccode_expression_write_inner (self->priv->_false_expression, writer);
}


static void vala_ccode_conditional_expression_real_write_inner (ValaCCodeExpression* base, ValaCCodeWriter* writer) {
	ValaCCodeConditionalExpression * self;
	self = (ValaCCodeConditionalExpression*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(");
	vala_ccode_node_write ((ValaCCodeNode*) self, writer);
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeExpression* vala_ccode_conditional_expression_get_condition (ValaCCodeConditionalExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_condition;
}


void vala_ccode_conditional_expression_set_condition (ValaCCodeConditionalExpression* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_condition == NULL) ? NULL : (self->priv->_condition = (vala_ccode_node_unref (self->priv->_condition), NULL)), _tmp2);
}


ValaCCodeExpression* vala_ccode_conditional_expression_get_true_expression (ValaCCodeConditionalExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_true_expression;
}


void vala_ccode_conditional_expression_set_true_expression (ValaCCodeConditionalExpression* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_true_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_true_expression == NULL) ? NULL : (self->priv->_true_expression = (vala_ccode_node_unref (self->priv->_true_expression), NULL)), _tmp2);
}


ValaCCodeExpression* vala_ccode_conditional_expression_get_false_expression (ValaCCodeConditionalExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_false_expression;
}


void vala_ccode_conditional_expression_set_false_expression (ValaCCodeConditionalExpression* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_false_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_false_expression == NULL) ? NULL : (self->priv->_false_expression = (vala_ccode_node_unref (self->priv->_false_expression), NULL)), _tmp2);
}


static void vala_ccode_conditional_expression_class_init (ValaCCodeConditionalExpressionClass * klass) {
	vala_ccode_conditional_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_conditional_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeConditionalExpressionPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_conditional_expression_real_write;
	VALA_CCODE_EXPRESSION_CLASS (klass)->write_inner = vala_ccode_conditional_expression_real_write_inner;
}


static void vala_ccode_conditional_expression_instance_init (ValaCCodeConditionalExpression * self) {
	self->priv = VALA_CCODE_CONDITIONAL_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_conditional_expression_finalize (ValaCCodeNode* obj) {
	ValaCCodeConditionalExpression * self;
	self = VALA_CCODE_CONDITIONAL_EXPRESSION (obj);
	(self->priv->_condition == NULL) ? NULL : (self->priv->_condition = (vala_ccode_node_unref (self->priv->_condition), NULL));
	(self->priv->_true_expression == NULL) ? NULL : (self->priv->_true_expression = (vala_ccode_node_unref (self->priv->_true_expression), NULL));
	(self->priv->_false_expression == NULL) ? NULL : (self->priv->_false_expression = (vala_ccode_node_unref (self->priv->_false_expression), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_conditional_expression_parent_class)->finalize (obj);
}


GType vala_ccode_conditional_expression_get_type (void) {
	static GType vala_ccode_conditional_expression_type_id = 0;
	if (vala_ccode_conditional_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeConditionalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_conditional_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeConditionalExpression), 0, (GInstanceInitFunc) vala_ccode_conditional_expression_instance_init, NULL };
		vala_ccode_conditional_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeConditionalExpression", &g_define_type_info, 0);
	}
	return vala_ccode_conditional_expression_type_id;
}




