/* libsoup-2.4.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Soup", lower_case_cprefix = "soup_")]
namespace Soup {
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Address : GLib.Object {
		[CCode (has_construct_function = false)]
		public Address.any (Soup.AddressFamily family, uint port);
		public static bool equal_by_ip (void* addr1, void* addr2);
		public static bool equal_by_name (void* addr1, void* addr2);
		[CCode (has_construct_function = false)]
		public Address.from_sockaddr (void* sa, int len);
		public unowned string get_name ();
		public unowned string get_physical ();
		public uint get_port ();
		public void* get_sockaddr (int len);
		public static uint hash_by_ip (void* addr);
		public static uint hash_by_name (void* addr);
		public bool is_resolved ();
		[CCode (has_construct_function = false)]
		public Address (string name, uint port);
		public void resolve_async (GLib.MainContext async_context, GLib.Cancellable cancellable, Soup.AddressCallback callback);
		public uint resolve_sync (GLib.Cancellable cancellable);
		[NoAccessorMethod]
		public Soup.AddressFamily family { get; construct; }
		public string name { get; construct; }
		public string physical { get; }
		public int port { get; construct; }
		public void* sockaddr { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Auth : GLib.Object {
		public virtual void authenticate (string username, string password);
		public void free_protection_space (GLib.SList space);
		public virtual unowned string get_authorization (Soup.Message msg);
		public unowned string get_host ();
		public unowned string get_info ();
		public virtual unowned GLib.SList get_protection_space (Soup.URI source_uri);
		public unowned string get_realm ();
		public unowned string get_scheme_name ();
		[CCode (has_construct_function = false)]
		public Auth (GLib.Type type, Soup.Message msg, string auth_header);
		public virtual bool update (Soup.Message msg, string auth_header);
		public string host { get; construct; }
		[NoAccessorMethod]
		public bool is_authenticated { get; }
		[NoAccessorMethod]
		public bool is_for_proxy { get; construct; }
		public string realm { get; construct; }
		public string scheme_name { get; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class AuthDomain : GLib.Object {
		public virtual unowned string accepts (Soup.Message msg);
		public void add_path (string path);
		public virtual unowned string challenge (Soup.Message msg);
		public virtual bool check_password (Soup.Message msg, string username, string password);
		public bool covers (Soup.Message msg);
		public unowned string get_realm ();
		public void remove_path (string path);
		public void set_filter (Soup.AuthDomainFilter filter, void* filter_data, GLib.DestroyNotify dnotify);
		public void set_generic_auth_callback (Soup.AuthDomainGenericAuthCallback auth_callback, void* auth_data, GLib.DestroyNotify dnotify);
		public bool try_generic_auth_callback (Soup.Message msg, string username);
		[NoAccessorMethod]
		public void* filter { get; set; }
		[NoAccessorMethod]
		public void* filter_data { get; set; }
		[NoAccessorMethod]
		public void* generic_auth_callback { get; set; }
		[NoAccessorMethod]
		public void* generic_auth_data { get; set; }
		[NoAccessorMethod]
		public bool proxy { get; construct; }
		public string realm { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class AuthDomainBasic : Soup.AuthDomain {
		[CCode (type = "SoupAuthDomain*", has_construct_function = false)]
		public AuthDomainBasic (string optname1);
		public static void set_auth_callback (Soup.AuthDomain domain, Soup.AuthDomainBasicAuthCallback callback, GLib.DestroyNotify dnotify);
		[NoAccessorMethod]
		public void* auth_callback { get; set; }
		[NoAccessorMethod]
		public void* auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class AuthDomainDigest : Soup.AuthDomain {
		public static unowned string encode_password (string username, string realm, string password);
		[CCode (type = "SoupAuthDomain*", has_construct_function = false)]
		public AuthDomainDigest (string optname1);
		public static void set_auth_callback (Soup.AuthDomain domain, Soup.AuthDomainDigestAuthCallback callback, GLib.DestroyNotify dnotify);
		[NoAccessorMethod]
		public void* auth_callback { get; set; }
		[NoAccessorMethod]
		public void* auth_data { get; set; }
	}
	[Compact]
	[CCode (copy_function = "soup_buffer_copy", type_id = "SOUP_TYPE_BUFFER", cheader_filename = "libsoup/soup.h")]
	public class Buffer {
		public weak string data;
		public size_t length;
		public unowned Soup.Buffer copy ();
		public void* get_owner ();
		[CCode (has_construct_function = false)]
		public Buffer (Soup.MemoryUse use, void* data, size_t length);
		[CCode (has_construct_function = false)]
		public Buffer.subbuffer (Soup.Buffer parent, size_t offset, size_t length);
		[CCode (has_construct_function = false)]
		public Buffer.with_owner (void* data, size_t length, void* owner, GLib.DestroyNotify owner_dnotify);
	}
	[Compact]
	[CCode (type_id = "SOUP_TYPE_BYTE_ARRAY", cheader_filename = "libsoup/soup.h")]
	public class ByteArray {
	}
	[Compact]
	[CCode (type_id = "SOUP_TYPE_CLIENT_CONTEXT", cheader_filename = "libsoup/soup.h")]
	public class ClientContext {
		public unowned Soup.Address get_address ();
		public unowned Soup.AuthDomain get_auth_domain ();
		public unowned string get_auth_user ();
		public unowned string get_host ();
		public unowned Soup.Socket get_socket ();
	}
	[Compact]
	[CCode (copy_function = "soup_cookie_copy", type_id = "SOUP_TYPE_COOKIE", cheader_filename = "libsoup/soup.h")]
	public class Cookie {
		public weak string domain;
		public weak Soup.Date expires;
		public bool http_only;
		public weak string name;
		public weak string path;
		public bool secure;
		public weak string value;
		public bool applies_to_uri (Soup.URI uri);
		public unowned Soup.Cookie copy ();
		public bool equal (Soup.Cookie cookie2);
		[CCode (has_construct_function = false)]
		public Cookie (string name, string value, string domain, string path, int max_age);
		public static unowned Soup.Cookie parse (string header, Soup.URI origin);
		public void set_domain (string domain);
		public void set_expires (Soup.Date expires);
		public void set_http_only (bool http_only);
		public void set_max_age (int max_age);
		public void set_name (string name);
		public void set_path (string path);
		public void set_secure (bool secure);
		public void set_value (string value);
		public unowned string to_cookie_header ();
		public unowned string to_set_cookie_header ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class CookieJar : GLib.Object, Soup.SessionFeature {
		public void add_cookie (Soup.Cookie cookie);
		public unowned GLib.SList all_cookies ();
		public void delete_cookie (Soup.Cookie cookie);
		public unowned string get_cookies (Soup.URI uri, bool for_http);
		[CCode (has_construct_function = false)]
		public CookieJar ();
		public virtual void save ();
		public void set_cookie (Soup.URI uri, string cookie);
		[NoAccessorMethod]
		public bool read_only { get; construct; }
		public virtual signal void changed (Soup.Cookie old_cookie, Soup.Cookie new_cookie);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class CookieJarText : Soup.CookieJar, Soup.SessionFeature {
		[CCode (type = "SoupCookieJar*", has_construct_function = false)]
		public CookieJarText (string filename, bool read_only);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[Compact]
	[CCode (copy_function = "soup_date_copy", type_id = "SOUP_TYPE_DATE", cheader_filename = "libsoup/soup.h")]
	public class Date {
		public int day;
		public int hour;
		public int minute;
		public int month;
		public int offset;
		public int second;
		public bool utc;
		public int year;
		public unowned Soup.Date copy ();
		[CCode (has_construct_function = false)]
		public Date.from_now (int offset_seconds);
		[CCode (has_construct_function = false)]
		public Date.from_string (string date_string);
		[CCode (has_construct_function = false)]
		public Date.from_time_t (ulong when);
		public bool is_past ();
		[CCode (has_construct_function = false)]
		public Date (int year, int month, int day, int hour, int minute, int second);
		public unowned string to_string (Soup.DateFormat format);
		public ulong to_time_t ();
		public void to_timeval (GLib.TimeVal time);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Logger : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public Logger (Soup.LoggerLogLevel level, int max_body_size);
		public void set_printer (Soup.LoggerPrinter printer, void* printer_data, GLib.DestroyNotify destroy);
		public void set_request_filter (Soup.LoggerFilter request_filter, void* filter_data, GLib.DestroyNotify destroy);
		public void set_response_filter (Soup.LoggerFilter response_filter, void* filter_data, GLib.DestroyNotify destroy);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Message : GLib.Object {
		public weak Soup.MessageBody request_body;
		public weak Soup.MessageHeaders request_headers;
		public weak Soup.MessageBody response_body;
		public weak Soup.MessageHeaders response_headers;
		public uint add_header_handler (string @signal, string header, GLib.Callback callback);
		public uint add_status_code_handler (string @signal, uint status_code, GLib.Callback callback);
		[CCode (has_construct_function = false)]
		public Message.from_uri (string method, Soup.URI uri);
		public unowned Soup.Address get_address ();
		public Soup.MessageFlags get_flags ();
		public Soup.HTTPVersion get_http_version ();
		public unowned Soup.URI get_uri ();
		public bool is_keepalive ();
		[CCode (has_construct_function = false)]
		public Message (string method, string uri_string);
		public void set_chunk_allocator (Soup.ChunkAllocator allocator, GLib.DestroyNotify destroy_notify);
		public void set_flags (Soup.MessageFlags flags);
		public void set_http_version (Soup.HTTPVersion version);
		public void set_request (string content_type, Soup.MemoryUse req_use, string req_body, size_t req_length);
		public void set_response (string content_type, Soup.MemoryUse resp_use, string resp_body, size_t resp_length);
		public void set_status (uint status_code);
		public void set_status_full (uint status_code, string reason_phrase);
		public void set_uri (Soup.URI uri);
		public Soup.MessageFlags flags { get; set; }
		public Soup.HTTPVersion http_version { get; set; }
		[NoAccessorMethod]
		public string method { owned get; set; }
		[NoAccessorMethod]
		public string reason_phrase { owned get; set; }
		[NoAccessorMethod]
		public bool server_side { get; construct; }
		[NoAccessorMethod]
		public uint status_code { get; set; }
		public Soup.URI uri { get; set; }
		[HasEmitter]
		public virtual signal void finished ();
		[HasEmitter]
		public virtual signal void got_body ();
		[HasEmitter]
		public virtual signal void got_chunk (Soup.Buffer chunk);
		[HasEmitter]
		public virtual signal void got_headers ();
		[HasEmitter]
		public virtual signal void got_informational ();
		[HasEmitter]
		public virtual signal void restarted ();
		[HasEmitter]
		public virtual signal void wrote_body ();
		[HasEmitter]
		public virtual signal void wrote_body_data (Soup.Buffer p0);
		[HasEmitter]
		public virtual signal void wrote_chunk ();
		[HasEmitter]
		public virtual signal void wrote_headers ();
		[HasEmitter]
		public virtual signal void wrote_informational ();
	}
	[Compact]
	[CCode (type_id = "SOUP_TYPE_MESSAGE_BODY", cheader_filename = "libsoup/soup.h")]
	public class MessageBody {
		public weak string data;
		public int64 length;
		public void append (Soup.MemoryUse use, void* data, size_t length);
		public void append_buffer (Soup.Buffer buffer);
		public void complete ();
		public unowned Soup.Buffer flatten ();
		public bool get_accumulate ();
		public unowned Soup.Buffer get_chunk (int64 offset);
		public void got_chunk (Soup.Buffer chunk);
		[CCode (has_construct_function = false)]
		public MessageBody ();
		public void set_accumulate (bool accumulate);
		public void truncate ();
		public void wrote_chunk (Soup.Buffer chunk);
	}
	[Compact]
	[CCode (type_id = "SOUP_TYPE_MESSAGE_HEADERS", cheader_filename = "libsoup/soup.h")]
	public class MessageHeaders {
		public void append (string name, string value);
		public void clear ();
		public void @foreach (Soup.MessageHeadersForeachFunc func);
		public void free_ranges (Soup.Range ranges);
		public unowned string get (string name);
		public bool get_content_disposition (out unowned string disposition, GLib.HashTable params);
		public int64 get_content_length ();
		public bool get_content_range (int64 start, int64 end, int64 total_length);
		public unowned string get_content_type (GLib.HashTable params);
		public Soup.Encoding get_encoding ();
		public Soup.Expectation get_expectations ();
		public bool get_ranges (int64 total_length, out unowned Soup.Range ranges, int length);
		[CCode (has_construct_function = false)]
		public MessageHeaders (Soup.MessageHeadersType type);
		public void remove (string name);
		public void replace (string name, string value);
		public void set_content_disposition (string disposition, GLib.HashTable params);
		public void set_content_length (int64 content_length);
		public void set_content_range (int64 start, int64 end, int64 total_length);
		public void set_content_type (string content_type, GLib.HashTable params);
		public void set_encoding (Soup.Encoding encoding);
		public void set_expectations (Soup.Expectation expectations);
		public void set_range (int64 start, int64 end);
		public void set_ranges (Soup.Range ranges, int length);
	}
	[Compact]
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class MessageHeadersIter {
		public void* dummy;
		public void init (Soup.MessageHeaders hdrs);
		public bool next (out unowned string name, out unowned string value);
	}
	[Compact]
	[CCode (type_id = "SOUP_TYPE_MULTIPART", cheader_filename = "libsoup/soup.h")]
	public class Multipart {
		public void append_form_file (string control_name, string filename, string content_type, Soup.Buffer body);
		public void append_form_string (string control_name, string data);
		public void append_part (Soup.MessageHeaders headers, Soup.Buffer body);
		[CCode (has_construct_function = false)]
		public Multipart.from_message (Soup.MessageHeaders headers, Soup.MessageBody body);
		public int get_length ();
		public bool get_part (int part, out unowned Soup.MessageHeaders headers, out unowned Soup.Buffer body);
		[CCode (has_construct_function = false)]
		public Multipart (string mime_type);
		public void to_message (Soup.MessageHeaders dest_headers, Soup.MessageBody dest_body);
	}
	[Compact]
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Range {
		public int64 end;
		public int64 start;
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Server : GLib.Object {
		public void add_auth_domain (Soup.AuthDomain auth_domain);
		public void add_handler (string path, owned Soup.ServerCallback callback);
		public unowned GLib.MainContext get_async_context ();
		public unowned Soup.Socket get_listener ();
		public uint get_port ();
		public bool is_https ();
		[CCode (has_construct_function = false)]
		public Server (string optname1, ...);
		public void pause_message (Soup.Message msg);
		public void quit ();
		public void remove_auth_domain (Soup.AuthDomain auth_domain);
		public void remove_handler (string path);
		public void run ();
		public void run_async ();
		public void unpause_message (Soup.Message msg);
		public void* async_context { get; construct; }
		[NoAccessorMethod]
		public Soup.Address @interface { owned get; construct; }
		public uint port { get; construct; }
		[NoAccessorMethod]
		public bool raw_paths { get; construct; }
		[NoAccessorMethod]
		public string server_header { owned get; set construct; }
		[NoAccessorMethod]
		public string ssl_cert_file { owned get; construct; }
		[NoAccessorMethod]
		public string ssl_key_file { owned get; construct; }
		public virtual signal void request_aborted (Soup.Message msg, Soup.ClientContext client);
		public virtual signal void request_finished (Soup.Message msg, Soup.ClientContext client);
		public virtual signal void request_read (Soup.Message msg, Soup.ClientContext client);
		public virtual signal void request_started (Soup.Message msg, Soup.ClientContext client);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Session : GLib.Object {
		public void abort ();
		public virtual void cancel_message (Soup.Message msg, uint status_code);
		public unowned GLib.MainContext get_async_context ();
		public void pause_message (Soup.Message msg);
		public virtual void queue_message (owned Soup.Message msg, Soup.SessionCallback callback);
		public void remove_feature (Soup.SessionFeature feature);
		public virtual void requeue_message (Soup.Message msg);
		public virtual uint send_message (Soup.Message msg);
		public void unpause_message (Soup.Message msg);
		[NoAccessorMethod]
		public Soup.SessionFeature add_feature { owned get; set; }
		[NoAccessorMethod]
		public GLib.Type add_feature_by_type { get; set; }
		public void* async_context { get; construct; }
		[NoAccessorMethod]
		public uint idle_timeout { get; set; }
		[NoAccessorMethod]
		public int max_conns { get; set; }
		[NoAccessorMethod]
		public int max_conns_per_host { get; set; }
		[NoAccessorMethod]
		public Soup.URI proxy_uri { owned get; set; }
		[NoAccessorMethod]
		public GLib.Type remove_feature_by_type { get; set; }
		[NoAccessorMethod]
		public string ssl_ca_file { owned get; set; }
		[NoAccessorMethod]
		public uint timeout { get; set; }
		[NoAccessorMethod]
		public bool use_ntlm { get; set; }
		[NoAccessorMethod]
		public string user_agent { owned get; set; }
		public virtual signal void authenticate (Soup.Message msg, Soup.Auth auth, bool retrying);
		public virtual signal void request_queued (Soup.Message p0);
		public virtual signal void request_started (Soup.Message msg, Soup.Socket socket);
		public virtual signal void request_unqueued (Soup.Message p0);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class SessionAsync : Soup.Session {
		[CCode (type = "SoupSession*", has_construct_function = false)]
		public SessionAsync ();
		[CCode (type = "SoupSession*", has_construct_function = false)]
		public SessionAsync.with_options (string optname1);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class SessionSync : Soup.Session {
		[CCode (type = "SoupSession*", has_construct_function = false)]
		public SessionSync ();
		[CCode (type = "SoupSession*", has_construct_function = false)]
		public SessionSync.with_options (string optname1);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Socket : GLib.Object {
		public void connect_async (GLib.Cancellable cancellable, Soup.SocketCallback callback);
		public uint connect_sync (GLib.Cancellable cancellable);
		public void disconnect ();
		public unowned Soup.Address get_local_address ();
		public unowned Soup.Address get_remote_address ();
		public bool is_connected ();
		public bool is_ssl ();
		public bool listen ();
		[CCode (has_construct_function = false)]
		public Socket (string optname1);
		public Soup.SocketIOStatus read (void* buffer, size_t len, size_t nread, GLib.Cancellable cancellable) throws GLib.Error;
		public Soup.SocketIOStatus read_until (void* buffer, size_t len, void* boundary, size_t boundary_len, size_t nread, bool got_boundary, GLib.Cancellable cancellable) throws GLib.Error;
		public bool start_proxy_ssl (string ssl_host, GLib.Cancellable cancellable);
		public bool start_ssl (GLib.Cancellable cancellable);
		public Soup.SocketIOStatus write (void* buffer, size_t len, size_t nwrote, GLib.Cancellable cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public void* async_context { get; construct; }
		[NoAccessorMethod]
		public bool is_server { get; }
		public Soup.Address local_address { get; construct; }
		[NoAccessorMethod]
		public bool non_blocking { get; set; }
		public Soup.Address remote_address { get; construct; }
		[NoAccessorMethod]
		public void* ssl_creds { get; set; }
		[NoAccessorMethod]
		public uint timeout { get; set; }
		public virtual signal void disconnected ();
		public virtual signal void new_connection (Soup.Socket p0);
		public virtual signal void readable ();
		public virtual signal void writable ();
	}
	[Compact]
	[CCode (copy_function = "soup_uri_copy", type_id = "SOUP_TYPE_URI", cheader_filename = "libsoup/soup.h")]
	public class URI {
		public weak string fragment;
		public weak string host;
		public weak string password;
		public weak string path;
		public uint port;
		public weak string query;
		public weak string scheme;
		public weak string user;
		public Soup.URI copy ();
		public static string decode (string part);
		public static string encode (string part, string? escape_extra);
		public bool equal (Soup.URI uri2);
		[CCode (has_construct_function = false)]
		public URI (string uri_string);
		public static string normalize (string part, string unescape_extra);
		public void set_fragment (string fragment);
		public void set_host (string host);
		public void set_password (string password);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_query (string query);
		public void set_query_from_fields (...);
		public void set_query_from_form (GLib.HashTable form);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public string to_string (bool just_path_and_query);
		public bool uses_default_port ();
		[CCode (has_construct_function = false)]
		public URI.with_base (Soup.URI @base, string uri_string);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public interface ProxyResolver : Soup.SessionFeature, GLib.Object {
		public abstract void get_proxy_async (Soup.Message msg, GLib.MainContext async_context, GLib.Cancellable cancellable, Soup.ProxyResolverCallback callback);
		public abstract uint get_proxy_sync (Soup.Message msg, GLib.Cancellable cancellable, out unowned Soup.Address addr);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public interface SessionFeature : GLib.Object {
		public abstract void attach (Soup.Session session);
		public abstract void detach (Soup.Session session);
		[NoWrapper]
		public abstract void request_queued (Soup.Session session, Soup.Message msg);
		[NoWrapper]
		public abstract void request_started (Soup.Session session, Soup.Message msg, Soup.Socket socket);
		[NoWrapper]
		public abstract void request_unqueued (Soup.Session session, Soup.Message msg);
	}
	[CCode (cprefix = "SOUP_ADDRESS_FAMILY_", cheader_filename = "libsoup/soup.h")]
	public enum AddressFamily {
		INVALID,
		IPV4,
		IPV6
	}
	[CCode (cprefix = "SOUP_DATE_", cheader_filename = "libsoup/soup.h")]
	public enum DateFormat {
		HTTP,
		COOKIE,
		RFC2822,
		ISO8601_COMPACT,
		ISO8601_FULL,
		ISO8601,
		ISO8601_XMLRPC
	}
	[CCode (cprefix = "SOUP_ENCODING_", cheader_filename = "libsoup/soup.h")]
	public enum Encoding {
		UNRECOGNIZED,
		NONE,
		CONTENT_LENGTH,
		EOF,
		CHUNKED,
		BYTERANGES
	}
	[CCode (cprefix = "SOUP_EXPECTATION_", cheader_filename = "libsoup/soup.h")]
	[Flags]
	public enum Expectation {
		UNRECOGNIZED,
		CONTINUE
	}
	[CCode (cprefix = "SOUP_HTTP_", cheader_filename = "libsoup/soup.h")]
	public enum HTTPVersion {
		@1_0,
		@1_1
	}
	[CCode (cprefix = "SOUP_STATUS_", cheader_filename = "libsoup/soup.h")]
	public enum KnownStatusCode {
		NONE,
		CANCELLED,
		CANT_RESOLVE,
		CANT_RESOLVE_PROXY,
		CANT_CONNECT,
		CANT_CONNECT_PROXY,
		SSL_FAILED,
		IO_ERROR,
		MALFORMED,
		TRY_AGAIN,
		CONTINUE,
		SWITCHING_PROTOCOLS,
		PROCESSING,
		OK,
		CREATED,
		ACCEPTED,
		NON_AUTHORITATIVE,
		NO_CONTENT,
		RESET_CONTENT,
		PARTIAL_CONTENT,
		MULTI_STATUS,
		MULTIPLE_CHOICES,
		MOVED_PERMANENTLY,
		FOUND,
		MOVED_TEMPORARILY,
		SEE_OTHER,
		NOT_MODIFIED,
		USE_PROXY,
		NOT_APPEARING_IN_THIS_PROTOCOL,
		TEMPORARY_REDIRECT,
		BAD_REQUEST,
		UNAUTHORIZED,
		PAYMENT_REQUIRED,
		FORBIDDEN,
		NOT_FOUND,
		METHOD_NOT_ALLOWED,
		NOT_ACCEPTABLE,
		PROXY_AUTHENTICATION_REQUIRED,
		PROXY_UNAUTHORIZED,
		REQUEST_TIMEOUT,
		CONFLICT,
		GONE,
		LENGTH_REQUIRED,
		PRECONDITION_FAILED,
		REQUEST_ENTITY_TOO_LARGE,
		REQUEST_URI_TOO_LONG,
		UNSUPPORTED_MEDIA_TYPE,
		REQUESTED_RANGE_NOT_SATISFIABLE,
		INVALID_RANGE,
		EXPECTATION_FAILED,
		UNPROCESSABLE_ENTITY,
		LOCKED,
		FAILED_DEPENDENCY,
		INTERNAL_SERVER_ERROR,
		NOT_IMPLEMENTED,
		BAD_GATEWAY,
		SERVICE_UNAVAILABLE,
		GATEWAY_TIMEOUT,
		HTTP_VERSION_NOT_SUPPORTED,
		INSUFFICIENT_STORAGE,
		NOT_EXTENDED
	}
	[CCode (cprefix = "SOUP_LOGGER_LOG_", cheader_filename = "libsoup/soup.h")]
	public enum LoggerLogLevel {
		NONE,
		MINIMAL,
		HEADERS,
		BODY
	}
	[CCode (cprefix = "SOUP_MEMORY_", cheader_filename = "libsoup/soup.h")]
	public enum MemoryUse {
		STATIC,
		TAKE,
		COPY,
		TEMPORARY
	}
	[CCode (cprefix = "SOUP_MESSAGE_", cheader_filename = "libsoup/soup.h")]
	[Flags]
	public enum MessageFlags {
		OVERWRITE_CHUNKS,
		NO_REDIRECT
	}
	[CCode (cprefix = "SOUP_MESSAGE_HEADERS_", cheader_filename = "libsoup/soup.h")]
	public enum MessageHeadersType {
		REQUEST,
		RESPONSE,
		MULTIPART
	}
	[CCode (cprefix = "SOUP_SSL_ERROR_", cheader_filename = "libsoup/soup.h")]
	public enum SSLError {
		HANDSHAKE_NEEDS_READ,
		HANDSHAKE_NEEDS_WRITE,
		CERTIFICATE
	}
	[CCode (cprefix = "SOUP_SOCKET_", cheader_filename = "libsoup/soup.h")]
	public enum SocketIOStatus {
		OK,
		WOULD_BLOCK,
		EOF,
		ERROR
	}
	[CCode (cprefix = "SOUP_XMLRPC_ERROR_", cheader_filename = "libsoup/soup.h")]
	public enum XMLRPCError {
		ARGUMENTS,
		RETVAL
	}
	[CCode (cprefix = "SOUP_XMLRPC_FAULT_", cheader_filename = "libsoup/soup.h")]
	public enum XMLRPCFault {
		PARSE_ERROR_NOT_WELL_FORMED,
		PARSE_ERROR_UNSUPPORTED_ENCODING,
		PARSE_ERROR_INVALID_CHARACTER_FOR_ENCODING,
		SERVER_ERROR_INVALID_XML_RPC,
		SERVER_ERROR_REQUESTED_METHOD_NOT_FOUND,
		SERVER_ERROR_INVALID_METHOD_PARAMETERS,
		SERVER_ERROR_INTERNAL_XML_RPC_ERROR,
		APPLICATION_ERROR,
		SYSTEM_ERROR,
		TRANSPORT_ERROR
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void AddressCallback (Soup.Address addr, uint status);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate bool AuthDomainBasicAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username, string password);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate unowned string AuthDomainDigestAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate bool AuthDomainFilter (Soup.AuthDomain domain, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate bool AuthDomainGenericAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate unowned Soup.Buffer ChunkAllocator (Soup.Message msg, size_t max_len);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate Soup.LoggerLogLevel LoggerFilter (Soup.Logger logger, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void LoggerPrinter (Soup.Logger logger, Soup.LoggerLogLevel level, string direction, string data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void MessageHeadersForeachFunc (string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static delegate void ProxyResolverCallback (Soup.ProxyResolver p1, Soup.Message p2, uint p3, Soup.Address p4, void* p5);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void ServerCallback (Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext client);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void SessionCallback (Soup.Session session, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void SocketCallback (Soup.Socket sock, uint status);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int ADDRESS_ANY_PORT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string ADDRESS_FAMILY;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string ADDRESS_NAME;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string ADDRESS_PHYSICAL;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string ADDRESS_PORT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string ADDRESS_SOCKADDR;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int AF_INET6;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_ADD_PATH;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_BASIC_AUTH_CALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_BASIC_AUTH_DATA;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int AUTH_DOMAIN_BASIC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_DIGEST_AUTH_CALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_DIGEST_AUTH_DATA;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int AUTH_DOMAIN_DIGEST_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_FILTER;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_FILTER_DATA;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_GENERIC_AUTH_CALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_GENERIC_AUTH_DATA;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int AUTH_DOMAIN_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_PROXY;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_REALM;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_DOMAIN_REMOVE_PATH;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int AUTH_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_HOST;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_IS_AUTHENTICATED;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_IS_FOR_PROXY;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_REALM;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string AUTH_SCHEME_NAME;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_JAR_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string COOKIE_JAR_READ_ONLY;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string COOKIE_JAR_TEXT_FILENAME;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_JAR_TEXT_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_MAX_AGE_ONE_DAY;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_MAX_AGE_ONE_HOUR;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_MAX_AGE_ONE_WEEK;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int COOKIE_MAX_AGE_ONE_YEAR;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int DATE_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int FORM_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string FORM_MIME_TYPE_MULTIPART;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string FORM_MIME_TYPE_URLENCODED;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int HEADERS_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int LOGGER_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int MESSAGE_BODY_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_FLAGS;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int MESSAGE_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int MESSAGE_HEADERS_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_HTTP_VERSION;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_METHOD;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_REASON_PHRASE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_SERVER_SIDE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_STATUS_CODE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string MESSAGE_URI;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int METHOD_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int MISC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int MULTIPART_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int PROXY_RESOLVER_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_ASYNC_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int SERVER_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_INTERFACE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_PORT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_RAW_PATHS;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_SERVER_HEADER;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_SSL_CERT_FILE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SERVER_SSL_KEY_FILE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_ADD_FEATURE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_ADD_FEATURE_BY_TYPE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_ASYNC_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int SESSION_ASYNC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int SESSION_FEATURE_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int SESSION_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_IDLE_TIMEOUT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_MAX_CONNS;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_MAX_CONNS_PER_HOST;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_PROXY_URI;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_REMOVE_FEATURE_BY_TYPE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_SSL_CA_FILE;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int SESSION_SYNC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_TIMEOUT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_USER_AGENT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SESSION_USE_NTLM;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_ASYNC_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_FLAG_NONBLOCKING;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int SOCKET_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_IS_SERVER;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_LOCAL_ADDRESS;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_REMOTE_ADDRESS;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_SSL_CREDENTIALS;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const string SOCKET_TIMEOUT;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int STATUS_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int TYPES_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int URI_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int VALUE_UTILS_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public const int XMLRPC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_completion (GLib.MainContext async_context, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_idle (GLib.MainContext async_context, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_timeout (GLib.MainContext async_context, uint interval, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_free (GLib.SList cookies);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.SList cookies_from_request (Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.SList cookies_from_response (Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string cookies_to_cookie_header (GLib.SList cookies);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_to_request (GLib.SList cookies, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_to_response (GLib.SList cookies, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.HashTable form_decode (string encoded_form);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.HashTable form_decode_multipart (Soup.Message msg, string file_control_name, out unowned string filename, out unowned string content_type, out unowned Soup.Buffer file);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string form_encode (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string form_encode_datalist (void* form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string form_encode_hash (GLib.HashTable form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string form_encode_valist (string first_field, void* args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned Soup.Message form_request_new (string method, string uri, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned Soup.Message form_request_new_from_datalist (string method, string uri, void* form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned Soup.Message form_request_new_from_hash (string method, string uri, GLib.HashTable form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned Soup.Message form_request_new_from_multipart (string uri, Soup.Multipart multipart);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool header_contains (string header, string token);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_free_list (GLib.SList list);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_free_param_list (GLib.HashTable param_list);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_g_string_append_param (GLib.StringBuilder str, string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.SList header_parse_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.HashTable header_parse_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.SList header_parse_quality_list (string header, GLib.SList unacceptable);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.HashTable header_parse_semi_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse (string str, int len, Soup.MessageHeaders dest);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint headers_parse_request (string str, int len, Soup.MessageHeaders req_headers, out unowned string req_method, out unowned string req_path, Soup.HTTPVersion ver);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_response (string str, int len, Soup.MessageHeaders headers, Soup.HTTPVersion ver, uint status_code, out unowned string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_status_line (string status_line, Soup.HTTPVersion ver, uint status_code, out unowned string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark http_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark ssl_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string status_get_phrase (uint status_code);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint status_proxify (uint status_code);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool str_case_equal (void* v1, void* v2);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint str_case_hash (void* key);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_append (GLib.ValueArray array, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_append_vals (GLib.ValueArray array, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.ValueArray value_array_from_args (void* args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_array_get_nth (GLib.ValueArray array, uint index_, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_insert (GLib.ValueArray array, uint index_, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.ValueArray value_array_new ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.ValueArray value_array_new_with_vals (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_array_to_args (GLib.ValueArray array, void* args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert (GLib.HashTable hash, string key, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert_vals (GLib.HashTable hash, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert_value (GLib.HashTable hash, string key, GLib.Value value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_hash_lookup (GLib.HashTable hash, string key, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_hash_lookup_vals (GLib.HashTable hash, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.HashTable value_hash_new ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.HashTable value_hash_new_with_vals (...);
	[PrintfFormat]
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string xmlrpc_build_fault (int fault_code, string fault_format, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string xmlrpc_build_method_call (string method_name, GLib.Value[] params);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string xmlrpc_build_method_response (GLib.Value value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark xmlrpc_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	public static bool xmlrpc_extract_method_call (string method_call, int length, out unowned string method_name, ...);
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	public static bool xmlrpc_extract_method_response (string method_response, int length, ...) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark xmlrpc_fault_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool xmlrpc_parse_method_call (string method_call, int length, out unowned string method_name, out unowned GLib.ValueArray params);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool xmlrpc_parse_method_response (string method_response, int length, GLib.Value value) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	public static unowned Soup.Message xmlrpc_request_new (string uri, string method_name, ...);
	[PrintfFormat]
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void xmlrpc_set_fault (Soup.Message msg, int fault_code, string fault_format, ...);
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	public static void xmlrpc_set_response (Soup.Message msg, ...);
}
