/* valacodegenerator.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACODEGENERATOR_H__
#define __VALA_VALACODEGENERATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGeneratorPrivate ValaCodeGeneratorPrivate;

/**
 * Abstract code visitor generating code.
 */
struct _ValaCodeGenerator {
	ValaCodeVisitor parent_instance;
	ValaCodeGeneratorPrivate * priv;
};

struct _ValaCodeGeneratorClass {
	ValaCodeVisitorClass parent_class;
	void (*emit) (ValaCodeGenerator* self, ValaCodeContext* context);
};


void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context);
ValaCodeGenerator* vala_code_generator_construct (GType object_type);
ValaCodeGenerator* vala_code_generator_new (void);
GType vala_code_generator_get_type (void);


G_END_DECLS

#endif
