/* valareport.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAREPORT_H__
#define __VALA_VALAREPORT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>

G_BEGIN_DECLS



extern gint vala_report_warnings;
extern gint vala_report_errors;
extern gboolean vala_report_verbose_errors;
void vala_report_set_verbose_errors (gboolean verbose);
gint vala_report_get_warnings (void);
gint vala_report_get_errors (void);
void vala_report_report_source (ValaSourceReference* source);
void vala_report_warning (ValaSourceReference* source, const char* message);
void vala_report_error (ValaSourceReference* source, const char* message);


G_END_DECLS

#endif
