/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaobjectcreationexpression.h>
#include <gee/arraylist.h>
#include <gee/readonlylist.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valamethod.h>
#include <vala/valamemberaccess.h>
#include <vala/valamemberinitializer.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valatypesymbol.h>
#include <vala/valareport.h>
#include <vala/valasymbol.h>
#include <vala/valacreationmethod.h>
#include <vala/valaclass.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valastruct.h>
#include <vala/valavaluetype.h>
#include <vala/valaerrorcode.h>
#include <vala/valaerrortype.h>
#include <vala/valaerrordomain.h>
#include <vala/valasourcefile.h>
#include <vala/valaformalparameter.h>
#include <vala/valamethodtype.h>




struct _ValaObjectCreationExpressionPrivate {
	ValaMethod* _constructor;
	ValaMemberAccess* _member_name;
	gboolean _struct_creation;
	GeeList* argument_list;
	GeeList* object_initializer;
	ValaDataType* _data_type;
};

#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
enum  {
	VALA_OBJECT_CREATION_EXPRESSION_DUMMY_PROPERTY
};
static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
static gpointer vala_object_creation_expression_parent_class = NULL;
static void vala_object_creation_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression* vala_object_creation_expression_construct (GType object_type, ValaMemberAccess* member_name, ValaSourceReference* source_reference) {
	ValaObjectCreationExpression* self;
	g_return_val_if_fail (member_name != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference) {
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	gee_collection_add ((GeeCollection*) self->priv->argument_list, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
GeeList* vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->argument_list);
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, ValaMemberInitializer* init) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	gee_collection_add ((GeeCollection*) self->priv->object_initializer, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
GeeList* vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->object_initializer);
}


static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_object_creation_expression_get_type_reference (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_object_creation_expression_get_type_reference (self), visitor);
	}
	if (self->priv->_member_name != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_member_name, visitor);
	}
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_accept ((ValaCodeNode*) arg, visitor);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	{
		GeeIterator* _init_it;
		_init_it = gee_iterable_iterator ((GeeIterable*) self->priv->object_initializer);
		while (gee_iterator_next (_init_it)) {
			ValaMemberInitializer* init;
			init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
			vala_code_node_accept ((ValaCodeNode*) init, visitor);
			(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
		}
		(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
	}
}


static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaObjectCreationExpression * self;
	gint index;
	gboolean _tmp0;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	index = gee_list_index_of (self->priv->argument_list, old_node);
	_tmp0 = FALSE;
	if (index >= 0) {
		_tmp0 = vala_code_node_get_parent_node ((ValaCodeNode*) new_node) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gee_list_set ((GeeList*) self->priv->argument_list, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	return FALSE;
}


static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_object_creation_expression_get_type_reference (self) == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaObjectCreationExpression * self;
	ValaTypeSymbol* type;
	ValaDataType* _tmp26;
	GeeList* _tmp27;
	gint _tmp28;
	gint given_num_type_args;
	gint expected_num_type_args;
	gboolean _tmp41;
	gboolean _tmp60;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (self->priv->_member_name != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_member_name, analyzer);
	}
	type = NULL;
	if (vala_object_creation_expression_get_type_reference (self) == NULL) {
		ValaSymbol* _tmp3;
		ValaSymbol* constructor_sym;
		ValaSymbol* _tmp4;
		ValaSymbol* type_sym;
		GeeList* type_args;
		if (self->priv->_member_name == NULL) {
			gboolean _tmp1;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Incomplete object creation expression");
			return (_tmp1 = FALSE, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1);
		}
		if (vala_expression_get_symbol_reference ((ValaExpression*) self->priv->_member_name) == NULL) {
			gboolean _tmp2;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			return (_tmp2 = FALSE, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2);
		}
		_tmp3 = NULL;
		constructor_sym = (_tmp3 = vala_expression_get_symbol_reference ((ValaExpression*) self->priv->_member_name), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
		_tmp4 = NULL;
		type_sym = (_tmp4 = vala_expression_get_symbol_reference ((ValaExpression*) self->priv->_member_name), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		type_args = vala_member_access_get_type_arguments (self->priv->_member_name);
		if (VALA_IS_METHOD (constructor_sym)) {
			ValaSymbol* _tmp6;
			ValaSymbol* _tmp5;
			ValaMethod* _tmp7;
			ValaMethod* constructor;
			ValaMemberAccess* _tmp12;
			ValaExpression* _tmp11;
			ValaMemberAccess* ma;
			_tmp6 = NULL;
			_tmp5 = NULL;
			type_sym = (_tmp6 = (_tmp5 = vala_symbol_get_parent_symbol (constructor_sym), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5)), (type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)), _tmp6);
			_tmp7 = NULL;
			constructor = (_tmp7 = VALA_METHOD (constructor_sym), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
			if (!(VALA_IS_CREATION_METHOD (constructor_sym))) {
				char* _tmp9;
				char* _tmp8;
				gboolean _tmp10;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp9 = NULL;
				_tmp8 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp9 = g_strdup_printf ("`%s' is not a creation method", _tmp8 = vala_symbol_get_full_name ((ValaSymbol*) constructor)));
				_tmp9 = (g_free (_tmp9), NULL);
				_tmp8 = (g_free (_tmp8), NULL);
				return (_tmp10 = FALSE, (constructor == NULL) ? NULL : (constructor = (vala_code_node_unref (constructor), NULL)), (constructor_sym == NULL) ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL)), (type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)), (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp10);
			}
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) constructor);
			/* inner expression can also be base access when chaining constructors*/
			_tmp12 = NULL;
			_tmp11 = NULL;
			ma = (_tmp12 = (_tmp11 = vala_member_access_get_inner (self->priv->_member_name), VALA_IS_MEMBER_ACCESS (_tmp11) ? ((ValaMemberAccess*) _tmp11) : NULL), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
			if (ma != NULL) {
				GeeList* _tmp13;
				_tmp13 = NULL;
				type_args = (_tmp13 = vala_member_access_get_type_arguments (ma), (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), _tmp13);
			}
			(constructor == NULL) ? NULL : (constructor = (vala_code_node_unref (constructor), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		if (VALA_IS_CLASS (type_sym)) {
			ValaTypeSymbol* _tmp15;
			ValaTypeSymbol* _tmp14;
			ValaObjectType* _tmp16;
			_tmp15 = NULL;
			_tmp14 = NULL;
			type = (_tmp15 = (_tmp14 = VALA_TYPESYMBOL (type_sym), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp15);
			_tmp16 = NULL;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) (_tmp16 = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (type))));
			(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL));
		} else {
			if (VALA_IS_STRUCT (type_sym)) {
				ValaTypeSymbol* _tmp18;
				ValaTypeSymbol* _tmp17;
				ValaValueType* _tmp19;
				_tmp18 = NULL;
				_tmp17 = NULL;
				type = (_tmp18 = (_tmp17 = VALA_TYPESYMBOL (type_sym), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp18);
				_tmp19 = NULL;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) (_tmp19 = vala_value_type_new (type)));
				(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_code_node_unref (_tmp19), NULL));
			} else {
				if (VALA_IS_ERROR_CODE (type_sym)) {
					ValaErrorType* _tmp20;
					_tmp20 = NULL;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) (_tmp20 = vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (type_sym)), VALA_ERROR_CODE (type_sym), vala_code_node_get_source_reference ((ValaCodeNode*) self))));
					(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL));
					vala_expression_set_symbol_reference ((ValaExpression*) self, type_sym);
				} else {
					char* _tmp22;
					char* _tmp21;
					gboolean _tmp23;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp22 = NULL;
					_tmp21 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp22 = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp21 = vala_symbol_get_full_name (type_sym)));
					_tmp22 = (g_free (_tmp22), NULL);
					_tmp21 = (g_free (_tmp21), NULL);
					return (_tmp23 = FALSE, (constructor_sym == NULL) ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL)), (type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)), (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp23);
				}
			}
		}
		{
			GeeIterator* _type_arg_it;
			_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_args);
			while (gee_iterator_next (_type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				vala_data_type_add_type_argument (vala_object_creation_expression_get_type_reference (self), type_arg);
				vala_source_file_add_type_dependency (vala_semantic_analyzer_get_current_source_file (analyzer), type_arg, VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
		(constructor_sym == NULL) ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL));
		(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
		(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
	} else {
		ValaTypeSymbol* _tmp25;
		ValaTypeSymbol* _tmp24;
		_tmp25 = NULL;
		_tmp24 = NULL;
		type = (_tmp25 = (_tmp24 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (self)), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp25);
	}
	vala_source_file_add_symbol_dependency (vala_semantic_analyzer_get_current_source_file (analyzer), (ValaSymbol*) type, VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	_tmp26 = NULL;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp26 = vala_data_type_copy (vala_object_creation_expression_get_type_reference (self)));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL));
	vala_data_type_set_value_owned (vala_expression_get_value_type ((ValaExpression*) self), TRUE);
	_tmp27 = NULL;
	given_num_type_args = (_tmp28 = gee_collection_get_size ((GeeCollection*) (_tmp27 = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (self)))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
	expected_num_type_args = 0;
	if (VALA_IS_CLASS (type)) {
		ValaClass* _tmp29;
		ValaClass* cl;
		GeeList* _tmp30;
		_tmp29 = NULL;
		cl = (_tmp29 = VALA_CLASS (type), (_tmp29 == NULL) ? NULL : vala_code_node_ref (_tmp29));
		_tmp30 = NULL;
		expected_num_type_args = gee_collection_get_size ((GeeCollection*) (_tmp30 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl)));
		(_tmp30 == NULL) ? NULL : (_tmp30 = (gee_collection_object_unref (_tmp30), NULL));
		if (self->priv->_struct_creation) {
			gboolean _tmp31;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "syntax error, use `new' to create new objects");
			return (_tmp31 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp31);
		}
		if (vala_class_get_is_abstract (cl)) {
			char* _tmp33;
			char* _tmp32;
			gboolean _tmp34;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp33 = NULL;
			_tmp32 = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp33 = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp32 = vala_symbol_get_full_name ((ValaSymbol*) cl)));
			_tmp33 = (g_free (_tmp33), NULL);
			_tmp32 = (g_free (_tmp32), NULL);
			return (_tmp34 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp34);
		}
		if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) vala_class_get_default_construction_method (cl));
		}
		while (cl != NULL) {
			ValaClass* _tmp36;
			ValaClass* _tmp35;
			if (VALA_TYPESYMBOL (cl) == analyzer->initially_unowned_type) {
				vala_data_type_set_floating_reference (vala_expression_get_value_type ((ValaExpression*) self), TRUE);
				break;
			}
			_tmp36 = NULL;
			_tmp35 = NULL;
			cl = (_tmp36 = (_tmp35 = vala_class_get_base_class (cl), (_tmp35 == NULL) ? NULL : vala_code_node_ref (_tmp35)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp36);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		if (VALA_IS_STRUCT (type)) {
			ValaStruct* _tmp37;
			ValaStruct* st;
			GeeList* _tmp38;
			_tmp37 = NULL;
			st = (_tmp37 = VALA_STRUCT (type), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
			_tmp38 = NULL;
			expected_num_type_args = gee_collection_get_size ((GeeCollection*) (_tmp38 = vala_struct_get_type_parameters (st)));
			(_tmp38 == NULL) ? NULL : (_tmp38 = (gee_collection_object_unref (_tmp38), NULL));
			if (!self->priv->_struct_creation) {
				vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) self), "deprecated syntax, don't use `new' to initialize structs");
			}
			if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) vala_struct_get_default_construction_method (st));
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		gboolean _tmp39;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "too few type arguments");
		return (_tmp39 = FALSE, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp39);
	} else {
		if (expected_num_type_args < given_num_type_args) {
			gboolean _tmp40;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "too many type arguments");
			return (_tmp40 = FALSE, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp40);
		}
	}
	_tmp41 = FALSE;
	if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
		GeeList* _tmp42;
		_tmp42 = NULL;
		_tmp41 = gee_collection_get_size ((GeeCollection*) (_tmp42 = vala_object_creation_expression_get_argument_list (self))) != 0;
		(_tmp42 == NULL) ? NULL : (_tmp42 = (gee_collection_object_unref (_tmp42), NULL));
	} else {
		_tmp41 = FALSE;
	}
	if (_tmp41) {
		char* _tmp44;
		char* _tmp43;
		gboolean _tmp45;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp44 = NULL;
		_tmp43 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp44 = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp43 = vala_symbol_get_full_name ((ValaSymbol*) type)));
		_tmp44 = (g_free (_tmp44), NULL);
		_tmp43 = (g_free (_tmp43), NULL);
		return (_tmp45 = FALSE, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp45);
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
		ValaMethod* _tmp46;
		ValaMethod* m;
		GeeList* args;
		GeeIterator* arg_it;
		GeeList* _tmp50;
		ValaMethodType* _tmp49;
		_tmp46 = NULL;
		m = (_tmp46 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp46 == NULL) ? NULL : vala_code_node_ref (_tmp46));
		args = vala_object_creation_expression_get_argument_list (self);
		arg_it = gee_iterable_iterator ((GeeIterable*) args);
		{
			GeeList* _tmp47;
			GeeIterator* _tmp48;
			GeeIterator* _param_it;
			_tmp47 = NULL;
			_tmp48 = NULL;
			_param_it = (_tmp48 = gee_iterable_iterator ((GeeIterable*) (_tmp47 = vala_method_get_parameters (m))), (_tmp47 == NULL) ? NULL : (_tmp47 = (gee_collection_object_unref (_tmp47), NULL)), _tmp48);
			while (gee_iterator_next (_param_it)) {
				ValaFormalParameter* param;
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				if (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					/* store expected type for callback parameters */
					vala_expression_set_target_type (arg, vala_formal_parameter_get_parameter_type (param));
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
		{
			GeeIterator* _arg_it;
			_arg_it = gee_iterable_iterator ((GeeIterable*) args);
			while (gee_iterator_next (_arg_it)) {
				ValaExpression* arg;
				arg = (ValaExpression*) gee_iterator_get (_arg_it);
				vala_code_node_check ((ValaCodeNode*) arg, analyzer);
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
		}
		_tmp50 = NULL;
		_tmp49 = NULL;
		vala_semantic_analyzer_check_arguments (analyzer, (ValaExpression*) self, (ValaDataType*) (_tmp49 = vala_method_type_new (m)), _tmp50 = vala_method_get_parameters (m), args);
		(_tmp50 == NULL) ? NULL : (_tmp50 = (gee_collection_object_unref (_tmp50), NULL));
		(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_code_node_unref (_tmp49), NULL));
		{
			GeeList* _tmp51;
			GeeIterator* _tmp52;
			GeeIterator* _error_type_it;
			_tmp51 = NULL;
			_tmp52 = NULL;
			_error_type_it = (_tmp52 = gee_iterable_iterator ((GeeIterable*) (_tmp51 = vala_code_node_get_error_types ((ValaCodeNode*) m))), (_tmp51 == NULL) ? NULL : (_tmp51 = (gee_collection_object_unref (_tmp51), NULL)), _tmp52);
			while (gee_iterator_next (_error_type_it)) {
				ValaDataType* error_type;
				ValaDataType* call_error_type;
				error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
				/* ensure we can trace back which expression may throw errors of this type*/
				call_error_type = vala_data_type_copy (error_type);
				vala_code_node_set_source_reference ((ValaCodeNode*) call_error_type, vala_code_node_get_source_reference ((ValaCodeNode*) self));
				vala_code_node_add_error_type ((ValaCodeNode*) self, call_error_type);
				(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
				(call_error_type == NULL) ? NULL : (call_error_type = (vala_code_node_unref (call_error_type), NULL));
			}
			(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		(args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL));
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_object_creation_expression_get_type_reference (self))) {
			GeeList* _tmp53;
			gboolean _tmp54;
			if (vala_object_creation_expression_get_type_reference (self) != NULL) {
				vala_code_node_check ((ValaCodeNode*) vala_object_creation_expression_get_type_reference (self), analyzer);
			}
			if (self->priv->_member_name != NULL) {
				vala_code_node_check ((ValaCodeNode*) self->priv->_member_name, analyzer);
			}
			{
				GeeIterator* _arg_it;
				_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					vala_code_node_check ((ValaCodeNode*) arg, analyzer);
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeIterator* _init_it;
				_init_it = gee_iterable_iterator ((GeeIterable*) self->priv->object_initializer);
				while (gee_iterator_next (_init_it)) {
					ValaMemberInitializer* init;
					init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
					vala_code_node_check ((ValaCodeNode*) init, analyzer);
					(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
				}
				(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
			}
			_tmp53 = NULL;
			if ((_tmp54 = gee_collection_get_size ((GeeCollection*) (_tmp53 = vala_object_creation_expression_get_argument_list (self))) == 0, (_tmp53 == NULL) ? NULL : (_tmp53 = (gee_collection_object_unref (_tmp53), NULL)), _tmp54)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Too few arguments, errors need at least 1 argument");
			} else {
				GeeList* _tmp55;
				GeeIterator* _tmp56;
				GeeIterator* arg_it;
				ValaExpression* ex;
				gboolean _tmp57;
				_tmp55 = NULL;
				_tmp56 = NULL;
				arg_it = (_tmp56 = gee_iterable_iterator ((GeeIterable*) (_tmp55 = vala_object_creation_expression_get_argument_list (self))), (_tmp55 == NULL) ? NULL : (_tmp55 = (gee_collection_object_unref (_tmp55), NULL)), _tmp56);
				gee_iterator_next (arg_it);
				ex = (ValaExpression*) gee_iterator_get (arg_it);
				_tmp57 = FALSE;
				if (vala_expression_get_value_type (ex) == NULL) {
					_tmp57 = TRUE;
				} else {
					_tmp57 = !vala_data_type_compatible (vala_expression_get_value_type (ex), analyzer->string_type);
				}
				if (_tmp57) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Invalid type for argument 1");
				}
				(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
				(ex == NULL) ? NULL : (ex = (vala_code_node_unref (ex), NULL));
			}
		}
	}
	{
		GeeList* _tmp58;
		GeeIterator* _tmp59;
		GeeIterator* _init_it;
		_tmp58 = NULL;
		_tmp59 = NULL;
		_init_it = (_tmp59 = gee_iterable_iterator ((GeeIterable*) (_tmp58 = vala_object_creation_expression_get_object_initializer (self))), (_tmp58 == NULL) ? NULL : (_tmp58 = (gee_collection_object_unref (_tmp58), NULL)), _tmp59);
		while (gee_iterator_next (_init_it)) {
			ValaMemberInitializer* init;
			init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
			vala_semantic_analyzer_visit_member_initializer (analyzer, init, vala_object_creation_expression_get_type_reference (self));
			(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
		}
		(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
	}
	return (_tmp60 = !vala_code_node_get_error ((ValaCodeNode*) self), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp60);
}


static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_get_defined_variables ((ValaCodeNode*) arg, collection);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
}


static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_get_used_variables ((ValaCodeNode*) arg, collection);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
}


ValaDataType* vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_data_type;
}


void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_data_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_data_type == NULL) ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_data_type, (ValaCodeNode*) self);
}


ValaMethod* vala_object_creation_expression_get_constructor (ValaObjectCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_constructor;
}


void vala_object_creation_expression_set_constructor (ValaObjectCreationExpression* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_constructor = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_constructor == NULL) ? NULL : (self->priv->_constructor = (vala_code_node_unref (self->priv->_constructor), NULL)), _tmp2);
}


ValaMemberAccess* vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_member_name;
}


void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, ValaMemberAccess* value) {
	ValaMemberAccess* _tmp2;
	ValaMemberAccess* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_member_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_member_name == NULL) ? NULL : (self->priv->_member_name = (vala_code_node_unref (self->priv->_member_name), NULL)), _tmp2);
}


gboolean vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_struct_creation;
}


void vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass) {
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_object_creation_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_object_creation_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_object_creation_expression_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_object_creation_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_object_creation_expression_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_object_creation_expression_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_object_creation_expression_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_object_creation_expression_real_get_used_variables;
}


static void vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self) {
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	self->priv->argument_list = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->object_initializer = (GeeList*) gee_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_object_creation_expression_finalize (ValaCodeNode* obj) {
	ValaObjectCreationExpression * self;
	self = VALA_OBJECT_CREATION_EXPRESSION (obj);
	(self->priv->_constructor == NULL) ? NULL : (self->priv->_constructor = (vala_code_node_unref (self->priv->_constructor), NULL));
	(self->priv->_member_name == NULL) ? NULL : (self->priv->_member_name = (vala_code_node_unref (self->priv->_member_name), NULL));
	(self->priv->argument_list == NULL) ? NULL : (self->priv->argument_list = (gee_collection_object_unref (self->priv->argument_list), NULL));
	(self->priv->object_initializer == NULL) ? NULL : (self->priv->object_initializer = (gee_collection_object_unref (self->priv->object_initializer), NULL));
	(self->priv->_data_type == NULL) ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL));
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


GType vala_object_creation_expression_get_type (void) {
	static GType vala_object_creation_expression_type_id = 0;
	if (vala_object_creation_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	}
	return vala_object_creation_expression_type_id;
}




