/* valagasyncmodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valagasyncmodule.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodestruct.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefunction.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valacodevisitor.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valalocalvariable.h>
#include <vala/valamemberaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valaexpression.h>
#include <gobject/valaccodemethodmodule.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_GASYNC_MODULE_DUMMY_PROPERTY
};
static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt);
static gpointer vala_gasync_module_parent_class = NULL;



ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGAsyncModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGAsyncModule*) vala_gsignal_module_construct (object_type, codegen, next);
	return self;
}


ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gasync_module_construct (VALA_TYPE_GASYNC_MODULE, codegen, next);
}


static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaGAsyncModule * self;
	ValaDataType* _tmp0;
	ValaDataType* creturn_type;
	gboolean visible;
	char* _tmp2;
	char* _tmp1;
	char* _tmp3;
	char* dataname;
	char* _tmp4;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* datastruct;
	ValaCCodeTypeDefinition* _tmp12;
	ValaCCodeVariableDeclarator* _tmp11;
	char* _tmp10;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeFunction* _tmp15;
	ValaCCodeFunction* asyncfunc;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* asyncblock;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp18;
	char* _tmp19;
	ValaCCodeDeclaration* _tmp20;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp21;
	ValaCCodeExpressionStatement* _tmp24;
	ValaCCodeAssignment* _tmp23;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeMemberAccess* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeAssignment* _tmp33;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeMemberAccess* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeIdentifier* _tmp44;
	char* _tmp43;
	char* _tmp42;
	ValaCCodeFunctionCall* _tmp45;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeFormalParameter* _tmp48;
	ValaCCodeFormalParameter* _tmp49;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean _tmp50;
	char* _tmp59;
	char* _tmp58;
	char* _tmp57;
	ValaCCodeFunction* _tmp60;
	ValaCCodeFunction* finishfunc;
	GeeHashMap* _tmp61;
	ValaCCodeBlock* finishblock;
	ValaCCodeFormalParameter* _tmp62;
	gboolean _tmp63;
	gboolean _tmp97;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (m != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
	if (!vala_method_get_coroutine (m)) {
		return;
	}
	_tmp0 = NULL;
	creturn_type = (_tmp0 = vala_method_get_return_type (m), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	((ValaCCodeBaseModule*) self)->gio_h_needed = TRUE;
	/* generate struct to hold parameters, local variables, and the return value*/
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	dataname = (_tmp3 = g_strconcat (_tmp2 = vala_symbol_lower_case_to_camel_case (_tmp1 = vala_method_get_cname (m)), "Data", NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	datastruct = (_tmp5 = vala_ccode_struct_new (_tmp4 = g_strconcat ("_", dataname, NULL)), _tmp4 = (g_free (_tmp4), NULL), _tmp5);
	vala_ccode_struct_add_field (datastruct, "int", "state");
	vala_ccode_struct_add_field (datastruct, "GAsyncReadyCallback", "callback");
	vala_ccode_struct_add_field (datastruct, "gpointer", "user_data");
	vala_ccode_struct_add_field (datastruct, "GAsyncResult*", "res");
	{
		GeeList* _tmp6;
		GeeIterator* _tmp7;
		GeeIterator* _param_it;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_param_it = (_tmp7 = gee_iterable_iterator ((GeeIterable*) (_tmp6 = vala_method_get_parameters (m))), (_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)), _tmp7);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			char* _tmp8;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp8 = NULL;
			vala_ccode_struct_add_field (datastruct, _tmp8 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)), vala_symbol_get_name ((ValaSymbol*) param));
			_tmp8 = (g_free (_tmp8), NULL);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		char* _tmp9;
		_tmp9 = NULL;
		vala_ccode_struct_add_field (datastruct, _tmp9 = vala_data_type_get_cname (vala_method_get_return_type (m)), "result");
		_tmp9 = (g_free (_tmp9), NULL);
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_definition, (ValaCCodeNode*) datastruct);
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_declaration, (ValaCCodeNode*) (_tmp12 = vala_ccode_type_definition_new (_tmp10 = g_strconcat ("struct _", dataname, NULL), (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new (dataname)))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp10 = (g_free (_tmp10), NULL);
	/* generate async function*/
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp15 = NULL;
	asyncfunc = (_tmp15 = vala_ccode_function_new (_tmp14 = g_strconcat (_tmp13 = vala_method_get_real_cname (m), "_async", NULL), "void"), _tmp14 = (g_free (_tmp14), NULL), _tmp13 = (g_free (_tmp13), NULL), _tmp15);
	vala_ccode_node_set_line ((ValaCCodeNode*) asyncfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	asyncblock = vala_ccode_block_new ();
	_tmp16 = NULL;
	_tmp17 = NULL;
	dataalloc = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (dataalloc, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (dataname)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	_tmp20 = NULL;
	datadecl = (_tmp20 = vala_ccode_declaration_new (_tmp19 = g_strconcat (dataname, "*", NULL)), _tmp19 = (g_free (_tmp19), NULL), _tmp20);
	_tmp21 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp21 = vala_ccode_variable_declarator_new ("data")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) datadecl);
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp24 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) dataalloc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("data")), "callback")), (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("callback")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp34 = NULL;
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp34 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("data")), "user_data")), (ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	{
		GeeList* _tmp35;
		GeeIterator* _tmp36;
		GeeIterator* _param_it;
		_tmp35 = NULL;
		_tmp36 = NULL;
		_param_it = (_tmp36 = gee_iterable_iterator ((GeeIterable*) (_tmp35 = vala_method_get_parameters (m))), (_tmp35 == NULL) ? NULL : (_tmp35 = (gee_collection_object_unref (_tmp35), NULL)), _tmp36);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				ValaCCodeExpressionStatement* _tmp41;
				ValaCCodeAssignment* _tmp40;
				ValaCCodeIdentifier* _tmp39;
				ValaCCodeMemberAccess* _tmp38;
				ValaCCodeIdentifier* _tmp37;
				_tmp41 = NULL;
				_tmp40 = NULL;
				_tmp39 = NULL;
				_tmp38 = NULL;
				_tmp37 = NULL;
				vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp41 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp38 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("data")), vala_symbol_get_name ((ValaSymbol*) param))), (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
				(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
				(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
				(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
				(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp44 = NULL;
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp45 = NULL;
	ccall = (_tmp45 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new (_tmp43 = g_strconcat (_tmp42 = vala_method_get_real_cname (m), "_co", NULL)))), (_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)), _tmp43 = (g_free (_tmp43), NULL), _tmp42 = (g_free (_tmp42), NULL), _tmp45);
	_tmp46 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("data")));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp47 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp47 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp48 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp48 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	_tmp49 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp49 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	vdeclarator = NULL;
	_tmp50 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp50 = TRUE;
	} else {
		_tmp50 = vala_method_get_is_virtual (m);
	}
	if (_tmp50) {
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp52;
		char* _tmp51;
		vdecl = vala_ccode_declaration_new ("void");
		_tmp52 = NULL;
		_tmp51 = NULL;
		vdeclarator = (_tmp52 = vala_ccode_function_declarator_new (_tmp51 = g_strconcat (vala_method_get_vfunc_name (m), "_async", NULL)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp52);
		_tmp51 = (g_free (_tmp51), NULL);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, creturn_type, FALSE, (GeeMap*) cparam_map, asyncfunc, vdeclarator, NULL, NULL, 1);
	if (!vala_method_get_is_abstract (m)) {
		gboolean _tmp53;
		gboolean _tmp54;
		_tmp53 = FALSE;
		_tmp54 = FALSE;
		if (visible) {
			_tmp54 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp54 = FALSE;
		}
		if (_tmp54) {
			_tmp53 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp53 = FALSE;
		}
		if (_tmp53) {
			ValaCCodeFunction* _tmp55;
			_tmp55 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp55 = vala_ccode_function_copy (asyncfunc)));
			(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
		} else {
			ValaCCodeFunction* _tmp56;
			vala_ccode_function_set_modifiers (asyncfunc, vala_ccode_function_get_modifiers (asyncfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp56 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp56 = vala_ccode_function_copy (asyncfunc)));
			(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
		}
		vala_ccode_function_set_block (asyncfunc, asyncblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) asyncfunc);
	}
	/* generate finish function*/
	_tmp59 = NULL;
	_tmp58 = NULL;
	_tmp57 = NULL;
	_tmp60 = NULL;
	finishfunc = (_tmp60 = vala_ccode_function_new (_tmp58 = g_strconcat (_tmp57 = vala_method_get_real_cname (m), "_finish", NULL), _tmp59 = vala_data_type_get_cname (creturn_type)), _tmp59 = (g_free (_tmp59), NULL), _tmp58 = (g_free (_tmp58), NULL), _tmp57 = (g_free (_tmp57), NULL), _tmp60);
	vala_ccode_node_set_line ((ValaCCodeNode*) finishfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	_tmp61 = NULL;
	cparam_map = (_tmp61 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp61);
	finishblock = vala_ccode_block_new ();
	_tmp62 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp62 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	_tmp63 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp63 = TRUE;
	} else {
		_tmp63 = vala_method_get_is_virtual (m);
	}
	if (_tmp63) {
		char* _tmp64;
		ValaCCodeDeclaration* _tmp65;
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp67;
		char* _tmp66;
		_tmp64 = NULL;
		_tmp65 = NULL;
		vdecl = (_tmp65 = vala_ccode_declaration_new (_tmp64 = vala_data_type_get_cname (creturn_type)), _tmp64 = (g_free (_tmp64), NULL), _tmp65);
		_tmp67 = NULL;
		_tmp66 = NULL;
		vdeclarator = (_tmp67 = vala_ccode_function_declarator_new (_tmp66 = g_strconcat (vala_method_get_vfunc_name (m), "_finish", NULL)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp67);
		_tmp66 = (g_free (_tmp66), NULL);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, creturn_type, FALSE, (GeeMap*) cparam_map, finishfunc, vdeclarator, NULL, NULL, 2);
	if (!vala_method_get_is_abstract (m)) {
		gboolean _tmp68;
		gboolean _tmp69;
		_tmp68 = FALSE;
		_tmp69 = FALSE;
		if (visible) {
			_tmp69 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp69 = FALSE;
		}
		if (_tmp69) {
			_tmp68 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp68 = FALSE;
		}
		if (_tmp68) {
			ValaCCodeFunction* _tmp70;
			_tmp70 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp70 = vala_ccode_function_copy (finishfunc)));
			(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
		} else {
			ValaCCodeFunction* _tmp71;
			vala_ccode_function_set_modifiers (finishfunc, vala_ccode_function_get_modifiers (finishfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp71 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp71 = vala_ccode_function_copy (finishfunc)));
			(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
		}
		vala_ccode_function_set_block (finishfunc, finishblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) finishfunc);
	}
	if (!vala_method_get_is_abstract (m)) {
		char* _tmp73;
		char* _tmp72;
		ValaCCodeFunction* _tmp74;
		ValaCCodeFunction* readyfunc;
		ValaCCodeFormalParameter* _tmp75;
		ValaCCodeFormalParameter* _tmp76;
		ValaCCodeFormalParameter* _tmp77;
		ValaCCodeBlock* readyblock;
		ValaCCodeDeclaration* _tmp79;
		char* _tmp78;
		ValaCCodeVariableDeclarator* _tmp80;
		ValaCCodeExpressionStatement* _tmp84;
		ValaCCodeAssignment* _tmp83;
		ValaCCodeIdentifier* _tmp82;
		ValaCCodeIdentifier* _tmp81;
		ValaCCodeExpressionStatement* _tmp89;
		ValaCCodeAssignment* _tmp88;
		ValaCCodeIdentifier* _tmp87;
		ValaCCodeMemberAccess* _tmp86;
		ValaCCodeIdentifier* _tmp85;
		ValaCCodeFunctionCall* _tmp93;
		ValaCCodeIdentifier* _tmp92;
		char* _tmp91;
		char* _tmp90;
		ValaCCodeIdentifier* _tmp94;
		ValaCCodeExpressionStatement* _tmp95;
		ValaCCodeFunction* _tmp96;
		/* generate ready callback handler*/
		_tmp73 = NULL;
		_tmp72 = NULL;
		_tmp74 = NULL;
		readyfunc = (_tmp74 = vala_ccode_function_new (_tmp73 = g_strconcat (_tmp72 = vala_method_get_cname (m), "_ready", NULL), "void"), _tmp73 = (g_free (_tmp73), NULL), _tmp72 = (g_free (_tmp72), NULL), _tmp74);
		vala_ccode_node_set_line ((ValaCCodeNode*) readyfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		_tmp75 = NULL;
		vala_ccode_function_add_parameter (readyfunc, _tmp75 = vala_ccode_formal_parameter_new ("source_object", "GObject*"));
		(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
		_tmp76 = NULL;
		vala_ccode_function_add_parameter (readyfunc, _tmp76 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
		(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
		_tmp77 = NULL;
		vala_ccode_function_add_parameter (readyfunc, _tmp77 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
		(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
		readyblock = vala_ccode_block_new ();
		_tmp79 = NULL;
		_tmp78 = NULL;
		datadecl = (_tmp79 = vala_ccode_declaration_new (_tmp78 = g_strconcat (dataname, "*", NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), _tmp79);
		_tmp78 = (g_free (_tmp78), NULL);
		_tmp80 = NULL;
		vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp80 = vala_ccode_variable_declarator_new ("data")));
		(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) datadecl);
		_tmp84 = NULL;
		_tmp83 = NULL;
		_tmp82 = NULL;
		_tmp81 = NULL;
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp84 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp83 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
		(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
		(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
		(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
		_tmp89 = NULL;
		_tmp88 = NULL;
		_tmp87 = NULL;
		_tmp86 = NULL;
		_tmp85 = NULL;
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp89 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp88 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp86 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("data")), "res")), (ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new ("res")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
		(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
		(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
		(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
		(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
		_tmp93 = NULL;
		_tmp92 = NULL;
		_tmp91 = NULL;
		_tmp90 = NULL;
		ccall = (_tmp93 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new (_tmp91 = g_strconcat (_tmp90 = vala_method_get_real_cname (m), "_co", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp93);
		(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
		_tmp91 = (g_free (_tmp91), NULL);
		_tmp90 = (g_free (_tmp90), NULL);
		_tmp94 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("data")));
		(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
		_tmp95 = NULL;
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp95 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
		vala_ccode_function_set_modifiers (readyfunc, vala_ccode_function_get_modifiers (readyfunc) | (VALA_CCODE_MODIFIERS_STATIC));
		_tmp96 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp96 = vala_ccode_function_copy (readyfunc)));
		(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
		vala_ccode_function_set_block (readyfunc, readyblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) readyfunc);
		(readyfunc == NULL) ? NULL : (readyfunc = (vala_ccode_node_unref (readyfunc), NULL));
		(readyblock == NULL) ? NULL : (readyblock = (vala_ccode_node_unref (readyblock), NULL));
	}
	_tmp97 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp97 = TRUE;
	} else {
		_tmp97 = vala_method_get_is_virtual (m);
	}
	if (_tmp97) {
		GeeHashMap* _tmp98;
		GeeHashMap* carg_map;
		ValaCCodeFormalParameter* _tmp99;
		ValaCCodeFormalParameter* _tmp100;
		ValaCCodeIdentifier* _tmp101;
		ValaCCodeIdentifier* _tmp102;
		ValaVoidType* _tmp103;
		GeeHashMap* _tmp104;
		GeeHashMap* _tmp105;
		ValaCCodeFormalParameter* _tmp106;
		ValaCCodeIdentifier* _tmp107;
		_tmp98 = NULL;
		cparam_map = (_tmp98 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp98);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp99 = NULL;
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp99 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
		(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
		_tmp100 = NULL;
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp100 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
		(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
		_tmp101 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp101 = vala_ccode_identifier_new ("callback")));
		(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
		_tmp102 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("user_data")));
		(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
		_tmp103 = NULL;
		vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, (ValaDataType*) (_tmp103 = vala_void_type_new ()), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_async", 1);
		(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_code_node_unref (_tmp103), NULL));
		_tmp104 = NULL;
		cparam_map = (_tmp104 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp104);
		_tmp105 = NULL;
		carg_map = (_tmp105 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp105);
		_tmp106 = NULL;
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp106 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
		(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
		_tmp107 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp107 = vala_ccode_identifier_new ("res")));
		(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
		vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, vala_method_get_return_type (m), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_finish", 2);
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	}
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
	dataname = (g_free (dataname), NULL);
	(datastruct == NULL) ? NULL : (datastruct = (vala_ccode_node_unref (datastruct), NULL));
	(asyncfunc == NULL) ? NULL : (asyncfunc = (vala_ccode_node_unref (asyncfunc), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(asyncblock == NULL) ? NULL : (asyncblock = (vala_ccode_node_unref (asyncblock), NULL));
	(dataalloc == NULL) ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(finishfunc == NULL) ? NULL : (finishfunc = (vala_ccode_node_unref (finishfunc), NULL));
	(finishblock == NULL) ? NULL : (finishblock = (vala_ccode_node_unref (finishblock), NULL));
}


static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt) {
	ValaGAsyncModule * self;
	ValaCCodeExpressionStatement* _tmp18;
	gboolean _tmp19;
	ValaCCodeFragment* cfrag;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_yield_statement_get_yield_expression (stmt) == NULL) {
		ValaCCodeFragment* cfrag;
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* idle_call;
		ValaCCodeCastExpression* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		char* _tmp2;
		ValaCCodeIdentifier* _tmp5;
		gint state;
		ValaCCodeExpressionStatement* _tmp6;
		ValaCCodeExpressionStatement* _tmp12;
		ValaCCodeAssignment* _tmp11;
		ValaCCodeConstant* _tmp10;
		char* _tmp9;
		ValaCCodeMemberAccess* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeReturnStatement* _tmp14;
		ValaCCodeConstant* _tmp13;
		ValaCCodeCaseStatement* _tmp17;
		ValaCCodeConstant* _tmp16;
		char* _tmp15;
		cfrag = vala_ccode_fragment_new ();
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		_tmp0 = NULL;
		_tmp1 = NULL;
		idle_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_idle_add"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = vala_method_get_real_cname (((ValaCCodeBaseModule*) self)->current_method))), "GSourceFunc")));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("data")));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
		_tmp6 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) idle_call)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp12 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new (_tmp9 = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
		_tmp9 = (g_free (_tmp9), NULL);
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp14 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new ("FALSE")))));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp17 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_constant_new (_tmp15 = g_strdup_printf ("%i", state))))));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
		_tmp15 = (g_free (_tmp15), NULL);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
		(idle_call == NULL) ? NULL : (idle_call = (vala_ccode_node_unref (idle_call), NULL));
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp18 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))))));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp19 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt));
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	/* free temporary objects */
	if (gee_collection_get_size ((GeeCollection*) (GEE_LIST (((ValaCCodeBaseModule*) self)->temp_vars))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp22;
			ValaCCodeExpression* _tmp21;
			ValaCCodeIdentifier* _tmp20;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new (_tmp21 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_gasync_module_class_init (ValaGAsyncModuleClass * klass) {
	vala_gasync_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_gasync_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->visit_yield_statement = vala_gasync_module_real_visit_yield_statement;
}


static void vala_gasync_module_instance_init (ValaGAsyncModule * self) {
}


GType vala_gasync_module_get_type (void) {
	static GType vala_gasync_module_type_id = 0;
	if (vala_gasync_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGAsyncModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gasync_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGAsyncModule), 0, (GInstanceInitFunc) vala_gasync_module_instance_init, NULL };
		vala_gasync_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGAsyncModule", &g_define_type_info, 0);
	}
	return vala_gasync_module_type_id;
}




