/* valaccodearraymodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodearraymodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valadatatype.h>
#include <vala/valalocalvariable.h>
#include <vala/valasymbol.h>
#include <gee/list.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valainitializerlist.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valaarraytype.h>
#include <vala/valaunaryexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valainvocationexpression.h>
#include <vala/valaformalparameter.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valafield.h>
#include <vala/valamemberaccess.h>
#include <vala/valamember.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valaconstant.h>
#include <vala/valanullliteral.h>
#include <gee/collection.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaintegerliteral.h>
#include <vala/valascope.h>
#include <vala/valamethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valasignal.h>
#include <vala/valastringliteral.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_ARRAY_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCCodeModule* base, ValaArrayCreationExpression* expr);
static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeModule* base, const char* array_cname, gint dim);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeModule* base, ValaExpression* array_expr, gint dim);
static void vala_ccode_array_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr);
static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self, gboolean have_length);
static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base);
static gpointer vala_ccode_array_module_parent_class = NULL;



ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeArrayModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeArrayModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeArrayModule*) (vala_ccode_invocation_expression_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_array_module_construct (VALA_TYPE_CCODE_ARRAY_MODULE, codegen, next);
}


static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCCodeModule* base, ValaArrayCreationExpression* expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	gboolean first;
	ValaCCodeExpression* cexpr;
	self = ((ValaCCodeArrayModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp0 = NULL;
	_tmp1 = NULL;
	gnew = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("g_new0"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (gnew, ((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_data_type_get_cname (vala_array_creation_expression_get_element_type (expr))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp2 = (g_free (_tmp2), NULL);
	first = TRUE;
	cexpr = NULL;
	/* iterate over each dimension*/
	{
		GeeList* size_collection;
		int size_it;
		size_collection = vala_array_creation_expression_get_sizes (expr);
		for (size_it = 0; size_it < gee_collection_get_size (GEE_COLLECTION (size_collection)); size_it = size_it + 1) {
			ValaExpression* size;
			size = ((ValaExpression*) (gee_list_get (GEE_LIST (size_collection), size_it)));
			{
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* csize;
				_tmp4 = NULL;
				csize = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (size)))), (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4)));
				if (!vala_ccode_base_module_is_pure_ccode_expression (((ValaCCodeBaseModule*) (self)), csize)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* name_cnode;
					ValaCCodeExpression* _tmp6;
					ValaCCodeAssignment* _tmp5;
					temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->int_type, FALSE, ((ValaCodeNode*) (expr)));
					name_cnode = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
					vala_code_node_set_ccodenode (((ValaCodeNode*) (size)), ((ValaCCodeNode*) (name_cnode)));
					gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
					_tmp6 = NULL;
					_tmp5 = NULL;
					csize = (_tmp6 = ((ValaCCodeExpression*) (vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_assignment_new (((ValaCCodeExpression*) (name_cnode)), csize, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))))), (csize == NULL ? NULL : (csize = (vala_ccode_node_unref (csize), NULL))), _tmp6);
					(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
					(name_cnode == NULL ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL)));
				}
				if (first) {
					ValaCCodeExpression* _tmp8;
					ValaCCodeExpression* _tmp7;
					_tmp8 = NULL;
					_tmp7 = NULL;
					cexpr = (_tmp8 = (_tmp7 = csize, (_tmp7 == NULL ? NULL : vala_ccode_node_ref (_tmp7))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp8);
					first = FALSE;
				} else {
					ValaCCodeExpression* _tmp9;
					_tmp9 = NULL;
					cexpr = (_tmp9 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, csize))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp9);
				}
				(size == NULL ? NULL : (size = (vala_code_node_unref (size), NULL)));
				(csize == NULL ? NULL : (csize = (vala_ccode_node_unref (csize), NULL)));
			}
		}
		(size_collection == NULL ? NULL : (size_collection = (gee_collection_object_unref (size_collection), NULL)));
	}
	/* add extra item to have array NULL-terminated for all reference types*/
	if (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)))) {
		ValaCCodeExpression* _tmp11;
		ValaCCodeConstant* _tmp10;
		_tmp11 = NULL;
		_tmp10 = NULL;
		cexpr = (_tmp11 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, cexpr, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ("1"))))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp11);
		(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaCCodeAssignment* _tmp12;
		/* FIXME rank > 1 not supported yet*/
		if (vala_array_creation_expression_get_rank (expr) > 1) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Creating arrays with rank greater than 1 with initializers is not supported yet");
		}
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE, ((ValaCodeNode*) (expr)));
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
		i = 0;
		gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
		_tmp12 = NULL;
		vala_ccode_comma_expression_append_expression (ce, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_assignment_new (((ValaCCodeExpression*) (name_cnode)), ((ValaCCodeExpression*) (gnew)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		{
			GeeList* e_collection;
			int e_it;
			e_collection = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
				ValaExpression* e;
				e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
				{
					ValaCCodeAssignment* _tmp16;
					ValaCCodeElementAccess* _tmp15;
					ValaCCodeConstant* _tmp14;
					char* _tmp13;
					_tmp16 = NULL;
					_tmp15 = NULL;
					_tmp14 = NULL;
					_tmp13 = NULL;
					vala_ccode_comma_expression_append_expression (ce, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_element_access_new (((ValaCCodeExpression*) (name_cnode)), ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_constant_new ((_tmp13 = g_strdup_printf ("%i", i)))))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (e)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
					(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
					(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
					_tmp13 = (g_free (_tmp13), NULL);
					i++;
					(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
				}
			}
			(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, ((ValaCCodeExpression*) (name_cnode)));
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ce)));
		(ce == NULL ? NULL : (ce = (vala_ccode_node_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL)));
	} else {
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (gnew)));
	}
	(gnew == NULL ? NULL : (gnew = (vala_ccode_node_unref (gnew), NULL)));
	(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
}


static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeModule* base, const char* array_cname, gint dim) {
	ValaCCodeArrayModule * self;
	self = ((ValaCCodeArrayModule*) (base));
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeModule* base, ValaExpression* array_expr, gint dim) {
	ValaCCodeArrayModule * self;
	gboolean is_out;
	self = ((ValaCCodeArrayModule*) (base));
	g_return_val_if_fail (array_expr != NULL, NULL);
	/* dim == -1 => total size over all dimensions*/
	if (dim == -1) {
		ValaArrayType* _tmp1;
		ValaDataType* _tmp0;
		ValaArrayType* array_type;
		_tmp1 = NULL;
		_tmp0 = NULL;
		array_type = (_tmp1 = (_tmp0 = vala_expression_get_value_type (array_expr), (VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		if (array_type != NULL && vala_array_type_get_rank (array_type) > 1) {
			ValaCCodeExpression* cexpr;
			ValaCCodeExpression* _tmp4;
			cexpr = vala_ccode_module_get_array_length_cexpression (((ValaCCodeModule*) (self)), array_expr, 1);
			for (dim = 2; dim <= vala_array_type_get_rank (array_type); dim++) {
				ValaCCodeExpression* _tmp3;
				ValaCCodeExpression* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				cexpr = (_tmp3 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, (_tmp2 = vala_ccode_module_get_array_length_cexpression (((ValaCCodeModule*) (self)), array_expr, dim))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp3);
				(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
			}
			_tmp4 = NULL;
			return (_tmp4 = cexpr, (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp4);
		} else {
			dim = 1;
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	}
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* _tmp5;
		ValaUnaryExpression* unary_expr;
		_tmp5 = NULL;
		unary_expr = (_tmp5 = VALA_UNARY_EXPRESSION (array_expr), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT || vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL)));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* _tmp6;
			ValaReferenceTransferExpression* reftransfer_expr;
			_tmp6 = NULL;
			reftransfer_expr = (_tmp6 = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL ? NULL : (reftransfer_expr = (vala_code_node_unref (reftransfer_expr), NULL)));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		ValaCCodeExpression* _tmp7;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		length_expr = ((ValaExpression*) (gee_list_get (((GeeList*) (size)), dim - 1)));
		_tmp7 = NULL;
		return (_tmp7 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (length_expr)))), (size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (vala_code_node_unref (length_expr), NULL))), _tmp7);
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* _tmp8;
			ValaInvocationExpression* invocation_expr;
			GeeList* size;
			ValaCCodeExpression* _tmp9;
			_tmp8 = NULL;
			invocation_expr = (_tmp8 = VALA_INVOCATION_EXPRESSION (array_expr), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			_tmp9 = NULL;
			return (_tmp9 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (size)), dim - 1))), (invocation_expr == NULL ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL))), _tmp9);
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* _tmp10;
					ValaFormalParameter* param;
					_tmp10 = NULL;
					param = (_tmp10 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						char* _tmp11;
						ValaCCodeExpression* _tmp12;
						ValaCCodeExpression* length_expr;
						_tmp11 = NULL;
						_tmp12 = NULL;
						length_expr = (_tmp12 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp11 = vala_ccode_module_get_array_length_cname (((ValaCCodeModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (param))), dim))))), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
							ValaCCodeExpression* _tmp14;
							ValaCCodeUnaryExpression* _tmp13;
							/* accessing argument of out/ref param*/
							_tmp14 = NULL;
							_tmp13 = NULL;
							length_expr = (_tmp14 = ((ValaCCodeExpression*) (vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, length_expr))))))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), _tmp14);
							(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
						}
						if (is_out) {
							ValaCCodeExpression* _tmp15;
							/* passing array as out/ref*/
							_tmp15 = NULL;
							return (_tmp15 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp15);
						} else {
							ValaCCodeExpression* _tmp16;
							_tmp16 = NULL;
							return (_tmp16 = length_expr, (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp16);
						}
						(length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
						ValaLocalVariable* _tmp17;
						ValaLocalVariable* local;
						char* _tmp18;
						ValaCCodeIdentifier* _tmp19;
						ValaCCodeIdentifier* length_expr;
						_tmp17 = NULL;
						local = (_tmp17 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)), (_tmp17 == NULL ? NULL : vala_code_node_ref (_tmp17)));
						_tmp18 = NULL;
						_tmp19 = NULL;
						length_expr = (_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_ccode_module_get_array_length_cname (((ValaCCodeModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (local))), dim))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp19);
						if (is_out) {
							ValaCCodeExpression* _tmp20;
							_tmp20 = NULL;
							return (_tmp20 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (length_expr))))), (local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), _tmp20);
						} else {
							ValaCCodeExpression* _tmp21;
							_tmp21 = NULL;
							return (_tmp21 = ((ValaCCodeExpression*) (length_expr)), (local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL))), _tmp21);
						}
						(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* _tmp22;
							ValaField* field;
							_tmp22 = NULL;
							field = (_tmp22 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22)));
							if (!vala_field_get_no_array_length (field)) {
								ValaMemberAccess* _tmp23;
								ValaMemberAccess* ma;
								ValaCCodeExpression* length_expr;
								_tmp23 = NULL;
								ma = (_tmp23 = VALA_MEMBER_ACCESS (array_expr), (_tmp23 == NULL ? NULL : vala_code_node_ref (_tmp23)));
								length_expr = NULL;
								if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
									ValaTypeSymbol* base_type;
									char* length_cname;
									ValaDataType* instance_expression_type;
									ValaDataType* instance_target_type;
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									base_type = NULL;
									if (vala_expression_get_value_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaTypeSymbol* _tmp25;
										ValaTypeSymbol* _tmp24;
										_tmp25 = NULL;
										_tmp24 = NULL;
										base_type = (_tmp25 = (_tmp24 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24))), (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), _tmp25);
									}
									length_cname = vala_ccode_module_get_array_length_cname (((ValaCCodeModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (field))), dim);
									instance_expression_type = vala_ccode_base_module_get_data_type_for_symbol (base_type);
									instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (field)))));
									typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_member_access_get_inner (ma)))));
									inst = NULL;
									if (vala_symbol_get_access (((ValaSymbol*) (field))) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* _tmp26;
										_tmp26 = NULL;
										inst = (_tmp26 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (typed_inst, "priv"))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp26);
									} else {
										ValaCCodeExpression* _tmp28;
										ValaCCodeExpression* _tmp27;
										_tmp28 = NULL;
										_tmp27 = NULL;
										inst = (_tmp28 = (_tmp27 = typed_inst, (_tmp27 == NULL ? NULL : vala_ccode_node_ref (_tmp27))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp28);
									}
									if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (field))))))) {
										ValaCCodeExpression* _tmp29;
										_tmp29 = NULL;
										length_expr = (_tmp29 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (inst, length_cname))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), _tmp29);
									} else {
										ValaCCodeExpression* _tmp30;
										_tmp30 = NULL;
										length_expr = (_tmp30 = ((ValaCCodeExpression*) (vala_ccode_member_access_new (inst, length_cname, FALSE))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), _tmp30);
									}
									(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
									length_cname = (g_free (length_cname), NULL);
									(instance_expression_type == NULL ? NULL : (instance_expression_type = (vala_code_node_unref (instance_expression_type), NULL)));
									(instance_target_type == NULL ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL)));
									(typed_inst == NULL ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* _tmp33;
									char* _tmp32;
									char* _tmp31;
									_tmp33 = NULL;
									_tmp32 = NULL;
									_tmp31 = NULL;
									length_expr = (_tmp33 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp32 = vala_ccode_module_get_array_length_cname (((ValaCCodeModule*) (self)), (_tmp31 = vala_field_get_cname (field)), dim))))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), _tmp33);
									_tmp32 = (g_free (_tmp32), NULL);
									_tmp31 = (g_free (_tmp31), NULL);
								}
								if (is_out) {
									ValaCCodeExpression* _tmp34;
									_tmp34 = NULL;
									return (_tmp34 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL))), (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), _tmp34);
								} else {
									ValaCCodeExpression* _tmp35;
									_tmp35 = NULL;
									return (_tmp35 = length_expr, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), _tmp35);
								}
								(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
						} else {
							if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (array_expr))) {
								ValaConstant* _tmp36;
								ValaConstant* constant;
								ValaCCodeIdentifier* _tmp37;
								ValaCCodeFunctionCall* _tmp38;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp40;
								char* _tmp39;
								ValaCCodeExpression* _tmp41;
								_tmp36 = NULL;
								constant = (_tmp36 = VALA_CONSTANT (vala_expression_get_symbol_reference (array_expr)), (_tmp36 == NULL ? NULL : vala_code_node_ref (_tmp36)));
								_tmp37 = NULL;
								_tmp38 = NULL;
								ccall = (_tmp38 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp37 = vala_ccode_identifier_new ("G_N_ELEMENTS"))))), (_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL))), _tmp38);
								_tmp40 = NULL;
								_tmp39 = NULL;
								vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp40 = vala_ccode_identifier_new ((_tmp39 = vala_constant_get_cname (constant)))))));
								(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
								_tmp39 = (g_free (_tmp39), NULL);
								_tmp41 = NULL;
								return (_tmp41 = ((ValaCCodeExpression*) (ccall)), (constant == NULL ? NULL : (constant = (vala_code_node_unref (constant), NULL))), _tmp41);
							}
						}
					}
				}
			} else {
				if (VALA_IS_NULL_LITERAL (array_expr)) {
					return ((ValaCCodeExpression*) (vala_ccode_constant_new ("0")));
				}
			}
		}
	}
	if (!is_out) {
		/* allow arrays with unknown length even for value types
		 * as else it may be impossible to bind some libraries
		 * users of affected libraries should explicitly set
		 * the array length as early as possible
		 * by setting the virtual length field of the array
		 */
		return ((ValaCCodeExpression*) (vala_ccode_constant_new ("-1")));
	} else {
		return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
	}
}


static void vala_ccode_array_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr) {
	ValaCCodeArrayModule * self;
	GeeList* indices;
	gint rank;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* container_type;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp3;
	ValaExpression* _tmp2;
	ValaCCodeExpression* _tmp4;
	ValaCCodeExpression* cindex;
	self = ((ValaCCodeArrayModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size (((GeeCollection*) (indices)));
	_tmp0 = NULL;
	container_type = (_tmp0 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	ccontainer = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_element_access_get_container (expr))))), (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp4 = NULL;
	cindex = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) ((_tmp2 = ((ValaExpression*) (gee_list_get (((GeeList*) (indices)), 0)))))))), (_tmp3 == NULL ? NULL : vala_ccode_node_ref (_tmp3))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL))), _tmp4);
	if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
		ValaExpression* _tmp5;
		ValaIntegerLiteral* lit;
		ValaMemberAccess* _tmp7;
		ValaExpression* _tmp6;
		ValaMemberAccess* memberaccess;
		/* Figure if cindex is a constant expression and calculate dim...*/
		_tmp5 = NULL;
		lit = (_tmp5 = ((ValaExpression*) (gee_list_get (((GeeList*) (indices)), 0))), (VALA_IS_INTEGER_LITERAL (_tmp5) ? ((ValaIntegerLiteral*) (_tmp5)) : NULL));
		_tmp7 = NULL;
		_tmp6 = NULL;
		memberaccess = (_tmp7 = (_tmp6 = vala_element_access_get_container (expr), (VALA_IS_MEMBER_ACCESS (_tmp6) ? ((ValaMemberAccess*) (_tmp6)) : NULL)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
		if (lit != NULL && memberaccess != NULL) {
			gint dim;
			ValaCCodeExpression* _tmp8;
			dim = atoi (vala_integer_literal_get_value (lit));
			_tmp8 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp8 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_member_access_get_inner (memberaccess), dim + 1)))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
		}
		(lit == NULL ? NULL : (lit = (vala_code_node_unref (lit), NULL)));
		(memberaccess == NULL ? NULL : (memberaccess = (vala_code_node_unref (memberaccess), NULL)));
	} else {
		if (container_type == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeFunctionCall* _tmp10;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeIdentifier* _tmp11;
			ValaCCodeFunctionCall* _tmp12;
			ValaCCodeFunctionCall* ccall;
			/* should be moved to a different module
			 access to unichar in a string*/
			_tmp9 = NULL;
			_tmp10 = NULL;
			coffsetcall = (_tmp10 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), _tmp10);
			vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
			vala_ccode_function_call_add_argument (coffsetcall, cindex);
			_tmp11 = NULL;
			_tmp12 = NULL;
			ccall = (_tmp12 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ("g_utf8_get_char"))))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), _tmp12);
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (coffsetcall)));
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (vala_ccode_node_unref (coffsetcall), NULL)));
			(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
		} else {
			if (container_type != NULL && ((ValaCCodeBaseModule*) (self))->list_type != NULL && ((ValaCCodeBaseModule*) (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->list_type))) || vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->map_type))))) {
				ValaTypeSymbol* collection_iface;
				ValaMethod* get_method;
				GeeList* get_params;
				GeeIterator* get_params_it;
				ValaFormalParameter* get_param;
				ValaCCodeIdentifier* _tmp19;
				char* _tmp18;
				ValaCCodeFunctionCall* _tmp20;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeCastExpression* _tmp23;
				char* _tmp22;
				char* _tmp21;
				ValaCCodeExpression* _tmp24;
				/* should be moved to a different module*/
				collection_iface = NULL;
				if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->list_type)))) {
					ValaTypeSymbol* _tmp14;
					ValaTypeSymbol* _tmp13;
					_tmp14 = NULL;
					_tmp13 = NULL;
					collection_iface = (_tmp14 = (_tmp13 = ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->list_type)), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13))), (collection_iface == NULL ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL))), _tmp14);
				} else {
					if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->map_type)))) {
						ValaTypeSymbol* _tmp16;
						ValaTypeSymbol* _tmp15;
						_tmp16 = NULL;
						_tmp15 = NULL;
						collection_iface = (_tmp16 = (_tmp15 = ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->map_type)), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15))), (collection_iface == NULL ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL))), _tmp16);
					}
				}
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (collection_iface))), "get"));
				get_params = vala_method_get_parameters (get_method);
				get_params_it = gee_iterable_iterator (((GeeIterable*) (get_params)));
				gee_iterator_next (get_params_it);
				get_param = ((ValaFormalParameter*) (gee_iterator_get (get_params_it)));
				if (vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (get_param)) != NULL) {
					ValaDataType* index_type;
					ValaCCodeExpression* _tmp17;
					index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), ((ValaSymbol*) (get_method)), vala_formal_parameter_get_parameter_type (get_param), ((ValaCodeNode*) (expr)));
					_tmp17 = NULL;
					cindex = (_tmp17 = vala_ccode_base_module_convert_to_generic_pointer (((ValaCCodeBaseModule*) (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL))), _tmp17);
					(index_type == NULL ? NULL : (index_type = (vala_code_node_unref (index_type), NULL)));
				}
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp20 = NULL;
				get_ccall = (_tmp20 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_method_get_cname (get_method))))))), (_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp20);
				_tmp23 = NULL;
				_tmp22 = NULL;
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_cast_expression_new (ccontainer, (_tmp22 = g_strconcat ((_tmp21 = vala_typesymbol_get_cname (collection_iface, FALSE)), "*", NULL)))))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				_tmp22 = (g_free (_tmp22), NULL);
				_tmp21 = (g_free (_tmp21), NULL);
				vala_ccode_function_call_add_argument (get_ccall, cindex);
				_tmp24 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp24 = vala_ccode_base_module_convert_from_generic_pointer (((ValaCCodeBaseModule*) (self)), ((ValaCCodeExpression*) (get_ccall)), vala_expression_get_value_type (((ValaExpression*) (expr))))))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
				(collection_iface == NULL ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL)));
				(get_method == NULL ? NULL : (get_method = (vala_code_node_unref (get_method), NULL)));
				(get_params == NULL ? NULL : (get_params = (gee_collection_object_unref (get_params), NULL)));
				(get_params_it == NULL ? NULL : (get_params_it = (gee_collection_object_unref (get_params_it), NULL)));
				(get_param == NULL ? NULL : (get_param = (vala_code_node_unref (get_param), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (vala_ccode_node_unref (get_ccall), NULL)));
			} else {
				if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (expr)) && VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
					ValaSignal* _tmp25;
					ValaSignal* sig;
					ValaMemberAccess* _tmp26;
					ValaMemberAccess* ma;
					GeeList* _tmp27;
					ValaExpression* _tmp28;
					ValaStringLiteral* _tmp29;
					ValaStringLiteral* detail_expr;
					char* signal_detail;
					ValaCCodeIdentifier* _tmp30;
					ValaCCodeFunctionCall* _tmp31;
					ValaCCodeFunctionCall* ccall;
					ValaCCodeIdentifier* _tmp32;
					ValaCCodeFunctionCall* _tmp33;
					ValaCCodeFunctionCall* ccast;
					ValaCCodeConstant* _tmp34;
					/* should be moved to the GSignal module
					 detailed signal emission*/
					_tmp25 = NULL;
					sig = (_tmp25 = VALA_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp25 == NULL ? NULL : vala_code_node_ref (_tmp25)));
					_tmp26 = NULL;
					ma = (_tmp26 = VALA_MEMBER_ACCESS (vala_element_access_get_container (expr)), (_tmp26 == NULL ? NULL : vala_code_node_ref (_tmp26)));
					_tmp27 = NULL;
					_tmp28 = NULL;
					_tmp29 = NULL;
					detail_expr = (_tmp29 = (_tmp28 = ((ValaExpression*) (gee_list_get ((_tmp27 = vala_element_access_get_indices (expr)), 0))), (VALA_IS_STRING_LITERAL (_tmp28) ? ((ValaStringLiteral*) (_tmp28)) : NULL)), (_tmp27 == NULL ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL))), _tmp29);
					signal_detail = vala_string_literal_eval (detail_expr);
					_tmp30 = NULL;
					_tmp31 = NULL;
					ccall = (_tmp31 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp30 = vala_ccode_identifier_new ("g_signal_emit_by_name"))))), (_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL))), _tmp31);
					/* FIXME: use C cast if debugging disabled*/
					_tmp32 = NULL;
					_tmp33 = NULL;
					ccast = (_tmp33 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp32 = vala_ccode_identifier_new ("G_OBJECT"))))), (_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL))), _tmp33);
					vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (ma))))));
					vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (ccast)));
					_tmp34 = NULL;
					vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp34 = vala_signal_get_canonical_cconstant (sig, signal_detail)))));
					(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
					vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
					(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
					(detail_expr == NULL ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL)));
					signal_detail = (g_free (signal_detail), NULL);
					(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
					(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
				} else {
					ValaCCodeElementAccess* _tmp41;
					{
						gint i;
						/* access to element in an array*/
						i = 1;
						for (; i < rank; i++) {
							ValaCCodeExpression* _tmp36;
							ValaCCodeParenthesizedExpression* _tmp35;
							ValaCCodeBinaryExpression* _tmp37;
							ValaCCodeBinaryExpression* cmul;
							ValaCCodeExpression* _tmp40;
							ValaCCodeParenthesizedExpression* _tmp39;
							ValaExpression* _tmp38;
							_tmp36 = NULL;
							_tmp35 = NULL;
							_tmp37 = NULL;
							cmul = (_tmp37 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_parenthesized_expression_new (cindex)))), (_tmp36 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_element_access_get_container (expr), i + 1))), (_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL))), (_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL))), _tmp37);
							_tmp40 = NULL;
							_tmp39 = NULL;
							_tmp38 = NULL;
							cindex = (_tmp40 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) (cmul)), ((ValaCCodeExpression*) ((_tmp39 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) ((_tmp38 = ((ValaExpression*) (gee_list_get (((GeeList*) (indices)), i))))))))))))))), (cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL))), _tmp40);
							(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
							(_tmp38 == NULL ? NULL : (_tmp38 = (vala_code_node_unref (_tmp38), NULL)));
							(cmul == NULL ? NULL : (cmul = (vala_ccode_node_unref (cmul), NULL)));
						}
					}
					_tmp41 = NULL;
					vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp41 = vala_ccode_element_access_new (ccontainer, cindex)))));
					(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
				}
			}
		}
	}
	(indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL)));
	(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (vala_ccode_node_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL)));
}


static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self, gboolean have_length) {
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeCastExpression* _tmp1;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeElementAccess* _tmp3;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeExpression* cforcond;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeAssignment* _tmp23;
	ValaCCodeBinaryExpression* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeForStatement* _tmp24;
	g_return_val_if_fail (self != NULL, NULL);
	cbody = vala_ccode_block_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	cptrarray = (_tmp1 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("array")))), "gpointer*"), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cea = (_tmp3 = vala_ccode_element_access_new (((ValaCCodeExpression*) (cptrarray)), ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("i"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cfreecall = (_tmp5 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp4 = vala_ccode_identifier_new ("destroy_func"))))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (cfreecall, ((ValaCCodeExpression*) (cea)));
	cforcond = NULL;
	if (have_length) {
		ValaCCodeConstant* _tmp6;
		ValaCCodeBinaryExpression* _tmp7;
		ValaCCodeBinaryExpression* cfreecond;
		ValaCCodeExpression* _tmp10;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeIfStatement* _tmp12;
		ValaCCodeExpressionStatement* _tmp11;
		_tmp6 = NULL;
		_tmp7 = NULL;
		cfreecond = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) (cea)), ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_constant_new ("NULL"))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), _tmp7);
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		cforcond = (_tmp10 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_identifier_new ("i")))), ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("array_length"))))))), (cforcond == NULL ? NULL : (cforcond = (vala_ccode_node_unref (cforcond), NULL))), _tmp10);
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_if_statement_new (((ValaCCodeExpression*) (cfreecond)), ((ValaCCodeStatement*) ((_tmp11 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cfreecall)))))), NULL)))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
		(cfreecond == NULL ? NULL : (cfreecond = (vala_ccode_node_unref (cfreecond), NULL)));
	} else {
		ValaCCodeExpression* _tmp14;
		ValaCCodeConstant* _tmp13;
		ValaCCodeExpressionStatement* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		cforcond = (_tmp14 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) (cea)), ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_constant_new ("NULL"))))))), (cforcond == NULL ? NULL : (cforcond = (vala_ccode_node_unref (cforcond), NULL))), _tmp14);
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
		_tmp15 = NULL;
		vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) ((_tmp15 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cfreecall)))))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	}
	cfor = vala_ccode_for_statement_new (cforcond, ((ValaCCodeStatement*) (cbody)));
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("i")))), ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_constant_new ("0")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new ("i")))), ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("i")))), ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_constant_new ("1")))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp24 = NULL;
	return (_tmp24 = cfor, (cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL))), (cptrarray == NULL ? NULL : (cptrarray = (vala_ccode_node_unref (cptrarray), NULL))), (cea == NULL ? NULL : (cea = (vala_ccode_node_unref (cea), NULL))), (cfreecall == NULL ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL))), (cforcond == NULL ? NULL : (cforcond = (vala_ccode_node_unref (cforcond), NULL))), _tmp24);
}


static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* clencheck;
	ValaCCodeForStatement* _tmp9;
	ValaCCodeForStatement* _tmp8;
	ValaCCodeIfStatement* _tmp10;
	ValaCCodeIfStatement* ciflen;
	ValaCCodeConstant* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeIfStatement* _tmp18;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	self = ((ValaCCodeArrayModule*) (base));
	fun = vala_ccode_function_new ("_vala_array_free", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("array_length", "gint")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp3 = vala_ccode_function_copy (fun)))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (citdecl, ((ValaCCodeDeclarator*) ((_tmp4 = vala_ccode_variable_declarator_new ("i")))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	vala_ccode_block_add_statement (cdofree, ((ValaCCodeNode*) (citdecl)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	clencheck = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ("array_length")))), ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_constant_new ("0"))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	ciflen = (_tmp10 = vala_ccode_if_statement_new (((ValaCCodeExpression*) (clencheck)), ((ValaCCodeStatement*) ((_tmp8 = vala_ccode_array_module_get_vala_array_free_loop (self, TRUE)))), ((ValaCCodeStatement*) ((_tmp9 = vala_ccode_array_module_get_vala_array_free_loop (self, FALSE))))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), _tmp10);
	vala_ccode_block_add_statement (cdofree, ((ValaCCodeNode*) (ciflen)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	ccondarr = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ("array")))), ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_constant_new ("NULL"))))), (_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp16 = NULL;
	ccondfunc = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ("destroy_func")))), ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ("NULL"))))), (_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL))), (_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL))), _tmp16);
	_tmp17 = NULL;
	_tmp18 = NULL;
	cif = (_tmp18 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, ((ValaCCodeExpression*) (ccondarr)), ((ValaCCodeExpression*) (ccondfunc)))))), ((ValaCCodeStatement*) (cdofree)), NULL), (_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_function_set_block (fun, (_tmp19 = vala_ccode_block_new ()));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) (cif)));
	_tmp20 = NULL;
	_tmp21 = NULL;
	carrfree = (_tmp21 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("g_free"))))), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (carrfree, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ("array")))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) ((_tmp23 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (carrfree)))))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (fun)));
	(fun == NULL ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)));
	(cdofree == NULL ? NULL : (cdofree = (vala_ccode_node_unref (cdofree), NULL)));
	(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
	(clencheck == NULL ? NULL : (clencheck = (vala_ccode_node_unref (clencheck), NULL)));
	(ciflen == NULL ? NULL : (ciflen = (vala_ccode_node_unref (ciflen), NULL)));
	(ccondarr == NULL ? NULL : (ccondarr = (vala_ccode_node_unref (ccondarr), NULL)));
	(ccondfunc == NULL ? NULL : (ccondfunc = (vala_ccode_node_unref (ccondfunc), NULL)));
	(cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)));
	(carrfree == NULL ? NULL : (carrfree = (vala_ccode_node_unref (carrfree), NULL)));
}


static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeCastExpression* _tmp7;
	ValaCCodeCastExpression* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp8;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeBinaryExpression* _tmp11;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp14;
	ValaCCodeParenthesizedExpression* _tmp13;
	ValaCCodeBinaryExpression* _tmp12;
	ValaCCodeBinaryExpression* _tmp15;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp19;
	ValaCCodeExpressionStatement* _tmp20;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeConstant* _tmp23;
	ValaCCodeBinaryExpression* _tmp26;
	ValaCCodeParenthesizedExpression* _tmp25;
	ValaCCodeBinaryExpression* _tmp24;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp29;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeConstant* _tmp30;
	ValaCCodeBinaryExpression* _tmp33;
	ValaCCodeParenthesizedExpression* _tmp32;
	ValaCCodeBinaryExpression* _tmp31;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeIfStatement* _tmp36;
	ValaCCodeBinaryExpression* _tmp35;
	self = ((ValaCCodeArrayModule*) (base));
	((ValaCCodeBaseModule*) (self))->string_h_needed = TRUE;
	/* assumes that overwritten array elements are null before invocation
	 FIXME will leak memory if that's not the case*/
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("element_size", "gsize")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("src", "gint")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp3 = vala_ccode_formal_parameter_new ("dest", "gint")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp4 = vala_ccode_formal_parameter_new ("length", "gint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp5 = vala_ccode_function_copy (fun)))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	_tmp7 = NULL;
	array = (_tmp7 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp6 = vala_ccode_identifier_new ("array")))), "char*"), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), _tmp7);
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	_tmp8 = NULL;
	_tmp9 = NULL;
	src_address = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) (array)), ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) (src)), ((ValaCCodeExpression*) (element_size))))))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), _tmp9);
	_tmp10 = NULL;
	_tmp11 = NULL;
	dest_address = (_tmp11 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) (array)), ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) (dest)), ((ValaCCodeExpression*) (element_size))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp11);
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp15 = NULL;
	dest_end_address = (_tmp15 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) (array)), ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) (dest)), ((ValaCCodeExpression*) (length)))))))))), ((ValaCCodeExpression*) (element_size))))))), (_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), (_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL))), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_set_block (fun, (_tmp16 = vala_ccode_block_new ()));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	_tmp18 = NULL;
	ccall = (_tmp18 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_identifier_new ("g_memmove"))))), (_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL))), _tmp18);
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (dest_address)));
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (src_address)));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) (length)), ((ValaCCodeExpression*) (element_size)))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp20 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) ((_tmp20 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	_tmp21 = NULL;
	_tmp22 = NULL;
	czero1 = (_tmp22 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ("memset"))))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), _tmp22);
	vala_ccode_function_call_add_argument (czero1, ((ValaCCodeExpression*) (src_address)));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (czero1, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_constant_new ("0")))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (czero1, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) ((_tmp25 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp24 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, ((ValaCCodeExpression*) (dest)), ((ValaCCodeExpression*) (src)))))))))), ((ValaCCodeExpression*) (element_size)))))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	czeroblock1 = vala_ccode_block_new ();
	_tmp27 = NULL;
	vala_ccode_block_add_statement (czeroblock1, ((ValaCCodeNode*) ((_tmp27 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (czero1)))))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	_tmp28 = NULL;
	_tmp29 = NULL;
	czero2 = (_tmp29 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new ("memset"))))), (_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL))), _tmp29);
	vala_ccode_function_call_add_argument (czero2, ((ValaCCodeExpression*) (dest_end_address)));
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (czero2, ((ValaCCodeExpression*) ((_tmp30 = vala_ccode_constant_new ("0")))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (czero2, ((ValaCCodeExpression*) ((_tmp33 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) ((_tmp32 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp31 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, ((ValaCCodeExpression*) (src)), ((ValaCCodeExpression*) (dest)))))))))), ((ValaCCodeExpression*) (element_size)))))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
	czeroblock2 = vala_ccode_block_new ();
	_tmp34 = NULL;
	vala_ccode_block_add_statement (czeroblock2, ((ValaCCodeNode*) ((_tmp34 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (czero2)))))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) ((_tmp36 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp35 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, ((ValaCCodeExpression*) (src)), ((ValaCCodeExpression*) (dest)))))), ((ValaCCodeStatement*) (czeroblock1)), ((ValaCCodeStatement*) (czeroblock2)))))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (fun)));
	(fun == NULL ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)));
	(array == NULL ? NULL : (array = (vala_ccode_node_unref (array), NULL)));
	(element_size == NULL ? NULL : (element_size = (vala_ccode_node_unref (element_size), NULL)));
	(length == NULL ? NULL : (length = (vala_ccode_node_unref (length), NULL)));
	(src == NULL ? NULL : (src = (vala_ccode_node_unref (src), NULL)));
	(dest == NULL ? NULL : (dest = (vala_ccode_node_unref (dest), NULL)));
	(src_address == NULL ? NULL : (src_address = (vala_ccode_node_unref (src_address), NULL)));
	(dest_address == NULL ? NULL : (dest_address = (vala_ccode_node_unref (dest_address), NULL)));
	(dest_end_address == NULL ? NULL : (dest_end_address = (vala_ccode_node_unref (dest_end_address), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(czero1 == NULL ? NULL : (czero1 = (vala_ccode_node_unref (czero1), NULL)));
	(czeroblock1 == NULL ? NULL : (czeroblock1 = (vala_ccode_node_unref (czeroblock1), NULL)));
	(czero2 == NULL ? NULL : (czero2 = (vala_ccode_node_unref (czero2), NULL)));
	(czeroblock2 == NULL ? NULL : (czeroblock2 = (vala_ccode_node_unref (czeroblock2), NULL)));
}


static void vala_ccode_array_module_class_init (ValaCCodeArrayModuleClass * klass) {
	vala_ccode_array_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_array_creation_expression = vala_ccode_array_module_real_visit_array_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_length_cname = vala_ccode_array_module_real_get_array_length_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_length_cexpression = vala_ccode_array_module_real_get_array_length_cexpression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_element_access = vala_ccode_array_module_real_visit_element_access;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_array_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_array_module_real_append_vala_array_move;
}


static void vala_ccode_array_module_instance_init (ValaCCodeArrayModule * self) {
}


GType vala_ccode_array_module_get_type (void) {
	static GType vala_ccode_array_module_type_id = 0;
	if (vala_ccode_array_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeArrayModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_array_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeArrayModule), 0, (GInstanceInitFunc) vala_ccode_array_module_instance_init, NULL };
		vala_ccode_array_module_type_id = g_type_register_static (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE, "ValaCCodeArrayModule", &g_define_type_info, 0);
	}
	return vala_ccode_array_module_type_id;
}




