/* valaccodedostatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodedostatement.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodeblock.h>




struct _ValaCCodeDoStatementPrivate {
	ValaCCodeStatement* _body;
	ValaCCodeExpression* _condition;
};

#define VALA_CCODE_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DO_STATEMENT, ValaCCodeDoStatementPrivate))
enum  {
	VALA_CCODE_DO_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_do_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_do_statement_parent_class = NULL;
static void vala_ccode_do_statement_finalize (ValaCCodeNode* obj);



ValaCCodeDoStatement* vala_ccode_do_statement_construct (GType object_type, ValaCCodeStatement* stmt, ValaCCodeExpression* cond) {
	ValaCCodeDoStatement* self;
	g_return_val_if_fail (stmt != NULL, NULL);
	g_return_val_if_fail (cond != NULL, NULL);
	self = ((ValaCCodeDoStatement*) (g_type_create_instance (object_type)));
	vala_ccode_do_statement_set_body (self, stmt);
	vala_ccode_do_statement_set_condition (self, cond);
	return self;
}


ValaCCodeDoStatement* vala_ccode_do_statement_new (ValaCCodeStatement* stmt, ValaCCodeExpression* cond) {
	return vala_ccode_do_statement_construct (VALA_TYPE_CCODE_DO_STATEMENT, stmt, cond);
}


static void vala_ccode_do_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeDoStatement * self;
	self = ((ValaCCodeDoStatement*) (base));
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (((ValaCCodeNode*) (self))));
	vala_ccode_writer_write_string (writer, "do");
	/* while shouldn't be on a separate line */
	if (VALA_IS_CCODE_BLOCK (self->priv->_body)) {
		ValaCCodeBlock* _tmp0;
		ValaCCodeBlock* cblock;
		_tmp0 = NULL;
		cblock = (_tmp0 = VALA_CCODE_BLOCK (self->priv->_body), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
		vala_ccode_block_set_suppress_newline (cblock, TRUE);
		(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
	}
	vala_ccode_node_write (((ValaCCodeNode*) (self->priv->_body)), writer);
	vala_ccode_writer_write_string (writer, " while (");
	vala_ccode_node_write (((ValaCCodeNode*) (self->priv->_condition)), writer);
	vala_ccode_writer_write_string (writer, ");");
}


ValaCCodeStatement* vala_ccode_do_statement_get_body (ValaCCodeDoStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_body;
}


void vala_ccode_do_statement_set_body (ValaCCodeDoStatement* self, ValaCCodeStatement* value) {
	ValaCCodeStatement* _tmp2;
	ValaCCodeStatement* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_ccode_node_unref (self->priv->_body), NULL))), _tmp2);
}


ValaCCodeExpression* vala_ccode_do_statement_get_condition (ValaCCodeDoStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_condition;
}


void vala_ccode_do_statement_set_condition (ValaCCodeDoStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (vala_ccode_node_unref (self->priv->_condition), NULL))), _tmp2);
}


static void vala_ccode_do_statement_class_init (ValaCCodeDoStatementClass * klass) {
	vala_ccode_do_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_do_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeDoStatementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_do_statement_real_write;
}


static void vala_ccode_do_statement_instance_init (ValaCCodeDoStatement * self) {
	self->priv = VALA_CCODE_DO_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_do_statement_finalize (ValaCCodeNode* obj) {
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_ccode_node_unref (self->priv->_body), NULL)));
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (vala_ccode_node_unref (self->priv->_condition), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_do_statement_parent_class)->finalize (obj);
}


GType vala_ccode_do_statement_get_type (void) {
	static GType vala_ccode_do_statement_type_id = 0;
	if (vala_ccode_do_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDoStatement), 0, (GInstanceInitFunc) vala_ccode_do_statement_instance_init, NULL };
		vala_ccode_do_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeDoStatement", &g_define_type_info, 0);
	}
	return vala_ccode_do_statement_type_id;
}




