/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <version.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValaVAPIGen {
	GObject parent_instance;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GObjectClass parent_class;
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;

GType vala_vapi_gen_get_type (void) G_GNUC_CONST;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gint vala_vapi_gen_main (gchar** args, int args_length1);
ValaVAPIGen* vala_vapi_gen_new (void);
ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[10] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	gint result = 0;
	ValaReport* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_get_report (self->priv->context);
	_tmp1_ = vala_report_get_errors (_tmp0_);
	if (_tmp1_ == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			ValaReport* _tmp2_ = NULL;
			gint _tmp3_;
			_tmp2_ = vala_code_context_get_report (self->priv->context);
			_tmp3_ = vala_report_get_warnings (_tmp2_);
			fprintf (stdout, "Generation succeeded - %d warning(s)\n", _tmp3_);
		}
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			ValaReport* _tmp4_ = NULL;
			gint _tmp5_;
			ValaReport* _tmp6_ = NULL;
			gint _tmp7_;
			_tmp4_ = vala_code_context_get_report (self->priv->context);
			_tmp5_ = vala_report_get_errors (_tmp4_);
			_tmp6_ = vala_code_context_get_report (self->priv->context);
			_tmp7_ = vala_report_get_warnings (_tmp6_);
			fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", _tmp5_, _tmp7_);
		}
		result = 1;
		return result;
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = strnlen ((gchar*) self, (gsize) (offset + len));
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	ValaReport* _tmp8_ = NULL;
	ValaReport* _tmp9_ = NULL;
	ValaReport* _tmp10_ = NULL;
	gint _tmp11_;
	ValaReport* _tmp20_ = NULL;
	gint _tmp21_;
	ValaReport* _tmp23_ = NULL;
	gint _tmp24_;
	ValaReport* _tmp28_ = NULL;
	gint _tmp29_;
	ValaReport* _tmp37_ = NULL;
	gint _tmp38_;
	ValaParser* _tmp40_ = NULL;
	ValaParser* parser;
	ValaReport* _tmp41_ = NULL;
	gint _tmp42_;
	ValaGirParser* _tmp44_ = NULL;
	ValaGirParser* girparser;
	ValaReport* _tmp45_ = NULL;
	gint _tmp46_;
	ValaGIdlParser* _tmp48_ = NULL;
	ValaGIdlParser* gidlparser;
	ValaReport* _tmp49_ = NULL;
	gint _tmp50_;
	ValaReport* _tmp52_ = NULL;
	gint _tmp53_;
	ValaCodeWriter* _tmp71_ = NULL;
	ValaCodeWriter* interface_writer;
	gchar* _tmp72_ = NULL;
	gchar* vapi_filename;
	gchar* _tmp75_;
	gint _tmp76_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_tmp1_ = _tmp0_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	_tmp2_ = (_tmp3_ = vala_vapi_gen_vapi_directories, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, _vala_array_length (vala_vapi_gen_vapi_directories)));
	_tmp4_ = _tmp2_;
	self->priv->context->vapi_directories = (_vala_array_free (self->priv->context->vapi_directories, self->priv->context->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->vapi_directories_length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	self->priv->context->vapi_directories = _tmp4_;
	_tmp5_ = (_tmp6_ = vala_vapi_gen_gir_directories, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup2 (_tmp6_, _vala_array_length (vala_vapi_gen_gir_directories)));
	_tmp7_ = _tmp5_;
	self->priv->context->gir_directories = (_vala_array_free (self->priv->context->gir_directories, self->priv->context->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->gir_directories_length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	self->priv->context->gir_directories = _tmp7_;
	_tmp8_ = vala_code_context_get_report (self->priv->context);
	vala_report_set_enable_warnings (_tmp8_, !vala_vapi_gen_disable_warnings);
	_tmp9_ = vala_code_context_get_report (self->priv->context);
	vala_report_set_verbose_errors (_tmp9_, !vala_vapi_gen_quiet_mode);
	vala_code_context_push (self->priv->context);
	vala_code_context_add_external_package (self->priv->context, "glib-2.0");
	vala_code_context_add_external_package (self->priv->context, "gobject-2.0");
	_tmp10_ = vala_code_context_get_report (self->priv->context);
	_tmp11_ = vala_report_get_errors (_tmp10_);
	if (_tmp11_ > 0) {
		gint _tmp12_;
		_tmp12_ = vala_vapi_gen_quit (self);
		result = _tmp12_;
		return result;
	}
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			gchar* _tmp13_;
			gchar* source;
			_tmp13_ = g_strdup (source_collection[source_it]);
			source = _tmp13_;
			{
				gboolean _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* depsfile;
				_tmp14_ = g_str_has_suffix (source, ".gi");
				if (!_tmp14_) {
					_g_free0 (source);
					continue;
				}
				_tmp15_ = strlen (source);
				_tmp16_ = strlen ("gi");
				_tmp17_ = string_substring (source, (glong) 0, (glong) (_tmp15_ - _tmp16_));
				_tmp18_ = _tmp17_;
				depsfile = (_tmp19_ = g_strconcat (_tmp18_, "deps", NULL), _g_free0 (_tmp18_), _tmp19_);
				vala_code_context_add_packages_from_file (self->priv->context, depsfile);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp20_ = vala_code_context_get_report (self->priv->context);
	_tmp21_ = vala_report_get_errors (_tmp20_);
	if (_tmp21_ > 0) {
		gint _tmp22_;
		_tmp22_ = vala_vapi_gen_quit (self);
		result = _tmp22_;
		return result;
	}
	if (vala_vapi_gen_library != NULL) {
		gchar* depsfile;
		depsfile = g_strconcat (vala_vapi_gen_library, ".deps", NULL);
		vala_code_context_add_packages_from_file (self->priv->context, depsfile);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp23_ = vala_code_context_get_report (self->priv->context);
	_tmp24_ = vala_report_get_errors (_tmp23_);
	if (_tmp24_ > 0) {
		gint _tmp25_;
		_tmp25_ = vala_vapi_gen_quit (self);
		result = _tmp25_;
		return result;
	}
	if (vala_vapi_gen_packages != NULL) {
		gchar** _tmp27_;
		{
			gchar** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_vapi_gen_packages;
			package_collection_length1 = _vala_array_length (vala_vapi_gen_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_vapi_gen_packages); package_it = package_it + 1) {
				gchar* _tmp26_;
				gchar* package;
				_tmp26_ = g_strdup (package_collection[package_it]);
				package = _tmp26_;
				{
					vala_code_context_add_external_package (self->priv->context, package);
					_g_free0 (package);
				}
			}
		}
		_tmp27_ = NULL;
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = _tmp27_;
	}
	_tmp28_ = vala_code_context_get_report (self->priv->context);
	_tmp29_ = vala_report_get_errors (_tmp28_);
	if (_tmp29_ > 0) {
		gint _tmp30_;
		_tmp30_ = vala_vapi_gen_quit (self);
		result = _tmp30_;
		return result;
	}
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			gchar* _tmp31_;
			gchar* source;
			_tmp31_ = g_strdup (source_collection[source_it]);
			source = _tmp31_;
			{
				gboolean _tmp32_;
				_tmp32_ = g_file_test (source, G_FILE_TEST_EXISTS);
				if (_tmp32_) {
					ValaSourceFile* _tmp33_ = NULL;
					ValaSourceFile* _tmp34_;
					_tmp33_ = vala_source_file_new (self->priv->context, VALA_SOURCE_FILE_TYPE_PACKAGE, source, NULL);
					_tmp34_ = _tmp33_;
					vala_code_context_add_source_file (self->priv->context, _tmp34_);
					_vala_source_file_unref0 (_tmp34_);
				} else {
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_;
					_tmp35_ = g_strdup_printf ("%s not found", source);
					_tmp36_ = _tmp35_;
					vala_report_error (NULL, _tmp36_);
					_g_free0 (_tmp36_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp37_ = vala_code_context_get_report (self->priv->context);
	_tmp38_ = vala_report_get_errors (_tmp37_);
	if (_tmp38_ > 0) {
		gint _tmp39_;
		_tmp39_ = vala_vapi_gen_quit (self);
		result = _tmp39_;
		return result;
	}
	_tmp40_ = vala_parser_new ();
	parser = _tmp40_;
	vala_parser_parse (parser, self->priv->context);
	_tmp41_ = vala_code_context_get_report (self->priv->context);
	_tmp42_ = vala_report_get_errors (_tmp41_);
	if (_tmp42_ > 0) {
		gint _tmp43_;
		_tmp43_ = vala_vapi_gen_quit (self);
		result = _tmp43_;
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp44_ = vala_gir_parser_new ();
	girparser = _tmp44_;
	vala_gir_parser_parse (girparser, self->priv->context);
	_tmp45_ = vala_code_context_get_report (self->priv->context);
	_tmp46_ = vala_report_get_errors (_tmp45_);
	if (_tmp46_ > 0) {
		gint _tmp47_;
		_tmp47_ = vala_vapi_gen_quit (self);
		result = _tmp47_;
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp48_ = vala_gidl_parser_new ();
	gidlparser = _tmp48_;
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	_tmp49_ = vala_code_context_get_report (self->priv->context);
	_tmp50_ = vala_report_get_errors (_tmp49_);
	if (_tmp50_ > 0) {
		gint _tmp51_;
		_tmp51_ = vala_vapi_gen_quit (self);
		result = _tmp51_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	vala_code_context_check (self->priv->context);
	_tmp52_ = vala_code_context_get_report (self->priv->context);
	_tmp53_ = vala_report_get_errors (_tmp52_);
	if (_tmp53_ > 0) {
		gint _tmp54_;
		_tmp54_ = vala_vapi_gen_quit (self);
		result = _tmp54_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	{
		ValaList* _tmp55_ = NULL;
		ValaList* _file_list;
		gint _tmp56_;
		gint _file_size;
		gint _file_index;
		_tmp55_ = vala_code_context_get_source_files (self->priv->context);
		_file_list = _tmp55_;
		_tmp56_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp56_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp57_ = NULL;
			ValaSourceFile* file;
			const gchar* _tmp58_ = NULL;
			gboolean _tmp59_;
			const gchar* _tmp60_ = NULL;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp57_ = vala_list_get (_file_list, _file_index);
			file = (ValaSourceFile*) _tmp57_;
			_tmp58_ = vala_source_file_get_filename (file);
			_tmp59_ = g_str_has_suffix (_tmp58_, ".vapi");
			if (_tmp59_) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp60_ = vala_source_file_get_filename (file);
			if (_vala_string_array_contains (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), _tmp60_)) {
				vala_source_file_set_file_type (file, VALA_SOURCE_FILE_TYPE_SOURCE);
			} else {
				const gchar* _tmp61_ = NULL;
				gboolean _tmp62_;
				_tmp61_ = vala_source_file_get_filename (file);
				_tmp62_ = g_str_has_suffix (_tmp61_, ".metadata");
				if (_tmp62_) {
					const gchar* _tmp63_ = NULL;
					const gchar* _tmp64_ = NULL;
					gint _tmp65_;
					gint _tmp66_;
					gchar* _tmp67_ = NULL;
					gchar* _tmp68_;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_;
					gchar* gir_filename;
					_tmp63_ = vala_source_file_get_filename (file);
					_tmp64_ = vala_source_file_get_filename (file);
					_tmp65_ = strlen (_tmp64_);
					_tmp66_ = strlen (".metadata");
					_tmp67_ = string_substring (_tmp63_, (glong) 0, (glong) (_tmp65_ - _tmp66_));
					_tmp68_ = _tmp67_;
					_tmp69_ = g_strdup_printf ("%s.gir", _tmp68_);
					gir_filename = (_tmp70_ = _tmp69_, _g_free0 (_tmp68_), _tmp70_);
					if (_vala_string_array_contains (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), gir_filename)) {
						vala_source_file_set_file_type (file, VALA_SOURCE_FILE_TYPE_SOURCE);
					}
					_g_free0 (gir_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp71_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
	interface_writer = _tmp71_;
	_tmp72_ = g_strdup_printf ("%s.vapi", vala_vapi_gen_library);
	vapi_filename = _tmp72_;
	if (vala_vapi_gen_directory != NULL) {
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_;
		_tmp73_ = g_build_filename (vala_vapi_gen_directory, vapi_filename, NULL);
		_tmp74_ = _tmp73_;
		_g_free0 (vapi_filename);
		vapi_filename = _tmp74_;
	}
	vala_code_writer_write_file (interface_writer, self->priv->context, vapi_filename);
	_tmp75_ = NULL;
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = _tmp75_;
	_tmp76_ = vala_vapi_gen_quit (self);
	result = _tmp76_;
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint vala_vapi_gen_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* opt_context;
	ValaVAPIGen* _tmp1_ = NULL;
	ValaVAPIGen* vapigen;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("- Vala API Generator");
	opt_context = _tmp0_;
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
	g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch3_g_option_error;
		}
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_g_option_context_free0 (opt_context);
	goto __finally3;
	__catch3_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_vapi_gen_version) {
		fprintf (stdout, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp1_ = vala_vapi_gen_new ();
	vapigen = _tmp1_;
	_tmp2_ = vala_vapi_gen_run (vapigen);
	result = _tmp2_;
	_g_object_unref0 (vapigen);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_gen_main (argv, argc);
}


ValaVAPIGen* vala_vapi_gen_construct (GType object_type) {
	ValaVAPIGen * self = NULL;
	self = (ValaVAPIGen*) g_object_new (object_type, NULL);
	return self;
}


ValaVAPIGen* vala_vapi_gen_new (void) {
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_vapi_gen_finalize;
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_finalize (GObject* obj) {
	ValaVAPIGen * self;
	self = VALA_VAPI_GEN (obj);
	_vala_code_context_unref0 (self->priv->context);
	G_OBJECT_CLASS (vala_vapi_gen_parent_class)->finalize (obj);
}


GType vala_vapi_gen_get_type (void) {
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, NULL };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



