/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valagee.h>


#define VALA_TYPE_GIR_WRITER (vala_gir_writer_get_type ())
#define VALA_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriter))
#define VALA_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))
#define VALA_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_WRITER))
#define VALA_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_WRITER))
#define VALA_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))

typedef struct _ValaGIRWriter ValaGIRWriter;
typedef struct _ValaGIRWriterClass ValaGIRWriterClass;
typedef struct _ValaGIRWriterPrivate ValaGIRWriterPrivate;

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaGIRWriter {
	ValaCodeVisitor parent_instance;
	ValaGIRWriterPrivate * priv;
};

struct _ValaGIRWriterClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaArrayList* externals;
	gint enum_value;
};


static gpointer vala_gir_writer_parent_class = NULL;

GType vala_gir_writer_get_type (void) G_GNUC_CONST;
static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
#define VALA_GIR_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_WRITER, ValaGIRWriterPrivate))
enum  {
	VALA_GIR_WRITER_DUMMY_PROPERTY
};
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g);
void vala_gir_writer_write_includes (ValaGIRWriter* self);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_namespace, const gchar* gir_version, const gchar* package);
static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix);
static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, const gchar* tag, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction, gboolean constructor);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, gboolean constructor, ValaDataType* instance_type, gboolean user_data);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version);
ValaGIRWriter* vala_gir_writer_new (void);
ValaGIRWriter* vala_gir_writer_construct (GType object_type);
static void vala_gir_writer_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_gir_writer_write_includes (ValaGIRWriter* self) {
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _tmp0_;
		ValaArrayList* _i_list;
		gint _tmp1_;
		gint _i_size;
		gint _i_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->externals);
		_i_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _i_list);
		_i_size = _tmp1_;
		_i_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaGIRWriterGIRNamespace* i;
			_i_index = _i_index + 1;
			if (!(_i_index < _i_size)) {
				break;
			}
			_tmp2_ = vala_list_get ((ValaList*) _i_list, _i_index);
			i = (ValaGIRWriterGIRNamespace*) _tmp2_;
			vala_gir_writer_write_indent_stream (self);
			fprintf (self->priv->stream, "<include name=\"%s\" version=\"%s\"/>\n", (*i).ns, (*i).version);
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_iterable_unref0 (_i_list);
	}
}


/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context  a code context
 * @param filename a relative or absolute filename
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_namespace, const gchar* gir_version, const gchar* package) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaNamespace* _tmp8_ = NULL;
	ValaNamespace* _tmp9_;
	ValaNamespace* root_symbol;
	ValaScope* _tmp10_ = NULL;
	ValaSymbol* _tmp11_ = NULL;
	ValaSymbol* glib_ns;
	ValaScope* _tmp12_ = NULL;
	ValaSymbol* _tmp13_ = NULL;
	ValaTypeSymbol* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* filename;
	FILE* _tmp16_ = NULL;
	FILE* _tmp17_;
	FILE* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_tmp1_ = _tmp0_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = g_strdup (directory);
	_tmp3_ = _tmp2_;
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp3_;
	_tmp4_ = g_strdup (gir_namespace);
	_tmp5_ = _tmp4_;
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp5_;
	_tmp6_ = g_strdup (gir_version);
	_tmp7_ = _tmp6_;
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp7_;
	_tmp8_ = vala_code_context_get_root (context);
	_tmp9_ = _vala_code_node_ref0 (_tmp8_);
	root_symbol = _tmp9_;
	_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) root_symbol);
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	glib_ns = _tmp11_;
	_tmp12_ = vala_symbol_get_scope (glib_ns);
	_tmp13_ = vala_scope_lookup (_tmp12_, "Object");
	_tmp14_ = VALA_TYPESYMBOL (_tmp13_);
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = _tmp14_;
	vala_gir_writer_write_package (self, package);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	self->priv->indent--;
	g_string_append_printf (self->priv->buffer, "</repository>\n");
	_tmp15_ = g_strdup_printf ("%s%c%s-%s.gir", directory, (gint) G_DIR_SEPARATOR, gir_namespace, gir_version);
	filename = _tmp15_;
	_tmp16_ = fopen (filename, "w");
	_tmp17_ = _tmp16_;
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp17_;
	if (self->priv->stream == NULL) {
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp18_ = g_strdup_printf ("unable to open `%s' for writing", filename);
		_tmp19_ = _tmp18_;
		vala_report_error (NULL, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	fprintf (self->priv->stream, "<?xml version=\"1.0\"?>\n");
	fprintf (self->priv->stream, "<repository version=\"1.2\"");
	fprintf (self->priv->stream, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	fprintf (self->priv->stream, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	fprintf (self->priv->stream, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	fprintf (self->priv->stream, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_includes (self);
	self->priv->indent--;
	fputs (self->priv->buffer->str, self->priv->stream);
	_tmp20_ = NULL;
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp20_;
	{
		ValaIterator* _tmp21_ = NULL;
		ValaIterator* _ns_it;
		_tmp21_ = vala_iterable_iterator ((ValaIterable*) self->priv->unannotated_namespaces);
		_ns_it = _tmp21_;
		while (TRUE) {
			gboolean _tmp22_;
			gpointer _tmp23_ = NULL;
			ValaNamespace* ns;
			gboolean _tmp24_;
			_tmp22_ = vala_iterator_next (_ns_it);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = vala_iterator_get (_ns_it);
			ns = (ValaNamespace*) _tmp23_;
			_tmp24_ = vala_collection_contains ((ValaCollection*) self->priv->our_namespaces, ns);
			if (!_tmp24_) {
				ValaSourceReference* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
				_tmp26_ = vala_symbol_get_name ((ValaSymbol*) ns);
				_tmp27_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", _tmp26_);
				_tmp28_ = _tmp27_;
				vala_report_warning (_tmp25_, _tmp28_);
				_g_free0 (_tmp28_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaIterator* _tmp29_ = NULL;
		ValaIterator* _ns_it;
		_tmp29_ = vala_iterable_iterator ((ValaIterable*) self->priv->our_namespaces);
		_ns_it = _tmp29_;
		while (TRUE) {
			gboolean _tmp30_;
			gpointer _tmp31_ = NULL;
			ValaNamespace* ns;
			ValaSourceReference* _tmp32_ = NULL;
			ValaSourceFile* _tmp33_ = NULL;
			ValaSourceReference* _tmp34_ = NULL;
			ValaSourceFile* _tmp35_ = NULL;
			_tmp30_ = vala_iterator_next (_ns_it);
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = vala_iterator_get (_ns_it);
			ns = (ValaNamespace*) _tmp31_;
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			_tmp33_ = vala_source_reference_get_file (_tmp32_);
			vala_source_file_set_gir_namespace (_tmp33_, gir_namespace);
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			_tmp35_ = vala_source_reference_get_file (_tmp34_);
			vala_source_file_set_gir_version (_tmp35_, gir_version);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}


static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<package name=\"%s\"/>\n", package);
}


static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns) {
	ValaHashSet* _tmp0_ = NULL;
	ValaSet* header_filenames;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	header_filenames = (ValaSet*) _tmp0_;
	{
		ValaList* _tmp1_ = NULL;
		ValaList* _c_header_filename_list;
		gint _tmp2_;
		gint _c_header_filename_size;
		gint _c_header_filename_index;
		_tmp1_ = vala_symbol_get_cheader_filenames ((ValaSymbol*) ns);
		_c_header_filename_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _c_header_filename_list);
		_c_header_filename_size = _tmp2_;
		_c_header_filename_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			gchar* c_header_filename;
			_c_header_filename_index = _c_header_filename_index + 1;
			if (!(_c_header_filename_index < _c_header_filename_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_c_header_filename_list, _c_header_filename_index);
			c_header_filename = (gchar*) _tmp3_;
			vala_collection_add ((ValaCollection*) header_filenames, c_header_filename);
			_g_free0 (c_header_filename);
		}
		_vala_iterable_unref0 (_c_header_filename_list);
	}
	{
		ValaScope* _tmp4_ = NULL;
		ValaMap* _tmp5_ = NULL;
		ValaMap* _tmp6_;
		ValaCollection* _tmp7_ = NULL;
		ValaCollection* _tmp8_;
		ValaIterator* _tmp9_ = NULL;
		ValaIterator* _tmp10_;
		ValaIterator* _symbol_it;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) ns);
		_tmp5_ = vala_scope_get_symbol_table (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_map_get_values (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_iterable_iterator ((ValaIterable*) _tmp8_);
		_symbol_it = (_tmp10_ = _tmp9_, _vala_iterable_unref0 (_tmp8_), _vala_map_unref0 (_tmp6_), _tmp10_);
		while (TRUE) {
			gboolean _tmp11_;
			gpointer _tmp12_ = NULL;
			ValaSymbol* symbol;
			_tmp11_ = vala_iterator_next (_symbol_it);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = vala_iterator_get (_symbol_it);
			symbol = (ValaSymbol*) _tmp12_;
			{
				ValaList* _tmp13_ = NULL;
				ValaList* _c_header_filename_list;
				gint _tmp14_;
				gint _c_header_filename_size;
				gint _c_header_filename_index;
				_tmp13_ = vala_symbol_get_cheader_filenames (symbol);
				_c_header_filename_list = _tmp13_;
				_tmp14_ = vala_collection_get_size ((ValaCollection*) _c_header_filename_list);
				_c_header_filename_size = _tmp14_;
				_c_header_filename_index = -1;
				while (TRUE) {
					gpointer _tmp15_ = NULL;
					gchar* c_header_filename;
					_c_header_filename_index = _c_header_filename_index + 1;
					if (!(_c_header_filename_index < _c_header_filename_size)) {
						break;
					}
					_tmp15_ = vala_list_get (_c_header_filename_list, _c_header_filename_index);
					c_header_filename = (gchar*) _tmp15_;
					vala_collection_add ((ValaCollection*) header_filenames, c_header_filename);
					_g_free0 (c_header_filename);
				}
				_vala_iterable_unref0 (_c_header_filename_list);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaIterator* _tmp16_ = NULL;
		ValaIterator* _c_header_filename_it;
		_tmp16_ = vala_iterable_iterator ((ValaIterable*) header_filenames);
		_c_header_filename_it = _tmp16_;
		while (TRUE) {
			gboolean _tmp17_;
			gpointer _tmp18_ = NULL;
			gchar* c_header_filename;
			_tmp17_ = vala_iterator_next (_c_header_filename_it);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = vala_iterator_get (_c_header_filename_it);
			c_header_filename = (gchar*) _tmp18_;
			vala_gir_writer_write_c_include (self, c_header_filename);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}


static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<c:include name=\"%s\"/>\n", name);
}


static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	const gchar* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* cprefix;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) ns);
	if (_tmp1_ == NULL) {
		vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) ns);
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
		return;
	}
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) ns);
	_tmp3_ = vala_symbol_get_name (_tmp2_);
	if (_tmp3_ != NULL) {
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		return;
	}
	vala_gir_writer_write_c_includes (self, ns);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<namespace name=\"%s\" version=\"%s\"", self->priv->gir_namespace, self->priv->gir_version);
	_tmp4_ = vala_symbol_get_cprefix ((ValaSymbol*) ns);
	cprefix = _tmp4_;
	if (cprefix != NULL) {
		g_string_append_printf (self->priv->buffer, " c:prefix=\"%s\"", cprefix);
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) ns);
	vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) ns);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
	vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</namespace>\n");
	vala_collection_add ((ValaCollection*) self->priv->our_namespaces, ns);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (cprefix);
}


static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = vala_symbol_get_deprecated (symbol);
	if (_tmp0_) {
		gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp1_ = NULL;
		_tmp2_ = vala_symbol_get_replacement (symbol);
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_strdup ("");
			_tmp4_ = _tmp3_;
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp4_;
		} else {
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp5_ = vala_symbol_get_replacement (symbol);
			_tmp6_ = g_strdup_printf ("Use %s", _tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp7_;
		}
		g_string_append_printf (self->priv->buffer, " deprecated=\"%s\"", _tmp1_);
		_tmp8_ = vala_symbol_get_deprecated_since (symbol);
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = vala_symbol_get_deprecated_since (symbol);
			g_string_append_printf (self->priv->buffer, " deprecated-version=\"%s\"", _tmp9_);
		}
		_g_free0 (_tmp1_);
	}
}


static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gpointer _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cl);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) cl);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	_tmp3_ = (ValaSymbol*) _tmp2_;
	if ((_tmp4_ = !VALA_IS_NAMESPACE (_tmp3_), _vala_code_node_unref0 (_tmp3_), _tmp4_)) {
		vala_collection_add ((ValaCollection*) self->priv->deferred, (ValaCodeNode*) cl);
		return;
	}
	_tmp5_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, self->priv->gobject_type);
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* gtype_struct_name;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		ValaClass* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gboolean _tmp12_;
		ValaClass* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		ValaClass* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		const gchar* _tmp30_ = NULL;
		ValaClass* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		ValaClass* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		_tmp6_ = vala_symbol_get_name ((ValaSymbol*) cl);
		gtype_struct_name = g_strconcat (_tmp6_, "Class", NULL);
		vala_gir_writer_write_indent (self);
		_tmp7_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp8_ = _tmp7_;
		g_string_append_printf (self->priv->buffer, "<class name=\"%s\"", _tmp8_);
		_g_free0 (_tmp8_);
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) cl);
		g_string_append_printf (self->priv->buffer, " glib:type-struct=\"%s\"", gtype_struct_name);
		_tmp9_ = vala_class_get_base_class (cl);
		_tmp10_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append_printf (self->priv->buffer, " parent=\"%s\"", _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = vala_class_get_is_abstract (cl);
		if (_tmp12_) {
			g_string_append_printf (self->priv->buffer, " abstract=\"1\"");
		}
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cl);
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		{
			ValaList* _tmp13_ = NULL;
			ValaList* _base_type_list;
			gint _tmp14_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp13_ = vala_class_get_base_types (cl);
			_base_type_list = _tmp13_;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_size = _tmp14_;
			_base_type_index = -1;
			while (TRUE) {
				gpointer _tmp15_ = NULL;
				ValaDataType* base_type;
				ValaObjectType* _tmp16_;
				ValaObjectType* object_type;
				ValaObjectTypeSymbol* _tmp17_ = NULL;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp15_ = vala_list_get (_base_type_list, _base_type_index);
				base_type = (ValaDataType*) _tmp15_;
				_tmp16_ = _vala_code_node_ref0 (VALA_OBJECT_TYPE (base_type));
				object_type = _tmp16_;
				_tmp17_ = vala_object_type_get_type_symbol (object_type);
				if (VALA_IS_INTERFACE (_tmp17_)) {
					ValaObjectTypeSymbol* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					vala_gir_writer_write_indent (self);
					_tmp18_ = vala_object_type_get_type_symbol (object_type);
					_tmp19_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp18_);
					_tmp20_ = _tmp19_;
					g_string_append_printf (self->priv->buffer, "<implements name=\"%s\"/>\n", _tmp20_);
					_g_free0 (_tmp20_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) cl);
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<field name=\"parent_instance\">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		_tmp21_ = vala_class_get_base_class (cl);
		_tmp22_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_class_get_base_class (cl);
		_tmp25_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) _tmp24_, FALSE);
		_tmp26_ = _tmp25_;
		g_string_append_printf (self->priv->buffer, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp23_, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</field>\n");
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<field name=\"priv\">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) cl);
		_tmp28_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE);
		_tmp29_ = _tmp28_;
		g_string_append_printf (self->priv->buffer, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp27_, _tmp29_);
		_g_free0 (_tmp29_);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</field>\n");
		vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</class>\n");
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", gtype_struct_name);
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) cl, "Class");
		_tmp30_ = vala_symbol_get_name ((ValaSymbol*) cl);
		g_string_append_printf (self->priv->buffer, " glib:is-gtype-struct-for=\"%s\"", _tmp30_);
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<field name=\"parent_class\">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		_tmp31_ = vala_class_get_base_class (cl);
		_tmp32_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_class_get_base_class (cl);
		_tmp35_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) _tmp34_, FALSE);
		_tmp36_ = _tmp35_;
		g_string_append_printf (self->priv->buffer, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp33_, _tmp36_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp33_);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</field>\n");
		{
			ValaList* _tmp37_ = NULL;
			ValaList* _m_list;
			gint _tmp38_;
			gint _m_size;
			gint _m_index;
			_tmp37_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
			_m_list = _tmp37_;
			_tmp38_ = vala_collection_get_size ((ValaCollection*) _m_list);
			_m_size = _tmp38_;
			_m_index = -1;
			while (TRUE) {
				gpointer _tmp39_ = NULL;
				ValaMethod* m;
				gboolean _tmp40_ = FALSE;
				gboolean _tmp41_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp39_ = vala_list_get (_m_list, _m_index);
				m = (ValaMethod*) _tmp39_;
				_tmp41_ = vala_method_get_is_abstract (m);
				if (_tmp41_) {
					_tmp40_ = TRUE;
				} else {
					gboolean _tmp42_;
					_tmp42_ = vala_method_get_is_virtual (m);
					_tmp40_ = _tmp42_;
				}
				if (_tmp40_) {
					const gchar* _tmp43_ = NULL;
					vala_gir_writer_write_indent (self);
					_tmp43_ = vala_symbol_get_name ((ValaSymbol*) m);
					g_string_append_printf (self->priv->buffer, "<field name=\"%s\">\n", _tmp43_);
					self->priv->indent++;
					vala_gir_writer_write_signature (self, m, "callback", TRUE);
					self->priv->indent--;
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "</field>\n");
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _tmp44_ = NULL;
			ValaList* _sig_list;
			gint _tmp45_;
			gint _sig_size;
			gint _sig_index;
			_tmp44_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl);
			_sig_list = _tmp44_;
			_tmp45_ = vala_collection_get_size ((ValaCollection*) _sig_list);
			_sig_size = _tmp45_;
			_sig_index = -1;
			while (TRUE) {
				gpointer _tmp46_ = NULL;
				ValaSignal* sig;
				ValaMethod* _tmp47_ = NULL;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp46_ = vala_list_get (_sig_list, _sig_index);
				sig = (ValaSignal*) _tmp46_;
				_tmp47_ = vala_signal_get_default_handler (sig);
				if (_tmp47_ != NULL) {
					const gchar* _tmp48_ = NULL;
					ValaMethod* _tmp49_ = NULL;
					vala_gir_writer_write_indent (self);
					_tmp48_ = vala_symbol_get_name ((ValaSymbol*) sig);
					g_string_append_printf (self->priv->buffer, "<field name=\"%s\">\n", _tmp48_);
					self->priv->indent++;
					_tmp49_ = vala_signal_get_default_handler (sig);
					vala_gir_writer_write_signature (self, _tmp49_, "callback", TRUE);
					self->priv->indent--;
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp50_ = vala_symbol_get_name ((ValaSymbol*) cl);
		_tmp51_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE);
		_tmp52_ = _tmp51_;
		g_string_append_printf (self->priv->buffer, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp50_, _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (gtype_struct_name);
	} else {
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_;
		vala_gir_writer_write_indent (self);
		_tmp53_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp54_ = _tmp53_;
		g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", _tmp54_);
		_g_free0 (_tmp54_);
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cl);
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) cl);
		vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gpointer _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) st);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) st);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	_tmp3_ = (ValaSymbol*) _tmp2_;
	if ((_tmp4_ = !VALA_IS_NAMESPACE (_tmp3_), _vala_code_node_unref0 (_tmp3_), _tmp4_)) {
		vala_collection_add ((ValaCollection*) self->priv->deferred, (ValaCodeNode*) st);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) st);
	_tmp6_ = _tmp5_;
	g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", _tmp6_);
	_g_free0 (_tmp6_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) st);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) st);
	vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) st);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
	vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gpointer _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* gtype_struct_name;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	ValaList* _tmp8_ = NULL;
	ValaList* _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp18_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) iface);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) iface);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	_tmp3_ = (ValaSymbol*) _tmp2_;
	if ((_tmp4_ = !VALA_IS_NAMESPACE (_tmp3_), _vala_code_node_unref0 (_tmp3_), _tmp4_)) {
		vala_collection_add ((ValaCollection*) self->priv->deferred, (ValaCodeNode*) iface);
		return;
	}
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) iface);
	gtype_struct_name = g_strconcat (_tmp5_, "Iface", NULL);
	vala_gir_writer_write_indent (self);
	_tmp6_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp7_ = _tmp6_;
	g_string_append_printf (self->priv->buffer, "<interface name=\"%s\"", _tmp7_);
	_g_free0 (_tmp7_);
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) iface);
	g_string_append_printf (self->priv->buffer, " glib:type-struct=\"%s\"", gtype_struct_name);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) iface);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	_tmp8_ = vala_interface_get_prerequisites (iface);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
	if ((_tmp11_ = _tmp10_ > 0, _vala_iterable_unref0 (_tmp9_), _tmp11_)) {
		{
			ValaList* _tmp12_ = NULL;
			ValaList* _base_type_list;
			gint _tmp13_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp12_ = vala_interface_get_prerequisites (iface);
			_base_type_list = _tmp12_;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_size = _tmp13_;
			_base_type_index = -1;
			while (TRUE) {
				gpointer _tmp14_ = NULL;
				ValaDataType* base_type;
				ValaObjectTypeSymbol* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp14_ = vala_list_get (_base_type_list, _base_type_index);
				base_type = (ValaDataType*) _tmp14_;
				vala_gir_writer_write_indent (self);
				_tmp15_ = vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (base_type));
				_tmp16_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp15_);
				_tmp17_ = _tmp16_;
				g_string_append_printf (self->priv->buffer, "<prerequisite name=\"%s\"/>\n", _tmp17_);
				_g_free0 (_tmp17_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) iface);
	vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) iface);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</interface>\n");
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", gtype_struct_name);
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) iface, "Iface");
	_tmp18_ = vala_symbol_get_name ((ValaSymbol*) iface);
	g_string_append_printf (self->priv->buffer, " glib:is-gtype-struct-for=\"%s\"", _tmp18_);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	{
		ValaList* _tmp19_ = NULL;
		ValaList* _m_list;
		gint _tmp20_;
		gint _m_size;
		gint _m_index;
		_tmp19_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface);
		_m_list = _tmp19_;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp20_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp21_ = NULL;
			ValaMethod* m;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp21_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp21_;
			_tmp23_ = vala_method_get_is_abstract (m);
			if (_tmp23_) {
				_tmp22_ = TRUE;
			} else {
				gboolean _tmp24_;
				_tmp24_ = vala_method_get_is_virtual (m);
				_tmp22_ = _tmp24_;
			}
			if (_tmp22_) {
				vala_gir_writer_write_signature (self, m, "callback", TRUE);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}


static void vala_gir_writer_visit_deferred (ValaGIRWriter* self) {
	ValaArrayList* _tmp0_;
	ValaArrayList* nodes;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->deferred);
	nodes = _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	_tmp2_ = _tmp1_;
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp2_;
	{
		ValaArrayList* _tmp3_;
		ValaArrayList* _node_list;
		gint _tmp4_;
		gint _node_size;
		gint _node_index;
		_tmp3_ = _vala_iterable_ref0 (nodes);
		_node_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaCodeNode* node;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp5_ = vala_list_get ((ValaList*) _node_list, _node_index);
			node = (ValaCodeNode*) _tmp5_;
			vala_code_node_accept (node, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_iterable_unref0 (nodes);
}


static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol) {
	gchar* result = NULL;
	gchar* gir_name;
	gpointer _tmp0_ = NULL;
	ValaSymbol* h0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	h0 = (ValaSymbol*) _tmp0_;
	{
		ValaSymbol* _tmp1_;
		ValaSymbol* cur_sym;
		_tmp1_ = _vala_code_node_ref0 (symbol);
		cur_sym = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				if (!_tmp2_) {
					ValaSymbol* _tmp3_ = NULL;
					ValaSymbol* _tmp4_;
					ValaSymbol* _tmp5_;
					_tmp3_ = vala_symbol_get_parent_symbol (cur_sym);
					_tmp4_ = _vala_code_node_ref0 (_tmp3_);
					_tmp5_ = _tmp4_;
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp5_;
				}
				_tmp2_ = FALSE;
				if (!(cur_sym != NULL)) {
					break;
				}
				if (cur_sym == h0) {
					break;
				}
				_tmp6_ = vala_symbol_get_gir_name (cur_sym);
				_tmp7_ = g_strconcat (_tmp6_, gir_name, NULL);
				_tmp8_ = _tmp7_;
				_g_free0 (gir_name);
				gir_name = _tmp8_;
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}


static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gpointer _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* element_name;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) en);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) en);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	_tmp3_ = (ValaSymbol*) _tmp2_;
	if ((_tmp4_ = !VALA_IS_NAMESPACE (_tmp3_), _vala_code_node_unref0 (_tmp3_), _tmp4_)) {
		vala_collection_add ((ValaCollection*) self->priv->deferred, (ValaCodeNode*) en);
		return;
	}
	_tmp5_ = NULL;
	_tmp6_ = vala_enum_get_is_flags (en);
	if (_tmp6_) {
		_tmp5_ = "bitfield";
	} else {
		_tmp5_ = "enumeration";
	}
	_tmp7_ = g_strdup (_tmp5_);
	element_name = _tmp7_;
	vala_gir_writer_write_indent (self);
	_tmp8_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) en);
	_tmp9_ = _tmp8_;
	g_string_append_printf (self->priv->buffer, "<%s name=\"%s\"", element_name, _tmp9_);
	_g_free0 (_tmp9_);
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) en);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) en);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) en);
	self->priv->enum_value = 0;
	vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) en);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
	vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</%s>\n", element_name);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}


static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaGIRWriter * self;
	gpointer _tmp0_ = NULL;
	ValaEnum* en;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	ValaExpression* _tmp6_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	en = VALA_ENUM ((ValaSymbol*) _tmp0_);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) ev);
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_constant_get_cname ((ValaConstant*) ev);
	_tmp5_ = _tmp4_;
	g_string_append_printf (self->priv->buffer, "<member name=\"%s\" c:identifier=\"%s\"", _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = vala_constant_get_value ((ValaConstant*) ev);
	if (_tmp6_ != NULL) {
		ValaExpression* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* value;
		_tmp7_ = vala_constant_get_value ((ValaConstant*) ev);
		_tmp8_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp7_);
		value = _tmp8_;
		g_string_append_printf (self->priv->buffer, " value=\"%s\"", value);
		_g_free0 (value);
	} else {
		gboolean _tmp9_;
		_tmp9_ = vala_enum_get_is_flags (en);
		if (_tmp9_) {
			gint _tmp10_;
			_tmp10_ = self->priv->enum_value;
			self->priv->enum_value = _tmp10_ + 1;
			g_string_append_printf (self->priv->buffer, " value=\"%d\"", 1 << _tmp10_);
		} else {
			gint _tmp11_;
			_tmp11_ = self->priv->enum_value;
			self->priv->enum_value = _tmp11_ + 1;
			g_string_append_printf (self->priv->buffer, " value=\"%d\"", _tmp11_);
		}
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) ev);
	g_string_append_printf (self->priv->buffer, "/>\n");
	_vala_code_node_unref0 (en);
}


static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) edomain);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) edomain);
	if (!_tmp1_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	g_string_append_printf (self->priv->buffer, "<errordomain name=\"%s\"", _tmp2_);
	_tmp3_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain);
	_tmp4_ = _tmp3_;
	g_string_append_printf (self->priv->buffer, " get-quark=\"%squark\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	g_string_append_printf (self->priv->buffer, " codes=\"%s\"", _tmp5_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) edomain);
	g_string_append_printf (self->priv->buffer, ">\n");
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) edomain);
	g_string_append_printf (self->priv->buffer, "</errordomain>\n");
	vala_gir_writer_write_indent (self);
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	g_string_append_printf (self->priv->buffer, "<enumeration name=\"%s\"", _tmp6_);
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) edomain, "");
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	self->priv->enum_value = 0;
	vala_list_insert ((ValaList*) self->priv->hierarchy, 0, (ValaSymbol*) edomain);
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	vala_list_remove_at ((ValaList*) self->priv->hierarchy, 0);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaGIRWriter * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	ValaExpression* _tmp5_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) ecode);
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE);
	_tmp4_ = _tmp3_;
	g_string_append_printf (self->priv->buffer, "<member name=\"%s\" c:identifier=\"%s\"", _tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = vala_error_code_get_value (ecode);
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* value;
		_tmp6_ = vala_error_code_get_value (ecode);
		_tmp7_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp6_);
		value = _tmp7_;
		g_string_append_printf (self->priv->buffer, " value=\"%s\"", value);
		_g_free0 (value);
	} else {
		gint _tmp8_;
		_tmp8_ = self->priv->enum_value;
		self->priv->enum_value = _tmp8_ + 1;
		g_string_append_printf (self->priv->buffer, " value=\"%d\"", _tmp8_);
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) ecode);
	g_string_append_printf (self->priv->buffer, "/>\n");
}


static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp2_ = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* initializer;
	gchar* _tmp4_ = NULL;
	gchar* value;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	ValaDataType* _tmp8_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) c);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) c);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = vala_constant_get_value (c);
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	initializer = _tmp3_;
	_tmp4_ = vala_gir_writer_literal_expression_to_value_string (self, initializer);
	value = _tmp4_;
	vala_gir_writer_write_indent (self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp6_ = vala_constant_get_cname (c);
	_tmp7_ = _tmp6_;
	g_string_append_printf (self->priv->buffer, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	g_string_append_printf (self->priv->buffer, " value=\"%s\"", value);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) c);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	_tmp8_ = vala_expression_get_value_type (initializer);
	vala_gir_writer_write_type (self, _tmp8_, -1);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}


static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	ValaDataType* _tmp4_ = NULL;
	gboolean _tmp5_;
	ValaDataType* _tmp6_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) f);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) f);
	if (!_tmp1_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = vala_field_get_cname (f);
	_tmp3_ = _tmp2_;
	g_string_append_printf (self->priv->buffer, "<field name=\"%s\"", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp5_ = vala_data_type_get_nullable (_tmp4_);
	if (_tmp5_) {
		g_string_append_printf (self->priv->buffer, " allow-none=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) f);
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) f);
	vala_gir_writer_write_type (self, _tmp6_, -1);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</field>\n");
}


static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		_tmp0_ = has_array_length;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeContext* _tmp1_ = NULL;
		ValaCodeContext* _tmp2_;
		ValaNamespace* _tmp3_ = NULL;
		ValaScope* _tmp4_ = NULL;
		ValaSymbol* _tmp5_ = NULL;
		ValaSymbol* _tmp6_;
		ValaStruct* _tmp7_;
		ValaIntegerType* _tmp8_ = NULL;
		ValaIntegerType* _tmp9_;
		ValaIntegerType* int_type;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp1_ = vala_code_context_get ();
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_code_context_get_root (_tmp2_);
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) _tmp3_);
		_tmp5_ = vala_scope_lookup (_tmp4_, "int");
		_tmp7_ = (_tmp6_ = _tmp5_, VALA_IS_STRUCT (_tmp6_) ? ((ValaStruct*) _tmp6_) : NULL);
		_tmp8_ = vala_integer_type_new (_tmp7_, NULL, NULL);
		int_type = (_tmp9_ = _tmp8_, _vala_code_node_unref0 (_tmp7_), _vala_code_context_unref0 (_tmp2_), _tmp9_);
		_tmp10_ = g_strdup_printf ("%s_length1", name);
		_tmp11_ = _tmp10_;
		vala_gir_writer_write_param_or_return (self, (ValaDataType*) int_type, "parameter", index, has_array_length, _tmp11_, direction, FALSE);
		_g_free0 (_tmp11_);
		_vala_code_node_unref0 (int_type);
	} else {
		if (VALA_IS_DELEGATE_TYPE (type)) {
			ValaVoidType* _tmp12_ = NULL;
			ValaVoidType* _tmp13_;
			ValaPointerType* _tmp14_ = NULL;
			ValaPointerType* _tmp15_;
			ValaPointerType* data_type;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp12_ = vala_void_type_new (NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_pointer_type_new ((ValaDataType*) _tmp13_, NULL);
			data_type = (_tmp15_ = _tmp14_, _vala_code_node_unref0 (_tmp13_), _tmp15_);
			_tmp16_ = g_strdup_printf ("%s_target", name);
			_tmp17_ = _tmp16_;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) data_type, "parameter", index, FALSE, _tmp17_, direction, FALSE);
			_g_free0 (_tmp17_);
			_tmp18_ = vala_data_type_get_value_owned (type);
			if (_tmp18_) {
				ValaCodeContext* _tmp19_ = NULL;
				ValaCodeContext* _tmp20_;
				ValaNamespace* _tmp21_ = NULL;
				ValaScope* _tmp22_ = NULL;
				ValaSymbol* _tmp23_ = NULL;
				ValaSymbol* _tmp24_;
				ValaScope* _tmp25_ = NULL;
				ValaSymbol* _tmp26_ = NULL;
				ValaSymbol* _tmp27_;
				ValaDelegate* _tmp28_;
				ValaDelegateType* _tmp29_ = NULL;
				ValaDelegateType* _tmp30_;
				ValaDelegateType* notify_type;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				_tmp19_ = vala_code_context_get ();
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_code_context_get_root (_tmp20_);
				_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
				_tmp23_ = vala_scope_lookup (_tmp22_, "GLib");
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_scope (_tmp24_);
				_tmp26_ = vala_scope_lookup (_tmp25_, "DestroyNotify");
				_tmp28_ = (_tmp27_ = _tmp26_, VALA_IS_DELEGATE (_tmp27_) ? ((ValaDelegate*) _tmp27_) : NULL);
				_tmp29_ = vala_delegate_type_new (_tmp28_);
				notify_type = (_tmp30_ = _tmp29_, _vala_code_node_unref0 (_tmp28_), _vala_code_node_unref0 (_tmp24_), _vala_code_context_unref0 (_tmp20_), _tmp30_);
				_tmp31_ = g_strdup_printf ("%s_target_destroy_notify", name);
				_tmp32_ = _tmp31_;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) notify_type, "parameter", index, FALSE, _tmp32_, direction, FALSE);
				_g_free0 (_tmp32_);
				_vala_code_node_unref0 (notify_type);
			}
			_vala_code_node_unref0 (data_type);
		}
	}
}


static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, gboolean constructor, ValaDataType* instance_type, gboolean user_data) {
	gint last_index;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) params);
	if (_tmp3_ != 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = instance_type != NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_ARRAY_TYPE (return_type)) {
			_tmp4_ = return_array_length;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp1_ = _tmp4_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_DELEGATE_TYPE (return_type);
	}
	if (_tmp0_) {
		gint index;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<parameters>\n");
		self->priv->indent++;
		index = 1;
		if (instance_type != NULL) {
			vala_gir_writer_write_param_or_return (self, instance_type, "parameter", &index, FALSE, "self", VALA_PARAMETER_DIRECTION_IN, FALSE);
		}
		{
			ValaList* _tmp5_;
			ValaList* _param_list;
			gint _tmp6_;
			gint _param_size;
			gint _param_index;
			_tmp5_ = _vala_iterable_ref0 (params);
			_param_list = _tmp5_;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _param_list);
			_param_size = _tmp6_;
			_param_index = -1;
			while (TRUE) {
				gpointer _tmp7_ = NULL;
				ValaParameter* param;
				ValaDataType* _tmp8_ = NULL;
				gboolean _tmp9_;
				const gchar* _tmp10_ = NULL;
				ValaParameterDirection _tmp11_;
				ValaDataType* _tmp12_ = NULL;
				gboolean _tmp13_;
				const gchar* _tmp14_ = NULL;
				ValaParameterDirection _tmp15_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp7_ = vala_list_get (_param_list, _param_index);
				param = (ValaParameter*) _tmp7_;
				_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp9_ = vala_parameter_get_no_array_length (param);
				_tmp10_ = vala_symbol_get_name ((ValaSymbol*) param);
				_tmp11_ = vala_parameter_get_direction (param);
				vala_gir_writer_write_param_or_return (self, _tmp8_, "parameter", &index, !_tmp9_, _tmp10_, _tmp11_, FALSE);
				_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp13_ = vala_parameter_get_no_array_length (param);
				_tmp14_ = vala_symbol_get_name ((ValaSymbol*) param);
				_tmp15_ = vala_parameter_get_direction (param);
				vala_gir_writer_write_implicit_params (self, _tmp12_, &index, !_tmp13_, _tmp14_, _tmp15_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		last_index = index - 1;
		vala_gir_writer_write_implicit_params (self, return_type, &index, return_array_length, "result", VALA_PARAMETER_DIRECTION_OUT);
		if (user_data) {
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", index);
			self->priv->indent++;
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			self->priv->indent--;
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "</parameter>\n");
		}
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</parameters>\n");
	}
	if (return_type != NULL) {
		vala_gir_writer_write_param_or_return (self, return_type, "return-value", &last_index, return_array_length, NULL, VALA_PARAMETER_DIRECTION_IN, constructor);
	}
}


static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	ValaList* _tmp6_ = NULL;
	ValaList* _tmp7_;
	ValaDataType* _tmp8_ = NULL;
	gboolean _tmp9_;
	gboolean _tmp10_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cb);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) cb);
	if (!_tmp1_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) cb);
	g_string_append_printf (self->priv->buffer, "<callback name=\"%s\"", _tmp2_);
	_tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cb, FALSE);
	_tmp4_ = _tmp3_;
	g_string_append_printf (self->priv->buffer, " c:type=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) cb);
	if (_tmp5_) {
		g_string_append_printf (self->priv->buffer, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cb);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) cb);
	_tmp6_ = vala_delegate_get_parameters (cb);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_delegate_get_return_type (cb);
	_tmp9_ = vala_delegate_get_no_array_length (cb);
	_tmp10_ = vala_delegate_get_has_target (cb);
	vala_gir_writer_write_params_and_return (self, _tmp7_, _tmp8_, !_tmp9_, FALSE, NULL, _tmp10_);
	_vala_iterable_unref0 (_tmp7_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</callback>\n");
}


static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gchar* _tmp10_;
	gchar* tag_name;
	gpointer _tmp11_ = NULL;
	ValaSymbol* parent;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	if (_tmp0_) {
		return;
	}
	_tmp3_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) m);
	if (!_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = vala_method_get_overrides (m);
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaMethod* _tmp7_ = NULL;
		_tmp7_ = vala_method_get_base_interface_method (m);
		if (_tmp7_ != NULL) {
			gboolean _tmp8_;
			_tmp8_ = vala_method_get_is_abstract (m);
			_tmp6_ = !_tmp8_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gboolean _tmp9_;
			_tmp9_ = vala_method_get_is_virtual (m);
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		return;
	}
	_tmp10_ = g_strdup ("method");
	tag_name = _tmp10_;
	_tmp11_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	parent = (ValaSymbol*) _tmp11_;
	if (VALA_IS_ENUM (parent)) {
		vala_collection_add ((ValaCollection*) self->priv->deferred, (ValaCodeNode*) m);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	if (VALA_IS_NAMESPACE (parent)) {
		_tmp13_ = TRUE;
	} else {
		ValaMemberBinding _tmp14_;
		_tmp14_ = vala_method_get_binding (m);
		_tmp13_ = _tmp14_ == VALA_MEMBER_BINDING_STATIC;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		ValaSymbol* _tmp15_ = NULL;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp12_ = parent != _tmp15_;
	}
	if (_tmp12_) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = g_strdup ("function");
		_tmp17_ = _tmp16_;
		_g_free0 (tag_name);
		tag_name = _tmp17_;
	}
	vala_gir_writer_write_signature (self, m, tag_name, FALSE);
	_tmp19_ = vala_method_get_is_abstract (m);
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp20_;
		_tmp20_ = vala_method_get_is_virtual (m);
		_tmp18_ = _tmp20_;
	}
	if (_tmp18_) {
		vala_gir_writer_write_signature (self, m, "virtual-method", FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance) {
	gpointer _tmp0_ = NULL;
	ValaSymbol* parent;
	gchar* name;
	ValaSymbol* _tmp1_ = NULL;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = vala_list_get ((ValaList*) self->priv->hierarchy, 0);
	parent = (ValaSymbol*) _tmp0_;
	name = NULL;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	if (_tmp1_ != parent) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* parent_prefix;
		gboolean _tmp5_;
		instance = FALSE;
		_tmp2_ = vala_method_get_cname (m);
		_tmp3_ = _tmp2_;
		_g_free0 (name);
		name = _tmp3_;
		_tmp4_ = vala_symbol_get_lower_case_cprefix (parent);
		parent_prefix = _tmp4_;
		_tmp5_ = g_str_has_prefix (name, parent_prefix);
		if (_tmp5_) {
			gint _tmp6_;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp6_ = strlen (parent_prefix);
			_tmp7_ = string_offset (name, (glong) _tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (name);
			name = _tmp9_;
		}
		_g_free0 (parent_prefix);
	} else {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (name);
		name = _tmp12_;
	}
	_tmp13_ = vala_method_get_coroutine (m);
	if (_tmp13_) {
		gchar* _tmp14_;
		gchar* finish_name;
		gboolean _tmp15_;
		gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		ValaList* _tmp23_ = NULL;
		ValaList* _tmp24_;
		ValaVoidType* _tmp25_ = NULL;
		ValaVoidType* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		ValaList* _tmp29_ = NULL;
		ValaList* _tmp30_;
		ValaDataType* _tmp31_ = NULL;
		gboolean _tmp32_;
		_tmp14_ = g_strdup (name);
		finish_name = _tmp14_;
		_tmp15_ = g_str_has_suffix (finish_name, "_async");
		if (_tmp15_) {
			gint _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp16_ = strlen (finish_name);
			_tmp17_ = strlen ("_async");
			_tmp18_ = string_substring (finish_name, (glong) 0, (glong) (_tmp16_ - _tmp17_));
			_tmp19_ = _tmp18_;
			_g_free0 (finish_name);
			finish_name = _tmp19_;
		}
		_tmp20_ = g_strconcat (finish_name, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp20_;
		_tmp21_ = vala_method_get_cname (m);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_async_begin_parameters (m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_void_type_new (NULL);
		_tmp26_ = _tmp25_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, name, _tmp22_, _tmp24_, (ValaDataType*) _tmp26_, FALSE);
		_vala_code_node_unref0 (_tmp26_);
		_vala_iterable_unref0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp27_ = vala_method_get_finish_cname (m);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_method_get_async_end_parameters (m);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_method_get_return_type (m);
		_tmp32_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, finish_name, _tmp28_, _tmp30_, _tmp31_, _tmp32_);
		_vala_iterable_unref0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (finish_name);
	} else {
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		ValaList* _tmp35_ = NULL;
		ValaList* _tmp36_;
		ValaDataType* _tmp37_ = NULL;
		gboolean _tmp38_;
		_tmp33_ = vala_method_get_cname (m);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_method_get_parameters (m);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_method_get_return_type (m);
		_tmp38_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, name, _tmp34_, _tmp36_, _tmp37_, _tmp38_);
		_vala_iterable_unref0 (_tmp36_);
		_g_free0 (_tmp34_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}


static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail) {
	ValaDataType* instance_type;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<%s name=\"%s\"", tag_name, name);
	if (g_strcmp0 (tag_name, "virtual-method") == 0) {
		g_string_append_printf (self->priv->buffer, " invoker=\"%s\"", name);
	} else {
		if (g_strcmp0 (tag_name, "callback") == 0) {
			g_string_append_printf (self->priv->buffer, " c:type=\"%s\"", name);
		} else {
			g_string_append_printf (self->priv->buffer, " c:identifier=\"%s\"", cname);
		}
	}
	if (can_fail) {
		g_string_append_printf (self->priv->buffer, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) m);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) m);
	instance_type = NULL;
	if (instance) {
		ValaSymbol* _tmp0_ = NULL;
		ValaDataType* _tmp1_ = NULL;
		ValaDataType* _tmp2_;
		_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp1_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (_tmp0_));
		_tmp2_ = _tmp1_;
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp2_;
	}
	_tmp3_ = vala_method_get_no_array_length (m);
	vala_gir_writer_write_params_and_return (self, params, return_type, !_tmp3_, FALSE, instance_type, FALSE);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</%s>\n", tag_name);
	_vala_code_node_unref0 (instance_type);
}


static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaSymbol* _tmp4_ = NULL;
	gboolean _tmp16_;
	ValaSymbol* _tmp17_ = NULL;
	ValaDataType* _tmp18_ = NULL;
	ValaDataType* datatype;
	ValaList* _tmp19_ = NULL;
	ValaList* _tmp20_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) m);
	if (!_tmp1_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	if (VALA_IS_CLASS (_tmp4_)) {
		ValaSymbol* _tmp5_ = NULL;
		ValaMethod* _tmp6_ = NULL;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp6_ = vala_class_get_default_construction_method (VALA_CLASS (_tmp5_));
		_tmp3_ = VALA_METHOD (m) == _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		ValaSymbol* _tmp8_ = NULL;
		_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		if (VALA_IS_STRUCT (_tmp8_)) {
			ValaSymbol* _tmp9_ = NULL;
			ValaMethod* _tmp10_ = NULL;
			_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp10_ = vala_struct_get_default_construction_method (VALA_STRUCT (_tmp9_));
			_tmp7_ = VALA_METHOD (m) == _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp2_ = _tmp7_;
	}
	if (_tmp2_) {
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp11_ = vala_method_get_cname ((ValaMethod*) m);
		_tmp12_ = _tmp11_;
		g_string_append_printf (self->priv->buffer, "<constructor name=\"new\" c:identifier=\"%s\"", _tmp12_);
		_g_free0 (_tmp12_);
	} else {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp13_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp14_ = vala_method_get_cname ((ValaMethod*) m);
		_tmp15_ = _tmp14_;
		g_string_append_printf (self->priv->buffer, "<constructor name=\"%s\" c:identifier=\"%s\"", _tmp13_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
	if (_tmp16_) {
		g_string_append_printf (self->priv->buffer, " throws=\"1\"");
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) m);
	_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp18_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (_tmp17_));
	datatype = _tmp18_;
	_tmp19_ = vala_method_get_parameters ((ValaMethod*) m);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_params_and_return (self, _tmp20_, datatype, FALSE, TRUE, NULL, FALSE);
	_vala_iterable_unref0 (_tmp20_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</constructor>\n");
	_vala_code_node_unref0 (datatype);
}


static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaPropertyAccessor* _tmp11_ = NULL;
	ValaPropertyAccessor* _tmp12_ = NULL;
	ValaDataType* _tmp17_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	_tmp2_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) prop);
	if (!_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = vala_property_get_overrides (prop);
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaProperty* _tmp6_ = NULL;
		_tmp6_ = vala_property_get_base_interface_property (prop);
		if (_tmp6_ != NULL) {
			gboolean _tmp7_;
			_tmp7_ = vala_property_get_is_abstract (prop);
			_tmp5_ = !_tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp8_;
			_tmp8_ = vala_property_get_is_virtual (prop);
			_tmp4_ = !_tmp8_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp9_ = vala_property_get_canonical_name (prop);
	_tmp10_ = _tmp9_;
	g_string_append_printf (self->priv->buffer, "<property name=\"%s\"", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = vala_property_get_get_accessor (prop);
	if (_tmp11_ == NULL) {
		g_string_append_printf (self->priv->buffer, " readable=\"0\"");
	}
	_tmp12_ = vala_property_get_set_accessor (prop);
	if (_tmp12_ != NULL) {
		ValaPropertyAccessor* _tmp13_ = NULL;
		gboolean _tmp14_;
		g_string_append_printf (self->priv->buffer, " writable=\"1\"");
		_tmp13_ = vala_property_get_set_accessor (prop);
		_tmp14_ = vala_property_accessor_get_construction (_tmp13_);
		if (_tmp14_) {
			ValaPropertyAccessor* _tmp15_ = NULL;
			gboolean _tmp16_;
			_tmp15_ = vala_property_get_set_accessor (prop);
			_tmp16_ = vala_property_accessor_get_writable (_tmp15_);
			if (!_tmp16_) {
				g_string_append_printf (self->priv->buffer, " construct-only=\"1\"");
			} else {
				g_string_append_printf (self->priv->buffer, " construct=\"1\"");
			}
		}
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) prop);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) prop);
	_tmp17_ = vala_property_get_property_type (prop);
	vala_gir_writer_write_type (self, _tmp17_, -1);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</property>\n");
}


static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaList* _tmp3_ = NULL;
	ValaList* _tmp4_;
	ValaDataType* _tmp5_ = NULL;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) sig);
	if (!_tmp0_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp1_ = vala_signal_get_cname (sig);
	_tmp2_ = _tmp1_;
	g_string_append_printf (self->priv->buffer, "<glib:signal name=\"%s\"", _tmp2_);
	_g_free0 (_tmp2_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) sig);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) sig);
	_tmp3_ = vala_signal_get_parameters (sig);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_signal_get_return_type (sig);
	vala_gir_writer_write_params_and_return (self, _tmp4_, _tmp5_, FALSE, FALSE, NULL, FALSE);
	_vala_iterable_unref0 (_tmp4_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</glib:signal>\n");
}


static void vala_gir_writer_write_indent (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			g_string_append_c (self->priv->buffer, '\t');
		}
	}
}


static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			fputc ('\t', self->priv->stream);
		}
	}
}


static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, const gchar* tag, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction, gboolean constructor) {
	ValaDataType* _tmp0_;
	ValaDelegateType* _tmp1_;
	ValaDelegateType* delegate_type;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (tag != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<%s", tag);
	if (name != NULL) {
		g_string_append_printf (self->priv->buffer, " name=\"%s\"", name);
	}
	if (direction == VALA_PARAMETER_DIRECTION_REF) {
		g_string_append_printf (self->priv->buffer, " direction=\"inout\"");
	} else {
		if (direction == VALA_PARAMETER_DIRECTION_OUT) {
			g_string_append_printf (self->priv->buffer, " direction=\"out\"");
		}
	}
	_tmp1_ = _vala_code_node_ref0 ((_tmp0_ = type, VALA_IS_DELEGATE_TYPE (_tmp0_) ? ((ValaDelegateType*) _tmp0_) : NULL));
	delegate_type = _tmp1_;
	_tmp4_ = vala_data_type_get_value_owned (type);
	if (_tmp4_) {
		_tmp3_ = delegate_type == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = constructor;
	}
	if (_tmp2_) {
		g_string_append_printf (self->priv->buffer, " transfer-ownership=\"full\"");
	} else {
		g_string_append_printf (self->priv->buffer, " transfer-ownership=\"none\"");
	}
	_tmp5_ = vala_data_type_get_nullable (type);
	if (_tmp5_) {
		g_string_append_printf (self->priv->buffer, " allow-none=\"1\"");
	}
	if (delegate_type != NULL) {
		ValaDelegate* _tmp7_ = NULL;
		gboolean _tmp8_;
		_tmp7_ = vala_delegate_type_get_delegate_symbol (delegate_type);
		_tmp8_ = vala_delegate_get_has_target (_tmp7_);
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean _tmp9_;
		g_string_append_printf (self->priv->buffer, " closure=\"%i\"", (*index) + 1);
		_tmp9_ = vala_data_type_get_value_owned (type);
		if (_tmp9_) {
			g_string_append_printf (self->priv->buffer, " destroy=\"%i\"", (*index) + 2);
		}
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	if (has_array_length) {
		_tmp10_ = *index;
	} else {
		_tmp10_ = -1;
	}
	vala_gir_writer_write_type (self, type, _tmp10_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</%s>\n", tag);
	(*index)++;
	_vala_code_node_unref0 (delegate_type);
}


static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = vala_typesymbol_get_cname (symbol, FALSE);
	_tmp1_ = _tmp0_;
	g_string_append_printf (self->priv->buffer, " c:type=\"%s%s\"", _tmp1_, suffix);
	_g_free0 (_tmp1_);
}


static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	vala_gir_writer_write_ctype_attributes (self, symbol, "");
	_tmp0_ = vala_typesymbol_get_cname (symbol, FALSE);
	_tmp1_ = _tmp0_;
	g_string_append_printf (self->priv->buffer, " glib:type-name=\"%s\"", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) symbol);
	_tmp3_ = _tmp2_;
	g_string_append_printf (self->priv->buffer, " glib:get-type=\"%sget_type\"", _tmp3_);
	_g_free0 (_tmp3_);
}


static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		ValaArrayType* _tmp0_;
		ValaArrayType* array_type;
		gboolean _tmp1_;
		ValaDataType* _tmp3_ = NULL;
		_tmp0_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (type));
		array_type = _tmp0_;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<array");
		_tmp1_ = vala_array_type_get_fixed_length (array_type);
		if (_tmp1_) {
			gint _tmp2_;
			_tmp2_ = vala_array_type_get_length (array_type);
			g_string_append_printf (self->priv->buffer, " fixed-size=\"%i\"", _tmp2_);
		} else {
			if (index != (-1)) {
				g_string_append_printf (self->priv->buffer, " length=\"%i\"", index + 1);
			}
		}
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		_tmp3_ = vala_array_type_get_element_type (array_type);
		vala_gir_writer_write_type (self, _tmp3_, -1);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		if (VALA_IS_VOID_TYPE (type)) {
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "<type name=\"none\"/>\n");
		} else {
			if (VALA_IS_POINTER_TYPE (type)) {
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				vala_gir_writer_write_indent (self);
				_tmp4_ = vala_data_type_get_cname (type);
				_tmp5_ = _tmp4_;
				g_string_append_printf (self->priv->buffer, "<type name=\"gpointer\" c:type=\"%s\"/>\n", _tmp5_);
				_g_free0 (_tmp5_);
			} else {
				ValaTypeSymbol* _tmp6_ = NULL;
				_tmp6_ = vala_data_type_get_data_type (type);
				if (_tmp6_ != NULL) {
					ValaTypeSymbol* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					ValaList* _tmp12_ = NULL;
					ValaList* type_arguments;
					gint _tmp13_;
					vala_gir_writer_write_indent (self);
					_tmp7_ = vala_data_type_get_data_type (type);
					_tmp8_ = vala_gir_writer_gi_type_name (self, _tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = vala_data_type_get_cname (type);
					_tmp11_ = _tmp10_;
					g_string_append_printf (self->priv->buffer, "<type name=\"%s\" c:type=\"%s\"", _tmp9_, _tmp11_);
					_g_free0 (_tmp11_);
					_g_free0 (_tmp9_);
					_tmp12_ = vala_data_type_get_type_arguments (type);
					type_arguments = _tmp12_;
					_tmp13_ = vala_collection_get_size ((ValaCollection*) type_arguments);
					if (_tmp13_ == 0) {
						g_string_append_printf (self->priv->buffer, "/>\n");
					} else {
						g_string_append_printf (self->priv->buffer, ">\n");
						self->priv->indent++;
						{
							ValaList* _tmp14_;
							ValaList* _type_argument_list;
							gint _tmp15_;
							gint _type_argument_size;
							gint _type_argument_index;
							_tmp14_ = _vala_iterable_ref0 (type_arguments);
							_type_argument_list = _tmp14_;
							_tmp15_ = vala_collection_get_size ((ValaCollection*) _type_argument_list);
							_type_argument_size = _tmp15_;
							_type_argument_index = -1;
							while (TRUE) {
								gpointer _tmp16_ = NULL;
								ValaDataType* type_argument;
								_type_argument_index = _type_argument_index + 1;
								if (!(_type_argument_index < _type_argument_size)) {
									break;
								}
								_tmp16_ = vala_list_get (_type_argument_list, _type_argument_index);
								type_argument = (ValaDataType*) _tmp16_;
								vala_gir_writer_write_type (self, type_argument, -1);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_iterable_unref0 (_type_argument_list);
						}
						self->priv->indent--;
						vala_gir_writer_write_indent (self);
						g_string_append_printf (self->priv->buffer, "</type>\n");
					}
					_vala_iterable_unref0 (type_arguments);
				} else {
					if (VALA_IS_DELEGATE_TYPE (type)) {
						ValaDelegateType* _tmp17_;
						ValaDelegateType* deleg_type;
						ValaDelegate* _tmp18_ = NULL;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						_tmp17_ = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (type));
						deleg_type = _tmp17_;
						vala_gir_writer_write_indent (self);
						_tmp18_ = vala_delegate_type_get_delegate_symbol (deleg_type);
						_tmp19_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = vala_data_type_get_cname (type);
						_tmp22_ = _tmp21_;
						g_string_append_printf (self->priv->buffer, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp20_, _tmp22_);
						_g_free0 (_tmp22_);
						_g_free0 (_tmp20_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						if (VALA_IS_GENERIC_TYPE (type)) {
							vala_gir_writer_write_indent (self);
							g_string_append (self->priv->buffer, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_;
							vala_gir_writer_write_indent (self);
							_tmp23_ = vala_code_node_to_string ((ValaCodeNode*) type);
							_tmp24_ = _tmp23_;
							g_string_append_printf (self->priv->buffer, "<type name=\"%s\"/>\n", _tmp24_);
							_g_free0 (_tmp24_);
						}
					}
				}
			}
		}
	}
}


static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	{
		GList* attr_collection;
		GList* attr_it;
		attr_collection = node->attributes;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* attr;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) attr_it->data);
			attr = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_ = NULL;
				gchar* name;
				_tmp1_ = vala_attribute_get_name (attr);
				_tmp2_ = vala_gir_writer_camel_case_to_canonical (self, _tmp1_);
				name = _tmp2_;
				{
					ValaSet* _tmp3_ = NULL;
					ValaSet* _tmp4_;
					ValaIterator* _tmp5_ = NULL;
					ValaIterator* _tmp6_;
					ValaIterator* _arg_name_it;
					_tmp3_ = vala_map_get_keys (attr->args);
					_tmp4_ = _tmp3_;
					_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
					_arg_name_it = (_tmp6_ = _tmp5_, _vala_iterable_unref0 (_tmp4_), _tmp6_);
					while (TRUE) {
						gboolean _tmp7_;
						gpointer _tmp8_ = NULL;
						gchar* arg_name;
						gpointer _tmp9_ = NULL;
						gchar* value;
						gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						_tmp7_ = vala_iterator_next (_arg_name_it);
						if (!_tmp7_) {
							break;
						}
						_tmp8_ = vala_iterator_get (_arg_name_it);
						arg_name = (gchar*) _tmp8_;
						_tmp9_ = vala_map_get (attr->args, arg_name);
						value = (gchar*) _tmp9_;
						vala_gir_writer_write_indent (self);
						_tmp10_ = vala_gir_writer_camel_case_to_canonical (self, arg_name);
						_tmp11_ = _tmp10_;
						g_string_append_printf (self->priv->buffer, "<annotation key=\"%s.%s\" value=\"%s\"/>\n", name, _tmp11_, value);
						_g_free0 (_tmp11_);
						_g_free0 (value);
						_g_free0 (arg_name);
					}
					_vala_iterator_unref0 (_arg_name_it);
				}
				_g_free0 (name);
				_vala_code_node_unref0 (attr);
			}
		}
	}
}


static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	ValaSymbol* parent;
	gchar* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) type_symbol);
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	parent = _tmp1_;
	if (VALA_IS_NAMESPACE (parent)) {
		ValaSymbol* _tmp2_;
		ValaNamespace* _tmp3_;
		ValaNamespace* ns;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = _vala_code_node_ref0 ((_tmp2_ = parent, VALA_IS_NAMESPACE (_tmp2_) ? ((ValaNamespace*) _tmp2_) : NULL));
		ns = _tmp3_;
		_tmp4_ = vala_symbol_get_gir_name ((ValaSymbol*) ns);
		if (_tmp4_ != NULL) {
			ValaSourceReference* _tmp5_ = NULL;
			ValaSourceFile* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
			_tmp6_ = vala_source_reference_get_file (_tmp5_);
			_tmp7_ = vala_source_file_get_gir_namespace (_tmp6_);
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_ = NULL;
				ValaSourceFile* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				ValaSourceReference* _tmp11_ = NULL;
				ValaSourceFile* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				ValaGIRWriterGIRNamespace external = {0};
				gboolean _tmp14_;
				ValaSourceReference* _tmp15_ = NULL;
				ValaSourceFile* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
				_tmp9_ = vala_source_reference_get_file (_tmp8_);
				_tmp10_ = vala_source_file_get_gir_namespace (_tmp9_);
				_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
				_tmp12_ = vala_source_reference_get_file (_tmp11_);
				_tmp13_ = vala_source_file_get_gir_version (_tmp12_);
				vala_gir_writer_gir_namespace_init (&external, _tmp10_, _tmp13_);
				_tmp14_ = vala_collection_contains ((ValaCollection*) self->priv->externals, &external);
				if (!_tmp14_) {
					vala_collection_add ((ValaCollection*) self->priv->externals, &external);
				}
				_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
				_tmp16_ = vala_source_reference_get_file (_tmp15_);
				_tmp17_ = vala_source_file_get_gir_namespace (_tmp16_);
				_tmp18_ = vala_symbol_get_gir_name ((ValaSymbol*) type_symbol);
				_tmp19_ = g_strdup_printf ("%s.%s", _tmp17_, _tmp18_);
				result = _tmp19_;
				vala_gir_writer_gir_namespace_destroy (&external);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				vala_collection_add ((ValaCollection*) self->priv->unannotated_namespaces, ns);
			}
		}
		_vala_code_node_unref0 (ns);
	}
	_tmp20_ = vala_symbol_get_full_gir_name ((ValaSymbol*) type_symbol);
	result = _tmp20_;
	_vala_code_node_unref0 (parent);
	return result;
}


static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	if (VALA_IS_STRING_LITERAL (literal)) {
		ValaExpression* _tmp0_;
		ValaStringLiteral* _tmp1_;
		ValaStringLiteral* lit;
		_tmp1_ = _vala_code_node_ref0 ((_tmp0_ = literal, VALA_IS_STRING_LITERAL (_tmp0_) ? ((ValaStringLiteral*) _tmp0_) : NULL));
		lit = _tmp1_;
		if (lit != NULL) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp2_ = vala_string_literal_eval (lit);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) (-1));
			result = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		if (VALA_IS_CHARACTER_LITERAL (literal)) {
			gunichar _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp6_ = vala_character_literal_get_char (VALA_CHARACTER_LITERAL (literal));
			_tmp7_ = g_strdup_printf ("%c", (gint) ((gchar) _tmp6_));
			result = _tmp7_;
			return result;
		} else {
			if (VALA_IS_BOOLEAN_LITERAL (literal)) {
				const gchar* _tmp8_;
				gboolean _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = NULL;
				_tmp9_ = vala_boolean_literal_get_value (VALA_BOOLEAN_LITERAL (literal));
				if (_tmp9_) {
					_tmp8_ = "true";
				} else {
					_tmp8_ = "false";
				}
				_tmp10_ = g_strdup (_tmp8_);
				result = _tmp10_;
				return result;
			} else {
				if (VALA_IS_REAL_LITERAL (literal)) {
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					_tmp11_ = vala_real_literal_get_value (VALA_REAL_LITERAL (literal));
					_tmp12_ = g_strdup (_tmp11_);
					result = _tmp12_;
					return result;
				} else {
					if (VALA_IS_INTEGER_LITERAL (literal)) {
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_;
						_tmp13_ = vala_integer_literal_get_value (VALA_INTEGER_LITERAL (literal));
						_tmp14_ = g_strdup (_tmp13_);
						result = _tmp14_;
						return result;
					} else {
						if (VALA_IS_UNARY_EXPRESSION (literal)) {
							ValaUnaryExpression* _tmp15_;
							ValaUnaryExpression* unary;
							ValaUnaryOperator _tmp16_;
							_tmp15_ = _vala_code_node_ref0 (VALA_UNARY_EXPRESSION (literal));
							unary = _tmp15_;
							_tmp16_ = vala_unary_expression_get_operator (unary);
							if (_tmp16_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaExpression* _tmp17_ = NULL;
								_tmp17_ = vala_unary_expression_get_inner (unary);
								if (VALA_IS_REAL_LITERAL (_tmp17_)) {
									ValaExpression* _tmp18_ = NULL;
									const gchar* _tmp19_ = NULL;
									_tmp18_ = vala_unary_expression_get_inner (unary);
									_tmp19_ = vala_real_literal_get_value (VALA_REAL_LITERAL (_tmp18_));
									result = g_strconcat ("-", _tmp19_, NULL);
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaExpression* _tmp20_ = NULL;
									_tmp20_ = vala_unary_expression_get_inner (unary);
									if (VALA_IS_INTEGER_LITERAL (_tmp20_)) {
										ValaExpression* _tmp21_ = NULL;
										const gchar* _tmp22_ = NULL;
										_tmp21_ = vala_unary_expression_get_inner (unary);
										_tmp22_ = vala_integer_literal_get_value (VALA_INTEGER_LITERAL (_tmp21_));
										result = g_strconcat ("-", _tmp22_, NULL);
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp5_;
	gchar** parts;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_symbol_camel_case_to_lower_case (name);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "_", 0);
	_tmp5_ = (_tmp4_ = _tmp3_, _g_free0 (_tmp1_), _tmp4_);
	parts_length1 = _vala_array_length (_tmp2_);
	_parts_size_ = parts_length1;
	parts = _tmp5_;
	_tmp6_ = g_strjoinv ("-", parts);
	result = _tmp6_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_symbol_get_access (sym);
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbolAccessibility _tmp2_;
		_tmp2_ = vala_symbol_get_access (sym);
		_tmp0_ = _tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


ValaGIRWriter* vala_gir_writer_construct (GType object_type) {
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIRWriter* vala_gir_writer_new (void) {
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}


static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = g_strdup (ns);
	_tmp1_ = _tmp0_;
	_g_free0 ((*self).ns);
	(*self).ns = _tmp1_;
	_tmp2_ = g_strdup (version);
	_tmp3_ = _tmp2_;
	_g_free0 ((*self).version);
	(*self).version = _tmp3_;
}


static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (g_strcmp0 ((*self).ns, (*g).ns) == 0) {
		_tmp0_ = g_strcmp0 ((*self).version, (*g).version) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest) {
	dest->ns = g_strdup (self->ns);
	dest->version = g_strdup (self->version);
}


static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self) {
	_g_free0 (self->ns);
	_g_free0 (self->version);
}


static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self) {
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}


static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self) {
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}


static GType vala_gir_writer_gir_namespace_get_type (void) {
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}


static void vala_gir_writer_class_init (ValaGIRWriterClass * klass) {
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gir_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIRWriterPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gir_writer_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gir_writer_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gir_writer_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gir_writer_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gir_writer_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_gir_writer_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gir_writer_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_gir_writer_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_gir_writer_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_gir_writer_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gir_writer_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_gir_writer_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_gir_writer_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_gir_writer_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_gir_writer_real_visit_signal;
}


static void vala_gir_writer_instance_init (ValaGIRWriter * self) {
	GString* _tmp0_ = NULL;
	ValaHashSet* _tmp1_ = NULL;
	ValaHashSet* _tmp2_ = NULL;
	ValaArrayList* _tmp3_ = NULL;
	ValaArrayList* _tmp4_ = NULL;
	ValaArrayList* _tmp5_ = NULL;
	self->priv = VALA_GIR_WRITER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	self->priv->unannotated_namespaces = _tmp1_;
	_tmp2_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	self->priv->our_namespaces = _tmp2_;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->hierarchy = _tmp3_;
	_tmp4_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->deferred = _tmp4_;
	_tmp5_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp5_;
}


static void vala_gir_writer_finalize (ValaCodeVisitor* obj) {
	ValaGIRWriter * self;
	self = VALA_GIR_WRITER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}


/**
 * Code visitor generating .gir file for the public interface.
 */
GType vala_gir_writer_get_type (void) {
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



