/* valaccodeconstant.c generated by valac, the Vala compiler
 * generated from valaccodeconstant.vala, do not modify */

/* valaccodeconstant.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_EXPRESSION (vala_ccode_expression_get_type ())
#define VALA_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression))
#define VALA_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))
#define VALA_IS_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_IS_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_CCODE_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))

typedef struct _ValaCCodeExpression ValaCCodeExpression;
typedef struct _ValaCCodeExpressionClass ValaCCodeExpressionClass;
typedef struct _ValaCCodeExpressionPrivate ValaCCodeExpressionPrivate;

#define VALA_TYPE_CCODE_CONSTANT (vala_ccode_constant_get_type ())
#define VALA_CCODE_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant))
#define VALA_CCODE_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstantClass))
#define VALA_IS_CCODE_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONSTANT))
#define VALA_IS_CCODE_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONSTANT))
#define VALA_CCODE_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstantClass))

typedef struct _ValaCCodeConstant ValaCCodeConstant;
typedef struct _ValaCCodeConstantClass ValaCCodeConstantClass;
typedef struct _ValaCCodeConstantPrivate ValaCCodeConstantPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeExpression {
	ValaCCodeNode parent_instance;
	ValaCCodeExpressionPrivate * priv;
};

struct _ValaCCodeExpressionClass {
	ValaCCodeNodeClass parent_class;
	void (*write_inner) (ValaCCodeExpression* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeConstant {
	ValaCCodeExpression parent_instance;
	ValaCCodeConstantPrivate * priv;
};

struct _ValaCCodeConstantClass {
	ValaCCodeExpressionClass parent_class;
};

struct _ValaCCodeConstantPrivate {
	gchar* _name;
};


static gpointer vala_ccode_constant_parent_class = NULL;

gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
void vala_value_take_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
void vala_value_take_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void) G_GNUC_CONST;
GType vala_ccode_expression_get_type (void) G_GNUC_CONST;
GType vala_ccode_constant_get_type (void) G_GNUC_CONST;
#define VALA_CCODE_CONSTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstantPrivate))
enum  {
	VALA_CCODE_CONSTANT_DUMMY_PROPERTY
};
#define VALA_CCODE_CONSTANT_LINE_LENGTH 70
ValaCCodeConstant* vala_ccode_constant_new (const gchar* _name);
ValaCCodeConstant* vala_ccode_constant_construct (GType object_type, const gchar* _name);
ValaCCodeExpression* vala_ccode_expression_construct (GType object_type);
void vala_ccode_constant_set_name (ValaCCodeConstant* self, const gchar* value);
ValaCCodeConstant* vala_ccode_constant_new_string (const gchar* _name);
ValaCCodeConstant* vala_ccode_constant_construct_string (GType object_type, const gchar* _name);
static void vala_ccode_constant_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const gchar* s);
const gchar* vala_ccode_constant_get_name (ValaCCodeConstant* self);
static void vala_ccode_constant_finalize (ValaCCodeNode* obj);


ValaCCodeConstant* vala_ccode_constant_construct (GType object_type, const gchar* _name) {
	ValaCCodeConstant* self = NULL;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) vala_ccode_expression_construct (object_type);
	vala_ccode_constant_set_name (self, _name);
	return self;
}


ValaCCodeConstant* vala_ccode_constant_new (const gchar* _name) {
	return vala_ccode_constant_construct (VALA_TYPE_CCODE_CONSTANT, _name);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


ValaCCodeConstant* vala_ccode_constant_construct_string (GType object_type, const gchar* _name) {
	ValaCCodeConstant* self = NULL;
	gchar _tmp0_;
	gint _tmp1_;
	GString* _tmp2_ = NULL;
	GString* builder;
	gchar* p;
	gint _tmp3_;
	gchar* end;
	gint col;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) vala_ccode_expression_construct (object_type);
	_tmp0_ = string_get (_name, (glong) 0);
	g_assert (_tmp0_ == '\"');
	_tmp1_ = strlen (_name);
	if (_tmp1_ <= VALA_CCODE_CONSTANT_LINE_LENGTH) {
		vala_ccode_constant_set_name (self, _name);
		return self;
	}
	_tmp2_ = g_string_new ("\"");
	builder = _tmp2_;
	p = _name;
	_tmp3_ = strlen (_name);
	end = p + _tmp3_;
	p++;
	end--;
	col = 0;
	while (TRUE) {
		if (!(p < end)) {
			break;
		}
		if (col >= VALA_CCODE_CONSTANT_LINE_LENGTH) {
			g_string_append (builder, "\" \\\n\"");
			col = 0;
		}
		if ((*p) == '\\') {
			gchar* begin_of_char;
			begin_of_char = p;
			g_string_append_c (builder, p[0]);
			g_string_append_c (builder, p[1]);
			p = p + 2;
			switch (p[-1]) {
				case 'x':
				{
					while (TRUE) {
						gboolean _tmp4_ = FALSE;
						if (p < end) {
							gboolean _tmp5_;
							_tmp5_ = g_ascii_isxdigit (*p);
							_tmp4_ = _tmp5_;
						} else {
							_tmp4_ = FALSE;
						}
						if (!_tmp4_) {
							break;
						}
						g_string_append_c (builder, *p);
						p++;
					}
					break;
				}
				case 'n':
				{
					col = VALA_CCODE_CONSTANT_LINE_LENGTH;
					break;
				}
			}
			col = col + ((gint) (p - begin_of_char));
		} else {
			gunichar _tmp6_;
			const gchar* _tmp7_ = NULL;
			_tmp6_ = string_get_char ((const gchar*) p, 0);
			g_string_append_unichar (builder, _tmp6_);
			_tmp7_ = g_utf8_next_char ((const gchar*) p);
			p = p + (((gchar*) _tmp7_) - p);
			col++;
		}
	}
	g_string_append_c (builder, '"');
	vala_ccode_constant_set_name (self, builder->str);
	_g_string_free0 (builder);
	return self;
}


ValaCCodeConstant* vala_ccode_constant_new_string (const gchar* _name) {
	return vala_ccode_constant_construct_string (VALA_TYPE_CCODE_CONSTANT, _name);
}


static void vala_ccode_constant_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeConstant * self;
	self = (ValaCCodeConstant*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
}


const gchar* vala_ccode_constant_get_name (ValaCCodeConstant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void vala_ccode_constant_set_name (ValaCCodeConstant* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


static void vala_ccode_constant_class_init (ValaCCodeConstantClass * klass) {
	vala_ccode_constant_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_constant_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeConstantPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_constant_real_write;
}


static void vala_ccode_constant_instance_init (ValaCCodeConstant * self) {
	self->priv = VALA_CCODE_CONSTANT_GET_PRIVATE (self);
}


static void vala_ccode_constant_finalize (ValaCCodeNode* obj) {
	ValaCCodeConstant * self;
	self = VALA_CCODE_CONSTANT (obj);
	_g_free0 (self->priv->_name);
	VALA_CCODE_NODE_CLASS (vala_ccode_constant_parent_class)->finalize (obj);
}


/**
 * A constant C expression.
 */
GType vala_ccode_constant_get_type (void) {
	static volatile gsize vala_ccode_constant_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_constant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeConstant), 0, (GInstanceInitFunc) vala_ccode_constant_instance_init, NULL };
		GType vala_ccode_constant_type_id;
		vala_ccode_constant_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeConstant", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_constant_type_id__volatile, vala_ccode_constant_type_id);
	}
	return vala_ccode_constant_type_id__volatile;
}



