/* valaparameter.c generated by valac, the Vala compiler
 * generated from valaparameter.vala, do not modify */

/* valaparameter.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaVariablePrivate ValaVariablePrivate;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;
typedef struct _ValaParameterPrivate ValaParameterPrivate;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaVariable {
	ValaSymbol parent_instance;
	ValaVariablePrivate * priv;
};

struct _ValaVariableClass {
	ValaSymbolClass parent_class;
};

struct _ValaParameter {
	ValaVariable parent_instance;
	ValaParameterPrivate * priv;
};

struct _ValaParameterClass {
	ValaVariableClass parent_class;
};

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;

struct _ValaParameterPrivate {
	ValaParameterDirection _direction;
	gboolean _ellipsis;
	gboolean _params_array;
	gboolean _no_array_length;
	gboolean _array_null_terminated;
	gchar* _array_length_type;
	gdouble _cparameter_position;
	gdouble _carray_length_parameter_position;
	gdouble _cdelegate_target_parameter_position;
	gdouble _cdestroy_notify_parameter_position;
	gchar* _ctype;
	gboolean _captured;
	gchar* array_length_cname;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_parameter_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
GType vala_parameter_direction_get_type (void) G_GNUC_CONST;
#define VALA_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARAMETER, ValaParameterPrivate))
enum  {
	VALA_PARAMETER_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaVariable* vala_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaParameter* vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference);
void vala_parameter_set_ellipsis (ValaParameter* self, gboolean value);
static void vala_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_formal_parameter (ValaCodeVisitor* self, ValaParameter* p);
static void vala_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
gboolean vala_parameter_get_ellipsis (ValaParameter* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
static void vala_parameter_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
static void vala_parameter_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_variable_set_initializer (ValaVariable* self, ValaExpression* value);
gchar* vala_parameter_get_array_length_cname (ValaParameter* self);
void vala_parameter_set_array_length_cname (ValaParameter* self, const gchar* array_length_cname);
static void vala_parameter_process_ccode_attribute (ValaParameter* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
void vala_parameter_set_ctype (ValaParameter* self, const gchar* value);
gdouble vala_attribute_get_double (ValaAttribute* self, const gchar* name);
void vala_parameter_set_cparameter_position (ValaParameter* self, gdouble value);
gboolean vala_attribute_get_bool (ValaAttribute* self, const gchar* name);
void vala_parameter_set_no_array_length (ValaParameter* self, gboolean value);
void vala_parameter_set_array_length_type (ValaParameter* self, const gchar* value);
void vala_parameter_set_array_null_terminated (ValaParameter* self, gboolean value);
void vala_parameter_set_carray_length_parameter_position (ValaParameter* self, gdouble value);
void vala_parameter_set_cdelegate_target_parameter_position (ValaParameter* self, gdouble value);
void vala_parameter_set_cdestroy_notify_parameter_position (ValaParameter* self, gdouble value);
void vala_parameter_process_attributes (ValaParameter* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
ValaParameter* vala_parameter_copy (ValaParameter* self);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gboolean vala_parameter_get_params_array (ValaParameter* self);
void vala_parameter_set_params_array (ValaParameter* self, gboolean value);
ValaParameterDirection vala_parameter_get_direction (ValaParameter* self);
void vala_parameter_set_direction (ValaParameter* self, ValaParameterDirection value);
static gboolean vala_parameter_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
GType vala_literal_get_type (void) G_GNUC_CONST;
GType vala_null_literal_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
gboolean vala_parameter_get_no_array_length (ValaParameter* self);
gboolean vala_parameter_get_array_null_terminated (ValaParameter* self);
gboolean vala_parameter_get_has_array_length_cname (ValaParameter* self);
const gchar* vala_parameter_get_array_length_type (ValaParameter* self);
gdouble vala_parameter_get_cparameter_position (ValaParameter* self);
gdouble vala_parameter_get_carray_length_parameter_position (ValaParameter* self);
gdouble vala_parameter_get_cdelegate_target_parameter_position (ValaParameter* self);
gdouble vala_parameter_get_cdestroy_notify_parameter_position (ValaParameter* self);
const gchar* vala_parameter_get_ctype (ValaParameter* self);
gboolean vala_parameter_get_captured (ValaParameter* self);
void vala_parameter_set_captured (ValaParameter* self, gboolean value);
static void vala_parameter_finalize (ValaCodeNode* obj);


/**
 * Creates a new formal parameter.
 *
 * @param name   parameter name
 * @param type   parameter type
 * @param source reference to source code
 * @return       newly created formal parameter
 */
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference) {
	ValaParameter* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaParameter*) vala_variable_construct (object_type, variable_type, name, NULL, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference) {
	return vala_parameter_construct (VALA_TYPE_PARAMETER, name, variable_type, source_reference);
}


/**
 * Creates a new ellipsis parameter representing an indefinite number of
 * parameters.
 */
ValaParameter* vala_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference) {
	ValaParameter* self = NULL;
	self = (ValaParameter*) vala_variable_construct (object_type, NULL, NULL, NULL, source_reference, NULL);
	vala_parameter_set_ellipsis (self, TRUE);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter* vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference) {
	return vala_parameter_construct_with_ellipsis (VALA_TYPE_PARAMETER, source_reference);
}


static void vala_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParameter * self;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_formal_parameter (visitor, self);
}


static void vala_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParameter * self;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	if (!self->priv->_ellipsis) {
		ValaDataType* _tmp0_ = NULL;
		ValaExpression* _tmp1_ = NULL;
		_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
		vala_code_node_accept ((ValaCodeNode*) _tmp0_, visitor);
		_tmp1_ = vala_variable_get_initializer ((ValaVariable*) self);
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_ = NULL;
			_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
			vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
		}
	}
}


static void vala_parameter_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaParameter * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaParameter*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	if (_tmp0_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static void vala_parameter_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaParameter * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaParameter*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	if (_tmp0_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


/**
 * Returns the name of the array length parameter as it is used in C code
 *
 * @return the name of the array length parameter to be used in C code
 */
gchar* vala_parameter_get_array_length_cname (ValaParameter* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->array_length_cname);
	result = _tmp0_;
	return result;
}


/**
 * Sets the name of the array length parameter as it is used in C code
 *
 * @param array_length_cname the name of the array length parameter to be
 * used in C code
 */
void vala_parameter_set_array_length_cname (ValaParameter* self, const gchar* array_length_cname) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (array_length_cname);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->array_length_cname);
	self->priv->array_length_cname = _tmp1_;
}


static void vala_parameter_process_ccode_attribute (ValaParameter* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	gboolean _tmp14_;
	gboolean _tmp17_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "type");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_attribute_get_string (a, "type");
		_tmp2_ = _tmp1_;
		vala_parameter_set_ctype (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = vala_attribute_has_argument (a, "pos");
	if (_tmp3_) {
		gdouble _tmp4_;
		_tmp4_ = vala_attribute_get_double (a, "pos");
		vala_parameter_set_cparameter_position (self, _tmp4_);
	}
	_tmp5_ = vala_attribute_has_argument (a, "array_length");
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = vala_attribute_get_bool (a, "array_length");
		vala_parameter_set_no_array_length (self, !_tmp6_);
	}
	_tmp7_ = vala_attribute_has_argument (a, "array_length_type");
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp8_ = vala_attribute_get_string (a, "array_length_type");
		_tmp9_ = _tmp8_;
		vala_parameter_set_array_length_type (self, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = vala_attribute_has_argument (a, "array_null_terminated");
	if (_tmp10_) {
		gboolean _tmp11_;
		_tmp11_ = vala_attribute_get_bool (a, "array_null_terminated");
		vala_parameter_set_array_null_terminated (self, _tmp11_);
	}
	_tmp12_ = vala_attribute_has_argument (a, "array_length_pos");
	if (_tmp12_) {
		gdouble _tmp13_;
		_tmp13_ = vala_attribute_get_double (a, "array_length_pos");
		vala_parameter_set_carray_length_parameter_position (self, _tmp13_);
	}
	_tmp14_ = vala_attribute_has_argument (a, "array_length_cname");
	if (_tmp14_) {
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp15_ = vala_attribute_get_string (a, "array_length_cname");
		_tmp16_ = _tmp15_;
		vala_parameter_set_array_length_cname (self, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = vala_attribute_has_argument (a, "delegate_target_pos");
	if (_tmp17_) {
		gdouble _tmp18_;
		_tmp18_ = vala_attribute_get_double (a, "delegate_target_pos");
		vala_parameter_set_cdelegate_target_parameter_position (self, _tmp18_);
	}
	_tmp19_ = vala_attribute_has_argument (a, "destroy_notify_pos");
	if (_tmp19_) {
		gdouble _tmp20_;
		_tmp20_ = vala_attribute_get_double (a, "destroy_notify_pos");
		vala_parameter_set_cdestroy_notify_parameter_position (self, _tmp20_);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_parameter_process_attributes (ValaParameter* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_parameter_process_ccode_attribute (self, a);
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


ValaParameter* vala_parameter_copy (ValaParameter* self) {
	ValaParameter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->_ellipsis) {
		const gchar* _tmp0_ = NULL;
		ValaDataType* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_ = NULL;
		ValaParameter* _tmp3_ = NULL;
		ValaParameter* _result_;
		ValaExpression* _tmp4_ = NULL;
		_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp1_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = vala_parameter_new (_tmp0_, _tmp1_, _tmp2_);
		_result_ = _tmp3_;
		vala_parameter_set_params_array (_result_, self->priv->_params_array);
		vala_parameter_set_direction (_result_, self->priv->_direction);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		vala_variable_set_initializer ((ValaVariable*) _result_, _tmp4_);
		result = _result_;
		return result;
	} else {
		ValaParameter* _tmp5_ = NULL;
		_tmp5_ = vala_parameter_new_with_ellipsis (NULL);
		result = _tmp5_;
		return result;
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_parameter_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaParameter * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaSemanticAnalyzer* _tmp2_ = NULL;
	ValaSourceFile* _tmp3_ = NULL;
	ValaSourceFile* _tmp4_;
	ValaSourceFile* old_source_file;
	ValaSemanticAnalyzer* _tmp5_ = NULL;
	ValaSymbol* _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* old_symbol;
	ValaSourceReference* _tmp8_ = NULL;
	ValaSemanticAnalyzer* _tmp12_ = NULL;
	ValaSymbol* _tmp13_ = NULL;
	ValaDataType* _tmp14_ = NULL;
	ValaExpression* _tmp28_ = NULL;
	ValaSemanticAnalyzer* _tmp52_ = NULL;
	ValaSemanticAnalyzer* _tmp53_ = NULL;
	gboolean _tmp54_;
	self = (ValaParameter*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_parameter_process_attributes (self);
	_tmp2_ = vala_code_context_get_analyzer (context);
	_tmp3_ = vala_semantic_analyzer_get_current_source_file (_tmp2_);
	_tmp4_ = _vala_source_file_ref0 (_tmp3_);
	old_source_file = _tmp4_;
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = vala_semantic_analyzer_get_current_symbol (_tmp5_);
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	old_symbol = _tmp7_;
	_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	if (_tmp8_ != NULL) {
		ValaSemanticAnalyzer* _tmp9_ = NULL;
		ValaSourceReference* _tmp10_ = NULL;
		ValaSourceFile* _tmp11_ = NULL;
		_tmp9_ = vala_code_context_get_analyzer (context);
		_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp11_ = vala_source_reference_get_file (_tmp10_);
		vala_semantic_analyzer_set_current_source_file (_tmp9_, _tmp11_);
	}
	_tmp12_ = vala_code_context_get_analyzer (context);
	_tmp13_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	vala_semantic_analyzer_set_current_symbol (_tmp12_, _tmp13_);
	_tmp14_ = vala_variable_get_variable_type ((ValaVariable*) self);
	if (_tmp14_ != NULL) {
		ValaDataType* _tmp15_ = NULL;
		ValaDataType* _tmp17_ = NULL;
		_tmp15_ = vala_variable_get_variable_type ((ValaVariable*) self);
		if (VALA_IS_VOID_TYPE (_tmp15_)) {
			ValaSourceReference* _tmp16_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			vala_report_error (_tmp16_, "'void' not supported as parameter type");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) self);
		vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
	}
	if (!self->priv->_ellipsis) {
		ValaDataType* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		ValaExpression* _tmp22_ = NULL;
		_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
		vala_code_node_check ((ValaCodeNode*) _tmp18_, context);
		if (self->priv->_params_array) {
			ValaDataType* _tmp20_ = NULL;
			_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp19_ = !VALA_IS_ARRAY_TYPE (_tmp20_);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaSourceReference* _tmp21_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			vala_report_error (_tmp21_, "parameter array expected");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp22_ = vala_variable_get_initializer ((ValaVariable*) self);
		if (_tmp22_ != NULL) {
			ValaExpression* _tmp23_ = NULL;
			ValaDataType* _tmp24_ = NULL;
			ValaDataType* _tmp25_ = NULL;
			ValaDataType* _tmp26_;
			ValaExpression* _tmp27_ = NULL;
			_tmp23_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp25_ = vala_data_type_copy (_tmp24_);
			_tmp26_ = _tmp25_;
			vala_expression_set_target_type (_tmp23_, _tmp26_);
			_vala_code_node_unref0 (_tmp26_);
			_tmp27_ = vala_variable_get_initializer ((ValaVariable*) self);
			vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
		}
	}
	_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
	if (_tmp28_ != NULL) {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaExpression* _tmp31_ = NULL;
		_tmp31_ = vala_variable_get_initializer ((ValaVariable*) self);
		if (VALA_IS_NULL_LITERAL (_tmp31_)) {
			ValaDataType* _tmp32_ = NULL;
			gboolean _tmp33_;
			_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp33_ = vala_data_type_get_nullable (_tmp32_);
			_tmp30_ = !_tmp33_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			_tmp29_ = self->priv->_direction != VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaSourceReference* _tmp34_ = NULL;
			ValaDataType* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup_printf ("`null' incompatible with parameter type `%s`", _tmp37_);
			_tmp39_ = _tmp38_;
			vala_report_warning (_tmp34_, _tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
		}
	}
	if (!self->priv->_ellipsis) {
		ValaSemanticAnalyzer* _tmp40_ = NULL;
		ValaDataType* _tmp41_ = NULL;
		gboolean _tmp42_;
		_tmp40_ = vala_code_context_get_analyzer (context);
		_tmp41_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp42_ = vala_semantic_analyzer_is_type_accessible (_tmp40_, (ValaSymbol*) self, _tmp41_);
		if (!_tmp42_) {
			ValaSourceReference* _tmp43_ = NULL;
			ValaDataType* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			ValaSymbol* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp48_ = vala_symbol_get_full_name (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strdup_printf ("parameter type `%s` is less accessible than method `%s`", _tmp46_, _tmp49_);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp43_, _tmp51_);
			_g_free0 (_tmp51_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp46_);
		}
	}
	_tmp52_ = vala_code_context_get_analyzer (context);
	vala_semantic_analyzer_set_current_source_file (_tmp52_, old_source_file);
	_tmp53_ = vala_code_context_get_analyzer (context);
	vala_semantic_analyzer_set_current_symbol (_tmp53_, old_symbol);
	_tmp54_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp54_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaParameterDirection vala_parameter_get_direction (ValaParameter* self) {
	ValaParameterDirection result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_direction;
	return result;
}


void vala_parameter_set_direction (ValaParameter* self, ValaParameterDirection value) {
	g_return_if_fail (self != NULL);
	self->priv->_direction = value;
}


gboolean vala_parameter_get_ellipsis (ValaParameter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ellipsis;
	return result;
}


void vala_parameter_set_ellipsis (ValaParameter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ellipsis = value;
}


gboolean vala_parameter_get_params_array (ValaParameter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_params_array;
	return result;
}


void vala_parameter_set_params_array (ValaParameter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_params_array = value;
}


gboolean vala_parameter_get_no_array_length (ValaParameter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_parameter_set_no_array_length (ValaParameter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_parameter_get_array_null_terminated (ValaParameter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_parameter_set_array_null_terminated (ValaParameter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


gboolean vala_parameter_get_has_array_length_cname (ValaParameter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->array_length_cname != NULL;
	return result;
}


const gchar* vala_parameter_get_array_length_type (ValaParameter* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_array_length_type;
	return result;
}


void vala_parameter_set_array_length_type (ValaParameter* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_array_length_type);
	self->priv->_array_length_type = _tmp1_;
}


gdouble vala_parameter_get_cparameter_position (ValaParameter* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cparameter_position;
	return result;
}


void vala_parameter_set_cparameter_position (ValaParameter* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_cparameter_position = value;
}


gdouble vala_parameter_get_carray_length_parameter_position (ValaParameter* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_carray_length_parameter_position;
	return result;
}


void vala_parameter_set_carray_length_parameter_position (ValaParameter* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_carray_length_parameter_position = value;
}


gdouble vala_parameter_get_cdelegate_target_parameter_position (ValaParameter* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cdelegate_target_parameter_position;
	return result;
}


void vala_parameter_set_cdelegate_target_parameter_position (ValaParameter* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_cdelegate_target_parameter_position = value;
}


gdouble vala_parameter_get_cdestroy_notify_parameter_position (ValaParameter* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cdestroy_notify_parameter_position;
	return result;
}


void vala_parameter_set_cdestroy_notify_parameter_position (ValaParameter* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_cdestroy_notify_parameter_position = value;
}


const gchar* vala_parameter_get_ctype (ValaParameter* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ctype;
	return result;
}


void vala_parameter_set_ctype (ValaParameter* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_ctype);
	self->priv->_ctype = _tmp1_;
}


gboolean vala_parameter_get_captured (ValaParameter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}


void vala_parameter_set_captured (ValaParameter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


static void vala_parameter_class_init (ValaParameterClass * klass) {
	vala_parameter_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_parameter_finalize;
	g_type_class_add_private (klass, sizeof (ValaParameterPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_parameter_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_parameter_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_parameter_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_parameter_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_parameter_real_check;
}


static void vala_parameter_instance_init (ValaParameter * self) {
	self->priv = VALA_PARAMETER_GET_PRIVATE (self);
	self->priv->_direction = VALA_PARAMETER_DIRECTION_IN;
	self->priv->_array_length_type = NULL;
}


static void vala_parameter_finalize (ValaCodeNode* obj) {
	ValaParameter * self;
	self = VALA_PARAMETER (obj);
	_g_free0 (self->priv->_array_length_type);
	_g_free0 (self->priv->_ctype);
	_g_free0 (self->priv->array_length_cname);
	VALA_CODE_NODE_CLASS (vala_parameter_parent_class)->finalize (obj);
}


/**
 * Represents a formal parameter in method and callback signatures.
 */
GType vala_parameter_get_type (void) {
	static volatile gsize vala_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParameter), 0, (GInstanceInitFunc) vala_parameter_instance_init, NULL };
		GType vala_parameter_type_id;
		vala_parameter_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaParameter", &g_define_type_info, 0);
		g_once_init_leave (&vala_parameter_type_id__volatile, vala_parameter_type_id);
	}
	return vala_parameter_type_id__volatile;
}


GType vala_parameter_direction_get_type (void) {
	static volatile gsize vala_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_PARAMETER_DIRECTION_IN, "VALA_PARAMETER_DIRECTION_IN", "in"}, {VALA_PARAMETER_DIRECTION_OUT, "VALA_PARAMETER_DIRECTION_OUT", "out"}, {VALA_PARAMETER_DIRECTION_REF, "VALA_PARAMETER_DIRECTION_REF", "ref"}, {0, NULL, NULL}};
		GType vala_parameter_direction_type_id;
		vala_parameter_direction_type_id = g_enum_register_static ("ValaParameterDirection", values);
		g_once_init_leave (&vala_parameter_direction_type_id__volatile, vala_parameter_direction_type_id);
	}
	return vala_parameter_direction_type_id__volatile;
}



