/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;
typedef struct _ValaArrayCreationExpressionPrivate ValaArrayCreationExpressionPrivate;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_INTEGER_TYPE (vala_integer_type_get_type ())
#define VALA_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerType))
#define VALA_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))
#define VALA_IS_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_TYPE))
#define VALA_IS_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_TYPE))
#define VALA_INTEGER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))

typedef struct _ValaIntegerType ValaIntegerType;
typedef struct _ValaIntegerTypeClass ValaIntegerTypeClass;

#define VALA_TYPE_ENUM_VALUE_TYPE (vala_enum_value_type_get_type ())
#define VALA_ENUM_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType))
#define VALA_ENUM_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueTypeClass))
#define VALA_IS_ENUM_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE_TYPE))
#define VALA_IS_ENUM_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE_TYPE))
#define VALA_ENUM_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueTypeClass))

typedef struct _ValaEnumValueType ValaEnumValueType;
typedef struct _ValaEnumValueTypeClass ValaEnumValueTypeClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
};

struct _ValaArrayCreationExpression {
	ValaExpression parent_instance;
	ValaArrayCreationExpressionPrivate * priv;
};

struct _ValaArrayCreationExpressionClass {
	ValaExpressionClass parent_class;
};

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaInitializerList* _initializer_list;
};


static gpointer vala_array_creation_expression_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_array_creation_expression_get_type (void) G_GNUC_CONST;
GType vala_initializer_list_get_type (void) G_GNUC_CONST;
#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
enum  {
	VALA_ARRAY_CREATION_EXPRESSION_DUMMY_PROPERTY
};
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaExpression* vala_expression_construct (GType object_type);
void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaDataType* value);
void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value);
void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_array_creation_expression (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
void vala_code_visitor_visit_expression (ValaCodeVisitor* self, ValaExpression* expr);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GType vala_literal_get_type (void) G_GNUC_CONST;
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self, ValaSemanticAnalyzer* analyzer, ValaInitializerList* il, gint rank, ValaList* sl);
gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self);
gint vala_initializer_list_get_size (ValaInitializerList* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaIntegerLiteral* vala_integer_literal_new (const gchar* i, ValaSourceReference* source);
ValaIntegerLiteral* vala_integer_literal_construct (GType object_type, const gchar* i, ValaSourceReference* source);
GType vala_integer_literal_get_type (void) G_GNUC_CONST;
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
ValaList* vala_initializer_list_get_initializers (ValaInitializerList* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GType vala_value_type_get_type (void) G_GNUC_CONST;
GType vala_integer_type_get_type (void) G_GNUC_CONST;
GType vala_enum_value_type_get_type (void) G_GNUC_CONST;
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
void vala_code_node_emit (ValaCodeNode* self, ValaCodeGenerator* codegen);
static void vala_array_creation_expression_finalize (ValaCodeNode* obj);


/**
 * Add a size expression.
 */
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	vala_collection_add ((ValaCollection*) self->priv->sizes, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->sizes);
	result = _tmp0_;
	return result;
}


ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}


static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_ = NULL;
	ValaInitializerList* _tmp5_ = NULL;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_ = NULL;
		_tmp1_ = vala_array_creation_expression_get_element_type (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	}
	{
		ValaList* _tmp2_;
		ValaList* _e_list;
		gint _tmp3_;
		gint _e_size;
		gint _e_index;
		_tmp2_ = _vala_iterable_ref0 (self->priv->sizes);
		_e_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp3_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			ValaExpression* e;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_e_list, _e_index);
			e = (ValaExpression*) _tmp4_;
			vala_code_node_accept ((ValaCodeNode*) e, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp5_ = vala_array_creation_expression_get_initializer_list (self);
	if (_tmp5_ != NULL) {
		ValaInitializerList* _tmp6_ = NULL;
		_tmp6_ = vala_array_creation_expression_get_initializer_list (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
	}
}


static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base) {
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}


static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_;
				gpointer _tmp2_ = NULL;
				ValaExpression* _tmp3_;
				gboolean _tmp4_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->sizes);
				if (!(i < _tmp1_)) {
					break;
				}
				_tmp2_ = vala_list_get (self->priv->sizes, i);
				_tmp3_ = (ValaExpression*) _tmp2_;
				if ((_tmp4_ = _tmp3_ == old_node, _vala_code_node_unref0 (_tmp3_), _tmp4_)) {
					vala_list_set (self->priv->sizes, i, new_node);
					return;
				}
			}
		}
	}
}


static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	if (_tmp0_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self, ValaSemanticAnalyzer* analyzer, ValaInitializerList* il, gint rank, ValaList* sl) {
	gint result = 0;
	gint _tmp0_;
	gint subsize;
	gint _tmp17_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (analyzer != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	if (_tmp0_ == (self->priv->_rank - rank)) {
		gint _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		ValaSourceReference* _tmp4_ = NULL;
		ValaIntegerLiteral* _tmp5_ = NULL;
		ValaIntegerLiteral* _tmp6_;
		ValaIntegerLiteral* init;
		_tmp1_ = vala_initializer_list_get_size (il);
		_tmp2_ = g_strdup_printf ("%i", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp5_ = vala_integer_literal_new (_tmp3_, _tmp4_);
		init = (_tmp6_ = _tmp5_, _g_free0 (_tmp3_), _tmp6_);
		vala_code_node_check ((ValaCodeNode*) init, analyzer);
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) init);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _tmp7_ = NULL;
		ValaList* _e_list;
		gint _tmp8_;
		gint _e_size;
		gint _e_index;
		_tmp7_ = vala_initializer_list_get_initializers (il);
		_e_list = _tmp7_;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			ValaExpression* e;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp9_ = vala_list_get (_e_list, _e_index);
			e = (ValaExpression*) _tmp9_;
			if (VALA_IS_INITIALIZER_LIST (e)) {
				gint _tmp11_;
				gint size;
				gboolean _tmp12_ = FALSE;
				if (rank == 1) {
					ValaSourceReference* _tmp10_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) e, TRUE);
					_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) e);
					vala_report_error (_tmp10_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp11_ = vala_array_creation_expression_create_sizes_from_initializer_list (self, analyzer, VALA_INITIALIZER_LIST (e), rank - 1, sl);
				size = _tmp11_;
				if (size == (-1)) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				if (subsize >= 0) {
					_tmp12_ = subsize != size;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					ValaSourceReference* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp14_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", subsize, size);
					_tmp15_ = _tmp14_;
					vala_report_error (_tmp13_, _tmp15_);
					_g_free0 (_tmp15_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					subsize = size;
				}
			} else {
				if (rank != 1) {
					ValaSourceReference* _tmp16_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) e, TRUE);
					_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) e);
					vala_report_error (_tmp16_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp17_ = vala_initializer_list_get_size (il);
	result = _tmp17_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaList* _tmp2_ = NULL;
	ValaList* sizes;
	ValaInitializerList* _tmp3_ = NULL;
	ValaInitializerList* _tmp4_;
	ValaInitializerList* initlist;
	ValaDataType* _tmp5_ = NULL;
	ValaArrayList* _tmp10_ = NULL;
	ValaArrayList* calc_sizes;
	gint _tmp16_;
	gboolean _tmp29_;
	gboolean _tmp30_ = FALSE;
	ValaInitializerList* _tmp31_ = NULL;
	ValaDataType* _tmp34_ = NULL;
	ValaDataType* _tmp36_ = NULL;
	ValaDataType* _tmp37_ = NULL;
	ValaSourceReference* _tmp38_ = NULL;
	ValaArrayType* _tmp39_ = NULL;
	ValaArrayType* _tmp40_;
	ValaDataType* _tmp41_ = NULL;
	gboolean _tmp42_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp2_ = vala_array_creation_expression_get_sizes (self);
	sizes = _tmp2_;
	_tmp3_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	initlist = _tmp4_;
	_tmp5_ = vala_array_creation_expression_get_element_type (self);
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_ = NULL;
		_tmp6_ = vala_array_creation_expression_get_element_type (self);
		vala_code_node_check ((ValaCodeNode*) _tmp6_, analyzer);
	}
	{
		ValaList* _tmp7_;
		ValaList* _e_list;
		gint _tmp8_;
		gint _e_size;
		gint _e_index;
		_tmp7_ = _vala_iterable_ref0 (sizes);
		_e_list = _tmp7_;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			ValaExpression* e;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp9_ = vala_list_get (_e_list, _e_index);
			e = (ValaExpression*) _tmp9_;
			vala_code_node_check ((ValaCodeNode*) e, analyzer);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp10_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	calc_sizes = _tmp10_;
	if (initlist != NULL) {
		ValaDataType* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_ = NULL;
		ValaArrayType* _tmp13_ = NULL;
		ValaArrayType* _tmp14_;
		gint _tmp15_;
		gint ret;
		_tmp11_ = vala_array_creation_expression_get_element_type (self);
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp13_ = vala_array_type_new (_tmp11_, self->priv->_rank, _tmp12_);
		_tmp14_ = _tmp13_;
		vala_expression_set_target_type ((ValaExpression*) initlist, (ValaDataType*) _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		vala_code_node_check ((ValaCodeNode*) initlist, analyzer);
		_tmp15_ = vala_array_creation_expression_create_sizes_from_initializer_list (self, analyzer, initlist, self->priv->_rank, (ValaList*) calc_sizes);
		ret = _tmp15_;
		if (ret == (-1)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	_tmp16_ = vala_collection_get_size ((ValaCollection*) sizes);
	if (_tmp16_ > 0) {
		{
			ValaList* _tmp17_;
			ValaList* _e_list;
			gint _tmp18_;
			gint _e_size;
			gint _e_index;
			_tmp17_ = _vala_iterable_ref0 (sizes);
			_e_list = _tmp17_;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _e_list);
			_e_size = _tmp18_;
			_e_index = -1;
			while (TRUE) {
				gpointer _tmp19_ = NULL;
				ValaExpression* e;
				ValaDataType* _tmp20_ = NULL;
				_e_index = _e_index + 1;
				if (!(_e_index < _e_size)) {
					break;
				}
				_tmp19_ = vala_list_get (_e_list, _e_index);
				e = (ValaExpression*) _tmp19_;
				_tmp20_ = vala_expression_get_value_type (e);
				if (_tmp20_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp21_ = FALSE;
					ValaDataType* _tmp22_ = NULL;
					_tmp22_ = vala_expression_get_value_type (e);
					if (VALA_IS_INTEGER_TYPE (_tmp22_)) {
						_tmp21_ = TRUE;
					} else {
						ValaDataType* _tmp23_ = NULL;
						_tmp23_ = vala_expression_get_value_type (e);
						_tmp21_ = VALA_IS_ENUM_VALUE_TYPE (_tmp23_);
					}
					if (!_tmp21_) {
						ValaSourceReference* _tmp24_ = NULL;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) e);
						vala_report_error (_tmp24_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		if (initlist == NULL) {
			ValaSourceReference* _tmp25_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			vala_report_error (_tmp25_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _tmp26_;
				ValaArrayList* _size_list;
				gint _tmp27_;
				gint _size_size;
				gint _size_index;
				_tmp26_ = _vala_iterable_ref0 (calc_sizes);
				_size_list = _tmp26_;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _size_list);
				_size_size = _tmp27_;
				_size_index = -1;
				while (TRUE) {
					gpointer _tmp28_ = NULL;
					ValaExpression* size;
					_size_index = _size_index + 1;
					if (!(_size_index < _size_size)) {
						break;
					}
					_tmp28_ = vala_list_get ((ValaList*) _size_list, _size_index);
					size = (ValaExpression*) ((ValaLiteral*) _tmp28_);
					vala_array_creation_expression_append_size (self, size);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp29_ = vala_code_node_get_error ((ValaCodeNode*) self);
	if (_tmp29_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp31_ = vala_array_creation_expression_get_initializer_list (self);
	if (_tmp31_ != NULL) {
		ValaInitializerList* _tmp32_ = NULL;
		ValaDataType* _tmp33_ = NULL;
		_tmp32_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp33_ = vala_expression_get_value_type ((ValaExpression*) _tmp32_);
		_tmp30_ = _tmp33_ == NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp34_ = vala_array_creation_expression_get_element_type (self);
	if (_tmp34_ == NULL) {
		ValaSourceReference* _tmp35_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp35_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp36_ = vala_array_creation_expression_get_element_type (self);
	vala_data_type_set_value_owned (_tmp36_, TRUE);
	_tmp37_ = vala_array_creation_expression_get_element_type (self);
	_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp39_ = vala_array_type_new (_tmp37_, self->priv->_rank, _tmp38_);
	_tmp40_ = _tmp39_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp40_);
	_vala_code_node_unref0 (_tmp40_);
	_tmp41_ = vala_expression_get_value_type ((ValaExpression*) self);
	vala_data_type_set_value_owned (_tmp41_, TRUE);
	_tmp42_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp42_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}


static void vala_array_creation_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp3_ = NULL;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _e_list;
		gint _tmp1_;
		gint _e_size;
		gint _e_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->sizes);
		_e_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp1_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaExpression* e;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_e_list, _e_index);
			e = (ValaExpression*) _tmp2_;
			vala_code_node_emit ((ValaCodeNode*) e, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp3_ = vala_array_creation_expression_get_initializer_list (self);
	if (_tmp3_ != NULL) {
		ValaInitializerList* _tmp4_ = NULL;
		_tmp4_ = vala_array_creation_expression_get_initializer_list (self);
		vala_code_node_emit ((ValaCodeNode*) _tmp4_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


ValaDataType* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_element_type;
	return result;
}


void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp1_;
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_element_type, (ValaCodeNode*) self);
}


gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}


void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self) {
	ValaInitializerList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_initializer_list;
	return result;
}


void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value) {
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp1_;
	if (self->priv->_initializer_list != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_initializer_list, (ValaCodeNode*) self);
	}
}


static void vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass) {
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_creation_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_array_creation_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_array_creation_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_array_creation_expression_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_creation_expression_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_array_creation_expression_real_check;
	VALA_CODE_NODE_CLASS (klass)->emit = vala_array_creation_expression_real_emit;
}


static void vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->sizes = (ValaList*) _tmp0_;
}


static void vala_array_creation_expression_finalize (ValaCodeNode* obj) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (obj);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an array creation expression e.g. {{{ new int[] {1,2,3} }}}.
 */
GType vala_array_creation_expression_get_type (void) {
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}



