/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valacodegen.h>
#include <unistd.h>
#include <config.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static char* vala_compiler_basedir;
static char* vala_compiler_basedir = NULL;
static char* vala_compiler_directory;
static char* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static char** vala_compiler_sources;
static char** vala_compiler_sources = NULL;
static char** vala_compiler_vapi_directories;
static char** vala_compiler_vapi_directories = NULL;
static char** vala_compiler_gir_directories;
static char** vala_compiler_gir_directories = NULL;
static char* vala_compiler_vapi_filename;
static char* vala_compiler_vapi_filename = NULL;
static char* vala_compiler_library;
static char* vala_compiler_library = NULL;
static char* vala_compiler_gir;
static char* vala_compiler_gir = NULL;
static char** vala_compiler_packages;
static char** vala_compiler_packages = NULL;
static char* vala_compiler_target_glib;
static char* vala_compiler_target_glib = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static char* vala_compiler_header_filename;
static char* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static char* vala_compiler_internal_header_filename;
static char* vala_compiler_internal_header_filename = NULL;
static char* vala_compiler_internal_vapi_filename;
static char* vala_compiler_internal_vapi_filename = NULL;
static char* vala_compiler_symbols_filename;
static char* vala_compiler_symbols_filename = NULL;
static char* vala_compiler_includedir;
static char* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static char* vala_compiler_output;
static char* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_disable_dbus_transformation;
static gboolean vala_compiler_disable_dbus_transformation = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static char* vala_compiler_cc_command;
static char* vala_compiler_cc_command = NULL;
static char** vala_compiler_cc_options;
static char** vala_compiler_cc_options = NULL;
static char* vala_compiler_dump_tree;
static char* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static char** vala_compiler_defines;
static char** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static char* vala_compiler_profile;
static char* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static char* vala_compiler_entry_point;
static char* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gpointer vala_compiler_parent_class = NULL;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gboolean vala_compiler_add_gir (ValaCompiler* self, ValaCodeContext* context, const char* gir);
static gboolean vala_compiler_add_package (ValaCompiler* self, ValaCodeContext* context, const char* pkg);
static gint vala_compiler_run (ValaCompiler* self);
static char* vala_compiler_realpath (const char* name);
static gboolean vala_compiler_ends_with_dir_separator (const char* s);
static gint vala_compiler_run_source (char** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void _lambda0_ (GPid pid, gint status, Block1Data* _data1_);
static void __lambda0__gchild_watch_func (GPid pid, gint status, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gint vala_compiler_main (char** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry VALA_COMPILER_options[44] = {{"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"disable-dbus-transformation", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_dbus_transformation, "Disable transformation of D-Bus member names", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};


static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) == 0) {
		_tmp0_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) == 0) {
		gboolean _tmp2_ = FALSE;
		if (!vala_compiler_fatal_warnings) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) == 0;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (!vala_compiler_quiet_mode) {
			fprintf (stdout, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (vala_code_context_get_report (self->priv->context)));
		}
		result = 0;
		return result;
	} else {
		if (!vala_compiler_quiet_mode) {
			fprintf (stdout, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (vala_code_context_get_report (self->priv->context)), vala_report_get_warnings (vala_code_context_get_report (self->priv->context)));
		}
		result = 1;
		return result;
	}
}


static gboolean vala_compiler_add_gir (ValaCompiler* self, ValaCodeContext* context, const char* gir) {
	gboolean result = FALSE;
	char* gir_path;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (gir != NULL, FALSE);
	gir_path = vala_code_context_get_gir_path (context, gir, vala_compiler_gir_directories, _vala_array_length (vala_compiler_gir_directories));
	if (gir_path == NULL) {
		result = FALSE;
		_g_free0 (gir_path);
		return result;
	}
	vala_code_context_add_source_file (context, _tmp0_ = vala_source_file_new (context, gir_path, TRUE, NULL));
	_vala_source_file_unref0 (_tmp0_);
	result = TRUE;
	_g_free0 (gir_path);
	return result;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean vala_compiler_add_package (ValaCompiler* self, ValaCodeContext* context, const char* pkg) {
	gboolean result = FALSE;
	char* package_path;
	ValaSourceFile* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* deps_filename;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (vala_code_context_has_package (context, pkg)) {
		result = TRUE;
		return result;
	}
	package_path = vala_code_context_get_package_path (context, pkg, vala_compiler_vapi_directories, _vala_array_length (vala_compiler_vapi_directories));
	if (package_path == NULL) {
		result = FALSE;
		_g_free0 (package_path);
		return result;
	}
	vala_code_context_add_package (context, pkg);
	vala_code_context_add_source_file (context, _tmp0_ = vala_source_file_new (context, package_path, TRUE, NULL));
	_vala_source_file_unref0 (_tmp0_);
	deps_filename = (_tmp3_ = g_build_filename (_tmp1_ = g_path_get_dirname (package_path), _tmp2_ = g_strdup_printf ("%s.deps", pkg), NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	if (g_file_test (deps_filename, G_FILE_TEST_EXISTS)) {
		{
			char* deps_content;
			gsize deps_len = 0UL;
			char* _tmp4_ = NULL;
			char* _tmp5_;
			deps_content = NULL;
			g_file_get_contents (deps_filename, &_tmp4_, &deps_len, &_inner_error_);
			deps_content = (_tmp5_ = _tmp4_, _g_free0 (deps_content), _tmp5_);
			if (_inner_error_ != NULL) {
				_g_free0 (deps_content);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (deps_content);
				_g_free0 (deps_filename);
				_g_free0 (package_path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			{
				char** _tmp6_;
				char** dep_collection;
				int dep_collection_length1;
				int dep_it;
				dep_collection = _tmp6_ = g_strsplit (deps_content, "\n", 0);
				dep_collection_length1 = _vala_array_length (_tmp6_);
				for (dep_it = 0; dep_it < _vala_array_length (_tmp6_); dep_it = dep_it + 1) {
					char* dep;
					dep = g_strdup (dep_collection[dep_it]);
					{
						char* _tmp7_;
						dep = (_tmp7_ = string_strip (dep), _g_free0 (dep), _tmp7_);
						if (_vala_strcmp0 (dep, "") != 0) {
							if (!vala_compiler_add_package (self, context, dep)) {
								char* _tmp8_;
								vala_report_error (NULL, _tmp8_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", dep, pkg));
								_g_free0 (_tmp8_);
							}
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp9_;
				vala_report_error (NULL, _tmp9_ = g_strdup_printf ("Unable to read dependency file: %s", e->message));
				_g_free0 (_tmp9_);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (deps_filename);
			_g_free0 (package_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_g_free0 (package_path);
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean has_c_files;
	char** _tmp38_;
	gboolean _tmp39_ = FALSE;
	ValaParser* parser;
	ValaGenieParser* genie_parser;
	ValaGirParser* gir_parser;
	gboolean _tmp42_ = FALSE;
	ValaSymbolResolver* resolver;
	gboolean _tmp44_ = FALSE;
	ValaSemanticAnalyzer* analyzer;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp49_ = FALSE;
	ValaFlowAnalyzer* flow_analyzer;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp55_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	self->priv->context = (_tmp0_ = vala_code_context_new (), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	vala_code_context_push (self->priv->context);
	if (!vala_compiler_ccode_only) {
		_tmp2_ = !vala_compiler_compile_only;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = vala_compiler_output == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (g_utf8_strrchr (vala_compiler_sources[0], (gssize) (-1), (gunichar) '.') != NULL) {
			glong dot;
			char* _tmp3_;
			char* _tmp4_;
			dot = g_utf8_pointer_to_offset (vala_compiler_sources[0], g_utf8_strrchr (vala_compiler_sources[0], (gssize) (-1), (gunichar) '.'));
			vala_compiler_output = (_tmp4_ = g_path_get_basename (_tmp3_ = string_substring (vala_compiler_sources[0], (glong) 0, dot)), _g_free0 (vala_compiler_output), _tmp4_);
			_g_free0 (_tmp3_);
		}
	}
	vala_code_context_set_assert (self->priv->context, !vala_compiler_disable_assert);
	vala_code_context_set_checking (self->priv->context, vala_compiler_enable_checking);
	vala_code_context_set_deprecated (self->priv->context, vala_compiler_deprecated);
	vala_code_context_set_experimental (self->priv->context, vala_compiler_experimental);
	vala_code_context_set_experimental_non_null (self->priv->context, vala_compiler_experimental_non_null);
	vala_code_context_set_dbus_transformation (self->priv->context, !vala_compiler_disable_dbus_transformation);
	vala_report_set_enable_warnings (vala_code_context_get_report (self->priv->context), !vala_compiler_disable_warnings);
	vala_report_set_verbose_errors (vala_code_context_get_report (self->priv->context), !vala_compiler_quiet_mode);
	vala_code_context_set_verbose_mode (self->priv->context, vala_compiler_verbose_mode);
	vala_code_context_set_version_header (self->priv->context, !vala_compiler_disable_version_header);
	vala_code_context_set_ccode_only (self->priv->context, vala_compiler_ccode_only);
	vala_code_context_set_compile_only (self->priv->context, vala_compiler_compile_only);
	vala_code_context_set_header_filename (self->priv->context, vala_compiler_header_filename);
	if (vala_compiler_header_filename == NULL) {
		_tmp5_ = vala_compiler_use_header;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	vala_code_context_set_use_header (self->priv->context, vala_compiler_use_header);
	vala_code_context_set_internal_header_filename (self->priv->context, vala_compiler_internal_header_filename);
	vala_code_context_set_symbols_filename (self->priv->context, vala_compiler_symbols_filename);
	vala_code_context_set_includedir (self->priv->context, vala_compiler_includedir);
	vala_code_context_set_output (self->priv->context, vala_compiler_output);
	if (vala_compiler_basedir == NULL) {
		char* _tmp6_;
		vala_code_context_set_basedir (self->priv->context, _tmp6_ = vala_compiler_realpath ("."));
		_g_free0 (_tmp6_);
	} else {
		char* _tmp7_;
		vala_code_context_set_basedir (self->priv->context, _tmp7_ = vala_compiler_realpath (vala_compiler_basedir));
		_g_free0 (_tmp7_);
	}
	if (vala_compiler_directory != NULL) {
		char* _tmp8_;
		vala_code_context_set_directory (self->priv->context, _tmp8_ = vala_compiler_realpath (vala_compiler_directory));
		_g_free0 (_tmp8_);
	} else {
		vala_code_context_set_directory (self->priv->context, vala_code_context_get_basedir (self->priv->context));
	}
	vala_code_context_set_debug (self->priv->context, vala_compiler_debug);
	vala_code_context_set_thread (self->priv->context, vala_compiler_thread);
	vala_code_context_set_mem_profiler (self->priv->context, vala_compiler_mem_profiler);
	vala_code_context_set_save_temps (self->priv->context, vala_compiler_save_temps);
	if (_vala_strcmp0 (vala_compiler_profile, "posix") == 0) {
		vala_code_context_set_profile (self->priv->context, VALA_PROFILE_POSIX);
		vala_code_context_add_define (self->priv->context, "POSIX");
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (_vala_strcmp0 (vala_compiler_profile, "gobject-2.0") == 0) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = _vala_strcmp0 (vala_compiler_profile, "gobject") == 0;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = vala_compiler_profile == NULL;
		}
		if (_tmp9_) {
			vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
			vala_code_context_add_define (self->priv->context, "GOBJECT");
		} else {
			if (_vala_strcmp0 (vala_compiler_profile, "dova") == 0) {
				vala_code_context_set_profile (self->priv->context, VALA_PROFILE_DOVA);
				vala_code_context_add_define (self->priv->context, "DOVA");
			} else {
				char* _tmp11_;
				vala_report_error (NULL, _tmp11_ = g_strdup_printf ("Unknown profile %s", vala_compiler_profile));
				_g_free0 (_tmp11_);
			}
		}
	}
	vala_code_context_set_nostdpkg (self->priv->context, vala_compiler_nostdpkg);
	vala_code_context_set_entry_point_name (self->priv->context, vala_compiler_entry_point);
	vala_code_context_set_run_output (self->priv->context, vala_compiler_run_output);
	if (vala_compiler_defines != NULL) {
		{
			char** define_collection;
			int define_collection_length1;
			int define_it;
			define_collection = vala_compiler_defines;
			define_collection_length1 = _vala_array_length (vala_compiler_defines);
			for (define_it = 0; define_it < _vala_array_length (vala_compiler_defines); define_it = define_it + 1) {
				char* define;
				define = g_strdup (define_collection[define_it]);
				{
					vala_code_context_add_define (self->priv->context, define);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i;
		i = 2;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				char* _tmp13_;
				if (!_tmp12_) {
					i = i + 2;
				}
				_tmp12_ = FALSE;
				if (!(i <= 10)) {
					break;
				}
				vala_code_context_add_define (self->priv->context, _tmp13_ = g_strdup_printf ("VALA_0_%d", i));
				_g_free0 (_tmp13_);
			}
		}
	}
	if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_POSIX) {
		if (!vala_compiler_nostdpkg) {
			if (!vala_compiler_add_package (self, self->priv->context, "posix")) {
				vala_report_error (NULL, "posix not found in specified Vala API directories");
			}
		}
	} else {
		if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_GOBJECT) {
			gint glib_major;
			gint glib_minor;
			gboolean _tmp14_ = FALSE;
			glib_major = 2;
			glib_minor = 14;
			if (vala_compiler_target_glib != NULL) {
				_tmp14_ = sscanf (vala_compiler_target_glib, "%d.%d", &glib_major, &glib_minor) != 2;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				vala_report_error (NULL, "Invalid format for --target-glib");
			}
			vala_code_context_set_target_glib_major (self->priv->context, glib_major);
			vala_code_context_set_target_glib_minor (self->priv->context, glib_minor);
			if (vala_code_context_get_target_glib_major (self->priv->context) != 2) {
				vala_report_error (NULL, "This version of valac only supports GLib 2");
			}
			{
				gint i;
				i = 16;
				{
					gboolean _tmp15_;
					_tmp15_ = TRUE;
					while (TRUE) {
						char* _tmp16_;
						if (!_tmp15_) {
							i = i + 2;
						}
						_tmp15_ = FALSE;
						if (!(i <= glib_minor)) {
							break;
						}
						vala_code_context_add_define (self->priv->context, _tmp16_ = g_strdup_printf ("GLIB_2_%d", i));
						_g_free0 (_tmp16_);
					}
				}
			}
			if (!vala_compiler_nostdpkg) {
				if (!vala_compiler_add_package (self, self->priv->context, "glib-2.0")) {
					vala_report_error (NULL, "glib-2.0 not found in specified Vala API directories");
				}
				if (!vala_compiler_add_package (self, self->priv->context, "gobject-2.0")) {
					vala_report_error (NULL, "gobject-2.0 not found in specified Vala API directories");
				}
			}
		} else {
			if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_DOVA) {
				if (!vala_compiler_nostdpkg) {
					if (!vala_compiler_add_package (self, self->priv->context, "dova-core-0.1")) {
						vala_report_error (NULL, "dova-core-0.1 not found in specified Vala API directories");
					}
				}
			}
		}
	}
	if (vala_compiler_packages != NULL) {
		char** _tmp20_;
		{
			char** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_compiler_packages;
			package_collection_length1 = _vala_array_length (vala_compiler_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_compiler_packages); package_it = package_it + 1) {
				char* package;
				package = g_strdup (package_collection[package_it]);
				{
					gboolean _tmp17_ = FALSE;
					gboolean _tmp19_ = FALSE;
					if (!vala_compiler_add_package (self, self->priv->context, package)) {
						_tmp17_ = !vala_compiler_add_gir (self, self->priv->context, package);
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						char* _tmp18_;
						vala_report_error (NULL, _tmp18_ = g_strdup_printf ("%s not found in specified Vala API directories or GObject-Introspectio" \
"n GIR directories", package));
						_g_free0 (_tmp18_);
					}
					if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_GOBJECT) {
						_tmp19_ = _vala_strcmp0 (package, "dbus-glib-1") == 0;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						vala_code_context_add_define (self->priv->context, "DBUS_GLIB");
					}
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_tmp20_ = NULL, vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL), _tmp20_);
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp22_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp22_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp21_ = _tmp22_;
	}
	if (_tmp21_) {
		result = vala_compiler_quit (self);
		return result;
	}
	if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_GOBJECT) {
		if (vala_code_context_has_package (self->priv->context, "dbus-glib-1")) {
			ValaDBusServerModule* _tmp23_;
			if (!vala_code_context_get_deprecated (self->priv->context)) {
				vala_report_warning (NULL, "D-Bus GLib is deprecated, use GDBus");
			}
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) (_tmp23_ = vala_dbus_server_module_new ()));
			_vala_code_visitor_unref0 (_tmp23_);
		} else {
			ValaGDBusServerModule* _tmp24_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) (_tmp24_ = vala_gd_bus_server_module_new ()));
			_vala_code_visitor_unref0 (_tmp24_);
		}
	} else {
		if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_DOVA) {
			ValaDovaErrorModule* _tmp25_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) (_tmp25_ = vala_dova_error_module_new ()));
			_vala_code_visitor_unref0 (_tmp25_);
		} else {
			ValaCCodeDelegateModule* _tmp26_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) (_tmp26_ = vala_ccode_delegate_module_new ()));
			_vala_code_visitor_unref0 (_tmp26_);
		}
	}
	has_c_files = FALSE;
	{
		char** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_compiler_sources;
		source_collection_length1 = _vala_array_length (vala_compiler_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_compiler_sources); source_it = source_it + 1) {
			char* source;
			source = g_strdup (source_collection[source_it]);
			{
				if (g_file_test (source, G_FILE_TEST_EXISTS)) {
					char* rpath;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_ = FALSE;
					rpath = vala_compiler_realpath (source);
					if (vala_compiler_run_output) {
						_tmp28_ = TRUE;
					} else {
						_tmp28_ = g_str_has_suffix (source, ".vala");
					}
					if (_tmp28_) {
						_tmp27_ = TRUE;
					} else {
						_tmp27_ = g_str_has_suffix (source, ".gs");
					}
					if (_tmp27_) {
						ValaSourceFile* source_file;
						source_file = vala_source_file_new (self->priv->context, rpath, FALSE, NULL);
						vala_source_file_set_relative_filename (source_file, source);
						if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_POSIX) {
							ValaUnresolvedSymbol* _tmp29_;
							ValaUsingDirective* _tmp30_;
							ValaUsingDirective* ns_ref;
							ns_ref = (_tmp30_ = vala_using_directive_new ((ValaSymbol*) (_tmp29_ = vala_unresolved_symbol_new (NULL, "Posix", NULL)), NULL), _vala_code_node_unref0 (_tmp29_), _tmp30_);
							vala_source_file_add_using_directive (source_file, ns_ref);
							vala_namespace_add_using_directive (vala_code_context_get_root (self->priv->context), ns_ref);
							_vala_code_node_unref0 (ns_ref);
						} else {
							if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_GOBJECT) {
								ValaUnresolvedSymbol* _tmp31_;
								ValaUsingDirective* _tmp32_;
								ValaUsingDirective* ns_ref;
								ns_ref = (_tmp32_ = vala_using_directive_new ((ValaSymbol*) (_tmp31_ = vala_unresolved_symbol_new (NULL, "GLib", NULL)), NULL), _vala_code_node_unref0 (_tmp31_), _tmp32_);
								vala_source_file_add_using_directive (source_file, ns_ref);
								vala_namespace_add_using_directive (vala_code_context_get_root (self->priv->context), ns_ref);
								_vala_code_node_unref0 (ns_ref);
							} else {
								if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_DOVA) {
									ValaUnresolvedSymbol* _tmp33_;
									ValaUsingDirective* _tmp34_;
									ValaUsingDirective* ns_ref;
									ns_ref = (_tmp34_ = vala_using_directive_new ((ValaSymbol*) (_tmp33_ = vala_unresolved_symbol_new (NULL, "Dova", NULL)), NULL), _vala_code_node_unref0 (_tmp33_), _tmp34_);
									vala_source_file_add_using_directive (source_file, ns_ref);
									vala_namespace_add_using_directive (vala_code_context_get_root (self->priv->context), ns_ref);
									_vala_code_node_unref0 (ns_ref);
								}
							}
						}
						vala_code_context_add_source_file (self->priv->context, source_file);
						_vala_source_file_unref0 (source_file);
					} else {
						gboolean _tmp35_ = FALSE;
						if (g_str_has_suffix (source, ".vapi")) {
							_tmp35_ = TRUE;
						} else {
							_tmp35_ = g_str_has_suffix (source, ".gir");
						}
						if (_tmp35_) {
							ValaSourceFile* source_file;
							source_file = vala_source_file_new (self->priv->context, rpath, TRUE, NULL);
							vala_source_file_set_relative_filename (source_file, source);
							vala_code_context_add_source_file (self->priv->context, source_file);
							_vala_source_file_unref0 (source_file);
						} else {
							if (g_str_has_suffix (source, ".c")) {
								vala_code_context_add_c_source_file (self->priv->context, rpath);
								has_c_files = TRUE;
							} else {
								char* _tmp36_;
								vala_report_error (NULL, _tmp36_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c" \
" files are supported.", source));
								_g_free0 (_tmp36_);
							}
						}
					}
					_g_free0 (rpath);
				} else {
					char* _tmp37_;
					vala_report_error (NULL, _tmp37_ = g_strdup_printf ("%s not found", source));
					_g_free0 (_tmp37_);
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_tmp38_ = NULL, vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL), _tmp38_);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp39_ = TRUE;
	} else {
		gboolean _tmp40_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp40_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp40_ = FALSE;
		}
		_tmp39_ = _tmp40_;
	}
	if (_tmp39_) {
		result = vala_compiler_quit (self);
		return result;
	}
	parser = vala_parser_new ();
	vala_parser_parse (parser, self->priv->context);
	genie_parser = vala_genie_parser_new ();
	vala_genie_parser_parse (genie_parser, self->priv->context);
	gir_parser = vala_gir_parser_new ();
	vala_gir_parser_parse (gir_parser, self->priv->context);
	if (vala_gir_parser_get_package_names != NULL) {
		{
			gint _tmp41_;
			char** pkg_collection;
			int pkg_collection_length1;
			int pkg_it;
			pkg_collection = vala_gir_parser_get_package_names (gir_parser, &_tmp41_);
			pkg_collection_length1 = _tmp41_;
			for (pkg_it = 0; pkg_it < _tmp41_; pkg_it = pkg_it + 1) {
				char* pkg;
				pkg = g_strdup (pkg_collection[pkg_it]);
				{
					vala_code_context_add_package (self->priv->context, pkg);
					_g_free0 (pkg);
				}
			}
			pkg_collection = (_vala_array_free (pkg_collection, pkg_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp42_ = TRUE;
	} else {
		gboolean _tmp43_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp43_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp43_ = FALSE;
		}
		_tmp42_ = _tmp43_;
	}
	if (_tmp42_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	resolver = vala_symbol_resolver_new ();
	vala_symbol_resolver_resolve (resolver, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp44_ = TRUE;
	} else {
		gboolean _tmp45_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp45_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp45_ = FALSE;
		}
		_tmp44_ = _tmp45_;
	}
	if (_tmp44_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	analyzer = vala_semantic_analyzer_new ();
	vala_semantic_analyzer_analyze (analyzer, self->priv->context);
	if (!vala_compiler_ccode_only) {
		_tmp47_ = !vala_compiler_compile_only;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		_tmp46_ = vala_compiler_library == NULL;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		gboolean _tmp48_ = FALSE;
		if (!has_c_files) {
			_tmp48_ = vala_code_context_get_entry_point (self->priv->context) == NULL;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	if (vala_compiler_dump_tree != NULL) {
		ValaCodeWriter* code_writer;
		code_writer = vala_code_writer_new (TRUE, FALSE);
		vala_code_writer_write_file (code_writer, self->priv->context, vala_compiler_dump_tree);
		_vala_code_visitor_unref0 (code_writer);
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp49_ = TRUE;
	} else {
		gboolean _tmp50_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp50_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp50_ = FALSE;
		}
		_tmp49_ = _tmp50_;
	}
	if (_tmp49_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	flow_analyzer = vala_flow_analyzer_new ();
	vala_flow_analyzer_analyze (flow_analyzer, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp51_ = TRUE;
	} else {
		gboolean _tmp52_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp52_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp52_ = FALSE;
		}
		_tmp51_ = _tmp52_;
	}
	if (_tmp51_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (flow_analyzer);
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	vala_code_generator_emit (vala_code_context_get_codegen (self->priv->context), self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		_tmp53_ = TRUE;
	} else {
		gboolean _tmp54_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			_tmp54_ = vala_report_get_warnings (vala_code_context_get_report (self->priv->context)) > 0;
		} else {
			_tmp54_ = FALSE;
		}
		_tmp53_ = _tmp54_;
	}
	if (_tmp53_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (flow_analyzer);
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (vala_compiler_vapi_filename == NULL) {
		_tmp55_ = vala_compiler_library != NULL;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		char* _tmp56_;
		vala_compiler_vapi_filename = (_tmp56_ = g_strdup_printf ("%s.vapi", vala_compiler_library), _g_free0 (vala_compiler_vapi_filename), _tmp56_);
	}
	if (vala_compiler_library != NULL) {
		char* _tmp65_;
		if (vala_compiler_gir != NULL) {
			char* _tmp64_;
			if (vala_code_context_get_profile (self->priv->context) == VALA_PROFILE_GOBJECT) {
				glong gir_len;
				const char* last_hyphen;
				gboolean _tmp57_ = FALSE;
				gir_len = string_get_length (vala_compiler_gir);
				last_hyphen = g_utf8_strrchr (vala_compiler_gir, (gssize) gir_len, (gunichar) '-');
				if (last_hyphen == NULL) {
					_tmp57_ = TRUE;
				} else {
					_tmp57_ = !g_str_has_suffix (vala_compiler_gir, ".gir");
				}
				if (_tmp57_) {
					char* _tmp58_;
					vala_report_error (NULL, _tmp58_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", vala_compiler_gir));
					_g_free0 (_tmp58_);
				} else {
					glong offset;
					char* gir_namespace;
					char* gir_version;
					gboolean _tmp59_ = FALSE;
					gboolean _tmp60_ = FALSE;
					gboolean _tmp61_ = FALSE;
					offset = g_utf8_pointer_to_offset (vala_compiler_gir, last_hyphen);
					gir_namespace = string_substring (vala_compiler_gir, (glong) 0, offset);
					gir_version = string_substring (vala_compiler_gir, offset + 1, (gir_len - offset) - 5);
					g_strcanon (gir_version, "0123456789.", '?');
					if (_vala_strcmp0 (gir_namespace, "") == 0) {
						_tmp61_ = TRUE;
					} else {
						_tmp61_ = _vala_strcmp0 (gir_version, "") == 0;
					}
					if (_tmp61_) {
						_tmp60_ = TRUE;
					} else {
						_tmp60_ = !g_unichar_isdigit (g_utf8_get_char (g_utf8_offset_to_pointer (gir_version, 0)));
					}
					if (_tmp60_) {
						_tmp59_ = TRUE;
					} else {
						_tmp59_ = string_contains (gir_version, "?");
					}
					if (_tmp59_) {
						char* _tmp62_;
						vala_report_error (NULL, _tmp62_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", vala_compiler_gir));
						_g_free0 (_tmp62_);
					} else {
						ValaGIRWriter* gir_writer;
						char* gir_directory;
						gir_writer = vala_gir_writer_new ();
						gir_directory = g_strdup (".");
						if (vala_compiler_directory != NULL) {
							char* _tmp63_;
							gir_directory = (_tmp63_ = g_strdup (vala_code_context_get_directory (self->priv->context)), _g_free0 (gir_directory), _tmp63_);
						}
						vala_gir_writer_write_file (gir_writer, self->priv->context, gir_directory, gir_namespace, gir_version, vala_compiler_library);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
			}
			vala_compiler_gir = (_tmp64_ = NULL, _g_free0 (vala_compiler_gir), _tmp64_);
		}
		vala_compiler_library = (_tmp65_ = NULL, _g_free0 (vala_compiler_library), _tmp65_);
	}
	if (vala_compiler_vapi_filename != NULL) {
		ValaCodeWriter* interface_writer;
		gboolean _tmp66_ = FALSE;
		interface_writer = vala_code_writer_new (FALSE, FALSE);
		if (vala_compiler_directory != NULL) {
			_tmp66_ = !g_path_is_absolute (vala_compiler_vapi_filename);
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			char* _tmp67_;
			vala_compiler_vapi_filename = (_tmp67_ = g_strdup_printf ("%s%c%s", vala_code_context_get_directory (self->priv->context), (gint) G_DIR_SEPARATOR, vala_compiler_vapi_filename), _g_free0 (vala_compiler_vapi_filename), _tmp67_);
		}
		vala_code_writer_write_file (interface_writer, self->priv->context, vala_compiler_vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	if (vala_compiler_internal_vapi_filename != NULL) {
		gboolean _tmp68_ = FALSE;
		ValaCodeWriter* interface_writer;
		char* vapi_filename;
		gboolean _tmp69_ = FALSE;
		char* _tmp71_;
		if (vala_compiler_internal_header_filename == NULL) {
			_tmp68_ = TRUE;
		} else {
			_tmp68_ = vala_compiler_header_filename == NULL;
		}
		if (_tmp68_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (flow_analyzer);
			_vala_code_visitor_unref0 (analyzer);
			_vala_code_visitor_unref0 (resolver);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		interface_writer = vala_code_writer_new (FALSE, TRUE);
		vala_code_writer_set_cheader_override (interface_writer, vala_compiler_header_filename, vala_compiler_internal_header_filename);
		vapi_filename = g_strdup (vala_compiler_internal_vapi_filename);
		if (vala_compiler_directory != NULL) {
			_tmp69_ = !g_path_is_absolute (vapi_filename);
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			char* _tmp70_;
			vapi_filename = (_tmp70_ = g_strdup_printf ("%s%c%s", vala_code_context_get_directory (self->priv->context), (gint) G_DIR_SEPARATOR, vapi_filename), _g_free0 (vapi_filename), _tmp70_);
		}
		vala_code_writer_write_file (interface_writer, self->priv->context, vapi_filename);
		vala_compiler_internal_vapi_filename = (_tmp71_ = NULL, _g_free0 (vala_compiler_internal_vapi_filename), _tmp71_);
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	if (!vala_compiler_ccode_only) {
		ValaCCodeCompiler* ccompiler;
		gboolean _tmp72_ = FALSE;
		ccompiler = vala_ccode_compiler_new ();
		if (vala_compiler_cc_command == NULL) {
			_tmp72_ = g_getenv ("CC") != NULL;
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			char* _tmp73_;
			vala_compiler_cc_command = (_tmp73_ = g_strdup (g_getenv ("CC")), _g_free0 (vala_compiler_cc_command), _tmp73_);
		}
		if (vala_compiler_cc_options == NULL) {
			char** _tmp74_ = NULL;
			char** _tmp75_;
			gint _tmp75__length1;
			vala_ccode_compiler_compile (ccompiler, self->priv->context, vala_compiler_cc_command, (_tmp75_ = (_tmp74_ = g_new0 (char*, 0 + 1), _tmp74_), _tmp75__length1 = 0, _tmp75_), 0);
			_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
		} else {
			vala_ccode_compiler_compile (ccompiler, self->priv->context, vala_compiler_cc_command, vala_compiler_cc_options, _vala_array_length (vala_compiler_cc_options));
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (flow_analyzer);
	_vala_code_visitor_unref0 (analyzer);
	_vala_code_visitor_unref0 (resolver);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gboolean vala_compiler_ends_with_dir_separator (const char* s) {
	gboolean result = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	result = G_IS_DIR_SEPARATOR (g_utf8_get_char (g_utf8_offset_to_pointer (s, string_get_length (s) - 1)));
	return result;
}


static char* vala_compiler_realpath (const char* name) {
	char* result = NULL;
	char* rpath;
	const char* start;
	const char* end;
	glong root_len;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	rpath = NULL;
	start = NULL;
	end = NULL;
	if (!g_path_is_absolute (name)) {
		char* _tmp0_;
		rpath = (_tmp0_ = g_get_current_dir (), _g_free0 (rpath), _tmp0_);
		start = end = name;
	} else {
		char* _tmp1_;
		start = end = g_path_skip_root (name);
		rpath = (_tmp1_ = string_substring (name, (glong) 0, g_utf8_pointer_to_offset (name, start)), _g_free0 (rpath), _tmp1_);
	}
	root_len = g_utf8_pointer_to_offset (rpath, g_path_skip_root (rpath));
	{
		gboolean _tmp2_;
		_tmp2_ = TRUE;
		while (TRUE) {
			glong len;
			if (!_tmp2_) {
				start = end;
			}
			_tmp2_ = FALSE;
			if (!(g_utf8_get_char (start) != 0)) {
				break;
			}
			while (TRUE) {
				if (!G_IS_DIR_SEPARATOR (g_utf8_get_char (start))) {
					break;
				}
				start = g_utf8_next_char (start);
			}
			len = (glong) 0;
			{
				gboolean _tmp3_;
				end = start;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					if (!_tmp3_) {
						end = g_utf8_next_char (end);
					}
					_tmp3_ = FALSE;
					if (g_utf8_get_char (end) != 0) {
						_tmp4_ = !G_IS_DIR_SEPARATOR (g_utf8_get_char (end));
					} else {
						_tmp4_ = FALSE;
					}
					if (!_tmp4_) {
						break;
					}
					len++;
				}
			}
			if (len == 0) {
				break;
			} else {
				gboolean _tmp5_ = FALSE;
				if (len == 1) {
					_tmp5_ = g_utf8_get_char (start) == '.';
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
				} else {
					gboolean _tmp6_ = FALSE;
					if (len == 2) {
						_tmp6_ = g_str_has_prefix (start, "..");
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						if (string_get_length (rpath) > root_len) {
							{
								gboolean _tmp7_;
								_tmp7_ = TRUE;
								while (TRUE) {
									char* _tmp8_;
									if (!_tmp7_) {
										if (!(!vala_compiler_ends_with_dir_separator (rpath))) {
											break;
										}
									}
									_tmp7_ = FALSE;
									rpath = (_tmp8_ = string_substring (rpath, (glong) 0, string_get_length (rpath) - 1), _g_free0 (rpath), _tmp8_);
								}
							}
						}
					} else {
						char* _tmp10_;
						char* _tmp11_;
						if (!vala_compiler_ends_with_dir_separator (rpath)) {
							char* _tmp9_;
							rpath = (_tmp9_ = g_strconcat (rpath, G_DIR_SEPARATOR_S, NULL), _g_free0 (rpath), _tmp9_);
						}
						rpath = (_tmp11_ = g_strconcat (rpath, _tmp10_ = string_substring (start, (glong) 0, len), NULL), _g_free0 (rpath), _tmp11_);
						_g_free0 (_tmp10_);
					}
				}
			}
		}
	}
	if (string_get_length (rpath) > root_len) {
		_tmp12_ = vala_compiler_ends_with_dir_separator (rpath);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		char* _tmp13_;
		rpath = (_tmp13_ = string_substring (rpath, (glong) 0, string_get_length (rpath) - 1), _g_free0 (rpath), _tmp13_);
	}
	if (G_DIR_SEPARATOR != '/') {
		gint components_length1;
		gint _components_size_;
		char** _tmp15_;
		char** _tmp14_;
		char** components;
		char* _tmp16_;
		components = (_tmp15_ = _tmp14_ = g_strsplit (rpath, "\\", 0), components_length1 = _vala_array_length (_tmp14_), _components_size_ = components_length1, _tmp15_);
		rpath = (_tmp16_ = g_strjoinv ("/", components), _g_free0 (rpath), _tmp16_);
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _lambda0_ (GPid pid, gint status, Block1Data* _data1_) {
	_data1_->child_status = (status & 0xff00) >> 8;
	g_main_loop_quit (_data1_->loop);
}


static void __lambda0__gchild_watch_func (GPid pid, gint status, gpointer self) {
	_lambda0_ (pid, status, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gint vala_compiler_run_source (char** args, int args_length1) {
	gint result = 0;
	gint i;
	gboolean _tmp0_ = FALSE;
	char** _tmp2_ = NULL;
	char** _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	gint outputfd;
	ValaCompiler* compiler;
	gint ret;
	gint target_args_length1;
	gint _target_args_size_;
	char** _tmp7_;
	char** _tmp6_ = NULL;
	char** target_args;
	GError * _inner_error_ = NULL;
	i = 1;
	if (args[i] != NULL) {
		_tmp0_ = g_str_has_prefix (args[i], "-");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			gint compile_args_length1;
			gint _compile_args_size_;
			char** compile_args;
			char* _tmp1_;
			GOptionContext* opt_context;
			compile_args = (compile_args_length1 = 0, NULL);
			g_shell_parse_argv (_tmp1_ = g_strconcat ("valac ", args[1], NULL), &compile_args_length1, &compile_args, &_inner_error_);
			_g_free0 (_tmp1_);
			if (_inner_error_ != NULL) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch1_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch1_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			opt_context = g_option_context_new ("- Vala");
			g_option_context_set_help_enabled (opt_context, TRUE);
			g_option_context_add_main_entries (opt_context, VALA_COMPILER_options, NULL);
			g_option_context_parse (opt_context, &compile_args_length1, &compile_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch1_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch1_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_g_shell_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stdout, "%s\n", e->message);
				result = 1;
				_g_error_free0 (e);
				return result;
			}
		}
		goto __finally1;
		__catch1_g_option_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stdout, "%s\n", e->message);
				fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
				result = 1;
				_g_error_free0 (e);
				return result;
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		i++;
	}
	if (args[i] == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	vala_compiler_sources = (_tmp3_ = (_tmp2_ = g_new0 (char*, 1 + 1), _tmp2_[0] = g_strdup (args[i]), _tmp2_), vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL), _tmp3_);
	vala_compiler_output = (_tmp5_ = g_strdup_printf ("%s/%s.XXXXXX", g_get_tmp_dir (), _tmp4_ = g_path_get_basename (args[i])), _g_free0 (vala_compiler_output), _tmp5_);
	_g_free0 (_tmp4_);
	outputfd = g_mkstemp (vala_compiler_output);
	if (outputfd < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	compiler = vala_compiler_new ();
	ret = vala_compiler_run (compiler);
	if (ret != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	close (outputfd);
	if (g_chmod (vala_compiler_output, 0700) != 0) {
		g_unlink (vala_compiler_output);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	target_args = (_tmp7_ = (_tmp6_ = g_new0 (char*, 1 + 1), _tmp6_[0] = g_strdup (vala_compiler_output), _tmp6_), target_args_length1 = 1, _target_args_size_ = target_args_length1, _tmp7_);
	while (TRUE) {
		if (!(i < args_length1)) {
			break;
		}
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, g_strdup (args[i]));
		i++;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->loop = g_main_loop_new (NULL, FALSE);
		_data1_->child_status = 0;
		g_spawn_async (NULL, target_args, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &pid, &_inner_error_);
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch2_g_spawn_error;
			}
			block1_data_unref (_data1_);
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		g_unlink (vala_compiler_output);
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, __lambda0__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		g_main_loop_run (_data1_->loop);
		result = _data1_->child_status;
		block1_data_unref (_data1_);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally2;
	__catch2_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			result = 1;
			_g_error_free0 (e);
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			return result;
		}
	}
	__finally2:
	{
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
}


static gint vala_compiler_main (char** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	char* _tmp1_;
	gboolean _tmp2_;
	ValaCompiler* compiler;
	GError * _inner_error_ = NULL;
	if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = g_path_get_basename (args[0]), "vala") == 0, _g_free0 (_tmp1_), _tmp2_)) {
		_tmp0_ = TRUE;
	} else {
		char* _tmp3_;
		_tmp0_ = _vala_strcmp0 (_tmp3_ = g_path_get_basename (args[0]), "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp3_);
	}
	if (_tmp0_) {
		result = vala_compiler_run_source (args, args_length1);
		return result;
	}
	{
		GOptionContext* opt_context;
		opt_context = g_option_context_new ("- Vala Compiler");
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, VALA_COMPILER_options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_compiler_version) {
		fprintf (stdout, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	if (vala_compiler_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	compiler = vala_compiler_new ();
	result = vala_compiler_run (compiler);
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = VALA_COMPILER (obj);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




