/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valagee.h>


#define VALA_TYPE_GIR_WRITER (vala_gir_writer_get_type ())
#define VALA_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriter))
#define VALA_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))
#define VALA_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_WRITER))
#define VALA_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_WRITER))
#define VALA_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))

typedef struct _ValaGIRWriter ValaGIRWriter;
typedef struct _ValaGIRWriterClass ValaGIRWriterClass;
typedef struct _ValaGIRWriterPrivate ValaGIRWriterPrivate;

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))

struct _ValaGIRWriter {
	ValaCodeVisitor parent_instance;
	ValaGIRWriterPrivate * priv;
};

struct _ValaGIRWriterClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIRWriterGIRNamespace {
	char* ns;
	char* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	char* directory;
	char* gir_namespace;
	char* gir_version;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaArrayList* externals;
	gint enum_value;
};


static gpointer vala_gir_writer_parent_class = NULL;

GType vala_gir_writer_get_type (void) G_GNUC_CONST;
static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
#define VALA_GIR_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_WRITER, ValaGIRWriterPrivate))
enum  {
	VALA_GIR_WRITER_DUMMY_PROPERTY
};
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g);
void vala_gir_writer_write_includes (ValaGIRWriter* self);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const char* directory, const char* gir_namespace, const char* gir_version, const char* package);
static void vala_gir_writer_write_package (ValaGIRWriter* self, const char* package);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const char* name);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol);
static char* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const char* suffix);
static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const char* tag_name, gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static char* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const char* name, ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, const char* tag, gint* index, gboolean has_array_length, const char* name, ValaParameterDirection direction, gboolean constructor);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, gboolean constructor, ValaDataType* instance_type, gboolean user_data);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const char* tag_name, gboolean instance, const char* name, const char* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static char* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const char* name);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const char* ns, const char* version);
ValaGIRWriter* vala_gir_writer_new (void);
ValaGIRWriter* vala_gir_writer_construct (GType object_type);
static void vala_gir_writer_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



void vala_gir_writer_write_includes (ValaGIRWriter* self) {
	g_return_if_fail (self != NULL);
	{
		ValaIterator* _i_it;
		_i_it = vala_iterable_iterator ((ValaIterable*) self->priv->externals);
		while (TRUE) {
			ValaGIRWriterGIRNamespace* i;
			if (!vala_iterator_next (_i_it)) {
				break;
			}
			i = (ValaGIRWriterGIRNamespace*) vala_iterator_get (_i_it);
			vala_gir_writer_write_indent_stream (self);
			fprintf (self->priv->stream, "<include name=\"%s\" version=\"%s\"/>\n", (*i).ns, (*i).version);
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_collection_object_unref0 (_i_it);
	}
}


/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context  a code context
 * @param filename a relative or absolute filename
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const char* directory, const char* gir_namespace, const char* gir_version, const char* package) {
	ValaCodeContext* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	ValaNamespace* root_symbol;
	ValaSymbol* glib_ns;
	ValaTypeSymbol* _tmp4_;
	char* filename;
	FILE* _tmp5_;
	FILE* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	self->priv->context = (_tmp0_ = _vala_code_context_ref0 (context), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	self->priv->directory = (_tmp1_ = g_strdup (directory), _g_free0 (self->priv->directory), _tmp1_);
	self->priv->gir_namespace = (_tmp2_ = g_strdup (gir_namespace), _g_free0 (self->priv->gir_namespace), _tmp2_);
	self->priv->gir_version = (_tmp3_ = g_strdup (gir_version), _g_free0 (self->priv->gir_version), _tmp3_);
	root_symbol = _vala_code_node_ref0 (vala_code_context_get_root (context));
	glib_ns = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "GLib");
	self->priv->gobject_type = (_tmp4_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), _vala_code_node_unref0 (self->priv->gobject_type), _tmp4_);
	vala_gir_writer_write_package (self, package);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	self->priv->indent--;
	g_string_append_printf (self->priv->buffer, "</repository>\n");
	filename = g_strdup_printf ("%s%c%s-%s.gir", directory, (gint) G_DIR_SEPARATOR, gir_namespace, gir_version);
	self->priv->stream = (_tmp5_ = fopen (filename, "w"), _fclose0 (self->priv->stream), _tmp5_);
	if (self->priv->stream == NULL) {
		char* _tmp6_;
		vala_report_error (NULL, _tmp6_ = g_strdup_printf ("unable to open `%s' for writing", filename));
		_g_free0 (_tmp6_);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	fprintf (self->priv->stream, "<?xml version=\"1.0\"?>\n");
	fprintf (self->priv->stream, "<repository version=\"1.2\"");
	fprintf (self->priv->stream, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	fprintf (self->priv->stream, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	fprintf (self->priv->stream, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	fprintf (self->priv->stream, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_includes (self);
	self->priv->indent--;
	fputs (self->priv->buffer->str, self->priv->stream);
	self->priv->stream = (_tmp7_ = NULL, _fclose0 (self->priv->stream), _tmp7_);
	{
		ValaIterator* _ns_it;
		_ns_it = vala_iterable_iterator ((ValaIterable*) self->priv->unannotated_namespaces);
		while (TRUE) {
			ValaNamespace* ns;
			if (!vala_iterator_next (_ns_it)) {
				break;
			}
			ns = (ValaNamespace*) vala_iterator_get (_ns_it);
			if (!vala_collection_contains ((ValaCollection*) self->priv->our_namespaces, ns)) {
				char* _tmp8_;
				vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) ns), _tmp8_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", vala_symbol_get_name ((ValaSymbol*) ns)));
				_g_free0 (_tmp8_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_collection_object_unref0 (_ns_it);
	}
	{
		ValaIterator* _ns_it;
		_ns_it = vala_iterable_iterator ((ValaIterable*) self->priv->our_namespaces);
		while (TRUE) {
			ValaNamespace* ns;
			if (!vala_iterator_next (_ns_it)) {
				break;
			}
			ns = (ValaNamespace*) vala_iterator_get (_ns_it);
			vala_source_file_set_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns)), gir_namespace);
			vala_source_file_set_gir_version (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns)), gir_version);
			_vala_code_node_unref0 (ns);
		}
		_vala_collection_object_unref0 (_ns_it);
	}
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}


static void vala_gir_writer_write_package (ValaGIRWriter* self, const char* package) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<package name=\"%s\"/>\n", package);
}


static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns) {
	ValaSet* header_filenames;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	header_filenames = (ValaSet*) vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _c_header_filename_it;
		_c_header_filename_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_symbol_get_cheader_filenames ((ValaSymbol*) ns))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			char* c_header_filename;
			if (!vala_iterator_next (_c_header_filename_it)) {
				break;
			}
			c_header_filename = (char*) vala_iterator_get (_c_header_filename_it);
			vala_collection_add ((ValaCollection*) header_filenames, c_header_filename);
			_g_free0 (c_header_filename);
		}
		_vala_collection_object_unref0 (_c_header_filename_it);
	}
	{
		ValaMap* _tmp2_;
		ValaCollection* _tmp3_;
		ValaIterator* _tmp4_;
		ValaIterator* _symbol_it;
		_symbol_it = (_tmp4_ = vala_iterable_iterator ((ValaIterable*) (_tmp3_ = vala_map_get_values (_tmp2_ = vala_scope_get_symbol_table (vala_symbol_get_scope ((ValaSymbol*) ns))))), _vala_collection_object_unref0 (_tmp3_), _vala_collection_object_unref0 (_tmp2_), _tmp4_);
		while (TRUE) {
			ValaSymbol* symbol;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = (ValaSymbol*) vala_iterator_get (_symbol_it);
			{
				ValaList* _tmp5_;
				ValaIterator* _tmp6_;
				ValaIterator* _c_header_filename_it;
				_c_header_filename_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vala_symbol_get_cheader_filenames (symbol))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
				while (TRUE) {
					char* c_header_filename;
					if (!vala_iterator_next (_c_header_filename_it)) {
						break;
					}
					c_header_filename = (char*) vala_iterator_get (_c_header_filename_it);
					vala_collection_add ((ValaCollection*) header_filenames, c_header_filename);
					_g_free0 (c_header_filename);
				}
				_vala_collection_object_unref0 (_c_header_filename_it);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
	{
		ValaIterator* _c_header_filename_it;
		_c_header_filename_it = vala_iterable_iterator ((ValaIterable*) header_filenames);
		while (TRUE) {
			char* c_header_filename;
			if (!vala_iterator_next (_c_header_filename_it)) {
				break;
			}
			c_header_filename = (char*) vala_iterator_get (_c_header_filename_it);
			vala_gir_writer_write_c_include (self, c_header_filename);
			_g_free0 (c_header_filename);
		}
		_vala_collection_object_unref0 (_c_header_filename_it);
	}
	_vala_collection_object_unref0 (header_filenames);
}


static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const char* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<c:include name=\"%s\"/>\n", name);
}


static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIRWriter * self;
	char* cprefix;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) ns)) {
		return;
	}
	if (vala_symbol_get_name ((ValaSymbol*) ns) == NULL) {
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		return;
	}
	if (vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) ns)) != NULL) {
		return;
	}
	vala_gir_writer_write_c_includes (self, ns);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<namespace name=\"%s\" version=\"%s\"", self->priv->gir_namespace, self->priv->gir_version);
	cprefix = vala_symbol_get_cprefix ((ValaSymbol*) ns);
	if (cprefix != NULL) {
		g_string_append_printf (self->priv->buffer, " c:prefix=\"%s\"", cprefix);
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) ns);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</namespace>\n");
	vala_collection_add ((ValaCollection*) self->priv->our_namespaces, ns);
	_g_free0 (cprefix);
}


static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIRWriter * self;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) cl)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) cl)) {
		return;
	}
	if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, self->priv->gobject_type)) {
		char* gtype_struct_name;
		char* _tmp0_;
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		char* _tmp8_;
		char* _tmp14_;
		gtype_struct_name = g_strconcat (vala_symbol_get_name ((ValaSymbol*) cl), "Class", NULL);
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<class name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) cl));
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) cl);
		g_string_append_printf (self->priv->buffer, " glib:type-struct=\"%s\"", gtype_struct_name);
		g_string_append_printf (self->priv->buffer, " parent=\"%s\"", _tmp0_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) vala_class_get_base_class (cl)));
		_g_free0 (_tmp0_);
		if (vala_class_get_is_abstract (cl)) {
			g_string_append_printf (self->priv->buffer, " abstract=\"1\"");
		}
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		{
			ValaList* _tmp1_;
			ValaIterator* _tmp2_;
			ValaIterator* _base_type_it;
			_base_type_it = (_tmp2_ = vala_iterable_iterator ((ValaIterable*) (_tmp1_ = vala_class_get_base_types (cl))), _vala_collection_object_unref0 (_tmp1_), _tmp2_);
			while (TRUE) {
				ValaDataType* base_type;
				ValaObjectType* object_type;
				if (!vala_iterator_next (_base_type_it)) {
					break;
				}
				base_type = (ValaDataType*) vala_iterator_get (_base_type_it);
				object_type = _vala_code_node_ref0 (VALA_OBJECT_TYPE (base_type));
				if (VALA_IS_INTERFACE (vala_object_type_get_type_symbol (object_type))) {
					char* _tmp3_;
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "<implements name=\"%s\"/>\n", _tmp3_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) vala_object_type_get_type_symbol (object_type)));
					_g_free0 (_tmp3_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_collection_object_unref0 (_base_type_it);
		}
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) cl);
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<field name=\"parent_instance\">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp4_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) vala_class_get_base_class (cl)), _tmp5_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_class_get_base_class (cl), FALSE));
		_g_free0 (_tmp5_);
		_g_free0 (_tmp4_);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</field>\n");
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<field name=\"priv\">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", vala_symbol_get_name ((ValaSymbol*) cl), _tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE));
		_g_free0 (_tmp6_);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</field>\n");
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</class>\n");
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", gtype_struct_name);
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) cl, "Class");
		g_string_append_printf (self->priv->buffer, " glib:is-gtype-struct-for=\"%s\"", vala_symbol_get_name ((ValaSymbol*) cl));
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<field name=\"parent_class\">\n");
		self->priv->indent++;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp7_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) vala_class_get_base_class (cl)), _tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_class_get_base_class (cl), FALSE));
		_g_free0 (_tmp8_);
		_g_free0 (_tmp7_);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</field>\n");
		{
			ValaList* _tmp9_;
			ValaIterator* _tmp10_;
			ValaIterator* _m_it;
			_m_it = (_tmp10_ = vala_iterable_iterator ((ValaIterable*) (_tmp9_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl))), _vala_collection_object_unref0 (_tmp9_), _tmp10_);
			while (TRUE) {
				ValaMethod* m;
				gboolean _tmp11_ = FALSE;
				if (!vala_iterator_next (_m_it)) {
					break;
				}
				m = (ValaMethod*) vala_iterator_get (_m_it);
				if (vala_method_get_is_abstract (m)) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = vala_method_get_is_virtual (m);
				}
				if (_tmp11_) {
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "<field name=\"%s\">\n", vala_symbol_get_name ((ValaSymbol*) m));
					self->priv->indent++;
					vala_gir_writer_write_signature (self, m, "callback", TRUE);
					self->priv->indent--;
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "</field>\n");
				}
				_vala_code_node_unref0 (m);
			}
			_vala_collection_object_unref0 (_m_it);
		}
		{
			ValaList* _tmp12_;
			ValaIterator* _tmp13_;
			ValaIterator* _sig_it;
			_sig_it = (_tmp13_ = vala_iterable_iterator ((ValaIterable*) (_tmp12_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl))), _vala_collection_object_unref0 (_tmp12_), _tmp13_);
			while (TRUE) {
				ValaSignal* sig;
				if (!vala_iterator_next (_sig_it)) {
					break;
				}
				sig = (ValaSignal*) vala_iterator_get (_sig_it);
				if (vala_signal_get_default_handler (sig) != NULL) {
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "<field name=\"%s\">\n", vala_symbol_get_name ((ValaSymbol*) sig));
					self->priv->indent++;
					vala_gir_writer_write_signature (self, vala_signal_get_default_handler (sig), "callback", TRUE);
					self->priv->indent--;
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_collection_object_unref0 (_sig_it);
		}
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</record>\n");
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", vala_symbol_get_name ((ValaSymbol*) cl), _tmp14_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE));
		_g_free0 (_tmp14_);
		_g_free0 (gtype_struct_name);
	} else {
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) cl));
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</record>\n");
	}
}


static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIRWriter * self;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) st)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) st)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) st));
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) st);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</record>\n");
}


static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIRWriter * self;
	char* gtype_struct_name;
	ValaList* _tmp0_;
	gboolean _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) iface)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) iface)) {
		return;
	}
	gtype_struct_name = g_strconcat (vala_symbol_get_name ((ValaSymbol*) iface), "Iface", NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<interface name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) iface));
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) iface);
	g_string_append_printf (self->priv->buffer, " glib:type-struct=\"%s\"", gtype_struct_name);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	if ((_tmp1_ = vala_collection_get_size ((ValaCollection*) (_tmp0_ = vala_interface_get_prerequisites (iface))) > 0, _vala_collection_object_unref0 (_tmp0_), _tmp1_)) {
		{
			ValaList* _tmp2_;
			ValaIterator* _tmp3_;
			ValaIterator* _base_type_it;
			_base_type_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vala_interface_get_prerequisites (iface))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
			while (TRUE) {
				ValaDataType* base_type;
				char* _tmp4_;
				if (!vala_iterator_next (_base_type_it)) {
					break;
				}
				base_type = (ValaDataType*) vala_iterator_get (_base_type_it);
				vala_gir_writer_write_indent (self);
				g_string_append_printf (self->priv->buffer, "<prerequisite name=\"%s\"/>\n", _tmp4_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (base_type))));
				_g_free0 (_tmp4_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_collection_object_unref0 (_base_type_it);
		}
	}
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) iface);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</interface>\n");
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<record name=\"%s\"", gtype_struct_name);
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) iface, "Iface");
	g_string_append_printf (self->priv->buffer, " glib:is-gtype-struct-for=\"%s\"", vala_symbol_get_name ((ValaSymbol*) iface));
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	{
		ValaList* _tmp5_;
		ValaIterator* _tmp6_;
		ValaIterator* _m_it;
		_m_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
		while (TRUE) {
			ValaMethod* m;
			gboolean _tmp7_ = FALSE;
			if (!vala_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) vala_iterator_get (_m_it);
			if (vala_method_get_is_abstract (m)) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = vala_method_get_is_virtual (m);
			}
			if (_tmp7_) {
				vala_gir_writer_write_signature (self, m, "callback", TRUE);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_collection_object_unref0 (_m_it);
	}
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</record>\n");
	_g_free0 (gtype_struct_name);
}


static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIRWriter * self;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) en)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) en)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<enumeration name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) en));
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) en);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) en);
	self->priv->enum_value = 0;
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</enumeration>\n");
}


static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaGIRWriter * self;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<member name=\"%s\" c:identifier=\"%s\"", _tmp0_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) ev), -1), _tmp1_ = vala_constant_get_cname ((ValaConstant*) ev));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	if (vala_constant_get_value ((ValaConstant*) ev) != NULL) {
		char* value;
		value = vala_gir_writer_literal_expression_to_value_string (self, vala_constant_get_value ((ValaConstant*) ev));
		g_string_append_printf (self->priv->buffer, " value=\"%s\"", value);
		_g_free0 (value);
	} else {
		g_string_append_printf (self->priv->buffer, " value=\"%d\"", self->priv->enum_value++);
	}
	g_string_append_printf (self->priv->buffer, "/>\n");
}


static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGIRWriter * self;
	char* _tmp0_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) edomain)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) edomain)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<errordomain name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) edomain));
	g_string_append_printf (self->priv->buffer, " get-quark=\"%squark\"", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain));
	_g_free0 (_tmp0_);
	g_string_append_printf (self->priv->buffer, " codes=\"%s\"", vala_symbol_get_name ((ValaSymbol*) edomain));
	g_string_append_printf (self->priv->buffer, ">\n");
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) edomain);
	g_string_append_printf (self->priv->buffer, "</errordomain>\n");
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<enumeration name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) edomain));
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) edomain, "");
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	self->priv->enum_value = 0;
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</enumeration>\n");
}


static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaGIRWriter * self;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<member name=\"%s\" c:identifier=\"%s\"", _tmp0_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) ecode), -1), _tmp1_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	if (vala_error_code_get_value (ecode) != NULL) {
		char* value;
		value = vala_gir_writer_literal_expression_to_value_string (self, vala_error_code_get_value (ecode));
		g_string_append_printf (self->priv->buffer, " value=\"%s\"", value);
		_g_free0 (value);
	} else {
		g_string_append_printf (self->priv->buffer, " value=\"%d\"", self->priv->enum_value++);
	}
	g_string_append_printf (self->priv->buffer, "/>\n");
}


static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaGIRWriter * self;
	ValaExpression* initializer;
	char* value;
	char* _tmp0_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) c)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) c)) {
		return;
	}
	initializer = _vala_code_node_ref0 (vala_constant_get_value (c));
	value = vala_gir_writer_literal_expression_to_value_string (self, initializer);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<constant name=\"%s\" c:identifier=\"%s\"", vala_symbol_get_name ((ValaSymbol*) c), _tmp0_ = vala_constant_get_cname (c));
	_g_free0 (_tmp0_);
	g_string_append_printf (self->priv->buffer, " value=\"%s\"", value);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_type (self, vala_expression_get_value_type (initializer), -1);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}


static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGIRWriter * self;
	char* _tmp0_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) f)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) f)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<field name=\"%s\"", _tmp0_ = vala_field_get_cname (f));
	_g_free0 (_tmp0_);
	if (vala_data_type_get_nullable (vala_variable_get_variable_type ((ValaVariable*) f))) {
		g_string_append_printf (self->priv->buffer, " allow-none=\"1\"");
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) f);
	vala_gir_writer_write_type (self, vala_variable_get_variable_type ((ValaVariable*) f), -1);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</field>\n");
}


static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const char* name, ValaParameterDirection direction) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		_tmp0_ = has_array_length;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeContext* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaStruct* _tmp3_;
		ValaIntegerType* _tmp4_;
		ValaIntegerType* int_type;
		char* _tmp5_;
		int_type = (_tmp4_ = vala_integer_type_new (_tmp3_ = (_tmp2_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (_tmp1_ = vala_code_context_get ())), "int"), VALA_IS_STRUCT (_tmp2_) ? ((ValaStruct*) _tmp2_) : NULL), NULL, NULL), _vala_code_node_unref0 (_tmp3_), _vala_code_context_unref0 (_tmp1_), _tmp4_);
		vala_gir_writer_write_param_or_return (self, (ValaDataType*) int_type, "parameter", index, has_array_length, _tmp5_ = g_strdup_printf ("%s_length1", name), direction, FALSE);
		_g_free0 (_tmp5_);
		_vala_code_node_unref0 (int_type);
	} else {
		if (VALA_IS_DELEGATE_TYPE (type)) {
			ValaVoidType* _tmp6_;
			ValaPointerType* _tmp7_;
			ValaPointerType* data_type;
			char* _tmp8_;
			data_type = (_tmp7_ = vala_pointer_type_new ((ValaDataType*) (_tmp6_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp6_), _tmp7_);
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) data_type, "parameter", index, FALSE, _tmp8_ = g_strdup_printf ("%s_target", name), direction, FALSE);
			_g_free0 (_tmp8_);
			if (vala_data_type_get_value_owned (type)) {
				ValaCodeContext* _tmp9_;
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				ValaDelegate* _tmp12_;
				ValaDelegateType* _tmp13_;
				ValaDelegateType* notify_type;
				char* _tmp14_;
				notify_type = (_tmp13_ = vala_delegate_type_new (_tmp12_ = (_tmp11_ = vala_scope_lookup (vala_symbol_get_scope (_tmp10_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (_tmp9_ = vala_code_context_get ())), "GLib")), "DestroyNotify"), VALA_IS_DELEGATE (_tmp11_) ? ((ValaDelegate*) _tmp11_) : NULL)), _vala_code_node_unref0 (_tmp12_), _vala_code_node_unref0 (_tmp10_), _vala_code_context_unref0 (_tmp9_), _tmp13_);
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) notify_type, "parameter", index, FALSE, _tmp14_ = g_strdup_printf ("%s_target_destroy_notify", name), direction, FALSE);
				_g_free0 (_tmp14_);
				_vala_code_node_unref0 (notify_type);
			}
			_vala_code_node_unref0 (data_type);
		}
	}
}


static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, gboolean constructor, ValaDataType* instance_type, gboolean user_data) {
	gint last_index;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	if (vala_collection_get_size ((ValaCollection*) params) != 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = instance_type != NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (VALA_IS_ARRAY_TYPE (return_type)) {
			_tmp3_ = return_array_length;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_DELEGATE_TYPE (return_type);
	}
	if (_tmp0_) {
		gint index;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<parameters>\n");
		self->priv->indent++;
		index = 1;
		if (instance_type != NULL) {
			vala_gir_writer_write_param_or_return (self, instance_type, "parameter", &index, FALSE, "self", VALA_PARAMETER_DIRECTION_IN, FALSE);
		}
		{
			ValaIterator* _param_it;
			_param_it = vala_iterable_iterator ((ValaIterable*) params);
			while (TRUE) {
				ValaFormalParameter* param;
				if (!vala_iterator_next (_param_it)) {
					break;
				}
				param = (ValaFormalParameter*) vala_iterator_get (_param_it);
				vala_gir_writer_write_param_or_return (self, vala_variable_get_variable_type ((ValaVariable*) param), "parameter", &index, !vala_formal_parameter_get_no_array_length (param), vala_symbol_get_name ((ValaSymbol*) param), vala_formal_parameter_get_direction (param), FALSE);
				vala_gir_writer_write_implicit_params (self, vala_variable_get_variable_type ((ValaVariable*) param), &index, !vala_formal_parameter_get_no_array_length (param), vala_symbol_get_name ((ValaSymbol*) param), vala_formal_parameter_get_direction (param));
				_vala_code_node_unref0 (param);
			}
			_vala_collection_object_unref0 (_param_it);
		}
		last_index = index - 1;
		vala_gir_writer_write_implicit_params (self, return_type, &index, return_array_length, "result", VALA_PARAMETER_DIRECTION_OUT);
		if (user_data) {
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", index);
			self->priv->indent++;
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			self->priv->indent--;
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "</parameter>\n");
		}
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</parameters>\n");
	}
	if (return_type != NULL) {
		vala_gir_writer_write_param_or_return (self, return_type, "return-value", &last_index, return_array_length, NULL, VALA_PARAMETER_DIRECTION_IN, constructor);
	}
}


static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaGIRWriter * self;
	char* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) cb)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) cb)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<callback name=\"%s\"", vala_symbol_get_name ((ValaSymbol*) cb));
	g_string_append_printf (self->priv->buffer, " c:type=\"%s\"", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cb, FALSE));
	_g_free0 (_tmp0_);
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) cb)) {
		g_string_append_printf (self->priv->buffer, " throws=\"1\"");
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) cb);
	vala_gir_writer_write_params_and_return (self, _tmp1_ = vala_delegate_get_parameters (cb), vala_delegate_get_return_type (cb), !vala_delegate_get_no_array_length (cb), FALSE, NULL, vala_delegate_get_has_target (cb));
	_vala_collection_object_unref0 (_tmp1_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</callback>\n");
}


static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	char* tag_name;
	ValaSymbol* parent;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) m)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) m)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_method_get_overrides (m);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		if (vala_method_get_base_interface_method (m) != NULL) {
			_tmp3_ = !vala_method_get_is_abstract (m);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = !vala_method_get_is_virtual (m);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	tag_name = g_strdup ("method");
	parent = _vala_code_node_ref0 (vala_symbol_get_parent_symbol ((ValaSymbol*) m));
	if (VALA_IS_NAMESPACE (parent)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_method_get_binding (m) == MEMBER_BINDING_STATIC;
	}
	if (_tmp4_) {
		char* _tmp5_;
		tag_name = (_tmp5_ = g_strdup ("function"), _g_free0 (tag_name), _tmp5_);
	}
	vala_gir_writer_write_signature (self, m, tag_name, FALSE);
	if (vala_method_get_is_abstract (m)) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = vala_method_get_is_virtual (m);
	}
	if (_tmp6_) {
		vala_gir_writer_write_signature (self, m, "virtual-method", FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const char* tag_name, gboolean instance) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	if (vala_method_get_coroutine (m)) {
		char* finish_name;
		char* _tmp1_;
		char* _tmp2_;
		ValaList* _tmp3_;
		ValaVoidType* _tmp4_;
		char* _tmp5_;
		ValaList* _tmp6_;
		finish_name = g_strdup (vala_symbol_get_name ((ValaSymbol*) m));
		if (g_str_has_suffix (finish_name, "_async")) {
			char* _tmp0_;
			finish_name = (_tmp0_ = string_substring (finish_name, (glong) 0, string_get_length (finish_name) - string_get_length ("_async")), _g_free0 (finish_name), _tmp0_);
		}
		finish_name = (_tmp1_ = g_strconcat (finish_name, "_finish", NULL), _g_free0 (finish_name), _tmp1_);
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, vala_symbol_get_name ((ValaSymbol*) m), _tmp2_ = vala_method_get_cname (m), _tmp3_ = vala_method_get_async_begin_parameters (m), (ValaDataType*) (_tmp4_ = vala_void_type_new (NULL)), FALSE);
		_vala_code_node_unref0 (_tmp4_);
		_vala_collection_object_unref0 (_tmp3_);
		_g_free0 (_tmp2_);
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, finish_name, _tmp5_ = vala_method_get_finish_cname (m), _tmp6_ = vala_method_get_async_end_parameters (m), vala_method_get_return_type (m), vala_code_node_get_tree_can_fail ((ValaCodeNode*) m));
		_vala_collection_object_unref0 (_tmp6_);
		_g_free0 (_tmp5_);
		_g_free0 (finish_name);
	} else {
		char* _tmp7_;
		ValaList* _tmp8_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, vala_symbol_get_name ((ValaSymbol*) m), _tmp7_ = vala_method_get_cname (m), _tmp8_ = vala_method_get_parameters (m), vala_method_get_return_type (m), vala_code_node_get_tree_can_fail ((ValaCodeNode*) m));
		_vala_collection_object_unref0 (_tmp8_);
		_g_free0 (_tmp7_);
	}
}


static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const char* tag_name, gboolean instance, const char* name, const char* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail) {
	ValaDataType* instance_type;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<%s name=\"%s\"", tag_name, name);
	if (_vala_strcmp0 (tag_name, "virtual-method") == 0) {
		g_string_append_printf (self->priv->buffer, " invoker=\"%s\"", name);
	} else {
		if (_vala_strcmp0 (tag_name, "callback") == 0) {
			g_string_append_printf (self->priv->buffer, " c:type=\"%s\"", name);
		} else {
			g_string_append_printf (self->priv->buffer, " c:identifier=\"%s\"", cname);
		}
	}
	if (can_fail) {
		g_string_append_printf (self->priv->buffer, " throws=\"1\"");
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) m);
	instance_type = NULL;
	if (instance) {
		ValaDataType* _tmp0_;
		instance_type = (_tmp0_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m))), _vala_code_node_unref0 (instance_type), _tmp0_);
	}
	vala_gir_writer_write_params_and_return (self, params, return_type, !vala_method_get_no_array_length (m), FALSE, instance_type, FALSE);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</%s>\n", tag_name);
	_vala_code_node_unref0 (instance_type);
}


static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaDataType* datatype;
	ValaList* _tmp5_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_get_external_package ((ValaSymbol*) m)) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) m)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		_tmp1_ = VALA_METHOD (m) == vala_class_get_default_construction_method (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
			_tmp2_ = VALA_METHOD (m) == vala_struct_get_default_construction_method (VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		char* _tmp3_;
		g_string_append_printf (self->priv->buffer, "<constructor name=\"new\" c:identifier=\"%s\"", _tmp3_ = vala_method_get_cname ((ValaMethod*) m));
		_g_free0 (_tmp3_);
	} else {
		char* _tmp4_;
		g_string_append_printf (self->priv->buffer, "<constructor name=\"%s\" c:identifier=\"%s\"", vala_symbol_get_name ((ValaSymbol*) m), _tmp4_ = vala_method_get_cname ((ValaMethod*) m));
		_g_free0 (_tmp4_);
	}
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) m)) {
		g_string_append_printf (self->priv->buffer, " throws=\"1\"");
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) m);
	datatype = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
	vala_gir_writer_write_params_and_return (self, _tmp5_ = vala_method_get_parameters ((ValaMethod*) m), datatype, FALSE, TRUE, NULL, FALSE);
	_vala_collection_object_unref0 (_tmp5_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</constructor>\n");
	_vala_code_node_unref0 (datatype);
}


static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	char* _tmp4_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) prop)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_property_get_overrides (prop);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		if (vala_property_get_base_interface_property (prop) != NULL) {
			_tmp3_ = !vala_property_get_is_abstract (prop);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = !vala_property_get_is_virtual (prop);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<property name=\"%s\"", _tmp4_ = vala_property_get_canonical_name (prop));
	_g_free0 (_tmp4_);
	if (vala_property_get_get_accessor (prop) == NULL) {
		g_string_append_printf (self->priv->buffer, " readable=\"0\"");
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		g_string_append_printf (self->priv->buffer, " writable=\"1\"");
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (!vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				g_string_append_printf (self->priv->buffer, " construct-only=\"1\"");
			} else {
				g_string_append_printf (self->priv->buffer, " construct=\"1\"");
			}
		}
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) prop);
	vala_gir_writer_write_type (self, vala_property_get_property_type (prop), -1);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</property>\n");
}


static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGIRWriter * self;
	char* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) sig)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<glib:signal name=\"%s\"", _tmp0_ = vala_signal_get_cname (sig));
	_g_free0 (_tmp0_);
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) sig);
	vala_gir_writer_write_params_and_return (self, _tmp1_ = vala_signal_get_parameters (sig), vala_signal_get_return_type (sig), FALSE, FALSE, NULL, FALSE);
	_vala_collection_object_unref0 (_tmp1_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</glib:signal>\n");
}


static void vala_gir_writer_write_indent (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			g_string_append_c (self->priv->buffer, '\t');
		}
	}
}


static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			fputc ('\t', self->priv->stream);
		}
	}
}


static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, const char* tag, gint* index, gboolean has_array_length, const char* name, ValaParameterDirection direction, gboolean constructor) {
	ValaDataType* _tmp0_;
	ValaDelegateType* delegate_type;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (tag != NULL);
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "<%s", tag);
	if (name != NULL) {
		g_string_append_printf (self->priv->buffer, " name=\"%s\"", name);
	}
	if (direction == VALA_PARAMETER_DIRECTION_REF) {
		g_string_append_printf (self->priv->buffer, " direction=\"inout\"");
	} else {
		if (direction == VALA_PARAMETER_DIRECTION_OUT) {
			g_string_append_printf (self->priv->buffer, " direction=\"out\"");
		}
	}
	delegate_type = _vala_code_node_ref0 ((_tmp0_ = type, VALA_IS_DELEGATE_TYPE (_tmp0_) ? ((ValaDelegateType*) _tmp0_) : NULL));
	if (vala_data_type_get_value_owned (type)) {
		_tmp2_ = delegate_type == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = constructor;
	}
	if (_tmp1_) {
		g_string_append_printf (self->priv->buffer, " transfer-ownership=\"full\"");
	} else {
		g_string_append_printf (self->priv->buffer, " transfer-ownership=\"none\"");
	}
	if (vala_data_type_get_nullable (type)) {
		g_string_append_printf (self->priv->buffer, " allow-none=\"1\"");
	}
	if (delegate_type != NULL) {
		_tmp3_ = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		g_string_append_printf (self->priv->buffer, " closure=\"%i\"", (*index) + 1);
		if (vala_data_type_get_value_owned (type)) {
			g_string_append_printf (self->priv->buffer, " destroy=\"%i\"", (*index) + 2);
		}
	}
	g_string_append_printf (self->priv->buffer, ">\n");
	self->priv->indent++;
	if (has_array_length) {
		_tmp4_ = *index;
	} else {
		_tmp4_ = -1;
	}
	vala_gir_writer_write_type (self, type, _tmp4_);
	self->priv->indent--;
	vala_gir_writer_write_indent (self);
	g_string_append_printf (self->priv->buffer, "</%s>\n", tag);
	(*index)++;
	_vala_code_node_unref0 (delegate_type);
}


static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const char* suffix) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	g_string_append_printf (self->priv->buffer, " c:type=\"%s%s\"", _tmp0_ = vala_typesymbol_get_cname (symbol, FALSE), suffix);
	_g_free0 (_tmp0_);
}


static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	vala_gir_writer_write_ctype_attributes (self, symbol, "");
	g_string_append_printf (self->priv->buffer, " glib:type-name=\"%s\"", _tmp0_ = vala_typesymbol_get_cname (symbol, FALSE));
	_g_free0 (_tmp0_);
	g_string_append_printf (self->priv->buffer, " glib:get-type=\"%sget_type\"", _tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) symbol));
	_g_free0 (_tmp1_);
}


static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		ValaArrayType* array_type;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (type));
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "<array");
		if (vala_array_type_get_fixed_length (array_type)) {
			g_string_append_printf (self->priv->buffer, " fixed-length\"%i\"", vala_array_type_get_length (array_type));
		} else {
			if (index != (-1)) {
				g_string_append_printf (self->priv->buffer, " length=\"%i\"", index + 1);
			}
		}
		g_string_append_printf (self->priv->buffer, ">\n");
		self->priv->indent++;
		vala_gir_writer_write_type (self, vala_array_type_get_element_type (array_type), -1);
		self->priv->indent--;
		vala_gir_writer_write_indent (self);
		g_string_append_printf (self->priv->buffer, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		if (VALA_IS_VOID_TYPE (type)) {
			vala_gir_writer_write_indent (self);
			g_string_append_printf (self->priv->buffer, "<type name=\"none\"/>\n");
		} else {
			if (VALA_IS_POINTER_TYPE (type)) {
				char* _tmp0_;
				vala_gir_writer_write_indent (self);
				g_string_append_printf (self->priv->buffer, "<type name=\"gpointer\" c:type=\"%s\"/>\n", _tmp0_ = vala_data_type_get_cname (type));
				_g_free0 (_tmp0_);
			} else {
				if (vala_data_type_get_data_type (type) != NULL) {
					char* _tmp1_;
					char* _tmp2_;
					ValaList* type_arguments;
					vala_gir_writer_write_indent (self);
					g_string_append_printf (self->priv->buffer, "<type name=\"%s\" c:type=\"%s\"", _tmp1_ = vala_gir_writer_gi_type_name (self, vala_data_type_get_data_type (type)), _tmp2_ = vala_data_type_get_cname (type));
					_g_free0 (_tmp2_);
					_g_free0 (_tmp1_);
					type_arguments = vala_data_type_get_type_arguments (type);
					if (vala_collection_get_size ((ValaCollection*) type_arguments) == 0) {
						g_string_append_printf (self->priv->buffer, "/>\n");
					} else {
						g_string_append_printf (self->priv->buffer, ">\n");
						self->priv->indent++;
						{
							ValaIterator* _type_argument_it;
							_type_argument_it = vala_iterable_iterator ((ValaIterable*) type_arguments);
							while (TRUE) {
								ValaDataType* type_argument;
								if (!vala_iterator_next (_type_argument_it)) {
									break;
								}
								type_argument = (ValaDataType*) vala_iterator_get (_type_argument_it);
								vala_gir_writer_write_type (self, type_argument, -1);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_collection_object_unref0 (_type_argument_it);
						}
						self->priv->indent--;
						vala_gir_writer_write_indent (self);
						g_string_append_printf (self->priv->buffer, "</type>\n");
					}
					_vala_collection_object_unref0 (type_arguments);
				} else {
					if (VALA_IS_DELEGATE_TYPE (type)) {
						ValaDelegateType* deleg_type;
						char* _tmp3_;
						char* _tmp4_;
						deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (type));
						vala_gir_writer_write_indent (self);
						g_string_append_printf (self->priv->buffer, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp3_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) vala_delegate_type_get_delegate_symbol (deleg_type)), _tmp4_ = vala_data_type_get_cname (type));
						_g_free0 (_tmp4_);
						_g_free0 (_tmp3_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						if (VALA_IS_GENERIC_TYPE (type)) {
							vala_gir_writer_write_indent (self);
							g_string_append (self->priv->buffer, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							char* _tmp5_;
							vala_gir_writer_write_indent (self);
							g_string_append_printf (self->priv->buffer, "<type name=\"%s\"/>\n", _tmp5_ = vala_code_node_to_string ((ValaCodeNode*) type));
							_g_free0 (_tmp5_);
						}
					}
				}
			}
		}
	}
}


static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	{
		GList* attr_collection;
		GList* attr_it;
		attr_collection = node->attributes;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			ValaAttribute* attr;
			attr = _vala_code_node_ref0 ((ValaAttribute*) attr_it->data);
			{
				char* name;
				name = vala_gir_writer_camel_case_to_canonical (self, vala_attribute_get_name (attr));
				{
					ValaSet* _tmp0_;
					ValaIterator* _tmp1_;
					ValaIterator* _arg_name_it;
					_arg_name_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_map_get_keys (attr->args))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
					while (TRUE) {
						char* arg_name;
						ValaExpression* arg;
						char* value;
						if (!vala_iterator_next (_arg_name_it)) {
							break;
						}
						arg_name = (char*) vala_iterator_get (_arg_name_it);
						arg = (ValaExpression*) vala_map_get (attr->args, arg_name);
						value = vala_gir_writer_literal_expression_to_value_string (self, (ValaExpression*) VALA_LITERAL (arg));
						if (value != NULL) {
							char* _tmp2_;
							vala_gir_writer_write_indent (self);
							g_string_append_printf (self->priv->buffer, "<annotation key=\"%s.%s\" value=\"%s\"/>\n", name, _tmp2_ = vala_gir_writer_camel_case_to_canonical (self, arg_name), value);
							_g_free0 (_tmp2_);
						}
						_g_free0 (value);
						_vala_code_node_unref0 (arg);
						_g_free0 (arg_name);
					}
					_vala_collection_object_unref0 (_arg_name_it);
				}
				_g_free0 (name);
				_vala_code_node_unref0 (attr);
			}
		}
	}
}


static char* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol) {
	char* result = NULL;
	ValaSymbol* parent;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	parent = _vala_code_node_ref0 (vala_symbol_get_parent_symbol ((ValaSymbol*) type_symbol));
	if (VALA_IS_NAMESPACE (parent)) {
		ValaSymbol* _tmp0_;
		ValaNamespace* ns;
		ns = _vala_code_node_ref0 ((_tmp0_ = parent, VALA_IS_NAMESPACE (_tmp0_) ? ((ValaNamespace*) _tmp0_) : NULL));
		if (vala_symbol_get_gir_name ((ValaSymbol*) ns) != NULL) {
			if (vala_source_file_get_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol))) != NULL) {
				ValaGIRWriterGIRNamespace external = {0};
				vala_gir_writer_gir_namespace_init (&external, vala_source_file_get_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol))), vala_source_file_get_gir_version (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol))));
				if (!vala_collection_contains ((ValaCollection*) self->priv->externals, &external)) {
					vala_collection_add ((ValaCollection*) self->priv->externals, &external);
				}
				result = g_strdup_printf ("%s.%s", vala_source_file_get_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol))), vala_symbol_get_gir_name ((ValaSymbol*) type_symbol));
				vala_gir_writer_gir_namespace_destroy (&external);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				vala_collection_add ((ValaCollection*) self->priv->unannotated_namespaces, ns);
			}
		}
		_vala_code_node_unref0 (ns);
	}
	result = vala_symbol_get_full_gir_name ((ValaSymbol*) type_symbol);
	_vala_code_node_unref0 (parent);
	return result;
}


static char* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	if (VALA_IS_STRING_LITERAL (literal)) {
		ValaExpression* _tmp0_;
		ValaStringLiteral* lit;
		lit = _vala_code_node_ref0 ((_tmp0_ = literal, VALA_IS_STRING_LITERAL (_tmp0_) ? ((ValaStringLiteral*) _tmp0_) : NULL));
		if (lit != NULL) {
			char* _tmp1_;
			char* _tmp2_;
			result = (_tmp2_ = g_markup_escape_text (_tmp1_ = vala_string_literal_eval (lit), -1), _g_free0 (_tmp1_), _tmp2_);
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		if (VALA_IS_CHARACTER_LITERAL (literal)) {
			result = g_strdup_printf ("%c", (gint) ((gchar) vala_character_literal_get_char (VALA_CHARACTER_LITERAL (literal))));
			return result;
		} else {
			if (VALA_IS_BOOLEAN_LITERAL (literal)) {
				const char* _tmp3_;
				_tmp3_ = NULL;
				if (vala_boolean_literal_get_value (VALA_BOOLEAN_LITERAL (literal))) {
					_tmp3_ = "true";
				} else {
					_tmp3_ = "false";
				}
				result = g_strdup (_tmp3_);
				return result;
			} else {
				if (VALA_IS_REAL_LITERAL (literal)) {
					result = g_strdup (vala_real_literal_get_value (VALA_REAL_LITERAL (literal)));
					return result;
				} else {
					if (VALA_IS_INTEGER_LITERAL (literal)) {
						result = g_strdup (vala_integer_literal_get_value (VALA_INTEGER_LITERAL (literal)));
						return result;
					} else {
						if (VALA_IS_UNARY_EXPRESSION (literal)) {
							ValaUnaryExpression* unary;
							unary = _vala_code_node_ref0 (VALA_UNARY_EXPRESSION (literal));
							if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_MINUS) {
								if (VALA_IS_REAL_LITERAL (vala_unary_expression_get_inner (unary))) {
									result = g_strconcat ("-", vala_real_literal_get_value (VALA_REAL_LITERAL (vala_unary_expression_get_inner (unary))), NULL);
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									if (VALA_IS_INTEGER_LITERAL (vala_unary_expression_get_inner (unary))) {
										result = g_strconcat ("-", vala_integer_literal_get_value (VALA_INTEGER_LITERAL (vala_unary_expression_get_inner (unary))), NULL);
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static char* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const char* name) {
	char* result = NULL;
	gint parts_length1;
	gint _parts_size_;
	char** _tmp3_;
	char* _tmp0_;
	char** _tmp1_;
	char** _tmp2_;
	char** parts;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	parts = (_tmp3_ = (_tmp2_ = _tmp1_ = g_strsplit (_tmp0_ = vala_symbol_camel_case_to_lower_case (name), "_", 0), _g_free0 (_tmp0_), _tmp2_), parts_length1 = _vala_array_length (_tmp1_), _parts_size_ = parts_length1, _tmp3_);
	result = g_strjoinv ("-", parts);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	if (vala_symbol_get_access (sym) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_symbol_get_access (sym) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


ValaGIRWriter* vala_gir_writer_construct (GType object_type) {
	ValaGIRWriter* self;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIRWriter* vala_gir_writer_new (void) {
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}


static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const char* ns, const char* version) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	(*self).ns = (_tmp0_ = g_strdup (ns), _g_free0 ((*self).ns), _tmp0_);
	(*self).version = (_tmp1_ = g_strdup (version), _g_free0 ((*self).version), _tmp1_);
}


static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (_vala_strcmp0 ((*self).ns, (*g).ns) == 0) {
		_tmp0_ = _vala_strcmp0 ((*self).version, (*g).version) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest) {
	dest->ns = g_strdup (self->ns);
	dest->version = g_strdup (self->version);
}


static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self) {
	_g_free0 (self->ns);
	_g_free0 (self->version);
}


static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self) {
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}


static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self) {
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}


static GType vala_gir_writer_gir_namespace_get_type (void) {
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}


static void vala_gir_writer_class_init (ValaGIRWriterClass * klass) {
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gir_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIRWriterPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gir_writer_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gir_writer_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gir_writer_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gir_writer_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gir_writer_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_gir_writer_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gir_writer_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_gir_writer_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_gir_writer_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_gir_writer_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gir_writer_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_gir_writer_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_gir_writer_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_gir_writer_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_gir_writer_real_visit_signal;
}


static void vala_gir_writer_instance_init (ValaGIRWriter * self) {
	self->priv = VALA_GIR_WRITER_GET_PRIVATE (self);
	self->priv->buffer = g_string_new ("");
	self->priv->unannotated_namespaces = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	self->priv->our_namespaces = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	self->priv->externals = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
}


static void vala_gir_writer_finalize (ValaCodeVisitor* obj) {
	ValaGIRWriter * self;
	self = VALA_GIR_WRITER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_collection_object_unref0 (self->priv->unannotated_namespaces);
	_vala_collection_object_unref0 (self->priv->our_namespaces);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_collection_object_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}


/**
 * Code visitor generating .gir file for the public interface.
 */
GType vala_gir_writer_get_type (void) {
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




