/* valavapigen.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valavapigen.h"
#include <vala/valacodecontext.h>
#include <vala/valareport.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <vala/valasourcefile.h>
#include <vala/valasourcereference.h>
#include <vala/valaparser.h>
#include <vala/valaattributeprocessor.h>
#include <vala/valasymbolresolver.h>
#include <vala/valainterfacewriter.h>
#include "valagidlparser.h"

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;

#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

struct _ValaVAPIGen {
	GObject parent;
	ValaVAPIGenPrivate * priv;
};
struct _ValaVAPIGenClass {
	GObjectClass parent;
};
struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static char* vala_vapi_gen_directory;
static gboolean vala_vapi_gen_version;
static char** vala_vapi_gen_sources;
static char** vala_vapi_gen_vapi_directories;
static char* vala_vapi_gen_library;
static char** vala_vapi_gen_packages;
static const GOptionEntry VALA_VAPI_GEN_options[] = {{"vapidir", 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"version", 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"", 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static char* vala_vapi_gen_get_package_path (ValaVAPIGen* self, const char* pkg);
static gboolean vala_vapi_gen_add_package (ValaVAPIGen* self, const char* pkg);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gint vala_vapi_gen_main (int args_length1, char** args);
static gpointer vala_vapi_gen_parent_class = NULL;
static void vala_vapi_gen_dispose (GObject * obj);
GType vala_vapi_gen_get_type (void);


static gint vala_vapi_gen_quit (ValaVAPIGen* self)
{
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), 0);
	if (vala_report_get_errors () == 0) {
		fprintf (stdout, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings ());
		return 0;
	} else {
		fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (), vala_report_get_warnings ());
		return 1;
	}
}


static char* vala_vapi_gen_get_package_path (ValaVAPIGen* self, const char* pkg)
{
	char* basename;
	char* filename;
	char* __temp5;
	gpointer __temp7;
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	basename = g_strdup_printf ("%s.vala", pkg);
	if (vala_vapi_gen_vapi_directories != NULL) {
		{
			char** vapidir_collection;
			char** vapidir_it;
			vapidir_collection = vala_vapi_gen_vapi_directories;
			for (vapidir_it = vapidir_collection; *vapidir_it != NULL; vapidir_it = vapidir_it + 1) {
				const char* __temp3;
				char* vapidir;
				__temp3 = NULL;
				vapidir = (__temp3 = *vapidir_it, (__temp3 == NULL ? NULL : g_strdup (__temp3)));
				{
					char* filename;
					filename = g_build_filename (vapidir, basename, NULL, NULL);
					if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
						char* __temp2;
						__temp2 = NULL;
						return (__temp2 = filename, (vapidir = (g_free (vapidir), NULL)), (basename = (g_free (basename), NULL)), __temp2);
					}
					(vapidir = (g_free (vapidir), NULL));
					(filename = (g_free (filename), NULL));
				}
			}
		}
	}
	filename = g_build_filename ("/usr/local/share/vala/vapi", basename, NULL, NULL);
	if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
		char* __temp4;
		__temp4 = NULL;
		return (__temp4 = filename, (basename = (g_free (basename), NULL)), __temp4);
	}
	__temp5 = NULL;
	filename = (__temp5 = g_build_filename ("/usr/share/vala/vapi", basename, NULL, NULL), (filename = (g_free (filename), NULL)), __temp5);
	if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
		char* __temp6;
		__temp6 = NULL;
		return (__temp6 = filename, (basename = (g_free (basename), NULL)), __temp6);
	}
	return (__temp7 = NULL, (basename = (g_free (basename), NULL)), (filename = (g_free (filename), NULL)), __temp7);
	(basename = (g_free (basename), NULL));
	(filename = (g_free (filename), NULL));
}


static gboolean vala_vapi_gen_add_package (ValaVAPIGen* self, const char* pkg)
{
	char* package_path;
	ValaSourceFile* __temp9;
	gboolean __temp10;
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	package_path = vala_vapi_gen_get_package_path (self, pkg);
	if (package_path == NULL) {
		gboolean __temp8;
		return (__temp8 = FALSE, (package_path = (g_free (package_path), NULL)), __temp8);
	}
	__temp9 = NULL;
	vala_code_context_add_source_file (self->priv->context, (__temp9 = vala_source_file_new (self->priv->context, package_path, TRUE)));
	(__temp9 == NULL ? NULL : (__temp9 = (g_object_unref (__temp9), NULL)));
	return (__temp10 = TRUE, (package_path = (g_free (package_path), NULL)), __temp10);
	(package_path = (g_free (package_path), NULL));
}


static gint vala_vapi_gen_run (ValaVAPIGen* self)
{
	ValaCodeContext* __temp11;
	char** __temp19;
	ValaParser* parser;
	ValaGIdlParser* gidlparser;
	ValaAttributeProcessor* attributeprocessor;
	ValaSymbolResolver* resolver;
	gint __temp27;
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), 0);
	__temp11 = NULL;
	self->priv->context = (__temp11 = g_object_new (VALA_TYPE_CODE_CONTEXT, NULL), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), __temp11);
	/* default package */
	if (!vala_vapi_gen_add_package (self, "glib-2.0")) {
		vala_report_error (NULL, "glib-2.0 not found in specified Vala API directories");
	}
	if (vala_vapi_gen_packages != NULL) {
		char** __temp14;
		{
			char** package_collection;
			char** package_it;
			package_collection = vala_vapi_gen_packages;
			for (package_it = package_collection; *package_it != NULL; package_it = package_it + 1) {
				const char* __temp13;
				char* package;
				__temp13 = NULL;
				package = (__temp13 = *package_it, (__temp13 == NULL ? NULL : g_strdup (__temp13)));
				{
					if (!vala_vapi_gen_add_package (self, package)) {
						char* __temp12;
						__temp12 = NULL;
						vala_report_error (NULL, (__temp12 = g_strdup_printf ("%s not found in specified Vala API directories", package)));
						(__temp12 = (g_free (__temp12), NULL));
					}
					(package = (g_free (package), NULL));
				}
			}
		}
		__temp14 = NULL;
		vala_vapi_gen_packages = (__temp14 = NULL, (vala_vapi_gen_packages = (g_strfreev (vala_vapi_gen_packages), NULL)), __temp14);
	}
	if (vala_report_get_errors () > 0) {
		return vala_vapi_gen_quit (self);
	}
	{
		char** source_collection;
		char** source_it;
		source_collection = vala_vapi_gen_sources;
		for (source_it = source_collection; *source_it != NULL; source_it = source_it + 1) {
			const char* __temp18;
			char* source;
			__temp18 = NULL;
			source = (__temp18 = *source_it, (__temp18 == NULL ? NULL : g_strdup (__temp18)));
			{
				if (g_file_test (source, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* __temp16;
					__temp16 = NULL;
					vala_code_context_add_source_file (self->priv->context, (__temp16 = vala_source_file_new (self->priv->context, source, FALSE)));
					(__temp16 == NULL ? NULL : (__temp16 = (g_object_unref (__temp16), NULL)));
				} else {
					char* __temp17;
					__temp17 = NULL;
					vala_report_error (NULL, (__temp17 = g_strdup_printf ("%s not found", source)));
					(__temp17 = (g_free (__temp17), NULL));
				}
				(source = (g_free (source), NULL));
			}
		}
	}
	__temp19 = NULL;
	vala_vapi_gen_sources = (__temp19 = NULL, (vala_vapi_gen_sources = (g_strfreev (vala_vapi_gen_sources), NULL)), __temp19);
	if (vala_report_get_errors () > 0) {
		return vala_vapi_gen_quit (self);
	}
	parser = g_object_new (VALA_TYPE_PARSER, NULL);
	vala_parser_parse (parser, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint __temp21;
		return (__temp21 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), __temp21);
	}
	gidlparser = g_object_new (VALA_TYPE_GIDL_PARSER, NULL);
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint __temp22;
		return (__temp22 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), __temp22);
	}
	attributeprocessor = g_object_new (VALA_TYPE_ATTRIBUTE_PROCESSOR, NULL);
	vala_attribute_processor_process (attributeprocessor, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint __temp23;
		return (__temp23 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), __temp23);
	}
	resolver = g_object_new (VALA_TYPE_SYMBOL_RESOLVER, NULL);
	vala_symbol_resolver_resolve (resolver, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint __temp24;
		return (__temp24 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), (resolver == NULL ? NULL : (resolver = (g_object_unref (resolver), NULL))), __temp24);
	}
	if (vala_vapi_gen_library != NULL) {
		ValaInterfaceWriter* interface_writer;
		char* __temp25;
		char* __temp26;
		interface_writer = g_object_new (VALA_TYPE_INTERFACE_WRITER, NULL);
		__temp25 = NULL;
		vala_interface_writer_write_file (interface_writer, self->priv->context, (__temp25 = g_strdup_printf ("%s.vala", vala_vapi_gen_library)));
		(__temp25 = (g_free (__temp25), NULL));
		__temp26 = NULL;
		vala_vapi_gen_library = (__temp26 = NULL, (vala_vapi_gen_library = (g_free (vala_vapi_gen_library), NULL)), __temp26);
		(interface_writer == NULL ? NULL : (interface_writer = (g_object_unref (interface_writer), NULL)));
	}
	return (__temp27 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), (resolver == NULL ? NULL : (resolver = (g_object_unref (resolver), NULL))), __temp27);
	(parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL)));
	(gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL)));
	(attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL)));
	(resolver == NULL ? NULL : (resolver = (g_object_unref (resolver), NULL)));
}


static gint vala_vapi_gen_main (int args_length1, char** args)
{
	GError * inner_error;
	ValaVAPIGen* vapigen;
	gint __temp30;
	inner_error = NULL;
	{
		GOptionContext* opt_context;
		opt_context = g_option_context_new ("- Vala API Generator");
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		(opt_context == NULL ? NULL : (opt_context = (g_option_context_free (opt_context), NULL)));
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			return 1;
		}
	}
	__finally2:
	;
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		return 1;
	}
	vapigen = g_object_new (VALA_TYPE_VAPI_GEN, NULL);
	return (__temp30 = vala_vapi_gen_run (vapigen), (vapigen == NULL ? NULL : (vapigen = (g_object_unref (vapigen), NULL))), __temp30);
	(vapigen == NULL ? NULL : (vapigen = (g_object_unref (vapigen), NULL)));
}


int main (int argc, char ** argv)
{
	g_type_init ();
	return vala_vapi_gen_main (argc, argv);
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_vapi_gen_dispose;
}


static void vala_vapi_gen_init (ValaVAPIGen * self)
{
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_dispose (GObject * obj)
{
	ValaVAPIGen * self;
	ValaVAPIGenClass * klass;
	GObjectClass * parent_class;
	self = VALA_VAPI_GEN (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	klass = VALA_VAPI_GEN_CLASS (g_type_class_peek (VALA_TYPE_VAPI_GEN));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_vapi_gen_get_type (void)
{
	static GType vala_vapi_gen_type_id = 0;
	if (G_UNLIKELY (vala_vapi_gen_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_init };
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
	}
	return vala_vapi_gen_type_id;
}




