/* valabreakstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valabreakstatement.h"
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valabreakstatement.h>

enum  {
	VALA_BREAK_STATEMENT_DUMMY_PROPERTY
};
static void vala_break_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_break_statement_parent_class = NULL;
static ValaStatementIface* vala_break_statement_vala_statement_parent_iface = NULL;


/**
 * Creates a new break statement.
 *
 * @param source reference to source code
 * @return       newly created break statement
 */
ValaBreakStatement* vala_break_statement_new (ValaSourceReference* source)
{
	ValaBreakStatement * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_BREAK_STATEMENT, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_break_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaBreakStatement * self;
	self = ((ValaBreakStatement*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_break_statement (visitor, self);
}


static void vala_break_statement_class_init (ValaBreakStatementClass * klass)
{
	vala_break_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->accept = vala_break_statement_real_accept;
}


static void vala_break_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_break_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_break_statement_init (ValaBreakStatement * self)
{
}


GType vala_break_statement_get_type (void)
{
	static GType vala_break_statement_type_id = 0;
	if (G_UNLIKELY (vala_break_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBreakStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_break_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBreakStatement), 0, (GInstanceInitFunc) vala_break_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_break_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_break_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaBreakStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_break_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_break_statement_type_id;
}




