/* valacodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALACODEGENERATOR_H__
#define __VALACODEGENERATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valacallback.h>
#include <vala/valamember.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valaemptystatement.h>
#include <vala/valastruct.h>
#include <vala/valadeclarationstatement.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valainitializerlist.h>
#include <vala/valatypereference.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodefragment.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valastatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valabreakstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valareturnstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valalockstatement.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valaliteralexpression.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valaelementaccess.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valamemberaccess.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valaconditionalexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasignal.h>
#include <vala/valadatatype.h>
#include <vala/valainvocationexpression.h>
#include <vala/valamethod.h>
#include <ccode/valaccodestatement.h>
#include <vala/valacreationmethod.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodeincludedirective.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;
typedef struct _ValaCodeGeneratorPrivate ValaCodeGeneratorPrivate;

/**
 * Code visitor generating C Code.
 */
struct _ValaCodeGenerator {
	ValaCodeVisitor parent;
	ValaCodeGeneratorPrivate * priv;
};
struct _ValaCodeGeneratorClass {
	ValaCodeVisitorClass parent;
};

ValaCodeGenerator* vala_code_generator_new (gboolean manage_memory);
void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context);
gboolean vala_code_generator_get_memory_management (ValaCodeGenerator* self);
void vala_code_generator_set_memory_management (ValaCodeGenerator* self, gboolean value);
GType vala_code_generator_get_type (void);

G_END_DECLS

#endif
