/* valacodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#include "valacodegenerator.h"
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefunction.h>
#include <gee/arraylist.h>
#include <gee/set.h>
#include <vala/valascope.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valaliteral.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valalockable.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodedeclaration.h>
#include <vala/valaarray.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <vala/valainstancecast.h>
#include <gee/list.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valareport.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodegotostatement.h>
#include <ccode/valaccodeifstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <ccode/valaccodelabel.h>
#include <ccode/valaccodenewline.h>
#include <vala/valatypeparameter.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valainvokable.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valapointer.h>
#include <gee/hashset.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <gobject/valacodegenerator.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valainterfaceregisterfunction.h>

struct _ValaCodeGeneratorPrivate {
	gboolean _memory_management;
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaTypeReference* current_return_type;
	ValaTryStatement* current_try;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_dispose_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeBlock* block;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gint current_try_id;
	gint next_try_id;
	gboolean in_creation_method;
	gboolean current_method_inner_error;
	ValaTypeReference* bool_type;
	ValaTypeReference* char_type;
	ValaTypeReference* unichar_type;
	ValaTypeReference* short_type;
	ValaTypeReference* ushort_type;
	ValaTypeReference* int_type;
	ValaTypeReference* uint_type;
	ValaTypeReference* long_type;
	ValaTypeReference* ulong_type;
	ValaTypeReference* int64_type;
	ValaTypeReference* uint64_type;
	ValaTypeReference* string_type;
	ValaTypeReference* float_type;
	ValaTypeReference* double_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* gstring_type;
	ValaTypeReference* mutex_type;
	ValaDataType* type_module_type;
	ValaDataType* iterable_type;
	ValaDataType* iterator_type;
	ValaDataType* list_type;
	ValaDataType* map_type;
	ValaMethod* substring_method;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean requires_free_checked;
	gboolean requires_array_free;
	gboolean requires_array_move;
};
#define VALA_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorPrivate))
enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY,
	VALA_CODE_GENERATOR_MEMORY_MANAGEMENT
};
static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st);
static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name);
static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership);
static ValaCCodeExpression* vala_code_generator_get_dup_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type, ValaExpression* expr);
static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars);
static void vala_code_generator_add_simple_check (ValaCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars);
static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_code_generator_real_visit_begin_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_code_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_code_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym);
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr);
static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim);
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static ValaCCodeExpression* vala_code_generator_convert_from_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type);
static ValaCCodeExpression* vala_code_generator_convert_to_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type);
static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface);
static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl);
static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference);
static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl);
static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop);
static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type);
static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface);
static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeExpression* vala_code_generator_default_value_for_type (ValaCodeGenerator* self, ValaDataType* type);
static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaSymbol* sym);
static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim);
static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b, gboolean has_params);
static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix);
static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig);
static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename);
static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_code_generator_get_define_for_filename (const char* filename);
static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_code_generator_parent_class = NULL;
static void vala_code_generator_dispose (GObject * obj);


ValaCodeGenerator* vala_code_generator_new (gboolean manage_memory)
{
	ValaCodeGenerator * self;
	self = g_object_newv (VALA_TYPE_CODE_GENERATOR, 0, NULL);
	vala_code_generator_set_memory_management (self, manage_memory);
	return self;
}


/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context)
{
	ValaCodeContext* __temp0;
	ValaSymbol* __temp1;
	ValaTypeReference* __temp2;
	ValaDataType* __temp3;
	ValaTypeReference* __temp4;
	ValaDataType* __temp5;
	ValaTypeReference* __temp6;
	ValaDataType* __temp7;
	ValaTypeReference* __temp8;
	ValaDataType* __temp9;
	ValaTypeReference* __temp10;
	ValaDataType* __temp11;
	ValaTypeReference* __temp12;
	ValaDataType* __temp13;
	ValaTypeReference* __temp14;
	ValaDataType* __temp15;
	ValaTypeReference* __temp16;
	ValaDataType* __temp17;
	ValaTypeReference* __temp18;
	ValaDataType* __temp19;
	ValaTypeReference* __temp20;
	ValaDataType* __temp21;
	ValaTypeReference* __temp22;
	ValaDataType* __temp23;
	ValaTypeReference* __temp24;
	ValaDataType* __temp25;
	ValaTypeReference* __temp26;
	ValaDataType* __temp27;
	ValaTypeReference* __temp28;
	ValaDataType* __temp29;
	ValaMethod* __temp30;
	ValaSymbol* glib_ns;
	ValaDataType* __temp31;
	ValaDataType* __temp32;
	ValaDataType* __temp33;
	ValaTypeReference* __temp34;
	ValaDataType* __temp35;
	ValaDataType* __temp36;
	ValaSymbol* gee_ns;
	GeeCollection* source_files;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	__temp0 = NULL;
	self->priv->context = (__temp0 = g_object_ref (context), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), __temp0);
	vala_code_context_find_header_cycles (context);
	__temp1 = NULL;
	self->priv->root_symbol = (__temp1 = VALA_SYMBOL (g_object_ref (vala_code_context_get_root (context))), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp1);
	__temp2 = NULL;
	self->priv->bool_type = (__temp2 = vala_type_reference_new (), (self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL))), __temp2);
	__temp3 = NULL;
	vala_type_reference_set_data_type (self->priv->bool_type, (__temp3 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "bool"))));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	__temp4 = NULL;
	self->priv->char_type = (__temp4 = vala_type_reference_new (), (self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL))), __temp4);
	__temp5 = NULL;
	vala_type_reference_set_data_type (self->priv->char_type, (__temp5 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "char"))));
	(__temp5 == NULL ? NULL : (__temp5 = (g_object_unref (__temp5), NULL)));
	__temp6 = NULL;
	self->priv->unichar_type = (__temp6 = vala_type_reference_new (), (self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL))), __temp6);
	__temp7 = NULL;
	vala_type_reference_set_data_type (self->priv->unichar_type, (__temp7 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "unichar"))));
	(__temp7 == NULL ? NULL : (__temp7 = (g_object_unref (__temp7), NULL)));
	__temp8 = NULL;
	self->priv->short_type = (__temp8 = vala_type_reference_new (), (self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL))), __temp8);
	__temp9 = NULL;
	vala_type_reference_set_data_type (self->priv->short_type, (__temp9 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "short"))));
	(__temp9 == NULL ? NULL : (__temp9 = (g_object_unref (__temp9), NULL)));
	__temp10 = NULL;
	self->priv->ushort_type = (__temp10 = vala_type_reference_new (), (self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL))), __temp10);
	__temp11 = NULL;
	vala_type_reference_set_data_type (self->priv->ushort_type, (__temp11 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ushort"))));
	(__temp11 == NULL ? NULL : (__temp11 = (g_object_unref (__temp11), NULL)));
	__temp12 = NULL;
	self->priv->int_type = (__temp12 = vala_type_reference_new (), (self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL))), __temp12);
	__temp13 = NULL;
	vala_type_reference_set_data_type (self->priv->int_type, (__temp13 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int"))));
	(__temp13 == NULL ? NULL : (__temp13 = (g_object_unref (__temp13), NULL)));
	__temp14 = NULL;
	self->priv->uint_type = (__temp14 = vala_type_reference_new (), (self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL))), __temp14);
	__temp15 = NULL;
	vala_type_reference_set_data_type (self->priv->uint_type, (__temp15 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint"))));
	(__temp15 == NULL ? NULL : (__temp15 = (g_object_unref (__temp15), NULL)));
	__temp16 = NULL;
	self->priv->long_type = (__temp16 = vala_type_reference_new (), (self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL))), __temp16);
	__temp17 = NULL;
	vala_type_reference_set_data_type (self->priv->long_type, (__temp17 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "long"))));
	(__temp17 == NULL ? NULL : (__temp17 = (g_object_unref (__temp17), NULL)));
	__temp18 = NULL;
	self->priv->ulong_type = (__temp18 = vala_type_reference_new (), (self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL))), __temp18);
	__temp19 = NULL;
	vala_type_reference_set_data_type (self->priv->ulong_type, (__temp19 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ulong"))));
	(__temp19 == NULL ? NULL : (__temp19 = (g_object_unref (__temp19), NULL)));
	__temp20 = NULL;
	self->priv->int64_type = (__temp20 = vala_type_reference_new (), (self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL))), __temp20);
	__temp21 = NULL;
	vala_type_reference_set_data_type (self->priv->int64_type, (__temp21 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int64"))));
	(__temp21 == NULL ? NULL : (__temp21 = (g_object_unref (__temp21), NULL)));
	__temp22 = NULL;
	self->priv->uint64_type = (__temp22 = vala_type_reference_new (), (self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL))), __temp22);
	__temp23 = NULL;
	vala_type_reference_set_data_type (self->priv->uint64_type, (__temp23 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint64"))));
	(__temp23 == NULL ? NULL : (__temp23 = (g_object_unref (__temp23), NULL)));
	__temp24 = NULL;
	self->priv->float_type = (__temp24 = vala_type_reference_new (), (self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL))), __temp24);
	__temp25 = NULL;
	vala_type_reference_set_data_type (self->priv->float_type, (__temp25 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "float"))));
	(__temp25 == NULL ? NULL : (__temp25 = (g_object_unref (__temp25), NULL)));
	__temp26 = NULL;
	self->priv->double_type = (__temp26 = vala_type_reference_new (), (self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL))), __temp26);
	__temp27 = NULL;
	vala_type_reference_set_data_type (self->priv->double_type, (__temp27 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "double"))));
	(__temp27 == NULL ? NULL : (__temp27 = (g_object_unref (__temp27), NULL)));
	__temp28 = NULL;
	self->priv->string_type = (__temp28 = vala_type_reference_new (), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL))), __temp28);
	__temp29 = NULL;
	vala_type_reference_set_data_type (self->priv->string_type, (__temp29 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "string"))));
	(__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL)));
	__temp30 = NULL;
	self->priv->substring_method = (__temp30 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) vala_type_reference_get_data_type (self->priv->string_type))), "substring")), (self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL))), __temp30);
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "GLib");
	__temp31 = NULL;
	self->priv->glist_type = (__temp31 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->priv->glist_type == NULL ? NULL : (self->priv->glist_type = (g_object_unref (self->priv->glist_type), NULL))), __temp31);
	__temp32 = NULL;
	self->priv->gslist_type = (__temp32 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->priv->gslist_type == NULL ? NULL : (self->priv->gslist_type = (g_object_unref (self->priv->gslist_type), NULL))), __temp32);
	__temp33 = NULL;
	self->priv->gstring_type = (__temp33 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "String")), (self->priv->gstring_type == NULL ? NULL : (self->priv->gstring_type = (g_object_unref (self->priv->gstring_type), NULL))), __temp33);
	__temp34 = NULL;
	self->priv->mutex_type = (__temp34 = vala_type_reference_new (), (self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL))), __temp34);
	__temp35 = NULL;
	vala_type_reference_set_data_type (self->priv->mutex_type, (__temp35 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Mutex"))));
	(__temp35 == NULL ? NULL : (__temp35 = (g_object_unref (__temp35), NULL)));
	__temp36 = NULL;
	self->priv->type_module_type = (__temp36 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL))), __temp36);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* __temp37;
		__temp37 = NULL;
		self->priv->module_init_fragment = (__temp37 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL))), __temp37);
		{
			GeeCollection* parameter_collection;
			GeeIterator* parameter_it;
			parameter_collection = vala_invokable_get_parameters (VALA_INVOKABLE (vala_code_context_get_module_init_method (context)));
			parameter_it = gee_iterable_iterator (GEE_ITERABLE (parameter_collection));
			while (gee_iterator_next (parameter_it)) {
				ValaFormalParameter* parameter;
				parameter = gee_iterator_get (parameter_it);
				{
					if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->priv->type_module_type) {
						char* __temp39;
						const char* __temp38;
						self->priv->in_plugin = TRUE;
						__temp39 = NULL;
						__temp38 = NULL;
						self->priv->module_init_param_name = (__temp39 = (__temp38 = vala_symbol_get_name (((ValaSymbol*) parameter)), (__temp38 == NULL ? NULL : g_strdup (__temp38))), (self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL)), __temp39);
						(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
						break;
					}
					(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
				}
			}
			(parameter_collection == NULL ? NULL : (parameter_collection = (g_object_unref (parameter_collection), NULL)));
			(parameter_it == NULL ? NULL : (parameter_it = (g_object_unref (parameter_it), NULL)));
		}
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaDataType* __temp40;
		ValaDataType* __temp41;
		ValaDataType* __temp42;
		ValaDataType* __temp43;
		__temp40 = NULL;
		self->priv->iterable_type = (__temp40 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterable")), (self->priv->iterable_type == NULL ? NULL : (self->priv->iterable_type = (g_object_unref (self->priv->iterable_type), NULL))), __temp40);
		__temp41 = NULL;
		self->priv->iterator_type = (__temp41 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterator")), (self->priv->iterator_type == NULL ? NULL : (self->priv->iterator_type = (g_object_unref (self->priv->iterator_type), NULL))), __temp41);
		__temp42 = NULL;
		self->priv->list_type = (__temp42 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL))), __temp42);
		__temp43 = NULL;
		self->priv->map_type = (__temp43 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->priv->map_type == NULL ? NULL : (self->priv->map_type = (g_object_unref (self->priv->map_type), NULL))), __temp43);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeCollection* file_collection;
		GeeIterator* file_it;
		file_collection = source_files;
		file_it = gee_iterable_iterator (GEE_ITERABLE (file_collection));
		while (gee_iterator_next (file_it)) {
			ValaSourceFile* file;
			file = gee_iterator_get (file_it);
			{
				if (!vala_source_file_get_pkg (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
				(file == NULL ? NULL : (file = (g_object_unref (file), NULL)));
			}
		}
		(file_it == NULL ? NULL : (file_it = (g_object_unref (file_it), NULL)));
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(gee_ns == NULL ? NULL : (gee_ns = (g_object_unref (gee_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_object_unref (source_files), NULL)));
}


static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaCodeGenerator * self;
	ValaCCodeEnum* __temp45;
	char* __temp44;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ENUM (en));
	__temp45 = NULL;
	__temp44 = NULL;
	self->priv->cenum = (__temp45 = vala_ccode_enum_new ((__temp44 = vala_data_type_get_cname (VALA_DATA_TYPE (en), FALSE))), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp45);
	(__temp44 = (g_free (__temp44), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) en))) != NULL) {
		ValaCCodeComment* __temp46;
		__temp46 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp46 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) en)))))));
		(__temp46 == NULL ? NULL : (__temp46 = (g_object_unref (__temp46), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	if (vala_enum_get_error_domain (en)) {
		char* __temp47;
		char* __temp48;
		char* quark_fun_name;
		char* __temp50;
		char* __temp49;
		ValaCCodeMacroReplacement* __temp51;
		ValaCCodeMacroReplacement* error_domain_define;
		ValaCCodeFunction* cquark_fun;
		ValaCCodeBlock* cquark_block;
		ValaCCodeIdentifier* __temp52;
		ValaCCodeFunctionCall* __temp53;
		ValaCCodeFunctionCall* cquark_call;
		ValaCCodeConstant* __temp57;
		char* __temp56;
		char* __temp55;
		char* __temp54;
		ValaCCodeReturnStatement* __temp58;
		ValaCCodeFunction* __temp59;
		__temp47 = NULL;
		__temp48 = NULL;
		quark_fun_name = (__temp48 = g_strconcat ((__temp47 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (en))), "quark", NULL), (__temp47 = (g_free (__temp47), NULL)), __temp48);
		__temp50 = NULL;
		__temp49 = NULL;
		__temp51 = NULL;
		error_domain_define = (__temp51 = vala_ccode_macro_replacement_new ((__temp49 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (en), NULL)), (__temp50 = g_strconcat (quark_fun_name, " ()", NULL))), (__temp50 = (g_free (__temp50), NULL)), (__temp49 = (g_free (__temp49), NULL)), __temp51);
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (error_domain_define));
		cquark_fun = vala_ccode_function_new (quark_fun_name, "GQuark");
		cquark_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		__temp52 = NULL;
		__temp53 = NULL;
		cquark_call = (__temp53 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp52 = vala_ccode_identifier_new ("g_quark_from_static_string")))), (__temp52 == NULL ? NULL : (__temp52 = (g_object_unref (__temp52), NULL))), __temp53);
		__temp57 = NULL;
		__temp56 = NULL;
		__temp55 = NULL;
		__temp54 = NULL;
		vala_ccode_function_call_add_argument (cquark_call, VALA_CCODE_EXPRESSION ((__temp57 = vala_ccode_constant_new ((__temp56 = g_strconcat ((__temp55 = g_strconcat ("\"", (__temp54 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (en), NULL)), NULL)), "-quark\"", NULL))))));
		(__temp57 == NULL ? NULL : (__temp57 = (g_object_unref (__temp57), NULL)));
		(__temp56 = (g_free (__temp56), NULL));
		(__temp55 = (g_free (__temp55), NULL));
		(__temp54 = (g_free (__temp54), NULL));
		__temp58 = NULL;
		vala_ccode_block_add_statement (cquark_block, VALA_CCODE_NODE ((__temp58 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (cquark_call)))));
		(__temp58 == NULL ? NULL : (__temp58 = (g_object_unref (__temp58), NULL)));
		__temp59 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp59 = vala_ccode_function_copy (cquark_fun))));
		(__temp59 = (g_object_unref (__temp59), NULL));
		vala_ccode_function_set_block (cquark_fun, cquark_block);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cquark_fun));
		(quark_fun_name = (g_free (quark_fun_name), NULL));
		(error_domain_define == NULL ? NULL : (error_domain_define = (g_object_unref (error_domain_define), NULL)));
		(cquark_fun == NULL ? NULL : (cquark_fun = (g_object_unref (cquark_fun), NULL)));
		(cquark_block == NULL ? NULL : (cquark_block = (g_object_unref (cquark_block), NULL)));
		(cquark_call == NULL ? NULL : (cquark_call = (g_object_unref (cquark_call), NULL)));
	}
}


static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev)
{
	ValaCodeGenerator * self;
	char* val;
	char* __temp62;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_enum_value_get_value (ev))) {
		ValaLiteral* __temp60;
		ValaLiteral* lit;
		__temp60 = NULL;
		lit = (__temp60 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_enum_value_get_value (ev)))), (__temp60 == NULL ? NULL : g_object_ref (__temp60)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp61;
			__temp61 = NULL;
			val = (__temp61 = g_strdup (vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit)))), (val = (g_free (val), NULL)), __temp61);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	__temp62 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp62 = vala_enum_value_get_cname (ev)), val);
	(__temp62 = (g_free (__temp62), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaCodeGenerator * self;
	char* __temp63;
	ValaCCodeFunctionDeclarator* __temp64;
	ValaCCodeFunctionDeclarator* cfundecl;
	char* __temp65;
	ValaCCodeTypeDefinition* __temp66;
	ValaCCodeTypeDefinition* ctypedef;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	__temp63 = NULL;
	__temp64 = NULL;
	cfundecl = (__temp64 = vala_ccode_function_declarator_new ((__temp63 = vala_data_type_get_cname (VALA_DATA_TYPE (cb), FALSE))), (__temp63 = (g_free (__temp63), NULL)), __temp64);
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_callback_get_parameters (cb);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	__temp65 = NULL;
	__temp66 = NULL;
	ctypedef = (__temp66 = vala_ccode_type_definition_new ((__temp65 = vala_type_reference_get_cname (vala_callback_get_return_type (cb), FALSE, FALSE)), VALA_CCODE_DECLARATOR (cfundecl)), (__temp65 = (g_free (__temp65), NULL)), __temp66);
	if (((ValaDataType*) cb)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* __temp68;
		char* __temp67;
		ValaCCodeExpressionStatement* __temp77;
		ValaCCodeAssignment* __temp76;
		ValaCCodeFunctionCall* __temp75;
		ValaCCodeIdentifier* __temp74;
		char* __temp73;
		ValaCCodeMemberAccess* __temp72;
		char* __temp71;
		ValaCCodeMemberAccess* __temp70;
		ValaCCodeIdentifier* __temp69;
		ValaCCodeIdentifier* __temp78;
		ValaCCodeFunctionCall* __temp79;
		ValaCCodeFunctionCall* fc;
		ValaCCodeMemberAccess* __temp83;
		char* __temp82;
		ValaCCodeMemberAccess* __temp81;
		ValaCCodeIdentifier* __temp80;
		ValaCCodeIdentifier* __temp85;
		char* __temp84;
		__temp68 = NULL;
		__temp67 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_priv_struct, (__temp67 = vala_type_reference_get_cname (self->priv->mutex_type, FALSE, FALSE)), (__temp68 = vala_code_generator_get_symbol_lock_name (self, VALA_SYMBOL (m))));
		(__temp68 = (g_free (__temp68), NULL));
		(__temp67 = (g_free (__temp67), NULL));
		__temp77 = NULL;
		__temp76 = NULL;
		__temp75 = NULL;
		__temp74 = NULL;
		__temp73 = NULL;
		__temp72 = NULL;
		__temp71 = NULL;
		__temp70 = NULL;
		__temp69 = NULL;
		vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp77 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp76 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp70 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp69 = vala_ccode_identifier_new ("self"))), "priv"))), (__temp71 = vala_code_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))), VALA_CCODE_EXPRESSION ((__temp75 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp74 = vala_ccode_identifier_new ((__temp73 = vala_method_get_cname (vala_struct_get_default_construction_method ((VALA_STRUCT (vala_type_reference_get_data_type (self->priv->mutex_type)))))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp77 == NULL ? NULL : (__temp77 = (g_object_unref (__temp77), NULL)));
		(__temp76 == NULL ? NULL : (__temp76 = (g_object_unref (__temp76), NULL)));
		(__temp75 == NULL ? NULL : (__temp75 = (g_object_unref (__temp75), NULL)));
		(__temp74 == NULL ? NULL : (__temp74 = (g_object_unref (__temp74), NULL)));
		(__temp73 = (g_free (__temp73), NULL));
		(__temp72 == NULL ? NULL : (__temp72 = (g_object_unref (__temp72), NULL)));
		(__temp71 = (g_free (__temp71), NULL));
		(__temp70 == NULL ? NULL : (__temp70 = (g_object_unref (__temp70), NULL)));
		(__temp69 == NULL ? NULL : (__temp69 = (g_object_unref (__temp69), NULL)));
		self->priv->requires_free_checked = TRUE;
		__temp78 = NULL;
		__temp79 = NULL;
		fc = (__temp79 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp78 = vala_ccode_identifier_new ("VALA_FREE_CHECKED")))), (__temp78 == NULL ? NULL : (__temp78 = (g_object_unref (__temp78), NULL))), __temp79);
		__temp83 = NULL;
		__temp82 = NULL;
		__temp81 = NULL;
		__temp80 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp83 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp81 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp80 = vala_ccode_identifier_new ("self"))), "priv"))), (__temp82 = vala_code_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))));
		(__temp83 == NULL ? NULL : (__temp83 = (g_object_unref (__temp83), NULL)));
		(__temp82 = (g_free (__temp82), NULL));
		(__temp81 == NULL ? NULL : (__temp81 = (g_object_unref (__temp81), NULL)));
		(__temp80 == NULL ? NULL : (__temp80 = (g_object_unref (__temp80), NULL)));
		__temp85 = NULL;
		__temp84 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp85 = vala_ccode_identifier_new ((__temp84 = vala_data_type_get_free_function (vala_type_reference_get_data_type (self->priv->mutex_type)))))));
		(__temp85 == NULL ? NULL : (__temp85 = (g_object_unref (__temp85), NULL)));
		(__temp84 = (g_free (__temp84), NULL));
		if (self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp86;
			__temp86 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp86 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(__temp86 == NULL ? NULL : (__temp86 = (g_object_unref (__temp86), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	if (VALA_IS_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) c)))) {
		ValaDataType* __temp87;
		ValaDataType* t;
		char* __temp88;
		ValaCCodeDeclaration* __temp89;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* __temp93;
		char* __temp92;
		char* __temp91;
		__temp87 = NULL;
		t = (__temp87 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) c))), (__temp87 == NULL ? NULL : g_object_ref (__temp87)));
		__temp88 = NULL;
		__temp89 = NULL;
		cdecl_ = (__temp89 = vala_ccode_declaration_new ((__temp88 = vala_type_reference_get_const_cname (vala_constant_get_type_reference (c)))), (__temp88 = (g_free (__temp88), NULL)), __temp89);
		arr = g_strdup ("");
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_constant_get_type_reference (c)))) {
			char* __temp90;
			__temp90 = NULL;
			arr = (__temp90 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), __temp90);
		}
		__temp93 = NULL;
		__temp92 = NULL;
		__temp91 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp93 = vala_ccode_variable_declarator_new_with_initializer ((__temp92 = g_strdup_printf ("%s%s", (__temp91 = vala_constant_get_cname (c)), arr)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_constant_get_initializer (c))))))));
		(__temp93 == NULL ? NULL : (__temp93 = (g_object_unref (__temp93), NULL)));
		(__temp92 = (g_free (__temp92), NULL));
		(__temp91 = (g_free (__temp91), NULL));
		vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
		if (c->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		} else {
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		}
		(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		(arr = (g_free (arr), NULL));
	}
}


static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	lhs = NULL;
	st = NULL;
	if (f->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		ValaCCodeStruct* __temp95;
		ValaCCodeStruct* __temp94;
		__temp95 = NULL;
		__temp94 = NULL;
		st = (__temp95 = (__temp94 = self->priv->instance_struct, (__temp94 == NULL ? NULL : g_object_ref (__temp94))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp95);
		if (vala_field_get_instance (f)) {
			ValaCCodeExpression* __temp98;
			char* __temp97;
			ValaCCodeIdentifier* __temp96;
			__temp98 = NULL;
			__temp97 = NULL;
			__temp96 = NULL;
			lhs = (__temp98 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp96 = vala_ccode_identifier_new ("self"))), (__temp97 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp98);
			(__temp97 = (g_free (__temp97), NULL));
			(__temp96 == NULL ? NULL : (__temp96 = (g_object_unref (__temp96), NULL)));
		}
	} else {
		if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_instance (f)) {
				ValaCCodeStruct* __temp100;
				ValaCCodeStruct* __temp99;
				ValaCCodeExpression* __temp104;
				char* __temp103;
				ValaCCodeMemberAccess* __temp102;
				ValaCCodeIdentifier* __temp101;
				__temp100 = NULL;
				__temp99 = NULL;
				st = (__temp100 = (__temp99 = self->priv->instance_priv_struct, (__temp99 == NULL ? NULL : g_object_ref (__temp99))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp100);
				__temp104 = NULL;
				__temp103 = NULL;
				__temp102 = NULL;
				__temp101 = NULL;
				lhs = (__temp104 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp102 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp101 = vala_ccode_identifier_new ("self"))), "priv"))), (__temp103 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp104);
				(__temp103 = (g_free (__temp103), NULL));
				(__temp102 == NULL ? NULL : (__temp102 = (g_object_unref (__temp102), NULL)));
				(__temp101 == NULL ? NULL : (__temp101 = (g_object_unref (__temp101), NULL)));
			} else {
				if (VALA_IS_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))) {
					ValaDataType* __temp105;
					ValaDataType* t;
					char* __temp106;
					ValaCCodeDeclaration* __temp107;
					ValaCCodeDeclaration* cdecl_;
					char* __temp108;
					ValaCCodeVariableDeclarator* __temp109;
					ValaCCodeVariableDeclarator* var_decl;
					__temp105 = NULL;
					t = (__temp105 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f))), (__temp105 == NULL ? NULL : g_object_ref (__temp105)));
					__temp106 = NULL;
					__temp107 = NULL;
					cdecl_ = (__temp107 = vala_ccode_declaration_new ((__temp106 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE))), (__temp106 = (g_free (__temp106), NULL)), __temp107);
					__temp108 = NULL;
					__temp109 = NULL;
					var_decl = (__temp109 = vala_ccode_variable_declarator_new ((__temp108 = vala_field_get_cname (f))), (__temp108 = (g_free (__temp108), NULL)), __temp109);
					if (vala_field_get_initializer (f) != NULL) {
						vala_ccode_variable_declarator_set_initializer (var_decl, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_field_get_initializer (f)))));
					}
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
					vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
					vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
					(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
				}
			}
		}
	}
	if (vala_field_get_instance (f)) {
		char* __temp111;
		char* __temp110;
		__temp111 = NULL;
		__temp110 = NULL;
		vala_ccode_struct_add_field (st, (__temp110 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE)), (__temp111 = vala_field_get_cname (f)));
		(__temp111 = (g_free (__temp111), NULL));
		(__temp110 = (g_free (__temp110), NULL));
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f)) {
			ValaArray* __temp112;
			ValaArray* arr;
			/* create fields to store array dimensions*/
			__temp112 = NULL;
			arr = (__temp112 = VALA_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))), (__temp112 == NULL ? NULL : g_object_ref (__temp112)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaTypeReference* len_type;
					char* __temp114;
					char* __temp113;
					len_type = vala_type_reference_new ();
					vala_type_reference_set_data_type (len_type, vala_type_reference_get_data_type (self->priv->int_type));
					__temp114 = NULL;
					__temp113 = NULL;
					vala_ccode_struct_add_field (st, (__temp113 = vala_type_reference_get_cname (len_type, FALSE, FALSE)), (__temp114 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) f)), dim)));
					(__temp114 = (g_free (__temp114), NULL));
					(__temp113 = (g_free (__temp113), NULL));
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* __temp115;
			ValaCCodeExpression* rhs;
			ValaCCodeExpressionStatement* __temp118;
			ValaCCodeAssignment* __temp117;
			__temp115 = NULL;
			rhs = (__temp115 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_field_get_initializer (f)))), (__temp115 == NULL ? NULL : g_object_ref (__temp115)));
			if (vala_type_reference_get_data_type (vala_field_get_type_reference (f)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_field_get_initializer (f))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_field_get_initializer (f))) != vala_type_reference_get_data_type (vala_field_get_type_reference (f))) {
				ValaCCodeExpression* __temp116;
				/* FIXME: use C cast if debugging disabled*/
				__temp116 = NULL;
				rhs = (__temp116 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_field_get_type_reference (f)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp116);
			}
			__temp118 = NULL;
			__temp117 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp118 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp117 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(__temp118 == NULL ? NULL : (__temp118 = (g_object_unref (__temp118), NULL)));
			(__temp117 == NULL ? NULL : (__temp117 = (g_object_unref (__temp117), NULL)));
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* array_len_lhs;
				GeeList* sizes;
				ValaExpression* size;
				ValaCCodeExpressionStatement* __temp120;
				ValaCCodeAssignment* __temp119;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) f)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
				array_len_lhs = vala_code_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), 1);
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				size = gee_list_get (((GeeList*) sizes), 0);
				__temp120 = NULL;
				__temp119 = NULL;
				vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp120 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp119 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(__temp120 == NULL ? NULL : (__temp120 = (g_object_unref (__temp120), NULL)));
				(__temp119 == NULL ? NULL : (__temp119 = (g_object_unref (__temp119), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(array_len_lhs = (g_object_unref (array_len_lhs), NULL));
				(sizes == NULL ? NULL : (sizes = (g_object_unref (sizes), NULL)));
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
		if (vala_type_reference_get_takes_ownership (vala_field_get_type_reference (f)) && self->priv->instance_dispose_fragment != NULL) {
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* __temp122;
			ValaCCodeExpression* __temp121;
			ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) f)), NULL);
			vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
			__temp122 = NULL;
			__temp121 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp122 = vala_ccode_expression_statement_new ((__temp121 = vala_code_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f), VALA_EXPRESSION (ma)))))));
			(__temp122 == NULL ? NULL : (__temp122 = (g_object_unref (__temp122), NULL)));
			(__temp121 == NULL ? NULL : (__temp121 = (g_object_unref (__temp121), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
	}
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
}


static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		ValaCCodeFormalParameter* __temp124;
		char* __temp123;
		__temp124 = NULL;
		__temp123 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((__temp124 = vala_ccode_formal_parameter_new (vala_symbol_get_name (((ValaSymbol*) p)), (__temp123 = vala_type_reference_get_cname (vala_formal_parameter_get_type_reference (p), FALSE, !vala_type_reference_get_takes_ownership (vala_formal_parameter_get_type_reference (p))))))));
		(__temp124 == NULL ? NULL : (__temp124 = (g_object_unref (__temp124), NULL)));
		(__temp123 = (g_free (__temp123), NULL));
	}
}


static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) prop)))) {
		char* __temp125;
		__temp125 = NULL;
		vala_ccode_enum_add_value (self->priv->prop_enum, (__temp125 = vala_property_get_upper_case_cname (prop)), NULL);
		(__temp125 = (g_free (__temp125), NULL));
	}
}


static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaCodeGenerator * self;
	ValaProperty* __temp126;
	ValaProperty* prop;
	ValaTypeReference* __temp129;
	ValaDataType* __temp130;
	ValaDataType* t;
	ValaTypeReference* this_type;
	char* __temp131;
	ValaCCodeFormalParameter* __temp132;
	ValaCCodeFormalParameter* cselfparam;
	char* __temp133;
	ValaCCodeFormalParameter* __temp134;
	ValaCCodeFormalParameter* cvalueparam;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	__temp126 = NULL;
	prop = (__temp126 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (__temp126 == NULL ? NULL : g_object_ref (__temp126)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaTypeReference* __temp127;
		__temp127 = NULL;
		self->priv->current_return_type = (__temp127 = g_object_ref (vala_property_get_type_reference (prop)), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp127);
	} else {
		ValaTypeReference* __temp128;
		/* void*/
		__temp128 = NULL;
		self->priv->current_return_type = (__temp128 = vala_type_reference_new (), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp128);
	}
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
	__temp129 = NULL;
	self->priv->current_return_type = (__temp129 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp129);
	__temp130 = NULL;
	t = (__temp130 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) prop))), (__temp130 == NULL ? NULL : g_object_ref (__temp130)));
	this_type = vala_type_reference_new ();
	vala_type_reference_set_data_type (this_type, t);
	__temp131 = NULL;
	__temp132 = NULL;
	cselfparam = (__temp132 = vala_ccode_formal_parameter_new ("self", (__temp131 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (__temp131 = (g_free (__temp131), NULL)), __temp132);
	__temp133 = NULL;
	__temp134 = NULL;
	cvalueparam = (__temp134 = vala_ccode_formal_parameter_new ("value", (__temp133 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, TRUE))), (__temp133 = (g_free (__temp133), NULL)), __temp134);
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeBlock* block;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp138;
			char* __temp137;
			char* __temp136;
			char* __temp135;
			__temp138 = NULL;
			__temp137 = NULL;
			__temp136 = NULL;
			__temp135 = NULL;
			self->priv->function = (__temp138 = vala_ccode_function_new ((__temp136 = g_strdup_printf ("%s_get_%s", (__temp135 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (((ValaSymbol*) prop)))), (__temp137 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp138);
			(__temp137 = (g_free (__temp137), NULL));
			(__temp136 = (g_free (__temp136), NULL));
			(__temp135 = (g_free (__temp135), NULL));
		} else {
			ValaCCodeFunction* __temp141;
			char* __temp140;
			char* __temp139;
			__temp141 = NULL;
			__temp140 = NULL;
			__temp139 = NULL;
			self->priv->function = (__temp141 = vala_ccode_function_new ((__temp140 = g_strdup_printf ("%s_set_%s", (__temp139 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (((ValaSymbol*) prop)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp141);
			(__temp140 = (g_free (__temp140), NULL));
			(__temp139 = (g_free (__temp139), NULL));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (t->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFunction* __temp142;
			__temp142 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp142 = vala_ccode_function_copy (self->priv->function))));
			(__temp142 = (g_object_unref (__temp142), NULL));
		} else {
			ValaCCodeFunction* __temp143;
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
			__temp143 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp143 = vala_ccode_function_copy (self->priv->function))));
			(__temp143 = (g_object_unref (__temp143), NULL));
		}
		block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vala_ccode_function_set_block (self->priv->function, block);
		if (vala_property_accessor_get_readable (acc)) {
			char* __temp144;
			ValaCCodeDeclaration* __temp145;
			ValaCCodeDeclaration* decl;
			ValaCCodeVariableDeclarator* __temp146;
			ValaCCodeIdentifier* __temp147;
			ValaCCodeFunctionCall* __temp148;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* __temp149;
			ValaCCodeFunctionCall* __temp150;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* __temp151;
			ValaCCodeConstant* __temp152;
			ValaCCodeUnaryExpression* __temp154;
			ValaCCodeIdentifier* __temp153;
			ValaCCodeConstant* __temp155;
			ValaCCodeExpressionStatement* __temp156;
			ValaCCodeReturnStatement* __temp158;
			ValaCCodeIdentifier* __temp157;
			/* declare temporary variable to save the property value*/
			__temp144 = NULL;
			__temp145 = NULL;
			decl = (__temp145 = vala_ccode_declaration_new ((__temp144 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (__temp144 = (g_free (__temp144), NULL)), __temp145);
			__temp146 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp146 = vala_ccode_variable_declarator_new ("value"))));
			(__temp146 == NULL ? NULL : (__temp146 = (g_object_unref (__temp146), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			__temp147 = NULL;
			__temp148 = NULL;
			ccall = (__temp148 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp147 = vala_ccode_identifier_new ("g_object_get")))), (__temp147 == NULL ? NULL : (__temp147 = (g_object_unref (__temp147), NULL))), __temp148);
			__temp149 = NULL;
			__temp150 = NULL;
			ccast = (__temp150 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp149 = vala_ccode_identifier_new ("G_OBJECT")))), (__temp149 == NULL ? NULL : (__temp149 = (g_object_unref (__temp149), NULL))), __temp150);
			__temp151 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp151 = vala_ccode_identifier_new ("self"))));
			(__temp151 == NULL ? NULL : (__temp151 = (g_object_unref (__temp151), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			__temp152 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp152 = vala_property_get_canonical_cconstant (prop))));
			(__temp152 = (g_object_unref (__temp152), NULL));
			__temp154 = NULL;
			__temp153 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp154 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp153 = vala_ccode_identifier_new ("value")))))));
			(__temp154 == NULL ? NULL : (__temp154 = (g_object_unref (__temp154), NULL)));
			(__temp153 == NULL ? NULL : (__temp153 = (g_object_unref (__temp153), NULL)));
			__temp155 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp155 = vala_ccode_constant_new ("NULL"))));
			(__temp155 == NULL ? NULL : (__temp155 = (g_object_unref (__temp155), NULL)));
			__temp156 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp156 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp156 == NULL ? NULL : (__temp156 = (g_object_unref (__temp156), NULL)));
			__temp158 = NULL;
			__temp157 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp158 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((__temp157 = vala_ccode_identifier_new ("value")))))));
			(__temp158 == NULL ? NULL : (__temp158 = (g_object_unref (__temp158), NULL)));
			(__temp157 == NULL ? NULL : (__temp157 = (g_object_unref (__temp157), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeIdentifier* __temp159;
			ValaCCodeFunctionCall* __temp160;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* __temp161;
			ValaCCodeFunctionCall* __temp162;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* __temp163;
			ValaCCodeConstant* __temp164;
			ValaCCodeIdentifier* __temp165;
			ValaCCodeConstant* __temp166;
			ValaCCodeExpressionStatement* __temp167;
			__temp159 = NULL;
			__temp160 = NULL;
			ccall = (__temp160 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp159 = vala_ccode_identifier_new ("g_object_set")))), (__temp159 == NULL ? NULL : (__temp159 = (g_object_unref (__temp159), NULL))), __temp160);
			__temp161 = NULL;
			__temp162 = NULL;
			ccast = (__temp162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp161 = vala_ccode_identifier_new ("G_OBJECT")))), (__temp161 == NULL ? NULL : (__temp161 = (g_object_unref (__temp161), NULL))), __temp162);
			__temp163 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp163 = vala_ccode_identifier_new ("self"))));
			(__temp163 == NULL ? NULL : (__temp163 = (g_object_unref (__temp163), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			__temp164 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp164 = vala_property_get_canonical_cconstant (prop))));
			(__temp164 = (g_object_unref (__temp164), NULL));
			__temp165 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp165 = vala_ccode_identifier_new ("value"))));
			(__temp165 == NULL ? NULL : (__temp165 = (g_object_unref (__temp165), NULL)));
			__temp166 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp166 = vala_ccode_constant_new ("NULL"))));
			(__temp166 == NULL ? NULL : (__temp166 = (g_object_unref (__temp166), NULL)));
			__temp167 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp167 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp167 == NULL ? NULL : (__temp167 = (g_object_unref (__temp167), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* prefix;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL);
		if (is_virtual) {
			char* __temp168;
			__temp168 = NULL;
			prefix = (__temp168 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp168);
		}
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp171;
			char* __temp170;
			char* __temp169;
			__temp171 = NULL;
			__temp170 = NULL;
			__temp169 = NULL;
			self->priv->function = (__temp171 = vala_ccode_function_new ((__temp169 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))), (__temp170 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp171);
			(__temp170 = (g_free (__temp170), NULL));
			(__temp169 = (g_free (__temp169), NULL));
		} else {
			ValaCCodeFunction* __temp173;
			char* __temp172;
			__temp173 = NULL;
			__temp172 = NULL;
			self->priv->function = (__temp173 = vala_ccode_function_new ((__temp172 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp173);
			(__temp172 = (g_free (__temp172), NULL));
		}
		if (is_virtual) {
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!is_virtual) {
			if (t->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* __temp174;
				__temp174 = NULL;
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp174 = vala_ccode_function_copy (self->priv->function))));
				(__temp174 = (g_object_unref (__temp174), NULL));
			} else {
				ValaCCodeFunction* __temp175;
				vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
				__temp175 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp175 = vala_ccode_function_copy (self->priv->function))));
				(__temp175 = (g_object_unref (__temp175), NULL));
			}
		}
		if (vala_property_accessor_get_body (acc) != NULL) {
			ValaCCodeStatement* __temp176;
			vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_property_accessor_get_body (acc)))));
			__temp176 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp176 = vala_code_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(__temp176 == NULL ? NULL : (__temp176 = (g_object_unref (__temp176), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(prefix = (g_free (prefix), NULL));
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaCodeGenerator * self;
	ValaClass* __temp177;
	ValaClass* cl;
	ValaCCodeFunction* __temp180;
	char* __temp179;
	char* __temp178;
	ValaCCodeFormalParameter* __temp181;
	ValaCCodeFormalParameter* __temp182;
	ValaCCodeFormalParameter* __temp183;
	ValaCCodeFunction* __temp184;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp185;
	ValaCCodeDeclaration* __temp188;
	char* __temp187;
	char* __temp186;
	ValaCCodeVariableDeclarator* __temp189;
	ValaCCodeDeclaration* __temp190;
	ValaCCodeVariableDeclarator* __temp191;
	ValaCCodeIdentifier* __temp192;
	ValaCCodeFunctionCall* __temp193;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp195;
	char* __temp194;
	ValaCCodeIdentifier* __temp198;
	char* __temp197;
	char* __temp196;
	ValaCCodeFunctionCall* __temp199;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* __temp202;
	ValaCCodeAssignment* __temp201;
	ValaCCodeIdentifier* __temp200;
	ValaCCodeFunctionCall* __temp204;
	ValaCCodeIdentifier* __temp203;
	ValaCCodeIdentifier* __temp205;
	ValaCCodeFunctionCall* __temp207;
	ValaCCodeIdentifier* __temp206;
	ValaCCodeExpressionStatement* __temp210;
	ValaCCodeAssignment* __temp209;
	ValaCCodeIdentifier* __temp208;
	ValaCCodeFunctionCall* __temp213;
	ValaCCodeMemberAccess* __temp212;
	ValaCCodeIdentifier* __temp211;
	ValaCCodeIdentifier* __temp214;
	ValaCCodeIdentifier* __temp215;
	ValaCCodeIdentifier* __temp216;
	ValaCCodeExpressionStatement* __temp219;
	ValaCCodeAssignment* __temp218;
	ValaCCodeIdentifier* __temp217;
	ValaCCodeFunctionCall* __temp222;
	ValaCCodeIdentifier* __temp221;
	char* __temp220;
	ValaCCodeIdentifier* __temp223;
	ValaCCodeDeclaration* __temp226;
	char* __temp225;
	char* __temp224;
	ValaCCodeVariableDeclarator* __temp227;
	ValaCCodeReturnStatement* __temp231;
	ValaCCodeIdentifier* __temp230;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	self->priv->current_method_inner_error = FALSE;
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	__temp177 = NULL;
	cl = (__temp177 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) c))), (__temp177 == NULL ? NULL : g_object_ref (__temp177)));
	__temp180 = NULL;
	__temp179 = NULL;
	__temp178 = NULL;
	self->priv->function = (__temp180 = vala_ccode_function_new ((__temp179 = g_strdup_printf ("%s_constructor", (__temp178 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "GObject *"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp180);
	(__temp179 = (g_free (__temp179), NULL));
	(__temp178 = (g_free (__temp178), NULL));
	vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC);
	__temp181 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp181 = vala_ccode_formal_parameter_new ("type", "GType")));
	(__temp181 == NULL ? NULL : (__temp181 = (g_object_unref (__temp181), NULL)));
	__temp182 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp182 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
	(__temp182 == NULL ? NULL : (__temp182 = (g_object_unref (__temp182), NULL)));
	__temp183 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp183 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
	(__temp183 == NULL ? NULL : (__temp183 = (g_object_unref (__temp183), NULL)));
	__temp184 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp184 = vala_ccode_function_copy (self->priv->function))));
	(__temp184 = (g_object_unref (__temp184), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GObject *");
	__temp185 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp185 = vala_ccode_variable_declarator_new ("obj"))));
	(__temp185 == NULL ? NULL : (__temp185 = (g_object_unref (__temp185), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp188 = NULL;
	__temp187 = NULL;
	__temp186 = NULL;
	cdecl_ = (__temp188 = vala_ccode_declaration_new ((__temp187 = g_strdup_printf ("%sClass *", (__temp186 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp188);
	(__temp187 = (g_free (__temp187), NULL));
	(__temp186 = (g_free (__temp186), NULL));
	__temp189 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp189 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp189 == NULL ? NULL : (__temp189 = (g_object_unref (__temp189), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp190 = NULL;
	cdecl_ = (__temp190 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp190);
	__temp191 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp191 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp191 == NULL ? NULL : (__temp191 = (g_object_unref (__temp191), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp192 = NULL;
	__temp193 = NULL;
	ccall = (__temp193 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp192 = vala_ccode_identifier_new ("g_type_class_peek")))), (__temp192 == NULL ? NULL : (__temp192 = (g_object_unref (__temp192), NULL))), __temp193);
	__temp195 = NULL;
	__temp194 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp195 = vala_ccode_identifier_new ((__temp194 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))))));
	(__temp195 == NULL ? NULL : (__temp195 = (g_object_unref (__temp195), NULL)));
	(__temp194 = (g_free (__temp194), NULL));
	__temp198 = NULL;
	__temp197 = NULL;
	__temp196 = NULL;
	__temp199 = NULL;
	ccast = (__temp199 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp198 = vala_ccode_identifier_new ((__temp197 = g_strdup_printf ("%s_CLASS", (__temp196 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (__temp198 == NULL ? NULL : (__temp198 = (g_object_unref (__temp198), NULL))), (__temp197 = (g_free (__temp197), NULL)), (__temp196 = (g_free (__temp196), NULL)), __temp199);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp202 = NULL;
	__temp201 = NULL;
	__temp200 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp202 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp201 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp200 = vala_ccode_identifier_new ("klass"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp202 == NULL ? NULL : (__temp202 = (g_object_unref (__temp202), NULL)));
	(__temp201 == NULL ? NULL : (__temp201 = (g_object_unref (__temp201), NULL)));
	(__temp200 == NULL ? NULL : (__temp200 = (g_object_unref (__temp200), NULL)));
	__temp204 = NULL;
	__temp203 = NULL;
	ccall = (__temp204 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp203 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp204);
	(__temp203 == NULL ? NULL : (__temp203 = (g_object_unref (__temp203), NULL)));
	__temp205 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp205 = vala_ccode_identifier_new ("klass"))));
	(__temp205 == NULL ? NULL : (__temp205 = (g_object_unref (__temp205), NULL)));
	__temp207 = NULL;
	__temp206 = NULL;
	ccast = (__temp207 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp206 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp207);
	(__temp206 == NULL ? NULL : (__temp206 = (g_object_unref (__temp206), NULL)));
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp210 = NULL;
	__temp209 = NULL;
	__temp208 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp210 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp209 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp208 = vala_ccode_identifier_new ("parent_class"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp210 == NULL ? NULL : (__temp210 = (g_object_unref (__temp210), NULL)));
	(__temp209 == NULL ? NULL : (__temp209 = (g_object_unref (__temp209), NULL)));
	(__temp208 == NULL ? NULL : (__temp208 = (g_object_unref (__temp208), NULL)));
	__temp213 = NULL;
	__temp212 = NULL;
	__temp211 = NULL;
	ccall = (__temp213 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp212 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp211 = vala_ccode_identifier_new ("parent_class"))), "constructor")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp213);
	(__temp212 == NULL ? NULL : (__temp212 = (g_object_unref (__temp212), NULL)));
	(__temp211 == NULL ? NULL : (__temp211 = (g_object_unref (__temp211), NULL)));
	__temp214 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp214 = vala_ccode_identifier_new ("type"))));
	(__temp214 == NULL ? NULL : (__temp214 = (g_object_unref (__temp214), NULL)));
	__temp215 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp215 = vala_ccode_identifier_new ("n_construct_properties"))));
	(__temp215 == NULL ? NULL : (__temp215 = (g_object_unref (__temp215), NULL)));
	__temp216 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp216 = vala_ccode_identifier_new ("construct_properties"))));
	(__temp216 == NULL ? NULL : (__temp216 = (g_object_unref (__temp216), NULL)));
	__temp219 = NULL;
	__temp218 = NULL;
	__temp217 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp219 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp218 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp217 = vala_ccode_identifier_new ("obj"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp219 == NULL ? NULL : (__temp219 = (g_object_unref (__temp219), NULL)));
	(__temp218 == NULL ? NULL : (__temp218 = (g_object_unref (__temp218), NULL)));
	(__temp217 == NULL ? NULL : (__temp217 = (g_object_unref (__temp217), NULL)));
	__temp222 = NULL;
	__temp221 = NULL;
	__temp220 = NULL;
	ccall = (__temp222 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp221 = vala_ccode_identifier_new ((__temp220 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp222);
	(__temp221 == NULL ? NULL : (__temp221 = (g_object_unref (__temp221), NULL)));
	(__temp220 = (g_free (__temp220), NULL));
	__temp223 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp223 = vala_ccode_identifier_new ("obj"))));
	(__temp223 == NULL ? NULL : (__temp223 = (g_object_unref (__temp223), NULL)));
	__temp226 = NULL;
	__temp225 = NULL;
	__temp224 = NULL;
	cdecl_ = (__temp226 = vala_ccode_declaration_new ((__temp225 = g_strdup_printf ("%s *", (__temp224 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp226);
	(__temp225 = (g_free (__temp225), NULL));
	(__temp224 = (g_free (__temp224), NULL));
	__temp227 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp227 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp227 == NULL ? NULL : (__temp227 = (g_object_unref (__temp227), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (self->priv->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* __temp229;
		ValaCCodeConstant* __temp228;
		/* always separate error parameter and inner_error local variable
		 * as error may be set to NULL but we're always interested in inner errors
		 */
		cdecl_ = vala_ccode_declaration_new ("GError *");
		__temp229 = NULL;
		__temp228 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp229 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((__temp228 = vala_ccode_constant_new ("NULL")))))));
		(__temp229 == NULL ? NULL : (__temp229 = (g_object_unref (__temp229), NULL)));
		(__temp228 == NULL ? NULL : (__temp228 = (g_object_unref (__temp228), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	}
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_constructor_get_body (c))));
	__temp231 = NULL;
	__temp230 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp231 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((__temp230 = vala_ccode_identifier_new ("obj")))))));
	(__temp231 == NULL ? NULL : (__temp231 = (g_object_unref (__temp231), NULL)));
	(__temp230 == NULL ? NULL : (__temp230 = (g_object_unref (__temp230), NULL)));
	vala_ccode_function_set_block (self->priv->function, cblock);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) c))) != NULL) {
		ValaCCodeComment* __temp232;
		__temp232 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp232 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) c)))))));
		(__temp232 == NULL ? NULL : (__temp232 = (g_object_unref (__temp232), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp233;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	__temp233 = NULL;
	self->priv->current_symbol = (__temp233 = VALA_SYMBOL (g_object_ref (b)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp233);
}


static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	GeeCollection* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* __temp241;
	ValaSymbol* __temp240;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				vala_symbol_set_active (VALA_SYMBOL (decl), FALSE);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	{
		GeeCollection* stmt_collection;
		GeeIterator* stmt_it;
		stmt_collection = vala_block_get_statements (b);
		stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
		while (gee_iterator_next (stmt_it)) {
			ValaCodeNode* stmt;
			stmt = gee_iterator_get (stmt_it);
			{
				ValaSourceReference* __temp234;
				ValaSourceReference* src;
				__temp234 = NULL;
				src = (__temp234 = vala_code_node_get_source_reference (stmt), (__temp234 == NULL ? NULL : g_object_ref (__temp234)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* __temp235;
					__temp235 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp235 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(__temp235 == NULL ? NULL : (__temp235 = (g_object_unref (__temp235), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
					{
						GeeCollection* cstmt_collection;
						GeeIterator* cstmt_it;
						cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
						cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
						while (gee_iterator_next (cstmt_it)) {
							ValaCCodeStatement* cstmt;
							cstmt = gee_iterator_get (cstmt_it);
							{
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
								(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
							}
						}
						(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
						(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
				}
				(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
		(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GeeCollection* decl_collection;
			GeeIterator* decl_it;
			decl_collection = local_vars;
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaVariableDeclarator* decl;
				decl = gee_iterator_get (decl_it);
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* __temp239;
						ValaCCodeExpression* __temp238;
						ValaCCodeIdentifier* __temp237;
						char* __temp236;
						ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
						vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
						__temp239 = NULL;
						__temp238 = NULL;
						__temp237 = NULL;
						__temp236 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp239 = vala_ccode_expression_statement_new ((__temp238 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp237 = vala_ccode_identifier_new ((__temp236 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
						(__temp239 == NULL ? NULL : (__temp239 = (g_object_unref (__temp239), NULL)));
						(__temp238 == NULL ? NULL : (__temp238 = (g_object_unref (__temp238), NULL)));
						(__temp237 == NULL ? NULL : (__temp237 = (g_object_unref (__temp237), NULL)));
						(__temp236 = (g_free (__temp236), NULL));
						(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					}
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				}
			}
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock));
	__temp241 = NULL;
	__temp240 = NULL;
	self->priv->current_symbol = (__temp241 = (__temp240 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp240 == NULL ? NULL : g_object_ref (__temp240))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp241);
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeEmptyStatement* __temp242;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_EMPTY_STATEMENT (stmt));
	__temp242 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp242 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL))));
	(__temp242 == NULL ? NULL : (__temp242 = (g_object_unref (__temp242), NULL)));
}


static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_STRUCT (st), FALSE);
	{
		GeeCollection* f_collection;
		GeeIterator* f_it;
		f_collection = vala_struct_get_fields (st);
		f_it = gee_iterable_iterator (GEE_ITERABLE (f_collection));
		while (gee_iterator_next (f_it)) {
			ValaField* f;
			f = gee_iterator_get (f_it);
			{
				if (vala_field_get_instance (f)) {
					gboolean __temp243;
					return (__temp243 = TRUE, (f == NULL ? NULL : (f = (g_object_unref (f), NULL))), (f_collection == NULL ? NULL : (f_collection = (g_object_unref (f_collection), NULL))), (f_it == NULL ? NULL : (f_it = (g_object_unref (f_it), NULL))), __temp243);
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			}
		}
		(f_collection == NULL ? NULL : (f_collection = (g_object_unref (f_collection), NULL)));
		(f_it == NULL ? NULL : (f_it = (g_object_unref (f_it), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (stmt));
	/* split declaration statement as var declarators
	 * might have different types */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				char* __temp245;
				ValaCCodeDeclaration* __temp246;
				ValaCCodeDeclaration* cdecl_;
				__temp245 = NULL;
				__temp246 = NULL;
				cdecl_ = (__temp246 = vala_ccode_declaration_new ((__temp245 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))))), (__temp245 = (g_free (__temp245), NULL)), __temp246);
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (((ValaCodeNode*) decl)))));
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				if (vala_variable_declarator_get_initializer (decl) != NULL && vala_expression_get_can_fail (vala_variable_declarator_get_initializer (decl))) {
					vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)), cfrag);
				}
				/* try to initialize uninitialized variables */
				if (vala_variable_declarator_get_initializer (decl) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
						ValaCCodeConstant* __temp247;
						__temp247 = NULL;
						vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (((ValaCodeNode*) decl)))), VALA_CCODE_EXPRESSION ((__temp247 = vala_ccode_constant_new ("NULL"))));
						(__temp247 == NULL ? NULL : (__temp247 = (g_object_unref (__temp247), NULL)));
					} else {
						char* __temp248;
						gboolean __temp249;
						__temp248 = NULL;
						if ((__temp249 = (__temp248 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) != NULL, (__temp248 = (g_free (__temp248), NULL)), __temp249)) {
							ValaCCodeConstant* __temp251;
							char* __temp250;
							__temp251 = NULL;
							__temp250 = NULL;
							vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (((ValaCodeNode*) decl)))), VALA_CCODE_EXPRESSION ((__temp251 = vala_ccode_constant_new ((__temp250 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))))));
							(__temp251 == NULL ? NULL : (__temp251 = (g_object_unref (__temp251), NULL)));
							(__temp250 = (g_free (__temp250), NULL));
						} else {
							if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_code_generator_struct_has_instance_fields (self, VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))) {
								ValaStruct* __temp252;
								ValaStruct* st;
								ValaCCodeIdentifier* __temp253;
								ValaCCodeFunctionCall* __temp254;
								ValaCCodeFunctionCall* czero;
								ValaCCodeUnaryExpression* __temp257;
								ValaCCodeIdentifier* __temp256;
								char* __temp255;
								ValaCCodeConstant* __temp258;
								ValaCCodeIdentifier* __temp261;
								char* __temp260;
								char* __temp259;
								ValaCCodeExpressionStatement* __temp262;
								__temp252 = NULL;
								st = (__temp252 = VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp252 == NULL ? NULL : g_object_ref (__temp252)));
								/* memset needs string.h */
								self->priv->string_h_needed = TRUE;
								__temp253 = NULL;
								__temp254 = NULL;
								czero = (__temp254 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp253 = vala_ccode_identifier_new ("memset")))), (__temp253 == NULL ? NULL : (__temp253 = (g_object_unref (__temp253), NULL))), __temp254);
								__temp257 = NULL;
								__temp256 = NULL;
								__temp255 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp257 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp256 = vala_ccode_identifier_new ((__temp255 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)))))))))));
								(__temp257 == NULL ? NULL : (__temp257 = (g_object_unref (__temp257), NULL)));
								(__temp256 == NULL ? NULL : (__temp256 = (g_object_unref (__temp256), NULL)));
								(__temp255 = (g_free (__temp255), NULL));
								__temp258 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp258 = vala_ccode_constant_new ("0"))));
								(__temp258 == NULL ? NULL : (__temp258 = (g_object_unref (__temp258), NULL)));
								__temp261 = NULL;
								__temp260 = NULL;
								__temp259 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp261 = vala_ccode_identifier_new ((__temp260 = g_strdup_printf ("sizeof (%s)", (__temp259 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, FALSE))))))));
								(__temp261 == NULL ? NULL : (__temp261 = (g_object_unref (__temp261), NULL)));
								(__temp260 = (g_free (__temp260), NULL));
								(__temp259 = (g_free (__temp259), NULL));
								__temp262 = NULL;
								vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp262 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(__temp262 == NULL ? NULL : (__temp262 = (g_object_unref (__temp262), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							} else {
								char* __temp264;
								char* __temp263;
								__temp264 = NULL;
								__temp263 = NULL;
								vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) decl)), (__temp264 = g_strdup_printf ("unable to initialize a variable of type `%s'", (__temp263 = vala_symbol_get_full_name (VALA_SYMBOL (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))))));
								(__temp264 = (g_free (__temp264), NULL));
								(__temp263 = (g_free (__temp263), NULL));
							}
						}
					}
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_variable_declarator_get_initializer (decl) != NULL) {
					vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_variable_declarator_get_initializer (decl)->temp_vars));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (self->priv->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (gee_collection_contains (GEE_COLLECTION (self->priv->c_keywords), name)) {
		return g_strconcat (name, "_", NULL);
	} else {
		return g_strdup (name);
	}
}


static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* rhs;
	ValaCCodeVariableDeclarator* __temp285;
	char* __temp284;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (decl));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
		ValaArray* __temp267;
		ValaArray* arr;
		/* create variables to store array dimensions*/
		__temp267 = NULL;
		arr = (__temp267 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp267 == NULL ? NULL : g_object_ref (__temp267)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				char* __temp268;
				ValaVariableDeclarator* __temp269;
				ValaVariableDeclarator* len_decl;
				ValaTypeReference* __temp270;
				__temp268 = NULL;
				__temp269 = NULL;
				len_decl = (__temp269 = vala_variable_declarator_new ((__temp268 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)), dim)), NULL, NULL), (__temp268 = (g_free (__temp268), NULL)), __temp269);
				__temp270 = NULL;
				vala_variable_declarator_set_type_reference (len_decl, (__temp270 = vala_type_reference_new ()));
				(__temp270 == NULL ? NULL : (__temp270 = (g_object_unref (__temp270), NULL)));
				vala_type_reference_set_data_type (vala_variable_declarator_get_type_reference (len_decl), vala_type_reference_get_data_type (self->priv->int_type));
				gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, len_decl);
				(len_decl == NULL ? NULL : (len_decl = (g_object_unref (len_decl), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	rhs = NULL;
	if (vala_variable_declarator_get_initializer (decl) != NULL) {
		ValaCCodeExpression* __temp272;
		ValaCCodeExpression* __temp271;
		__temp272 = NULL;
		__temp271 = NULL;
		rhs = (__temp272 = (__temp271 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_variable_declarator_get_initializer (decl)))), (__temp271 == NULL ? NULL : g_object_ref (__temp271))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp272);
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) {
			ValaCCodeExpression* __temp273;
			/* FIXME: use C cast if debugging disabled*/
			__temp273 = NULL;
			rhs = (__temp273 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp273);
		}
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaArray* __temp274;
			ValaArray* arr;
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaCCodeAssignment* __temp276;
			ValaCCodeIdentifier* __temp275;
			ValaCCodeIdentifier* __temp280;
			ValaCCodeExpression* __temp282;
			ValaCCodeCommaExpression* __temp281;
			__temp274 = NULL;
			arr = (__temp274 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp274 == NULL ? NULL : g_object_ref (__temp274)));
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE);
			gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
			__temp276 = NULL;
			__temp275 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp276 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp275 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp276 == NULL ? NULL : (__temp276 = (g_object_unref (__temp276), NULL)));
			(__temp275 == NULL ? NULL : (__temp275 = (g_object_unref (__temp275), NULL)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					char* __temp277;
					ValaCCodeIdentifier* __temp278;
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* __temp279;
					__temp277 = NULL;
					__temp278 = NULL;
					lhs_array_len = (__temp278 = vala_ccode_identifier_new ((__temp277 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)), dim))), (__temp277 = (g_free (__temp277), NULL)), __temp278);
					rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_variable_declarator_get_initializer (decl), dim);
					__temp279 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp279 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp279 == NULL ? NULL : (__temp279 = (g_object_unref (__temp279), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
				}
			}
			__temp280 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp280 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
			(__temp280 == NULL ? NULL : (__temp280 = (g_object_unref (__temp280), NULL)));
			__temp282 = NULL;
			__temp281 = NULL;
			rhs = (__temp282 = VALA_CCODE_EXPRESSION ((__temp281 = ccomma, (__temp281 == NULL ? NULL : g_object_ref (__temp281)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp282);
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		}
	} else {
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeExpression* __temp283;
			__temp283 = NULL;
			rhs = (__temp283 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp283);
		}
	}
	__temp285 = NULL;
	__temp284 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE ((__temp285 = vala_ccode_variable_declarator_new_with_initializer ((__temp284 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)))), rhs))));
	(__temp285 == NULL ? NULL : (__temp285 = (g_object_unref (__temp285), NULL)));
	(__temp284 = (g_free (__temp284), NULL));
	vala_symbol_set_active (VALA_SYMBOL (decl), TRUE);
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	if (vala_expression_get_expected_type (((ValaExpression*) list)) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_expected_type (((ValaExpression*) list))))) {
	} else {
		ValaCCodeInitializerList* clist;
		/* TODO */
		clist = g_object_new (VALA_TYPE_CCODE_INITIALIZER_LIST, NULL);
		{
			GeeCollection* expr_collection;
			GeeIterator* expr_it;
			expr_collection = vala_initializer_list_get_initializers (list);
			expr_it = gee_iterable_iterator (GEE_ITERABLE (expr_collection));
			while (gee_iterator_next (expr_it)) {
				ValaExpression* expr;
				expr = gee_iterator_get (expr_it);
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
					(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				}
			}
			(expr_collection == NULL ? NULL : (expr_collection = (g_object_unref (expr_collection), NULL)));
			(expr_it == NULL ? NULL : (expr_it = (g_object_unref (expr_it), NULL)));
		}
		vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist));
		(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	}
}


static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership)
{
	char* __temp286;
	ValaVariableDeclarator* __temp287;
	ValaVariableDeclarator* decl;
	ValaTypeReference* __temp288;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	__temp286 = NULL;
	__temp287 = NULL;
	decl = (__temp287 = vala_variable_declarator_new ((__temp286 = g_strdup_printf ("__temp%d", self->priv->next_temp_var_id)), NULL, NULL), (__temp286 = (g_free (__temp286), NULL)), __temp287);
	__temp288 = NULL;
	vala_variable_declarator_set_type_reference (decl, (__temp288 = vala_type_reference_copy (type)));
	(__temp288 = (g_object_unref (__temp288), NULL));
	vala_type_reference_set_is_ref (vala_variable_declarator_get_type_reference (decl), FALSE);
	vala_type_reference_set_is_out (vala_variable_declarator_get_type_reference (decl), FALSE);
	vala_type_reference_set_takes_ownership (vala_variable_declarator_get_type_reference (decl), takes_ownership);
	self->priv->next_temp_var_id++;
	return decl;
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_dup_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* dup_function;
		ValaCCodeIdentifier* __temp293;
		dup_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* __temp290;
			__temp290 = NULL;
			dup_function = (__temp290 = vala_data_type_get_ref_function (vala_type_reference_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), __temp290);
		} else {
			char* __temp292;
			if (vala_type_reference_get_data_type (type) != vala_type_reference_get_data_type (self->priv->string_type)) {
				char* __temp291;
				/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
				__temp291 = NULL;
				vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp291 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_symbol_get_name (((ValaSymbol*) vala_type_reference_get_data_type (type))))));
				(__temp291 = (g_free (__temp291), NULL));
			}
			__temp292 = NULL;
			dup_function = (__temp292 = vala_data_type_get_dup_function (vala_type_reference_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), __temp292);
		}
		__temp293 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp293 = vala_ccode_identifier_new (dup_function), (dup_function = (g_free (dup_function), NULL)), __temp293));
		(dup_function = (g_free (dup_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->priv->current_type_symbol)) {
			char* __temp294;
			char* __temp295;
			char* func_name;
			ValaCCodeMemberAccess* __temp297;
			ValaCCodeIdentifier* __temp296;
			ValaCCodeMemberAccess* __temp298;
			ValaCCodeMemberAccess* __temp299;
			__temp294 = NULL;
			__temp295 = NULL;
			func_name = (__temp295 = g_strdup_printf ("%s_dup_func", (__temp294 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) vala_type_reference_get_type_parameter (type))), -1))), (__temp294 = (g_free (__temp294), NULL)), __temp295);
			__temp297 = NULL;
			__temp296 = NULL;
			__temp298 = NULL;
			__temp299 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp299 = (__temp298 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp297 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp296 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (__temp297 == NULL ? NULL : (__temp297 = (g_object_unref (__temp297), NULL))), (__temp296 == NULL ? NULL : (__temp296 = (g_object_unref (__temp296), NULL))), __temp298), (func_name = (g_free (func_name), NULL)), __temp299));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* unref_function;
		ValaCCodeIdentifier* __temp303;
		unref_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* __temp301;
			__temp301 = NULL;
			unref_function = (__temp301 = vala_data_type_get_unref_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp301);
		} else {
			char* __temp302;
			__temp302 = NULL;
			unref_function = (__temp302 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp302);
		}
		__temp303 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp303 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), __temp303));
		(unref_function = (g_free (unref_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->priv->current_type_symbol)) {
			char* __temp304;
			char* __temp305;
			char* func_name;
			ValaCCodeMemberAccess* __temp307;
			ValaCCodeIdentifier* __temp306;
			ValaCCodeMemberAccess* __temp308;
			ValaCCodeMemberAccess* __temp309;
			__temp304 = NULL;
			__temp305 = NULL;
			func_name = (__temp305 = g_strdup_printf ("%s_destroy_func", (__temp304 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) vala_type_reference_get_type_parameter (type))), -1))), (__temp304 = (g_free (__temp304), NULL)), __temp305);
			__temp307 = NULL;
			__temp306 = NULL;
			__temp308 = NULL;
			__temp309 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp309 = (__temp308 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp307 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp306 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (__temp307 == NULL ? NULL : (__temp307 = (g_object_unref (__temp307), NULL))), (__temp306 == NULL ? NULL : (__temp306 = (g_object_unref (__temp306), NULL))), __temp308), (func_name = (g_free (func_name), NULL)), __temp309));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type, ValaExpression* expr)
{
	ValaCCodeConstant* __temp312;
	ValaCCodeBinaryExpression* __temp313;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeExpression* __temp319;
	ValaCCodeFunctionCall* __temp320;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* __temp335;
	ValaCCodeAssignment* cassign;
	char* __temp336;
	gboolean __temp337;
	ValaCCodeParenthesizedExpression* __temp340;
	ValaCCodeConstant* __temp339;
	ValaCCodeConditionalExpression* __temp341;
	ValaCCodeConditionalExpression* __temp342;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	if (vala_type_reference_get_is_null (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
	__temp312 = NULL;
	__temp313 = NULL;
	cisnull = (__temp313 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION ((__temp312 = vala_ccode_constant_new ("NULL")))), (__temp312 == NULL ? NULL : (__temp312 = (g_object_unref (__temp312), NULL))), __temp313);
	if (vala_type_reference_get_data_type (type) == NULL) {
		ValaCCodeConstant* __temp316;
		ValaCCodeExpression* __temp315;
		ValaCCodeBinaryExpression* __temp317;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* __temp318;
		if (!(VALA_IS_CLASS (self->priv->current_type_symbol))) {
			ValaCCodeConstant* __temp314;
			__temp314 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp314 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp314));
		}
		/* unref functions are optional for type parameters*/
		__temp316 = NULL;
		__temp315 = NULL;
		__temp317 = NULL;
		cunrefisnull = (__temp317 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (__temp315 = vala_code_generator_get_destroy_func_expression (self, type)), VALA_CCODE_EXPRESSION ((__temp316 = vala_ccode_constant_new ("NULL")))), (__temp316 == NULL ? NULL : (__temp316 = (g_object_unref (__temp316), NULL))), (__temp315 == NULL ? NULL : (__temp315 = (g_object_unref (__temp315), NULL))), __temp317);
		__temp318 = NULL;
		cisnull = (__temp318 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp318);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	__temp319 = NULL;
	__temp320 = NULL;
	ccall = (__temp320 = vala_ccode_function_call_new ((__temp319 = vala_code_generator_get_destroy_func_expression (self, type))), (__temp319 == NULL ? NULL : (__temp319 = (g_object_unref (__temp319), NULL))), __temp320);
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	if (vala_type_reference_get_data_type (type) == self->priv->glist_type) {
		gboolean is_ref;
		gboolean is_class;
		gboolean is_interface;
		is_ref = FALSE;
		is_class = FALSE;
		is_interface = FALSE;
		{
			GeeList* type_arg_collection;
			GeeIterator* type_arg_it;
			type_arg_collection = vala_type_reference_get_type_arguments (type);
			type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
			while (gee_iterator_next (type_arg_it)) {
				ValaTypeReference* type_arg;
				type_arg = gee_iterator_get (type_arg_it);
				{
					is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
					is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
					is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
			(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
		}
		if (is_ref) {
			ValaCCodeIdentifier* __temp321;
			ValaCCodeFunctionCall* __temp322;
			ValaCCodeFunctionCall* cunrefcall;
			ValaCCodeConstant* __temp325;
			__temp321 = NULL;
			__temp322 = NULL;
			cunrefcall = (__temp322 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp321 = vala_ccode_identifier_new ("g_list_foreach")))), (__temp321 == NULL ? NULL : (__temp321 = (g_object_unref (__temp321), NULL))), __temp322);
			vala_ccode_function_call_add_argument (cunrefcall, cvar);
			if (is_class || is_interface) {
				ValaCCodeIdentifier* __temp323;
				__temp323 = NULL;
				vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp323 = vala_ccode_identifier_new ("(GFunc) g_object_unref"))));
				(__temp323 == NULL ? NULL : (__temp323 = (g_object_unref (__temp323), NULL)));
			} else {
				ValaCCodeIdentifier* __temp324;
				__temp324 = NULL;
				vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp324 = vala_ccode_identifier_new ("(GFunc) g_free"))));
				(__temp324 == NULL ? NULL : (__temp324 = (g_object_unref (__temp324), NULL)));
			}
			__temp325 = NULL;
			vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp325 = vala_ccode_constant_new ("NULL"))));
			(__temp325 == NULL ? NULL : (__temp325 = (g_object_unref (__temp325), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cunrefcall));
			(cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL)));
		}
	} else {
		if (vala_type_reference_get_data_type (type) == self->priv->gstring_type) {
			ValaCCodeConstant* __temp326;
			__temp326 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp326 = vala_ccode_constant_new ("TRUE"))));
			(__temp326 == NULL ? NULL : (__temp326 = (g_object_unref (__temp326), NULL)));
		} else {
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (type))) {
				ValaArray* __temp327;
				ValaArray* arr;
				__temp327 = NULL;
				arr = (__temp327 = VALA_ARRAY (vala_type_reference_get_data_type (type)), (__temp327 == NULL ? NULL : g_object_ref (__temp327)));
				if (vala_array_get_element_type (arr) == vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaCCodeIdentifier* __temp328;
					__temp328 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((__temp328 = vala_ccode_identifier_new ("g_strfreev"))));
					(__temp328 == NULL ? NULL : (__temp328 = (g_object_unref (__temp328), NULL)));
				} else {
					if (vala_array_get_element_type (arr) == NULL || vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
						gboolean first;
						ValaCCodeExpression* csizeexpr;
						ValaCCodeIdentifier* __temp332;
						ValaTypeReference* element_type;
						ValaCCodeCastExpression* __temp334;
						ValaCCodeExpression* __temp333;
						self->priv->requires_array_free = TRUE;
						first = TRUE;
						csizeexpr = NULL;
						{
							gint dim;
							dim = 0;
							for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
								if (first) {
									ValaCCodeExpression* __temp329;
									__temp329 = NULL;
									csizeexpr = (__temp329 = vala_code_generator_get_array_length_cexpression (self, expr, dim), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), __temp329);
									first = FALSE;
								} else {
									ValaCCodeExpression* __temp331;
									ValaCCodeExpression* __temp330;
									__temp331 = NULL;
									__temp330 = NULL;
									csizeexpr = (__temp331 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, (__temp330 = vala_code_generator_get_array_length_cexpression (self, expr, dim)))), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), __temp331);
									(__temp330 = (g_object_unref (__temp330), NULL));
								}
							}
						}
						__temp332 = NULL;
						vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((__temp332 = vala_ccode_identifier_new ("_vala_array_free"))));
						(__temp332 == NULL ? NULL : (__temp332 = (g_object_unref (__temp332), NULL)));
						vala_ccode_function_call_add_argument (ccall, csizeexpr);
						element_type = vala_type_reference_new ();
						vala_type_reference_set_data_type (element_type, vala_array_get_element_type (arr));
						vala_type_reference_set_type_parameter (element_type, vala_array_get_element_type_parameter (arr));
						__temp334 = NULL;
						__temp333 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp334 = vala_ccode_cast_expression_new ((__temp333 = vala_code_generator_get_destroy_func_expression (self, element_type)), "GDestroyNotify"))));
						(__temp334 == NULL ? NULL : (__temp334 = (g_object_unref (__temp334), NULL)));
						(__temp333 == NULL ? NULL : (__temp333 = (g_object_unref (__temp333), NULL)));
						(csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL)));
						(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
					}
				}
				(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			}
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	__temp335 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp335 = vala_ccode_constant_new ("NULL"))));
	(__temp335 == NULL ? NULL : (__temp335 = (g_object_unref (__temp335), NULL)));
	cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	__temp336 = NULL;
	if ((__temp337 = vala_type_reference_get_non_null (type) || (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type)) && g_utf8_collate ((__temp336 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type))), "g_free") == 0), (__temp336 = (g_free (__temp336), NULL)), __temp337)) {
		ValaCCodeParenthesizedExpression* __temp338;
		__temp338 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp338 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp338));
	}
	__temp340 = NULL;
	__temp339 = NULL;
	__temp341 = NULL;
	__temp342 = NULL;
	return VALA_CCODE_EXPRESSION ((__temp342 = (__temp341 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION ((__temp339 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_EXPRESSION ((__temp340 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign))))), (__temp340 == NULL ? NULL : (__temp340 = (g_object_unref (__temp340), NULL))), (__temp339 == NULL ? NULL : (__temp339 = (g_object_unref (__temp339), NULL))), __temp341), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp342));
	(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
}


static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr)
{
	ValaCodeGenerator * self;
	ValaVariableDeclarator* full_expr_decl;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* __temp344;
	ValaCCodeIdentifier* __temp343;
	ValaCCodeIdentifier* __temp347;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
		return;
	}
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear (GEE_COLLECTION (expr->temp_vars));
	{
		GeeArrayList* decl1_collection;
		GeeIterator* decl1_it;
		decl1_collection = self->priv->temp_vars;
		decl1_it = gee_iterable_iterator (GEE_ITERABLE (decl1_collection));
		while (gee_iterator_next (decl1_it)) {
			ValaVariableDeclarator* decl1;
			decl1 = gee_iterator_get (decl1_it);
			{
				gee_collection_add (GEE_COLLECTION (expr->temp_vars), decl1);
				(decl1 == NULL ? NULL : (decl1 = (g_object_unref (decl1), NULL)));
			}
		}
		(decl1_it == NULL ? NULL : (decl1_it = (g_object_unref (decl1_it), NULL)));
	}
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	if (gee_collection_get_size (((GeeCollection*) (GEE_LIST (self->priv->temp_ref_vars)))) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	full_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), full_expr_decl);
	expr_list = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	__temp344 = NULL;
	__temp343 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp344 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp343 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) full_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp344 == NULL ? NULL : (__temp344 = (g_object_unref (__temp344), NULL)));
	(__temp343 == NULL ? NULL : (__temp343 = (g_object_unref (__temp343), NULL)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpression* __temp346;
				ValaCCodeIdentifier* __temp345;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				__temp346 = NULL;
				__temp345 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (__temp346 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp345 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma))));
				(__temp346 == NULL ? NULL : (__temp346 = (g_object_unref (__temp346), NULL)));
				(__temp345 == NULL ? NULL : (__temp345 = (g_object_unref (__temp345), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	__temp347 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp347 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) full_expr_decl))))));
	(__temp347 == NULL ? NULL : (__temp347 = (g_object_unref (__temp347), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	(full_expr_decl == NULL ? NULL : (full_expr_decl = (g_object_unref (full_expr_decl), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	g_return_if_fail (temp_vars == NULL || GEE_IS_COLLECTION (temp_vars));
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = temp_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				char* __temp348;
				ValaCCodeDeclaration* __temp349;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				__temp348 = NULL;
				__temp349 = NULL;
				cdecl_ = (__temp349 = vala_ccode_declaration_new ((__temp348 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), TRUE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))))), (__temp348 = (g_free (__temp348), NULL)), __temp349);
				vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) decl)));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (vardecl));
				if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					ValaCCodeConstant* __temp350;
					__temp350 = NULL;
					vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((__temp350 = vala_ccode_constant_new ("NULL"))));
					(__temp350 == NULL ? NULL : (__temp350 = (g_object_unref (__temp350), NULL)));
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
}


static void vala_code_generator_add_simple_check (ValaCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag)
{
	ValaCCodeFragment* cprint_frag;
	ValaCCodeIdentifier* __temp351;
	ValaCCodeFunctionCall* __temp352;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* __temp353;
	ValaCCodeConstant* __temp354;
	ValaCCodeConstant* __temp355;
	ValaCCodeMemberAccess* __temp357;
	ValaCCodeIdentifier* __temp356;
	ValaCCodeExpressionStatement* __temp358;
	ValaCCodeIdentifier* __temp359;
	ValaCCodeFunctionCall* __temp360;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* __temp362;
	ValaCCodeIdentifier* __temp361;
	ValaCCodeExpressionStatement* __temp363;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_NODE (node));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	cprint_frag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp351 = NULL;
	__temp352 = NULL;
	ccritical = (__temp352 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp351 = vala_ccode_identifier_new ("g_critical")))), (__temp351 == NULL ? NULL : (__temp351 = (g_object_unref (__temp351), NULL))), __temp352);
	__temp353 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp353 = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\""))));
	(__temp353 == NULL ? NULL : (__temp353 = (g_object_unref (__temp353), NULL)));
	__temp354 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp354 = vala_ccode_constant_new ("__FILE__"))));
	(__temp354 == NULL ? NULL : (__temp354 = (g_object_unref (__temp354), NULL)));
	__temp355 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp355 = vala_ccode_constant_new ("__LINE__"))));
	(__temp355 == NULL ? NULL : (__temp355 = (g_object_unref (__temp355), NULL)));
	__temp357 = NULL;
	__temp356 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp357 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp356 = vala_ccode_identifier_new ("inner_error"))), "message"))));
	(__temp357 == NULL ? NULL : (__temp357 = (g_object_unref (__temp357), NULL)));
	(__temp356 == NULL ? NULL : (__temp356 = (g_object_unref (__temp356), NULL)));
	__temp358 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((__temp358 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccritical)))));
	(__temp358 == NULL ? NULL : (__temp358 = (g_object_unref (__temp358), NULL)));
	__temp359 = NULL;
	__temp360 = NULL;
	cclear = (__temp360 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp359 = vala_ccode_identifier_new ("g_clear_error")))), (__temp359 == NULL ? NULL : (__temp359 = (g_object_unref (__temp359), NULL))), __temp360);
	__temp362 = NULL;
	__temp361 = NULL;
	vala_ccode_function_call_add_argument (cclear, VALA_CCODE_EXPRESSION ((__temp362 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp361 = vala_ccode_identifier_new ("inner_error")))))));
	(__temp362 == NULL ? NULL : (__temp362 = (g_object_unref (__temp362), NULL)));
	(__temp361 == NULL ? NULL : (__temp361 = (g_object_unref (__temp361), NULL)));
	__temp363 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((__temp363 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cclear)))));
	(__temp363 == NULL ? NULL : (__temp363 = (g_object_unref (__temp363), NULL)));
	if (self->priv->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeConstant* __temp374;
		ValaCCodeIdentifier* __temp373;
		ValaCCodeBinaryExpression* __temp375;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeIfStatement* __temp376;
		/* surrounding try found
		 TODO might be the wrong one when using nested try statements*/
		cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GeeCollection* clause_collection;
			GeeIterator* clause_it;
			clause_collection = vala_try_statement_get_catch_clauses (self->priv->current_try);
			clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
			while (gee_iterator_next (clause_it)) {
				ValaCatchClause* clause;
				clause = gee_iterator_get (clause_it);
				{
					ValaCCodeIdentifier* __temp367;
					char* __temp366;
					ValaCCodeMemberAccess* __temp365;
					ValaCCodeIdentifier* __temp364;
					ValaCCodeBinaryExpression* __temp368;
					ValaCCodeBinaryExpression* ccond;
					ValaCCodeBlock* cgoto_block;
					ValaCCodeGotoStatement* __temp371;
					char* __temp370;
					char* __temp369;
					ValaCCodeIfStatement* __temp372;
					/* go to catch clause if error domain matches*/
					__temp367 = NULL;
					__temp366 = NULL;
					__temp365 = NULL;
					__temp364 = NULL;
					__temp368 = NULL;
					ccond = (__temp368 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((__temp365 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp364 = vala_ccode_identifier_new ("inner_error"))), "domain"))), VALA_CCODE_EXPRESSION ((__temp367 = vala_ccode_identifier_new ((__temp366 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause)), NULL)))))), (__temp367 == NULL ? NULL : (__temp367 = (g_object_unref (__temp367), NULL))), (__temp366 = (g_free (__temp366), NULL)), (__temp365 == NULL ? NULL : (__temp365 = (g_object_unref (__temp365), NULL))), (__temp364 == NULL ? NULL : (__temp364 = (g_object_unref (__temp364), NULL))), __temp368);
					cgoto_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					__temp371 = NULL;
					__temp370 = NULL;
					__temp369 = NULL;
					vala_ccode_block_add_statement (cgoto_block, VALA_CCODE_NODE ((__temp371 = vala_ccode_goto_statement_new ((__temp370 = g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (__temp369 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause))), NULL))))))));
					(__temp371 == NULL ? NULL : (__temp371 = (g_object_unref (__temp371), NULL)));
					(__temp370 = (g_free (__temp370), NULL));
					(__temp369 = (g_free (__temp369), NULL));
					__temp372 = NULL;
					vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp372 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cgoto_block), NULL))));
					(__temp372 == NULL ? NULL : (__temp372 = (g_object_unref (__temp372), NULL)));
					(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
					(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
					(cgoto_block == NULL ? NULL : (cgoto_block = (g_object_unref (cgoto_block), NULL)));
				}
			}
			(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
			(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
		}
		/* print critical message if no catch clause matches*/
		vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
		/* check error domain if expression failed*/
		__temp374 = NULL;
		__temp373 = NULL;
		__temp375 = NULL;
		ccond = (__temp375 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp373 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((__temp374 = vala_ccode_constant_new ("NULL")))), (__temp374 == NULL ? NULL : (__temp374 = (g_object_unref (__temp374), NULL))), (__temp373 == NULL ? NULL : (__temp373 = (g_object_unref (__temp373), NULL))), __temp375);
		__temp376 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp376 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
		(__temp376 == NULL ? NULL : (__temp376 = (g_object_unref (__temp376), NULL)));
		(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	} else {
		GeeCollection* __temp377;
		gboolean __temp378;
		__temp377 = NULL;
		if ((__temp378 = self->priv->current_method != NULL && gee_collection_get_size ((__temp377 = vala_method_get_error_domains (self->priv->current_method))) > 0, (__temp377 == NULL ? NULL : (__temp377 = (g_object_unref (__temp377), NULL))), __temp378)) {
			ValaCCodeIdentifier* __temp379;
			ValaCCodeFunctionCall* __temp380;
			ValaCCodeFunctionCall* cpropagate;
			ValaCCodeIdentifier* __temp381;
			ValaCCodeIdentifier* __temp382;
			ValaCCodeBlock* cerror_block;
			ValaCCodeExpressionStatement* __temp383;
			ValaCCodeConstant* __temp388;
			ValaCCodeIdentifier* __temp387;
			ValaCCodeBinaryExpression* __temp389;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* __temp390;
			/* current method can fail, propagate error
			 TODO ensure one of the error domains matches*/
			__temp379 = NULL;
			__temp380 = NULL;
			cpropagate = (__temp380 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp379 = vala_ccode_identifier_new ("g_propagate_error")))), (__temp379 == NULL ? NULL : (__temp379 = (g_object_unref (__temp379), NULL))), __temp380);
			__temp381 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((__temp381 = vala_ccode_identifier_new ("error"))));
			(__temp381 == NULL ? NULL : (__temp381 = (g_object_unref (__temp381), NULL)));
			__temp382 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((__temp382 = vala_ccode_identifier_new ("inner_error"))));
			(__temp382 == NULL ? NULL : (__temp382 = (g_object_unref (__temp382), NULL)));
			cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			__temp383 = NULL;
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp383 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cpropagate)))));
			(__temp383 == NULL ? NULL : (__temp383 = (g_object_unref (__temp383), NULL)));
			if (self->priv->current_return_type != NULL && vala_type_reference_get_data_type (self->priv->current_return_type) != NULL) {
				ValaCCodeReturnStatement* __temp385;
				ValaCCodeExpression* __temp384;
				__temp385 = NULL;
				__temp384 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp385 = vala_ccode_return_statement_new ((__temp384 = vala_code_generator_default_value_for_type (self, vala_type_reference_get_data_type (self->priv->current_return_type)))))));
				(__temp385 == NULL ? NULL : (__temp385 = (g_object_unref (__temp385), NULL)));
				(__temp384 == NULL ? NULL : (__temp384 = (g_object_unref (__temp384), NULL)));
			} else {
				ValaCCodeReturnStatement* __temp386;
				__temp386 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp386 = vala_ccode_return_statement_new (NULL))));
				(__temp386 == NULL ? NULL : (__temp386 = (g_object_unref (__temp386), NULL)));
			}
			__temp388 = NULL;
			__temp387 = NULL;
			__temp389 = NULL;
			ccond = (__temp389 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp387 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((__temp388 = vala_ccode_constant_new ("NULL")))), (__temp388 == NULL ? NULL : (__temp388 = (g_object_unref (__temp388), NULL))), (__temp387 == NULL ? NULL : (__temp387 = (g_object_unref (__temp387), NULL))), __temp389);
			__temp390 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp390 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(__temp390 == NULL ? NULL : (__temp390 = (g_object_unref (__temp390), NULL)));
			(cpropagate == NULL ? NULL : (cpropagate = (g_object_unref (cpropagate), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		} else {
			ValaCCodeBlock* cerror_block;
			ValaCCodeConstant* __temp392;
			ValaCCodeIdentifier* __temp391;
			ValaCCodeBinaryExpression* __temp393;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* __temp394;
			/* TODO improve check and move to semantic analyzer*/
			vala_report_warning (vala_code_node_get_source_reference (node), "unhandled error");
			cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			/* print critical message*/
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
			/* check error domain if expression failed*/
			__temp392 = NULL;
			__temp391 = NULL;
			__temp393 = NULL;
			ccond = (__temp393 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp391 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((__temp392 = vala_ccode_constant_new ("NULL")))), (__temp392 == NULL ? NULL : (__temp392 = (g_object_unref (__temp392), NULL))), (__temp391 == NULL ? NULL : (__temp391 = (g_object_unref (__temp391), NULL))), __temp393);
			__temp394 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp394 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(__temp394 == NULL ? NULL : (__temp394 = (g_object_unref (__temp394), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		}
	}
	(cprint_frag == NULL ? NULL : (cprint_frag = (g_object_unref (cprint_frag), NULL)));
	(ccritical == NULL ? NULL : (ccritical = (g_object_unref (ccritical), NULL)));
	(cclear == NULL ? NULL : (cclear = (g_object_unref (cclear), NULL)));
}


static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeExpressionStatement* __temp395;
	ValaCCodeFragment* cfrag;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (stmt));
	__temp395 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp395 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_expression_statement_get_expression (stmt))))))));
	(__temp395 == NULL ? NULL : (__temp395 = (g_object_unref (__temp395), NULL)));
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) stmt)) && vala_expression_get_can_fail (vala_expression_statement_get_expression (stmt))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) stmt)));
		vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)), cfrag);
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (!vala_code_generator_get_memory_management (self)) {
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
		return;
	}
	if (gee_collection_get_size (((GeeCollection*) (GEE_LIST (self->priv->temp_vars)))) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) stmt)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* __temp398;
				ValaCCodeExpression* __temp397;
				ValaCCodeIdentifier* __temp396;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				__temp398 = NULL;
				__temp397 = NULL;
				__temp396 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp398 = vala_ccode_expression_statement_new ((__temp397 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp396 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
				(__temp398 == NULL ? NULL : (__temp398 = (g_object_unref (__temp398), NULL)));
				(__temp397 == NULL ? NULL : (__temp397 = (g_object_unref (__temp397), NULL)));
				(__temp396 == NULL ? NULL : (__temp396 = (g_object_unref (__temp396), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	g_return_if_fail (temp_vars == NULL || GEE_IS_COLLECTION (temp_vars));
	/* declare temporary variables */
	if (gee_collection_get_size (temp_vars) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, temp_vars);
	/* FIXME cast to CodeNode shouldn't be necessary as Statement requires CodeNode*/
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((VALA_CODE_NODE (stmt))));
	vala_code_node_set_ccodenode ((VALA_CODE_NODE (stmt)), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_IF_STATEMENT (stmt));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* __temp399;
		__temp399 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp399 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_false_statement (stmt))))))));
		(__temp399 == NULL ? NULL : (__temp399 = (g_object_unref (__temp399), NULL)));
	} else {
		ValaCCodeIfStatement* __temp400;
		__temp400 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp400 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_true_statement (stmt)))), NULL))));
		(__temp400 == NULL ? NULL : (__temp400 = (g_object_unref (__temp400), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_if_statement_get_condition (stmt)->temp_vars));
}


static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaVariableDeclarator* temp_decl;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeExpressionStatement* __temp401;
	GeeCollection* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE);
	gee_list_insert (GEE_LIST (vala_switch_statement_get_expression (stmt)->temp_vars), 0, temp_decl);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
	cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	cswitchblock = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp401 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((__temp401 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(__temp401 == NULL ? NULL : (__temp401 = (g_object_unref (__temp401), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_switch_statement_get_expression (stmt)->temp_vars));
	default_statements = NULL;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeCollection* section_collection;
		GeeIterator* section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		section_it = gee_iterable_iterator (GEE_ITERABLE (section_collection));
		while (gee_iterator_next (section_it)) {
			ValaSwitchSection* section;
			section = gee_iterator_get (section_it);
			{
				if (vala_switch_section_has_default_label (section)) {
					GeeCollection* __temp402;
					__temp402 = NULL;
					default_statements = (__temp402 = vala_switch_section_get_statements (section), (default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL))), __temp402);
				} else {
					ValaCCodeBinaryExpression* cor;
					ValaCCodeBlock* cblock;
					ValaCCodeConstant* __temp406;
					ValaCCodeDoStatement* __temp407;
					ValaCCodeDoStatement* cdo;
					ValaCCodeIfStatement* cif;
					ValaCCodeIfStatement* __temp411;
					ValaCCodeIfStatement* __temp410;
					cor = NULL;
					{
						GeeCollection* label_collection;
						GeeIterator* label_it;
						label_collection = vala_switch_section_get_labels (section);
						label_it = gee_iterable_iterator (GEE_ITERABLE (label_collection));
						while (gee_iterator_next (label_it)) {
							ValaSwitchLabel* label;
							label = gee_iterator_get (label_it);
							{
								ValaCCodeBinaryExpression* ccmp;
								ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_switch_label_get_expression (label)))));
								if (cor == NULL) {
									ValaCCodeBinaryExpression* __temp404;
									ValaCCodeBinaryExpression* __temp403;
									__temp404 = NULL;
									__temp403 = NULL;
									cor = (__temp404 = (__temp403 = ccmp, (__temp403 == NULL ? NULL : g_object_ref (__temp403))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp404);
								} else {
									ValaCCodeBinaryExpression* __temp405;
									__temp405 = NULL;
									cor = (__temp405 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp405);
								}
								(label == NULL ? NULL : (label = (g_object_unref (label), NULL)));
								(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
							}
						}
						(label_collection == NULL ? NULL : (label_collection = (g_object_unref (label_collection), NULL)));
						(label_it == NULL ? NULL : (label_it = (g_object_unref (label_it), NULL)));
					}
					cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					{
						GeeCollection* body_stmt_collection;
						GeeIterator* body_stmt_it;
						body_stmt_collection = vala_switch_section_get_statements (section);
						body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
						while (gee_iterator_next (body_stmt_it)) {
							ValaCodeNode* body_stmt;
							body_stmt = gee_iterator_get (body_stmt_it);
							{
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
									{
										GeeCollection* cstmt_collection;
										GeeIterator* cstmt_it;
										cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))));
										cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
										while (gee_iterator_next (cstmt_it)) {
											ValaCCodeStatement* cstmt;
											cstmt = gee_iterator_get (cstmt_it);
											{
												vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
												(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
											}
										}
										(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
										(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
									}
								} else {
									vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (body_stmt))));
								}
								(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
							}
						}
						(body_stmt_collection == NULL ? NULL : (body_stmt_collection = (g_object_unref (body_stmt_collection), NULL)));
						(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
					}
					__temp406 = NULL;
					__temp407 = NULL;
					cdo = (__temp407 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((__temp406 = vala_ccode_constant_new ("0")))), (__temp406 == NULL ? NULL : (__temp406 = (g_object_unref (__temp406), NULL))), __temp407);
					cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
					if (coldif != NULL) {
						vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif));
					} else {
						ValaCCodeStatement* __temp409;
						ValaCCodeIfStatement* __temp408;
						__temp409 = NULL;
						__temp408 = NULL;
						ctopstmt = (__temp409 = VALA_CCODE_STATEMENT ((__temp408 = cif, (__temp408 == NULL ? NULL : g_object_ref (__temp408)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp409);
					}
					__temp411 = NULL;
					__temp410 = NULL;
					coldif = (__temp411 = (__temp410 = cif, (__temp410 == NULL ? NULL : g_object_ref (__temp410))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), __temp411);
					(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
					(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
					(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
					(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
				}
				(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (g_object_unref (section_collection), NULL)));
		(section_it == NULL ? NULL : (section_it = (g_object_unref (section_it), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* __temp412;
		ValaCCodeDoStatement* __temp413;
		ValaCCodeDoStatement* cdo;
		cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GeeCollection* body_stmt_collection;
			GeeIterator* body_stmt_it;
			body_stmt_collection = default_statements;
			body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
			while (gee_iterator_next (body_stmt_it)) {
				ValaCodeNode* body_stmt;
				body_stmt = gee_iterator_get (body_stmt_it);
				{
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (body_stmt))));
					(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
				}
			}
			(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
		}
		__temp412 = NULL;
		__temp413 = NULL;
		cdo = (__temp413 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((__temp412 = vala_ccode_constant_new ("0")))), (__temp412 == NULL ? NULL : (__temp412 = (g_object_unref (__temp412), NULL))), __temp413);
		if (coldif == NULL) {
			ValaCCodeStatement* __temp415;
			ValaCCodeDoStatement* __temp414;
			/* there is only one section and that section
			 contains a default label*/
			__temp415 = NULL;
			__temp414 = NULL;
			ctopstmt = (__temp415 = VALA_CCODE_STATEMENT ((__temp414 = cdo, (__temp414 == NULL ? NULL : g_object_ref (__temp414)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp415);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeWhileStatement* __temp416;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (stmt));
	__temp416 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp416 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_while_statement_get_body (stmt))))))));
	(__temp416 == NULL ? NULL : (__temp416 = (g_object_unref (__temp416), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_while_statement_get_condition (stmt)->temp_vars));
}


static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeDoStatement* __temp417;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_DO_STATEMENT (stmt));
	__temp417 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp417 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_do_statement_get_condition (stmt))))))));
	(__temp417 == NULL ? NULL : (__temp417 = (g_object_unref (__temp417), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_do_statement_get_condition (stmt)->temp_vars));
}


static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeForStatement* cfor;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FOR_STATEMENT (stmt));
	cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_for_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_for_statement_get_body (stmt)))));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor));
	{
		GeeCollection* init_expr_collection;
		GeeIterator* init_expr_it;
		init_expr_collection = vala_for_statement_get_initializer (stmt);
		init_expr_it = gee_iterable_iterator (GEE_ITERABLE (init_expr_collection));
		while (gee_iterator_next (init_expr_it)) {
			ValaExpression* init_expr;
			init_expr = gee_iterator_get (init_expr_it);
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) init_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (init_expr->temp_vars));
				(init_expr == NULL ? NULL : (init_expr = (g_object_unref (init_expr), NULL)));
			}
		}
		(init_expr_collection == NULL ? NULL : (init_expr_collection = (g_object_unref (init_expr_collection), NULL)));
		(init_expr_it == NULL ? NULL : (init_expr_it = (g_object_unref (init_expr_it), NULL)));
	}
	{
		GeeCollection* it_expr_collection;
		GeeIterator* it_expr_it;
		it_expr_collection = vala_for_statement_get_iterator (stmt);
		it_expr_it = gee_iterable_iterator (GEE_ITERABLE (it_expr_collection));
		while (gee_iterator_next (it_expr_it)) {
			ValaExpression* it_expr;
			it_expr = gee_iterator_get (it_expr_it);
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) it_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (it_expr->temp_vars));
				(it_expr == NULL ? NULL : (it_expr = (g_object_unref (it_expr), NULL)));
			}
		}
		(it_expr_collection == NULL ? NULL : (it_expr_collection = (g_object_unref (it_expr_collection), NULL)));
		(it_expr_it == NULL ? NULL : (it_expr_it = (g_object_unref (it_expr_it), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_for_statement_get_condition (stmt)->temp_vars));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_code_generator_real_visit_begin_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_variable_declarator (stmt)), TRUE);
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_collection_variable_declarator (stmt)), TRUE);
	if (vala_foreach_statement_get_iterator_variable_declarator (stmt) != NULL) {
		vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_iterator_variable_declarator (stmt)), TRUE);
	}
}


static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBlock* cblock;
	ValaCCodeForStatement* cfor;
	ValaCCodeFragment* cfrag;
	ValaVariableDeclarator* __temp418;
	ValaVariableDeclarator* collection_backup;
	char* __temp419;
	ValaCCodeDeclaration* __temp420;
	ValaCCodeDeclaration* ccoldecl;
	ValaCCodeVariableDeclarator* __temp421;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cfor = NULL;
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (vala_foreach_statement_get_collection (stmt)->temp_vars));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	__temp418 = NULL;
	collection_backup = (__temp418 = vala_foreach_statement_get_collection_variable_declarator (stmt), (__temp418 == NULL ? NULL : g_object_ref (__temp418)));
	__temp419 = NULL;
	__temp420 = NULL;
	ccoldecl = (__temp420 = vala_ccode_declaration_new ((__temp419 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (collection_backup), FALSE, FALSE))), (__temp419 = (g_free (__temp419), NULL)), __temp420);
	__temp421 = NULL;
	vala_ccode_declaration_add_declarator (ccoldecl, VALA_CCODE_DECLARATOR ((__temp421 = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name (((ValaSymbol*) collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))))))));
	(__temp421 == NULL ? NULL : (__temp421 = (g_object_unref (__temp421), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (ccoldecl));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))))) {
		ValaArray* __temp422;
		ValaArray* arr;
		ValaCCodeExpression* array_len;
		__temp422 = NULL;
		arr = (__temp422 = VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))), (__temp422 == NULL ? NULL : g_object_ref (__temp422)));
		array_len = vala_code_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), 1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			char* __temp423;
			ValaCCodeDeclaration* __temp424;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp425;
			ValaCCodeBlock* cbody;
			char* __temp426;
			ValaCCodeIdentifier* __temp427;
			ValaCCodeExpression* element_expr;
			char* __temp429;
			ValaCCodeDeclaration* __temp430;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp431;
			ValaCCodeConstant* __temp434;
			ValaCCodeIdentifier* __temp433;
			char* __temp432;
			ValaCCodeBinaryExpression* __temp435;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp438;
			ValaCCodeIdentifier* __temp437;
			ValaCCodeIdentifier* __temp436;
			ValaCCodeAssignment* __temp443;
			ValaCCodeBinaryExpression* __temp442;
			ValaCCodeConstant* __temp441;
			ValaCCodeIdentifier* __temp440;
			ValaCCodeIdentifier* __temp439;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			__temp423 = NULL;
			__temp424 = NULL;
			citdecl = (__temp424 = vala_ccode_declaration_new ((__temp423 = vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE))), (__temp423 = (g_free (__temp423), NULL)), __temp424);
			__temp425 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp425 = vala_ccode_variable_declarator_new (it_name))));
			(__temp425 == NULL ? NULL : (__temp425 = (g_object_unref (__temp425), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			__temp426 = NULL;
			__temp427 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((__temp427 = vala_ccode_identifier_new ((__temp426 = g_strdup_printf ("*%s", it_name))), (__temp426 = (g_free (__temp426), NULL)), __temp427));
			if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* __temp428;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				__temp428 = NULL;
				element_expr = (__temp428 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp428);
				cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
				vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			__temp429 = NULL;
			__temp430 = NULL;
			cdecl_ = (__temp430 = vala_ccode_declaration_new ((__temp429 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (__temp429 = (g_free (__temp429), NULL)), __temp430);
			__temp431 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp431 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(__temp431 == NULL ? NULL : (__temp431 = (g_object_unref (__temp431), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
			__temp434 = NULL;
			__temp433 = NULL;
			__temp432 = NULL;
			__temp435 = NULL;
			ccond = (__temp435 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp433 = vala_ccode_identifier_new ((__temp432 = g_strdup_printf ("*%s", it_name))))), VALA_CCODE_EXPRESSION ((__temp434 = vala_ccode_constant_new ("NULL")))), (__temp434 == NULL ? NULL : (__temp434 = (g_object_unref (__temp434), NULL))), (__temp433 == NULL ? NULL : (__temp433 = (g_object_unref (__temp433), NULL))), (__temp432 = (g_free (__temp432), NULL)), __temp435);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp438 = NULL;
			__temp437 = NULL;
			__temp436 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp438 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp436 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp437 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp438 == NULL ? NULL : (__temp438 = (g_object_unref (__temp438), NULL)));
			(__temp437 == NULL ? NULL : (__temp437 = (g_object_unref (__temp437), NULL)));
			(__temp436 == NULL ? NULL : (__temp436 = (g_object_unref (__temp436), NULL)));
			__temp443 = NULL;
			__temp442 = NULL;
			__temp441 = NULL;
			__temp440 = NULL;
			__temp439 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp443 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp439 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp442 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((__temp440 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp441 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp443 == NULL ? NULL : (__temp443 = (g_object_unref (__temp443), NULL)));
			(__temp442 == NULL ? NULL : (__temp442 = (g_object_unref (__temp442), NULL)));
			(__temp441 == NULL ? NULL : (__temp441 = (g_object_unref (__temp441), NULL)));
			(__temp440 == NULL ? NULL : (__temp440 = (g_object_unref (__temp440), NULL)));
			(__temp439 == NULL ? NULL : (__temp439 = (g_object_unref (__temp439), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp444;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* __temp446;
			ValaCCodeIdentifier* __temp445;
			ValaCCodeElementAccess* __temp447;
			ValaCCodeExpression* element_expr;
			char* __temp449;
			ValaCCodeDeclaration* __temp450;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp451;
			ValaCCodeConstant* __temp452;
			ValaCCodeBinaryExpression* __temp453;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeIdentifier* __temp454;
			ValaCCodeBinaryExpression* __temp455;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp473;
			ValaCCodeConstant* __temp472;
			ValaCCodeIdentifier* __temp471;
			ValaCCodeAssignment* __temp478;
			ValaCCodeBinaryExpression* __temp477;
			ValaCCodeConstant* __temp476;
			ValaCCodeIdentifier* __temp475;
			ValaCCodeIdentifier* __temp474;
			/* the array has a length parameter */
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			__temp444 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp444 = vala_ccode_variable_declarator_new (it_name))));
			(__temp444 == NULL ? NULL : (__temp444 = (g_object_unref (__temp444), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			__temp446 = NULL;
			__temp445 = NULL;
			__temp447 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((__temp447 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((__temp445 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_EXPRESSION ((__temp446 = vala_ccode_identifier_new (it_name)))), (__temp446 == NULL ? NULL : (__temp446 = (g_object_unref (__temp446), NULL))), (__temp445 == NULL ? NULL : (__temp445 = (g_object_unref (__temp445), NULL))), __temp447));
			if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* __temp448;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				__temp448 = NULL;
				element_expr = (__temp448 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp448);
				cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
				vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			__temp449 = NULL;
			__temp450 = NULL;
			cdecl_ = (__temp450 = vala_ccode_declaration_new ((__temp449 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (__temp449 = (g_free (__temp449), NULL)), __temp450);
			__temp451 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp451 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(__temp451 == NULL ? NULL : (__temp451 = (g_object_unref (__temp451), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
			__temp452 = NULL;
			__temp453 = NULL;
			ccond_ind1 = (__temp453 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION ((__temp452 = vala_ccode_constant_new ("-1")))), (__temp452 == NULL ? NULL : (__temp452 = (g_object_unref (__temp452), NULL))), __temp453);
			__temp454 = NULL;
			__temp455 = NULL;
			ccond_ind2 = (__temp455 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((__temp454 = vala_ccode_identifier_new (it_name))), array_len), (__temp454 == NULL ? NULL : (__temp454 = (g_object_unref (__temp454), NULL))), __temp455);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
				ValaCCodeConstant* __temp456;
				ValaCCodeBinaryExpression* __temp457;
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeConstant* __temp461;
				ValaCCodeElementAccess* __temp460;
				ValaCCodeIdentifier* __temp459;
				ValaCCodeIdentifier* __temp458;
				ValaCCodeBinaryExpression* __temp462;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* __temp465;
				ValaCCodeParenthesizedExpression* __temp464;
				ValaCCodeParenthesizedExpression* __temp463;
				__temp456 = NULL;
				__temp457 = NULL;
				ccond_term1 = (__temp457 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION ((__temp456 = vala_ccode_constant_new ("-1")))), (__temp456 == NULL ? NULL : (__temp456 = (g_object_unref (__temp456), NULL))), __temp457);
				__temp461 = NULL;
				__temp460 = NULL;
				__temp459 = NULL;
				__temp458 = NULL;
				__temp462 = NULL;
				ccond_term2 = (__temp462 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp460 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((__temp458 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_EXPRESSION ((__temp459 = vala_ccode_identifier_new (it_name)))))), VALA_CCODE_EXPRESSION ((__temp461 = vala_ccode_constant_new ("NULL")))), (__temp461 == NULL ? NULL : (__temp461 = (g_object_unref (__temp461), NULL))), (__temp460 == NULL ? NULL : (__temp460 = (g_object_unref (__temp460), NULL))), (__temp459 == NULL ? NULL : (__temp459 = (g_object_unref (__temp459), NULL))), (__temp458 == NULL ? NULL : (__temp458 = (g_object_unref (__temp458), NULL))), __temp462);
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				__temp465 = NULL;
				__temp464 = NULL;
				__temp463 = NULL;
				ccond = (__temp465 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION ((__temp463 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind)))), VALA_CCODE_EXPRESSION ((__temp464 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term))))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp465);
				(__temp464 == NULL ? NULL : (__temp464 = (g_object_unref (__temp464), NULL)));
				(__temp463 == NULL ? NULL : (__temp463 = (g_object_unref (__temp463), NULL)));
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeIdentifier* __temp466;
				ValaCCodeFunctionCall* __temp467;
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* __temp468;
				ValaCCodeBinaryExpression* __temp470;
				ValaCCodeBinaryExpression* __temp469;
				/* assert when trying to iterate over value-type arrays of unknown length */
				__temp466 = NULL;
				__temp467 = NULL;
				cassert = (__temp467 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp466 = vala_ccode_identifier_new ("g_assert")))), (__temp466 == NULL ? NULL : (__temp466 = (g_object_unref (__temp466), NULL))), __temp467);
				vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (ccond_ind1));
				__temp468 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp468 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)))));
				(__temp468 == NULL ? NULL : (__temp468 = (g_object_unref (__temp468), NULL)));
				__temp470 = NULL;
				__temp469 = NULL;
				ccond = (__temp470 = (__temp469 = ccond_ind2, (__temp469 == NULL ? NULL : g_object_ref (__temp469))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp470);
				(cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp473 = NULL;
			__temp472 = NULL;
			__temp471 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp473 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp471 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp472 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp473 == NULL ? NULL : (__temp473 = (g_object_unref (__temp473), NULL)));
			(__temp472 == NULL ? NULL : (__temp472 = (g_object_unref (__temp472), NULL)));
			(__temp471 == NULL ? NULL : (__temp471 = (g_object_unref (__temp471), NULL)));
			__temp478 = NULL;
			__temp477 = NULL;
			__temp476 = NULL;
			__temp475 = NULL;
			__temp474 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp478 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp474 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp477 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((__temp475 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp476 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp478 == NULL ? NULL : (__temp478 = (g_object_unref (__temp478), NULL)));
			(__temp477 == NULL ? NULL : (__temp477 = (g_object_unref (__temp477), NULL)));
			(__temp476 == NULL ? NULL : (__temp476 = (g_object_unref (__temp476), NULL)));
			(__temp475 == NULL ? NULL : (__temp475 = (g_object_unref (__temp475), NULL)));
			(__temp474 == NULL ? NULL : (__temp474 = (g_object_unref (__temp474), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		(array_len = (g_object_unref (array_len), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->glist_type || vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->gslist_type) {
			char* it_name;
			char* __temp479;
			ValaCCodeDeclaration* __temp480;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp481;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* __temp482;
			ValaCCodeMemberAccess* __temp483;
			ValaCCodeExpression* element_expr;
			ValaCCodeExpression* __temp484;
			char* __temp486;
			ValaCCodeDeclaration* __temp487;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp488;
			ValaCCodeConstant* __temp490;
			ValaCCodeIdentifier* __temp489;
			ValaCCodeBinaryExpression* __temp491;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp494;
			ValaCCodeIdentifier* __temp493;
			ValaCCodeIdentifier* __temp492;
			ValaCCodeAssignment* __temp498;
			ValaCCodeMemberAccess* __temp497;
			ValaCCodeIdentifier* __temp496;
			ValaCCodeIdentifier* __temp495;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			__temp479 = NULL;
			__temp480 = NULL;
			citdecl = (__temp480 = vala_ccode_declaration_new ((__temp479 = vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE))), (__temp479 = (g_free (__temp479), NULL)), __temp480);
			__temp481 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp481 = vala_ccode_variable_declarator_new (it_name))));
			(__temp481 == NULL ? NULL : (__temp481 = (g_object_unref (__temp481), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			__temp482 = NULL;
			__temp483 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((__temp483 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp482 = vala_ccode_identifier_new (it_name))), "data"), (__temp482 == NULL ? NULL : (__temp482 = (g_object_unref (__temp482), NULL))), __temp483));
			__temp484 = NULL;
			element_expr = (__temp484 = vala_code_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp484);
			if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* __temp485;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				__temp485 = NULL;
				element_expr = (__temp485 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp485);
				cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
				vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			__temp486 = NULL;
			__temp487 = NULL;
			cdecl_ = (__temp487 = vala_ccode_declaration_new ((__temp486 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (__temp486 = (g_free (__temp486), NULL)), __temp487);
			__temp488 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp488 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(__temp488 == NULL ? NULL : (__temp488 = (g_object_unref (__temp488), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
			__temp490 = NULL;
			__temp489 = NULL;
			__temp491 = NULL;
			ccond = (__temp491 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp489 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp490 = vala_ccode_constant_new ("NULL")))), (__temp490 == NULL ? NULL : (__temp490 = (g_object_unref (__temp490), NULL))), (__temp489 == NULL ? NULL : (__temp489 = (g_object_unref (__temp489), NULL))), __temp491);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp494 = NULL;
			__temp493 = NULL;
			__temp492 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp494 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp492 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp493 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp494 == NULL ? NULL : (__temp494 = (g_object_unref (__temp494), NULL)));
			(__temp493 == NULL ? NULL : (__temp493 = (g_object_unref (__temp493), NULL)));
			(__temp492 == NULL ? NULL : (__temp492 = (g_object_unref (__temp492), NULL)));
			__temp498 = NULL;
			__temp497 = NULL;
			__temp496 = NULL;
			__temp495 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp498 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp495 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((__temp497 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp496 = vala_ccode_identifier_new (it_name))), "next"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp498 == NULL ? NULL : (__temp498 = (g_object_unref (__temp498), NULL)));
			(__temp497 == NULL ? NULL : (__temp497 = (g_object_unref (__temp497), NULL)));
			(__temp496 == NULL ? NULL : (__temp496 = (g_object_unref (__temp496), NULL)));
			(__temp495 == NULL ? NULL : (__temp495 = (g_object_unref (__temp495), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->iterable_type || vala_data_type_is_subtype_of (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))), self->priv->iterable_type)) {
				char* it_name;
				char* __temp500;
				char* __temp499;
				ValaCCodeDeclaration* __temp501;
				ValaCCodeDeclaration* citdecl;
				ValaMethod* it_method;
				ValaCCodeIdentifier* __temp503;
				char* __temp502;
				ValaCCodeFunctionCall* __temp504;
				ValaCCodeFunctionCall* it_ccall;
				ValaInstanceCast* __temp506;
				ValaCCodeIdentifier* __temp505;
				ValaCCodeVariableDeclarator* __temp507;
				ValaCCodeBlock* cbody;
				ValaMethod* get_method;
				ValaCCodeIdentifier* __temp509;
				char* __temp508;
				ValaCCodeFunctionCall* __temp510;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeIdentifier* __temp511;
				ValaCCodeFunctionCall* __temp512;
				ValaCCodeExpression* element_expr;
				ValaCCodeExpression* __temp513;
				GeeList* __temp514;
				GeeIterator* __temp515;
				GeeIterator* type_arg_it;
				ValaTypeReference* __temp516;
				ValaTypeReference* __temp517;
				ValaTypeReference* it_type;
				char* __temp519;
				ValaCCodeDeclaration* __temp520;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* __temp521;
				ValaMethod* next_method;
				ValaCCodeIdentifier* __temp523;
				char* __temp522;
				ValaCCodeFunctionCall* __temp524;
				ValaCCodeFunctionCall* next_ccall;
				ValaCCodeIdentifier* __temp525;
				ValaCCodeWhileStatement* __temp526;
				it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
				__temp500 = NULL;
				__temp499 = NULL;
				__temp501 = NULL;
				citdecl = (__temp501 = vala_ccode_declaration_new ((__temp500 = g_strconcat ((__temp499 = vala_data_type_get_cname (self->priv->iterator_type, FALSE)), "*", NULL))), (__temp500 = (g_free (__temp500), NULL)), (__temp499 = (g_free (__temp499), NULL)), __temp501);
				it_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) self->priv->iterable_type)), "iterator"));
				__temp503 = NULL;
				__temp502 = NULL;
				__temp504 = NULL;
				it_ccall = (__temp504 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp503 = vala_ccode_identifier_new ((__temp502 = vala_method_get_cname (it_method)))))), (__temp503 == NULL ? NULL : (__temp503 = (g_object_unref (__temp503), NULL))), (__temp502 = (g_free (__temp502), NULL)), __temp504);
				__temp506 = NULL;
				__temp505 = NULL;
				vala_ccode_function_call_add_argument (it_ccall, VALA_CCODE_EXPRESSION ((__temp506 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((__temp505 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), self->priv->iterable_type))));
				(__temp506 == NULL ? NULL : (__temp506 = (g_object_unref (__temp506), NULL)));
				(__temp505 == NULL ? NULL : (__temp505 = (g_object_unref (__temp505), NULL)));
				__temp507 = NULL;
				vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp507 = vala_ccode_variable_declarator_new_with_initializer (it_name, VALA_CCODE_EXPRESSION (it_ccall)))));
				(__temp507 == NULL ? NULL : (__temp507 = (g_object_unref (__temp507), NULL)));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
				cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) self->priv->iterator_type)), "get"));
				__temp509 = NULL;
				__temp508 = NULL;
				__temp510 = NULL;
				get_ccall = (__temp510 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp509 = vala_ccode_identifier_new ((__temp508 = vala_method_get_cname (get_method)))))), (__temp509 == NULL ? NULL : (__temp509 = (g_object_unref (__temp509), NULL))), (__temp508 = (g_free (__temp508), NULL)), __temp510);
				__temp511 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((__temp511 = vala_ccode_identifier_new (it_name))));
				(__temp511 == NULL ? NULL : (__temp511 = (g_object_unref (__temp511), NULL)));
				__temp512 = NULL;
				element_expr = VALA_CCODE_EXPRESSION ((__temp512 = get_ccall, (__temp512 == NULL ? NULL : g_object_ref (__temp512))));
				__temp513 = NULL;
				element_expr = (__temp513 = vala_code_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp513);
				__temp514 = NULL;
				__temp515 = NULL;
				type_arg_it = (__temp515 = gee_iterable_iterator (GEE_ITERABLE ((__temp514 = vala_type_reference_get_type_arguments (vala_method_get_return_type (it_method))))), (__temp514 == NULL ? NULL : (__temp514 = (g_object_unref (__temp514), NULL))), __temp515);
				gee_iterator_next (type_arg_it);
				__temp516 = NULL;
				__temp517 = NULL;
				it_type = (__temp517 = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_SYMBOL (it_method), (__temp516 = gee_iterator_get (type_arg_it)), VALA_CODE_NODE (stmt)), (__temp516 == NULL ? NULL : (__temp516 = (g_object_unref (__temp516), NULL))), __temp517);
				if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt)) && !vala_type_reference_get_takes_ownership (it_type)) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* __temp518;
					ValaCCodeFragment* cfrag;
					ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
					vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
					__temp518 = NULL;
					element_expr = (__temp518 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp518);
					cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
					vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
					vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
					gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
				}
				__temp519 = NULL;
				__temp520 = NULL;
				cdecl_ = (__temp520 = vala_ccode_declaration_new ((__temp519 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (__temp519 = (g_free (__temp519), NULL)), __temp520);
				__temp521 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp521 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
				(__temp521 == NULL ? NULL : (__temp521 = (g_object_unref (__temp521), NULL)));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
				vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
				next_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) self->priv->iterator_type)), "next"));
				__temp523 = NULL;
				__temp522 = NULL;
				__temp524 = NULL;
				next_ccall = (__temp524 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp523 = vala_ccode_identifier_new ((__temp522 = vala_method_get_cname (next_method)))))), (__temp523 == NULL ? NULL : (__temp523 = (g_object_unref (__temp523), NULL))), (__temp522 = (g_free (__temp522), NULL)), __temp524);
				__temp525 = NULL;
				vala_ccode_function_call_add_argument (next_ccall, VALA_CCODE_EXPRESSION ((__temp525 = vala_ccode_identifier_new (it_name))));
				(__temp525 == NULL ? NULL : (__temp525 = (g_object_unref (__temp525), NULL)));
				__temp526 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp526 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (next_ccall), VALA_CCODE_STATEMENT (cbody)))));
				(__temp526 == NULL ? NULL : (__temp526 = (g_object_unref (__temp526), NULL)));
				(it_name = (g_free (it_name), NULL));
				(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
				(it_method == NULL ? NULL : (it_method = (g_object_unref (it_method), NULL)));
				(it_ccall == NULL ? NULL : (it_ccall = (g_object_unref (it_ccall), NULL)));
				(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
				(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				(it_type == NULL ? NULL : (it_type = (g_object_unref (it_type), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(next_method == NULL ? NULL : (next_method = (g_object_unref (next_method), NULL)));
				(next_ccall == NULL ? NULL : (next_ccall = (g_object_unref (next_ccall), NULL)));
			}
		}
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GeeCollection* decl_collection;
			GeeIterator* decl_it;
			decl_collection = vala_block_get_local_variables (VALA_BLOCK (stmt));
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaVariableDeclarator* decl;
				decl = gee_iterator_get (decl_it);
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* __temp530;
						ValaCCodeExpression* __temp529;
						ValaCCodeIdentifier* __temp528;
						char* __temp527;
						ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
						vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
						__temp530 = NULL;
						__temp529 = NULL;
						__temp528 = NULL;
						__temp527 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp530 = vala_ccode_expression_statement_new ((__temp529 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp528 = vala_ccode_identifier_new ((__temp527 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
						(__temp530 == NULL ? NULL : (__temp530 = (g_object_unref (__temp530), NULL)));
						(__temp529 == NULL ? NULL : (__temp529 = (g_object_unref (__temp529), NULL)));
						(__temp528 == NULL ? NULL : (__temp528 = (g_object_unref (__temp528), NULL)));
						(__temp527 = (g_free (__temp527), NULL));
						(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					}
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				}
			}
			(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(ccoldecl == NULL ? NULL : (ccoldecl = (g_object_unref (ccoldecl), NULL)));
}


static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBreakStatement* __temp531;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BREAK_STATEMENT (stmt));
	__temp531 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp531 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
	(__temp531 == NULL ? NULL : (__temp531 = (g_object_unref (__temp531), NULL)));
	vala_code_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeContinueStatement* __temp532;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONTINUE_STATEMENT (stmt));
	__temp532 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp532 = g_object_new (VALA_TYPE_CCODE_CONTINUE_STATEMENT, NULL))));
	(__temp532 == NULL ? NULL : (__temp532 = (g_object_unref (__temp532), NULL)));
	vala_code_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop)
{
	ValaBlock* __temp533;
	ValaBlock* b;
	GeeCollection* local_vars;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (sym == NULL || VALA_IS_SYMBOL (sym));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	__temp533 = NULL;
	b = (__temp533 = VALA_BLOCK (sym), (__temp533 == NULL ? NULL : g_object_ref (__temp533)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_symbol_get_active (((ValaSymbol*) decl)) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* __temp537;
					ValaCCodeExpression* __temp536;
					ValaCCodeIdentifier* __temp535;
					char* __temp534;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					__temp537 = NULL;
					__temp536 = NULL;
					__temp535 = NULL;
					__temp534 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp537 = vala_ccode_expression_statement_new ((__temp536 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp535 = vala_ccode_identifier_new ((__temp534 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
					(__temp537 == NULL ? NULL : (__temp537 = (g_object_unref (__temp537), NULL)));
					(__temp536 == NULL ? NULL : (__temp536 = (g_object_unref (__temp536), NULL)));
					(__temp535 == NULL ? NULL : (__temp535 = (g_object_unref (__temp535), NULL)));
					(__temp534 = (g_free (__temp534), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	if (stop_at_loop) {
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b)))) {
			(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
			(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_code_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
}


static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_CODE_NODE (stmt));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_local_free (self, self->priv->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop)
{
	gboolean found;
	ValaBlock* __temp538;
	ValaBlock* b;
	GeeCollection* local_vars;
	gboolean __temp542;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (ccomma == NULL || VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	__temp538 = NULL;
	b = (__temp538 = VALA_BLOCK (sym), (__temp538 == NULL ? NULL : g_object_ref (__temp538)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_symbol_get_active (((ValaSymbol*) decl)) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* __temp541;
					ValaCCodeIdentifier* __temp540;
					char* __temp539;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					__temp541 = NULL;
					__temp540 = NULL;
					__temp539 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp541 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp540 = vala_ccode_identifier_new ((__temp539 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma))));
					(__temp541 == NULL ? NULL : (__temp541 = (g_object_unref (__temp541), NULL)));
					(__temp540 == NULL ? NULL : (__temp540 = (g_object_unref (__temp540), NULL)));
					(__temp539 = (g_free (__temp539), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		found = vala_code_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop) || found;
	}
	return (__temp542 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL))), __temp542);
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
}


static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaVariableDeclarator* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* __temp544;
	ValaCCodeIdentifier* __temp543;
	ValaCCodeIdentifier* __temp545;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	__temp544 = NULL;
	__temp543 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp544 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp543 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp544 == NULL ? NULL : (__temp544 = (g_object_unref (__temp544), NULL)));
	(__temp543 == NULL ? NULL : (__temp543 = (g_object_unref (__temp543), NULL)));
	if (!vala_code_generator_append_local_free_expr (self, self->priv->current_symbol, ccomma, FALSE)) {
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	/* no local variables need to be freed */
	__temp545 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp545 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))));
	(__temp545 == NULL ? NULL : (__temp545 = (g_object_unref (__temp545), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), return_expr_decl);
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaVariableDeclarator* __temp546;
			ValaVariableDeclarator* decl;
			__temp546 = NULL;
			decl = (__temp546 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (__temp546 == NULL ? NULL : g_object_ref (__temp546)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE);
				/* don't ref expression*/
				vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE);
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* __temp547;
		__temp547 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp547 = vala_ccode_return_statement_new (NULL))));
		(__temp547 == NULL ? NULL : (__temp547 = (g_object_unref (__temp547), NULL)));
		vala_code_generator_create_local_free (self, VALA_CODE_NODE (stmt), FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaCCodeReturnStatement* __temp560;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaVariableDeclarator* __temp548;
			ValaVariableDeclarator* decl;
			__temp548 = NULL;
			decl = (__temp548 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (__temp548 == NULL ? NULL : g_object_ref (__temp548)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				ValaSymbol* __temp550;
				ValaVariableDeclarator* __temp549;
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				__temp550 = NULL;
				__temp549 = NULL;
				return_expression_symbol = (__temp550 = VALA_SYMBOL ((__temp549 = decl, (__temp549 == NULL ? NULL : g_object_ref (__temp549)))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), __temp550);
				vala_symbol_set_active (return_expression_symbol, FALSE);
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
		/* return array length if appropriate*/
		if (self->priv->current_method != NULL && !vala_method_get_no_array_length (self->priv->current_method) && VALA_IS_ARRAY (vala_type_reference_get_data_type (self->priv->current_return_type))) {
			ValaVariableDeclarator* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* __temp552;
			ValaCCodeIdentifier* __temp551;
			ValaArray* __temp553;
			ValaArray* arr;
			ValaCCodeIdentifier* __temp558;
			return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), TRUE);
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			__temp552 = NULL;
			__temp551 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp552 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp551 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_return_statement_get_return_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp552 == NULL ? NULL : (__temp552 = (g_object_unref (__temp552), NULL)));
			(__temp551 == NULL ? NULL : (__temp551 = (g_object_unref (__temp551), NULL)));
			__temp553 = NULL;
			arr = (__temp553 = VALA_ARRAY (vala_type_reference_get_data_type (self->priv->current_return_type)), (__temp553 == NULL ? NULL : g_object_ref (__temp553)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeIdentifier* __temp555;
					char* __temp554;
					ValaCCodeUnaryExpression* __temp556;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* __temp557;
					__temp555 = NULL;
					__temp554 = NULL;
					__temp556 = NULL;
					len_l = (__temp556 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((__temp555 = vala_ccode_identifier_new ((__temp554 = vala_code_generator_get_array_length_cname (self, "result", dim)))))), (__temp555 == NULL ? NULL : (__temp555 = (g_object_unref (__temp555), NULL))), (__temp554 = (g_free (__temp554), NULL)), __temp556);
					len_r = vala_code_generator_get_array_length_cexpression (self, vala_return_statement_get_return_expression (stmt), dim);
					__temp557 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp557 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (len_l), len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp557 == NULL ? NULL : (__temp557 = (g_object_unref (__temp557), NULL)));
					(len_l == NULL ? NULL : (len_l = (g_object_unref (len_l), NULL)));
					(len_r = (g_object_unref (len_r), NULL));
				}
			}
			__temp558 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp558 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))));
			(__temp558 == NULL ? NULL : (__temp558 = (g_object_unref (__temp558), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE (ccomma));
			gee_collection_add (GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars), return_expr_decl);
			(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_code_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		if (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt))) != vala_type_reference_get_data_type (self->priv->current_return_type)) {
			/* cast required */
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (self->priv->current_return_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (self->priv->current_return_type))) {
				ValaInstanceCast* __temp559;
				__temp559 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((__temp559 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_return_statement_get_return_expression (stmt)))), vala_type_reference_get_data_type (self->priv->current_return_type)))));
				(__temp559 == NULL ? NULL : (__temp559 = (g_object_unref (__temp559), NULL)));
			}
		}
		__temp560 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp560 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))))))));
		(__temp560 == NULL ? NULL : (__temp560 = (g_object_unref (__temp560), NULL)));
		vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars));
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static void vala_code_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpressionStatement* __temp561;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp561 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp561 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_throw_statement_get_error_expression (stmt))))))));
	(__temp561 == NULL ? NULL : (__temp561 = (g_object_unref (__temp561), NULL)));
	if (self->priv->current_return_type != NULL && vala_type_reference_get_data_type (self->priv->current_return_type) != NULL) {
		ValaCCodeReturnStatement* __temp563;
		ValaCCodeExpression* __temp562;
		__temp563 = NULL;
		__temp562 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp563 = vala_ccode_return_statement_new ((__temp562 = vala_code_generator_default_value_for_type (self, vala_type_reference_get_data_type (self->priv->current_return_type)))))));
		(__temp563 == NULL ? NULL : (__temp563 = (g_object_unref (__temp563), NULL)));
		(__temp562 == NULL ? NULL : (__temp562 = (g_object_unref (__temp562), NULL)));
	} else {
		ValaCCodeReturnStatement* __temp564;
		__temp564 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp564 = vala_ccode_return_statement_new (NULL))));
		(__temp564 == NULL ? NULL : (__temp564 = (g_object_unref (__temp564), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaTryStatement* __temp565;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* __temp566;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* __temp570;
	char* __temp569;
	ValaTryStatement* __temp573;
	ValaTryStatement* __temp572;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_TRY_STATEMENT (stmt));
	__temp565 = NULL;
	old_try = (__temp565 = self->priv->current_try, (__temp565 == NULL ? NULL : g_object_ref (__temp565)));
	old_try_id = self->priv->current_try_id;
	__temp566 = NULL;
	self->priv->current_try = (__temp566 = g_object_ref (stmt), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), __temp566);
	self->priv->current_try_id = self->priv->next_try_id++;
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_try_statement_get_body (stmt))));
	{
		GeeCollection* clause_collection;
		GeeIterator* clause_it;
		clause_collection = vala_try_statement_get_catch_clauses (stmt);
		clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
		while (gee_iterator_next (clause_it)) {
			ValaCatchClause* clause;
			clause = gee_iterator_get (clause_it);
			{
				ValaCCodeGotoStatement* __temp568;
				char* __temp567;
				__temp568 = NULL;
				__temp567 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp568 = vala_ccode_goto_statement_new ((__temp567 = g_strdup_printf ("__finally%d", self->priv->current_try_id))))));
				(__temp568 == NULL ? NULL : (__temp568 = (g_object_unref (__temp568), NULL)));
				(__temp567 = (g_free (__temp567), NULL));
				vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) clause)));
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
		(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
		(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
	}
	__temp570 = NULL;
	__temp569 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp570 = vala_ccode_label_new ((__temp569 = g_strdup_printf ("__finally%d", self->priv->current_try_id))))));
	(__temp570 == NULL ? NULL : (__temp570 = (g_object_unref (__temp570), NULL)));
	(__temp569 = (g_free (__temp569), NULL));
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_try_statement_get_finally_body (stmt))));
	} else {
		ValaCCodeEmptyStatement* __temp571;
		/* avoid gcc error: label at end of compound statement*/
		__temp571 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp571 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL))));
		(__temp571 == NULL ? NULL : (__temp571 = (g_object_unref (__temp571), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	__temp573 = NULL;
	__temp572 = NULL;
	self->priv->current_try = (__temp573 = (__temp572 = old_try, (__temp572 == NULL ? NULL : g_object_ref (__temp572))), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), __temp573);
	self->priv->current_try_id = old_try_id;
	(old_try == NULL ? NULL : (old_try = (g_object_unref (old_try), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* __temp576;
	char* __temp575;
	char* __temp574;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp578;
	ValaCCodeIdentifier* __temp577;
	ValaCCodeExpressionStatement* __temp582;
	ValaCCodeAssignment* __temp581;
	ValaCCodeConstant* __temp580;
	ValaCCodeIdentifier* __temp579;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp576 = NULL;
	__temp575 = NULL;
	__temp574 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp576 = vala_ccode_label_new ((__temp575 = g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (__temp574 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause))), NULL))))))));
	(__temp576 == NULL ? NULL : (__temp576 = (g_object_unref (__temp576), NULL)));
	(__temp575 = (g_free (__temp575), NULL));
	(__temp574 = (g_free (__temp574), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GError *");
	__temp578 = NULL;
	__temp577 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp578 = vala_ccode_variable_declarator_new_with_initializer (vala_catch_clause_get_variable_name (clause), VALA_CCODE_EXPRESSION ((__temp577 = vala_ccode_identifier_new ("inner_error")))))));
	(__temp578 == NULL ? NULL : (__temp578 = (g_object_unref (__temp578), NULL)));
	(__temp577 == NULL ? NULL : (__temp577 = (g_object_unref (__temp577), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp582 = NULL;
	__temp581 = NULL;
	__temp580 = NULL;
	__temp579 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp582 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp581 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp579 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((__temp580 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp582 == NULL ? NULL : (__temp582 = (g_object_unref (__temp582), NULL)));
	(__temp581 == NULL ? NULL : (__temp581 = (g_object_unref (__temp581), NULL)));
	(__temp580 == NULL ? NULL : (__temp580 = (g_object_unref (__temp580), NULL)));
	(__temp579 == NULL ? NULL : (__temp579 = (g_object_unref (__temp579), NULL)));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_catch_clause_get_body (clause))));
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cblock));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (clause), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
}


static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


/**
 * Visit operation called for lock statements.
 *
 * @param stmt a lock statement
 */
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* __temp584;
	ValaExpression* inner_node;
	ValaCCodeExpression* __temp593;
	char* __temp592;
	ValaCCodeMemberAccess* __temp591;
	ValaCCodeFunctionCall* __temp597;
	ValaCCodeIdentifier* __temp596;
	char* __temp595;
	ValaMethod* __temp594;
	ValaCCodeExpressionStatement* __temp598;
	ValaCCodeFunctionCall* __temp602;
	ValaCCodeIdentifier* __temp601;
	char* __temp600;
	ValaMethod* __temp599;
	ValaCCodeExpressionStatement* __temp603;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (stmt));
	cn = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	l = NULL;
	fc = NULL;
	__temp584 = NULL;
	inner_node = (__temp584 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (__temp584 == NULL ? NULL : g_object_ref (__temp584)));
	if (inner_node == NULL) {
		ValaCCodeExpression* __temp585;
		__temp585 = NULL;
		l = (__temp585 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp585);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != self->priv->current_type_symbol) {
			ValaCCodeExpression* __temp588;
			ValaCCodeIdentifier* __temp587;
			char* __temp586;
			__temp588 = NULL;
			__temp587 = NULL;
			__temp586 = NULL;
			l = (__temp588 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp587 = vala_ccode_identifier_new ((__temp586 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), NULL))))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp588);
			(__temp587 == NULL ? NULL : (__temp587 = (g_object_unref (__temp587), NULL)));
			(__temp586 = (g_free (__temp586), NULL));
			vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (l)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) inner_node))));
		} else {
			ValaCCodeExpression* __temp590;
			ValaCCodeExpression* __temp589;
			__temp590 = NULL;
			__temp589 = NULL;
			l = (__temp590 = (__temp589 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) inner_node))), (__temp589 == NULL ? NULL : g_object_ref (__temp589))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp590);
		}
	}
	__temp593 = NULL;
	__temp592 = NULL;
	__temp591 = NULL;
	l = (__temp593 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp591 = vala_ccode_member_access_new_pointer (l, "priv"))), (__temp592 = vala_code_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp593);
	(__temp592 = (g_free (__temp592), NULL));
	(__temp591 == NULL ? NULL : (__temp591 = (g_object_unref (__temp591), NULL)));
	__temp597 = NULL;
	__temp596 = NULL;
	__temp595 = NULL;
	__temp594 = NULL;
	fc = (__temp597 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp596 = vala_ccode_identifier_new ((__temp595 = vala_method_get_cname ((__temp594 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) vala_type_reference_get_data_type (self->priv->mutex_type))), "lock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp597);
	(__temp596 == NULL ? NULL : (__temp596 = (g_object_unref (__temp596), NULL)));
	(__temp595 = (g_free (__temp595), NULL));
	(__temp594 == NULL ? NULL : (__temp594 = (g_object_unref (__temp594), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	__temp598 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp598 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp598 == NULL ? NULL : (__temp598 = (g_object_unref (__temp598), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_lock_statement_get_body (stmt))));
	__temp602 = NULL;
	__temp601 = NULL;
	__temp600 = NULL;
	__temp599 = NULL;
	fc = (__temp602 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp601 = vala_ccode_identifier_new ((__temp600 = vala_method_get_cname ((__temp599 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) vala_type_reference_get_data_type (self->priv->mutex_type))), "unlock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp602);
	(__temp601 == NULL ? NULL : (__temp601 = (g_object_unref (__temp601), NULL)));
	(__temp600 = (g_free (__temp600), NULL));
	(__temp599 == NULL ? NULL : (__temp599 = (g_object_unref (__temp599), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	__temp603 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp603 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp603 == NULL ? NULL : (__temp603 = (g_object_unref (__temp603), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp604;
	ValaCCodeFunctionCall* __temp605;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* __temp607;
	char* __temp606;
	gboolean first;
	ValaCCodeExpression* cexpr;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	__temp604 = NULL;
	__temp605 = NULL;
	gnew = (__temp605 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp604 = vala_ccode_identifier_new ("g_new0")))), (__temp604 == NULL ? NULL : (__temp604 = (g_object_unref (__temp604), NULL))), __temp605);
	__temp607 = NULL;
	__temp606 = NULL;
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION ((__temp607 = vala_ccode_identifier_new ((__temp606 = vala_type_reference_get_cname (vala_array_creation_expression_get_element_type (expr), FALSE, FALSE))))));
	(__temp607 == NULL ? NULL : (__temp607 = (g_object_unref (__temp607), NULL)));
	(__temp606 = (g_free (__temp606), NULL));
	first = TRUE;
	cexpr = NULL;
	{
		GeeList* size_collection;
		GeeIterator* size_it;
		size_collection = vala_array_creation_expression_get_sizes (expr);
		size_it = gee_iterable_iterator (GEE_ITERABLE (size_collection));
		while (gee_iterator_next (size_it)) {
			ValaExpression* size;
			size = gee_iterator_get (size_it);
			{
				if (first) {
					ValaCCodeExpression* __temp609;
					ValaCCodeExpression* __temp608;
					__temp609 = NULL;
					__temp608 = NULL;
					cexpr = (__temp609 = (__temp608 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) size))), (__temp608 == NULL ? NULL : g_object_ref (__temp608))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp609);
					first = FALSE;
				} else {
					ValaCCodeExpression* __temp610;
					__temp610 = NULL;
					cexpr = (__temp610 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) size))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp610);
				}
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
			}
		}
		(size_collection == NULL ? NULL : (size_collection = (g_object_unref (size_collection), NULL)));
		(size_it == NULL ? NULL : (size_it = (g_object_unref (size_it), NULL)));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaVariableDeclarator* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaCCodeAssignment* __temp611;
		/* FIXME rank > 1 not supported yet*/
		if (vala_array_creation_expression_get_rank (expr) > 1) {
			vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "Creating arrays with rank greater than 1 with initializers is not supported yet");
		}
		ce = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		temp_var = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (((ValaExpression*) expr)), TRUE);
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_var)));
		i = 0;
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_var);
		__temp611 = NULL;
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp611 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (gnew), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp611 == NULL ? NULL : (__temp611 = (g_object_unref (__temp611), NULL)));
		{
			GeeCollection* e_collection;
			GeeIterator* e_it;
			e_collection = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			e_it = gee_iterable_iterator (GEE_ITERABLE (e_collection));
			while (gee_iterator_next (e_it)) {
				ValaExpression* e;
				e = gee_iterator_get (e_it);
				{
					ValaCCodeAssignment* __temp615;
					ValaCCodeElementAccess* __temp614;
					ValaCCodeConstant* __temp613;
					char* __temp612;
					__temp615 = NULL;
					__temp614 = NULL;
					__temp613 = NULL;
					__temp612 = NULL;
					vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp615 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp614 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION ((__temp613 = vala_ccode_constant_new ((__temp612 = g_strdup_printf ("%i", i)))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) e))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp615 == NULL ? NULL : (__temp615 = (g_object_unref (__temp615), NULL)));
					(__temp614 == NULL ? NULL : (__temp614 = (g_object_unref (__temp614), NULL)));
					(__temp613 == NULL ? NULL : (__temp613 = (g_object_unref (__temp613), NULL)));
					(__temp612 = (g_free (__temp612), NULL));
					i++;
					(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
				}
			}
			(e_collection == NULL ? NULL : (e_collection = (g_object_unref (e_collection), NULL)));
			(e_it == NULL ? NULL : (e_it = (g_object_unref (e_it), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION (name_cnode));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ce));
		(ce == NULL ? NULL : (ce = (g_object_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
	} else {
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (gnew));
	}
	(gnew == NULL ? NULL : (gnew = (g_object_unref (gnew), NULL)));
	(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
}


static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp616;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (expr));
	__temp616 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp616 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE")))));
	(__temp616 == NULL ? NULL : (__temp616 = (g_object_unref (__temp616), NULL)));
}


static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* __temp617;
		__temp617 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp617 = vala_ccode_constant_new (vala_character_literal_get_value (expr)))));
		(__temp617 == NULL ? NULL : (__temp617 = (g_object_unref (__temp617), NULL)));
	} else {
		ValaCCodeConstant* __temp619;
		char* __temp618;
		__temp619 = NULL;
		__temp618 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp619 = vala_ccode_constant_new ((__temp618 = g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))));
		(__temp619 == NULL ? NULL : (__temp619 = (g_object_unref (__temp619), NULL)));
		(__temp618 = (g_free (__temp618), NULL));
	}
}


static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp620;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INTEGER_LITERAL (expr));
	__temp620 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp620 = vala_ccode_constant_new (vala_integer_literal_get_value (expr)))));
	(__temp620 == NULL ? NULL : (__temp620 = (g_object_unref (__temp620), NULL)));
}


static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp621;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_REAL_LITERAL (expr));
	__temp621 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp621 = vala_ccode_constant_new (vala_real_literal_get_value (expr)))));
	(__temp621 == NULL ? NULL : (__temp621 = (g_object_unref (__temp621), NULL)));
}


static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp622;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_STRING_LITERAL (expr));
	__temp622 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp622 = vala_ccode_constant_new (vala_string_literal_get_value (expr)))));
	(__temp622 == NULL ? NULL : (__temp622 = (g_object_unref (__temp622), NULL)));
}


static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp623;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_NULL_LITERAL (expr));
	__temp623 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp623 = vala_ccode_constant_new ("NULL"))));
	(__temp623 == NULL ? NULL : (__temp623 = (g_object_unref (__temp623), NULL)));
}


static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_LITERAL_EXPRESSION (expr));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), vala_code_node_get_ccodenode (((ValaCodeNode*) vala_literal_expression_get_literal (expr))));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeParenthesizedExpression* __temp624;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	__temp624 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp624 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_parenthesized_expression_get_inner (expr))))))));
	(__temp624 == NULL ? NULL : (__temp624 = (g_object_unref (__temp624), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim)
{
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (array_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* __temp625;
		ValaUnaryExpression* unary_expr;
		__temp625 = NULL;
		unary_expr = (__temp625 = VALA_UNARY_EXPRESSION (array_expr), (__temp625 == NULL ? NULL : g_object_ref (__temp625)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* __temp626;
			ValaReferenceTransferExpression* reftransfer_expr;
			__temp626 = NULL;
			reftransfer_expr = (__temp626 = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (__temp626 == NULL ? NULL : g_object_ref (__temp626)));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL ? NULL : (reftransfer_expr = (g_object_unref (reftransfer_expr), NULL)));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		ValaCCodeExpression* __temp627;
		ValaCCodeExpression* __temp628;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		length_expr = gee_list_get (((GeeList*) size), dim - 1);
		__temp627 = NULL;
		__temp628 = NULL;
		return (__temp628 = (__temp627 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) length_expr))), (__temp627 == NULL ? NULL : g_object_ref (__temp627))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp628);
		(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
		(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* __temp629;
			ValaInvocationExpression* invocation_expr;
			GeeList* size;
			ValaCCodeExpression* __temp630;
			__temp629 = NULL;
			invocation_expr = (__temp629 = VALA_INVOCATION_EXPRESSION (array_expr), (__temp629 == NULL ? NULL : g_object_ref (__temp629)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			__temp630 = NULL;
			return (__temp630 = gee_list_get (((GeeList*) size), dim - 1), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), __temp630);
			(invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL)));
			(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* __temp631;
					ValaFormalParameter* param;
					__temp631 = NULL;
					param = (__temp631 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (__temp631 == NULL ? NULL : g_object_ref (__temp631)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						char* __temp632;
						ValaCCodeIdentifier* __temp633;
						ValaCCodeIdentifier* length_expr;
						__temp632 = NULL;
						__temp633 = NULL;
						length_expr = (__temp633 = vala_ccode_identifier_new ((__temp632 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) param)), dim))), (__temp632 = (g_free (__temp632), NULL)), __temp633);
						if (is_out) {
							ValaCCodeUnaryExpression* __temp634;
							__temp634 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp634 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp634));
						} else {
							ValaCCodeIdentifier* __temp635;
							__temp635 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp635 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp635));
						}
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (array_expr))) {
						ValaVariableDeclarator* __temp636;
						ValaVariableDeclarator* decl;
						char* __temp637;
						ValaCCodeIdentifier* __temp638;
						ValaCCodeIdentifier* length_expr;
						__temp636 = NULL;
						decl = (__temp636 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (array_expr)), (__temp636 == NULL ? NULL : g_object_ref (__temp636)));
						__temp637 = NULL;
						__temp638 = NULL;
						length_expr = (__temp638 = vala_ccode_identifier_new ((__temp637 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)), dim))), (__temp637 = (g_free (__temp637), NULL)), __temp638);
						if (is_out) {
							ValaCCodeUnaryExpression* __temp639;
							__temp639 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp639 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp639));
						} else {
							ValaCCodeIdentifier* __temp640;
							__temp640 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp640 = length_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), __temp640));
						}
						(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* __temp641;
							ValaField* field;
							__temp641 = NULL;
							field = (__temp641 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (__temp641 == NULL ? NULL : g_object_ref (__temp641)));
							if (!vala_field_get_no_array_length (field)) {
								char* length_cname;
								ValaMemberAccess* __temp642;
								ValaMemberAccess* ma;
								ValaCCodeExpression* pub_inst;
								ValaDataType* base_type;
								ValaCCodeExpression* length_expr;
								length_cname = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) field)), dim);
								__temp642 = NULL;
								ma = (__temp642 = VALA_MEMBER_ACCESS (array_expr), (__temp642 == NULL ? NULL : g_object_ref (__temp642)));
								pub_inst = NULL;
								base_type = NULL;
								length_expr = NULL;
								if (vala_member_access_get_inner (ma) == NULL) {
									ValaCCodeExpression* __temp643;
									__temp643 = NULL;
									pub_inst = (__temp643 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp643);
									if (self->priv->current_type_symbol != NULL) {
										ValaDataType* __temp645;
										ValaDataType* __temp644;
										/* base type is available if this is a type method */
										__temp645 = NULL;
										__temp644 = NULL;
										base_type = (__temp645 = (__temp644 = VALA_DATA_TYPE (self->priv->current_type_symbol), (__temp644 == NULL ? NULL : g_object_ref (__temp644))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp645);
									}
								} else {
									ValaCCodeExpression* __temp647;
									ValaCCodeExpression* __temp646;
									__temp647 = NULL;
									__temp646 = NULL;
									pub_inst = (__temp647 = (__temp646 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (__temp646 == NULL ? NULL : g_object_ref (__temp646))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp647);
									if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaDataType* __temp649;
										ValaDataType* __temp648;
										__temp649 = NULL;
										__temp648 = NULL;
										base_type = (__temp649 = (__temp648 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (__temp648 == NULL ? NULL : g_object_ref (__temp648))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp649);
									}
								}
								if (vala_field_get_instance (field)) {
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									typed_inst = NULL;
									if (vala_symbol_get_parent_symbol (((ValaSymbol*) field)) != VALA_SYMBOL (base_type)) {
										ValaCCodeExpression* __temp652;
										ValaCCodeIdentifier* __temp651;
										char* __temp650;
										/* FIXME: use C cast if debugging disabled*/
										__temp652 = NULL;
										__temp651 = NULL;
										__temp650 = NULL;
										typed_inst = (__temp652 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp651 = vala_ccode_identifier_new ((__temp650 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) field)))), NULL))))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp652);
										(__temp651 == NULL ? NULL : (__temp651 = (g_object_unref (__temp651), NULL)));
										(__temp650 = (g_free (__temp650), NULL));
										vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
									} else {
										ValaCCodeExpression* __temp654;
										ValaCCodeExpression* __temp653;
										__temp654 = NULL;
										__temp653 = NULL;
										typed_inst = (__temp654 = (__temp653 = pub_inst, (__temp653 == NULL ? NULL : g_object_ref (__temp653))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp654);
									}
									inst = NULL;
									if (field->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* __temp655;
										__temp655 = NULL;
										inst = (__temp655 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp655);
									} else {
										ValaCCodeExpression* __temp657;
										ValaCCodeExpression* __temp656;
										__temp657 = NULL;
										__temp656 = NULL;
										inst = (__temp657 = (__temp656 = typed_inst, (__temp656 == NULL ? NULL : g_object_ref (__temp656))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp657);
									}
									if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) field)))))) {
										ValaCCodeExpression* __temp658;
										__temp658 = NULL;
										length_expr = (__temp658 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp658);
									} else {
										ValaCCodeExpression* __temp659;
										__temp659 = NULL;
										length_expr = (__temp659 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp659);
									}
									(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* __temp660;
									__temp660 = NULL;
									length_expr = (__temp660 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp660);
								}
								if (is_out) {
									ValaCCodeUnaryExpression* __temp661;
									__temp661 = NULL;
									return VALA_CCODE_EXPRESSION ((__temp661 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), __temp661));
								} else {
									ValaCCodeExpression* __temp662;
									__temp662 = NULL;
									return (__temp662 = length_expr, (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), __temp662);
								}
								(length_cname = (g_free (length_cname), NULL));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
								(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						}
					}
				}
			}
		}
	}
	if (!is_out) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


/* allow arrays with unknown length even for value types
 * as else it may be impossible to bind some libraries
 * users of affected libraries should explicitly set
 * the array length as early as possible
 * by setting the virtual length field of the array
 */
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr)
{
	ValaCodeGenerator * self;
	GeeList* indices;
	gint rank;
	ValaDataType* __temp665;
	ValaDataType* container_type;
	ValaCCodeExpression* __temp666;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* __temp668;
	ValaExpression* __temp667;
	ValaCCodeExpression* __temp669;
	ValaCCodeExpression* cindex;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (expr));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size (((GeeCollection*) indices));
	__temp665 = NULL;
	container_type = (__temp665 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (__temp665 == NULL ? NULL : g_object_ref (__temp665)));
	__temp666 = NULL;
	ccontainer = (__temp666 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_element_access_get_container (expr)))), (__temp666 == NULL ? NULL : g_object_ref (__temp666)));
	__temp668 = NULL;
	__temp667 = NULL;
	__temp669 = NULL;
	cindex = (__temp669 = (__temp668 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (__temp667 = gee_list_get (((GeeList*) indices), 0))))), (__temp668 == NULL ? NULL : g_object_ref (__temp668))), (__temp667 == NULL ? NULL : (__temp667 = (g_object_unref (__temp667), NULL))), __temp669);
	if (container_type == vala_type_reference_get_data_type (self->priv->string_type)) {
		ValaCCodeIdentifier* __temp670;
		ValaCCodeFunctionCall* __temp671;
		ValaCCodeFunctionCall* coffsetcall;
		ValaCCodeIdentifier* __temp672;
		ValaCCodeFunctionCall* __temp673;
		ValaCCodeFunctionCall* ccall;
		/* access to unichar in a string*/
		__temp670 = NULL;
		__temp671 = NULL;
		coffsetcall = (__temp671 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp670 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (__temp670 == NULL ? NULL : (__temp670 = (g_object_unref (__temp670), NULL))), __temp671);
		vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
		vala_ccode_function_call_add_argument (coffsetcall, cindex);
		__temp672 = NULL;
		__temp673 = NULL;
		ccall = (__temp673 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp672 = vala_ccode_identifier_new ("g_utf8_get_char")))), (__temp672 == NULL ? NULL : (__temp672 = (g_object_unref (__temp672), NULL))), __temp673);
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (coffsetcall));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
		(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	} else {
		if (container_type != NULL && self->priv->list_type != NULL && self->priv->map_type != NULL && (container_type == self->priv->list_type || vala_data_type_is_subtype_of (container_type, self->priv->list_type) || container_type == self->priv->map_type || vala_data_type_is_subtype_of (container_type, self->priv->map_type))) {
			ValaMethod* get_method;
			GeeCollection* get_params;
			GeeIterator* get_params_it;
			ValaFormalParameter* get_param;
			ValaCCodeIdentifier* __temp676;
			char* __temp675;
			ValaCCodeFunctionCall* __temp677;
			ValaCCodeFunctionCall* get_ccall;
			ValaCCodeCastExpression* __temp680;
			char* __temp679;
			char* __temp678;
			ValaCCodeExpression* __temp681;
			get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) container_type)), "get"));
			get_params = vala_invokable_get_parameters (VALA_INVOKABLE (get_method));
			get_params_it = gee_iterable_iterator (GEE_ITERABLE (get_params));
			gee_iterator_next (get_params_it);
			get_param = gee_iterator_get (get_params_it);
			if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (get_param)) != NULL) {
				ValaTypeReference* index_type;
				ValaCCodeExpression* __temp674;
				index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (get_method), vala_formal_parameter_get_type_reference (get_param), VALA_CODE_NODE (expr));
				__temp674 = NULL;
				cindex = (__temp674 = vala_code_generator_convert_to_generic_pointer (self, cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), __temp674);
				(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
			}
			__temp676 = NULL;
			__temp675 = NULL;
			__temp677 = NULL;
			get_ccall = (__temp677 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp676 = vala_ccode_identifier_new ((__temp675 = vala_method_get_cname (get_method)))))), (__temp676 == NULL ? NULL : (__temp676 = (g_object_unref (__temp676), NULL))), (__temp675 = (g_free (__temp675), NULL)), __temp677);
			__temp680 = NULL;
			__temp679 = NULL;
			__temp678 = NULL;
			vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((__temp680 = vala_ccode_cast_expression_new (ccontainer, (__temp679 = g_strconcat ((__temp678 = vala_data_type_get_cname (container_type, FALSE)), "*", NULL))))));
			(__temp680 == NULL ? NULL : (__temp680 = (g_object_unref (__temp680), NULL)));
			(__temp679 = (g_free (__temp679), NULL));
			(__temp678 = (g_free (__temp678), NULL));
			vala_ccode_function_call_add_argument (get_ccall, cindex);
			__temp681 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp681 = vala_code_generator_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (get_ccall), vala_expression_get_static_type (((ValaExpression*) expr))))));
			(__temp681 = (g_object_unref (__temp681), NULL));
			(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
			(get_params == NULL ? NULL : (get_params = (g_object_unref (get_params), NULL)));
			(get_params_it == NULL ? NULL : (get_params_it = (g_object_unref (get_params_it), NULL)));
			(get_param == NULL ? NULL : (get_param = (g_object_unref (get_param), NULL)));
			(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
		} else {
			ValaCCodeElementAccess* __temp686;
			{
				gint i;
				i = 0;
				for (i = 1; i < rank; i++) {
					ValaCCodeExpression* __temp682;
					ValaCCodeBinaryExpression* __temp683;
					ValaCCodeBinaryExpression* cmul;
					ValaCCodeExpression* __temp685;
					ValaExpression* __temp684;
					/* access to element in an array*/
					__temp682 = NULL;
					__temp683 = NULL;
					cmul = (__temp683 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cindex, (__temp682 = vala_code_generator_get_array_length_cexpression (self, vala_element_access_get_container (expr), i + 1))), (__temp682 = (g_object_unref (__temp682), NULL)), __temp683);
					__temp685 = NULL;
					__temp684 = NULL;
					cindex = (__temp685 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (cmul), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (__temp684 = gee_list_get (((GeeList*) indices), i))))))), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), __temp685);
					(__temp684 == NULL ? NULL : (__temp684 = (g_object_unref (__temp684), NULL)));
					(cmul == NULL ? NULL : (cmul = (g_object_unref (cmul), NULL)));
				}
			}
			__temp686 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp686 = vala_ccode_element_access_new (ccontainer, cindex))));
			(__temp686 == NULL ? NULL : (__temp686 = (g_object_unref (__temp686), NULL)));
		}
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr)
{
	ValaCodeGenerator * self;
	ValaInstanceCast* __temp688;
	ValaCCodeIdentifier* __temp687;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BASE_ACCESS (expr));
	__temp688 = NULL;
	__temp687 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp688 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((__temp687 = vala_ccode_identifier_new ("self"))), vala_type_reference_get_data_type (vala_expression_get_static_type (((ValaExpression*) expr)))))));
	(__temp688 == NULL ? NULL : (__temp688 = (g_object_unref (__temp688), NULL)));
	(__temp687 == NULL ? NULL : (__temp687 = (g_object_unref (__temp687), NULL)));
}


static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* __temp696;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (expr));
	ma = vala_code_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* __temp689;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeAssignment* __temp691;
		ValaCCodeIdentifier* __temp690;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* __temp693;
		ValaCCodeIdentifier* __temp692;
		ValaCCodeBinaryExpression* __temp694;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp695;
		/* property postfix expression*/
		__temp689 = NULL;
		prop = (__temp689 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) ma))), (__temp689 == NULL ? NULL : g_object_ref (__temp689)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		/* assign current value to temp variable*/
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_property_get_type_reference (prop), TRUE);
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
		__temp691 = NULL;
		__temp690 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp691 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp690 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp691 == NULL ? NULL : (__temp691 = (g_object_unref (__temp691), NULL)));
		(__temp690 == NULL ? NULL : (__temp690 = (g_object_unref (__temp690), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		__temp693 = NULL;
		__temp692 = NULL;
		__temp694 = NULL;
		cexpr = (__temp694 = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION ((__temp692 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), VALA_CCODE_EXPRESSION ((__temp693 = vala_ccode_constant_new ("1")))), (__temp693 == NULL ? NULL : (__temp693 = (g_object_unref (__temp693), NULL))), (__temp692 == NULL ? NULL : (__temp692 = (g_object_unref (__temp692), NULL))), __temp694);
		ccall = vala_code_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		__temp695 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp695 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
		(__temp695 == NULL ? NULL : (__temp695 = (g_object_unref (__temp695), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	__temp696 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp696 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_postfix_expression_get_inner (expr))))))));
	(__temp696 == NULL ? NULL : (__temp696 = (g_object_unref (__temp696), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaMemberAccess* __temp700;
	ValaMemberAccess* ma;
	gpointer __temp702;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* __temp697;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* __temp698;
		__temp697 = NULL;
		pe = (__temp697 = VALA_PARENTHESIZED_EXPRESSION (expr), (__temp697 == NULL ? NULL : g_object_ref (__temp697)));
		__temp698 = NULL;
		return (__temp698 = vala_code_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), __temp698);
		(pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL)));
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return VALA_MEMBER_ACCESS (NULL);
	}
	__temp700 = NULL;
	ma = (__temp700 = VALA_MEMBER_ACCESS (expr), (__temp700 == NULL ? NULL : g_object_ref (__temp700)));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) ma)))) {
		return ma;
	}
	return VALA_MEMBER_ACCESS ((__temp702 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp702));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaCCodeExpression* __temp703;
	ValaCCodeFunctionCall* __temp704;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	__temp703 = NULL;
	__temp704 = NULL;
	ccall = (__temp704 = vala_ccode_function_call_new ((__temp703 = vala_code_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr)))), (__temp703 == NULL ? NULL : (__temp703 = (g_object_unref (__temp703), NULL))), __temp704);
	if (vala_type_reference_get_non_null (vala_expression_get_static_type (expr)) && vala_type_reference_get_type_parameter (vala_expression_get_static_type (expr)) == NULL) {
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
		return VALA_CCODE_EXPRESSION (ccall);
	} else {
		ValaVariableDeclarator* decl;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeConstant* __temp706;
		ValaCCodeBinaryExpression* __temp707;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* __temp714;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* __temp722;
		ValaCCodeCommaExpression* __temp723;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), FALSE);
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl)));
		__temp706 = NULL;
		__temp707 = NULL;
		cisnull = (__temp707 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION ((__temp706 = vala_ccode_constant_new ("NULL")))), (__temp706 == NULL ? NULL : (__temp706 = (g_object_unref (__temp706), NULL))), __temp707);
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == NULL) {
			ValaCCodeConstant* __temp711;
			ValaCCodeExpression* __temp710;
			ValaCCodeBinaryExpression* __temp712;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* __temp713;
			if (!(VALA_IS_CLASS (self->priv->current_type_symbol))) {
				ValaCCodeExpression* __temp708;
				ValaCCodeExpression* __temp709;
				__temp708 = NULL;
				__temp709 = NULL;
				return (__temp709 = (__temp708 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), (__temp708 == NULL ? NULL : g_object_ref (__temp708))), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp709);
			}
			/* dup functions are optional for type parameters*/
			__temp711 = NULL;
			__temp710 = NULL;
			__temp712 = NULL;
			cdupisnull = (__temp712 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (__temp710 = vala_code_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr))), VALA_CCODE_EXPRESSION ((__temp711 = vala_ccode_constant_new ("NULL")))), (__temp711 == NULL ? NULL : (__temp711 = (g_object_unref (__temp711), NULL))), (__temp710 == NULL ? NULL : (__temp710 = (g_object_unref (__temp710), NULL))), __temp712);
			__temp713 = NULL;
			cisnull = (__temp713 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cdupisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp713);
			(cdupisnull == NULL ? NULL : (cdupisnull = (g_object_unref (cdupisnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		__temp714 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp714 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp714 == NULL ? NULL : (__temp714 = (g_object_unref (__temp714), NULL)));
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == self->priv->glist_type) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GeeList* type_arg_collection;
				GeeIterator* type_arg_it;
				type_arg_collection = vala_type_reference_get_type_arguments (vala_expression_get_static_type (expr));
				type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
				while (gee_iterator_next (type_arg_it)) {
					ValaTypeReference* type_arg;
					type_arg = gee_iterator_get (type_arg_it);
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
						(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
					}
				}
				(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
			}
			if (is_ref && (is_class || is_interface)) {
				ValaCCodeIdentifier* __temp715;
				ValaCCodeFunctionCall* __temp716;
				ValaCCodeFunctionCall* crefcall;
				ValaCCodeIdentifier* __temp717;
				ValaCCodeConstant* __temp718;
				__temp715 = NULL;
				__temp716 = NULL;
				crefcall = (__temp716 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp715 = vala_ccode_identifier_new ("g_list_foreach")))), (__temp715 == NULL ? NULL : (__temp715 = (g_object_unref (__temp715), NULL))), __temp716);
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION (ctemp));
				__temp717 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp717 = vala_ccode_identifier_new ("(GFunc) g_object_ref"))));
				(__temp717 == NULL ? NULL : (__temp717 = (g_object_unref (__temp717), NULL)));
				__temp718 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp718 = vala_ccode_constant_new ("NULL"))));
				(__temp718 == NULL ? NULL : (__temp718 = (g_object_unref (__temp718), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (crefcall));
				(crefcall == NULL ? NULL : (crefcall = (g_object_unref (crefcall), NULL)));
			}
		}
		cifnull = NULL;
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) != NULL) {
			ValaCCodeExpression* __temp719;
			__temp719 = NULL;
			cifnull = (__temp719 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), __temp719);
		} else {
			ValaCCodeExpression* __temp721;
			ValaCCodeIdentifier* __temp720;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters*/
			__temp721 = NULL;
			__temp720 = NULL;
			cifnull = (__temp721 = VALA_CCODE_EXPRESSION ((__temp720 = ctemp, (__temp720 == NULL ? NULL : g_object_ref (__temp720)))), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), __temp721);
		}
		__temp722 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp722 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), cifnull, VALA_CCODE_EXPRESSION (ccall)))));
		(__temp722 == NULL ? NULL : (__temp722 = (g_object_unref (__temp722), NULL)));
		__temp723 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp723 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp723));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL)));
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_type_reference_get_floating_reference (vala_expression_get_static_type (expr))) {
		ValaCCodeIdentifier* __temp724;
		ValaCCodeFunctionCall* __temp725;
		ValaCCodeFunctionCall* csink;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		__temp724 = NULL;
		__temp725 = NULL;
		csink = (__temp725 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp724 = vala_ccode_identifier_new ("g_object_ref_sink")))), (__temp724 == NULL ? NULL : (__temp724 = (g_object_unref (__temp724), NULL))), __temp725);
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaVariableDeclarator* decl;
		ValaCCodeParenthesizedExpression* __temp729;
		ValaCCodeAssignment* __temp728;
		ValaCCodeIdentifier* __temp727;
		char* __temp726;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, decl);
		gee_list_insert (GEE_LIST (self->priv->temp_ref_vars), 0, decl);
		__temp729 = NULL;
		__temp728 = NULL;
		__temp727 = NULL;
		__temp726 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp729 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((__temp728 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp727 = vala_ccode_identifier_new ((__temp726 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp729 == NULL ? NULL : (__temp729 = (g_object_unref (__temp729), NULL)));
		(__temp728 == NULL ? NULL : (__temp728 = (g_object_unref (__temp728), NULL)));
		(__temp727 == NULL ? NULL : (__temp727 = (g_object_unref (__temp727), NULL)));
		(__temp726 = (g_free (__temp726), NULL));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* __temp730;
			__temp730 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp730 = vala_code_generator_get_ref_expression (self, expr))));
			(__temp730 == NULL ? NULL : (__temp730 = (g_object_unref (__temp730), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	if (vala_expression_get_symbol_reference (((ValaExpression*) expr)) == NULL) {
		/* no creation method*/
		if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			ValaCCodeIdentifier* __temp731;
			ValaCCodeFunctionCall* __temp732;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* __temp734;
			char* __temp733;
			ValaCCodeConstant* __temp735;
			__temp731 = NULL;
			__temp732 = NULL;
			ccall = (__temp732 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp731 = vala_ccode_identifier_new ("g_object_new")))), (__temp731 == NULL ? NULL : (__temp731 = (g_object_unref (__temp731), NULL))), __temp732);
			__temp734 = NULL;
			__temp733 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp734 = vala_ccode_constant_new ((__temp733 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr))))))));
			(__temp734 == NULL ? NULL : (__temp734 = (g_object_unref (__temp734), NULL)));
			(__temp733 = (g_free (__temp733), NULL));
			__temp735 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp735 = vala_ccode_constant_new ("NULL"))));
			(__temp735 == NULL ? NULL : (__temp735 = (g_object_unref (__temp735), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->glist_type || vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->gslist_type) {
				ValaCCodeConstant* __temp736;
				/* NULL is an empty list*/
				__temp736 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp736 = vala_ccode_constant_new ("NULL"))));
				(__temp736 == NULL ? NULL : (__temp736 = (g_object_unref (__temp736), NULL)));
			} else {
				ValaCCodeIdentifier* __temp737;
				ValaCCodeFunctionCall* __temp738;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* __temp740;
				char* __temp739;
				ValaCCodeConstant* __temp741;
				__temp737 = NULL;
				__temp738 = NULL;
				ccall = (__temp738 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp737 = vala_ccode_identifier_new ("g_new0")))), (__temp737 == NULL ? NULL : (__temp737 = (g_object_unref (__temp737), NULL))), __temp738);
				__temp740 = NULL;
				__temp739 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp740 = vala_ccode_constant_new ((__temp739 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))))));
				(__temp740 == NULL ? NULL : (__temp740 = (g_object_unref (__temp740), NULL)));
				(__temp739 = (g_free (__temp739), NULL));
				__temp741 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp741 = vala_ccode_constant_new ("1"))));
				(__temp741 == NULL ? NULL : (__temp741 = (g_object_unref (__temp741), NULL)));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			}
		}
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
			ValaMethod* __temp742;
			ValaMethod* m;
			GeeCollection* params;
			ValaCCodeIdentifier* __temp744;
			char* __temp743;
			ValaCCodeFunctionCall* __temp745;
			ValaCCodeFunctionCall* ccall;
			gboolean ellipsis;
			gint i;
			GeeIterator* params_it;
			/* use creation method*/
			__temp742 = NULL;
			m = (__temp742 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp742 == NULL ? NULL : g_object_ref (__temp742)));
			params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
			__temp744 = NULL;
			__temp743 = NULL;
			__temp745 = NULL;
			ccall = (__temp745 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp744 = vala_ccode_identifier_new ((__temp743 = vala_method_get_cname (m)))))), (__temp744 == NULL ? NULL : (__temp744 = (g_object_unref (__temp744), NULL))), (__temp743 = (g_free (__temp743), NULL)), __temp745);
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
				{
					GeeList* type_arg_collection;
					GeeIterator* type_arg_it;
					type_arg_collection = vala_type_reference_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
					type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
					while (gee_iterator_next (type_arg_it)) {
						ValaTypeReference* type_arg;
						type_arg = gee_iterator_get (type_arg_it);
						{
							if (vala_type_reference_get_takes_ownership (type_arg)) {
								ValaCCodeExpression* __temp746;
								ValaCCodeExpression* __temp747;
								__temp746 = NULL;
								vala_ccode_function_call_add_argument (ccall, (__temp746 = vala_code_generator_get_dup_func_expression (self, type_arg)));
								(__temp746 == NULL ? NULL : (__temp746 = (g_object_unref (__temp746), NULL)));
								__temp747 = NULL;
								vala_ccode_function_call_add_argument (ccall, (__temp747 = vala_code_generator_get_destroy_func_expression (self, type_arg)));
								(__temp747 == NULL ? NULL : (__temp747 = (g_object_unref (__temp747), NULL)));
							} else {
								ValaCCodeConstant* __temp748;
								ValaCCodeConstant* __temp749;
								__temp748 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp748 = vala_ccode_constant_new ("NULL"))));
								(__temp748 == NULL ? NULL : (__temp748 = (g_object_unref (__temp748), NULL)));
								__temp749 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp749 = vala_ccode_constant_new ("NULL"))));
								(__temp749 == NULL ? NULL : (__temp749 = (g_object_unref (__temp749), NULL)));
							}
							(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
						}
					}
					(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
					(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				}
			}
			ellipsis = FALSE;
			i = 1;
			params_it = gee_iterable_iterator (GEE_ITERABLE (params));
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_object_creation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = gee_iterator_get (arg_it);
					{
						ValaCCodeExpression* __temp750;
						ValaCCodeExpression* cexpr;
						__temp750 = NULL;
						cexpr = (__temp750 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) arg))), (__temp750 == NULL ? NULL : g_object_ref (__temp750)));
						if (gee_iterator_next (params_it)) {
							ValaFormalParameter* param;
							param = gee_iterator_get (params_it);
							ellipsis = vala_formal_parameter_get_ellipsis (param);
							if (!vala_formal_parameter_get_ellipsis (param) && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeIdentifier* __temp752;
								char* __temp751;
								ValaCCodeFunctionCall* __temp753;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* __temp755;
								ValaCCodeFunctionCall* __temp754;
								/* FIXME: use C cast if debugging disabled*/
								__temp752 = NULL;
								__temp751 = NULL;
								__temp753 = NULL;
								ccall = (__temp753 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp752 = vala_ccode_identifier_new ((__temp751 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL)))))), (__temp752 == NULL ? NULL : (__temp752 = (g_object_unref (__temp752), NULL))), (__temp751 = (g_free (__temp751), NULL)), __temp753);
								vala_ccode_function_call_add_argument (ccall, cexpr);
								__temp755 = NULL;
								__temp754 = NULL;
								cexpr = (__temp755 = VALA_CCODE_EXPRESSION ((__temp754 = ccall, (__temp754 == NULL ? NULL : g_object_ref (__temp754)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp755);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
						vala_ccode_function_call_add_argument (ccall, cexpr);
						i++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (params_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* __temp756;
					__temp756 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), (__temp756 = g_strdup_printf ("no default expression for argument %d", i)));
					(__temp756 = (g_free (__temp756), NULL));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_formal_parameter_get_default_expression (param)))));
				i++;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
			if (vala_expression_get_can_fail (((ValaExpression*) expr))) {
				ValaCCodeUnaryExpression* __temp758;
				ValaCCodeIdentifier* __temp757;
				/* method can fail*/
				self->priv->current_method_inner_error = TRUE;
				__temp758 = NULL;
				__temp757 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp758 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp757 = vala_ccode_identifier_new ("inner_error")))))));
				(__temp758 == NULL ? NULL : (__temp758 = (g_object_unref (__temp758), NULL)));
				(__temp757 == NULL ? NULL : (__temp757 = (g_object_unref (__temp757), NULL)));
			}
			if (ellipsis) {
				ValaCCodeConstant* __temp759;
				/* ensure variable argument list ends with NULL*/
				__temp759 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp759 = vala_ccode_constant_new ("NULL"))));
				(__temp759 == NULL ? NULL : (__temp759 = (g_object_unref (__temp759), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
		} else {
			if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
				ValaEnumValue* __temp760;
				ValaEnumValue* ev;
				ValaEnum* __temp761;
				ValaEnum* en;
				ValaCCodeIdentifier* __temp762;
				ValaCCodeFunctionCall* __temp763;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp764;
				ValaCCodeIdentifier* __temp766;
				char* __temp765;
				ValaCCodeIdentifier* __temp768;
				char* __temp767;
				/* error code*/
				__temp760 = NULL;
				ev = (__temp760 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp760 == NULL ? NULL : g_object_ref (__temp760)));
				__temp761 = NULL;
				en = (__temp761 = VALA_ENUM (vala_symbol_get_parent_symbol (((ValaSymbol*) ev))), (__temp761 == NULL ? NULL : g_object_ref (__temp761)));
				__temp762 = NULL;
				__temp763 = NULL;
				ccall = (__temp763 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp762 = vala_ccode_identifier_new ("g_set_error")))), (__temp762 == NULL ? NULL : (__temp762 = (g_object_unref (__temp762), NULL))), __temp763);
				__temp764 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp764 = vala_ccode_identifier_new ("error"))));
				(__temp764 == NULL ? NULL : (__temp764 = (g_object_unref (__temp764), NULL)));
				__temp766 = NULL;
				__temp765 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp766 = vala_ccode_identifier_new ((__temp765 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (en), NULL))))));
				(__temp766 == NULL ? NULL : (__temp766 = (g_object_unref (__temp766), NULL)));
				(__temp765 = (g_free (__temp765), NULL));
				__temp768 = NULL;
				__temp767 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp768 = vala_ccode_identifier_new ((__temp767 = vala_enum_value_get_cname (ev))))));
				(__temp768 == NULL ? NULL : (__temp768 = (g_object_unref (__temp768), NULL)));
				(__temp767 = (g_free (__temp767), NULL));
				{
					GeeCollection* arg_collection;
					GeeIterator* arg_it;
					arg_collection = vala_object_creation_expression_get_argument_list (expr);
					arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
					while (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = gee_iterator_get (arg_it);
						{
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) arg))));
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						}
					}
					(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
					(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
				}
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
				(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
				(en == NULL ? NULL : (en = (g_object_unref (en), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			} else {
				g_assert (FALSE);
			}
		}
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp769;
	ValaCCodeFunctionCall* __temp770;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* __temp772;
	char* __temp771;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SIZEOF_EXPRESSION (expr));
	__temp769 = NULL;
	__temp770 = NULL;
	csizeof = (__temp770 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp769 = vala_ccode_identifier_new ("sizeof")))), (__temp769 == NULL ? NULL : (__temp769 = (g_object_unref (__temp769), NULL))), __temp770);
	__temp772 = NULL;
	__temp771 = NULL;
	vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((__temp772 = vala_ccode_identifier_new ((__temp771 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_sizeof_expression_get_type_reference (expr)), FALSE))))));
	(__temp772 == NULL ? NULL : (__temp772 = (g_object_unref (__temp772), NULL)));
	(__temp771 = (g_free (__temp771), NULL));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csizeof));
	(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
}


static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp774;
	char* __temp773;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (expr));
	__temp774 = NULL;
	__temp773 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp774 = vala_ccode_identifier_new ((__temp773 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_typeof_expression_get_type_reference (expr))))))));
	(__temp774 == NULL ? NULL : (__temp774 = (g_object_unref (__temp774), NULL)));
	(__temp773 = (g_free (__temp773), NULL));
}


static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* __temp775;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_UNARY_EXPRESSION (expr));
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	__temp775 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp775 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_unary_expression_get_inner (expr))))))));
	(__temp775 == NULL ? NULL : (__temp775 = (g_object_unref (__temp775), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (expr));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))) {
		ValaInstanceCast* __temp776;
		/* GObject cast*/
		__temp776 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp776 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_cast_expression_get_inner (expr)))), vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))))));
		(__temp776 == NULL ? NULL : (__temp776 = (g_object_unref (__temp776), NULL)));
	} else {
		ValaCCodeCastExpression* __temp778;
		char* __temp777;
		__temp778 = NULL;
		__temp777 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp778 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_cast_expression_get_inner (expr)))), (__temp777 = vala_type_reference_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))))));
		(__temp778 == NULL ? NULL : (__temp778 = (g_object_unref (__temp778), NULL)));
		(__temp777 = (g_free (__temp777), NULL));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* __temp779;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (expr));
	__temp779 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp779 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_pointer_indirection_get_inner (expr))))))));
	(__temp779 == NULL ? NULL : (__temp779 = (g_object_unref (__temp779), NULL)));
}


static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* __temp780;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (expr));
	__temp780 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp780 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_addressof_expression_get_inner (expr))))))));
	(__temp780 == NULL ? NULL : (__temp780 = (g_object_unref (__temp780), NULL)));
}


static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeCommaExpression* ccomma;
	ValaVariableDeclarator* temp_decl;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* __temp781;
	ValaCCodeAssignment* __temp783;
	ValaCCodeConstant* __temp782;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (((ValaExpression*) expr)), TRUE);
	gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
	cvar = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
	__temp781 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp781 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp781 == NULL ? NULL : (__temp781 = (g_object_unref (__temp781), NULL)));
	__temp783 = NULL;
	__temp782 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp783 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION ((__temp782 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp783 == NULL ? NULL : (__temp783 = (g_object_unref (__temp783), NULL)));
	(__temp782 == NULL ? NULL : (__temp782 = (g_object_unref (__temp782), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeBinaryOperator op;
	ValaCCodeExpression* __temp784;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* __temp785;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryExpression* __temp790;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BINARY_EXPRESSION (expr));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	__temp784 = NULL;
	cleft = (__temp784 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_binary_expression_get_left (expr)))), (__temp784 == NULL ? NULL : g_object_ref (__temp784)));
	__temp785 = NULL;
	cright = (__temp785 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_binary_expression_get_right (expr)))), (__temp785 == NULL ? NULL : g_object_ref (__temp785)));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		if (vala_expression_get_static_type (vala_binary_expression_get_left (expr)) != NULL && vala_expression_get_static_type (vala_binary_expression_get_right (expr)) != NULL && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr))))) {
			ValaClass* __temp786;
			ValaClass* left_cl;
			ValaClass* __temp787;
			ValaClass* right_cl;
			__temp786 = NULL;
			left_cl = (__temp786 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (__temp786 == NULL ? NULL : g_object_ref (__temp786)));
			__temp787 = NULL;
			right_cl = (__temp787 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (__temp787 == NULL ? NULL : g_object_ref (__temp787)));
			if (left_cl != right_cl) {
				if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (left_cl), VALA_DATA_TYPE (right_cl))) {
					ValaCCodeExpression* __temp788;
					__temp788 = NULL;
					cleft = (__temp788 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_DATA_TYPE (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), __temp788);
				} else {
					if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (right_cl), VALA_DATA_TYPE (left_cl))) {
						ValaCCodeExpression* __temp789;
						__temp789 = NULL;
						cright = (__temp789 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_DATA_TYPE (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), __temp789);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		}
	}
	__temp790 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp790 = vala_ccode_binary_expression_new (op, cleft, cright))));
	(__temp790 == NULL ? NULL : (__temp790 = (g_object_unref (__temp790), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp792;
	char* __temp791;
	ValaCCodeFunctionCall* __temp793;
	ValaCCodeFunctionCall* ccheck;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_TYPE_CHECK (expr));
	__temp792 = NULL;
	__temp791 = NULL;
	__temp793 = NULL;
	ccheck = (__temp793 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp792 = vala_ccode_identifier_new ((__temp791 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_type_check_get_type_reference (expr)), "IS_")))))), (__temp792 == NULL ? NULL : (__temp792 = (g_object_unref (__temp792), NULL))), (__temp791 = (g_free (__temp791), NULL)), __temp793);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_type_check_get_expression (expr)))));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccheck));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConditionalExpression* __temp794;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (expr));
	__temp794 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp794 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_conditional_expression_get_false_expression (expr))))))));
	(__temp794 == NULL ? NULL : (__temp794 = (g_object_unref (__temp794), NULL)));
}


static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp796;
	char* __temp795;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (l));
	__temp796 = NULL;
	__temp795 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((__temp796 = vala_ccode_identifier_new ((__temp795 = vala_method_get_cname (vala_lambda_expression_get_method (l)))))));
	(__temp796 == NULL ? NULL : (__temp796 = (g_object_unref (__temp796), NULL)));
	(__temp795 = (g_free (__temp795), NULL));
}


static ValaCCodeExpression* vala_code_generator_convert_from_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type)
{
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (actual_type), NULL);
	result = g_object_ref (cexpr);
	if (VALA_IS_STRUCT (vala_type_reference_get_data_type (actual_type))) {
		ValaStruct* __temp797;
		ValaStruct* st;
		__temp797 = NULL;
		st = (__temp797 = VALA_STRUCT (vala_type_reference_get_data_type (actual_type)), (__temp797 == NULL ? NULL : g_object_ref (__temp797)));
		if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
			ValaCCodeIdentifier* __temp798;
			ValaCCodeFunctionCall* __temp799;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* __temp801;
			ValaCCodeFunctionCall* __temp800;
			__temp798 = NULL;
			__temp799 = NULL;
			cconv = (__temp799 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp798 = vala_ccode_identifier_new ("GPOINTER_TO_UINT")))), (__temp798 == NULL ? NULL : (__temp798 = (g_object_unref (__temp798), NULL))), __temp799);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			__temp801 = NULL;
			__temp800 = NULL;
			result = (__temp801 = VALA_CCODE_EXPRESSION ((__temp800 = cconv, (__temp800 == NULL ? NULL : g_object_ref (__temp800)))), (result = (g_object_unref (result), NULL)), __temp801);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* __temp802;
				ValaCCodeFunctionCall* __temp803;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* __temp805;
				ValaCCodeFunctionCall* __temp804;
				__temp802 = NULL;
				__temp803 = NULL;
				cconv = (__temp803 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp802 = vala_ccode_identifier_new ("GPOINTER_TO_INT")))), (__temp802 == NULL ? NULL : (__temp802 = (g_object_unref (__temp802), NULL))), __temp803);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				__temp805 = NULL;
				__temp804 = NULL;
				result = (__temp805 = VALA_CCODE_EXPRESSION ((__temp804 = cconv, (__temp804 == NULL ? NULL : g_object_ref (__temp804)))), (result = (g_object_unref (result), NULL)), __temp805);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
	(result = (g_object_unref (result), NULL));
}


static ValaCCodeExpression* vala_code_generator_convert_to_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type)
{
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (actual_type), NULL);
	result = g_object_ref (cexpr);
	if (VALA_IS_STRUCT (vala_type_reference_get_data_type (actual_type))) {
		ValaStruct* __temp807;
		ValaStruct* st;
		__temp807 = NULL;
		st = (__temp807 = VALA_STRUCT (vala_type_reference_get_data_type (actual_type)), (__temp807 == NULL ? NULL : g_object_ref (__temp807)));
		if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
			ValaCCodeIdentifier* __temp808;
			ValaCCodeFunctionCall* __temp809;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* __temp811;
			ValaCCodeFunctionCall* __temp810;
			__temp808 = NULL;
			__temp809 = NULL;
			cconv = (__temp809 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp808 = vala_ccode_identifier_new ("GUINT_TO_POINTER")))), (__temp808 == NULL ? NULL : (__temp808 = (g_object_unref (__temp808), NULL))), __temp809);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			__temp811 = NULL;
			__temp810 = NULL;
			result = (__temp811 = VALA_CCODE_EXPRESSION ((__temp810 = cconv, (__temp810 == NULL ? NULL : g_object_ref (__temp810)))), (result = (g_object_unref (result), NULL)), __temp811);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* __temp812;
				ValaCCodeFunctionCall* __temp813;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* __temp815;
				ValaCCodeFunctionCall* __temp814;
				__temp812 = NULL;
				__temp813 = NULL;
				cconv = (__temp813 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp812 = vala_ccode_identifier_new ("GINT_TO_POINTER")))), (__temp812 == NULL ? NULL : (__temp812 = (g_object_unref (__temp812), NULL))), __temp813);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				__temp815 = NULL;
				__temp814 = NULL;
				result = (__temp815 = VALA_CCODE_EXPRESSION ((__temp814 = cconv, (__temp814 == NULL ? NULL : g_object_ref (__temp814)))), (result = (g_object_unref (result), NULL)), __temp815);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
	(result = (g_object_unref (result), NULL));
}


static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ASSIGNMENT (a));
	ma = NULL;
	if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* __temp818;
		ValaMemberAccess* __temp817;
		__temp818 = NULL;
		__temp817 = NULL;
		ma = (__temp818 = (__temp817 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (__temp817 == NULL ? NULL : g_object_ref (__temp817))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp818);
	}
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))) {
		ValaProperty* __temp819;
		ValaProperty* prop;
		__temp819 = NULL;
		prop = (__temp819 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (a))), (__temp819 == NULL ? NULL : g_object_ref (__temp819)));
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop)) && VALA_IS_CLASS (self->priv->current_type_symbol) && vala_member_access_get_inner (ma) == NULL && self->priv->in_creation_method) {
			ValaCCodeIdentifier* cpointer;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeMemberAccess* cnamemember;
			ValaCCodeConstant* __temp820;
			ValaCCodeAssignment* __temp821;
			ValaCCodeAssignment* cnameassign;
			ValaCCodeMemberAccess* __temp822;
			ValaCCodeUnaryExpression* __temp823;
			ValaCCodeUnaryExpression* gvaluearg;
			ValaCCodeIdentifier* __temp824;
			ValaCCodeFunctionCall* __temp825;
			ValaCCodeFunctionCall* cvalueinit;
			ValaCCodeIdentifier* __temp827;
			char* __temp826;
			ValaCCodeIdentifier* __temp828;
			ValaCCodeFunctionCall* __temp829;
			ValaCCodeFunctionCall* cvalueset;
			ValaCCodeUnaryExpression* __temp830;
			/* this property is used as a construction parameter*/
			cpointer = vala_ccode_identifier_new ("__params_it");
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			/* set name in array for current parameter*/
			cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
			__temp820 = NULL;
			__temp821 = NULL;
			cnameassign = (__temp821 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION ((__temp820 = vala_property_get_canonical_cconstant (prop))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp820 = (g_object_unref (__temp820), NULL)), __temp821);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
			__temp822 = NULL;
			__temp823 = NULL;
			gvaluearg = (__temp823 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp822 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")))), (__temp822 == NULL ? NULL : (__temp822 = (g_object_unref (__temp822), NULL))), __temp823);
			/* initialize GValue in array for current parameter*/
			__temp824 = NULL;
			__temp825 = NULL;
			cvalueinit = (__temp825 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp824 = vala_ccode_identifier_new ("g_value_init")))), (__temp824 == NULL ? NULL : (__temp824 = (g_object_unref (__temp824), NULL))), __temp825);
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
			__temp827 = NULL;
			__temp826 = NULL;
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp827 = vala_ccode_identifier_new ((__temp826 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))))))));
			(__temp827 == NULL ? NULL : (__temp827 = (g_object_unref (__temp827), NULL)));
			(__temp826 = (g_free (__temp826), NULL));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
			/* set GValue for current parameter*/
			__temp828 = NULL;
			__temp829 = NULL;
			cvalueset = (__temp829 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp828 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))))), (__temp828 = (g_object_unref (__temp828), NULL)), __temp829);
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
			/* move pointer to next parameter in array*/
			__temp830 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp830 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
			(__temp830 == NULL ? NULL : (__temp830 = (g_object_unref (__temp830), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
			(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
			(cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL)));
			(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
			(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
			(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
		} else {
			ValaCCodeExpression* __temp831;
			ValaCCodeExpression* cexpr;
			ValaCCodeFunctionCall* ccall;
			__temp831 = NULL;
			cexpr = (__temp831 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))), (__temp831 == NULL ? NULL : g_object_ref (__temp831)));
			if (!vala_property_get_no_accessor_method (prop) && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a)))) {
				ValaCCodeIdentifier* __temp833;
				char* __temp832;
				ValaCCodeFunctionCall* __temp834;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeExpression* __temp836;
				ValaCCodeFunctionCall* __temp835;
				/* cast is necessary */
				__temp833 = NULL;
				__temp832 = NULL;
				__temp834 = NULL;
				ccast = (__temp834 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp833 = vala_ccode_identifier_new ((__temp832 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), NULL)))))), (__temp833 == NULL ? NULL : (__temp833 = (g_object_unref (__temp833), NULL))), (__temp832 = (g_free (__temp832), NULL)), __temp834);
				vala_ccode_function_call_add_argument (ccast, cexpr);
				__temp836 = NULL;
				__temp835 = NULL;
				cexpr = (__temp836 = VALA_CCODE_EXPRESSION ((__temp835 = ccast, (__temp835 == NULL ? NULL : g_object_ref (__temp835)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp836);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			if (vala_assignment_get_operator (a) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
				ValaCCodeBinaryOperator cop;
				ValaCCodeExpression* __temp838;
				ValaCCodeParenthesizedExpression* __temp837;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_BINARY_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_BINARY_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_BINARY_OPERATOR_MOD;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp838 = NULL;
				__temp837 = NULL;
				cexpr = (__temp838 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), VALA_CCODE_EXPRESSION ((__temp837 = vala_ccode_parenthesized_expression_new (cexpr))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp838);
				(__temp837 == NULL ? NULL : (__temp837 = (g_object_unref (__temp837), NULL)));
			}
			ccall = vala_code_generator_get_property_set_call (self, prop, ma, cexpr);
			/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
			if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) a))))) {
				ValaCCodeCommaExpression* ccomma;
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
				/* update property*/
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) ma))));
				/* current property value*/
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			} else {
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall));
			}
			(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	} else {
		if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))) {
			ValaSignal* __temp839;
			ValaSignal* sig;
			ValaMethod* __temp840;
			ValaMethod* m;
			char* connect_func;
			gboolean disconnect;
			ValaCCodeIdentifier* __temp844;
			ValaCCodeFunctionCall* __temp845;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeCastExpression* __temp864;
			ValaCCodeIdentifier* __temp863;
			char* __temp862;
			__temp839 = NULL;
			sig = (__temp839 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (a))), (__temp839 == NULL ? NULL : g_object_ref (__temp839)));
			__temp840 = NULL;
			m = (__temp840 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (a))), (__temp840 == NULL ? NULL : g_object_ref (__temp840)));
			connect_func = NULL;
			disconnect = FALSE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
				char* __temp841;
				__temp841 = NULL;
				connect_func = (__temp841 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), __temp841);
				if (!vala_method_get_instance (m)) {
					char* __temp842;
					__temp842 = NULL;
					connect_func = (__temp842 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), __temp842);
				}
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
					char* __temp843;
					__temp843 = NULL;
					connect_func = (__temp843 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), __temp843);
					disconnect = TRUE;
				} else {
					vala_code_node_set_error (VALA_CODE_NODE (a), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) a)), "Specified compound assignment type for signals not supported.");
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(connect_func = (g_free (connect_func), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					return;
				}
			}
			__temp844 = NULL;
			__temp845 = NULL;
			ccall = (__temp845 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp844 = vala_ccode_identifier_new (connect_func)))), (__temp844 == NULL ? NULL : (__temp844 = (g_object_unref (__temp844), NULL))), __temp845);
			if (vala_member_access_get_inner (ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))));
			} else {
				ValaCCodeIdentifier* __temp846;
				__temp846 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp846 = vala_ccode_identifier_new ("self"))));
				(__temp846 == NULL ? NULL : (__temp846 = (g_object_unref (__temp846), NULL)));
			}
			if (!disconnect) {
				ValaCCodeConstant* __temp847;
				__temp847 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp847 = vala_signal_get_canonical_cconstant (sig))));
				(__temp847 = (g_object_unref (__temp847), NULL));
			} else {
				ValaCCodeConstant* __temp848;
				ValaCCodeCommaExpression* ccomma;
				ValaVariableDeclarator* temp_decl;
				ValaCCodeIdentifier* __temp849;
				ValaCCodeFunctionCall* __temp850;
				ValaCCodeFunctionCall* parse_call;
				ValaCCodeConstant* __temp851;
				ValaDataType* __temp852;
				ValaDataType* decl_type;
				ValaCCodeIdentifier* __temp854;
				char* __temp853;
				ValaCCodeUnaryExpression* __temp856;
				ValaCCodeIdentifier* __temp855;
				ValaCCodeConstant* __temp857;
				ValaCCodeConstant* __temp858;
				ValaCCodeIdentifier* __temp859;
				ValaCCodeConstant* __temp860;
				ValaCCodeConstant* __temp861;
				__temp848 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp848 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
				(__temp848 == NULL ? NULL : (__temp848 = (g_object_unref (__temp848), NULL)));
				/* get signal id*/
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->uint_type, TRUE);
				gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
				__temp849 = NULL;
				__temp850 = NULL;
				parse_call = (__temp850 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp849 = vala_ccode_identifier_new ("g_signal_parse_name")))), (__temp849 == NULL ? NULL : (__temp849 = (g_object_unref (__temp849), NULL))), __temp850);
				__temp851 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp851 = vala_signal_get_canonical_cconstant (sig))));
				(__temp851 = (g_object_unref (__temp851), NULL));
				__temp852 = NULL;
				decl_type = (__temp852 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) sig))), (__temp852 == NULL ? NULL : g_object_ref (__temp852)));
				__temp854 = NULL;
				__temp853 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp854 = vala_ccode_identifier_new ((__temp853 = vala_data_type_get_type_id (decl_type))))));
				(__temp854 == NULL ? NULL : (__temp854 = (g_object_unref (__temp854), NULL)));
				(__temp853 = (g_free (__temp853), NULL));
				__temp856 = NULL;
				__temp855 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp856 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp855 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)))))))));
				(__temp856 == NULL ? NULL : (__temp856 = (g_object_unref (__temp856), NULL)));
				(__temp855 == NULL ? NULL : (__temp855 = (g_object_unref (__temp855), NULL)));
				__temp857 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp857 = vala_ccode_constant_new ("NULL"))));
				(__temp857 == NULL ? NULL : (__temp857 = (g_object_unref (__temp857), NULL)));
				__temp858 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp858 = vala_ccode_constant_new ("FALSE"))));
				(__temp858 == NULL ? NULL : (__temp858 = (g_object_unref (__temp858), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
				__temp859 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp859 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
				(__temp859 == NULL ? NULL : (__temp859 = (g_object_unref (__temp859), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
				__temp860 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp860 = vala_ccode_constant_new ("0"))));
				(__temp860 == NULL ? NULL : (__temp860 = (g_object_unref (__temp860), NULL)));
				__temp861 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp861 = vala_ccode_constant_new ("NULL"))));
				(__temp861 == NULL ? NULL : (__temp861 = (g_object_unref (__temp861), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
				(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
			}
			__temp864 = NULL;
			__temp863 = NULL;
			__temp862 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp864 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((__temp863 = vala_ccode_identifier_new ((__temp862 = vala_method_get_cname (m))))), "GCallback"))));
			(__temp864 == NULL ? NULL : (__temp864 = (g_object_unref (__temp864), NULL)));
			(__temp863 == NULL ? NULL : (__temp863 = (g_object_unref (__temp863), NULL)));
			(__temp862 = (g_free (__temp862), NULL));
			if (vala_method_get_instance (m)) {
				if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (a))) {
					ValaMemberAccess* __temp865;
					ValaMemberAccess* right_ma;
					__temp865 = NULL;
					right_ma = (__temp865 = VALA_MEMBER_ACCESS (vala_assignment_get_right (a)), (__temp865 == NULL ? NULL : g_object_ref (__temp865)));
					if (vala_member_access_get_inner (right_ma) != NULL) {
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (right_ma)))));
					} else {
						ValaCCodeIdentifier* __temp866;
						__temp866 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp866 = vala_ccode_identifier_new ("self"))));
						(__temp866 == NULL ? NULL : (__temp866 = (g_object_unref (__temp866), NULL)));
					}
					(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
				} else {
					if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (a))) {
						ValaCCodeIdentifier* __temp867;
						__temp867 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp867 = vala_ccode_identifier_new ("self"))));
						(__temp867 == NULL ? NULL : (__temp867 = (g_object_unref (__temp867), NULL)));
					}
				}
				if (!disconnect) {
					ValaCCodeConstant* __temp868;
					__temp868 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp868 = vala_ccode_constant_new ("0"))));
					(__temp868 == NULL ? NULL : (__temp868 = (g_object_unref (__temp868), NULL)));
				}
			} else {
				ValaCCodeConstant* __temp869;
				__temp869 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp869 = vala_ccode_constant_new ("NULL"))));
				(__temp869 == NULL ? NULL : (__temp869 = (g_object_unref (__temp869), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(connect_func = (g_free (connect_func), NULL));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (a)) && !(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (a))))))))) {
				ValaCCodeExpression* __temp870;
				ValaCCodeExpression* rhs;
				ValaElementAccess* __temp876;
				ValaElementAccess* expr;
				ValaDataType* __temp877;
				ValaDataType* container_type;
				GeeCollection* indices;
				GeeIterator* indices_it;
				ValaCCodeExpression* __temp878;
				ValaCCodeExpression* ccontainer;
				ValaCCodeExpression* __temp880;
				ValaExpression* __temp879;
				ValaCCodeExpression* __temp881;
				ValaCCodeExpression* cindex;
				/* custom element access*/
				__temp870 = NULL;
				rhs = (__temp870 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))), (__temp870 == NULL ? NULL : g_object_ref (__temp870)));
				if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
					ValaCCodeIdentifier* __temp872;
					char* __temp871;
					ValaCCodeFunctionCall* __temp873;
					ValaCCodeFunctionCall* ccast;
					ValaCCodeExpression* __temp875;
					ValaCCodeFunctionCall* __temp874;
					__temp872 = NULL;
					__temp871 = NULL;
					__temp873 = NULL;
					ccast = (__temp873 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp872 = vala_ccode_identifier_new ((__temp871 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL)))))), (__temp872 == NULL ? NULL : (__temp872 = (g_object_unref (__temp872), NULL))), (__temp871 = (g_free (__temp871), NULL)), __temp873);
					vala_ccode_function_call_add_argument (ccast, rhs);
					__temp875 = NULL;
					__temp874 = NULL;
					rhs = (__temp875 = VALA_CCODE_EXPRESSION ((__temp874 = ccast, (__temp874 == NULL ? NULL : g_object_ref (__temp874)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp875);
					(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
				}
				__temp876 = NULL;
				expr = (__temp876 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (a)), (__temp876 == NULL ? NULL : g_object_ref (__temp876)));
				__temp877 = NULL;
				container_type = (__temp877 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (__temp877 == NULL ? NULL : g_object_ref (__temp877)));
				indices = GEE_COLLECTION (vala_element_access_get_indices (expr));
				indices_it = gee_iterable_iterator (GEE_ITERABLE (indices));
				gee_iterator_next (indices_it);
				__temp878 = NULL;
				ccontainer = (__temp878 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_element_access_get_container (expr)))), (__temp878 == NULL ? NULL : g_object_ref (__temp878)));
				__temp880 = NULL;
				__temp879 = NULL;
				__temp881 = NULL;
				cindex = (__temp881 = (__temp880 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (__temp879 = gee_iterator_get (indices_it))))), (__temp880 == NULL ? NULL : g_object_ref (__temp880))), (__temp879 == NULL ? NULL : (__temp879 = (g_object_unref (__temp879), NULL))), __temp881);
				if (container_type != NULL && self->priv->list_type != NULL && self->priv->map_type != NULL && (container_type == self->priv->list_type || vala_data_type_is_subtype_of (container_type, self->priv->list_type) || container_type == self->priv->map_type || vala_data_type_is_subtype_of (container_type, self->priv->map_type))) {
					ValaMethod* set_method;
					GeeCollection* set_params;
					GeeIterator* set_params_it;
					ValaFormalParameter* set_param;
					ValaCCodeIdentifier* __temp884;
					char* __temp883;
					ValaCCodeFunctionCall* __temp885;
					ValaCCodeFunctionCall* set_ccall;
					ValaCCodeCastExpression* __temp888;
					char* __temp887;
					char* __temp886;
					ValaCCodeExpression* __temp889;
					set_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) container_type)), "set"));
					set_params = vala_invokable_get_parameters (VALA_INVOKABLE (set_method));
					set_params_it = gee_iterable_iterator (GEE_ITERABLE (set_params));
					gee_iterator_next (set_params_it);
					set_param = gee_iterator_get (set_params_it);
					if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (set_param)) != NULL) {
						ValaTypeReference* index_type;
						ValaCCodeExpression* __temp882;
						index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (set_method), vala_formal_parameter_get_type_reference (set_param), VALA_CODE_NODE (a));
						__temp882 = NULL;
						cindex = (__temp882 = vala_code_generator_convert_to_generic_pointer (self, cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), __temp882);
						(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
					}
					__temp884 = NULL;
					__temp883 = NULL;
					__temp885 = NULL;
					set_ccall = (__temp885 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp884 = vala_ccode_identifier_new ((__temp883 = vala_method_get_cname (set_method)))))), (__temp884 == NULL ? NULL : (__temp884 = (g_object_unref (__temp884), NULL))), (__temp883 = (g_free (__temp883), NULL)), __temp885);
					__temp888 = NULL;
					__temp887 = NULL;
					__temp886 = NULL;
					vala_ccode_function_call_add_argument (set_ccall, VALA_CCODE_EXPRESSION ((__temp888 = vala_ccode_cast_expression_new (ccontainer, (__temp887 = g_strconcat ((__temp886 = vala_data_type_get_cname (container_type, FALSE)), "*", NULL))))));
					(__temp888 == NULL ? NULL : (__temp888 = (g_object_unref (__temp888), NULL)));
					(__temp887 = (g_free (__temp887), NULL));
					(__temp886 = (g_free (__temp886), NULL));
					vala_ccode_function_call_add_argument (set_ccall, cindex);
					__temp889 = NULL;
					vala_ccode_function_call_add_argument (set_ccall, (__temp889 = vala_code_generator_convert_to_generic_pointer (self, rhs, vala_expression_get_static_type (((ValaExpression*) expr)))));
					(__temp889 = (g_object_unref (__temp889), NULL));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (set_ccall));
					(set_method == NULL ? NULL : (set_method = (g_object_unref (set_method), NULL)));
					(set_params == NULL ? NULL : (set_params = (g_object_unref (set_params), NULL)));
					(set_params_it == NULL ? NULL : (set_params_it = (g_object_unref (set_params_it), NULL)));
					(set_param == NULL ? NULL : (set_param = (g_object_unref (set_param), NULL)));
					(set_ccall == NULL ? NULL : (set_ccall = (g_object_unref (set_ccall), NULL)));
				} else {
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) a)), "internal error: unsupported element access");
					vala_code_node_set_error (VALA_CODE_NODE (a), TRUE);
				}
				(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
				(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
				(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
				(indices_it == NULL ? NULL : (indices_it = (g_object_unref (indices_it), NULL)));
				(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
				(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
			} else {
				ValaCCodeExpression* __temp890;
				ValaCCodeExpression* rhs;
				gboolean unref_old;
				gboolean array;
				ValaCCodeAssignmentOperator cop;
				ValaCCodeAssignment* __temp903;
				__temp890 = NULL;
				rhs = (__temp890 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))), (__temp890 == NULL ? NULL : g_object_ref (__temp890)));
				if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
					ValaCCodeIdentifier* __temp892;
					char* __temp891;
					ValaCCodeFunctionCall* __temp893;
					ValaCCodeFunctionCall* ccast;
					ValaCCodeExpression* __temp895;
					ValaCCodeFunctionCall* __temp894;
					__temp892 = NULL;
					__temp891 = NULL;
					__temp893 = NULL;
					ccast = (__temp893 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp892 = vala_ccode_identifier_new ((__temp891 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL)))))), (__temp892 == NULL ? NULL : (__temp892 = (g_object_unref (__temp892), NULL))), (__temp891 = (g_free (__temp891), NULL)), __temp893);
					vala_ccode_function_call_add_argument (ccast, rhs);
					__temp895 = NULL;
					__temp894 = NULL;
					rhs = (__temp895 = VALA_CCODE_EXPRESSION ((__temp894 = ccast, (__temp894 == NULL ? NULL : g_object_ref (__temp894)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp895);
					(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
				}
				unref_old = (vala_code_generator_get_memory_management (self) && vala_type_reference_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (a))));
				array = FALSE;
				if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))))) {
					array = !(VALA_IS_CCODE_CONSTANT (vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1)));
				}
				if (unref_old || array) {
					ValaCCodeCommaExpression* ccomma;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeAssignment* __temp897;
					ValaCCodeIdentifier* __temp896;
					ValaCCodeIdentifier* __temp900;
					ValaCCodeExpression* __temp902;
					ValaCCodeCommaExpression* __temp901;
					ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_assignment_get_left (a)), TRUE);
					gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
					__temp897 = NULL;
					__temp896 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp897 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp896 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp897 == NULL ? NULL : (__temp897 = (g_object_unref (__temp897), NULL)));
					(__temp896 == NULL ? NULL : (__temp896 = (g_object_unref (__temp896), NULL)));
					if (unref_old) {
						ValaCCodeExpression* __temp898;
						/* unref old value */
						__temp898 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (__temp898 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), vala_expression_get_static_type (vala_assignment_get_left (a)), vala_assignment_get_left (a))));
						(__temp898 == NULL ? NULL : (__temp898 = (g_object_unref (__temp898), NULL)));
					}
					if (array) {
						ValaCCodeExpression* lhs_array_len;
						ValaCCodeExpression* rhs_array_len;
						ValaCCodeAssignment* __temp899;
						lhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1);
						rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_right (a), 1);
						__temp899 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp899 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
						(__temp899 == NULL ? NULL : (__temp899 = (g_object_unref (__temp899), NULL)));
						(lhs_array_len = (g_object_unref (lhs_array_len), NULL));
						(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
					}
					__temp900 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp900 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
					(__temp900 == NULL ? NULL : (__temp900 = (g_object_unref (__temp900), NULL)));
					__temp902 = NULL;
					__temp901 = NULL;
					rhs = (__temp902 = VALA_CCODE_EXPRESSION ((__temp901 = ccomma, (__temp901 == NULL ? NULL : g_object_ref (__temp901)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp902);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				}
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp903 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE ((__temp903 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), rhs, cop))));
				(__temp903 == NULL ? NULL : (__temp903 = (g_object_unref (__temp903), NULL)));
				if (unref_old && VALA_IS_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a))))) {
					ValaCCodeElementAccess* __temp904;
					ValaCCodeElementAccess* cea;
					/* ensure that index expression in element access doesn't get evaluated more than once
					 except when it's a simple expression*/
					__temp904 = NULL;
					cea = (__temp904 = VALA_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), (__temp904 == NULL ? NULL : g_object_ref (__temp904)));
					if (!(VALA_IS_CCODE_CONSTANT (vala_ccode_element_access_get_index (cea)) || VALA_IS_CCODE_IDENTIFIER (vala_ccode_element_access_get_index (cea)))) {
						ValaVariableDeclarator* index_temp_decl;
						ValaCCodeCommaExpression* ccomma;
						ValaCCodeAssignment* __temp906;
						ValaCCodeIdentifier* __temp905;
						ValaCCodeIdentifier* __temp907;
						index_temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
						gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, index_temp_decl);
						ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
						__temp906 = NULL;
						__temp905 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp906 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp905 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) index_temp_decl))))), vala_ccode_element_access_get_index (cea), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
						(__temp906 == NULL ? NULL : (__temp906 = (g_object_unref (__temp906), NULL)));
						(__temp905 == NULL ? NULL : (__temp905 = (g_object_unref (__temp905), NULL)));
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) a))));
						__temp907 = NULL;
						vala_ccode_element_access_set_index (cea, VALA_CCODE_EXPRESSION ((__temp907 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) index_temp_decl))))));
						(__temp907 == NULL ? NULL : (__temp907 = (g_object_unref (__temp907), NULL)));
						vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
						(index_temp_decl == NULL ? NULL : (index_temp_decl = (g_object_unref (index_temp_decl), NULL)));
						(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					}
					(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
				}
				(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
			}
		}
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr)
{
	ValaClass* __temp908;
	ValaClass* cl;
	char* set_func;
	ValaProperty* base_property;
	ValaCCodeIdentifier* __temp916;
	ValaCCodeFunctionCall* __temp917;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* instance;
	gboolean req_cast;
	ValaCCodeFunctionCall* __temp928;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	__temp908 = NULL;
	cl = (__temp908 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) prop))), (__temp908 == NULL ? NULL : g_object_ref (__temp908)));
	set_func = g_strdup ("g_object_set");
	base_property = g_object_ref (prop);
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaDataType* __temp913;
		ValaDataType* base_property_type;
		char* __temp915;
		char* __temp914;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* __temp910;
			ValaProperty* __temp909;
			__temp910 = NULL;
			__temp909 = NULL;
			base_property = (__temp910 = (__temp909 = vala_property_get_base_property (prop), (__temp909 == NULL ? NULL : g_object_ref (__temp909))), (base_property = (g_object_unref (base_property), NULL)), __temp910);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* __temp912;
				ValaProperty* __temp911;
				__temp912 = NULL;
				__temp911 = NULL;
				base_property = (__temp912 = (__temp911 = vala_property_get_base_interface_property (prop), (__temp911 == NULL ? NULL : g_object_ref (__temp911))), (base_property = (g_object_unref (base_property), NULL)), __temp912);
			}
		}
		__temp913 = NULL;
		base_property_type = (__temp913 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property))), (__temp913 == NULL ? NULL : g_object_ref (__temp913)));
		__temp915 = NULL;
		__temp914 = NULL;
		set_func = (__temp915 = g_strdup_printf ("%s_set_%s", (__temp914 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (((ValaSymbol*) base_property))), (set_func = (g_free (set_func), NULL)), __temp915);
		(__temp914 = (g_free (__temp914), NULL));
		(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
	}
	__temp916 = NULL;
	__temp917 = NULL;
	ccall = (__temp917 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp916 = vala_ccode_identifier_new (set_func)))), (__temp916 == NULL ? NULL : (__temp916 = (g_object_unref (__temp916), NULL))), __temp917);
	/* target instance is first argument */
	instance = NULL;
	req_cast = FALSE;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* __temp918;
		__temp918 = NULL;
		instance = (__temp918 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp918);
		/* require casts for inherited properties */
		req_cast = (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property)) != self->priv->current_type_symbol);
	} else {
		ValaCCodeExpression* __temp920;
		ValaCCodeExpression* __temp919;
		__temp920 = NULL;
		__temp919 = NULL;
		instance = (__temp920 = (__temp919 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (__temp919 == NULL ? NULL : g_object_ref (__temp919))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp920);
		/* require casts if the type of the used instance is
		 * different than the type which declared the property */
		req_cast = vala_symbol_get_parent_symbol (((ValaSymbol*) base_property)) != VALA_SYMBOL (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
	}
	if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) prop)))))) {
		ValaCCodeIdentifier* __temp922;
		char* __temp921;
		ValaCCodeFunctionCall* __temp923;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpression* __temp925;
		ValaCCodeFunctionCall* __temp924;
		__temp922 = NULL;
		__temp921 = NULL;
		__temp923 = NULL;
		ccast = (__temp923 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp922 = vala_ccode_identifier_new ((__temp921 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property)))), NULL)))))), (__temp922 == NULL ? NULL : (__temp922 = (g_object_unref (__temp922), NULL))), (__temp921 = (g_free (__temp921), NULL)), __temp923);
		vala_ccode_function_call_add_argument (ccast, instance);
		__temp925 = NULL;
		__temp924 = NULL;
		instance = (__temp925 = VALA_CCODE_EXPRESSION ((__temp924 = ccast, (__temp924 == NULL ? NULL : g_object_ref (__temp924)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp925);
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp926;
		/* property name is second argument of g_object_set */
		__temp926 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp926 = vala_property_get_canonical_cconstant (prop))));
		(__temp926 = (g_object_unref (__temp926), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp927;
		__temp927 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp927 = vala_ccode_constant_new ("NULL"))));
		(__temp927 == NULL ? NULL : (__temp927 = (g_object_unref (__temp927), NULL)));
	}
	__temp928 = NULL;
	return (__temp928 = ccall, (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), (set_func = (g_free (set_func), NULL)), (base_property = (g_object_unref (base_property), NULL)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp928);
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(set_func = (g_free (set_func), NULL));
	(base_property = (g_object_unref (base_property), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp929;
	ValaSymbol* old_symbol;
	ValaSymbol* __temp930;
	ValaSymbol* old_type_symbol;
	ValaClass* __temp931;
	ValaClass* old_class;
	ValaCCodeStruct* __temp932;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeStruct* __temp933;
	ValaCCodeStruct* old_type_struct;
	ValaCCodeStruct* __temp934;
	ValaCCodeStruct* old_instance_priv_struct;
	ValaCCodeEnum* __temp935;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* __temp936;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* __temp937;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaSymbol* __temp938;
	ValaSymbol* __temp939;
	ValaClass* __temp940;
	ValaCCodeStruct* __temp943;
	char* __temp942;
	char* __temp941;
	ValaCCodeStruct* __temp946;
	char* __temp945;
	char* __temp944;
	ValaCCodeStruct* __temp949;
	char* __temp948;
	char* __temp947;
	ValaCCodeEnum* __temp950;
	char* __temp952;
	char* __temp951;
	ValaCCodeFragment* __temp953;
	ValaCCodeFragment* __temp954;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaCCodeNewline* __temp963;
	char* __temp964;
	char* __temp965;
	char* macro;
	ValaCCodeMacroReplacement* __temp967;
	char* __temp966;
	char* __temp970;
	char* __temp969;
	char* __temp968;
	ValaCCodeMacroReplacement* __temp973;
	char* __temp972;
	char* __temp971;
	char* __temp976;
	char* __temp975;
	char* __temp974;
	ValaCCodeMacroReplacement* __temp979;
	char* __temp978;
	char* __temp977;
	char* __temp981;
	char* __temp980;
	ValaCCodeMacroReplacement* __temp984;
	char* __temp983;
	char* __temp982;
	char* __temp986;
	char* __temp985;
	ValaCCodeMacroReplacement* __temp989;
	char* __temp988;
	char* __temp987;
	char* __temp992;
	char* __temp991;
	char* __temp990;
	ValaCCodeMacroReplacement* __temp995;
	char* __temp994;
	char* __temp993;
	ValaCCodeNewline* __temp996;
	ValaCCodeTypeDefinition* __temp1010;
	ValaCCodeVariableDeclarator* __temp1009;
	char* __temp1008;
	char* __temp1007;
	char* __temp1006;
	char* __temp1011;
	char* __temp1013;
	char* __temp1012;
	char* __temp1015;
	char* __temp1014;
	ValaSymbol* __temp1035;
	ValaSymbol* __temp1034;
	ValaClass* __temp1037;
	ValaClass* __temp1036;
	ValaCCodeStruct* __temp1039;
	ValaCCodeStruct* __temp1038;
	ValaCCodeStruct* __temp1041;
	ValaCCodeStruct* __temp1040;
	ValaCCodeStruct* __temp1043;
	ValaCCodeStruct* __temp1042;
	ValaCCodeEnum* __temp1045;
	ValaCCodeEnum* __temp1044;
	ValaCCodeFragment* __temp1047;
	ValaCCodeFragment* __temp1046;
	ValaCCodeFragment* __temp1049;
	ValaCCodeFragment* __temp1048;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp929 = NULL;
	old_symbol = (__temp929 = self->priv->current_symbol, (__temp929 == NULL ? NULL : g_object_ref (__temp929)));
	__temp930 = NULL;
	old_type_symbol = (__temp930 = self->priv->current_type_symbol, (__temp930 == NULL ? NULL : g_object_ref (__temp930)));
	__temp931 = NULL;
	old_class = (__temp931 = self->priv->current_class, (__temp931 == NULL ? NULL : g_object_ref (__temp931)));
	__temp932 = NULL;
	old_instance_struct = (__temp932 = self->priv->instance_struct, (__temp932 == NULL ? NULL : g_object_ref (__temp932)));
	__temp933 = NULL;
	old_type_struct = (__temp933 = self->priv->type_struct, (__temp933 == NULL ? NULL : g_object_ref (__temp933)));
	__temp934 = NULL;
	old_instance_priv_struct = (__temp934 = self->priv->instance_priv_struct, (__temp934 == NULL ? NULL : g_object_ref (__temp934)));
	__temp935 = NULL;
	old_prop_enum = (__temp935 = self->priv->prop_enum, (__temp935 == NULL ? NULL : g_object_ref (__temp935)));
	__temp936 = NULL;
	old_instance_init_fragment = (__temp936 = self->priv->instance_init_fragment, (__temp936 == NULL ? NULL : g_object_ref (__temp936)));
	__temp937 = NULL;
	old_instance_dispose_fragment = (__temp937 = self->priv->instance_dispose_fragment, (__temp937 == NULL ? NULL : g_object_ref (__temp937)));
	__temp938 = NULL;
	self->priv->current_symbol = (__temp938 = VALA_SYMBOL (g_object_ref (cl)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp938);
	__temp939 = NULL;
	self->priv->current_type_symbol = (__temp939 = VALA_SYMBOL (g_object_ref (cl)), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp939);
	__temp940 = NULL;
	self->priv->current_class = (__temp940 = g_object_ref (cl), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp940);
	if (vala_class_get_is_static (cl)) {
		(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
		(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
		(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
		(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
		(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
		(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
		(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
		(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
		(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
		return;
	}
	__temp943 = NULL;
	__temp942 = NULL;
	__temp941 = NULL;
	self->priv->instance_struct = (__temp943 = vala_ccode_struct_new ((__temp942 = g_strdup_printf ("_%s", (__temp941 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp943);
	(__temp942 = (g_free (__temp942), NULL));
	(__temp941 = (g_free (__temp941), NULL));
	__temp946 = NULL;
	__temp945 = NULL;
	__temp944 = NULL;
	self->priv->type_struct = (__temp946 = vala_ccode_struct_new ((__temp945 = g_strdup_printf ("_%sClass", (__temp944 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp946);
	(__temp945 = (g_free (__temp945), NULL));
	(__temp944 = (g_free (__temp944), NULL));
	__temp949 = NULL;
	__temp948 = NULL;
	__temp947 = NULL;
	self->priv->instance_priv_struct = (__temp949 = vala_ccode_struct_new ((__temp948 = g_strdup_printf ("_%sPrivate", (__temp947 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), __temp949);
	(__temp948 = (g_free (__temp948), NULL));
	(__temp947 = (g_free (__temp947), NULL));
	__temp950 = NULL;
	self->priv->prop_enum = (__temp950 = vala_ccode_enum_new (NULL), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), __temp950);
	__temp952 = NULL;
	__temp951 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp952 = g_strdup_printf ("%s_DUMMY_PROPERTY", (__temp951 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), NULL);
	(__temp952 = (g_free (__temp952), NULL));
	(__temp951 = (g_free (__temp951), NULL));
	__temp953 = NULL;
	self->priv->instance_init_fragment = (__temp953 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), __temp953);
	__temp954 = NULL;
	self->priv->instance_dispose_fragment = (__temp954 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp954);
	decl_frag = NULL;
	def_frag = NULL;
	if (((ValaDataType*) cl)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* __temp956;
		ValaCCodeFragment* __temp955;
		ValaCCodeFragment* __temp958;
		ValaCCodeFragment* __temp957;
		__temp956 = NULL;
		__temp955 = NULL;
		decl_frag = (__temp956 = (__temp955 = self->priv->header_type_declaration, (__temp955 == NULL ? NULL : g_object_ref (__temp955))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), __temp956);
		__temp958 = NULL;
		__temp957 = NULL;
		def_frag = (__temp958 = (__temp957 = self->priv->header_type_definition, (__temp957 == NULL ? NULL : g_object_ref (__temp957))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), __temp958);
	} else {
		ValaCCodeFragment* __temp960;
		ValaCCodeFragment* __temp959;
		ValaCCodeFragment* __temp962;
		ValaCCodeFragment* __temp961;
		__temp960 = NULL;
		__temp959 = NULL;
		decl_frag = (__temp960 = (__temp959 = self->priv->source_type_member_declaration, (__temp959 == NULL ? NULL : g_object_ref (__temp959))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), __temp960);
		__temp962 = NULL;
		__temp961 = NULL;
		def_frag = (__temp962 = (__temp961 = self->priv->source_type_member_declaration, (__temp961 == NULL ? NULL : g_object_ref (__temp961))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), __temp962);
	}
	__temp963 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp963 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp963 == NULL ? NULL : (__temp963 = (g_object_unref (__temp963), NULL)));
	__temp964 = NULL;
	__temp965 = NULL;
	macro = (__temp965 = g_strdup_printf ("(%s_get_type ())", (__temp964 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))), (__temp964 = (g_free (__temp964), NULL)), __temp965);
	__temp967 = NULL;
	__temp966 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp967 = vala_ccode_macro_replacement_new ((__temp966 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), macro))));
	(__temp967 == NULL ? NULL : (__temp967 = (g_object_unref (__temp967), NULL)));
	(__temp966 = (g_free (__temp966), NULL));
	__temp970 = NULL;
	__temp969 = NULL;
	__temp968 = NULL;
	macro = (__temp970 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp968 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp969 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp970);
	(__temp969 = (g_free (__temp969), NULL));
	(__temp968 = (g_free (__temp968), NULL));
	__temp973 = NULL;
	__temp972 = NULL;
	__temp971 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp973 = vala_ccode_macro_replacement_new ((__temp972 = g_strdup_printf ("%s(obj)", (__temp971 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
	(__temp973 == NULL ? NULL : (__temp973 = (g_object_unref (__temp973), NULL)));
	(__temp972 = (g_free (__temp972), NULL));
	(__temp971 = (g_free (__temp971), NULL));
	__temp976 = NULL;
	__temp975 = NULL;
	__temp974 = NULL;
	macro = (__temp976 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (__temp974 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp975 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp976);
	(__temp975 = (g_free (__temp975), NULL));
	(__temp974 = (g_free (__temp974), NULL));
	__temp979 = NULL;
	__temp978 = NULL;
	__temp977 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp979 = vala_ccode_macro_replacement_new ((__temp978 = g_strdup_printf ("%s_CLASS(klass)", (__temp977 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
	(__temp979 == NULL ? NULL : (__temp979 = (g_object_unref (__temp979), NULL)));
	(__temp978 = (g_free (__temp978), NULL));
	(__temp977 = (g_free (__temp977), NULL));
	__temp981 = NULL;
	__temp980 = NULL;
	macro = (__temp981 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp980 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp981);
	(__temp980 = (g_free (__temp980), NULL));
	__temp984 = NULL;
	__temp983 = NULL;
	__temp982 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp984 = vala_ccode_macro_replacement_new ((__temp983 = g_strdup_printf ("%s(obj)", (__temp982 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_")))), macro))));
	(__temp984 == NULL ? NULL : (__temp984 = (g_object_unref (__temp984), NULL)));
	(__temp983 = (g_free (__temp983), NULL));
	(__temp982 = (g_free (__temp982), NULL));
	__temp986 = NULL;
	__temp985 = NULL;
	macro = (__temp986 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (__temp985 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp986);
	(__temp985 = (g_free (__temp985), NULL));
	__temp989 = NULL;
	__temp988 = NULL;
	__temp987 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp989 = vala_ccode_macro_replacement_new ((__temp988 = g_strdup_printf ("%s_CLASS(klass)", (__temp987 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_")))), macro))));
	(__temp989 == NULL ? NULL : (__temp989 = (g_object_unref (__temp989), NULL)));
	(__temp988 = (g_free (__temp988), NULL));
	(__temp987 = (g_free (__temp987), NULL));
	__temp992 = NULL;
	__temp991 = NULL;
	__temp990 = NULL;
	macro = (__temp992 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (__temp990 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp991 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp992);
	(__temp991 = (g_free (__temp991), NULL));
	(__temp990 = (g_free (__temp990), NULL));
	__temp995 = NULL;
	__temp994 = NULL;
	__temp993 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp995 = vala_ccode_macro_replacement_new ((__temp994 = g_strdup_printf ("%s_GET_CLASS(obj)", (__temp993 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
	(__temp995 == NULL ? NULL : (__temp995 = (g_object_unref (__temp995), NULL)));
	(__temp994 = (g_free (__temp994), NULL));
	(__temp993 = (g_free (__temp993), NULL));
	__temp996 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp996 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp996 == NULL ? NULL : (__temp996 = (g_object_unref (__temp996), NULL)));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) cl)))) == NULL) {
		ValaCCodeTypeDefinition* __temp1000;
		ValaCCodeVariableDeclarator* __temp999;
		char* __temp998;
		char* __temp997;
		ValaCCodeTypeDefinition* __temp1005;
		ValaCCodeVariableDeclarator* __temp1004;
		char* __temp1003;
		char* __temp1002;
		char* __temp1001;
		__temp1000 = NULL;
		__temp999 = NULL;
		__temp998 = NULL;
		__temp997 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp1000 = vala_ccode_type_definition_new ((__temp997 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_struct))), VALA_CCODE_DECLARATOR ((__temp999 = vala_ccode_variable_declarator_new ((__temp998 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
		(__temp1000 == NULL ? NULL : (__temp1000 = (g_object_unref (__temp1000), NULL)));
		(__temp999 == NULL ? NULL : (__temp999 = (g_object_unref (__temp999), NULL)));
		(__temp998 = (g_free (__temp998), NULL));
		(__temp997 = (g_free (__temp997), NULL));
		__temp1005 = NULL;
		__temp1004 = NULL;
		__temp1003 = NULL;
		__temp1002 = NULL;
		__temp1001 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp1005 = vala_ccode_type_definition_new ((__temp1001 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct))), VALA_CCODE_DECLARATOR ((__temp1004 = vala_ccode_variable_declarator_new ((__temp1003 = g_strdup_printf ("%sClass", (__temp1002 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))))));
		(__temp1005 == NULL ? NULL : (__temp1005 = (g_object_unref (__temp1005), NULL)));
		(__temp1004 == NULL ? NULL : (__temp1004 = (g_object_unref (__temp1004), NULL)));
		(__temp1003 = (g_free (__temp1003), NULL));
		(__temp1002 = (g_free (__temp1002), NULL));
		(__temp1001 = (g_free (__temp1001), NULL));
	}
	__temp1010 = NULL;
	__temp1009 = NULL;
	__temp1008 = NULL;
	__temp1007 = NULL;
	__temp1006 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp1010 = vala_ccode_type_definition_new ((__temp1006 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_priv_struct))), VALA_CCODE_DECLARATOR ((__temp1009 = vala_ccode_variable_declarator_new ((__temp1008 = g_strdup_printf ("%sPrivate", (__temp1007 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))))));
	(__temp1010 == NULL ? NULL : (__temp1010 = (g_object_unref (__temp1010), NULL)));
	(__temp1009 == NULL ? NULL : (__temp1009 = (g_object_unref (__temp1009), NULL)));
	(__temp1008 = (g_free (__temp1008), NULL));
	(__temp1007 = (g_free (__temp1007), NULL));
	(__temp1006 = (g_free (__temp1006), NULL));
	__temp1011 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp1011 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)), "parent");
	(__temp1011 = (g_free (__temp1011), NULL));
	__temp1013 = NULL;
	__temp1012 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp1013 = g_strdup_printf ("%sPrivate *", (__temp1012 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), "priv");
	(__temp1013 = (g_free (__temp1013), NULL));
	(__temp1012 = (g_free (__temp1012), NULL));
	__temp1015 = NULL;
	__temp1014 = NULL;
	vala_ccode_struct_add_field (self->priv->type_struct, (__temp1015 = g_strdup_printf ("%sClass", (__temp1014 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)))), "parent");
	(__temp1015 = (g_free (__temp1015), NULL));
	(__temp1014 = (g_free (__temp1014), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) cl))) != NULL) {
		ValaCCodeComment* __temp1016;
		__temp1016 = NULL;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((__temp1016 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) cl)))))));
		(__temp1016 == NULL ? NULL : (__temp1016 = (g_object_unref (__temp1016), NULL)));
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->type_struct));
	/* only add the *Private struct if it is not empty, i.e. we actually have private data */
	if (vala_class_get_has_private_fields (cl)) {
		char* __temp1019;
		char* __temp1018;
		char* __temp1017;
		ValaCCodeMacroReplacement* __temp1022;
		char* __temp1021;
		char* __temp1020;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->instance_priv_struct));
		__temp1019 = NULL;
		__temp1018 = NULL;
		__temp1017 = NULL;
		macro = (__temp1019 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (__temp1017 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp1018 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp1019);
		(__temp1018 = (g_free (__temp1018), NULL));
		(__temp1017 = (g_free (__temp1017), NULL));
		__temp1022 = NULL;
		__temp1021 = NULL;
		__temp1020 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1022 = vala_ccode_macro_replacement_new ((__temp1021 = g_strdup_printf ("%s_GET_PRIVATE(o)", (__temp1020 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
		(__temp1022 == NULL ? NULL : (__temp1022 = (g_object_unref (__temp1022), NULL)));
		(__temp1021 = (g_free (__temp1021), NULL));
		(__temp1020 = (g_free (__temp1020), NULL));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->prop_enum));
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	if (!vala_class_get_is_static (cl)) {
		GeeCollection* __temp1023;
		gboolean __temp1024;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* __temp1027;
		if (vala_code_generator_class_has_readable_properties (self, cl)) {
			vala_code_generator_add_get_property_function (self, cl);
		}
		if (vala_code_generator_class_has_writable_properties (self, cl)) {
			vala_code_generator_add_set_property_function (self, cl);
		}
		vala_code_generator_add_class_init_function (self, cl);
		{
			GeeCollection* base_type_collection;
			GeeIterator* base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			base_type_it = gee_iterable_iterator (GEE_ITERABLE (base_type_collection));
			while (gee_iterator_next (base_type_it)) {
				ValaTypeReference* base_type;
				base_type = gee_iterator_get (base_type_it);
				{
					if (VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type))) {
						vala_code_generator_add_interface_init_function (self, cl, VALA_INTERFACE (vala_type_reference_get_data_type (base_type)));
					}
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
			(base_type_it == NULL ? NULL : (base_type_it = (g_object_unref (base_type_it), NULL)));
		}
		vala_code_generator_add_instance_init_function (self, cl);
		__temp1023 = NULL;
		if ((__temp1024 = (vala_code_generator_get_memory_management (self) && gee_collection_get_size ((__temp1023 = vala_class_get_fields (cl))) > 0) || vala_class_get_destructor (cl) != NULL, (__temp1023 == NULL ? NULL : (__temp1023 = (g_object_unref (__temp1023), NULL))), __temp1024)) {
			vala_code_generator_add_dispose_function (self, cl);
		}
		type_fun = vala_class_register_function_new (cl);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), self->priv->in_plugin);
		if (((ValaDataType*) cl)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* __temp1025;
			__temp1025 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1025 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
			(__temp1025 = (g_object_unref (__temp1025), NULL));
		} else {
			ValaCCodeFragment* __temp1026;
			__temp1026 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1026 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
			(__temp1026 = (g_object_unref (__temp1026), NULL));
		}
		__temp1027 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp1027 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp1027 = (g_object_unref (__temp1027), NULL));
		if (self->priv->in_plugin) {
			ValaCCodeIdentifier* __temp1030;
			char* __temp1029;
			char* __temp1028;
			ValaCCodeFunctionCall* __temp1031;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* __temp1032;
			ValaCCodeExpressionStatement* __temp1033;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			__temp1030 = NULL;
			__temp1029 = NULL;
			__temp1028 = NULL;
			__temp1031 = NULL;
			register_call = (__temp1031 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1030 = vala_ccode_identifier_new ((__temp1029 = g_strdup_printf ("%s_register_type", (__temp1028 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))))))), (__temp1030 == NULL ? NULL : (__temp1030 = (g_object_unref (__temp1030), NULL))), (__temp1029 = (g_free (__temp1029), NULL)), (__temp1028 = (g_free (__temp1028), NULL)), __temp1031);
			__temp1032 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((__temp1032 = vala_ccode_identifier_new (self->priv->module_init_param_name))));
			(__temp1032 == NULL ? NULL : (__temp1032 = (g_object_unref (__temp1032), NULL)));
			__temp1033 = NULL;
			vala_ccode_fragment_append (self->priv->module_init_fragment, VALA_CCODE_NODE ((__temp1033 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(__temp1033 == NULL ? NULL : (__temp1033 = (g_object_unref (__temp1033), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	__temp1035 = NULL;
	__temp1034 = NULL;
	self->priv->current_type_symbol = (__temp1035 = (__temp1034 = old_type_symbol, (__temp1034 == NULL ? NULL : g_object_ref (__temp1034))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1035);
	__temp1037 = NULL;
	__temp1036 = NULL;
	self->priv->current_class = (__temp1037 = (__temp1036 = old_class, (__temp1036 == NULL ? NULL : g_object_ref (__temp1036))), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp1037);
	__temp1039 = NULL;
	__temp1038 = NULL;
	self->priv->instance_struct = (__temp1039 = (__temp1038 = old_instance_struct, (__temp1038 == NULL ? NULL : g_object_ref (__temp1038))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp1039);
	__temp1041 = NULL;
	__temp1040 = NULL;
	self->priv->type_struct = (__temp1041 = (__temp1040 = old_type_struct, (__temp1040 == NULL ? NULL : g_object_ref (__temp1040))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp1041);
	__temp1043 = NULL;
	__temp1042 = NULL;
	self->priv->instance_priv_struct = (__temp1043 = (__temp1042 = old_instance_priv_struct, (__temp1042 == NULL ? NULL : g_object_ref (__temp1042))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), __temp1043);
	__temp1045 = NULL;
	__temp1044 = NULL;
	self->priv->prop_enum = (__temp1045 = (__temp1044 = old_prop_enum, (__temp1044 == NULL ? NULL : g_object_ref (__temp1044))), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), __temp1045);
	__temp1047 = NULL;
	__temp1046 = NULL;
	self->priv->instance_init_fragment = (__temp1047 = (__temp1046 = old_instance_init_fragment, (__temp1046 == NULL ? NULL : g_object_ref (__temp1046))), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), __temp1047);
	__temp1049 = NULL;
	__temp1048 = NULL;
	self->priv->instance_dispose_fragment = (__temp1049 = (__temp1048 = old_instance_dispose_fragment, (__temp1048 == NULL ? NULL : g_object_ref (__temp1048))), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp1049);
	(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
	(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
	(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
	(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
	(macro = (g_free (macro), NULL));
}


static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp1051;
	char* __temp1050;
	ValaCCodeFunction* __temp1052;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* __temp1055;
	char* __temp1054;
	char* __temp1053;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* __temp1057;
	char* __temp1056;
	ValaCCodeVariableDeclarator* __temp1058;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* __temp1059;
	ValaCCodeFunctionCall* __temp1061;
	ValaCCodeIdentifier* __temp1060;
	ValaCCodeIdentifier* __temp1062;
	ValaCCodeIdentifier* __temp1065;
	char* __temp1064;
	char* __temp1063;
	ValaCCodeAssignment* __temp1066;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* __temp1067;
	ValaCCodeFunctionCall* __temp1076;
	ValaCCodeIdentifier* __temp1075;
	ValaCCodeIdentifier* __temp1077;
	GeeCollection* __temp1099;
	gboolean __temp1100;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp1051 = NULL;
	__temp1050 = NULL;
	__temp1052 = NULL;
	class_init = (__temp1052 = vala_ccode_function_new ((__temp1051 = g_strdup_printf ("%s_class_init", (__temp1050 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (__temp1051 = (g_free (__temp1051), NULL)), (__temp1050 = (g_free (__temp1050), NULL)), __temp1052);
	__temp1055 = NULL;
	__temp1054 = NULL;
	__temp1053 = NULL;
	vala_ccode_function_add_parameter (class_init, (__temp1055 = vala_ccode_formal_parameter_new ("klass", (__temp1054 = g_strdup_printf ("%sClass *", (__temp1053 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
	(__temp1055 == NULL ? NULL : (__temp1055 = (g_object_unref (__temp1055), NULL)));
	(__temp1054 = (g_free (__temp1054), NULL));
	(__temp1053 = (g_free (__temp1053), NULL));
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	__temp1057 = NULL;
	__temp1056 = NULL;
	__temp1058 = NULL;
	parent_var_decl = (__temp1058 = vala_ccode_variable_declarator_new ((__temp1057 = g_strdup_printf ("%s_parent_class", (__temp1056 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))), (__temp1057 = (g_free (__temp1057), NULL)), (__temp1056 = (g_free (__temp1056), NULL)), __temp1058);
	__temp1059 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp1059 = vala_ccode_constant_new ("NULL"))));
	(__temp1059 == NULL ? NULL : (__temp1059 = (g_object_unref (__temp1059), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	__temp1061 = NULL;
	__temp1060 = NULL;
	ccall = (__temp1061 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1060 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1061);
	(__temp1060 == NULL ? NULL : (__temp1060 = (g_object_unref (__temp1060), NULL)));
	__temp1062 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1062 = vala_ccode_identifier_new ("klass"))));
	(__temp1062 == NULL ? NULL : (__temp1062 = (g_object_unref (__temp1062), NULL)));
	__temp1065 = NULL;
	__temp1064 = NULL;
	__temp1063 = NULL;
	__temp1066 = NULL;
	parent_assignment = (__temp1066 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1065 = vala_ccode_identifier_new ((__temp1064 = g_strdup_printf ("%s_parent_class", (__temp1063 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp1065 == NULL ? NULL : (__temp1065 = (g_object_unref (__temp1065), NULL))), (__temp1064 = (g_free (__temp1064), NULL)), (__temp1063 = (g_free (__temp1063), NULL)), __temp1066);
	__temp1067 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1067 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp1067 == NULL ? NULL : (__temp1067 = (g_object_unref (__temp1067), NULL)));
	/* add struct for private fields */
	if (vala_class_get_has_private_fields (cl)) {
		ValaCCodeFunctionCall* __temp1069;
		ValaCCodeIdentifier* __temp1068;
		ValaCCodeIdentifier* __temp1070;
		ValaCCodeConstant* __temp1073;
		char* __temp1072;
		char* __temp1071;
		ValaCCodeExpressionStatement* __temp1074;
		__temp1069 = NULL;
		__temp1068 = NULL;
		ccall = (__temp1069 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1068 = vala_ccode_identifier_new ("g_type_class_add_private")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1069);
		(__temp1068 == NULL ? NULL : (__temp1068 = (g_object_unref (__temp1068), NULL)));
		__temp1070 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1070 = vala_ccode_identifier_new ("klass"))));
		(__temp1070 == NULL ? NULL : (__temp1070 = (g_object_unref (__temp1070), NULL)));
		__temp1073 = NULL;
		__temp1072 = NULL;
		__temp1071 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1073 = vala_ccode_constant_new ((__temp1072 = g_strdup_printf ("sizeof (%sPrivate)", (__temp1071 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))))));
		(__temp1073 == NULL ? NULL : (__temp1073 = (g_object_unref (__temp1073), NULL)));
		(__temp1072 = (g_free (__temp1072), NULL));
		(__temp1071 = (g_free (__temp1071), NULL));
		__temp1074 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1074 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(__temp1074 == NULL ? NULL : (__temp1074 = (g_object_unref (__temp1074), NULL)));
	}
	/* set property handlers */
	__temp1076 = NULL;
	__temp1075 = NULL;
	ccall = (__temp1076 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1075 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1076);
	(__temp1075 == NULL ? NULL : (__temp1075 = (g_object_unref (__temp1075), NULL)));
	__temp1077 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1077 = vala_ccode_identifier_new ("klass"))));
	(__temp1077 == NULL ? NULL : (__temp1077 = (g_object_unref (__temp1077), NULL)));
	if (vala_code_generator_class_has_readable_properties (self, cl)) {
		ValaCCodeExpressionStatement* __temp1083;
		ValaCCodeAssignment* __temp1082;
		ValaCCodeIdentifier* __temp1081;
		char* __temp1080;
		char* __temp1079;
		ValaCCodeMemberAccess* __temp1078;
		__temp1083 = NULL;
		__temp1082 = NULL;
		__temp1081 = NULL;
		__temp1080 = NULL;
		__temp1079 = NULL;
		__temp1078 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1083 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1082 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1078 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property"))), VALA_CCODE_EXPRESSION ((__temp1081 = vala_ccode_identifier_new ((__temp1080 = g_strdup_printf ("%s_get_property", (__temp1079 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp1083 == NULL ? NULL : (__temp1083 = (g_object_unref (__temp1083), NULL)));
		(__temp1082 == NULL ? NULL : (__temp1082 = (g_object_unref (__temp1082), NULL)));
		(__temp1081 == NULL ? NULL : (__temp1081 = (g_object_unref (__temp1081), NULL)));
		(__temp1080 = (g_free (__temp1080), NULL));
		(__temp1079 = (g_free (__temp1079), NULL));
		(__temp1078 == NULL ? NULL : (__temp1078 = (g_object_unref (__temp1078), NULL)));
	}
	if (vala_code_generator_class_has_writable_properties (self, cl)) {
		ValaCCodeExpressionStatement* __temp1089;
		ValaCCodeAssignment* __temp1088;
		ValaCCodeIdentifier* __temp1087;
		char* __temp1086;
		char* __temp1085;
		ValaCCodeMemberAccess* __temp1084;
		__temp1089 = NULL;
		__temp1088 = NULL;
		__temp1087 = NULL;
		__temp1086 = NULL;
		__temp1085 = NULL;
		__temp1084 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1089 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1088 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1084 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property"))), VALA_CCODE_EXPRESSION ((__temp1087 = vala_ccode_identifier_new ((__temp1086 = g_strdup_printf ("%s_set_property", (__temp1085 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp1089 == NULL ? NULL : (__temp1089 = (g_object_unref (__temp1089), NULL)));
		(__temp1088 == NULL ? NULL : (__temp1088 = (g_object_unref (__temp1088), NULL)));
		(__temp1087 == NULL ? NULL : (__temp1087 = (g_object_unref (__temp1087), NULL)));
		(__temp1086 = (g_free (__temp1086), NULL));
		(__temp1085 = (g_free (__temp1085), NULL));
		(__temp1084 == NULL ? NULL : (__temp1084 = (g_object_unref (__temp1084), NULL)));
	}
	/* set constructor */
	if (vala_class_get_constructor (cl) != NULL) {
		ValaCCodeIdentifier* __temp1090;
		ValaCCodeFunctionCall* __temp1091;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* __temp1092;
		ValaCCodeExpressionStatement* __temp1098;
		ValaCCodeAssignment* __temp1097;
		ValaCCodeIdentifier* __temp1096;
		char* __temp1095;
		char* __temp1094;
		ValaCCodeMemberAccess* __temp1093;
		__temp1090 = NULL;
		__temp1091 = NULL;
		ccast = (__temp1091 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1090 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (__temp1090 == NULL ? NULL : (__temp1090 = (g_object_unref (__temp1090), NULL))), __temp1091);
		__temp1092 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp1092 = vala_ccode_identifier_new ("klass"))));
		(__temp1092 == NULL ? NULL : (__temp1092 = (g_object_unref (__temp1092), NULL)));
		__temp1098 = NULL;
		__temp1097 = NULL;
		__temp1096 = NULL;
		__temp1095 = NULL;
		__temp1094 = NULL;
		__temp1093 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1098 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1097 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1093 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor"))), VALA_CCODE_EXPRESSION ((__temp1096 = vala_ccode_identifier_new ((__temp1095 = g_strdup_printf ("%s_constructor", (__temp1094 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp1098 == NULL ? NULL : (__temp1098 = (g_object_unref (__temp1098), NULL)));
		(__temp1097 == NULL ? NULL : (__temp1097 = (g_object_unref (__temp1097), NULL)));
		(__temp1096 == NULL ? NULL : (__temp1096 = (g_object_unref (__temp1096), NULL)));
		(__temp1095 = (g_free (__temp1095), NULL));
		(__temp1094 = (g_free (__temp1094), NULL));
		(__temp1093 == NULL ? NULL : (__temp1093 = (g_object_unref (__temp1093), NULL)));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* set dispose function */
	__temp1099 = NULL;
	if ((__temp1100 = vala_code_generator_get_memory_management (self) && gee_collection_get_size ((__temp1099 = vala_class_get_fields (cl))) > 0, (__temp1099 == NULL ? NULL : (__temp1099 = (g_object_unref (__temp1099), NULL))), __temp1100)) {
		ValaCCodeIdentifier* __temp1101;
		ValaCCodeFunctionCall* __temp1102;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* __temp1103;
		ValaCCodeExpressionStatement* __temp1109;
		ValaCCodeAssignment* __temp1108;
		ValaCCodeIdentifier* __temp1107;
		char* __temp1106;
		char* __temp1105;
		ValaCCodeMemberAccess* __temp1104;
		__temp1101 = NULL;
		__temp1102 = NULL;
		ccast = (__temp1102 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1101 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (__temp1101 == NULL ? NULL : (__temp1101 = (g_object_unref (__temp1101), NULL))), __temp1102);
		__temp1103 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp1103 = vala_ccode_identifier_new ("klass"))));
		(__temp1103 == NULL ? NULL : (__temp1103 = (g_object_unref (__temp1103), NULL)));
		__temp1109 = NULL;
		__temp1108 = NULL;
		__temp1107 = NULL;
		__temp1106 = NULL;
		__temp1105 = NULL;
		__temp1104 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1109 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1108 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1104 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose"))), VALA_CCODE_EXPRESSION ((__temp1107 = vala_ccode_identifier_new ((__temp1106 = g_strdup_printf ("%s_dispose", (__temp1105 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp1109 == NULL ? NULL : (__temp1109 = (g_object_unref (__temp1109), NULL)));
		(__temp1108 == NULL ? NULL : (__temp1108 = (g_object_unref (__temp1108), NULL)));
		(__temp1107 == NULL ? NULL : (__temp1107 = (g_object_unref (__temp1107), NULL)));
		(__temp1106 = (g_free (__temp1106), NULL));
		(__temp1105 = (g_free (__temp1105), NULL));
		(__temp1104 == NULL ? NULL : (__temp1104 = (g_object_unref (__temp1104), NULL)));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	{
		GeeCollection* m_collection;
		GeeIterator* m_it;
		m_collection = vala_class_get_methods (cl);
		m_it = gee_iterable_iterator (GEE_ITERABLE (m_collection));
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			m = gee_iterator_get (m_it);
			{
				ValaSymbol* __temp1110;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* __temp1113;
				char* __temp1112;
				char* __temp1111;
				ValaCCodeFunctionCall* __temp1114;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* __temp1115;
				ValaCCodeExpressionStatement* __temp1120;
				ValaCCodeAssignment* __temp1119;
				ValaCCodeIdentifier* __temp1118;
				char* __temp1117;
				ValaCCodeMemberAccess* __temp1116;
				/* connect overridden methods */
				if (vala_method_get_base_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				__temp1110 = NULL;
				base_type = (__temp1110 = vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_method (m))), (__temp1110 == NULL ? NULL : g_object_ref (__temp1110)));
				__temp1113 = NULL;
				__temp1112 = NULL;
				__temp1111 = NULL;
				__temp1114 = NULL;
				ccast = (__temp1114 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1113 = vala_ccode_identifier_new ((__temp1112 = g_strdup_printf ("%s_CLASS", (__temp1111 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE ((VALA_CLASS (base_type))), NULL)))))))), (__temp1113 == NULL ? NULL : (__temp1113 = (g_object_unref (__temp1113), NULL))), (__temp1112 = (g_free (__temp1112), NULL)), (__temp1111 = (g_free (__temp1111), NULL)), __temp1114);
				__temp1115 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp1115 = vala_ccode_identifier_new ("klass"))));
				(__temp1115 == NULL ? NULL : (__temp1115 = (g_object_unref (__temp1115), NULL)));
				__temp1120 = NULL;
				__temp1119 = NULL;
				__temp1118 = NULL;
				__temp1117 = NULL;
				__temp1116 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1120 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1119 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1116 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_symbol_get_name (((ValaSymbol*) m))))), VALA_CCODE_EXPRESSION ((__temp1118 = vala_ccode_identifier_new ((__temp1117 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(__temp1120 == NULL ? NULL : (__temp1120 = (g_object_unref (__temp1120), NULL)));
				(__temp1119 == NULL ? NULL : (__temp1119 = (g_object_unref (__temp1119), NULL)));
				(__temp1118 == NULL ? NULL : (__temp1118 = (g_object_unref (__temp1118), NULL)));
				(__temp1117 = (g_free (__temp1117), NULL));
				(__temp1116 == NULL ? NULL : (__temp1116 = (g_object_unref (__temp1116), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
		(m_it == NULL ? NULL : (m_it = (g_object_unref (m_it), NULL)));
	}
	{
		GeeCollection* type_param_collection;
		GeeIterator* type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
		while (gee_iterator_next (type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = gee_iterator_get (type_param_it);
			{
				char* func_name;
				char* enum_value;
				ValaCCodeConstant* func_name_constant;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeFunctionCall* cspec;
				char* __temp1122;
				char* __temp1121;
				ValaCCodeConstant* __temp1125;
				char* __temp1124;
				char* __temp1123;
				char* __temp1128;
				char* __temp1127;
				char* __temp1126;
				ValaCCodeFunctionCall* __temp1130;
				ValaCCodeIdentifier* __temp1129;
				ValaCCodeConstant* __temp1131;
				ValaCCodeFunctionCall* __temp1133;
				ValaCCodeIdentifier* __temp1132;
				ValaCCodeConstant* __temp1134;
				ValaCCodeConstant* __temp1135;
				ValaCCodeConstant* __temp1136;
				ValaCCodeExpressionStatement* __temp1137;
				char* __temp1139;
				char* __temp1138;
				ValaCCodeConstant* __temp1142;
				char* __temp1141;
				char* __temp1140;
				char* __temp1145;
				char* __temp1144;
				char* __temp1143;
				ValaCCodeFunctionCall* __temp1147;
				ValaCCodeIdentifier* __temp1146;
				ValaCCodeConstant* __temp1148;
				ValaCCodeFunctionCall* __temp1150;
				ValaCCodeIdentifier* __temp1149;
				ValaCCodeConstant* __temp1151;
				ValaCCodeConstant* __temp1152;
				ValaCCodeConstant* __temp1153;
				ValaCCodeExpressionStatement* __temp1154;
				/* create dup_func and destroy_func properties for generic types */
				func_name = NULL;
				enum_value = NULL;
				func_name_constant = NULL;
				cinst = NULL;
				cspec = NULL;
				__temp1122 = NULL;
				__temp1121 = NULL;
				func_name = (__temp1122 = g_strdup_printf ("%s_dup_func", (__temp1121 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), __temp1122);
				(__temp1121 = (g_free (__temp1121), NULL));
				__temp1125 = NULL;
				__temp1124 = NULL;
				__temp1123 = NULL;
				func_name_constant = (__temp1125 = vala_ccode_constant_new ((__temp1124 = g_strdup_printf ("\"%s-dup-func\"", (__temp1123 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), __temp1125);
				(__temp1124 = (g_free (__temp1124), NULL));
				(__temp1123 = (g_free (__temp1123), NULL));
				__temp1128 = NULL;
				__temp1127 = NULL;
				__temp1126 = NULL;
				enum_value = (__temp1128 = g_utf8_strup ((__temp1127 = g_strdup_printf ("%s_%s", (__temp1126 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), __temp1128);
				(__temp1127 = (g_free (__temp1127), NULL));
				(__temp1126 = (g_free (__temp1126), NULL));
				__temp1130 = NULL;
				__temp1129 = NULL;
				cinst = (__temp1130 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1129 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), __temp1130);
				(__temp1129 == NULL ? NULL : (__temp1129 = (g_object_unref (__temp1129), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				__temp1131 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1131 = vala_ccode_constant_new (enum_value))));
				(__temp1131 == NULL ? NULL : (__temp1131 = (g_object_unref (__temp1131), NULL)));
				__temp1133 = NULL;
				__temp1132 = NULL;
				cspec = (__temp1133 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1132 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), __temp1133);
				(__temp1132 == NULL ? NULL : (__temp1132 = (g_object_unref (__temp1132), NULL)));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				__temp1134 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1134 = vala_ccode_constant_new ("\"dup func\""))));
				(__temp1134 == NULL ? NULL : (__temp1134 = (g_object_unref (__temp1134), NULL)));
				__temp1135 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1135 = vala_ccode_constant_new ("\"dup func\""))));
				(__temp1135 == NULL ? NULL : (__temp1135 = (g_object_unref (__temp1135), NULL)));
				__temp1136 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1136 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
				(__temp1136 == NULL ? NULL : (__temp1136 = (g_object_unref (__temp1136), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				__temp1137 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1137 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp1137 == NULL ? NULL : (__temp1137 = (g_object_unref (__temp1137), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GBoxedCopyFunc", func_name);
				__temp1139 = NULL;
				__temp1138 = NULL;
				func_name = (__temp1139 = g_strdup_printf ("%s_destroy_func", (__temp1138 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), __temp1139);
				(__temp1138 = (g_free (__temp1138), NULL));
				__temp1142 = NULL;
				__temp1141 = NULL;
				__temp1140 = NULL;
				func_name_constant = (__temp1142 = vala_ccode_constant_new ((__temp1141 = g_strdup_printf ("\"%s-destroy-func\"", (__temp1140 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), __temp1142);
				(__temp1141 = (g_free (__temp1141), NULL));
				(__temp1140 = (g_free (__temp1140), NULL));
				__temp1145 = NULL;
				__temp1144 = NULL;
				__temp1143 = NULL;
				enum_value = (__temp1145 = g_utf8_strup ((__temp1144 = g_strdup_printf ("%s_%s", (__temp1143 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), __temp1145);
				(__temp1144 = (g_free (__temp1144), NULL));
				(__temp1143 = (g_free (__temp1143), NULL));
				__temp1147 = NULL;
				__temp1146 = NULL;
				cinst = (__temp1147 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1146 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), __temp1147);
				(__temp1146 == NULL ? NULL : (__temp1146 = (g_object_unref (__temp1146), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				__temp1148 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1148 = vala_ccode_constant_new (enum_value))));
				(__temp1148 == NULL ? NULL : (__temp1148 = (g_object_unref (__temp1148), NULL)));
				__temp1150 = NULL;
				__temp1149 = NULL;
				cspec = (__temp1150 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1149 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), __temp1150);
				(__temp1149 == NULL ? NULL : (__temp1149 = (g_object_unref (__temp1149), NULL)));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				__temp1151 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1151 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp1151 == NULL ? NULL : (__temp1151 = (g_object_unref (__temp1151), NULL)));
				__temp1152 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1152 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp1152 == NULL ? NULL : (__temp1152 = (g_object_unref (__temp1152), NULL)));
				__temp1153 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1153 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
				(__temp1153 == NULL ? NULL : (__temp1153 = (g_object_unref (__temp1153), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				__temp1154 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1154 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp1154 == NULL ? NULL : (__temp1154 = (g_object_unref (__temp1154), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GDestroyNotify", func_name);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
	}
	/* create properties */
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
					ValaCCodeIdentifier* __temp1155;
					ValaCCodeFunctionCall* __temp1156;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* __temp1158;
					char* __temp1157;
					ValaCCodeConstant* __temp1159;
					ValaCCodeExpressionStatement* __temp1160;
					__temp1155 = NULL;
					__temp1156 = NULL;
					cinst = (__temp1156 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1155 = vala_ccode_identifier_new ("g_object_class_override_property")))), (__temp1155 == NULL ? NULL : (__temp1155 = (g_object_unref (__temp1155), NULL))), __temp1156);
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					__temp1158 = NULL;
					__temp1157 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1158 = vala_ccode_constant_new ((__temp1157 = vala_property_get_upper_case_cname (prop))))));
					(__temp1158 == NULL ? NULL : (__temp1158 = (g_object_unref (__temp1158), NULL)));
					(__temp1157 = (g_free (__temp1157), NULL));
					__temp1159 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1159 = vala_property_get_canonical_cconstant (prop))));
					(__temp1159 = (g_object_unref (__temp1159), NULL));
					__temp1160 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1160 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp1160 == NULL ? NULL : (__temp1160 = (g_object_unref (__temp1160), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				} else {
					ValaCCodeIdentifier* __temp1161;
					ValaCCodeFunctionCall* __temp1162;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* __temp1164;
					char* __temp1163;
					ValaCCodeFunctionCall* __temp1165;
					ValaCCodeExpressionStatement* __temp1166;
					__temp1161 = NULL;
					__temp1162 = NULL;
					cinst = (__temp1162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1161 = vala_ccode_identifier_new ("g_object_class_install_property")))), (__temp1161 == NULL ? NULL : (__temp1161 = (g_object_unref (__temp1161), NULL))), __temp1162);
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					__temp1164 = NULL;
					__temp1163 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1164 = vala_ccode_constant_new ((__temp1163 = vala_property_get_upper_case_cname (prop))))));
					(__temp1164 == NULL ? NULL : (__temp1164 = (g_object_unref (__temp1164), NULL)));
					(__temp1163 = (g_free (__temp1163), NULL));
					__temp1165 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1165 = vala_code_generator_get_param_spec (self, prop))));
					(__temp1165 = (g_object_unref (__temp1165), NULL));
					__temp1166 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1166 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp1166 == NULL ? NULL : (__temp1166 = (g_object_unref (__temp1166), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	{
		GeeCollection* sig_collection;
		GeeIterator* sig_it;
		sig_collection = vala_class_get_signals (cl);
		sig_it = gee_iterable_iterator (GEE_ITERABLE (sig_collection));
		while (gee_iterator_next (sig_it)) {
			ValaSignal* sig;
			sig = gee_iterator_get (sig_it);
			{
				ValaCCodeExpressionStatement* __temp1168;
				ValaCCodeFunctionCall* __temp1167;
				/* create signals */
				__temp1168 = NULL;
				__temp1167 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1168 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1167 = vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (cl))))))));
				(__temp1168 == NULL ? NULL : (__temp1168 = (g_object_unref (__temp1168), NULL)));
				(__temp1167 = (g_object_unref (__temp1167), NULL));
				(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
		(sig_it == NULL ? NULL : (sig_it = (g_object_unref (sig_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface)
{
	char* __temp1171;
	char* __temp1170;
	char* __temp1169;
	ValaCCodeFunction* __temp1172;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* __temp1175;
	char* __temp1174;
	char* __temp1173;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* __temp1177;
	char* __temp1176;
	char* __temp1178;
	char* parent_iface_var;
	char* __temp1180;
	char* __temp1179;
	ValaCCodeDeclaration* __temp1181;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* __temp1182;
	ValaCCodeFunctionCall* __temp1184;
	ValaCCodeIdentifier* __temp1183;
	ValaCCodeIdentifier* __temp1185;
	ValaCCodeIdentifier* __temp1186;
	ValaCCodeAssignment* __temp1187;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* __temp1188;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp1171 = NULL;
	__temp1170 = NULL;
	__temp1169 = NULL;
	__temp1172 = NULL;
	iface_init = (__temp1172 = vala_ccode_function_new ((__temp1171 = g_strdup_printf ("%s_%s_interface_init", (__temp1169 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (__temp1170 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (__temp1171 = (g_free (__temp1171), NULL)), (__temp1170 = (g_free (__temp1170), NULL)), (__temp1169 = (g_free (__temp1169), NULL)), __temp1172);
	__temp1175 = NULL;
	__temp1174 = NULL;
	__temp1173 = NULL;
	vala_ccode_function_add_parameter (iface_init, (__temp1175 = vala_ccode_formal_parameter_new ("iface", (__temp1174 = g_strdup_printf ("%s *", (__temp1173 = vala_interface_get_type_cname (iface)))))));
	(__temp1175 == NULL ? NULL : (__temp1175 = (g_object_unref (__temp1175), NULL)));
	(__temp1174 = (g_free (__temp1174), NULL));
	(__temp1173 = (g_free (__temp1173), NULL));
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	__temp1177 = NULL;
	__temp1176 = NULL;
	__temp1178 = NULL;
	parent_iface_var = (__temp1178 = g_strdup_printf ("%s_%s_parent_iface", (__temp1176 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (__temp1177 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (__temp1177 = (g_free (__temp1177), NULL)), (__temp1176 = (g_free (__temp1176), NULL)), __temp1178);
	__temp1180 = NULL;
	__temp1179 = NULL;
	__temp1181 = NULL;
	parent_decl = (__temp1181 = vala_ccode_declaration_new ((__temp1180 = g_strconcat ((__temp1179 = vala_interface_get_type_cname (iface)), "*", NULL))), (__temp1180 = (g_free (__temp1180), NULL)), (__temp1179 = (g_free (__temp1179), NULL)), __temp1181);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	__temp1182 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp1182 = vala_ccode_constant_new ("NULL"))));
	(__temp1182 == NULL ? NULL : (__temp1182 = (g_object_unref (__temp1182), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	__temp1184 = NULL;
	__temp1183 = NULL;
	ccall = (__temp1184 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1183 = vala_ccode_identifier_new ("g_type_interface_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1184);
	(__temp1183 == NULL ? NULL : (__temp1183 = (g_object_unref (__temp1183), NULL)));
	__temp1185 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1185 = vala_ccode_identifier_new ("iface"))));
	(__temp1185 == NULL ? NULL : (__temp1185 = (g_object_unref (__temp1185), NULL)));
	__temp1186 = NULL;
	__temp1187 = NULL;
	parent_assignment = (__temp1187 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1186 = vala_ccode_identifier_new (parent_iface_var))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp1186 == NULL ? NULL : (__temp1186 = (g_object_unref (__temp1186), NULL))), __temp1187);
	__temp1188 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1188 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp1188 == NULL ? NULL : (__temp1188 = (g_object_unref (__temp1188), NULL)));
	{
		GeeCollection* m_collection;
		GeeIterator* m_it;
		m_collection = vala_class_get_methods (cl);
		m_it = gee_iterable_iterator (GEE_ITERABLE (m_collection));
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			m = gee_iterator_get (m_it);
			{
				ValaSymbol* __temp1189;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* ciface;
				ValaCCodeExpressionStatement* __temp1194;
				ValaCCodeAssignment* __temp1193;
				ValaCCodeIdentifier* __temp1192;
				char* __temp1191;
				ValaCCodeMemberAccess* __temp1190;
				if (vala_method_get_base_interface_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				__temp1189 = NULL;
				base_type = (__temp1189 = vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_interface_method (m))), (__temp1189 == NULL ? NULL : g_object_ref (__temp1189)));
				if (base_type != VALA_SYMBOL (iface)) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				__temp1194 = NULL;
				__temp1193 = NULL;
				__temp1192 = NULL;
				__temp1191 = NULL;
				__temp1190 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1194 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1193 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1190 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_symbol_get_name (((ValaSymbol*) m))))), VALA_CCODE_EXPRESSION ((__temp1192 = vala_ccode_identifier_new ((__temp1191 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(__temp1194 == NULL ? NULL : (__temp1194 = (g_object_unref (__temp1194), NULL)));
				(__temp1193 == NULL ? NULL : (__temp1193 = (g_object_unref (__temp1193), NULL)));
				(__temp1192 == NULL ? NULL : (__temp1192 = (g_object_unref (__temp1192), NULL)));
				(__temp1191 = (g_free (__temp1191), NULL));
				(__temp1190 == NULL ? NULL : (__temp1190 = (g_object_unref (__temp1190), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
		(m_it == NULL ? NULL : (m_it = (g_object_unref (m_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_iface_var = (g_free (parent_iface_var), NULL));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
}


static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp1196;
	char* __temp1195;
	ValaCCodeFunction* __temp1197;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* __temp1200;
	char* __temp1199;
	char* __temp1198;
	ValaCCodeBlock* init_block;
	ValaSymbol* init_sym;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp1196 = NULL;
	__temp1195 = NULL;
	__temp1197 = NULL;
	instance_init = (__temp1197 = vala_ccode_function_new ((__temp1196 = g_strdup_printf ("%s_init", (__temp1195 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (__temp1196 = (g_free (__temp1196), NULL)), (__temp1195 = (g_free (__temp1195), NULL)), __temp1197);
	__temp1200 = NULL;
	__temp1199 = NULL;
	__temp1198 = NULL;
	vala_ccode_function_add_parameter (instance_init, (__temp1200 = vala_ccode_formal_parameter_new ("self", (__temp1199 = g_strdup_printf ("%s *", (__temp1198 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
	(__temp1200 == NULL ? NULL : (__temp1200 = (g_object_unref (__temp1200), NULL)));
	(__temp1199 = (g_free (__temp1199), NULL));
	(__temp1198 = (g_free (__temp1198), NULL));
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	vala_ccode_function_set_block (instance_init, init_block);
	if (vala_class_get_has_private_fields (cl)) {
		ValaCCodeIdentifier* __temp1203;
		char* __temp1202;
		char* __temp1201;
		ValaCCodeFunctionCall* __temp1204;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp1205;
		ValaCCodeExpressionStatement* __temp1209;
		ValaCCodeAssignment* __temp1208;
		ValaCCodeMemberAccess* __temp1207;
		ValaCCodeIdentifier* __temp1206;
		__temp1203 = NULL;
		__temp1202 = NULL;
		__temp1201 = NULL;
		__temp1204 = NULL;
		ccall = (__temp1204 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1203 = vala_ccode_identifier_new ((__temp1202 = g_strdup_printf ("%s_GET_PRIVATE", (__temp1201 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (__temp1203 == NULL ? NULL : (__temp1203 = (g_object_unref (__temp1203), NULL))), (__temp1202 = (g_free (__temp1202), NULL)), (__temp1201 = (g_free (__temp1201), NULL)), __temp1204);
		__temp1205 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1205 = vala_ccode_identifier_new ("self"))));
		(__temp1205 == NULL ? NULL : (__temp1205 = (g_object_unref (__temp1205), NULL)));
		__temp1209 = NULL;
		__temp1208 = NULL;
		__temp1207 = NULL;
		__temp1206 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1209 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1208 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1207 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1206 = vala_ccode_identifier_new ("self"))), "priv"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp1209 == NULL ? NULL : (__temp1209 = (g_object_unref (__temp1209), NULL)));
		(__temp1208 == NULL ? NULL : (__temp1208 = (g_object_unref (__temp1208), NULL)));
		(__temp1207 == NULL ? NULL : (__temp1207 = (g_object_unref (__temp1207), NULL)));
		(__temp1206 == NULL ? NULL : (__temp1206 = (g_object_unref (__temp1206), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->instance_init_fragment));
	init_sym = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) cl)), "init");
	if (init_sym != NULL) {
		ValaMethod* __temp1210;
		ValaMethod* init_fun;
		__temp1210 = NULL;
		init_fun = (__temp1210 = VALA_METHOD (init_sym), (__temp1210 == NULL ? NULL : g_object_ref (__temp1210)));
		vala_ccode_block_add_statement (init_block, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_method_get_body (init_fun))));
		(init_fun == NULL ? NULL : (init_fun = (g_object_unref (init_fun), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(init_sym == NULL ? NULL : (init_sym = (g_object_unref (init_sym), NULL)));
}


static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl)
{
	ValaCCodeFunction* __temp1213;
	char* __temp1212;
	char* __temp1211;
	ValaCCodeFormalParameter* __temp1214;
	ValaCCodeFunction* __temp1215;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* __temp1217;
	char* __temp1216;
	ValaCCodeFunctionCall* __temp1218;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp1219;
	char* __temp1221;
	char* __temp1220;
	ValaCCodeDeclaration* __temp1222;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp1223;
	ValaCCodeDeclaration* __temp1226;
	char* __temp1225;
	char* __temp1224;
	ValaCCodeVariableDeclarator* __temp1227;
	ValaCCodeDeclaration* __temp1228;
	ValaCCodeVariableDeclarator* __temp1229;
	ValaCCodeFunctionCall* __temp1231;
	ValaCCodeIdentifier* __temp1230;
	ValaCCodeIdentifier* __temp1233;
	char* __temp1232;
	ValaCCodeIdentifier* __temp1236;
	char* __temp1235;
	char* __temp1234;
	ValaCCodeFunctionCall* __temp1237;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* __temp1240;
	ValaCCodeAssignment* __temp1239;
	ValaCCodeIdentifier* __temp1238;
	ValaCCodeFunctionCall* __temp1242;
	ValaCCodeIdentifier* __temp1241;
	ValaCCodeIdentifier* __temp1243;
	ValaCCodeFunctionCall* __temp1245;
	ValaCCodeIdentifier* __temp1244;
	ValaCCodeExpressionStatement* __temp1248;
	ValaCCodeAssignment* __temp1247;
	ValaCCodeIdentifier* __temp1246;
	ValaCCodeFunctionCall* __temp1251;
	ValaCCodeMemberAccess* __temp1250;
	ValaCCodeIdentifier* __temp1249;
	ValaCCodeIdentifier* __temp1252;
	ValaCCodeExpressionStatement* __temp1253;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp1213 = NULL;
	__temp1212 = NULL;
	__temp1211 = NULL;
	self->priv->function = (__temp1213 = vala_ccode_function_new ((__temp1212 = g_strdup_printf ("%s_dispose", (__temp1211 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp1213);
	(__temp1212 = (g_free (__temp1212), NULL));
	(__temp1211 = (g_free (__temp1211), NULL));
	vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC);
	__temp1214 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp1214 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(__temp1214 == NULL ? NULL : (__temp1214 = (g_object_unref (__temp1214), NULL)));
	__temp1215 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1215 = vala_ccode_function_copy (self->priv->function))));
	(__temp1215 = (g_object_unref (__temp1215), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1217 = NULL;
	__temp1216 = NULL;
	__temp1218 = NULL;
	ccall = (__temp1218 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1217 = vala_ccode_identifier_new ((__temp1216 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp1217 == NULL ? NULL : (__temp1217 = (g_object_unref (__temp1217), NULL))), (__temp1216 = (g_free (__temp1216), NULL)), __temp1218);
	__temp1219 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1219 = vala_ccode_identifier_new ("obj"))));
	(__temp1219 == NULL ? NULL : (__temp1219 = (g_object_unref (__temp1219), NULL)));
	__temp1221 = NULL;
	__temp1220 = NULL;
	__temp1222 = NULL;
	cdecl_ = (__temp1222 = vala_ccode_declaration_new ((__temp1221 = g_strdup_printf ("%s *", (__temp1220 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (__temp1221 = (g_free (__temp1221), NULL)), (__temp1220 = (g_free (__temp1220), NULL)), __temp1222);
	__temp1223 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1223 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp1223 == NULL ? NULL : (__temp1223 = (g_object_unref (__temp1223), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_destructor_get_body (vala_class_get_destructor (cl)))))));
	}
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
	__temp1226 = NULL;
	__temp1225 = NULL;
	__temp1224 = NULL;
	cdecl_ = (__temp1226 = vala_ccode_declaration_new ((__temp1225 = g_strdup_printf ("%sClass *", (__temp1224 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp1226);
	(__temp1225 = (g_free (__temp1225), NULL));
	(__temp1224 = (g_free (__temp1224), NULL));
	__temp1227 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1227 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp1227 == NULL ? NULL : (__temp1227 = (g_object_unref (__temp1227), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp1228 = NULL;
	cdecl_ = (__temp1228 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp1228);
	__temp1229 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1229 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp1229 == NULL ? NULL : (__temp1229 = (g_object_unref (__temp1229), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp1231 = NULL;
	__temp1230 = NULL;
	ccall = (__temp1231 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1230 = vala_ccode_identifier_new ("g_type_class_peek")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1231);
	(__temp1230 == NULL ? NULL : (__temp1230 = (g_object_unref (__temp1230), NULL)));
	__temp1233 = NULL;
	__temp1232 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1233 = vala_ccode_identifier_new ((__temp1232 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))))));
	(__temp1233 == NULL ? NULL : (__temp1233 = (g_object_unref (__temp1233), NULL)));
	(__temp1232 = (g_free (__temp1232), NULL));
	__temp1236 = NULL;
	__temp1235 = NULL;
	__temp1234 = NULL;
	__temp1237 = NULL;
	ccast = (__temp1237 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1236 = vala_ccode_identifier_new ((__temp1235 = g_strdup_printf ("%s_CLASS", (__temp1234 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (__temp1236 == NULL ? NULL : (__temp1236 = (g_object_unref (__temp1236), NULL))), (__temp1235 = (g_free (__temp1235), NULL)), (__temp1234 = (g_free (__temp1234), NULL)), __temp1237);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp1240 = NULL;
	__temp1239 = NULL;
	__temp1238 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp1240 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1239 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1238 = vala_ccode_identifier_new ("klass"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1240 == NULL ? NULL : (__temp1240 = (g_object_unref (__temp1240), NULL)));
	(__temp1239 == NULL ? NULL : (__temp1239 = (g_object_unref (__temp1239), NULL)));
	(__temp1238 == NULL ? NULL : (__temp1238 = (g_object_unref (__temp1238), NULL)));
	__temp1242 = NULL;
	__temp1241 = NULL;
	ccall = (__temp1242 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1241 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1242);
	(__temp1241 == NULL ? NULL : (__temp1241 = (g_object_unref (__temp1241), NULL)));
	__temp1243 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1243 = vala_ccode_identifier_new ("klass"))));
	(__temp1243 == NULL ? NULL : (__temp1243 = (g_object_unref (__temp1243), NULL)));
	__temp1245 = NULL;
	__temp1244 = NULL;
	ccast = (__temp1245 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1244 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp1245);
	(__temp1244 == NULL ? NULL : (__temp1244 = (g_object_unref (__temp1244), NULL)));
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp1248 = NULL;
	__temp1247 = NULL;
	__temp1246 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp1248 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1247 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1246 = vala_ccode_identifier_new ("parent_class"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1248 == NULL ? NULL : (__temp1248 = (g_object_unref (__temp1248), NULL)));
	(__temp1247 == NULL ? NULL : (__temp1247 = (g_object_unref (__temp1247), NULL)));
	(__temp1246 == NULL ? NULL : (__temp1246 = (g_object_unref (__temp1246), NULL)));
	__temp1251 = NULL;
	__temp1250 = NULL;
	__temp1249 = NULL;
	ccall = (__temp1251 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1250 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1249 = vala_ccode_identifier_new ("parent_class"))), "dispose")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1251);
	(__temp1250 == NULL ? NULL : (__temp1250 = (g_object_unref (__temp1250), NULL)));
	(__temp1249 == NULL ? NULL : (__temp1249 = (g_object_unref (__temp1249), NULL)));
	__temp1252 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1252 = vala_ccode_identifier_new ("obj"))));
	(__temp1252 == NULL ? NULL : (__temp1252 = (g_object_unref (__temp1252), NULL)));
	__temp1253 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp1253 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(__temp1253 == NULL ? NULL : (__temp1253 = (g_object_unref (__temp1253), NULL)));
	vala_ccode_function_set_block (self->priv->function, cblock);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (type_reference)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_reference))) {
		return vala_ccode_identifier_new ("g_value_set_object");
	} else {
		if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->string_type)) {
			return vala_ccode_identifier_new ("g_value_set_string");
		} else {
			if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (type_reference))) {
				return vala_ccode_identifier_new ("g_value_set_int");
			} else {
				if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					return vala_ccode_identifier_new ("g_value_set_uint");
				} else {
					if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->long_type)) {
						return vala_ccode_identifier_new ("g_value_set_long");
					} else {
						if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							return vala_ccode_identifier_new ("g_value_set_ulong");
						} else {
							if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								return vala_ccode_identifier_new ("g_value_set_boolean");
							} else {
								if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->float_type)) {
									return vala_ccode_identifier_new ("g_value_set_float");
								} else {
									if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->double_type)) {
										return vala_ccode_identifier_new ("g_value_set_double");
									} else {
										return vala_ccode_identifier_new ("g_value_set_pointer");
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = vala_class_get_properties (cl);
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_get_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					gboolean __temp1264;
					return (__temp1264 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), (prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL))), __temp1264);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	return FALSE;
}


static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = vala_class_get_properties (cl);
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_set_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					gboolean __temp1266;
					return (__temp1266 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), (prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL))), __temp1266);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp1269;
	char* __temp1268;
	ValaCCodeFunction* __temp1270;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* __temp1271;
	ValaCCodeFormalParameter* __temp1272;
	ValaCCodeFormalParameter* __temp1273;
	ValaCCodeFormalParameter* __temp1274;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* __temp1276;
	char* __temp1275;
	ValaCCodeFunctionCall* __temp1277;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp1278;
	char* __temp1280;
	char* __temp1279;
	ValaCCodeDeclaration* __temp1281;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp1282;
	ValaCCodeIdentifier* __temp1283;
	ValaCCodeSwitchStatement* __temp1284;
	ValaCCodeSwitchStatement* cswitch;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp1269 = NULL;
	__temp1268 = NULL;
	__temp1270 = NULL;
	get_prop = (__temp1270 = vala_ccode_function_new ((__temp1269 = g_strdup_printf ("%s_get_property", (__temp1268 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (__temp1269 = (g_free (__temp1269), NULL)), (__temp1268 = (g_free (__temp1268), NULL)), __temp1270);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	__temp1271 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp1271 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp1271 == NULL ? NULL : (__temp1271 = (g_object_unref (__temp1271), NULL)));
	__temp1272 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp1272 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp1272 == NULL ? NULL : (__temp1272 = (g_object_unref (__temp1272), NULL)));
	__temp1273 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp1273 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(__temp1273 == NULL ? NULL : (__temp1273 = (g_object_unref (__temp1273), NULL)));
	__temp1274 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp1274 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp1274 == NULL ? NULL : (__temp1274 = (g_object_unref (__temp1274), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1276 = NULL;
	__temp1275 = NULL;
	__temp1277 = NULL;
	ccall = (__temp1277 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1276 = vala_ccode_identifier_new ((__temp1275 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp1276 == NULL ? NULL : (__temp1276 = (g_object_unref (__temp1276), NULL))), (__temp1275 = (g_free (__temp1275), NULL)), __temp1277);
	__temp1278 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1278 = vala_ccode_identifier_new ("object"))));
	(__temp1278 == NULL ? NULL : (__temp1278 = (g_object_unref (__temp1278), NULL)));
	__temp1280 = NULL;
	__temp1279 = NULL;
	__temp1281 = NULL;
	cdecl_ = (__temp1281 = vala_ccode_declaration_new ((__temp1280 = g_strdup_printf ("%s *", (__temp1279 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (__temp1280 = (g_free (__temp1280), NULL)), (__temp1279 = (g_free (__temp1279), NULL)), __temp1281);
	__temp1282 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1282 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp1282 == NULL ? NULL : (__temp1282 = (g_object_unref (__temp1282), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	__temp1283 = NULL;
	__temp1284 = NULL;
	cswitch = (__temp1284 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((__temp1283 = vala_ccode_identifier_new ("property_id")))), (__temp1283 == NULL ? NULL : (__temp1283 = (g_object_unref (__temp1283), NULL))), __temp1284);
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* __temp1287;
				char* __temp1286;
				ValaCCodeCaseStatement* __temp1288;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* __temp1290;
				char* __temp1289;
				ValaCCodeFunctionCall* __temp1291;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp1292;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* __temp1293;
				ValaCCodeIdentifier* __temp1294;
				ValaCCodeExpressionStatement* __temp1295;
				ValaCCodeBreakStatement* __temp1296;
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* __temp1285;
					__temp1285 = NULL;
					prefix = (__temp1285 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp1285);
				}
				__temp1287 = NULL;
				__temp1286 = NULL;
				__temp1288 = NULL;
				ccase = (__temp1288 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((__temp1287 = vala_ccode_identifier_new ((__temp1286 = vala_property_get_upper_case_cname (prop)))))), (__temp1287 == NULL ? NULL : (__temp1287 = (g_object_unref (__temp1287), NULL))), (__temp1286 = (g_free (__temp1286), NULL)), __temp1288);
				__temp1290 = NULL;
				__temp1289 = NULL;
				__temp1291 = NULL;
				ccall = (__temp1291 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1290 = vala_ccode_identifier_new ((__temp1289 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))))))), (__temp1290 == NULL ? NULL : (__temp1290 = (g_object_unref (__temp1290), NULL))), (__temp1289 = (g_free (__temp1289), NULL)), __temp1291);
				__temp1292 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1292 = vala_ccode_identifier_new ("self"))));
				(__temp1292 == NULL ? NULL : (__temp1292 = (g_object_unref (__temp1292), NULL)));
				csetcall = vala_ccode_function_call_new (NULL);
				__temp1293 = NULL;
				vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((__temp1293 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop)))));
				(__temp1293 = (g_object_unref (__temp1293), NULL));
				__temp1294 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((__temp1294 = vala_ccode_identifier_new ("value"))));
				(__temp1294 == NULL ? NULL : (__temp1294 = (g_object_unref (__temp1294), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				__temp1295 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp1295 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(__temp1295 == NULL ? NULL : (__temp1295 = (g_object_unref (__temp1295), NULL)));
				__temp1296 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp1296 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp1296 == NULL ? NULL : (__temp1296 = (g_object_unref (__temp1296), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp1298;
	char* __temp1297;
	ValaCCodeFunction* __temp1299;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* __temp1300;
	ValaCCodeFormalParameter* __temp1301;
	ValaCCodeFormalParameter* __temp1302;
	ValaCCodeFormalParameter* __temp1303;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* __temp1305;
	char* __temp1304;
	ValaCCodeFunctionCall* __temp1306;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp1307;
	char* __temp1309;
	char* __temp1308;
	ValaCCodeDeclaration* __temp1310;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp1311;
	ValaCCodeIdentifier* __temp1312;
	ValaCCodeSwitchStatement* __temp1313;
	ValaCCodeSwitchStatement* cswitch;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp1298 = NULL;
	__temp1297 = NULL;
	__temp1299 = NULL;
	set_prop = (__temp1299 = vala_ccode_function_new ((__temp1298 = g_strdup_printf ("%s_set_property", (__temp1297 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (__temp1298 = (g_free (__temp1298), NULL)), (__temp1297 = (g_free (__temp1297), NULL)), __temp1299);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	__temp1300 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp1300 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp1300 == NULL ? NULL : (__temp1300 = (g_object_unref (__temp1300), NULL)));
	__temp1301 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp1301 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp1301 == NULL ? NULL : (__temp1301 = (g_object_unref (__temp1301), NULL)));
	__temp1302 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp1302 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(__temp1302 == NULL ? NULL : (__temp1302 = (g_object_unref (__temp1302), NULL)));
	__temp1303 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp1303 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp1303 == NULL ? NULL : (__temp1303 = (g_object_unref (__temp1303), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1305 = NULL;
	__temp1304 = NULL;
	__temp1306 = NULL;
	ccall = (__temp1306 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1305 = vala_ccode_identifier_new ((__temp1304 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp1305 == NULL ? NULL : (__temp1305 = (g_object_unref (__temp1305), NULL))), (__temp1304 = (g_free (__temp1304), NULL)), __temp1306);
	__temp1307 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1307 = vala_ccode_identifier_new ("object"))));
	(__temp1307 == NULL ? NULL : (__temp1307 = (g_object_unref (__temp1307), NULL)));
	__temp1309 = NULL;
	__temp1308 = NULL;
	__temp1310 = NULL;
	cdecl_ = (__temp1310 = vala_ccode_declaration_new ((__temp1309 = g_strdup_printf ("%s *", (__temp1308 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (__temp1309 = (g_free (__temp1309), NULL)), (__temp1308 = (g_free (__temp1308), NULL)), __temp1310);
	__temp1311 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1311 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp1311 == NULL ? NULL : (__temp1311 = (g_object_unref (__temp1311), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	__temp1312 = NULL;
	__temp1313 = NULL;
	cswitch = (__temp1313 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((__temp1312 = vala_ccode_identifier_new ("property_id")))), (__temp1312 == NULL ? NULL : (__temp1312 = (g_object_unref (__temp1312), NULL))), __temp1313);
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* __temp1316;
				char* __temp1315;
				ValaCCodeCaseStatement* __temp1317;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* __temp1319;
				char* __temp1318;
				ValaCCodeFunctionCall* __temp1320;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp1321;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* __temp1332;
				ValaCCodeExpressionStatement* __temp1333;
				ValaCCodeBreakStatement* __temp1334;
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* __temp1314;
					__temp1314 = NULL;
					prefix = (__temp1314 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp1314);
				}
				__temp1316 = NULL;
				__temp1315 = NULL;
				__temp1317 = NULL;
				ccase = (__temp1317 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((__temp1316 = vala_ccode_identifier_new ((__temp1315 = vala_property_get_upper_case_cname (prop)))))), (__temp1316 == NULL ? NULL : (__temp1316 = (g_object_unref (__temp1316), NULL))), (__temp1315 = (g_free (__temp1315), NULL)), __temp1317);
				__temp1319 = NULL;
				__temp1318 = NULL;
				__temp1320 = NULL;
				ccall = (__temp1320 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1319 = vala_ccode_identifier_new ((__temp1318 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))))))), (__temp1319 == NULL ? NULL : (__temp1319 = (g_object_unref (__temp1319), NULL))), (__temp1318 = (g_free (__temp1318), NULL)), __temp1320);
				__temp1321 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1321 = vala_ccode_identifier_new ("self"))));
				(__temp1321 == NULL ? NULL : (__temp1321 = (g_object_unref (__temp1321), NULL)));
				cgetcall = vala_ccode_function_call_new (NULL);
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
					ValaCCodeIdentifier* __temp1322;
					__temp1322 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1322 = vala_ccode_identifier_new ("g_value_get_object"))));
					(__temp1322 == NULL ? NULL : (__temp1322 = (g_object_unref (__temp1322), NULL)));
				} else {
					if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "string") == 0) {
						ValaCCodeIdentifier* __temp1323;
						__temp1323 = NULL;
						vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1323 = vala_ccode_identifier_new ("g_value_get_string"))));
						(__temp1323 == NULL ? NULL : (__temp1323 = (g_object_unref (__temp1323), NULL)));
					} else {
						if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "int") == 0 || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
							ValaCCodeIdentifier* __temp1324;
							__temp1324 = NULL;
							vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1324 = vala_ccode_identifier_new ("g_value_get_int"))));
							(__temp1324 == NULL ? NULL : (__temp1324 = (g_object_unref (__temp1324), NULL)));
						} else {
							if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "uint") == 0) {
								ValaCCodeIdentifier* __temp1325;
								__temp1325 = NULL;
								vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1325 = vala_ccode_identifier_new ("g_value_get_uint"))));
								(__temp1325 == NULL ? NULL : (__temp1325 = (g_object_unref (__temp1325), NULL)));
							} else {
								if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "long") == 0) {
									ValaCCodeIdentifier* __temp1326;
									__temp1326 = NULL;
									vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1326 = vala_ccode_identifier_new ("g_value_get_long"))));
									(__temp1326 == NULL ? NULL : (__temp1326 = (g_object_unref (__temp1326), NULL)));
								} else {
									if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "ulong") == 0) {
										ValaCCodeIdentifier* __temp1327;
										__temp1327 = NULL;
										vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1327 = vala_ccode_identifier_new ("g_value_get_ulong"))));
										(__temp1327 == NULL ? NULL : (__temp1327 = (g_object_unref (__temp1327), NULL)));
									} else {
										if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "bool") == 0) {
											ValaCCodeIdentifier* __temp1328;
											__temp1328 = NULL;
											vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1328 = vala_ccode_identifier_new ("g_value_get_boolean"))));
											(__temp1328 == NULL ? NULL : (__temp1328 = (g_object_unref (__temp1328), NULL)));
										} else {
											if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "float") == 0) {
												ValaCCodeIdentifier* __temp1329;
												__temp1329 = NULL;
												vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1329 = vala_ccode_identifier_new ("g_value_get_float"))));
												(__temp1329 == NULL ? NULL : (__temp1329 = (g_object_unref (__temp1329), NULL)));
											} else {
												if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "double") == 0) {
													ValaCCodeIdentifier* __temp1330;
													__temp1330 = NULL;
													vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1330 = vala_ccode_identifier_new ("g_value_get_double"))));
													(__temp1330 == NULL ? NULL : (__temp1330 = (g_object_unref (__temp1330), NULL)));
												} else {
													ValaCCodeIdentifier* __temp1331;
													__temp1331 = NULL;
													vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp1331 = vala_ccode_identifier_new ("g_value_get_pointer"))));
													(__temp1331 == NULL ? NULL : (__temp1331 = (g_object_unref (__temp1331), NULL)));
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp1332 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp1332 = vala_ccode_identifier_new ("value"))));
				(__temp1332 == NULL ? NULL : (__temp1332 = (g_object_unref (__temp1332), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				__temp1333 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp1333 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(__temp1333 == NULL ? NULL : (__temp1333 = (g_object_unref (__temp1333), NULL)));
				__temp1334 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp1334 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp1334 == NULL ? NULL : (__temp1334 = (g_object_unref (__temp1334), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	{
		GeeCollection* type_param_collection;
		GeeIterator* type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
		while (gee_iterator_next (type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = gee_iterator_get (type_param_it);
			{
				char* __temp1335;
				char* __temp1336;
				char* func_name;
				char* __temp1338;
				char* __temp1337;
				char* __temp1339;
				char* enum_value;
				ValaCCodeIdentifier* __temp1340;
				ValaCCodeCaseStatement* __temp1341;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* __temp1343;
				ValaCCodeIdentifier* __temp1342;
				ValaCCodeMemberAccess* __temp1344;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeIdentifier* __temp1345;
				ValaCCodeFunctionCall* __temp1346;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* __temp1347;
				ValaCCodeExpressionStatement* __temp1349;
				ValaCCodeAssignment* __temp1348;
				ValaCCodeBreakStatement* __temp1350;
				/* destroy func properties for generic types */
				__temp1335 = NULL;
				__temp1336 = NULL;
				func_name = (__temp1336 = g_strdup_printf ("%s_destroy_func", (__temp1335 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (__temp1335 = (g_free (__temp1335), NULL)), __temp1336);
				__temp1338 = NULL;
				__temp1337 = NULL;
				__temp1339 = NULL;
				enum_value = (__temp1339 = g_utf8_strup ((__temp1338 = g_strdup_printf ("%s_%s", (__temp1337 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (__temp1338 = (g_free (__temp1338), NULL)), (__temp1337 = (g_free (__temp1337), NULL)), __temp1339);
				__temp1340 = NULL;
				__temp1341 = NULL;
				ccase = (__temp1341 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((__temp1340 = vala_ccode_identifier_new (enum_value)))), (__temp1340 == NULL ? NULL : (__temp1340 = (g_object_unref (__temp1340), NULL))), __temp1341);
				__temp1343 = NULL;
				__temp1342 = NULL;
				__temp1344 = NULL;
				cfield = (__temp1344 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1343 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1342 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (__temp1343 == NULL ? NULL : (__temp1343 = (g_object_unref (__temp1343), NULL))), (__temp1342 == NULL ? NULL : (__temp1342 = (g_object_unref (__temp1342), NULL))), __temp1344);
				__temp1345 = NULL;
				__temp1346 = NULL;
				cgetcall = (__temp1346 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1345 = vala_ccode_identifier_new ("g_value_get_pointer")))), (__temp1345 == NULL ? NULL : (__temp1345 = (g_object_unref (__temp1345), NULL))), __temp1346);
				__temp1347 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp1347 = vala_ccode_identifier_new ("value"))));
				(__temp1347 == NULL ? NULL : (__temp1347 = (g_object_unref (__temp1347), NULL)));
				__temp1349 = NULL;
				__temp1348 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp1349 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1348 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(__temp1349 == NULL ? NULL : (__temp1349 = (g_object_unref (__temp1349), NULL)));
				(__temp1348 == NULL ? NULL : (__temp1348 = (g_object_unref (__temp1348), NULL)));
				__temp1350 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp1350 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp1350 == NULL ? NULL : (__temp1350 = (g_object_unref (__temp1350), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
	}
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp1351;
	ValaSymbol* __temp1352;
	ValaSymbol* __temp1391;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp1351 = NULL;
	self->priv->current_symbol = (__temp1351 = VALA_SYMBOL (g_object_ref (iface)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp1351);
	__temp1352 = NULL;
	self->priv->current_type_symbol = (__temp1352 = VALA_SYMBOL (g_object_ref (iface)), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1352);
	if (!vala_interface_get_is_static (iface)) {
		ValaCCodeStruct* __temp1355;
		char* __temp1354;
		char* __temp1353;
		ValaCCodeNewline* __temp1356;
		char* __temp1357;
		char* __temp1358;
		char* macro;
		ValaCCodeMacroReplacement* __temp1360;
		char* __temp1359;
		char* __temp1363;
		char* __temp1362;
		char* __temp1361;
		ValaCCodeMacroReplacement* __temp1366;
		char* __temp1365;
		char* __temp1364;
		char* __temp1368;
		char* __temp1367;
		ValaCCodeMacroReplacement* __temp1371;
		char* __temp1370;
		char* __temp1369;
		char* __temp1374;
		char* __temp1373;
		char* __temp1372;
		ValaCCodeMacroReplacement* __temp1377;
		char* __temp1376;
		char* __temp1375;
		ValaCCodeNewline* __temp1378;
		__temp1355 = NULL;
		__temp1354 = NULL;
		__temp1353 = NULL;
		self->priv->type_struct = (__temp1355 = vala_ccode_struct_new ((__temp1354 = g_strdup_printf ("_%s", (__temp1353 = vala_interface_get_type_cname (iface))))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp1355);
		(__temp1354 = (g_free (__temp1354), NULL));
		(__temp1353 = (g_free (__temp1353), NULL));
		__temp1356 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1356 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(__temp1356 == NULL ? NULL : (__temp1356 = (g_object_unref (__temp1356), NULL)));
		__temp1357 = NULL;
		__temp1358 = NULL;
		macro = (__temp1358 = g_strdup_printf ("(%s_get_type ())", (__temp1357 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (__temp1357 = (g_free (__temp1357), NULL)), __temp1358);
		__temp1360 = NULL;
		__temp1359 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1360 = vala_ccode_macro_replacement_new ((__temp1359 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), macro))));
		(__temp1360 == NULL ? NULL : (__temp1360 = (g_object_unref (__temp1360), NULL)));
		(__temp1359 = (g_free (__temp1359), NULL));
		__temp1363 = NULL;
		__temp1362 = NULL;
		__temp1361 = NULL;
		macro = (__temp1363 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp1361 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp1362 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), (macro = (g_free (macro), NULL)), __temp1363);
		(__temp1362 = (g_free (__temp1362), NULL));
		(__temp1361 = (g_free (__temp1361), NULL));
		__temp1366 = NULL;
		__temp1365 = NULL;
		__temp1364 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1366 = vala_ccode_macro_replacement_new ((__temp1365 = g_strdup_printf ("%s(obj)", (__temp1364 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))), macro))));
		(__temp1366 == NULL ? NULL : (__temp1366 = (g_object_unref (__temp1366), NULL)));
		(__temp1365 = (g_free (__temp1365), NULL));
		(__temp1364 = (g_free (__temp1364), NULL));
		__temp1368 = NULL;
		__temp1367 = NULL;
		macro = (__temp1368 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp1367 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp1368);
		(__temp1367 = (g_free (__temp1367), NULL));
		__temp1371 = NULL;
		__temp1370 = NULL;
		__temp1369 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1371 = vala_ccode_macro_replacement_new ((__temp1370 = g_strdup_printf ("%s(obj)", (__temp1369 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "IS_")))), macro))));
		(__temp1371 == NULL ? NULL : (__temp1371 = (g_object_unref (__temp1371), NULL)));
		(__temp1370 = (g_free (__temp1370), NULL));
		(__temp1369 = (g_free (__temp1369), NULL));
		__temp1374 = NULL;
		__temp1373 = NULL;
		__temp1372 = NULL;
		macro = (__temp1374 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (__temp1372 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp1373 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), __temp1374);
		(__temp1373 = (g_free (__temp1373), NULL));
		(__temp1372 = (g_free (__temp1372), NULL));
		__temp1377 = NULL;
		__temp1376 = NULL;
		__temp1375 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1377 = vala_ccode_macro_replacement_new ((__temp1376 = g_strdup_printf ("%s_GET_INTERFACE(obj)", (__temp1375 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))), macro))));
		(__temp1377 == NULL ? NULL : (__temp1377 = (g_object_unref (__temp1377), NULL)));
		(__temp1376 = (g_free (__temp1376), NULL));
		(__temp1375 = (g_free (__temp1375), NULL));
		__temp1378 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1378 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(__temp1378 == NULL ? NULL : (__temp1378 = (g_object_unref (__temp1378), NULL)));
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) iface)))) == NULL) {
			ValaCCodeTypeDefinition* __temp1383;
			ValaCCodeVariableDeclarator* __temp1382;
			char* __temp1381;
			char* __temp1380;
			char* __temp1379;
			ValaCCodeTypeDefinition* __temp1387;
			ValaCCodeVariableDeclarator* __temp1386;
			char* __temp1385;
			char* __temp1384;
			__temp1383 = NULL;
			__temp1382 = NULL;
			__temp1381 = NULL;
			__temp1380 = NULL;
			__temp1379 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1383 = vala_ccode_type_definition_new ((__temp1380 = g_strdup_printf ("struct _%s", (__temp1379 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))), VALA_CCODE_DECLARATOR ((__temp1382 = vala_ccode_variable_declarator_new ((__temp1381 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))))));
			(__temp1383 == NULL ? NULL : (__temp1383 = (g_object_unref (__temp1383), NULL)));
			(__temp1382 == NULL ? NULL : (__temp1382 = (g_object_unref (__temp1382), NULL)));
			(__temp1381 = (g_free (__temp1381), NULL));
			(__temp1380 = (g_free (__temp1380), NULL));
			(__temp1379 = (g_free (__temp1379), NULL));
			__temp1387 = NULL;
			__temp1386 = NULL;
			__temp1385 = NULL;
			__temp1384 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1387 = vala_ccode_type_definition_new ((__temp1384 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct))), VALA_CCODE_DECLARATOR ((__temp1386 = vala_ccode_variable_declarator_new ((__temp1385 = vala_interface_get_type_cname (iface)))))))));
			(__temp1387 == NULL ? NULL : (__temp1387 = (g_object_unref (__temp1387), NULL)));
			(__temp1386 == NULL ? NULL : (__temp1386 = (g_object_unref (__temp1386), NULL)));
			(__temp1385 = (g_free (__temp1385), NULL));
			(__temp1384 = (g_free (__temp1384), NULL));
		}
		vala_ccode_struct_add_field (self->priv->type_struct, "GTypeInterface", "parent");
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) iface))) != NULL) {
			ValaCCodeComment* __temp1388;
			__temp1388 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp1388 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) iface)))))));
			(__temp1388 == NULL ? NULL : (__temp1388 = (g_object_unref (__temp1388), NULL)));
		}
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
		(macro = (g_free (macro), NULL));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	if (!vala_interface_get_is_static (iface)) {
		ValaInterfaceRegisterFunction* type_fun;
		ValaCCodeFragment* __temp1389;
		ValaCCodeFragment* __temp1390;
		vala_code_generator_add_interface_base_init_function (self, iface);
		type_fun = vala_interface_register_function_new (iface);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), FALSE);
		__temp1389 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1389 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp1389 = (g_object_unref (__temp1389), NULL));
		__temp1390 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp1390 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp1390 = (g_object_unref (__temp1390), NULL));
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	__temp1391 = NULL;
	self->priv->current_type_symbol = (__temp1391 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1391);
}


static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop)
{
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* __temp1392;
	ValaCCodeConstant* __temp1393;
	ValaCCodeConstant* __temp1394;
	char* pflags;
	ValaCCodeConstant* __temp1431;
	ValaCCodeFunctionCall* __temp1432;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	__temp1392 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1392 = vala_property_get_canonical_cconstant (prop))));
	(__temp1392 = (g_object_unref (__temp1392), NULL));
	__temp1393 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1393 = vala_ccode_constant_new ("\"foo\""))));
	(__temp1393 == NULL ? NULL : (__temp1393 = (g_object_unref (__temp1393), NULL)));
	__temp1394 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1394 = vala_ccode_constant_new ("\"bar\""))));
	(__temp1394 == NULL ? NULL : (__temp1394 = (g_object_unref (__temp1394), NULL)));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* __temp1395;
		ValaCCodeIdentifier* __temp1397;
		char* __temp1396;
		__temp1395 = NULL;
		vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1395 = vala_ccode_identifier_new ("g_param_spec_object"))));
		(__temp1395 == NULL ? NULL : (__temp1395 = (g_object_unref (__temp1395), NULL)));
		__temp1397 = NULL;
		__temp1396 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1397 = vala_ccode_identifier_new ((__temp1396 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), "TYPE_"))))));
		(__temp1397 == NULL ? NULL : (__temp1397 = (g_object_unref (__temp1397), NULL)));
		(__temp1396 = (g_free (__temp1396), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->string_type)) {
			ValaCCodeIdentifier* __temp1398;
			ValaCCodeConstant* __temp1399;
			__temp1398 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1398 = vala_ccode_identifier_new ("g_param_spec_string"))));
			(__temp1398 == NULL ? NULL : (__temp1398 = (g_object_unref (__temp1398), NULL)));
			__temp1399 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1399 = vala_ccode_constant_new ("NULL"))));
			(__temp1399 == NULL ? NULL : (__temp1399 = (g_object_unref (__temp1399), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeIdentifier* __temp1400;
				ValaCCodeConstant* __temp1401;
				ValaCCodeConstant* __temp1402;
				ValaCCodeConstant* __temp1403;
				__temp1400 = NULL;
				vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1400 = vala_ccode_identifier_new ("g_param_spec_int"))));
				(__temp1400 == NULL ? NULL : (__temp1400 = (g_object_unref (__temp1400), NULL)));
				__temp1401 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1401 = vala_ccode_constant_new ("G_MININT"))));
				(__temp1401 == NULL ? NULL : (__temp1401 = (g_object_unref (__temp1401), NULL)));
				__temp1402 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1402 = vala_ccode_constant_new ("G_MAXINT"))));
				(__temp1402 == NULL ? NULL : (__temp1402 = (g_object_unref (__temp1402), NULL)));
				__temp1403 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1403 = vala_ccode_constant_new ("0"))));
				(__temp1403 == NULL ? NULL : (__temp1403 = (g_object_unref (__temp1403), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeIdentifier* __temp1404;
					ValaCCodeConstant* __temp1405;
					ValaCCodeConstant* __temp1406;
					ValaCCodeConstant* __temp1407;
					__temp1404 = NULL;
					vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1404 = vala_ccode_identifier_new ("g_param_spec_uint"))));
					(__temp1404 == NULL ? NULL : (__temp1404 = (g_object_unref (__temp1404), NULL)));
					__temp1405 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1405 = vala_ccode_constant_new ("0"))));
					(__temp1405 == NULL ? NULL : (__temp1405 = (g_object_unref (__temp1405), NULL)));
					__temp1406 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1406 = vala_ccode_constant_new ("G_MAXUINT"))));
					(__temp1406 == NULL ? NULL : (__temp1406 = (g_object_unref (__temp1406), NULL)));
					__temp1407 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1407 = vala_ccode_constant_new ("0U"))));
					(__temp1407 == NULL ? NULL : (__temp1407 = (g_object_unref (__temp1407), NULL)));
				} else {
					if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->long_type)) {
						ValaCCodeIdentifier* __temp1408;
						ValaCCodeConstant* __temp1409;
						ValaCCodeConstant* __temp1410;
						ValaCCodeConstant* __temp1411;
						__temp1408 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1408 = vala_ccode_identifier_new ("g_param_spec_long"))));
						(__temp1408 == NULL ? NULL : (__temp1408 = (g_object_unref (__temp1408), NULL)));
						__temp1409 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1409 = vala_ccode_constant_new ("G_MINLONG"))));
						(__temp1409 == NULL ? NULL : (__temp1409 = (g_object_unref (__temp1409), NULL)));
						__temp1410 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1410 = vala_ccode_constant_new ("G_MAXLONG"))));
						(__temp1410 == NULL ? NULL : (__temp1410 = (g_object_unref (__temp1410), NULL)));
						__temp1411 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1411 = vala_ccode_constant_new ("0L"))));
						(__temp1411 == NULL ? NULL : (__temp1411 = (g_object_unref (__temp1411), NULL)));
					} else {
						if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							ValaCCodeIdentifier* __temp1412;
							ValaCCodeConstant* __temp1413;
							ValaCCodeConstant* __temp1414;
							ValaCCodeConstant* __temp1415;
							__temp1412 = NULL;
							vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1412 = vala_ccode_identifier_new ("g_param_spec_ulong"))));
							(__temp1412 == NULL ? NULL : (__temp1412 = (g_object_unref (__temp1412), NULL)));
							__temp1413 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1413 = vala_ccode_constant_new ("0"))));
							(__temp1413 == NULL ? NULL : (__temp1413 = (g_object_unref (__temp1413), NULL)));
							__temp1414 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1414 = vala_ccode_constant_new ("G_MAXULONG"))));
							(__temp1414 == NULL ? NULL : (__temp1414 = (g_object_unref (__temp1414), NULL)));
							__temp1415 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1415 = vala_ccode_constant_new ("0UL"))));
							(__temp1415 == NULL ? NULL : (__temp1415 = (g_object_unref (__temp1415), NULL)));
						} else {
							if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								ValaCCodeIdentifier* __temp1416;
								ValaCCodeConstant* __temp1417;
								__temp1416 = NULL;
								vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1416 = vala_ccode_identifier_new ("g_param_spec_boolean"))));
								(__temp1416 == NULL ? NULL : (__temp1416 = (g_object_unref (__temp1416), NULL)));
								__temp1417 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1417 = vala_ccode_constant_new ("FALSE"))));
								(__temp1417 == NULL ? NULL : (__temp1417 = (g_object_unref (__temp1417), NULL)));
							} else {
								if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->float_type)) {
									ValaCCodeIdentifier* __temp1418;
									ValaCCodeConstant* __temp1419;
									ValaCCodeConstant* __temp1420;
									ValaCCodeConstant* __temp1421;
									__temp1418 = NULL;
									vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1418 = vala_ccode_identifier_new ("g_param_spec_float"))));
									(__temp1418 == NULL ? NULL : (__temp1418 = (g_object_unref (__temp1418), NULL)));
									__temp1419 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1419 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
									(__temp1419 == NULL ? NULL : (__temp1419 = (g_object_unref (__temp1419), NULL)));
									__temp1420 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1420 = vala_ccode_constant_new ("G_MAXFLOAT"))));
									(__temp1420 == NULL ? NULL : (__temp1420 = (g_object_unref (__temp1420), NULL)));
									__temp1421 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1421 = vala_ccode_constant_new ("0.0F"))));
									(__temp1421 == NULL ? NULL : (__temp1421 = (g_object_unref (__temp1421), NULL)));
								} else {
									if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->double_type)) {
										ValaCCodeIdentifier* __temp1422;
										ValaCCodeConstant* __temp1423;
										ValaCCodeConstant* __temp1424;
										ValaCCodeConstant* __temp1425;
										__temp1422 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1422 = vala_ccode_identifier_new ("g_param_spec_double"))));
										(__temp1422 == NULL ? NULL : (__temp1422 = (g_object_unref (__temp1422), NULL)));
										__temp1423 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1423 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
										(__temp1423 == NULL ? NULL : (__temp1423 = (g_object_unref (__temp1423), NULL)));
										__temp1424 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1424 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
										(__temp1424 == NULL ? NULL : (__temp1424 = (g_object_unref (__temp1424), NULL)));
										__temp1425 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1425 = vala_ccode_constant_new ("0.0"))));
										(__temp1425 == NULL ? NULL : (__temp1425 = (g_object_unref (__temp1425), NULL)));
									} else {
										ValaCCodeIdentifier* __temp1426;
										__temp1426 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp1426 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
										(__temp1426 == NULL ? NULL : (__temp1426 = (g_object_unref (__temp1426), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* __temp1427;
		__temp1427 = NULL;
		pflags = (__temp1427 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), __temp1427);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* __temp1428;
		__temp1428 = NULL;
		pflags = (__temp1428 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), __temp1428);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* __temp1429;
				__temp1429 = NULL;
				pflags = (__temp1429 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), __temp1429);
			} else {
				char* __temp1430;
				__temp1430 = NULL;
				pflags = (__temp1430 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), __temp1430);
			}
		}
	}
	__temp1431 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp1431 = vala_ccode_constant_new (pflags))));
	(__temp1431 == NULL ? NULL : (__temp1431 = (g_object_unref (__temp1431), NULL)));
	__temp1432 = NULL;
	return (__temp1432 = cspec, (pflags = (g_free (pflags), NULL)), __temp1432);
	(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
	(pflags = (g_free (pflags), NULL));
}


static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type)
{
	ValaCCodeIdentifier* __temp1433;
	ValaCCodeFunctionCall* __temp1434;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* __temp1436;
	char* __temp1435;
	ValaCCodeIdentifier* __temp1438;
	char* __temp1437;
	ValaCCodeConstant* __temp1439;
	ValaCCodeConstant* __temp1440;
	ValaCCodeConstant* __temp1441;
	ValaCCodeConstant* __temp1442;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeCollection* params;
	gint params_len;
	ValaCCodeConstant* __temp1448;
	char* __temp1447;
	ValaCCodeFunctionCall* __temp1452;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	__temp1433 = NULL;
	__temp1434 = NULL;
	csignew = (__temp1434 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1433 = vala_ccode_identifier_new ("g_signal_new")))), (__temp1433 == NULL ? NULL : (__temp1433 = (g_object_unref (__temp1433), NULL))), __temp1434);
	__temp1436 = NULL;
	__temp1435 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1436 = vala_ccode_constant_new ((__temp1435 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (((ValaSymbol*) sig))))))));
	(__temp1436 == NULL ? NULL : (__temp1436 = (g_object_unref (__temp1436), NULL)));
	(__temp1435 = (g_free (__temp1435), NULL));
	__temp1438 = NULL;
	__temp1437 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1438 = vala_ccode_identifier_new ((__temp1437 = vala_data_type_get_upper_case_cname (type, "TYPE_"))))));
	(__temp1438 == NULL ? NULL : (__temp1438 = (g_object_unref (__temp1438), NULL)));
	(__temp1437 = (g_free (__temp1437), NULL));
	__temp1439 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1439 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(__temp1439 == NULL ? NULL : (__temp1439 = (g_object_unref (__temp1439), NULL)));
	__temp1440 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1440 = vala_ccode_constant_new ("0"))));
	(__temp1440 == NULL ? NULL : (__temp1440 = (g_object_unref (__temp1440), NULL)));
	__temp1441 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1441 = vala_ccode_constant_new ("NULL"))));
	(__temp1441 == NULL ? NULL : (__temp1441 = (g_object_unref (__temp1441), NULL)));
	__temp1442 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1442 = vala_ccode_constant_new ("NULL"))));
	(__temp1442 == NULL ? NULL : (__temp1442 = (g_object_unref (__temp1442), NULL)));
	marshaller = vala_code_generator_get_signal_marshaller_function (self, sig, NULL);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	params_len = gee_collection_get_size (params);
	if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* __temp1443;
		__temp1443 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1443 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(__temp1443 == NULL ? NULL : (__temp1443 = (g_object_unref (__temp1443), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
			ValaCCodeConstant* __temp1444;
			__temp1444 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1444 = vala_ccode_constant_new ("G_TYPE_NONE"))));
			(__temp1444 == NULL ? NULL : (__temp1444 = (g_object_unref (__temp1444), NULL)));
		} else {
			ValaCCodeConstant* __temp1446;
			char* __temp1445;
			__temp1446 = NULL;
			__temp1445 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1446 = vala_ccode_constant_new ((__temp1445 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))))))));
			(__temp1446 == NULL ? NULL : (__temp1446 = (g_object_unref (__temp1446), NULL)));
			(__temp1445 = (g_free (__temp1445), NULL));
		}
	}
	__temp1448 = NULL;
	__temp1447 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1448 = vala_ccode_constant_new ((__temp1447 = g_strdup_printf ("%d", params_len))))));
	(__temp1448 == NULL ? NULL : (__temp1448 = (g_object_unref (__temp1448), NULL)));
	(__temp1447 = (g_free (__temp1447), NULL));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL) {
					ValaCCodeConstant* __temp1449;
					__temp1449 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1449 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(__temp1449 == NULL ? NULL : (__temp1449 = (g_object_unref (__temp1449), NULL)));
				} else {
					ValaCCodeConstant* __temp1451;
					char* __temp1450;
					__temp1451 = NULL;
					__temp1450 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp1451 = vala_ccode_constant_new ((__temp1450 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
					(__temp1451 == NULL ? NULL : (__temp1451 = (g_object_unref (__temp1451), NULL)));
					(__temp1450 = (g_free (__temp1450), NULL));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	__temp1452 = NULL;
	return (__temp1452 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), __temp1452);
	(csignew == NULL ? NULL : (csignew = (g_object_unref (csignew), NULL)));
	(marshaller = (g_free (marshaller), NULL));
	(marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface)
{
	char* __temp1454;
	char* __temp1453;
	ValaCCodeFunction* __temp1455;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* __temp1458;
	char* __temp1457;
	char* __temp1456;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* __temp1459;
	char* __temp1460;
	ValaCCodeDeclaration* __temp1461;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* __temp1463;
	ValaCCodeConstant* __temp1462;
	ValaCCodeUnaryExpression* __temp1465;
	ValaCCodeIdentifier* __temp1464;
	ValaCCodeIfStatement* __temp1466;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* __temp1470;
	ValaCCodeAssignment* __temp1469;
	ValaCCodeConstant* __temp1468;
	ValaCCodeIdentifier* __temp1467;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp1454 = NULL;
	__temp1453 = NULL;
	__temp1455 = NULL;
	base_init = (__temp1455 = vala_ccode_function_new ((__temp1454 = g_strdup_printf ("%s_base_init", (__temp1453 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (__temp1454 = (g_free (__temp1454), NULL)), (__temp1453 = (g_free (__temp1453), NULL)), __temp1455);
	__temp1458 = NULL;
	__temp1457 = NULL;
	__temp1456 = NULL;
	vala_ccode_function_add_parameter (base_init, (__temp1458 = vala_ccode_formal_parameter_new ("iface", (__temp1457 = g_strdup_printf ("%sIface *", (__temp1456 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
	(__temp1458 == NULL ? NULL : (__temp1458 = (g_object_unref (__temp1458), NULL)));
	(__temp1457 = (g_free (__temp1457), NULL));
	(__temp1456 = (g_free (__temp1456), NULL));
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	/* make sure not to run the initialization code twice */
	__temp1459 = NULL;
	vala_ccode_function_set_block (base_init, (__temp1459 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
	(__temp1459 == NULL ? NULL : (__temp1459 = (g_object_unref (__temp1459), NULL)));
	__temp1460 = NULL;
	__temp1461 = NULL;
	decl = (__temp1461 = vala_ccode_declaration_new ((__temp1460 = vala_type_reference_get_cname (self->priv->bool_type, FALSE, FALSE))), (__temp1460 = (g_free (__temp1460), NULL)), __temp1461);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC));
	__temp1463 = NULL;
	__temp1462 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp1463 = vala_ccode_variable_declarator_new_with_initializer ("initialized", VALA_CCODE_EXPRESSION ((__temp1462 = vala_ccode_constant_new ("FALSE")))))));
	(__temp1463 == NULL ? NULL : (__temp1463 = (g_object_unref (__temp1463), NULL)));
	(__temp1462 == NULL ? NULL : (__temp1462 = (g_object_unref (__temp1462), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (decl));
	__temp1465 = NULL;
	__temp1464 = NULL;
	__temp1466 = NULL;
	cif = (__temp1466 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((__temp1465 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION ((__temp1464 = vala_ccode_identifier_new ("initialized")))))), VALA_CCODE_STATEMENT (init_block), NULL), (__temp1465 == NULL ? NULL : (__temp1465 = (g_object_unref (__temp1465), NULL))), (__temp1464 == NULL ? NULL : (__temp1464 = (g_object_unref (__temp1464), NULL))), __temp1466);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (cif));
	__temp1470 = NULL;
	__temp1469 = NULL;
	__temp1468 = NULL;
	__temp1467 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1470 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1469 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1467 = vala_ccode_identifier_new ("initialized"))), VALA_CCODE_EXPRESSION ((__temp1468 = vala_ccode_constant_new ("TRUE"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1470 == NULL ? NULL : (__temp1470 = (g_object_unref (__temp1470), NULL)));
	(__temp1469 == NULL ? NULL : (__temp1469 = (g_object_unref (__temp1469), NULL)));
	(__temp1468 == NULL ? NULL : (__temp1468 = (g_object_unref (__temp1468), NULL)));
	(__temp1467 == NULL ? NULL : (__temp1467 = (g_object_unref (__temp1467), NULL)));
	/* create properties */
	props = vala_interface_get_properties (iface);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				ValaCCodeIdentifier* __temp1471;
				ValaCCodeFunctionCall* __temp1472;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeIdentifier* __temp1473;
				ValaCCodeFunctionCall* __temp1474;
				ValaCCodeExpressionStatement* __temp1475;
				__temp1471 = NULL;
				__temp1472 = NULL;
				cinst = (__temp1472 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1471 = vala_ccode_identifier_new ("g_object_interface_install_property")))), (__temp1471 == NULL ? NULL : (__temp1471 = (g_object_unref (__temp1471), NULL))), __temp1472);
				__temp1473 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1473 = vala_ccode_identifier_new ("iface"))));
				(__temp1473 == NULL ? NULL : (__temp1473 = (g_object_unref (__temp1473), NULL)));
				__temp1474 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp1474 = vala_code_generator_get_param_spec (self, prop))));
				(__temp1474 = (g_object_unref (__temp1474), NULL));
				__temp1475 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1475 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp1475 == NULL ? NULL : (__temp1475 = (g_object_unref (__temp1475), NULL)));
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	{
		GeeCollection* sig_collection;
		GeeIterator* sig_it;
		sig_collection = vala_interface_get_signals (iface);
		sig_it = gee_iterable_iterator (GEE_ITERABLE (sig_collection));
		while (gee_iterator_next (sig_it)) {
			ValaSignal* sig;
			sig = gee_iterator_get (sig_it);
			{
				ValaCCodeExpressionStatement* __temp1477;
				ValaCCodeFunctionCall* __temp1476;
				/* create signals */
				__temp1477 = NULL;
				__temp1476 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp1477 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1476 = vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (iface))))))));
				(__temp1477 == NULL ? NULL : (__temp1477 = (g_object_unref (__temp1477), NULL)));
				(__temp1476 = (g_object_unref (__temp1476), NULL));
				(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
		(sig_it == NULL ? NULL : (sig_it = (g_object_unref (sig_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (base_init));
	(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeCollection* params;
	ValaMemberAccess* __temp1478;
	ValaMemberAccess* ma;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	GeeIterator* params_it;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (expr));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "unsupported method invocation");
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	__temp1478 = NULL;
	ma = (__temp1478 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (__temp1478 == NULL ? NULL : g_object_ref (__temp1478)));
	if (VALA_IS_INVOKABLE (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))) {
		ValaInvokable* __temp1479;
		ValaInvokable* i;
		GeeCollection* __temp1480;
		__temp1479 = NULL;
		i = (__temp1479 = VALA_INVOKABLE (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))), (__temp1479 == NULL ? NULL : g_object_ref (__temp1479)));
		__temp1480 = NULL;
		params = (__temp1480 = vala_invokable_get_parameters (i), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), __temp1480);
		if (VALA_IS_METHOD (i)) {
			ValaMethod* __temp1482;
			ValaMethod* __temp1481;
			__temp1482 = NULL;
			__temp1481 = NULL;
			m = (__temp1482 = (__temp1481 = VALA_METHOD (i), (__temp1481 == NULL ? NULL : g_object_ref (__temp1481))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), __temp1482);
		} else {
			if (VALA_IS_SIGNAL (i)) {
				ValaCCodeFunctionCall* __temp1484;
				ValaCCodeFunctionCall* __temp1483;
				__temp1484 = NULL;
				__temp1483 = NULL;
				ccall = (__temp1484 = (__temp1483 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_invocation_expression_get_call (expr)))), (__temp1483 == NULL ? NULL : g_object_ref (__temp1483))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1484);
			}
		}
		(i == NULL ? NULL : (i = (g_object_unref (i), NULL)));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArray* __temp1485;
		ValaArray* array;
		ValaCCodeIdentifier* __temp1487;
		char* __temp1486;
		__temp1485 = NULL;
		array = (__temp1485 = VALA_ARRAY (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1485 == NULL ? NULL : g_object_ref (__temp1485)));
		__temp1487 = NULL;
		__temp1486 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1487 = vala_ccode_identifier_new ((__temp1486 = vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE))))));
		(__temp1487 == NULL ? NULL : (__temp1487 = (g_object_unref (__temp1487), NULL)));
		(__temp1486 = (g_free (__temp1486), NULL));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			self->priv->requires_array_move = TRUE;
		}
	}
	/* explicitly use strong reference as ccall gets unrefed
	 * at end of inner block
	 */
	instance = NULL;
	if (m != NULL && vala_method_get_instance (m)) {
		ValaMethod* __temp1488;
		ValaMethod* base_method;
		gboolean req_cast;
		__temp1488 = NULL;
		base_method = (__temp1488 = m, (__temp1488 == NULL ? NULL : g_object_ref (__temp1488)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaMethod* __temp1490;
			ValaMethod* __temp1489;
			__temp1490 = NULL;
			__temp1489 = NULL;
			base_method = (__temp1490 = (__temp1489 = vala_method_get_base_interface_method (m), (__temp1489 == NULL ? NULL : g_object_ref (__temp1489))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp1490);
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* __temp1492;
				ValaMethod* __temp1491;
				__temp1492 = NULL;
				__temp1491 = NULL;
				base_method = (__temp1492 = (__temp1491 = vala_method_get_base_method (m), (__temp1491 == NULL ? NULL : g_object_ref (__temp1491))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp1492);
			}
		}
		req_cast = FALSE;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* __temp1493;
			__temp1493 = NULL;
			instance = (__temp1493 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1493);
			/* require casts for overriden and inherited methods */
			req_cast = vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL || (vala_symbol_get_parent_symbol (((ValaSymbol*) m)) != self->priv->current_type_symbol);
		} else {
			ValaCCodeExpression* __temp1495;
			ValaCCodeExpression* __temp1494;
			__temp1495 = NULL;
			__temp1494 = NULL;
			instance = (__temp1495 = (__temp1494 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (__temp1494 == NULL ? NULL : g_object_ref (__temp1494))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1495);
			/* reqiure casts if the type of the used instance is
			 * different than the type which declared the method */
			req_cast = vala_symbol_get_parent_symbol (((ValaSymbol*) base_method)) != VALA_SYMBOL (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
		}
		if (vala_method_get_instance_by_reference (m) && (vala_member_access_get_inner (ma) != NULL || vala_symbol_get_parent_symbol (((ValaSymbol*) m)) != self->priv->current_type_symbol)) {
			ValaCCodeExpression* __temp1496;
			__temp1496 = NULL;
			instance = (__temp1496 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1496);
		}
		if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))))) {
			ValaCCodeIdentifier* __temp1498;
			char* __temp1497;
			ValaCCodeFunctionCall* __temp1499;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* __temp1501;
			ValaCCodeFunctionCall* __temp1500;
			/* FIXME: use C cast if debugging disabled*/
			__temp1498 = NULL;
			__temp1497 = NULL;
			__temp1499 = NULL;
			ccall = (__temp1499 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1498 = vala_ccode_identifier_new ((__temp1497 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_method)))), NULL)))))), (__temp1498 == NULL ? NULL : (__temp1498 = (g_object_unref (__temp1498), NULL))), (__temp1497 = (g_free (__temp1497), NULL)), __temp1499);
			vala_ccode_function_call_add_argument (ccall, instance);
			__temp1501 = NULL;
			__temp1500 = NULL;
			instance = (__temp1501 = VALA_CCODE_EXPRESSION ((__temp1500 = ccall, (__temp1500 == NULL ? NULL : g_object_ref (__temp1500)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1501);
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_call_add_argument (ccall, instance);
		}
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArray* __temp1502;
		ValaArray* array;
		ValaCCodeIdentifier* __temp1503;
		ValaCCodeFunctionCall* __temp1504;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* __temp1506;
		char* __temp1505;
		__temp1502 = NULL;
		array = (__temp1502 = VALA_ARRAY (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1502 == NULL ? NULL : g_object_ref (__temp1502)));
		__temp1503 = NULL;
		__temp1504 = NULL;
		csizeof = (__temp1504 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1503 = vala_ccode_identifier_new ("sizeof")))), (__temp1503 == NULL ? NULL : (__temp1503 = (g_object_unref (__temp1503), NULL))), __temp1504);
		__temp1506 = NULL;
		__temp1505 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((__temp1506 = vala_ccode_identifier_new ((__temp1505 = vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE))))));
		(__temp1506 == NULL ? NULL : (__temp1506 = (g_object_unref (__temp1506), NULL)));
		(__temp1505 = (g_free (__temp1505), NULL));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (csizeof));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	}
	ellipsis = FALSE;
	i = 1;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeCollection* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			arg = gee_iterator_get (arg_it);
			{
				ValaCCodeExpression* __temp1507;
				ValaCCodeExpression* cexpr;
				/* explicitly use strong reference as ccall gets
				 * unrefed at end of inner block
				 */
				__temp1507 = NULL;
				cexpr = (__temp1507 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) arg))), (__temp1507 == NULL ? NULL : g_object_ref (__temp1507)));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = gee_iterator_get (params_it);
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL) {
							if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaArray* __temp1508;
								ValaArray* arr;
								__temp1508 = NULL;
								arr = (__temp1508 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1508 == NULL ? NULL : g_object_ref (__temp1508)));
								{
									gint dim;
									dim = 0;
									for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
										ValaCCodeExpression* __temp1509;
										__temp1509 = NULL;
										vala_ccode_function_call_add_argument (ccall, (__temp1509 = vala_code_generator_get_array_length_cexpression (self, arg, dim)));
										(__temp1509 = (g_object_unref (__temp1509), NULL));
									}
								}
								(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
							}
							if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeIdentifier* __temp1511;
								char* __temp1510;
								ValaCCodeFunctionCall* __temp1512;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* __temp1514;
								ValaCCodeFunctionCall* __temp1513;
								/* FIXME: use C cast if debugging disabled*/
								__temp1511 = NULL;
								__temp1510 = NULL;
								__temp1512 = NULL;
								ccall = (__temp1512 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1511 = vala_ccode_identifier_new ((__temp1510 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL)))))), (__temp1511 == NULL ? NULL : (__temp1511 = (g_object_unref (__temp1511), NULL))), (__temp1510 = (g_free (__temp1510), NULL)), __temp1512);
								vala_ccode_function_call_add_argument (ccall, cexpr);
								__temp1514 = NULL;
								__temp1513 = NULL;
								cexpr = (__temp1514 = VALA_CCODE_EXPRESSION ((__temp1513 = ccall, (__temp1513 == NULL ? NULL : g_object_ref (__temp1513)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1514);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
						} else {
							if (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaCCodeExpression* __temp1516;
								char* __temp1515;
								__temp1516 = NULL;
								__temp1515 = NULL;
								cexpr = (__temp1516 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, (__temp1515 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), FALSE)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1516);
								(__temp1515 = (g_free (__temp1515), NULL));
							} else {
								if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg)))) {
									ValaCCodeExpression* __temp1517;
									__temp1517 = NULL;
									cexpr = (__temp1517 = vala_code_generator_convert_to_generic_pointer (self, cexpr, vala_expression_get_static_type (arg)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1517);
								}
							}
						}
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
				vala_ccode_function_call_add_argument (ccall, cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = gee_iterator_get (params_it);
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* __temp1518;
			__temp1518 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), (__temp1518 = g_strdup_printf ("no default expression for argument %d", i)));
			(__temp1518 = (g_free (__temp1518), NULL));
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
			ValaArray* __temp1519;
			ValaArray* arr;
			__temp1519 = NULL;
			arr = (__temp1519 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1519 == NULL ? NULL : g_object_ref (__temp1519)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* __temp1520;
					__temp1520 = NULL;
					vala_ccode_function_call_add_argument (ccall, (__temp1520 = vala_code_generator_get_array_length_cexpression (self, vala_formal_parameter_get_default_expression (param), dim)));
					(__temp1520 = (g_object_unref (__temp1520), NULL));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
		ValaArray* __temp1521;
		ValaArray* arr;
		__temp1521 = NULL;
		arr = (__temp1521 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (__temp1521 == NULL ? NULL : g_object_ref (__temp1521)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaVariableDeclarator* temp_decl;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* __temp1522;
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
					gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
					__temp1522 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1522 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(__temp1522 == NULL ? NULL : (__temp1522 = (g_object_unref (__temp1522), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* __temp1523;
					__temp1523 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((__temp1523 = vala_ccode_constant_new ("-1"))));
					(__temp1523 == NULL ? NULL : (__temp1523 = (g_object_unref (__temp1523), NULL)));
				}
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (vala_expression_get_can_fail (((ValaExpression*) expr))) {
		ValaCCodeUnaryExpression* __temp1525;
		ValaCCodeIdentifier* __temp1524;
		/* method can fail*/
		self->priv->current_method_inner_error = TRUE;
		__temp1525 = NULL;
		__temp1524 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1525 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp1524 = vala_ccode_identifier_new ("inner_error")))))));
		(__temp1525 == NULL ? NULL : (__temp1525 = (g_object_unref (__temp1525), NULL)));
		(__temp1524 == NULL ? NULL : (__temp1524 = (g_object_unref (__temp1524), NULL)));
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_call_add_argument (ccall, instance);
	} else {
		if (ellipsis) {
			/* ensure variable argument list ends with NULL
			 * except when using printf-style arguments */
			if (m == NULL || !vala_method_get_printf_format (m)) {
				ValaCCodeConstant* __temp1526;
				__temp1526 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1526 = vala_ccode_constant_new ("NULL"))));
				(__temp1526 == NULL ? NULL : (__temp1526 = (g_object_unref (__temp1526), NULL)));
			}
		}
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* __temp1527;
		__temp1527 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1527 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1527 == NULL ? NULL : (__temp1527 = (g_object_unref (__temp1527), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_type_reference_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (((ValaExpression*) expr))) != NULL) {
			ValaCCodeExpression* __temp1528;
			__temp1528 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1528 = vala_code_generator_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (ccall), vala_expression_get_static_type (((ValaExpression*) expr))))));
			(__temp1528 = (g_object_unref (__temp1528), NULL));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
		}
		vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeCollection* __temp1529;
		GeeIterator* __temp1530;
		GeeIterator* arg_it;
		ValaCCodeExpression* __temp1532;
		ValaExpression* __temp1531;
		ValaCCodeExpression* __temp1533;
		ValaCCodeExpression* new_size;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* __temp1534;
		ValaCCodeExpression* celems;
		char* __temp1536;
		char* __temp1535;
		ValaCCodeIdentifier* __temp1537;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* __temp1538;
		ValaCCodeParenthesizedExpression* __temp1539;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* __temp1540;
		ValaCCodeFunctionCall* __temp1541;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* __temp1542;
		ValaCCodeConstant* __temp1543;
		ValaCCodeBinaryExpression* __temp1544;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* __temp1545;
		ValaCCodeConditionalExpression* __temp1547;
		ValaCCodeConstant* __temp1546;
		ValaCCodeAssignment* __temp1549;
		ValaCCodeExpression* __temp1548;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		__temp1529 = NULL;
		__temp1530 = NULL;
		arg_it = (__temp1530 = gee_iterable_iterator (GEE_ITERABLE ((__temp1529 = vala_invocation_expression_get_argument_list (expr)))), (__temp1529 == NULL ? NULL : (__temp1529 = (g_object_unref (__temp1529), NULL))), __temp1530);
		gee_iterator_next (arg_it);
		__temp1532 = NULL;
		__temp1531 = NULL;
		__temp1533 = NULL;
		new_size = (__temp1533 = (__temp1532 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (__temp1531 = gee_iterator_get (arg_it))))), (__temp1532 == NULL ? NULL : g_object_ref (__temp1532))), (__temp1531 == NULL ? NULL : (__temp1531 = (g_object_unref (__temp1531), NULL))), __temp1533);
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		self->priv->string_h_needed = TRUE;
		clen = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1);
		__temp1534 = NULL;
		celems = (__temp1534 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (__temp1534 == NULL ? NULL : g_object_ref (__temp1534)));
		__temp1536 = NULL;
		__temp1535 = NULL;
		__temp1537 = NULL;
		csizeof = (__temp1537 = vala_ccode_identifier_new ((__temp1536 = g_strdup_printf ("sizeof (%s)", (__temp1535 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), FALSE))))), (__temp1536 = (g_free (__temp1536), NULL)), (__temp1535 = (g_free (__temp1535), NULL)), __temp1537);
		__temp1538 = NULL;
		__temp1539 = NULL;
		cdelta = (__temp1539 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((__temp1538 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (__temp1538 == NULL ? NULL : (__temp1538 = (g_object_unref (__temp1538), NULL))), __temp1539);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		__temp1540 = NULL;
		__temp1541 = NULL;
		czero = (__temp1541 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1540 = vala_ccode_identifier_new ("memset")))), (__temp1540 == NULL ? NULL : (__temp1540 = (g_object_unref (__temp1540), NULL))), __temp1541);
		__temp1542 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp1542 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(__temp1542 == NULL ? NULL : (__temp1542 = (g_object_unref (__temp1542), NULL)));
		__temp1543 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp1543 = vala_ccode_constant_new ("0"))));
		(__temp1543 == NULL ? NULL : (__temp1543 = (g_object_unref (__temp1543), NULL)));
		__temp1544 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp1544 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(__temp1544 == NULL ? NULL : (__temp1544 = (g_object_unref (__temp1544), NULL)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		__temp1545 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1545 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1545 == NULL ? NULL : (__temp1545 = (g_object_unref (__temp1545), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
		__temp1547 = NULL;
		__temp1546 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1547 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((__temp1546 = vala_ccode_constant_new ("NULL")))))));
		(__temp1547 == NULL ? NULL : (__temp1547 = (g_object_unref (__temp1547), NULL)));
		(__temp1546 == NULL ? NULL : (__temp1546 = (g_object_unref (__temp1546), NULL)));
		__temp1549 = NULL;
		__temp1548 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1549 = vala_ccode_assignment_new ((__temp1548 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1549 == NULL ? NULL : (__temp1549 = (g_object_unref (__temp1549), NULL)));
		(__temp1548 = (g_object_unref (__temp1548), NULL));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen = (g_object_unref (clen), NULL));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == self->priv->substring_method) {
			ValaVariableDeclarator* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* __temp1550;
			ValaCCodeFunctionCall* __temp1551;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* __temp1552;
			ValaCCodeExpression* __temp1553;
			ValaCCodeIdentifier* __temp1554;
			ValaCCodeFunctionCall* __temp1555;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* __temp1556;
			ValaCCodeIdentifier* __temp1557;
			ValaCCodeFunctionCall* __temp1558;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* __temp1559;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* __temp1560;
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->string_type, TRUE);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
			gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			__temp1550 = NULL;
			__temp1551 = NULL;
			coffsetcall = (__temp1551 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1550 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (__temp1550 == NULL ? NULL : (__temp1550 = (g_object_unref (__temp1550), NULL))), __temp1551);
			/* full string*/
			__temp1552 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (__temp1552 = gee_list_get (((GeeList*) args), 0)));
			(__temp1552 == NULL ? NULL : (__temp1552 = (g_object_unref (__temp1552), NULL)));
			/* offset*/
			__temp1553 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (__temp1553 = gee_list_get (((GeeList*) args), 1)));
			(__temp1553 == NULL ? NULL : (__temp1553 = (g_object_unref (__temp1553), NULL)));
			__temp1554 = NULL;
			__temp1555 = NULL;
			coffsetcall2 = (__temp1555 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1554 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (__temp1554 == NULL ? NULL : (__temp1554 = (g_object_unref (__temp1554), NULL))), __temp1555);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			__temp1556 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (__temp1556 = gee_list_get (((GeeList*) args), 2)));
			(__temp1556 == NULL ? NULL : (__temp1556 = (g_object_unref (__temp1556), NULL)));
			__temp1557 = NULL;
			__temp1558 = NULL;
			cndupcall = (__temp1558 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1557 = vala_ccode_identifier_new ("g_strndup")))), (__temp1557 == NULL ? NULL : (__temp1557 = (g_object_unref (__temp1557), NULL))), __temp1558);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			__temp1559 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((__temp1559 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(__temp1559 == NULL ? NULL : (__temp1559 = (g_object_unref (__temp1559), NULL)));
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			__temp1560 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1560 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp1560 == NULL ? NULL : (__temp1560 = (g_object_unref (__temp1560), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
		ValaMethod* __temp1561;
		ValaMethod* m;
		__temp1561 = NULL;
		m = (__temp1561 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1561 == NULL ? NULL : g_object_ref (__temp1561)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaInterface* __temp1562;
				ValaInterface* base_iface;
				char* __temp1564;
				char* __temp1563;
				char* __temp1565;
				char* parent_iface_var;
				ValaCCodeMemberAccess* __temp1567;
				ValaCCodeIdentifier* __temp1566;
				__temp1562 = NULL;
				base_iface = (__temp1562 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_interface_method (m)))), (__temp1562 == NULL ? NULL : g_object_ref (__temp1562)));
				__temp1564 = NULL;
				__temp1563 = NULL;
				__temp1565 = NULL;
				parent_iface_var = (__temp1565 = g_strdup_printf ("%s_%s_parent_iface", (__temp1563 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->current_class), NULL)), (__temp1564 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_iface), NULL))), (__temp1564 = (g_free (__temp1564), NULL)), (__temp1563 = (g_free (__temp1563), NULL)), __temp1565);
				__temp1567 = NULL;
				__temp1566 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1567 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1566 = vala_ccode_identifier_new (parent_iface_var))), vala_symbol_get_name (((ValaSymbol*) m))))));
				(__temp1567 == NULL ? NULL : (__temp1567 = (g_object_unref (__temp1567), NULL)));
				(__temp1566 == NULL ? NULL : (__temp1566 = (g_object_unref (__temp1566), NULL)));
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
			} else {
				if (vala_method_get_base_method (m) != NULL) {
					ValaClass* __temp1568;
					ValaClass* base_class;
					ValaCCodeIdentifier* __temp1571;
					char* __temp1570;
					char* __temp1569;
					ValaCCodeFunctionCall* __temp1572;
					ValaCCodeFunctionCall* vcast;
					ValaCCodeIdentifier* __temp1575;
					char* __temp1574;
					char* __temp1573;
					ValaCCodeMemberAccess* __temp1576;
					__temp1568 = NULL;
					base_class = (__temp1568 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_method (m)))), (__temp1568 == NULL ? NULL : g_object_ref (__temp1568)));
					__temp1571 = NULL;
					__temp1570 = NULL;
					__temp1569 = NULL;
					__temp1572 = NULL;
					vcast = (__temp1572 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1571 = vala_ccode_identifier_new ((__temp1570 = g_strdup_printf ("%s_CLASS", (__temp1569 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (base_class), NULL)))))))), (__temp1571 == NULL ? NULL : (__temp1571 = (g_object_unref (__temp1571), NULL))), (__temp1570 = (g_free (__temp1570), NULL)), (__temp1569 = (g_free (__temp1569), NULL)), __temp1572);
					__temp1575 = NULL;
					__temp1574 = NULL;
					__temp1573 = NULL;
					vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp1575 = vala_ccode_identifier_new ((__temp1574 = g_strdup_printf ("%s_parent_class", (__temp1573 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->current_class), NULL))))))));
					(__temp1575 == NULL ? NULL : (__temp1575 = (g_object_unref (__temp1575), NULL)));
					(__temp1574 = (g_free (__temp1574), NULL));
					(__temp1573 = (g_free (__temp1573), NULL));
					__temp1576 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1576 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_symbol_get_name (((ValaSymbol*) m))))));
					(__temp1576 == NULL ? NULL : (__temp1576 = (g_object_unref (__temp1576), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				}
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaCCodeIdentifier* __temp1578;
			char* __temp1577;
			__temp1578 = NULL;
			__temp1577 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1578 = vala_ccode_identifier_new ((__temp1577 = vala_method_get_cname (vala_method_get_base_interface_method (m)))))));
			(__temp1578 == NULL ? NULL : (__temp1578 = (g_object_unref (__temp1578), NULL)));
			(__temp1577 = (g_free (__temp1577), NULL));
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaCCodeIdentifier* __temp1580;
				char* __temp1579;
				__temp1580 = NULL;
				__temp1579 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1580 = vala_ccode_identifier_new ((__temp1579 = vala_method_get_cname (vala_method_get_base_method (m)))))));
				(__temp1580 == NULL ? NULL : (__temp1580 = (g_object_unref (__temp1580), NULL)));
				(__temp1579 = (g_free (__temp1579), NULL));
			} else {
				ValaCCodeIdentifier* __temp1582;
				char* __temp1581;
				__temp1582 = NULL;
				__temp1581 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1582 = vala_ccode_identifier_new ((__temp1581 = vala_method_get_cname (m))))));
				(__temp1582 == NULL ? NULL : (__temp1582 = (g_object_unref (__temp1582), NULL)));
				(__temp1581 = (g_free (__temp1581), NULL));
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
			ValaCCodeExpression* __temp1583;
			__temp1583 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1583 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (expr), 1))));
			(__temp1583 = (g_object_unref (__temp1583), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
				ValaField* __temp1584;
				ValaField* f;
				__temp1584 = NULL;
				f = (__temp1584 = VALA_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1584 == NULL ? NULL : g_object_ref (__temp1584)));
				if (vala_field_get_instance (f)) {
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* inst;
					typed_inst = NULL;
					if (vala_symbol_get_parent_symbol (((ValaSymbol*) f)) != VALA_SYMBOL (base_type)) {
						if (vala_code_context_get_debug (self->priv->context)) {
							ValaCCodeExpression* __temp1587;
							ValaCCodeIdentifier* __temp1586;
							char* __temp1585;
							__temp1587 = NULL;
							__temp1586 = NULL;
							__temp1585 = NULL;
							typed_inst = (__temp1587 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1586 = vala_ccode_identifier_new ((__temp1585 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))), NULL))))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1587);
							(__temp1586 == NULL ? NULL : (__temp1586 = (g_object_unref (__temp1586), NULL)));
							(__temp1585 = (g_free (__temp1585), NULL));
							vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
						} else {
							ValaCCodeExpression* __temp1590;
							char* __temp1589;
							char* __temp1588;
							__temp1590 = NULL;
							__temp1589 = NULL;
							__temp1588 = NULL;
							typed_inst = (__temp1590 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (pub_inst, (__temp1589 = g_strconcat ((__temp1588 = vala_data_type_get_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))), FALSE)), "*", NULL)))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1590);
							(__temp1589 = (g_free (__temp1589), NULL));
							(__temp1588 = (g_free (__temp1588), NULL));
						}
					} else {
						ValaCCodeExpression* __temp1592;
						ValaCCodeExpression* __temp1591;
						__temp1592 = NULL;
						__temp1591 = NULL;
						typed_inst = (__temp1592 = (__temp1591 = pub_inst, (__temp1591 == NULL ? NULL : g_object_ref (__temp1591))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1592);
					}
					inst = NULL;
					if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* __temp1593;
						__temp1593 = NULL;
						inst = (__temp1593 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp1593);
					} else {
						ValaCCodeExpression* __temp1595;
						ValaCCodeExpression* __temp1594;
						__temp1595 = NULL;
						__temp1594 = NULL;
						inst = (__temp1595 = (__temp1594 = typed_inst, (__temp1594 == NULL ? NULL : g_object_ref (__temp1594))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp1595);
					}
					if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))))) {
						ValaCCodeMemberAccess* __temp1597;
						char* __temp1596;
						__temp1597 = NULL;
						__temp1596 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1597 = vala_ccode_member_access_new_pointer (inst, (__temp1596 = vala_field_get_cname (f))))));
						(__temp1597 == NULL ? NULL : (__temp1597 = (g_object_unref (__temp1597), NULL)));
						(__temp1596 = (g_free (__temp1596), NULL));
					} else {
						ValaCCodeMemberAccess* __temp1599;
						char* __temp1598;
						__temp1599 = NULL;
						__temp1598 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1599 = vala_ccode_member_access_new (inst, (__temp1598 = vala_field_get_cname (f)), FALSE))));
						(__temp1599 == NULL ? NULL : (__temp1599 = (g_object_unref (__temp1599), NULL)));
						(__temp1598 = (g_free (__temp1598), NULL));
					}
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* __temp1601;
					char* __temp1600;
					__temp1601 = NULL;
					__temp1600 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1601 = vala_ccode_identifier_new ((__temp1600 = vala_field_get_cname (f))))));
					(__temp1601 == NULL ? NULL : (__temp1601 = (g_object_unref (__temp1601), NULL)));
					(__temp1600 = (g_free (__temp1600), NULL));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
					ValaConstant* __temp1602;
					ValaConstant* c;
					ValaCCodeIdentifier* __temp1604;
					char* __temp1603;
					__temp1602 = NULL;
					c = (__temp1602 = VALA_CONSTANT (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1602 == NULL ? NULL : g_object_ref (__temp1602)));
					__temp1604 = NULL;
					__temp1603 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1604 = vala_ccode_identifier_new ((__temp1603 = vala_constant_get_cname (c))))));
					(__temp1604 == NULL ? NULL : (__temp1604 = (g_object_unref (__temp1604), NULL)));
					(__temp1603 = (g_free (__temp1603), NULL));
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
						ValaProperty* __temp1605;
						ValaProperty* prop;
						__temp1605 = NULL;
						prop = (__temp1605 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1605 == NULL ? NULL : g_object_ref (__temp1605)));
						if (!vala_property_get_no_accessor_method (prop)) {
							ValaProperty* __temp1606;
							ValaProperty* base_property;
							ValaDataType* __temp1611;
							ValaDataType* base_property_type;
							ValaCCodeIdentifier* __temp1614;
							char* __temp1613;
							char* __temp1612;
							ValaCCodeFunctionCall* __temp1615;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeExpression* __temp1616;
							ValaCCodeExpression* typed_pub_inst;
							__temp1606 = NULL;
							base_property = (__temp1606 = prop, (__temp1606 == NULL ? NULL : g_object_ref (__temp1606)));
							if (vala_property_get_base_property (prop) != NULL) {
								ValaProperty* __temp1608;
								ValaProperty* __temp1607;
								__temp1608 = NULL;
								__temp1607 = NULL;
								base_property = (__temp1608 = (__temp1607 = vala_property_get_base_property (prop), (__temp1607 == NULL ? NULL : g_object_ref (__temp1607))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp1608);
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaProperty* __temp1610;
									ValaProperty* __temp1609;
									__temp1610 = NULL;
									__temp1609 = NULL;
									base_property = (__temp1610 = (__temp1609 = vala_property_get_base_interface_property (prop), (__temp1609 == NULL ? NULL : g_object_ref (__temp1609))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp1610);
								}
							}
							__temp1611 = NULL;
							base_property_type = (__temp1611 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property))), (__temp1611 == NULL ? NULL : g_object_ref (__temp1611)));
							__temp1614 = NULL;
							__temp1613 = NULL;
							__temp1612 = NULL;
							__temp1615 = NULL;
							ccall = (__temp1615 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1614 = vala_ccode_identifier_new ((__temp1613 = g_strdup_printf ("%s_get_%s", (__temp1612 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (((ValaSymbol*) base_property)))))))), (__temp1614 == NULL ? NULL : (__temp1614 = (g_object_unref (__temp1614), NULL))), (__temp1613 = (g_free (__temp1613), NULL)), (__temp1612 = (g_free (__temp1612), NULL)), __temp1615);
							__temp1616 = NULL;
							typed_pub_inst = (__temp1616 = pub_inst, (__temp1616 == NULL ? NULL : g_object_ref (__temp1616)));
							/* cast if necessary */
							if (base_property_type != base_type) {
								if (vala_code_context_get_debug (self->priv->context)) {
									ValaCCodeIdentifier* __temp1618;
									char* __temp1617;
									ValaCCodeFunctionCall* __temp1619;
									ValaCCodeFunctionCall* ccast;
									ValaCCodeExpression* __temp1621;
									ValaCCodeFunctionCall* __temp1620;
									__temp1618 = NULL;
									__temp1617 = NULL;
									__temp1619 = NULL;
									ccast = (__temp1619 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1618 = vala_ccode_identifier_new ((__temp1617 = vala_data_type_get_upper_case_cname (base_property_type, NULL)))))), (__temp1618 == NULL ? NULL : (__temp1618 = (g_object_unref (__temp1618), NULL))), (__temp1617 = (g_free (__temp1617), NULL)), __temp1619);
									vala_ccode_function_call_add_argument (ccast, pub_inst);
									__temp1621 = NULL;
									__temp1620 = NULL;
									typed_pub_inst = (__temp1621 = VALA_CCODE_EXPRESSION ((__temp1620 = ccast, (__temp1620 == NULL ? NULL : g_object_ref (__temp1620)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp1621);
									(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
								} else {
									ValaCCodeExpression* __temp1624;
									char* __temp1623;
									char* __temp1622;
									__temp1624 = NULL;
									__temp1623 = NULL;
									__temp1622 = NULL;
									typed_pub_inst = (__temp1624 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (pub_inst, (__temp1623 = g_strconcat ((__temp1622 = vala_data_type_get_cname (base_property_type, FALSE)), "*", NULL)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp1624);
									(__temp1623 = (g_free (__temp1623), NULL));
									(__temp1622 = (g_free (__temp1622), NULL));
								}
							}
							vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
							(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
							(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
						} else {
							ValaCCodeIdentifier* __temp1625;
							ValaCCodeFunctionCall* __temp1626;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* __temp1627;
							ValaCCodeFunctionCall* __temp1628;
							ValaCCodeFunctionCall* ccast;
							ValaCCodeConstant* __temp1629;
							ValaVariableDeclarator* temp_decl;
							ValaCCodeIdentifier* ctemp;
							ValaCCodeUnaryExpression* __temp1630;
							ValaCCodeConstant* __temp1631;
							ValaCCodeCommaExpression* ccomma;
							__temp1625 = NULL;
							__temp1626 = NULL;
							ccall = (__temp1626 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1625 = vala_ccode_identifier_new ("g_object_get")))), (__temp1625 == NULL ? NULL : (__temp1625 = (g_object_unref (__temp1625), NULL))), __temp1626);
							__temp1627 = NULL;
							__temp1628 = NULL;
							ccast = (__temp1628 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1627 = vala_ccode_identifier_new ("G_OBJECT")))), (__temp1627 == NULL ? NULL : (__temp1627 = (g_object_unref (__temp1627), NULL))), __temp1628);
							vala_ccode_function_call_add_argument (ccast, pub_inst);
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
							/* property name is second argument of g_object_get*/
							__temp1629 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1629 = vala_property_get_canonical_cconstant (prop))));
							(__temp1629 = (g_object_unref (__temp1629), NULL));
							/* we need a temporary variable to save the property value*/
							temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (((ValaExpression*) expr)), TRUE);
							gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
							ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
							__temp1630 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1630 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
							(__temp1630 == NULL ? NULL : (__temp1630 = (g_object_unref (__temp1630), NULL)));
							__temp1631 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1631 = vala_ccode_constant_new ("NULL"))));
							(__temp1631 == NULL ? NULL : (__temp1631 = (g_object_unref (__temp1631), NULL)));
							ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
							(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
							ValaEnumValue* __temp1632;
							ValaEnumValue* ev;
							ValaCCodeConstant* __temp1634;
							char* __temp1633;
							__temp1632 = NULL;
							ev = (__temp1632 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1632 == NULL ? NULL : g_object_ref (__temp1632)));
							__temp1634 = NULL;
							__temp1633 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1634 = vala_ccode_constant_new ((__temp1633 = vala_enum_value_get_cname (ev))))));
							(__temp1634 == NULL ? NULL : (__temp1634 = (g_object_unref (__temp1634), NULL)));
							(__temp1633 = (g_free (__temp1633), NULL));
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
								ValaVariableDeclarator* __temp1635;
								ValaVariableDeclarator* decl;
								ValaCCodeIdentifier* __temp1637;
								char* __temp1636;
								__temp1635 = NULL;
								decl = (__temp1635 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1635 == NULL ? NULL : g_object_ref (__temp1635)));
								__temp1637 = NULL;
								__temp1636 = NULL;
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1637 = vala_ccode_identifier_new ((__temp1636 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))));
								(__temp1637 == NULL ? NULL : (__temp1637 = (g_object_unref (__temp1637), NULL)));
								(__temp1636 = (g_free (__temp1636), NULL));
								(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
									ValaFormalParameter* __temp1638;
									ValaFormalParameter* p;
									__temp1638 = NULL;
									p = (__temp1638 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1638 == NULL ? NULL : g_object_ref (__temp1638)));
									if (g_utf8_collate (vala_symbol_get_name (((ValaSymbol*) p)), "this") == 0) {
										vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst));
									} else {
										if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (p)) || vala_type_reference_get_is_ref (vala_formal_parameter_get_type_reference (p))) {
											ValaCCodeIdentifier* __temp1640;
											char* __temp1639;
											__temp1640 = NULL;
											__temp1639 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1640 = vala_ccode_identifier_new ((__temp1639 = g_strdup_printf ("(*%s)", vala_symbol_get_name (((ValaSymbol*) p))))))));
											(__temp1640 == NULL ? NULL : (__temp1640 = (g_object_unref (__temp1640), NULL)));
											(__temp1639 = (g_free (__temp1639), NULL));
										} else {
											ValaCCodeIdentifier* __temp1641;
											__temp1641 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1641 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) p))))));
											(__temp1641 == NULL ? NULL : (__temp1641 = (g_object_unref (__temp1641), NULL)));
										}
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
										ValaSignal* __temp1642;
										ValaSignal* sig;
										ValaDataType* __temp1643;
										ValaDataType* cl;
										__temp1642 = NULL;
										sig = (__temp1642 = VALA_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (__temp1642 == NULL ? NULL : g_object_ref (__temp1642)));
										__temp1643 = NULL;
										cl = (__temp1643 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) sig))), (__temp1643 == NULL ? NULL : g_object_ref (__temp1643)));
										if (vala_signal_get_has_emitter (sig)) {
											ValaCCodeIdentifier* __temp1646;
											char* __temp1645;
											char* __temp1644;
											ValaCCodeFunctionCall* __temp1647;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeExpression* __temp1648;
											ValaCCodeExpression* typed_pub_inst;
											__temp1646 = NULL;
											__temp1645 = NULL;
											__temp1644 = NULL;
											__temp1647 = NULL;
											ccall = (__temp1647 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1646 = vala_ccode_identifier_new ((__temp1645 = g_strdup_printf ("%s_%s", (__temp1644 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (((ValaSymbol*) sig)))))))), (__temp1646 == NULL ? NULL : (__temp1646 = (g_object_unref (__temp1646), NULL))), (__temp1645 = (g_free (__temp1645), NULL)), (__temp1644 = (g_free (__temp1644), NULL)), __temp1647);
											/* explicitly use strong reference as ccast
											 * gets unrefed at the end of the inner block
											 */
											__temp1648 = NULL;
											typed_pub_inst = (__temp1648 = pub_inst, (__temp1648 == NULL ? NULL : g_object_ref (__temp1648)));
											/* cast if necessary */
											if (cl != base_type) {
												ValaCCodeIdentifier* __temp1650;
												char* __temp1649;
												ValaCCodeFunctionCall* __temp1651;
												ValaCCodeFunctionCall* ccast;
												ValaCCodeExpression* __temp1653;
												ValaCCodeFunctionCall* __temp1652;
												/* FIXME: use C cast if debugging disabled*/
												__temp1650 = NULL;
												__temp1649 = NULL;
												__temp1651 = NULL;
												ccast = (__temp1651 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1650 = vala_ccode_identifier_new ((__temp1649 = vala_data_type_get_upper_case_cname (cl, NULL)))))), (__temp1650 == NULL ? NULL : (__temp1650 = (g_object_unref (__temp1650), NULL))), (__temp1649 = (g_free (__temp1649), NULL)), __temp1651);
												vala_ccode_function_call_add_argument (ccast, pub_inst);
												__temp1653 = NULL;
												__temp1652 = NULL;
												typed_pub_inst = (__temp1653 = VALA_CCODE_EXPRESSION ((__temp1652 = ccast, (__temp1652 == NULL ? NULL : g_object_ref (__temp1652)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp1653);
												(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
											}
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeIdentifier* __temp1654;
											ValaCCodeFunctionCall* __temp1655;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeIdentifier* __temp1656;
											ValaCCodeFunctionCall* __temp1657;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* __temp1658;
											__temp1654 = NULL;
											__temp1655 = NULL;
											ccall = (__temp1655 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1654 = vala_ccode_identifier_new ("g_signal_emit_by_name")))), (__temp1654 == NULL ? NULL : (__temp1654 = (g_object_unref (__temp1654), NULL))), __temp1655);
											/* FIXME: use C cast if debugging disabled*/
											__temp1656 = NULL;
											__temp1657 = NULL;
											ccast = (__temp1657 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1656 = vala_ccode_identifier_new ("G_OBJECT")))), (__temp1656 == NULL ? NULL : (__temp1656 = (g_object_unref (__temp1656), NULL))), __temp1657);
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											__temp1658 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1658 = vala_signal_get_canonical_cconstant (sig))));
											(__temp1658 = (g_object_unref (__temp1658), NULL));
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* __temp1659;
		__temp1659 = NULL;
		pub_inst = (__temp1659 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1659);
		if (self->priv->current_type_symbol != NULL) {
			ValaDataType* __temp1661;
			ValaDataType* __temp1660;
			/* base type is available if this is a type method */
			__temp1661 = NULL;
			__temp1660 = NULL;
			base_type = (__temp1661 = (__temp1660 = VALA_DATA_TYPE (self->priv->current_type_symbol), (__temp1660 == NULL ? NULL : g_object_ref (__temp1660))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1661);
			if (!vala_data_type_is_reference_type (base_type)) {
				ValaCCodeExpression* __temp1662;
				__temp1662 = NULL;
				pub_inst = (__temp1662 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1662);
			}
		}
	} else {
		ValaCCodeExpression* __temp1664;
		ValaCCodeExpression* __temp1663;
		__temp1664 = NULL;
		__temp1663 = NULL;
		pub_inst = (__temp1664 = (__temp1663 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (expr)))), (__temp1663 == NULL ? NULL : g_object_ref (__temp1663))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1664);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* __temp1666;
			ValaDataType* __temp1665;
			__temp1666 = NULL;
			__temp1665 = NULL;
			base_type = (__temp1666 = (__temp1665 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (expr))), (__temp1665 == NULL ? NULL : g_object_ref (__temp1665))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1666);
		}
	}
	vala_code_generator_process_cmember (self, expr, pub_inst, base_type);
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaCodeGenerator * self;
	ValaMethod* __temp1667;
	ValaMethod* old_method;
	ValaTypeReference* __temp1668;
	ValaTypeReference* old_return_type;
	gboolean old_method_inner_error;
	ValaSymbol* __temp1669;
	ValaMethod* __temp1670;
	ValaTypeReference* __temp1672;
	ValaTypeReference* __temp1671;
	gboolean inner_error;
	ValaSymbol* __temp1678;
	ValaSymbol* __temp1677;
	ValaMethod* __temp1680;
	ValaMethod* __temp1679;
	ValaTypeReference* __temp1682;
	ValaTypeReference* __temp1681;
	ValaCCodeFunction* __temp1686;
	char* __temp1685;
	char* __temp1684;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFormalParameter* instance_param;
	GeeCollection* params;
	GeeCollection* __temp1712;
	gboolean __temp1713;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_METHOD (m));
	__temp1667 = NULL;
	old_method = (__temp1667 = self->priv->current_method, (__temp1667 == NULL ? NULL : g_object_ref (__temp1667)));
	__temp1668 = NULL;
	old_return_type = (__temp1668 = self->priv->current_return_type, (__temp1668 == NULL ? NULL : g_object_ref (__temp1668)));
	old_method_inner_error = self->priv->current_method_inner_error;
	__temp1669 = NULL;
	self->priv->current_symbol = (__temp1669 = VALA_SYMBOL (g_object_ref (m)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp1669);
	__temp1670 = NULL;
	self->priv->current_method = (__temp1670 = g_object_ref (m), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), __temp1670);
	__temp1672 = NULL;
	__temp1671 = NULL;
	self->priv->current_return_type = (__temp1672 = (__temp1671 = vala_method_get_return_type (m), (__temp1671 == NULL ? NULL : g_object_ref (__temp1671))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp1672);
	self->priv->current_method_inner_error = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		self->priv->in_creation_method = TRUE;
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (VALA_IS_CLASS (self->priv->current_type_symbol) && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = gee_iterator_get (stmt_it);
					{
						ValaProperty* __temp1673;
						gboolean __temp1674;
						__temp1673 = NULL;
						if ((__temp1674 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((__temp1673 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (__temp1673 == NULL ? NULL : (__temp1673 = (g_object_unref (__temp1673), NULL))), __temp1674)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_generator_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0);
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = gee_iterator_get (stmt_it);
					{
						ValaProperty* __temp1675;
						gboolean __temp1676;
						__temp1675 = NULL;
						if ((__temp1676 = !vala_property_accessor_get_construction (vala_property_get_set_accessor ((__temp1675 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (__temp1675 == NULL ? NULL : (__temp1675 = (g_object_unref (__temp1675), NULL))), __temp1676)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		}
		self->priv->in_creation_method = FALSE;
	}
	inner_error = self->priv->current_method_inner_error;
	__temp1678 = NULL;
	__temp1677 = NULL;
	self->priv->current_symbol = (__temp1678 = (__temp1677 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp1677 == NULL ? NULL : g_object_ref (__temp1677))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp1678);
	__temp1680 = NULL;
	__temp1679 = NULL;
	self->priv->current_method = (__temp1680 = (__temp1679 = self->priv->current_method, (__temp1679 == NULL ? NULL : g_object_ref (__temp1679))), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), __temp1680);
	__temp1682 = NULL;
	__temp1681 = NULL;
	self->priv->current_return_type = (__temp1682 = (__temp1681 = old_return_type, (__temp1681 == NULL ? NULL : g_object_ref (__temp1681))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp1682);
	self->priv->current_method_inner_error = old_method_inner_error;
	if (self->priv->current_type_symbol != NULL && VALA_IS_INTERFACE (self->priv->current_type_symbol)) {
		ValaInterface* __temp1683;
		ValaInterface* iface;
		__temp1683 = NULL;
		iface = (__temp1683 = VALA_INTERFACE (self->priv->current_type_symbol), (__temp1683 == NULL ? NULL : g_object_ref (__temp1683)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	__temp1686 = NULL;
	__temp1685 = NULL;
	__temp1684 = NULL;
	self->priv->function = (__temp1686 = vala_ccode_function_new ((__temp1684 = vala_method_get_real_cname (m)), (__temp1685 = vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp1686);
	(__temp1685 = (g_free (__temp1685), NULL));
	(__temp1684 = (g_free (__temp1684), NULL));
	vdeclarator = NULL;
	instance_param = NULL;
	if (vala_method_get_instance (m)) {
		ValaTypeReference* this_type;
		ValaDataType* __temp1687;
		this_type = vala_type_reference_new ();
		__temp1687 = NULL;
		vala_type_reference_set_data_type (this_type, (__temp1687 = vala_code_generator_find_parent_type (self, VALA_SYMBOL (m))));
		(__temp1687 == NULL ? NULL : (__temp1687 = (g_object_unref (__temp1687), NULL)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaTypeReference* base_type;
			ValaCCodeFormalParameter* __temp1689;
			char* __temp1688;
			base_type = vala_type_reference_new ();
			vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_interface_method (m)))));
			__temp1689 = NULL;
			__temp1688 = NULL;
			instance_param = (__temp1689 = vala_ccode_formal_parameter_new ("base", (__temp1688 = vala_type_reference_get_cname (base_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1689);
			(__temp1688 = (g_free (__temp1688), NULL));
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaTypeReference* base_type;
				ValaCCodeFormalParameter* __temp1691;
				char* __temp1690;
				base_type = vala_type_reference_new ();
				vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_method (m)))));
				__temp1691 = NULL;
				__temp1690 = NULL;
				instance_param = (__temp1691 = vala_ccode_formal_parameter_new ("base", (__temp1690 = vala_type_reference_get_cname (base_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1691);
				(__temp1690 = (g_free (__temp1690), NULL));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (vala_method_get_instance_by_reference (m)) {
					ValaCCodeFormalParameter* __temp1693;
					char* __temp1692;
					__temp1693 = NULL;
					__temp1692 = NULL;
					instance_param = (__temp1693 = vala_ccode_formal_parameter_new ("*self", (__temp1692 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1693);
					(__temp1692 = (g_free (__temp1692), NULL));
				} else {
					ValaCCodeFormalParameter* __temp1695;
					char* __temp1694;
					__temp1695 = NULL;
					__temp1694 = NULL;
					instance_param = (__temp1695 = vala_ccode_formal_parameter_new ("self", (__temp1694 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1695);
					(__temp1694 = (g_free (__temp1694), NULL));
				}
			}
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_add_parameter (self->priv->function, instance_param);
		}
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			char* __temp1696;
			ValaCCodeDeclaration* __temp1697;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* __temp1698;
			__temp1696 = NULL;
			__temp1697 = NULL;
			vdecl = (__temp1697 = vala_ccode_declaration_new ((__temp1696 = vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE))), (__temp1696 = (g_free (__temp1696), NULL)), __temp1697);
			__temp1698 = NULL;
			vdeclarator = (__temp1698 = vala_ccode_function_declarator_new (vala_symbol_get_name (((ValaSymbol*) m))), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), __temp1698);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (self->priv->type_struct, vdecl);
			vala_ccode_function_declarator_add_parameter (vdeclarator, instance_param);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m) && VALA_IS_CLASS (self->priv->current_type_symbol)) {
		{
			GeeCollection* type_param_collection;
			GeeIterator* type_param_it;
			type_param_collection = vala_class_get_type_parameters (self->priv->current_class);
			type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				type_param = gee_iterator_get (type_param_it);
				{
					ValaCCodeFormalParameter* __temp1701;
					char* __temp1700;
					char* __temp1699;
					ValaCCodeFormalParameter* __temp1704;
					char* __temp1703;
					char* __temp1702;
					/* memory management for generic types*/
					__temp1701 = NULL;
					__temp1700 = NULL;
					__temp1699 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (__temp1701 = vala_ccode_formal_parameter_new ((__temp1700 = g_strdup_printf ("%s_dup_func", (__temp1699 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1)))), "GBoxedCopyFunc")));
					(__temp1701 == NULL ? NULL : (__temp1701 = (g_object_unref (__temp1701), NULL)));
					(__temp1700 = (g_free (__temp1700), NULL));
					(__temp1699 = (g_free (__temp1699), NULL));
					__temp1704 = NULL;
					__temp1703 = NULL;
					__temp1702 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (__temp1704 = vala_ccode_formal_parameter_new ((__temp1703 = g_strdup_printf ("%s_destroy_func", (__temp1702 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1)))), "GDestroyNotify")));
					(__temp1704 == NULL ? NULL : (__temp1704 = (g_object_unref (__temp1704), NULL)));
					(__temp1703 = (g_free (__temp1703), NULL));
					(__temp1702 = (g_free (__temp1702), NULL));
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
		}
	}
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
					ValaArray* __temp1705;
					ValaArray* arr;
					char* length_ctype;
					__temp1705 = NULL;
					arr = (__temp1705 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1705 == NULL ? NULL : g_object_ref (__temp1705)));
					length_ctype = g_strdup ("int");
					if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
						char* __temp1706;
						__temp1706 = NULL;
						length_ctype = (__temp1706 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), __temp1706);
					}
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							char* __temp1707;
							ValaCCodeFormalParameter* __temp1708;
							ValaCCodeFormalParameter* cparam;
							__temp1707 = NULL;
							__temp1708 = NULL;
							cparam = (__temp1708 = vala_ccode_formal_parameter_new ((__temp1707 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) param)), dim)), length_ctype), (__temp1707 = (g_free (__temp1707), NULL)), __temp1708);
							vala_ccode_function_add_parameter (self->priv->function, cparam);
							if (vdeclarator != NULL) {
								vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					(length_ctype = (g_free (length_ctype), NULL));
				}
				vala_ccode_function_add_parameter (self->priv->function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	/* return array length if appropriate*/
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
		ValaArray* __temp1709;
		ValaArray* arr;
		__temp1709 = NULL;
		arr = (__temp1709 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (__temp1709 == NULL ? NULL : g_object_ref (__temp1709)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				char* __temp1710;
				ValaCCodeFormalParameter* __temp1711;
				ValaCCodeFormalParameter* cparam;
				__temp1710 = NULL;
				__temp1711 = NULL;
				cparam = (__temp1711 = vala_ccode_formal_parameter_new ((__temp1710 = vala_code_generator_get_array_length_cname (self, "result", dim)), "int*"), (__temp1710 = (g_free (__temp1710), NULL)), __temp1711);
				vala_ccode_function_add_parameter (self->priv->function, cparam);
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
				}
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_add_parameter (self->priv->function, instance_param);
	}
	__temp1712 = NULL;
	if ((__temp1713 = gee_collection_get_size ((__temp1712 = vala_method_get_error_domains (m))) > 0, (__temp1712 == NULL ? NULL : (__temp1712 = (g_object_unref (__temp1712), NULL))), __temp1713)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_add_parameter (self->priv->function, cparam);
		if (vdeclarator != NULL) {
			vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
		}
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	visible = m->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE;
	if (VALA_IS_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))) {
		ValaDataType* __temp1714;
		ValaDataType* dt;
		__temp1714 = NULL;
		dt = (__temp1714 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1714 == NULL ? NULL : g_object_ref (__temp1714)));
		visible = visible && dt->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE;
		(dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL)));
	}
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* __temp1715;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			__temp1715 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1715 = vala_ccode_function_copy (self->priv->function))));
			(__temp1715 = (g_object_unref (__temp1715), NULL));
		} else {
			ValaCCodeFunction* __temp1716;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
			__temp1716 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1716 = vala_ccode_function_copy (self->priv->function))));
			(__temp1716 = (g_object_unref (__temp1716), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_method_get_body (m)))));
			cinit = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))) {
				ValaClass* __temp1717;
				ValaClass* cl;
				__temp1717 = NULL;
				cl = (__temp1717 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1717 == NULL ? NULL : g_object_ref (__temp1717)));
				if (vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL) {
					ValaCCodeExpression* cself;
					char* __temp1729;
					char* __temp1728;
					ValaCCodeDeclaration* __temp1730;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* __temp1731;
					cself = NULL;
					if (vala_code_context_get_debug (self->priv->context)) {
						ValaCCodeIdentifier* __temp1719;
						char* __temp1718;
						ValaCCodeFunctionCall* __temp1720;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* __temp1721;
						ValaCCodeExpression* __temp1723;
						ValaCCodeFunctionCall* __temp1722;
						__temp1719 = NULL;
						__temp1718 = NULL;
						__temp1720 = NULL;
						ccall = (__temp1720 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1719 = vala_ccode_identifier_new ((__temp1718 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp1719 == NULL ? NULL : (__temp1719 = (g_object_unref (__temp1719), NULL))), (__temp1718 = (g_free (__temp1718), NULL)), __temp1720);
						__temp1721 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1721 = vala_ccode_identifier_new ("base"))));
						(__temp1721 == NULL ? NULL : (__temp1721 = (g_object_unref (__temp1721), NULL)));
						__temp1723 = NULL;
						__temp1722 = NULL;
						cself = (__temp1723 = VALA_CCODE_EXPRESSION ((__temp1722 = ccall, (__temp1722 == NULL ? NULL : g_object_ref (__temp1722)))), (cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL))), __temp1723);
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						ValaCCodeExpression* __temp1727;
						char* __temp1726;
						char* __temp1725;
						ValaCCodeIdentifier* __temp1724;
						__temp1727 = NULL;
						__temp1726 = NULL;
						__temp1725 = NULL;
						__temp1724 = NULL;
						cself = (__temp1727 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((__temp1724 = vala_ccode_identifier_new ("base"))), (__temp1726 = g_strconcat ((__temp1725 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)), "*", NULL)))), (cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL))), __temp1727);
						(__temp1726 = (g_free (__temp1726), NULL));
						(__temp1725 = (g_free (__temp1725), NULL));
						(__temp1724 == NULL ? NULL : (__temp1724 = (g_object_unref (__temp1724), NULL)));
					}
					__temp1729 = NULL;
					__temp1728 = NULL;
					__temp1730 = NULL;
					cdecl_ = (__temp1730 = vala_ccode_declaration_new ((__temp1729 = g_strdup_printf ("%s *", (__temp1728 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (__temp1729 = (g_free (__temp1729), NULL)), (__temp1728 = (g_free (__temp1728), NULL)), __temp1730);
					__temp1731 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1731 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(__temp1731 == NULL ? NULL : (__temp1731 = (g_object_unref (__temp1731), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* __temp1732;
						__temp1732 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp1732 = vala_code_generator_create_method_type_check_statement (self, m, VALA_DATA_TYPE (cl), TRUE, "self"))));
						(__temp1732 == NULL ? NULL : (__temp1732 = (g_object_unref (__temp1732), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GeeCollection* param_collection;
				GeeIterator* param_it;
				param_collection = vala_invokable_get_parameters (VALA_INVOKABLE (m));
				param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = gee_iterator_get (param_it);
					{
						ValaDataType* __temp1733;
						ValaDataType* t;
						__temp1733 = NULL;
						t = (__temp1733 = vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), (__temp1733 == NULL ? NULL : g_object_ref (__temp1733)));
						if (t != NULL && vala_data_type_is_reference_type (t) && !vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
							ValaCCodeStatement* type_check;
							type_check = vala_code_generator_create_method_type_check_statement (self, m, t, vala_type_reference_get_non_null (vala_formal_parameter_get_type_reference (param)), vala_symbol_get_name (((ValaSymbol*) param)));
							if (type_check != NULL) {
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
							}
							(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* __temp1735;
				ValaCCodeConstant* __temp1734;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				__temp1735 = NULL;
				__temp1734 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1735 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((__temp1734 = vala_ccode_constant_new ("NULL")))))));
				(__temp1735 == NULL ? NULL : (__temp1735 = (g_object_unref (__temp1735), NULL)));
				(__temp1734 == NULL ? NULL : (__temp1734 = (g_object_unref (__temp1734), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (((ValaCodeNode*) m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) m))) != NULL) {
				ValaCCodeComment* __temp1736;
				__temp1736 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp1736 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) m)))))));
				(__temp1736 == NULL ? NULL : (__temp1736 = (g_object_unref (__temp1736), NULL)));
			}
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (VALA_IS_CLASS (self->priv->current_type_symbol)) {
					gint n_params;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					if (n_params > 0) {
						ValaCCodeIdentifier* __temp1737;
						ValaCCodeFunctionCall* __temp1738;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* __temp1739;
						ValaCCodeConstant* __temp1741;
						char* __temp1740;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* __temp1742;
						ValaCCodeDeclaration* __temp1743;
						ValaCCodeVariableDeclarator* __temp1745;
						ValaCCodeIdentifier* __temp1744;
						/* declare construction parameter array*/
						__temp1737 = NULL;
						__temp1738 = NULL;
						cparamsinit = (__temp1738 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1737 = vala_ccode_identifier_new ("g_new0")))), (__temp1737 == NULL ? NULL : (__temp1737 = (g_object_unref (__temp1737), NULL))), __temp1738);
						__temp1739 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp1739 = vala_ccode_identifier_new ("GParameter"))));
						(__temp1739 == NULL ? NULL : (__temp1739 = (g_object_unref (__temp1739), NULL)));
						__temp1741 = NULL;
						__temp1740 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp1741 = vala_ccode_constant_new ((__temp1740 = g_strdup_printf ("%i", n_params))))));
						(__temp1741 == NULL ? NULL : (__temp1741 = (g_object_unref (__temp1741), NULL)));
						(__temp1740 = (g_free (__temp1740), NULL));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						__temp1742 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1742 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(__temp1742 == NULL ? NULL : (__temp1742 = (g_object_unref (__temp1742), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						__temp1743 = NULL;
						cdecl_ = (__temp1743 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp1743);
						__temp1745 = NULL;
						__temp1744 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1745 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((__temp1744 = vala_ccode_identifier_new ("__params")))))));
						(__temp1745 == NULL ? NULL : (__temp1745 = (g_object_unref (__temp1745), NULL)));
						(__temp1744 == NULL ? NULL : (__temp1744 = (g_object_unref (__temp1744), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					{
						GeeCollection* type_param_collection;
						GeeIterator* type_param_it;
						type_param_collection = vala_class_get_type_parameters (self->priv->current_class);
						type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
						while (gee_iterator_next (type_param_it)) {
							ValaTypeParameter* type_param;
							type_param = gee_iterator_get (type_param_it);
							{
								char* func_name;
								ValaCCodeMemberAccess* cmember;
								ValaCCodeAssignment* cassign;
								char* __temp1747;
								char* __temp1746;
								ValaCCodeMemberAccess* __temp1750;
								ValaCCodeMemberAccess* __temp1749;
								ValaCCodeIdentifier* __temp1748;
								ValaCCodeAssignment* __temp1752;
								ValaCCodeIdentifier* __temp1751;
								ValaCCodeExpressionStatement* __temp1753;
								char* __temp1755;
								char* __temp1754;
								ValaCCodeMemberAccess* __temp1758;
								ValaCCodeMemberAccess* __temp1757;
								ValaCCodeIdentifier* __temp1756;
								ValaCCodeAssignment* __temp1760;
								ValaCCodeIdentifier* __temp1759;
								ValaCCodeExpressionStatement* __temp1761;
								/* dup and destroy func properties for generic types */
								func_name = NULL;
								cmember = NULL;
								cassign = NULL;
								__temp1747 = NULL;
								__temp1746 = NULL;
								func_name = (__temp1747 = g_strdup_printf ("%s_dup_func", (__temp1746 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), __temp1747);
								(__temp1746 = (g_free (__temp1746), NULL));
								__temp1750 = NULL;
								__temp1749 = NULL;
								__temp1748 = NULL;
								cmember = (__temp1750 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1749 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1748 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), __temp1750);
								(__temp1749 == NULL ? NULL : (__temp1749 = (g_object_unref (__temp1749), NULL)));
								(__temp1748 == NULL ? NULL : (__temp1748 = (g_object_unref (__temp1748), NULL)));
								__temp1752 = NULL;
								__temp1751 = NULL;
								cassign = (__temp1752 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((__temp1751 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp1752);
								(__temp1751 == NULL ? NULL : (__temp1751 = (g_object_unref (__temp1751), NULL)));
								__temp1753 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp1753 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(__temp1753 == NULL ? NULL : (__temp1753 = (g_object_unref (__temp1753), NULL)));
								__temp1755 = NULL;
								__temp1754 = NULL;
								func_name = (__temp1755 = g_strdup_printf ("%s_destroy_func", (__temp1754 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), __temp1755);
								(__temp1754 = (g_free (__temp1754), NULL));
								__temp1758 = NULL;
								__temp1757 = NULL;
								__temp1756 = NULL;
								cmember = (__temp1758 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1757 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1756 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), __temp1758);
								(__temp1757 == NULL ? NULL : (__temp1757 = (g_object_unref (__temp1757), NULL)));
								(__temp1756 == NULL ? NULL : (__temp1756 = (g_object_unref (__temp1756), NULL)));
								__temp1760 = NULL;
								__temp1759 = NULL;
								cassign = (__temp1760 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((__temp1759 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp1760);
								(__temp1759 == NULL ? NULL : (__temp1759 = (g_object_unref (__temp1759), NULL)));
								__temp1761 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp1761 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(__temp1761 == NULL ? NULL : (__temp1761 = (g_object_unref (__temp1761), NULL)));
								(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
								(func_name = (g_free (func_name), NULL));
								(cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL)));
								(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
						(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
					}
				} else {
					ValaStruct* __temp1762;
					ValaStruct* st;
					char* __temp1764;
					char* __temp1763;
					ValaCCodeDeclaration* __temp1765;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeIdentifier* __temp1766;
					ValaCCodeFunctionCall* __temp1767;
					ValaCCodeFunctionCall* ccall;
					ValaCCodeIdentifier* __temp1769;
					char* __temp1768;
					ValaCCodeVariableDeclarator* __temp1770;
					__temp1762 = NULL;
					st = (__temp1762 = VALA_STRUCT (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1762 == NULL ? NULL : g_object_ref (__temp1762)));
					__temp1764 = NULL;
					__temp1763 = NULL;
					__temp1765 = NULL;
					cdecl_ = (__temp1765 = vala_ccode_declaration_new ((__temp1764 = g_strconcat ((__temp1763 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL))), (__temp1764 = (g_free (__temp1764), NULL)), (__temp1763 = (g_free (__temp1763), NULL)), __temp1765);
					__temp1766 = NULL;
					__temp1767 = NULL;
					ccall = (__temp1767 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1766 = vala_ccode_identifier_new ("g_slice_new0")))), (__temp1766 == NULL ? NULL : (__temp1766 = (g_object_unref (__temp1766), NULL))), __temp1767);
					__temp1769 = NULL;
					__temp1768 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1769 = vala_ccode_identifier_new ((__temp1768 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))))));
					(__temp1769 == NULL ? NULL : (__temp1769 = (g_object_unref (__temp1769), NULL)));
					(__temp1768 = (g_free (__temp1768), NULL));
					__temp1770 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1770 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp1770 == NULL ? NULL : (__temp1770 = (g_object_unref (__temp1770), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				}
			}
			if (vala_code_context_get_module_init_method (self->priv->context) == m && self->priv->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (self->priv->module_init_fragment));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* __temp1772;
		char* __temp1771;
		ValaCCodeFunction* __temp1773;
		ValaCCodeFunction* vfunc;
		ValaTypeReference* this_type;
		char* __temp1774;
		ValaCCodeFormalParameter* __temp1775;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* __temp1786;
		ValaCCodeMemberAccess* __temp1787;
		ValaCCodeFunctionCall* __temp1788;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* __temp1789;
		GeeCollection* params;
		__temp1772 = NULL;
		__temp1771 = NULL;
		__temp1773 = NULL;
		vfunc = (__temp1773 = vala_ccode_function_new ((__temp1771 = vala_method_get_cname (m)), (__temp1772 = vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE))), (__temp1772 = (g_free (__temp1772), NULL)), (__temp1771 = (g_free (__temp1771), NULL)), __temp1773);
		this_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (this_type, VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) m))));
		__temp1774 = NULL;
		__temp1775 = NULL;
		cparam = (__temp1775 = vala_ccode_formal_parameter_new ("self", (__temp1774 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (__temp1774 = (g_free (__temp1774), NULL)), __temp1775);
		vala_ccode_function_add_parameter (vfunc, cparam);
		vblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))) {
			ValaInterface* __temp1776;
			ValaInterface* iface;
			ValaCCodeFunctionCall* __temp1780;
			ValaCCodeIdentifier* __temp1779;
			char* __temp1778;
			char* __temp1777;
			__temp1776 = NULL;
			iface = (__temp1776 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1776 == NULL ? NULL : g_object_ref (__temp1776)));
			__temp1780 = NULL;
			__temp1779 = NULL;
			__temp1778 = NULL;
			__temp1777 = NULL;
			vcast = (__temp1780 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1779 = vala_ccode_identifier_new ((__temp1778 = g_strdup_printf ("%s_GET_INTERFACE", (__temp1777 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp1780);
			(__temp1779 == NULL ? NULL : (__temp1779 = (g_object_unref (__temp1779), NULL)));
			(__temp1778 = (g_free (__temp1778), NULL));
			(__temp1777 = (g_free (__temp1777), NULL));
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* __temp1781;
			ValaClass* cl;
			ValaCCodeFunctionCall* __temp1785;
			ValaCCodeIdentifier* __temp1784;
			char* __temp1783;
			char* __temp1782;
			__temp1781 = NULL;
			cl = (__temp1781 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (__temp1781 == NULL ? NULL : g_object_ref (__temp1781)));
			__temp1785 = NULL;
			__temp1784 = NULL;
			__temp1783 = NULL;
			__temp1782 = NULL;
			vcast = (__temp1785 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1784 = vala_ccode_identifier_new ((__temp1783 = g_strdup_printf ("%s_GET_CLASS", (__temp1782 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp1785);
			(__temp1784 == NULL ? NULL : (__temp1784 = (g_object_unref (__temp1784), NULL)));
			(__temp1783 = (g_free (__temp1783), NULL));
			(__temp1782 = (g_free (__temp1782), NULL));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		__temp1786 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp1786 = vala_ccode_identifier_new ("self"))));
		(__temp1786 == NULL ? NULL : (__temp1786 = (g_object_unref (__temp1786), NULL)));
		__temp1787 = NULL;
		__temp1788 = NULL;
		vcall = (__temp1788 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1787 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_symbol_get_name (((ValaSymbol*) m)))))), (__temp1787 == NULL ? NULL : (__temp1787 = (g_object_unref (__temp1787), NULL))), __temp1788);
		__temp1789 = NULL;
		vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp1789 = vala_ccode_identifier_new ("self"))));
		(__temp1789 == NULL ? NULL : (__temp1789 = (g_object_unref (__temp1789), NULL)));
		params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = params;
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (param_it);
				{
					ValaCCodeIdentifier* __temp1790;
					vala_ccode_function_add_parameter (vfunc, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
					__temp1790 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp1790 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param))))));
					(__temp1790 == NULL ? NULL : (__temp1790 = (g_object_unref (__temp1790), NULL)));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
			ValaCCodeExpressionStatement* __temp1791;
			__temp1791 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp1791 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp1791 == NULL ? NULL : (__temp1791 = (g_object_unref (__temp1791), NULL)));
		} else {
			ValaCCodeReturnStatement* __temp1792;
			/* pass method return value */
			__temp1792 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp1792 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp1792 == NULL ? NULL : (__temp1792 = (g_object_unref (__temp1792), NULL)));
		}
		if (visible) {
			ValaCCodeFunction* __temp1793;
			__temp1793 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1793 = vala_ccode_function_copy (vfunc))));
			(__temp1793 = (g_object_unref (__temp1793), NULL));
		} else {
			ValaCCodeFunction* __temp1794;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			__temp1794 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1794 = vala_ccode_function_copy (vfunc))));
			(__temp1794 = (g_object_unref (__temp1794), NULL));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeReturnStatement* creturn;
		ValaCCodeIdentifier* __temp1812;
		if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
			ValaCCodeIdentifier* __temp1796;
			ValaCCodeIdentifier* __temp1795;
			ValaCCodeBinaryExpression* __temp1797;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* __temp1800;
			ValaCCodeUnaryExpression* __temp1799;
			ValaCCodeIdentifier* __temp1798;
			ValaCCodeIdentifier* __temp1801;
			ValaCCodeFunctionCall* __temp1802;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* __temp1805;
			ValaCCodeMemberAccess* __temp1804;
			ValaCCodeIdentifier* __temp1803;
			ValaCCodeExpressionStatement* __temp1806;
			ValaCCodeWhileStatement* __temp1807;
			ValaCCodeIdentifier* __temp1808;
			ValaCCodeFunctionCall* __temp1809;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* __temp1810;
			ValaCCodeExpressionStatement* __temp1811;
			__temp1796 = NULL;
			__temp1795 = NULL;
			__temp1797 = NULL;
			ccond = (__temp1797 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((__temp1795 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((__temp1796 = vala_ccode_identifier_new ("__params")))), (__temp1796 == NULL ? NULL : (__temp1796 = (g_object_unref (__temp1796), NULL))), (__temp1795 == NULL ? NULL : (__temp1795 = (g_object_unref (__temp1795), NULL))), __temp1797);
			cdofreeparam = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			__temp1800 = NULL;
			__temp1799 = NULL;
			__temp1798 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((__temp1800 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1799 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((__temp1798 = vala_ccode_identifier_new ("__params_it"))))))))));
			(__temp1800 == NULL ? NULL : (__temp1800 = (g_object_unref (__temp1800), NULL)));
			(__temp1799 == NULL ? NULL : (__temp1799 = (g_object_unref (__temp1799), NULL)));
			(__temp1798 == NULL ? NULL : (__temp1798 = (g_object_unref (__temp1798), NULL)));
			__temp1801 = NULL;
			__temp1802 = NULL;
			cunsetcall = (__temp1802 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1801 = vala_ccode_identifier_new ("g_value_unset")))), (__temp1801 == NULL ? NULL : (__temp1801 = (g_object_unref (__temp1801), NULL))), __temp1802);
			__temp1805 = NULL;
			__temp1804 = NULL;
			__temp1803 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((__temp1805 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((__temp1804 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((__temp1803 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(__temp1805 == NULL ? NULL : (__temp1805 = (g_object_unref (__temp1805), NULL)));
			(__temp1804 == NULL ? NULL : (__temp1804 = (g_object_unref (__temp1804), NULL)));
			(__temp1803 == NULL ? NULL : (__temp1803 = (g_object_unref (__temp1803), NULL)));
			__temp1806 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((__temp1806 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(__temp1806 == NULL ? NULL : (__temp1806 = (g_object_unref (__temp1806), NULL)));
			__temp1807 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp1807 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(__temp1807 == NULL ? NULL : (__temp1807 = (g_object_unref (__temp1807), NULL)));
			__temp1808 = NULL;
			__temp1809 = NULL;
			cfreeparams = (__temp1809 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1808 = vala_ccode_identifier_new ("g_free")))), (__temp1808 == NULL ? NULL : (__temp1808 = (g_object_unref (__temp1808), NULL))), __temp1809);
			__temp1810 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((__temp1810 = vala_ccode_identifier_new ("__params"))));
			(__temp1810 == NULL ? NULL : (__temp1810 = (g_object_unref (__temp1810), NULL)));
			__temp1811 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp1811 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(__temp1811 == NULL ? NULL : (__temp1811 = (g_object_unref (__temp1811), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (g_object_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (g_object_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (g_object_unref (cfreeparams), NULL)));
		}
		creturn = vala_ccode_return_statement_new (NULL);
		__temp1812 = NULL;
		vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((__temp1812 = vala_ccode_identifier_new ("self"))));
		(__temp1812 == NULL ? NULL : (__temp1812 = (g_object_unref (__temp1812), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (creturn));
		(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_code_generator_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* __temp1813;
		ValaCCodeFormalParameter* __temp1814;
		ValaCCodeBlock* main_block;
		ValaCCodeExpressionStatement* __temp1821;
		ValaCCodeFunctionCall* __temp1820;
		ValaCCodeIdentifier* __temp1819;
		ValaCCodeIdentifier* __temp1822;
		ValaCCodeFunctionCall* __temp1823;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		__temp1813 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp1813 = vala_ccode_formal_parameter_new ("argc", "int")));
		(__temp1813 == NULL ? NULL : (__temp1813 = (g_object_unref (__temp1813), NULL)));
		__temp1814 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp1814 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(__temp1814 == NULL ? NULL : (__temp1814 = (g_object_unref (__temp1814), NULL)));
		main_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		if (vala_code_context_get_thread (self->priv->context)) {
			ValaCCodeIdentifier* __temp1815;
			ValaCCodeFunctionCall* __temp1816;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* __temp1817;
			ValaCCodeExpressionStatement* __temp1818;
			__temp1815 = NULL;
			__temp1816 = NULL;
			thread_init_call = (__temp1816 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1815 = vala_ccode_identifier_new ("g_thread_init")))), (__temp1815 == NULL ? NULL : (__temp1815 = (g_object_unref (__temp1815), NULL))), __temp1816);
			__temp1817 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((__temp1817 = vala_ccode_constant_new ("NULL"))));
			(__temp1817 == NULL ? NULL : (__temp1817 = (g_object_unref (__temp1817), NULL)));
			__temp1818 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1818 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(__temp1818 == NULL ? NULL : (__temp1818 = (g_object_unref (__temp1818), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		__temp1821 = NULL;
		__temp1820 = NULL;
		__temp1819 = NULL;
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1821 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1820 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1819 = vala_ccode_identifier_new ("g_type_init"))))))))));
		(__temp1821 == NULL ? NULL : (__temp1821 = (g_object_unref (__temp1821), NULL)));
		(__temp1820 == NULL ? NULL : (__temp1820 = (g_object_unref (__temp1820), NULL)));
		(__temp1819 == NULL ? NULL : (__temp1819 = (g_object_unref (__temp1819), NULL)));
		__temp1822 = NULL;
		__temp1823 = NULL;
		main_call = (__temp1823 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1822 = vala_ccode_identifier_new (vala_ccode_function_get_name (self->priv->function))))), (__temp1822 == NULL ? NULL : (__temp1822 = (g_object_unref (__temp1822), NULL))), __temp1823);
		if (args_parameter) {
			ValaCCodeIdentifier* __temp1824;
			ValaCCodeIdentifier* __temp1825;
			__temp1824 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp1824 = vala_ccode_identifier_new ("argc"))));
			(__temp1824 == NULL ? NULL : (__temp1824 = (g_object_unref (__temp1824), NULL)));
			__temp1825 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp1825 = vala_ccode_identifier_new ("argv"))));
			(__temp1825 == NULL ? NULL : (__temp1825 = (g_object_unref (__temp1825), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* __temp1826;
			__temp1826 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1826 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp1826 == NULL ? NULL : (__temp1826 = (g_object_unref (__temp1826), NULL)));
		} else {
			ValaCCodeExpressionStatement* __temp1827;
			ValaCCodeReturnStatement* __temp1829;
			ValaCCodeConstant* __temp1828;
			/* method returns void, always use 0 as exit code*/
			__temp1827 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1827 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp1827 == NULL ? NULL : (__temp1827 = (g_object_unref (__temp1827), NULL)));
			__temp1829 = NULL;
			__temp1828 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1829 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((__temp1828 = vala_ccode_constant_new ("0")))))));
			(__temp1829 == NULL ? NULL : (__temp1829 = (g_object_unref (__temp1829), NULL)));
			(__temp1828 == NULL ? NULL : (__temp1828 = (g_object_unref (__temp1828), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (m), vala_type_reference_get_data_type (vala_method_get_return_type (m)), t, non_null, var_name);
}


static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (getter) {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), t, non_null, var_name);
	} else {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), NULL, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name)
{
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* __temp1851;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if (VALA_IS_CLASS (t) || VALA_IS_INTERFACE (t)) {
		ValaCCodeIdentifier* __temp1834;
		char* __temp1833;
		ValaCCodeFunctionCall* __temp1835;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* __temp1836;
		ValaCCodeFunctionCall* __temp1837;
		ValaCCodeExpression* cexpr;
		__temp1834 = NULL;
		__temp1833 = NULL;
		__temp1835 = NULL;
		ctype_check = (__temp1835 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1834 = vala_ccode_identifier_new ((__temp1833 = vala_data_type_get_upper_case_cname (t, "IS_")))))), (__temp1834 == NULL ? NULL : (__temp1834 = (g_object_unref (__temp1834), NULL))), (__temp1833 = (g_free (__temp1833), NULL)), __temp1835);
		__temp1836 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((__temp1836 = vala_ccode_identifier_new (var_name))));
		(__temp1836 == NULL ? NULL : (__temp1836 = (g_object_unref (__temp1836), NULL)));
		__temp1837 = NULL;
		cexpr = VALA_CCODE_EXPRESSION ((__temp1837 = ctype_check, (__temp1837 == NULL ? NULL : g_object_ref (__temp1837))));
		if (!non_null) {
			ValaCCodeConstant* __temp1839;
			ValaCCodeIdentifier* __temp1838;
			ValaCCodeBinaryExpression* __temp1840;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* __temp1841;
			__temp1839 = NULL;
			__temp1838 = NULL;
			__temp1840 = NULL;
			cnull = (__temp1840 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((__temp1838 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((__temp1839 = vala_ccode_constant_new ("NULL")))), (__temp1839 == NULL ? NULL : (__temp1839 = (g_object_unref (__temp1839), NULL))), (__temp1838 == NULL ? NULL : (__temp1838 = (g_object_unref (__temp1838), NULL))), __temp1840);
			__temp1841 = NULL;
			cexpr = (__temp1841 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1841);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer __temp1842;
			return VALA_CCODE_STATEMENT ((__temp1842 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1842));
		} else {
			ValaCCodeConstant* __temp1844;
			ValaCCodeIdentifier* __temp1843;
			ValaCCodeBinaryExpression* __temp1845;
			ValaCCodeBinaryExpression* cnonnull;
			__temp1844 = NULL;
			__temp1843 = NULL;
			__temp1845 = NULL;
			cnonnull = (__temp1845 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp1843 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((__temp1844 = vala_ccode_constant_new ("NULL")))), (__temp1844 == NULL ? NULL : (__temp1844 = (g_object_unref (__temp1844), NULL))), (__temp1843 == NULL ? NULL : (__temp1843 = (g_object_unref (__temp1843), NULL))), __temp1845);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (ret_type == NULL) {
		ValaCCodeIdentifier* __temp1846;
		/* void function */
		__temp1846 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp1846 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(__temp1846 == NULL ? NULL : (__temp1846 = (g_object_unref (__temp1846), NULL)));
	} else {
		ValaCCodeIdentifier* __temp1847;
		ValaCCodeExpression* cdefault;
		__temp1847 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp1847 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(__temp1847 == NULL ? NULL : (__temp1847 = (g_object_unref (__temp1847), NULL)));
		cdefault = vala_code_generator_default_value_for_type (self, ret_type);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* __temp1848;
			ValaCCodeExpressionStatement* __temp1849;
			ValaCCodeExpressionStatement* __temp1850;
			vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
			__temp1848 = NULL;
			__temp1849 = NULL;
			__temp1850 = NULL;
			return VALA_CCODE_STATEMENT ((__temp1850 = (__temp1849 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1848 = vala_ccode_constant_new ("0")))), (__temp1848 == NULL ? NULL : (__temp1848 = (g_object_unref (__temp1848), NULL))), __temp1849), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1850));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	__temp1851 = NULL;
	return VALA_CCODE_STATEMENT ((__temp1851 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1851));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static ValaCCodeExpression* vala_code_generator_default_value_for_type (ValaCodeGenerator* self, ValaDataType* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_is_reference_type (type) || VALA_IS_POINTER (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	} else {
		char* __temp1853;
		gboolean __temp1854;
		__temp1853 = NULL;
		if ((__temp1854 = (__temp1853 = vala_data_type_get_default_value (type)) != NULL, (__temp1853 = (g_free (__temp1853), NULL)), __temp1854)) {
			char* __temp1855;
			ValaCCodeConstant* __temp1856;
			__temp1855 = NULL;
			__temp1856 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp1856 = vala_ccode_constant_new ((__temp1855 = vala_data_type_get_default_value (type))), (__temp1855 = (g_free (__temp1855), NULL)), __temp1856));
		}
	}
	return VALA_CCODE_EXPRESSION (NULL);
}


static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_DATA_TYPE (sym)) {
			ValaDataType* __temp1859;
			__temp1859 = NULL;
			return (__temp1859 = VALA_DATA_TYPE (sym), (__temp1859 == NULL ? NULL : g_object_ref (__temp1859)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return VALA_DATA_TYPE (NULL);
}


static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_code_visitor_visit_method (VALA_CODE_VISITOR (self), VALA_METHOD (m));
}


static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter)
{
	GeeCollection* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArray* __temp1870;
	ValaArray* array_type;
	gboolean __temp1872;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (((ValaSymbol*) m)) == NULL || g_utf8_collate (vala_symbol_get_name (((ValaSymbol*) m)), "main") != 0) {
		return FALSE;
	}
	/* method must be called "main"*/
	if (vala_method_get_instance (m)) {
		return FALSE;
	}
	/* method must be static*/
	if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == vala_type_reference_get_data_type (self->priv->int_type)) {
			(*return_value) = TRUE;
		} else {
			return FALSE;
		}
	}
	/* return type must be void or int*/
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	if (gee_collection_get_size (params) == 0) {
		gboolean __temp1866;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (__temp1866 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), __temp1866);
	}
	if (gee_collection_get_size (params) > 1) {
		gboolean __temp1867;
		return (__temp1867 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), __temp1867);
	}
	/* method must not have more than one parameter*/
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = gee_iterator_get (params_it);
	if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
		gboolean __temp1868;
		return (__temp1868 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1868);
	}
	/* parameter must not be an out parameter*/
	if (!(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) {
		gboolean __temp1869;
		return (__temp1869 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1869);
	}
	/* parameter must be an array*/
	__temp1870 = NULL;
	array_type = (__temp1870 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1870 == NULL ? NULL : g_object_ref (__temp1870)));
	if (vala_array_get_element_type (array_type) != vala_type_reference_get_data_type (self->priv->string_type)) {
		gboolean __temp1871;
		return (__temp1871 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp1871);
	}
	/* parameter must be an array of strings*/
	(*args_parameter) = TRUE;
	return (__temp1872 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp1872);
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b, gboolean has_params)
{
	ValaClass* __temp1873;
	ValaClass* cl;
	ValaCCodeIdentifier* __temp1874;
	ValaCCodeFunctionCall* __temp1875;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* __temp1877;
	char* __temp1876;
	ValaCCodeVariableDeclarator* cdecl_;
	char* __temp1883;
	char* __temp1882;
	ValaCCodeDeclaration* __temp1884;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	__temp1873 = NULL;
	cl = (__temp1873 = VALA_CLASS (self->priv->current_type_symbol), (__temp1873 == NULL ? NULL : g_object_ref (__temp1873)));
	__temp1874 = NULL;
	__temp1875 = NULL;
	ccall = (__temp1875 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1874 = vala_ccode_identifier_new ("g_object_newv")))), (__temp1874 == NULL ? NULL : (__temp1874 = (g_object_unref (__temp1874), NULL))), __temp1875);
	__temp1877 = NULL;
	__temp1876 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1877 = vala_ccode_constant_new ((__temp1876 = vala_data_type_get_type_id (VALA_DATA_TYPE (cl)))))));
	(__temp1877 == NULL ? NULL : (__temp1877 = (g_object_unref (__temp1877), NULL)));
	(__temp1876 = (g_free (__temp1876), NULL));
	if (has_params) {
		ValaCCodeConstant* __temp1878;
		ValaCCodeConstant* __temp1879;
		__temp1878 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1878 = vala_ccode_constant_new ("__params_it - __params"))));
		(__temp1878 == NULL ? NULL : (__temp1878 = (g_object_unref (__temp1878), NULL)));
		__temp1879 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1879 = vala_ccode_constant_new ("__params"))));
		(__temp1879 == NULL ? NULL : (__temp1879 = (g_object_unref (__temp1879), NULL)));
	} else {
		ValaCCodeConstant* __temp1880;
		ValaCCodeConstant* __temp1881;
		__temp1880 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1880 = vala_ccode_constant_new ("0"))));
		(__temp1880 == NULL ? NULL : (__temp1880 = (g_object_unref (__temp1880), NULL)));
		__temp1881 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1881 = vala_ccode_constant_new ("NULL"))));
		(__temp1881 == NULL ? NULL : (__temp1881 = (g_object_unref (__temp1881), NULL)));
	}
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
	__temp1883 = NULL;
	__temp1882 = NULL;
	__temp1884 = NULL;
	cdeclaration = (__temp1884 = vala_ccode_declaration_new ((__temp1883 = g_strdup_printf ("%s *", (__temp1882 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (__temp1883 = (g_free (__temp1883), NULL)), (__temp1882 = (g_free (__temp1882), NULL)), __temp1884);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup (("POINTER"));
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup (("VOID"));
		} else {
			return vala_data_type_get_marshaller_type_name (vala_type_reference_get_data_type (t));
		}
	}
}


static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix)
{
	char* signature;
	char* ret;
	GeeCollection* params;
	char* __temp1889;
	char* __temp1888;
	char* __temp1893;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = vala_code_generator_get_signal_signature (self, sig);
	ret = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	if (prefix == NULL) {
		if (gee_collection_contains (GEE_COLLECTION (self->priv->predefined_marshal_set), signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	__temp1889 = NULL;
	__temp1888 = NULL;
	ret = (__temp1889 = g_strdup_printf ("%s_%s_", prefix, (__temp1888 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (ret = (g_free (ret), NULL)), __temp1889);
	(__temp1888 = (g_free (__temp1888), NULL));
	if (params == NULL) {
		char* __temp1890;
		__temp1890 = NULL;
		ret = (__temp1890 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), __temp1890);
	} else {
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = gee_iterator_get (p_it);
				{
					char* __temp1892;
					char* __temp1891;
					__temp1892 = NULL;
					__temp1891 = NULL;
					ret = (__temp1892 = g_strdup_printf ("%s_%s", ret, (__temp1891 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (ret = (g_free (ret), NULL)), __temp1892);
					(__temp1891 = (g_free (__temp1891), NULL));
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	__temp1893 = NULL;
	return (__temp1893 = ret, (signature = (g_free (signature), NULL)), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), __temp1893);
	(signature = (g_free (signature), NULL));
	(ret = (g_free (ret), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup ("void");
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (t)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (t))) {
				return g_strdup ("GObject *");
			} else {
				if (VALA_IS_STRUCT (vala_type_reference_get_data_type (t))) {
					if (vala_data_type_is_reference_type (VALA_DATA_TYPE ((VALA_STRUCT (vala_type_reference_get_data_type (t)))))) {
						return g_strdup ("gpointer");
					} else {
						return vala_data_type_get_cname (vala_type_reference_get_data_type (t), FALSE);
					}
				} else {
					if (VALA_IS_ENUM (vala_type_reference_get_data_type (t))) {
						return g_strdup ("gint");
					} else {
						if (VALA_IS_ARRAY (vala_type_reference_get_data_type (t))) {
							return g_strdup ("gpointer");
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig)
{
	char* signature;
	GeeCollection* params;
	char* __temp1903;
	char* __temp1902;
	char* __temp1909;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	__temp1903 = NULL;
	__temp1902 = NULL;
	signature = (__temp1903 = g_strdup_printf ("%s:", (__temp1902 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (signature = (g_free (signature), NULL)), __temp1903);
	(__temp1902 = (g_free (__temp1902), NULL));
	if (params == NULL) {
		char* __temp1904;
		__temp1904 = NULL;
		signature = (__temp1904 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), __temp1904);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = gee_iterator_get (p_it);
				{
					if (first) {
						char* __temp1906;
						char* __temp1905;
						__temp1906 = NULL;
						__temp1905 = NULL;
						signature = (__temp1906 = g_strconcat (signature, (__temp1905 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p))), NULL), (signature = (g_free (signature), NULL)), __temp1906);
						(__temp1905 = (g_free (__temp1905), NULL));
						first = FALSE;
					} else {
						char* __temp1908;
						char* __temp1907;
						__temp1908 = NULL;
						__temp1907 = NULL;
						signature = (__temp1908 = g_strdup_printf ("%s,%s", signature, (__temp1907 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (signature = (g_free (signature), NULL)), __temp1908);
						(__temp1907 = (g_free (__temp1907), NULL));
					}
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	__temp1909 = NULL;
	return (__temp1909 = signature, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), __temp1909);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaCodeGenerator * self;
	char* signature;
	GeeCollection* params;
	gint n_params;
	gint i;
	char* __temp1910;
	char* __temp1911;
	ValaCCodeFunction* __temp1912;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* __temp1913;
	ValaCCodeFormalParameter* __temp1914;
	ValaCCodeFormalParameter* __temp1915;
	ValaCCodeFormalParameter* __temp1916;
	ValaCCodeFormalParameter* __temp1917;
	ValaCCodeFormalParameter* __temp1918;
	ValaCCodeFunction* __temp1919;
	ValaCCodeBlock* marshaller_body;
	char* __temp1920;
	ValaCCodeFunctionDeclarator* __temp1921;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* __temp1922;
	ValaCCodeFormalParameter* __temp1926;
	ValaCCodeTypeDefinition* __temp1928;
	char* __temp1927;
	char* __temp1929;
	ValaCCodeDeclaration* __temp1930;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* __temp1931;
	ValaCCodeDeclaration* __temp1932;
	ValaCCodeVariableDeclarator* __temp1935;
	ValaCCodeCastExpression* __temp1934;
	ValaCCodeIdentifier* __temp1933;
	ValaCCodeDeclaration* __temp1936;
	ValaCCodeVariableDeclarator* __temp1937;
	ValaCCodeVariableDeclarator* __temp1938;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* __temp1949;
	ValaCCodeIdentifier* __temp1948;
	ValaCCodeBinaryExpression* __temp1953;
	ValaCCodeConstant* __temp1952;
	char* __temp1951;
	ValaCCodeIdentifier* __temp1950;
	ValaCCodeExpressionStatement* __temp1954;
	ValaCCodeIdentifier* __temp1955;
	ValaCCodeMemberAccess* __temp1956;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* __temp1958;
	ValaCCodeIdentifier* __temp1957;
	ValaCCodeMemberAccess* __temp1959;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* __temp1960;
	ValaCCodeFunctionCall* __temp1961;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* __temp1962;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* __temp1965;
	ValaCCodeAssignment* __temp1964;
	ValaCCodeIdentifier* __temp1963;
	ValaCCodeExpressionStatement* __temp1968;
	ValaCCodeAssignment* __temp1967;
	ValaCCodeIdentifier* __temp1966;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* __temp1971;
	ValaCCodeAssignment* __temp1970;
	ValaCCodeIdentifier* __temp1969;
	ValaCCodeExpressionStatement* __temp1974;
	ValaCCodeAssignment* __temp1973;
	ValaCCodeIdentifier* __temp1972;
	ValaCCodeIfStatement* __temp1975;
	ValaCCodeCastExpression* __temp1983;
	char* __temp1982;
	ValaCCodeConditionalExpression* __temp1981;
	ValaCCodeMemberAccess* __temp1980;
	ValaCCodeIdentifier* __temp1979;
	ValaCCodeIdentifier* __temp1978;
	ValaCCodeIdentifier* __temp1977;
	ValaCCodeIdentifier* __temp1976;
	ValaCCodeAssignment* __temp1984;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* __temp1985;
	ValaCCodeFunctionCall* __temp1987;
	ValaCCodeIdentifier* __temp1986;
	ValaCCodeIdentifier* __temp1988;
	ValaCCodeIdentifier* __temp1997;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	__temp1910 = NULL;
	signature = (__temp1910 = vala_code_generator_get_signal_signature (self, sig), (signature = (g_free (signature), NULL)), __temp1910);
	if (gee_collection_contains (GEE_COLLECTION (self->priv->predefined_marshal_set), signature) || gee_collection_contains (GEE_COLLECTION (self->priv->user_marshal_set), signature)) {
		(signature = (g_free (signature), NULL));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	__temp1911 = NULL;
	__temp1912 = NULL;
	signal_marshaller = (__temp1912 = vala_ccode_function_new ((__temp1911 = vala_code_generator_get_signal_marshaller_function (self, sig, NULL)), "void"), (__temp1911 = (g_free (__temp1911), NULL)), __temp1912);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	__temp1913 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1913 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(__temp1913 == NULL ? NULL : (__temp1913 = (g_object_unref (__temp1913), NULL)));
	__temp1914 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1914 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(__temp1914 == NULL ? NULL : (__temp1914 = (g_object_unref (__temp1914), NULL)));
	__temp1915 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1915 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(__temp1915 == NULL ? NULL : (__temp1915 = (g_object_unref (__temp1915), NULL)));
	__temp1916 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1916 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(__temp1916 == NULL ? NULL : (__temp1916 = (g_object_unref (__temp1916), NULL)));
	__temp1917 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1917 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(__temp1917 == NULL ? NULL : (__temp1917 = (g_object_unref (__temp1917), NULL)));
	__temp1918 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1918 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(__temp1918 == NULL ? NULL : (__temp1918 = (g_object_unref (__temp1918), NULL)));
	__temp1919 = NULL;
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_declaration, VALA_CCODE_NODE ((__temp1919 = vala_ccode_function_copy (signal_marshaller))));
	(__temp1919 = (g_object_unref (__temp1919), NULL));
	marshaller_body = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1920 = NULL;
	__temp1921 = NULL;
	callback_decl = (__temp1921 = vala_ccode_function_declarator_new ((__temp1920 = vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), (__temp1920 = (g_free (__temp1920), NULL)), __temp1921);
	__temp1922 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1922 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(__temp1922 == NULL ? NULL : (__temp1922 = (g_object_unref (__temp1922), NULL)));
	n_params = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = gee_iterator_get (p_it);
			{
				ValaCCodeFormalParameter* __temp1925;
				char* __temp1924;
				char* __temp1923;
				__temp1925 = NULL;
				__temp1924 = NULL;
				__temp1923 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1925 = vala_ccode_formal_parameter_new ((__temp1923 = g_strdup_printf ("arg_%d", n_params)), (__temp1924 = vala_code_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p))))));
				(__temp1925 == NULL ? NULL : (__temp1925 = (g_object_unref (__temp1925), NULL)));
				(__temp1924 = (g_free (__temp1924), NULL));
				(__temp1923 = (g_free (__temp1923), NULL));
				n_params++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	__temp1926 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1926 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(__temp1926 == NULL ? NULL : (__temp1926 = (g_object_unref (__temp1926), NULL)));
	__temp1928 = NULL;
	__temp1927 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1928 = vala_ccode_type_definition_new ((__temp1927 = vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig))), VALA_CCODE_DECLARATOR (callback_decl)))));
	(__temp1928 == NULL ? NULL : (__temp1928 = (g_object_unref (__temp1928), NULL)));
	(__temp1927 = (g_free (__temp1927), NULL));
	__temp1929 = NULL;
	__temp1930 = NULL;
	var_decl = (__temp1930 = vala_ccode_declaration_new ((__temp1929 = vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), (__temp1929 = (g_free (__temp1929), NULL)), __temp1930);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	__temp1931 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1931 = vala_ccode_variable_declarator_new ("callback"))));
	(__temp1931 == NULL ? NULL : (__temp1931 = (g_object_unref (__temp1931), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	__temp1932 = NULL;
	var_decl = (__temp1932 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1932);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	__temp1935 = NULL;
	__temp1934 = NULL;
	__temp1933 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1935 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION ((__temp1934 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((__temp1933 = vala_ccode_identifier_new ("closure"))), "GCClosure *")))))));
	(__temp1935 == NULL ? NULL : (__temp1935 = (g_object_unref (__temp1935), NULL)));
	(__temp1934 == NULL ? NULL : (__temp1934 = (g_object_unref (__temp1934), NULL)));
	(__temp1933 == NULL ? NULL : (__temp1933 = (g_object_unref (__temp1933), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	__temp1936 = NULL;
	var_decl = (__temp1936 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1936);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	__temp1937 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1937 = vala_ccode_variable_declarator_new ("data1"))));
	(__temp1937 == NULL ? NULL : (__temp1937 = (g_object_unref (__temp1937), NULL)));
	__temp1938 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1938 = vala_ccode_variable_declarator_new ("data2"))));
	(__temp1938 == NULL ? NULL : (__temp1938 = (g_object_unref (__temp1938), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	fc = NULL;
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeDeclaration* __temp1940;
		char* __temp1939;
		ValaCCodeVariableDeclarator* __temp1941;
		ValaCCodeFunctionCall* __temp1943;
		ValaCCodeIdentifier* __temp1942;
		ValaCCodeBinaryExpression* __temp1946;
		ValaCCodeConstant* __temp1945;
		ValaCCodeIdentifier* __temp1944;
		ValaCCodeExpressionStatement* __temp1947;
		__temp1940 = NULL;
		__temp1939 = NULL;
		var_decl = (__temp1940 = vala_ccode_declaration_new ((__temp1939 = vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig)))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1940);
		(__temp1939 = (g_free (__temp1939), NULL));
		__temp1941 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1941 = vala_ccode_variable_declarator_new ("v_return"))));
		(__temp1941 == NULL ? NULL : (__temp1941 = (g_object_unref (__temp1941), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		__temp1943 = NULL;
		__temp1942 = NULL;
		fc = (__temp1943 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1942 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1943);
		(__temp1942 == NULL ? NULL : (__temp1942 = (g_object_unref (__temp1942), NULL)));
		__temp1946 = NULL;
		__temp1945 = NULL;
		__temp1944 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1946 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp1944 = vala_ccode_identifier_new ("return_value"))), VALA_CCODE_EXPRESSION ((__temp1945 = vala_ccode_constant_new ("NULL")))))));
		(__temp1946 == NULL ? NULL : (__temp1946 = (g_object_unref (__temp1946), NULL)));
		(__temp1945 == NULL ? NULL : (__temp1945 = (g_object_unref (__temp1945), NULL)));
		(__temp1944 == NULL ? NULL : (__temp1944 = (g_object_unref (__temp1944), NULL)));
		__temp1947 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1947 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp1947 == NULL ? NULL : (__temp1947 = (g_object_unref (__temp1947), NULL)));
	}
	__temp1949 = NULL;
	__temp1948 = NULL;
	fc = (__temp1949 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1948 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1949);
	(__temp1948 == NULL ? NULL : (__temp1948 = (g_object_unref (__temp1948), NULL)));
	__temp1953 = NULL;
	__temp1952 = NULL;
	__temp1951 = NULL;
	__temp1950 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1953 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((__temp1950 = vala_ccode_identifier_new ("n_param_values"))), VALA_CCODE_EXPRESSION ((__temp1952 = vala_ccode_constant_new ((__temp1951 = g_strdup_printf ("%i", n_params)))))))));
	(__temp1953 == NULL ? NULL : (__temp1953 = (g_object_unref (__temp1953), NULL)));
	(__temp1952 == NULL ? NULL : (__temp1952 = (g_object_unref (__temp1952), NULL)));
	(__temp1951 = (g_free (__temp1951), NULL));
	(__temp1950 == NULL ? NULL : (__temp1950 = (g_object_unref (__temp1950), NULL)));
	__temp1954 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1954 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp1954 == NULL ? NULL : (__temp1954 = (g_object_unref (__temp1954), NULL)));
	__temp1955 = NULL;
	__temp1956 = NULL;
	data = (__temp1956 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((__temp1955 = vala_ccode_identifier_new ("closure"))), "data", TRUE), (__temp1955 == NULL ? NULL : (__temp1955 = (g_object_unref (__temp1955), NULL))), __temp1956);
	__temp1958 = NULL;
	__temp1957 = NULL;
	__temp1959 = NULL;
	param = (__temp1959 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((__temp1958 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((__temp1957 = vala_ccode_identifier_new ("param_values"))), "data[0]", TRUE))), "v_pointer", FALSE), (__temp1958 == NULL ? NULL : (__temp1958 = (g_object_unref (__temp1958), NULL))), (__temp1957 == NULL ? NULL : (__temp1957 = (g_object_unref (__temp1957), NULL))), __temp1959);
	__temp1960 = NULL;
	__temp1961 = NULL;
	cond = (__temp1961 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1960 = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")))), (__temp1960 == NULL ? NULL : (__temp1960 = (g_object_unref (__temp1960), NULL))), __temp1961);
	__temp1962 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp1962 = vala_ccode_identifier_new ("closure"))));
	(__temp1962 == NULL ? NULL : (__temp1962 = (g_object_unref (__temp1962), NULL)));
	true_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1965 = NULL;
	__temp1964 = NULL;
	__temp1963 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp1965 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1964 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1963 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1965 == NULL ? NULL : (__temp1965 = (g_object_unref (__temp1965), NULL)));
	(__temp1964 == NULL ? NULL : (__temp1964 = (g_object_unref (__temp1964), NULL)));
	(__temp1963 == NULL ? NULL : (__temp1963 = (g_object_unref (__temp1963), NULL)));
	__temp1968 = NULL;
	__temp1967 = NULL;
	__temp1966 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp1968 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1967 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1966 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1968 == NULL ? NULL : (__temp1968 = (g_object_unref (__temp1968), NULL)));
	(__temp1967 == NULL ? NULL : (__temp1967 = (g_object_unref (__temp1967), NULL)));
	(__temp1966 == NULL ? NULL : (__temp1966 = (g_object_unref (__temp1966), NULL)));
	false_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1971 = NULL;
	__temp1970 = NULL;
	__temp1969 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp1971 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1970 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1969 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1971 == NULL ? NULL : (__temp1971 = (g_object_unref (__temp1971), NULL)));
	(__temp1970 == NULL ? NULL : (__temp1970 = (g_object_unref (__temp1970), NULL)));
	(__temp1969 == NULL ? NULL : (__temp1969 = (g_object_unref (__temp1969), NULL)));
	__temp1974 = NULL;
	__temp1973 = NULL;
	__temp1972 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp1974 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1973 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1972 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp1974 == NULL ? NULL : (__temp1974 = (g_object_unref (__temp1974), NULL)));
	(__temp1973 == NULL ? NULL : (__temp1973 = (g_object_unref (__temp1973), NULL)));
	(__temp1972 == NULL ? NULL : (__temp1972 = (g_object_unref (__temp1972), NULL)));
	__temp1975 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1975 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(__temp1975 == NULL ? NULL : (__temp1975 = (g_object_unref (__temp1975), NULL)));
	__temp1983 = NULL;
	__temp1982 = NULL;
	__temp1981 = NULL;
	__temp1980 = NULL;
	__temp1979 = NULL;
	__temp1978 = NULL;
	__temp1977 = NULL;
	__temp1976 = NULL;
	__temp1984 = NULL;
	c_assign = (__temp1984 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1976 = vala_ccode_identifier_new ("callback"))), VALA_CCODE_EXPRESSION ((__temp1983 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((__temp1981 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION ((__temp1977 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((__temp1978 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((__temp1980 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((__temp1979 = vala_ccode_identifier_new ("cc"))), "callback", TRUE)))))), (__temp1982 = vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp1983 == NULL ? NULL : (__temp1983 = (g_object_unref (__temp1983), NULL))), (__temp1982 = (g_free (__temp1982), NULL)), (__temp1981 == NULL ? NULL : (__temp1981 = (g_object_unref (__temp1981), NULL))), (__temp1980 == NULL ? NULL : (__temp1980 = (g_object_unref (__temp1980), NULL))), (__temp1979 == NULL ? NULL : (__temp1979 = (g_object_unref (__temp1979), NULL))), (__temp1978 == NULL ? NULL : (__temp1978 = (g_object_unref (__temp1978), NULL))), (__temp1977 == NULL ? NULL : (__temp1977 = (g_object_unref (__temp1977), NULL))), (__temp1976 == NULL ? NULL : (__temp1976 = (g_object_unref (__temp1976), NULL))), __temp1984);
	__temp1985 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1985 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(__temp1985 == NULL ? NULL : (__temp1985 = (g_object_unref (__temp1985), NULL)));
	__temp1987 = NULL;
	__temp1986 = NULL;
	fc = (__temp1987 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1986 = vala_ccode_identifier_new ("callback")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1987);
	(__temp1986 == NULL ? NULL : (__temp1986 = (g_object_unref (__temp1986), NULL)));
	__temp1988 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1988 = vala_ccode_identifier_new ("data1"))));
	(__temp1988 == NULL ? NULL : (__temp1988 = (g_object_unref (__temp1988), NULL)));
	i = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = gee_iterator_get (p_it);
			{
				char* get_value_function;
				ValaCCodeIdentifier* __temp1991;
				ValaCCodeFunctionCall* __temp1992;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* __temp1996;
				ValaCCodeIdentifier* __temp1995;
				char* __temp1994;
				ValaCCodeIdentifier* __temp1993;
				get_value_function = NULL;
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL) {
					char* __temp1989;
					__temp1989 = NULL;
					get_value_function = (__temp1989 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), __temp1989);
				} else {
					char* __temp1990;
					__temp1990 = NULL;
					get_value_function = (__temp1990 = vala_data_type_get_get_value_function (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), __temp1990);
				}
				__temp1991 = NULL;
				__temp1992 = NULL;
				inner_fc = (__temp1992 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp1991 = vala_ccode_identifier_new (get_value_function)))), (__temp1991 == NULL ? NULL : (__temp1991 = (g_object_unref (__temp1991), NULL))), __temp1992);
				__temp1996 = NULL;
				__temp1995 = NULL;
				__temp1994 = NULL;
				__temp1993 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((__temp1996 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((__temp1993 = vala_ccode_identifier_new ("param_values"))), VALA_CCODE_EXPRESSION ((__temp1995 = vala_ccode_identifier_new ((__temp1994 = g_strdup_printf ("%i", i)))))))));
				(__temp1996 == NULL ? NULL : (__temp1996 = (g_object_unref (__temp1996), NULL)));
				(__temp1995 == NULL ? NULL : (__temp1995 = (g_object_unref (__temp1995), NULL)));
				(__temp1994 = (g_free (__temp1994), NULL));
				(__temp1993 == NULL ? NULL : (__temp1993 = (g_object_unref (__temp1993), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				(get_value_function = (g_free (get_value_function), NULL));
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	__temp1997 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1997 = vala_ccode_identifier_new ("data2"))));
	(__temp1997 == NULL ? NULL : (__temp1997 = (g_object_unref (__temp1997), NULL)));
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeExpressionStatement* __temp2000;
		ValaCCodeAssignment* __temp1999;
		ValaCCodeIdentifier* __temp1998;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* __temp2010;
		ValaCCodeIdentifier* __temp2011;
		ValaCCodeExpressionStatement* __temp2012;
		__temp2000 = NULL;
		__temp1999 = NULL;
		__temp1998 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp2000 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp1999 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp1998 = vala_ccode_identifier_new ("v_return"))), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(__temp2000 == NULL ? NULL : (__temp2000 = (g_object_unref (__temp2000), NULL)));
		(__temp1999 == NULL ? NULL : (__temp1999 = (g_object_unref (__temp1999), NULL)));
		(__temp1998 == NULL ? NULL : (__temp1998 = (g_object_unref (__temp1998), NULL)));
		set_fc = NULL;
		if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
			ValaCCodeFunctionCall* __temp2002;
			ValaCCodeIdentifier* __temp2001;
			__temp2002 = NULL;
			__temp2001 = NULL;
			set_fc = (__temp2002 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2001 = vala_ccode_identifier_new ("g_value_set_pointer")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp2002);
			(__temp2001 == NULL ? NULL : (__temp2001 = (g_object_unref (__temp2001), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))) {
				ValaCCodeFunctionCall* __temp2004;
				ValaCCodeIdentifier* __temp2003;
				__temp2004 = NULL;
				__temp2003 = NULL;
				set_fc = (__temp2004 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2003 = vala_ccode_identifier_new ("g_value_take_object")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp2004);
				(__temp2003 == NULL ? NULL : (__temp2003 = (g_object_unref (__temp2003), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaCCodeFunctionCall* __temp2006;
					ValaCCodeIdentifier* __temp2005;
					__temp2006 = NULL;
					__temp2005 = NULL;
					set_fc = (__temp2006 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2005 = vala_ccode_identifier_new ("g_value_take_string")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp2006);
					(__temp2005 == NULL ? NULL : (__temp2005 = (g_object_unref (__temp2005), NULL)));
				} else {
					ValaCCodeFunctionCall* __temp2009;
					ValaCCodeIdentifier* __temp2008;
					char* __temp2007;
					__temp2009 = NULL;
					__temp2008 = NULL;
					__temp2007 = NULL;
					set_fc = (__temp2009 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2008 = vala_ccode_identifier_new ((__temp2007 = vala_data_type_get_set_value_function (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp2009);
					(__temp2008 == NULL ? NULL : (__temp2008 = (g_object_unref (__temp2008), NULL)));
					(__temp2007 = (g_free (__temp2007), NULL));
				}
			}
		}
		__temp2010 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp2010 = vala_ccode_identifier_new ("return_value"))));
		(__temp2010 == NULL ? NULL : (__temp2010 = (g_object_unref (__temp2010), NULL)));
		__temp2011 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp2011 = vala_ccode_identifier_new ("v_return"))));
		(__temp2011 == NULL ? NULL : (__temp2011 = (g_object_unref (__temp2011), NULL)));
		__temp2012 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp2012 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(__temp2012 == NULL ? NULL : (__temp2012 = (g_object_unref (__temp2012), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* __temp2013;
		__temp2013 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp2013 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp2013 == NULL ? NULL : (__temp2013 = (g_object_unref (__temp2013), NULL)));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	gee_collection_add (GEE_COLLECTION (self->priv->user_marshal_set), signature);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->context) == NULL);
}


static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* __temp2015;
	ValaCCodeFragment* __temp2016;
	ValaCCodeFragment* __temp2017;
	ValaCCodeFragment* __temp2018;
	ValaCCodeFragment* __temp2019;
	ValaCCodeFragment* __temp2020;
	ValaCCodeFragment* __temp2021;
	ValaCCodeFragment* __temp2022;
	ValaCCodeFragment* __temp2023;
	ValaCCodeFragment* __temp2024;
	GeeSet* __temp2025;
	ValaCCodeIncludeDirective* __temp2026;
	ValaCCodeIncludeDirective* __temp2027;
	ValaCCodeIncludeDirective* __temp2029;
	char* __temp2028;
	GeeList* used_includes;
	char* __temp2030;
	char* __temp2065;
	char* __temp2066;
	char* header_define;
	ValaCCodeComment* comment;
	char* __temp2144;
	ValaCCodeWriter* __temp2145;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* __temp2146;
	ValaCCodeNewline* __temp2147;
	ValaCCodeIdentifier* __temp2148;
	ValaCCodeNewline* __temp2149;
	ValaCCodeNewline* __temp2150;
	ValaCCodeNewline* __temp2151;
	ValaCCodeNewline* __temp2152;
	ValaCCodeNewline* __temp2153;
	ValaCCodeIdentifier* __temp2154;
	ValaCCodeNewline* __temp2155;
	ValaCCodeNewline* __temp2156;
	ValaCCodeWriter* __temp2158;
	char* __temp2157;
	ValaCCodeFragment* __temp2159;
	ValaCCodeFragment* __temp2160;
	ValaCCodeFragment* __temp2161;
	ValaCCodeFragment* __temp2162;
	ValaCCodeFragment* __temp2163;
	ValaCCodeFragment* __temp2164;
	ValaCCodeFragment* __temp2165;
	ValaCCodeFragment* __temp2166;
	ValaCCodeFragment* __temp2167;
	ValaCCodeFragment* __temp2168;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	__temp2015 = NULL;
	self->priv->header_begin = (__temp2015 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp2015);
	__temp2016 = NULL;
	self->priv->header_type_declaration = (__temp2016 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp2016);
	__temp2017 = NULL;
	self->priv->header_type_definition = (__temp2017 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp2017);
	__temp2018 = NULL;
	self->priv->header_type_member_declaration = (__temp2018 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp2018);
	__temp2019 = NULL;
	self->priv->source_begin = (__temp2019 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp2019);
	__temp2020 = NULL;
	self->priv->source_include_directives = (__temp2020 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp2020);
	__temp2021 = NULL;
	self->priv->source_type_member_declaration = (__temp2021 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp2021);
	__temp2022 = NULL;
	self->priv->source_type_member_definition = (__temp2022 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp2022);
	__temp2023 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp2023 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp2023);
	__temp2024 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp2024 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp2024);
	__temp2025 = NULL;
	self->priv->user_marshal_set = (__temp2025 = GEE_SET (gee_hash_set_new (g_strdup, g_free, g_str_hash, g_str_equal)), (self->priv->user_marshal_set == NULL ? NULL : (self->priv->user_marshal_set = (g_object_unref (self->priv->user_marshal_set), NULL))), __temp2025);
	self->priv->next_temp_var_id = 0;
	self->priv->string_h_needed = FALSE;
	self->priv->requires_free_checked = FALSE;
	self->priv->requires_array_free = FALSE;
	self->priv->requires_array_move = FALSE;
	__temp2026 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp2026 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(__temp2026 == NULL ? NULL : (__temp2026 = (g_object_unref (__temp2026), NULL)));
	__temp2027 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp2027 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(__temp2027 == NULL ? NULL : (__temp2027 = (g_object_unref (__temp2027), NULL)));
	__temp2029 = NULL;
	__temp2028 = NULL;
	vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp2029 = vala_ccode_include_directive_new ((__temp2028 = vala_source_file_get_cheader_filename (source_file)), TRUE))));
	(__temp2029 == NULL ? NULL : (__temp2029 = (g_object_unref (__temp2029), NULL)));
	(__temp2028 = (g_free (__temp2028), NULL));
	used_includes = GEE_LIST (gee_array_list_new (g_strdup, g_free, g_str_equal));
	gee_collection_add (GEE_COLLECTION (used_includes), "glib.h");
	gee_collection_add (GEE_COLLECTION (used_includes), "glib-object.h");
	__temp2030 = NULL;
	gee_collection_add (GEE_COLLECTION (used_includes), (__temp2030 = vala_source_file_get_cheader_filename (source_file)));
	(__temp2030 = (g_free (__temp2030), NULL));
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* __temp2031;
					__temp2031 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp2031 = vala_ccode_include_directive_new (filename, FALSE))));
					(__temp2031 == NULL ? NULL : (__temp2031 = (g_object_unref (__temp2031), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* __temp2032;
					__temp2032 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp2032 = vala_code_generator_get_internal_include (self, filename))));
					(__temp2032 == NULL ? NULL : (__temp2032 = (g_object_unref (__temp2032), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* __temp2033;
					__temp2033 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp2033 = vala_ccode_include_directive_new (filename, FALSE))));
					(__temp2033 == NULL ? NULL : (__temp2033 = (g_object_unref (__temp2033), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* __temp2034;
					__temp2034 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp2034 = vala_code_generator_get_internal_include (self, filename))));
					(__temp2034 == NULL ? NULL : (__temp2034 = (g_object_unref (__temp2034), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GeeList* cycle_file_collection;
			GeeIterator* cycle_file_it;
			cycle_file_collection = vala_source_file_get_cycle (source_file)->files;
			cycle_file_it = gee_iterable_iterator (GEE_ITERABLE (cycle_file_collection));
			while (gee_iterator_next (cycle_file_it)) {
				ValaSourceFile* __temp2064;
				ValaSourceFile* cycle_file;
				__temp2064 = NULL;
				cycle_file = (__temp2064 = gee_iterator_get (cycle_file_it), (__temp2064 == NULL ? NULL : g_object_ref (__temp2064)));
				{
					{
						GeeCollection* node_collection;
						GeeIterator* node_it;
						node_collection = vala_source_file_get_nodes (cycle_file);
						node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
						while (gee_iterator_next (node_it)) {
							ValaCodeNode* node;
							node = gee_iterator_get (node_it);
							{
								if (VALA_IS_STRUCT (node)) {
									ValaStruct* __temp2035;
									ValaStruct* st;
									ValaCCodeTypeDefinition* __temp2040;
									ValaCCodeVariableDeclarator* __temp2039;
									char* __temp2038;
									char* __temp2037;
									char* __temp2036;
									__temp2035 = NULL;
									st = (__temp2035 = VALA_STRUCT (node), (__temp2035 == NULL ? NULL : g_object_ref (__temp2035)));
									__temp2040 = NULL;
									__temp2039 = NULL;
									__temp2038 = NULL;
									__temp2037 = NULL;
									__temp2036 = NULL;
									vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp2040 = vala_ccode_type_definition_new ((__temp2037 = g_strdup_printf ("struct _%s", (__temp2036 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), VALA_CCODE_DECLARATOR ((__temp2039 = vala_ccode_variable_declarator_new ((__temp2038 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))))));
									(__temp2040 == NULL ? NULL : (__temp2040 = (g_object_unref (__temp2040), NULL)));
									(__temp2039 == NULL ? NULL : (__temp2039 = (g_object_unref (__temp2039), NULL)));
									(__temp2038 = (g_free (__temp2038), NULL));
									(__temp2037 = (g_free (__temp2037), NULL));
									(__temp2036 = (g_free (__temp2036), NULL));
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								} else {
									if (VALA_IS_CLASS (node)) {
										ValaClass* __temp2041;
										ValaClass* cl;
										ValaCCodeTypeDefinition* __temp2046;
										ValaCCodeVariableDeclarator* __temp2045;
										char* __temp2044;
										char* __temp2043;
										char* __temp2042;
										ValaCCodeTypeDefinition* __temp2052;
										ValaCCodeVariableDeclarator* __temp2051;
										char* __temp2050;
										char* __temp2049;
										char* __temp2048;
										char* __temp2047;
										__temp2041 = NULL;
										cl = (__temp2041 = VALA_CLASS (node), (__temp2041 == NULL ? NULL : g_object_ref (__temp2041)));
										__temp2046 = NULL;
										__temp2045 = NULL;
										__temp2044 = NULL;
										__temp2043 = NULL;
										__temp2042 = NULL;
										vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp2046 = vala_ccode_type_definition_new ((__temp2043 = g_strdup_printf ("struct _%s", (__temp2042 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), VALA_CCODE_DECLARATOR ((__temp2045 = vala_ccode_variable_declarator_new ((__temp2044 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
										(__temp2046 == NULL ? NULL : (__temp2046 = (g_object_unref (__temp2046), NULL)));
										(__temp2045 == NULL ? NULL : (__temp2045 = (g_object_unref (__temp2045), NULL)));
										(__temp2044 = (g_free (__temp2044), NULL));
										(__temp2043 = (g_free (__temp2043), NULL));
										(__temp2042 = (g_free (__temp2042), NULL));
										__temp2052 = NULL;
										__temp2051 = NULL;
										__temp2050 = NULL;
										__temp2049 = NULL;
										__temp2048 = NULL;
										__temp2047 = NULL;
										vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp2052 = vala_ccode_type_definition_new ((__temp2048 = g_strdup_printf ("struct _%sClass", (__temp2047 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), VALA_CCODE_DECLARATOR ((__temp2051 = vala_ccode_variable_declarator_new ((__temp2050 = g_strdup_printf ("%sClass", (__temp2049 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))))));
										(__temp2052 == NULL ? NULL : (__temp2052 = (g_object_unref (__temp2052), NULL)));
										(__temp2051 == NULL ? NULL : (__temp2051 = (g_object_unref (__temp2051), NULL)));
										(__temp2050 = (g_free (__temp2050), NULL));
										(__temp2049 = (g_free (__temp2049), NULL));
										(__temp2048 = (g_free (__temp2048), NULL));
										(__temp2047 = (g_free (__temp2047), NULL));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									} else {
										if (VALA_IS_INTERFACE (node)) {
											ValaInterface* __temp2053;
											ValaInterface* iface;
											ValaCCodeTypeDefinition* __temp2058;
											ValaCCodeVariableDeclarator* __temp2057;
											char* __temp2056;
											char* __temp2055;
											char* __temp2054;
											ValaCCodeTypeDefinition* __temp2063;
											ValaCCodeVariableDeclarator* __temp2062;
											char* __temp2061;
											char* __temp2060;
											char* __temp2059;
											__temp2053 = NULL;
											iface = (__temp2053 = VALA_INTERFACE (node), (__temp2053 == NULL ? NULL : g_object_ref (__temp2053)));
											__temp2058 = NULL;
											__temp2057 = NULL;
											__temp2056 = NULL;
											__temp2055 = NULL;
											__temp2054 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp2058 = vala_ccode_type_definition_new ((__temp2055 = g_strdup_printf ("struct _%s", (__temp2054 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))), VALA_CCODE_DECLARATOR ((__temp2057 = vala_ccode_variable_declarator_new ((__temp2056 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))))));
											(__temp2058 == NULL ? NULL : (__temp2058 = (g_object_unref (__temp2058), NULL)));
											(__temp2057 == NULL ? NULL : (__temp2057 = (g_object_unref (__temp2057), NULL)));
											(__temp2056 = (g_free (__temp2056), NULL));
											(__temp2055 = (g_free (__temp2055), NULL));
											(__temp2054 = (g_free (__temp2054), NULL));
											__temp2063 = NULL;
											__temp2062 = NULL;
											__temp2061 = NULL;
											__temp2060 = NULL;
											__temp2059 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp2063 = vala_ccode_type_definition_new ((__temp2060 = g_strdup_printf ("struct _%s", (__temp2059 = vala_interface_get_type_cname (iface)))), VALA_CCODE_DECLARATOR ((__temp2062 = vala_ccode_variable_declarator_new ((__temp2061 = vala_interface_get_type_cname (iface)))))))));
											(__temp2063 == NULL ? NULL : (__temp2063 = (g_object_unref (__temp2063), NULL)));
											(__temp2062 == NULL ? NULL : (__temp2062 = (g_object_unref (__temp2062), NULL)));
											(__temp2061 = (g_free (__temp2061), NULL));
											(__temp2060 = (g_free (__temp2060), NULL));
											(__temp2059 = (g_free (__temp2059), NULL));
											(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
										}
									}
								}
								(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
							}
						}
						(node_collection == NULL ? NULL : (node_collection = (g_object_unref (node_collection), NULL)));
						(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
					}
					(cycle_file == NULL ? NULL : (cycle_file = (g_object_unref (cycle_file), NULL)));
				}
			}
			(cycle_file_it == NULL ? NULL : (cycle_file_it = (g_object_unref (cycle_file_it), NULL)));
		}
	}
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
	__temp2065 = NULL;
	__temp2066 = NULL;
	header_define = (__temp2066 = vala_code_generator_get_define_for_filename ((__temp2065 = vala_source_file_get_cheader_filename (source_file))), (__temp2065 = (g_free (__temp2065), NULL)), __temp2066);
	/* generate hardcoded "well-known" macros */
	if (self->priv->requires_free_checked) {
		ValaCCodeMacroReplacement* __temp2067;
		__temp2067 = NULL;
		vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp2067 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
		(__temp2067 == NULL ? NULL : (__temp2067 = (g_object_unref (__temp2067), NULL)));
	}
	if (self->priv->requires_array_free) {
		ValaCCodeFunction* fun;
		ValaCCodeFormalParameter* __temp2068;
		ValaCCodeFormalParameter* __temp2069;
		ValaCCodeFormalParameter* __temp2070;
		ValaCCodeFunction* __temp2071;
		ValaCCodeBlock* cdofree;
		ValaCCodeDeclaration* citdecl;
		ValaCCodeVariableDeclarator* __temp2072;
		ValaCCodeBlock* cbody;
		ValaCCodeIdentifier* __temp2073;
		ValaCCodeCastExpression* __temp2074;
		ValaCCodeCastExpression* cptrarray;
		ValaCCodeIdentifier* __temp2075;
		ValaCCodeElementAccess* __temp2076;
		ValaCCodeElementAccess* cea;
		ValaCCodeConstant* __temp2077;
		ValaCCodeBinaryExpression* __temp2078;
		ValaCCodeBinaryExpression* cfreecond;
		ValaCCodeIdentifier* __temp2079;
		ValaCCodeFunctionCall* __temp2080;
		ValaCCodeFunctionCall* cfreecall;
		ValaCCodeIfStatement* __temp2082;
		ValaCCodeExpressionStatement* __temp2081;
		ValaCCodeIdentifier* __temp2084;
		ValaCCodeIdentifier* __temp2083;
		ValaCCodeBinaryExpression* __temp2085;
		ValaCCodeBinaryExpression* cforcond;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* __temp2088;
		ValaCCodeConstant* __temp2087;
		ValaCCodeIdentifier* __temp2086;
		ValaCCodeAssignment* __temp2093;
		ValaCCodeBinaryExpression* __temp2092;
		ValaCCodeConstant* __temp2091;
		ValaCCodeIdentifier* __temp2090;
		ValaCCodeIdentifier* __temp2089;
		ValaCCodeConstant* __temp2095;
		ValaCCodeIdentifier* __temp2094;
		ValaCCodeBinaryExpression* __temp2096;
		ValaCCodeBinaryExpression* ccondarr;
		ValaCCodeConstant* __temp2098;
		ValaCCodeIdentifier* __temp2097;
		ValaCCodeBinaryExpression* __temp2099;
		ValaCCodeBinaryExpression* ccondfunc;
		ValaCCodeBinaryExpression* __temp2100;
		ValaCCodeIfStatement* __temp2101;
		ValaCCodeIfStatement* cif;
		ValaCCodeBlock* __temp2102;
		ValaCCodeIdentifier* __temp2103;
		ValaCCodeFunctionCall* __temp2104;
		ValaCCodeFunctionCall* carrfree;
		ValaCCodeIdentifier* __temp2105;
		ValaCCodeExpressionStatement* __temp2106;
		fun = vala_ccode_function_new ("_vala_array_free", "void");
		vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		__temp2068 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2068 = vala_ccode_formal_parameter_new ("array", "gpointer")));
		(__temp2068 == NULL ? NULL : (__temp2068 = (g_object_unref (__temp2068), NULL)));
		__temp2069 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2069 = vala_ccode_formal_parameter_new ("array_length", "gint")));
		(__temp2069 == NULL ? NULL : (__temp2069 = (g_object_unref (__temp2069), NULL)));
		__temp2070 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2070 = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify")));
		(__temp2070 == NULL ? NULL : (__temp2070 = (g_object_unref (__temp2070), NULL)));
		__temp2071 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp2071 = vala_ccode_function_copy (fun))));
		(__temp2071 = (g_object_unref (__temp2071), NULL));
		cdofree = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		citdecl = vala_ccode_declaration_new ("int");
		__temp2072 = NULL;
		vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp2072 = vala_ccode_variable_declarator_new ("i"))));
		(__temp2072 == NULL ? NULL : (__temp2072 = (g_object_unref (__temp2072), NULL)));
		vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (citdecl));
		cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		__temp2073 = NULL;
		__temp2074 = NULL;
		cptrarray = (__temp2074 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((__temp2073 = vala_ccode_identifier_new ("array"))), "gpointer*"), (__temp2073 == NULL ? NULL : (__temp2073 = (g_object_unref (__temp2073), NULL))), __temp2074);
		__temp2075 = NULL;
		__temp2076 = NULL;
		cea = (__temp2076 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (cptrarray), VALA_CCODE_EXPRESSION ((__temp2075 = vala_ccode_identifier_new ("i")))), (__temp2075 == NULL ? NULL : (__temp2075 = (g_object_unref (__temp2075), NULL))), __temp2076);
		__temp2077 = NULL;
		__temp2078 = NULL;
		cfreecond = (__temp2078 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((__temp2077 = vala_ccode_constant_new ("NULL")))), (__temp2077 == NULL ? NULL : (__temp2077 = (g_object_unref (__temp2077), NULL))), __temp2078);
		__temp2079 = NULL;
		__temp2080 = NULL;
		cfreecall = (__temp2080 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2079 = vala_ccode_identifier_new ("destroy_func")))), (__temp2079 == NULL ? NULL : (__temp2079 = (g_object_unref (__temp2079), NULL))), __temp2080);
		vala_ccode_function_call_add_argument (cfreecall, VALA_CCODE_EXPRESSION (cea));
		__temp2082 = NULL;
		__temp2081 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((__temp2082 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cfreecond), VALA_CCODE_STATEMENT ((__temp2081 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))), NULL))));
		(__temp2082 == NULL ? NULL : (__temp2082 = (g_object_unref (__temp2082), NULL)));
		(__temp2081 == NULL ? NULL : (__temp2081 = (g_object_unref (__temp2081), NULL)));
		__temp2084 = NULL;
		__temp2083 = NULL;
		__temp2085 = NULL;
		cforcond = (__temp2085 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((__temp2083 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((__temp2084 = vala_ccode_identifier_new ("array_length")))), (__temp2084 == NULL ? NULL : (__temp2084 = (g_object_unref (__temp2084), NULL))), (__temp2083 == NULL ? NULL : (__temp2083 = (g_object_unref (__temp2083), NULL))), __temp2085);
		cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (cforcond), VALA_CCODE_STATEMENT (cbody));
		__temp2088 = NULL;
		__temp2087 = NULL;
		__temp2086 = NULL;
		vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp2088 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp2086 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((__temp2087 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp2088 == NULL ? NULL : (__temp2088 = (g_object_unref (__temp2088), NULL)));
		(__temp2087 == NULL ? NULL : (__temp2087 = (g_object_unref (__temp2087), NULL)));
		(__temp2086 == NULL ? NULL : (__temp2086 = (g_object_unref (__temp2086), NULL)));
		__temp2093 = NULL;
		__temp2092 = NULL;
		__temp2091 = NULL;
		__temp2090 = NULL;
		__temp2089 = NULL;
		vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp2093 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp2089 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((__temp2092 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((__temp2090 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((__temp2091 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp2093 == NULL ? NULL : (__temp2093 = (g_object_unref (__temp2093), NULL)));
		(__temp2092 == NULL ? NULL : (__temp2092 = (g_object_unref (__temp2092), NULL)));
		(__temp2091 == NULL ? NULL : (__temp2091 = (g_object_unref (__temp2091), NULL)));
		(__temp2090 == NULL ? NULL : (__temp2090 = (g_object_unref (__temp2090), NULL)));
		(__temp2089 == NULL ? NULL : (__temp2089 = (g_object_unref (__temp2089), NULL)));
		vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (cfor));
		__temp2095 = NULL;
		__temp2094 = NULL;
		__temp2096 = NULL;
		ccondarr = (__temp2096 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp2094 = vala_ccode_identifier_new ("array"))), VALA_CCODE_EXPRESSION ((__temp2095 = vala_ccode_constant_new ("NULL")))), (__temp2095 == NULL ? NULL : (__temp2095 = (g_object_unref (__temp2095), NULL))), (__temp2094 == NULL ? NULL : (__temp2094 = (g_object_unref (__temp2094), NULL))), __temp2096);
		__temp2098 = NULL;
		__temp2097 = NULL;
		__temp2099 = NULL;
		ccondfunc = (__temp2099 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((__temp2097 = vala_ccode_identifier_new ("destroy_func"))), VALA_CCODE_EXPRESSION ((__temp2098 = vala_ccode_constant_new ("NULL")))), (__temp2098 == NULL ? NULL : (__temp2098 = (g_object_unref (__temp2098), NULL))), (__temp2097 == NULL ? NULL : (__temp2097 = (g_object_unref (__temp2097), NULL))), __temp2099);
		__temp2100 = NULL;
		__temp2101 = NULL;
		cif = (__temp2101 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((__temp2100 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccondarr), VALA_CCODE_EXPRESSION (ccondfunc)))), VALA_CCODE_STATEMENT (cdofree), NULL), (__temp2100 == NULL ? NULL : (__temp2100 = (g_object_unref (__temp2100), NULL))), __temp2101);
		__temp2102 = NULL;
		vala_ccode_function_set_block (fun, (__temp2102 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
		(__temp2102 == NULL ? NULL : (__temp2102 = (g_object_unref (__temp2102), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE (cif));
		__temp2103 = NULL;
		__temp2104 = NULL;
		carrfree = (__temp2104 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2103 = vala_ccode_identifier_new ("g_free")))), (__temp2103 == NULL ? NULL : (__temp2103 = (g_object_unref (__temp2103), NULL))), __temp2104);
		__temp2105 = NULL;
		vala_ccode_function_call_add_argument (carrfree, VALA_CCODE_EXPRESSION ((__temp2105 = vala_ccode_identifier_new ("array"))));
		(__temp2105 == NULL ? NULL : (__temp2105 = (g_object_unref (__temp2105), NULL)));
		__temp2106 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((__temp2106 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (carrfree)))));
		(__temp2106 == NULL ? NULL : (__temp2106 = (g_object_unref (__temp2106), NULL)));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (fun));
		(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
		(cdofree == NULL ? NULL : (cdofree = (g_object_unref (cdofree), NULL)));
		(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
		(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
		(cptrarray == NULL ? NULL : (cptrarray = (g_object_unref (cptrarray), NULL)));
		(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
		(cfreecond == NULL ? NULL : (cfreecond = (g_object_unref (cfreecond), NULL)));
		(cfreecall == NULL ? NULL : (cfreecall = (g_object_unref (cfreecall), NULL)));
		(cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL)));
		(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		(ccondarr == NULL ? NULL : (ccondarr = (g_object_unref (ccondarr), NULL)));
		(ccondfunc == NULL ? NULL : (ccondfunc = (g_object_unref (ccondfunc), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
		(carrfree == NULL ? NULL : (carrfree = (g_object_unref (carrfree), NULL)));
	}
	if (self->priv->requires_array_move) {
		ValaCCodeFunction* fun;
		ValaCCodeFormalParameter* __temp2107;
		ValaCCodeFormalParameter* __temp2108;
		ValaCCodeFormalParameter* __temp2109;
		ValaCCodeFormalParameter* __temp2110;
		ValaCCodeFormalParameter* __temp2111;
		ValaCCodeFunction* __temp2112;
		ValaCCodeIdentifier* array;
		ValaCCodeIdentifier* element_size;
		ValaCCodeIdentifier* length;
		ValaCCodeIdentifier* src;
		ValaCCodeIdentifier* dest;
		ValaCCodeBinaryExpression* __temp2113;
		ValaCCodeBinaryExpression* __temp2114;
		ValaCCodeBinaryExpression* src_address;
		ValaCCodeBinaryExpression* __temp2115;
		ValaCCodeBinaryExpression* __temp2116;
		ValaCCodeBinaryExpression* dest_address;
		ValaCCodeBinaryExpression* __temp2119;
		ValaCCodeParenthesizedExpression* __temp2118;
		ValaCCodeBinaryExpression* __temp2117;
		ValaCCodeBinaryExpression* __temp2120;
		ValaCCodeBinaryExpression* dest_end_address;
		ValaCCodeBlock* __temp2121;
		ValaCCodeIdentifier* __temp2122;
		ValaCCodeFunctionCall* __temp2123;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeBinaryExpression* __temp2124;
		ValaCCodeExpressionStatement* __temp2125;
		ValaCCodeIdentifier* __temp2126;
		ValaCCodeFunctionCall* __temp2127;
		ValaCCodeFunctionCall* czero1;
		ValaCCodeConstant* __temp2128;
		ValaCCodeBinaryExpression* __temp2131;
		ValaCCodeParenthesizedExpression* __temp2130;
		ValaCCodeBinaryExpression* __temp2129;
		ValaCCodeBlock* czeroblock1;
		ValaCCodeExpressionStatement* __temp2132;
		ValaCCodeIdentifier* __temp2133;
		ValaCCodeFunctionCall* __temp2134;
		ValaCCodeFunctionCall* czero2;
		ValaCCodeConstant* __temp2135;
		ValaCCodeBinaryExpression* __temp2138;
		ValaCCodeParenthesizedExpression* __temp2137;
		ValaCCodeBinaryExpression* __temp2136;
		ValaCCodeBlock* czeroblock2;
		ValaCCodeExpressionStatement* __temp2139;
		ValaCCodeIfStatement* __temp2141;
		ValaCCodeBinaryExpression* __temp2140;
		self->priv->string_h_needed = TRUE;
		/* assumes that overwritten array elements are null before invocation
		 FIXME will leak memory if that's not the case*/
		fun = vala_ccode_function_new ("_vala_array_move", "void");
		vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		__temp2107 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2107 = vala_ccode_formal_parameter_new ("array", "gpointer")));
		(__temp2107 == NULL ? NULL : (__temp2107 = (g_object_unref (__temp2107), NULL)));
		__temp2108 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2108 = vala_ccode_formal_parameter_new ("element_size", "gsize")));
		(__temp2108 == NULL ? NULL : (__temp2108 = (g_object_unref (__temp2108), NULL)));
		__temp2109 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2109 = vala_ccode_formal_parameter_new ("src", "gint")));
		(__temp2109 == NULL ? NULL : (__temp2109 = (g_object_unref (__temp2109), NULL)));
		__temp2110 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2110 = vala_ccode_formal_parameter_new ("dest", "gint")));
		(__temp2110 == NULL ? NULL : (__temp2110 = (g_object_unref (__temp2110), NULL)));
		__temp2111 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp2111 = vala_ccode_formal_parameter_new ("length", "gint")));
		(__temp2111 == NULL ? NULL : (__temp2111 = (g_object_unref (__temp2111), NULL)));
		__temp2112 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp2112 = vala_ccode_function_copy (fun))));
		(__temp2112 = (g_object_unref (__temp2112), NULL));
		array = vala_ccode_identifier_new ("array");
		element_size = vala_ccode_identifier_new ("element_size");
		length = vala_ccode_identifier_new ("length");
		src = vala_ccode_identifier_new ("src");
		dest = vala_ccode_identifier_new ("dest");
		__temp2113 = NULL;
		__temp2114 = NULL;
		src_address = (__temp2114 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((__temp2113 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (element_size))))), (__temp2113 == NULL ? NULL : (__temp2113 = (g_object_unref (__temp2113), NULL))), __temp2114);
		__temp2115 = NULL;
		__temp2116 = NULL;
		dest_address = (__temp2116 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((__temp2115 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (element_size))))), (__temp2115 == NULL ? NULL : (__temp2115 = (g_object_unref (__temp2115), NULL))), __temp2116);
		__temp2119 = NULL;
		__temp2118 = NULL;
		__temp2117 = NULL;
		__temp2120 = NULL;
		dest_end_address = (__temp2120 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((__temp2119 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((__temp2118 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((__temp2117 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (length))))))), VALA_CCODE_EXPRESSION (element_size))))), (__temp2119 == NULL ? NULL : (__temp2119 = (g_object_unref (__temp2119), NULL))), (__temp2118 == NULL ? NULL : (__temp2118 = (g_object_unref (__temp2118), NULL))), (__temp2117 == NULL ? NULL : (__temp2117 = (g_object_unref (__temp2117), NULL))), __temp2120);
		__temp2121 = NULL;
		vala_ccode_function_set_block (fun, (__temp2121 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
		(__temp2121 == NULL ? NULL : (__temp2121 = (g_object_unref (__temp2121), NULL)));
		__temp2122 = NULL;
		__temp2123 = NULL;
		ccall = (__temp2123 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2122 = vala_ccode_identifier_new ("g_memmove")))), (__temp2122 == NULL ? NULL : (__temp2122 = (g_object_unref (__temp2122), NULL))), __temp2123);
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (dest_address));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (src_address));
		__temp2124 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp2124 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (length), VALA_CCODE_EXPRESSION (element_size)))));
		(__temp2124 == NULL ? NULL : (__temp2124 = (g_object_unref (__temp2124), NULL)));
		__temp2125 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((__temp2125 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(__temp2125 == NULL ? NULL : (__temp2125 = (g_object_unref (__temp2125), NULL)));
		__temp2126 = NULL;
		__temp2127 = NULL;
		czero1 = (__temp2127 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2126 = vala_ccode_identifier_new ("memset")))), (__temp2126 == NULL ? NULL : (__temp2126 = (g_object_unref (__temp2126), NULL))), __temp2127);
		vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION (src_address));
		__temp2128 = NULL;
		vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((__temp2128 = vala_ccode_constant_new ("0"))));
		(__temp2128 == NULL ? NULL : (__temp2128 = (g_object_unref (__temp2128), NULL)));
		__temp2131 = NULL;
		__temp2130 = NULL;
		__temp2129 = NULL;
		vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((__temp2131 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((__temp2130 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((__temp2129 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (src))))))), VALA_CCODE_EXPRESSION (element_size)))));
		(__temp2131 == NULL ? NULL : (__temp2131 = (g_object_unref (__temp2131), NULL)));
		(__temp2130 == NULL ? NULL : (__temp2130 = (g_object_unref (__temp2130), NULL)));
		(__temp2129 == NULL ? NULL : (__temp2129 = (g_object_unref (__temp2129), NULL)));
		czeroblock1 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		__temp2132 = NULL;
		vala_ccode_block_add_statement (czeroblock1, VALA_CCODE_NODE ((__temp2132 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero1)))));
		(__temp2132 == NULL ? NULL : (__temp2132 = (g_object_unref (__temp2132), NULL)));
		__temp2133 = NULL;
		__temp2134 = NULL;
		czero2 = (__temp2134 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2133 = vala_ccode_identifier_new ("memset")))), (__temp2133 == NULL ? NULL : (__temp2133 = (g_object_unref (__temp2133), NULL))), __temp2134);
		vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION (dest_end_address));
		__temp2135 = NULL;
		vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((__temp2135 = vala_ccode_constant_new ("0"))));
		(__temp2135 == NULL ? NULL : (__temp2135 = (g_object_unref (__temp2135), NULL)));
		__temp2138 = NULL;
		__temp2137 = NULL;
		__temp2136 = NULL;
		vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((__temp2138 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((__temp2137 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((__temp2136 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest))))))), VALA_CCODE_EXPRESSION (element_size)))));
		(__temp2138 == NULL ? NULL : (__temp2138 = (g_object_unref (__temp2138), NULL)));
		(__temp2137 == NULL ? NULL : (__temp2137 = (g_object_unref (__temp2137), NULL)));
		(__temp2136 == NULL ? NULL : (__temp2136 = (g_object_unref (__temp2136), NULL)));
		czeroblock2 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		__temp2139 = NULL;
		vala_ccode_block_add_statement (czeroblock2, VALA_CCODE_NODE ((__temp2139 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero2)))));
		(__temp2139 == NULL ? NULL : (__temp2139 = (g_object_unref (__temp2139), NULL)));
		__temp2141 = NULL;
		__temp2140 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((__temp2141 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((__temp2140 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest)))), VALA_CCODE_STATEMENT (czeroblock1), VALA_CCODE_STATEMENT (czeroblock2)))));
		(__temp2141 == NULL ? NULL : (__temp2141 = (g_object_unref (__temp2141), NULL)));
		(__temp2140 == NULL ? NULL : (__temp2140 = (g_object_unref (__temp2140), NULL)));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (fun));
		(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
		(element_size == NULL ? NULL : (element_size = (g_object_unref (element_size), NULL)));
		(length == NULL ? NULL : (length = (g_object_unref (length), NULL)));
		(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
		(dest == NULL ? NULL : (dest = (g_object_unref (dest), NULL)));
		(src_address == NULL ? NULL : (src_address = (g_object_unref (src_address), NULL)));
		(dest_address == NULL ? NULL : (dest_address = (g_object_unref (dest_address), NULL)));
		(dest_end_address == NULL ? NULL : (dest_end_address = (g_object_unref (dest_end_address), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(czero1 == NULL ? NULL : (czero1 = (g_object_unref (czero1), NULL)));
		(czeroblock1 == NULL ? NULL : (czeroblock1 = (g_object_unref (czeroblock1), NULL)));
		(czero2 == NULL ? NULL : (czero2 = (g_object_unref (czero2), NULL)));
		(czeroblock2 == NULL ? NULL : (czeroblock2 = (g_object_unref (czeroblock2), NULL)));
	}
	if (self->priv->string_h_needed) {
		ValaCCodeIncludeDirective* __temp2142;
		__temp2142 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp2142 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(__temp2142 == NULL ? NULL : (__temp2142 = (g_object_unref (__temp2142), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* __temp2143;
		__temp2143 = NULL;
		comment = (__temp2143 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), __temp2143);
	}
	__temp2144 = NULL;
	__temp2145 = NULL;
	writer = (__temp2145 = vala_ccode_writer_new ((__temp2144 = vala_source_file_get_cheader_filename (source_file))), (__temp2144 = (g_free (__temp2144), NULL)), __temp2145);
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	__temp2146 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2146 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2146 == NULL ? NULL : (__temp2146 = (g_object_unref (__temp2146), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_begin));
	__temp2147 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2147 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2147 == NULL ? NULL : (__temp2147 = (g_object_unref (__temp2147), NULL)));
	__temp2148 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2148 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(__temp2148 == NULL ? NULL : (__temp2148 = (g_object_unref (__temp2148), NULL)));
	__temp2149 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2149 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2149 == NULL ? NULL : (__temp2149 = (g_object_unref (__temp2149), NULL)));
	__temp2150 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2150 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2150 == NULL ? NULL : (__temp2150 = (g_object_unref (__temp2150), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_declaration));
	__temp2151 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2151 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2151 == NULL ? NULL : (__temp2151 = (g_object_unref (__temp2151), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_definition));
	__temp2152 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2152 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2152 == NULL ? NULL : (__temp2152 = (g_object_unref (__temp2152), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_member_declaration));
	__temp2153 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2153 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2153 == NULL ? NULL : (__temp2153 = (g_object_unref (__temp2153), NULL)));
	__temp2154 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2154 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(__temp2154 == NULL ? NULL : (__temp2154 = (g_object_unref (__temp2154), NULL)));
	__temp2155 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2155 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2155 == NULL ? NULL : (__temp2155 = (g_object_unref (__temp2155), NULL)));
	__temp2156 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp2156 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp2156 == NULL ? NULL : (__temp2156 = (g_object_unref (__temp2156), NULL)));
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	__temp2158 = NULL;
	__temp2157 = NULL;
	writer = (__temp2158 = vala_ccode_writer_new ((__temp2157 = vala_source_file_get_csource_filename (source_file))), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), __temp2158);
	(__temp2157 = (g_free (__temp2157), NULL));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	__temp2159 = NULL;
	self->priv->header_begin = (__temp2159 = NULL, (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp2159);
	__temp2160 = NULL;
	self->priv->header_type_declaration = (__temp2160 = NULL, (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp2160);
	__temp2161 = NULL;
	self->priv->header_type_definition = (__temp2161 = NULL, (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp2161);
	__temp2162 = NULL;
	self->priv->header_type_member_declaration = (__temp2162 = NULL, (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp2162);
	__temp2163 = NULL;
	self->priv->source_begin = (__temp2163 = NULL, (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp2163);
	__temp2164 = NULL;
	self->priv->source_include_directives = (__temp2164 = NULL, (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp2164);
	__temp2165 = NULL;
	self->priv->source_type_member_declaration = (__temp2165 = NULL, (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp2165);
	__temp2166 = NULL;
	self->priv->source_type_member_definition = (__temp2166 = NULL, (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp2166);
	__temp2167 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp2167 = NULL, (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp2167);
	__temp2168 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp2168 = NULL, (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp2168);
	(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
	(header_define = (g_free (header_define), NULL));
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static char* vala_code_generator_get_define_for_filename (const char* filename)
{
	GString* define;
	char* i;
	const char* __temp2171;
	char* __temp2172;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	i = g_strdup (filename);
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* __temp2170;
		const char* __temp2169;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		__temp2170 = NULL;
		__temp2169 = NULL;
		i = (__temp2170 = (__temp2169 = g_utf8_next_char (i), (__temp2169 == NULL ? NULL : g_strdup (__temp2169))), (i = (g_free (i), NULL)), __temp2170);
	}
	g_string_append (define, "__");
	__temp2171 = NULL;
	__temp2172 = NULL;
	return (__temp2172 = (__temp2171 = define->str, (__temp2171 == NULL ? NULL : g_strdup (__temp2171))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), __temp2172);
	(define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL)));
	(i = (g_free (i), NULL));
}


static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp2173;
	ValaSymbol* old_type_symbol;
	ValaCCodeStruct* __temp2174;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeFragment* __temp2175;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaSymbol* __temp2176;
	ValaCCodeStruct* __temp2179;
	char* __temp2178;
	char* __temp2177;
	ValaCCodeFragment* __temp2180;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaSymbol* __temp2209;
	ValaSymbol* __temp2208;
	ValaCCodeStruct* __temp2211;
	ValaCCodeStruct* __temp2210;
	ValaCCodeFragment* __temp2213;
	ValaCCodeFragment* __temp2212;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	__temp2173 = NULL;
	old_type_symbol = (__temp2173 = self->priv->current_type_symbol, (__temp2173 == NULL ? NULL : g_object_ref (__temp2173)));
	__temp2174 = NULL;
	old_instance_struct = (__temp2174 = self->priv->instance_struct, (__temp2174 == NULL ? NULL : g_object_ref (__temp2174)));
	__temp2175 = NULL;
	old_instance_dispose_fragment = (__temp2175 = self->priv->instance_dispose_fragment, (__temp2175 == NULL ? NULL : g_object_ref (__temp2175)));
	__temp2176 = NULL;
	self->priv->current_type_symbol = (__temp2176 = VALA_SYMBOL (g_object_ref (st)), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp2176);
	__temp2179 = NULL;
	__temp2178 = NULL;
	__temp2177 = NULL;
	self->priv->instance_struct = (__temp2179 = vala_ccode_struct_new ((__temp2178 = g_strdup_printf ("_%s", (__temp2177 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp2179);
	(__temp2178 = (g_free (__temp2178), NULL));
	(__temp2177 = (g_free (__temp2177), NULL));
	__temp2180 = NULL;
	self->priv->instance_dispose_fragment = (__temp2180 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp2180);
	decl_frag = NULL;
	def_frag = NULL;
	if (((ValaDataType*) st)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* __temp2182;
		ValaCCodeFragment* __temp2181;
		ValaCCodeFragment* __temp2184;
		ValaCCodeFragment* __temp2183;
		__temp2182 = NULL;
		__temp2181 = NULL;
		decl_frag = (__temp2182 = (__temp2181 = self->priv->header_type_declaration, (__temp2181 == NULL ? NULL : g_object_ref (__temp2181))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), __temp2182);
		__temp2184 = NULL;
		__temp2183 = NULL;
		def_frag = (__temp2184 = (__temp2183 = self->priv->header_type_definition, (__temp2183 == NULL ? NULL : g_object_ref (__temp2183))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), __temp2184);
	} else {
		ValaCCodeFragment* __temp2186;
		ValaCCodeFragment* __temp2185;
		ValaCCodeFragment* __temp2188;
		ValaCCodeFragment* __temp2187;
		__temp2186 = NULL;
		__temp2185 = NULL;
		decl_frag = (__temp2186 = (__temp2185 = self->priv->source_type_member_declaration, (__temp2185 == NULL ? NULL : g_object_ref (__temp2185))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), __temp2186);
		__temp2188 = NULL;
		__temp2187 = NULL;
		def_frag = (__temp2188 = (__temp2187 = self->priv->source_type_member_declaration, (__temp2187 == NULL ? NULL : g_object_ref (__temp2187))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), __temp2188);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) st)))) == NULL) {
		ValaCCodeTypeDefinition* __temp2193;
		ValaCCodeVariableDeclarator* __temp2192;
		char* __temp2191;
		char* __temp2190;
		char* __temp2189;
		__temp2193 = NULL;
		__temp2192 = NULL;
		__temp2191 = NULL;
		__temp2190 = NULL;
		__temp2189 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp2193 = vala_ccode_type_definition_new ((__temp2190 = g_strdup_printf ("struct _%s", (__temp2189 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), VALA_CCODE_DECLARATOR ((__temp2192 = vala_ccode_variable_declarator_new ((__temp2191 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))))));
		(__temp2193 == NULL ? NULL : (__temp2193 = (g_object_unref (__temp2193), NULL)));
		(__temp2192 == NULL ? NULL : (__temp2192 = (g_object_unref (__temp2192), NULL)));
		(__temp2191 = (g_free (__temp2191), NULL));
		(__temp2190 = (g_free (__temp2190), NULL));
		(__temp2189 = (g_free (__temp2189), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) st))) != NULL) {
		ValaCCodeComment* __temp2194;
		__temp2194 = NULL;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((__temp2194 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) st)))))));
		(__temp2194 == NULL ? NULL : (__temp2194 = (g_object_unref (__temp2194), NULL)));
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	if (vala_struct_get_default_construction_method (st) != NULL) {
		char* __temp2196;
		char* __temp2195;
		ValaCCodeFunction* __temp2197;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* __temp2200;
		char* __temp2199;
		char* __temp2198;
		ValaCCodeFunction* __temp2201;
		ValaCCodeBlock* cblock;
		ValaCCodeIdentifier* __temp2202;
		ValaCCodeFunctionCall* __temp2203;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp2205;
		char* __temp2204;
		ValaCCodeIdentifier* __temp2206;
		ValaCCodeExpressionStatement* __temp2207;
		__temp2196 = NULL;
		__temp2195 = NULL;
		__temp2197 = NULL;
		function = (__temp2197 = vala_ccode_function_new ((__temp2196 = g_strconcat ((__temp2195 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (st))), "free", NULL)), "void"), (__temp2196 = (g_free (__temp2196), NULL)), (__temp2195 = (g_free (__temp2195), NULL)), __temp2197);
		if (((ValaDataType*) st)->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		__temp2200 = NULL;
		__temp2199 = NULL;
		__temp2198 = NULL;
		vala_ccode_function_add_parameter (function, (__temp2200 = vala_ccode_formal_parameter_new ("self", (__temp2199 = g_strconcat ((__temp2198 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL)))));
		(__temp2200 == NULL ? NULL : (__temp2200 = (g_object_unref (__temp2200), NULL)));
		(__temp2199 = (g_free (__temp2199), NULL));
		(__temp2198 = (g_free (__temp2198), NULL));
		__temp2201 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((__temp2201 = vala_ccode_function_copy (function))));
		(__temp2201 = (g_object_unref (__temp2201), NULL));
		cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
		__temp2202 = NULL;
		__temp2203 = NULL;
		ccall = (__temp2203 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp2202 = vala_ccode_identifier_new ("g_slice_free")))), (__temp2202 == NULL ? NULL : (__temp2202 = (g_object_unref (__temp2202), NULL))), __temp2203);
		__temp2205 = NULL;
		__temp2204 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp2205 = vala_ccode_identifier_new ((__temp2204 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))))));
		(__temp2205 == NULL ? NULL : (__temp2205 = (g_object_unref (__temp2205), NULL)));
		(__temp2204 = (g_free (__temp2204), NULL));
		__temp2206 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp2206 = vala_ccode_identifier_new ("self"))));
		(__temp2206 == NULL ? NULL : (__temp2206 = (g_object_unref (__temp2206), NULL)));
		__temp2207 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp2207 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(__temp2207 == NULL ? NULL : (__temp2207 = (g_object_unref (__temp2207), NULL)));
		vala_ccode_function_set_block (function, cblock);
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (function));
		(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	__temp2209 = NULL;
	__temp2208 = NULL;
	self->priv->current_type_symbol = (__temp2209 = (__temp2208 = old_type_symbol, (__temp2208 == NULL ? NULL : g_object_ref (__temp2208))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp2209);
	__temp2211 = NULL;
	__temp2210 = NULL;
	self->priv->instance_struct = (__temp2211 = (__temp2210 = old_instance_struct, (__temp2210 == NULL ? NULL : g_object_ref (__temp2210))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp2211);
	__temp2213 = NULL;
	__temp2212 = NULL;
	self->priv->instance_dispose_fragment = (__temp2213 = (__temp2212 = old_instance_dispose_fragment, (__temp2212 == NULL ? NULL : g_object_ref (__temp2212))), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp2213);
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


gboolean vala_code_generator_get_memory_management (ValaCodeGenerator* self)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	return self->priv->_memory_management;
}


void vala_code_generator_set_memory_management (ValaCodeGenerator* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	self->priv->_memory_management = value;
}


static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	ValaCodeGenerator * self;
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_CODE_GENERATOR (obj);
	{
		GeeSet* __temp2215;
		GeeSet* __temp2216;
		__temp2215 = NULL;
		self->priv->predefined_marshal_set = (__temp2215 = GEE_SET (gee_hash_set_new (g_strdup, g_free, g_str_hash, g_str_equal)), (self->priv->predefined_marshal_set == NULL ? NULL : (self->priv->predefined_marshal_set = (g_object_unref (self->priv->predefined_marshal_set), NULL))), __temp2215);
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:VOID");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:BOOLEAN");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:CHAR");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UCHAR");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:INT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UINT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:LONG");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:ULONG");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:ENUM");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:FLAGS");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:FLOAT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:DOUBLE");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:STRING");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:OBJECT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "STRING:OBJECT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UINT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "BOOLEAN:FLAGS");
		__temp2216 = NULL;
		self->priv->c_keywords = (__temp2216 = GEE_SET (gee_hash_set_new (g_strdup, g_free, g_str_hash, g_str_equal)), (self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_object_unref (self->priv->c_keywords), NULL))), __temp2216);
		/* C99 keywords*/
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Bool");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Complex");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Imaginary");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "auto");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "break");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "case");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "char");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "const");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "continue");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "default");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "do");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "double");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "else");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "enum");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "extern");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "float");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "for");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "goto");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "if");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "inline");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "int");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "long");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "register");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "restrict");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "return");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "short");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "signed");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "sizeof");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "static");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "struct");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "switch");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "typedef");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "union");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "unsigned");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "void");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "volatile");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "while");
		/* MSVC keywords*/
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "cdecl");
	}
	return obj;
}


static void vala_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		g_value_set_boolean (value, vala_code_generator_get_memory_management (self));
		break;
	}
}


static void vala_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		vala_code_generator_set_memory_management (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass)
{
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_code_generator_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_code_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_code_generator_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_code_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_code_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_code_generator_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_code_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_code_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_code_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_code_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_code_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_code_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_code_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_code_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_block = vala_code_generator_real_visit_begin_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_block = vala_code_generator_real_visit_end_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_code_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_code_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_code_generator_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_initializer_list = vala_code_generator_real_visit_end_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_code_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_code_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_code_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_code_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_code_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_code_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_code_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_foreach_statement = vala_code_generator_real_visit_begin_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_foreach_statement = vala_code_generator_real_visit_end_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_code_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_code_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_return_statement = vala_code_generator_real_visit_begin_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_return_statement = vala_code_generator_real_visit_end_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_code_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_code_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_code_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_code_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_array_creation_expression = vala_code_generator_real_visit_end_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_code_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_code_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_code_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_code_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_code_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_code_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_literal_expression = vala_code_generator_real_visit_literal_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_code_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_code_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_code_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_code_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_object_creation_expression = vala_code_generator_real_visit_end_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_code_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_code_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_code_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_code_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_code_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_code_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_code_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_code_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_code_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_code_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_lambda_expression = vala_code_generator_real_visit_end_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_assignment = vala_code_generator_real_visit_end_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_code_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_code_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_invocation_expression = vala_code_generator_real_visit_end_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_code_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_code_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_code_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_code_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_code_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_code_generator_real_visit_struct;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_GENERATOR_MEMORY_MANAGEMENT, g_param_spec_boolean ("memory-management", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_code_generator_init (ValaCodeGenerator * self)
{
	self->priv = VALA_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->temp_vars = gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal);
	self->priv->temp_ref_vars = gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal);
	self->priv->next_temp_var_id = 0;
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->priv->in_creation_method = FALSE;
	self->priv->current_method_inner_error = FALSE;
	self->priv->in_plugin = FALSE;
}


static void vala_code_generator_dispose (GObject * obj)
{
	ValaCodeGenerator * self;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CODE_GENERATOR (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL)));
	(self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL)));
	(self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL)));
	(self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL)));
	(self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL)));
	(self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL)));
	(self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL)));
	(self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL)));
	(self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL)));
	(self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL)));
	(self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL)));
	(self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL)));
	(self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL)));
	(self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL)));
	(self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL)));
	(self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL)));
	(self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL)));
	(self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL)));
	(self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL)));
	(self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL)));
	(self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL)));
	(self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL)));
	(self->priv->block == NULL ? NULL : (self->priv->block = (g_object_unref (self->priv->block), NULL)));
	(self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_object_unref (self->priv->temp_vars), NULL)));
	(self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_object_unref (self->priv->temp_ref_vars), NULL)));
	(self->priv->user_marshal_set == NULL ? NULL : (self->priv->user_marshal_set = (g_object_unref (self->priv->user_marshal_set), NULL)));
	(self->priv->predefined_marshal_set == NULL ? NULL : (self->priv->predefined_marshal_set = (g_object_unref (self->priv->predefined_marshal_set), NULL)));
	(self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_object_unref (self->priv->c_keywords), NULL)));
	(self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL)));
	(self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL)));
	(self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL)));
	(self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL)));
	(self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL)));
	(self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL)));
	(self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL)));
	(self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL)));
	(self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL)));
	(self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL)));
	(self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL)));
	(self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL)));
	(self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL)));
	(self->priv->glist_type == NULL ? NULL : (self->priv->glist_type = (g_object_unref (self->priv->glist_type), NULL)));
	(self->priv->gslist_type == NULL ? NULL : (self->priv->gslist_type = (g_object_unref (self->priv->gslist_type), NULL)));
	(self->priv->gstring_type == NULL ? NULL : (self->priv->gstring_type = (g_object_unref (self->priv->gstring_type), NULL)));
	(self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL)));
	(self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL)));
	(self->priv->iterable_type == NULL ? NULL : (self->priv->iterable_type = (g_object_unref (self->priv->iterable_type), NULL)));
	(self->priv->iterator_type == NULL ? NULL : (self->priv->iterator_type = (g_object_unref (self->priv->iterator_type), NULL)));
	(self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL)));
	(self->priv->map_type == NULL ? NULL : (self->priv->map_type = (g_object_unref (self->priv->map_type), NULL)));
	(self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL)));
	(self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL));
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_code_generator_get_type (void)
{
	static GType vala_code_generator_type_id = 0;
	if (G_UNLIKELY (vala_code_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_init };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




