/* valawhilestatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valawhilestatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valawhilestatement.h>
#include <vala/valacodevisitor.h>

struct _ValaWhileStatementPrivate {
	ValaStatement* _body;
	ValaExpression* _condition;
};
#define VALA_WHILE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementPrivate))
enum  {
	VALA_WHILE_STATEMENT_DUMMY_PROPERTY,
	VALA_WHILE_STATEMENT_CONDITION,
	VALA_WHILE_STATEMENT_BODY,
};
static void vala_while_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_while_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_while_statement_parent_class = NULL;
static void vala_while_statement_dispose (GObject * obj);


/**
 * Creates a new while statement.
 *
 * @param cond   loop condition
 * @param body   loop body
 * @param source reference to source code
 * @return       newly created while statement
 */
ValaWhileStatement* vala_while_statement_new (ValaExpression* cond, ValaStatement* _body, ValaSourceReference* source)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (cond), NULL);
	g_return_val_if_fail (VALA_IS_STATEMENT (_body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 3);
	GParameter * __params_it = __params;
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, cond), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_STATEMENT), g_value_set_object (&__params_it->value, _body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaWhileStatement * self = g_object_newv (VALA_TYPE_WHILE_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_while_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaWhileStatement * self = VALA_WHILE_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_while_statement_get_condition (self)), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_while_statement_get_condition (self));
	vala_code_node_accept (VALA_CODE_NODE (vala_while_statement_get_body (self)), visitor);
	vala_code_visitor_visit_while_statement (visitor, self);
}


static void vala_while_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaWhileStatement * self = VALA_WHILE_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_while_statement_get_condition (self)) == old_node) {
		(vala_while_statement_set_condition (self, VALA_EXPRESSION (new_node)), vala_while_statement_get_condition (self));
	}
}


ValaExpression* vala_while_statement_get_condition (ValaWhileStatement* self)
{
	g_return_val_if_fail (VALA_IS_WHILE_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_while_statement_set_condition (ValaWhileStatement* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (self));
	ValaExpression* __temp1 = NULL;
	self->priv->_condition = (__temp1 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp1);
	(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_condition), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_condition)));
}


ValaStatement* vala_while_statement_get_body (ValaWhileStatement* self)
{
	g_return_val_if_fail (VALA_IS_WHILE_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_while_statement_set_body (ValaWhileStatement* self, ValaStatement* value)
{
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (self));
	ValaStatement* __temp4 = NULL;
	ValaStatement* __temp3 = NULL;
	self->priv->_body = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp4);
}


static void vala_while_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaWhileStatement * self = VALA_WHILE_STATEMENT (object);
	switch (property_id) {
		case VALA_WHILE_STATEMENT_CONDITION:
		g_value_set_object (value, vala_while_statement_get_condition (self));
		break;
		case VALA_WHILE_STATEMENT_BODY:
		g_value_set_object (value, vala_while_statement_get_body (self));
		break;
	}
}


static void vala_while_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaWhileStatement * self = VALA_WHILE_STATEMENT (object);
	switch (property_id) {
		case VALA_WHILE_STATEMENT_CONDITION:
		vala_while_statement_set_condition (self, g_value_get_object (value));
		break;
		case VALA_WHILE_STATEMENT_BODY:
		vala_while_statement_set_body (self, g_value_get_object (value));
		break;
	}
}


static void vala_while_statement_class_init (ValaWhileStatementClass * klass)
{
	vala_while_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaWhileStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_while_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_while_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_while_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_while_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_while_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_WHILE_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_WHILE_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_while_statement_init (ValaWhileStatement * self)
{
	self->priv = VALA_WHILE_STATEMENT_GET_PRIVATE (self);
}


static void vala_while_statement_dispose (GObject * obj)
{
	ValaWhileStatement * self = VALA_WHILE_STATEMENT (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	ValaWhileStatementClass * klass;
	GObjectClass * parent_class;
	klass = VALA_WHILE_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_WHILE_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_while_statement_get_type ()
{
	static GType vala_while_statement_type_id = 0;
	if (G_UNLIKELY (vala_while_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaWhileStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_while_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaWhileStatement), 0, (GInstanceInitFunc) vala_while_statement_init };
		vala_while_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaWhileStatement", &g_define_type_info, 0);
	}
	return vala_while_statement_type_id;
}




