/* valatypeparameter.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valatypeparameter.h"
#include <vala/valasourcereference.h>
#include <vala/valatypeparameter.h>
#include <vala/valacodevisitor.h>
#include <vala/valaarray.h>
#include <vala/valasymbol.h>
#include <vala/valadatatype.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>

struct _ValaTypeParameterPrivate {
	char* _name;
	GHashTable* array_types;
};
#define VALA_TYPE_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_PARAMETER, ValaTypeParameterPrivate))
enum  {
	VALA_TYPE_PARAMETER_DUMMY_PROPERTY,
	VALA_TYPE_PARAMETER_NAME,
};
static void vala_type_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_type_parameter_parent_class = NULL;
static void vala_type_parameter_dispose (GObject * obj);


/**
 * Creates a new generic type parameter.
 *
 * @param name   parameter name
 * @param source reference to source code
 * @return       newly created generic type parameter
 */
ValaTypeParameter* vala_type_parameter_new (const char* _name, ValaSourceReference* source)
{
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaTypeParameter * self = g_object_newv (VALA_TYPE_TYPE_PARAMETER, __params_it - __params, __params);
	return self;
}


static void vala_type_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaTypeParameter * self = VALA_TYPE_PARAMETER (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_type_parameter (visitor, self);
}


/**
 * Returns the array type for elements of this type parameter.
 *
 * @param rank the rank the array should be of
 * @return array type for this type parameter
 */
ValaArray* vala_type_parameter_get_array (ValaTypeParameter* self, gint rank)
{
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (self), NULL);
	ValaArray* __temp1 = NULL;
	char* __temp0 = NULL;
	ValaArray* __temp2 = NULL;
	ValaArray* array_type = (__temp2 = (__temp1 = VALA_ARRAY (g_hash_table_lookup (self->priv->array_types, (__temp0 = g_strdup_printf ("%i", rank)))), (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (__temp0 = (g_free (__temp0), NULL)), __temp2);
	if (array_type == NULL) {
		ValaArray* new_array_type = vala_array_new_with_type_parameter (self, rank, vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
		/* create a new Symbol */
		ValaSymbol* __temp3 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (new_array_type), (__temp3 = vala_symbol_new (VALA_CODE_NODE (new_array_type)))), vala_code_node_get_symbol (VALA_CODE_NODE (new_array_type)));
		(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
		vala_symbol_add (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self))), vala_data_type_get_name (VALA_DATA_TYPE (new_array_type)), vala_code_node_get_symbol (VALA_CODE_NODE (new_array_type)));
		/* add internal length field */
		ValaArrayLengthField* __temp5 = NULL;
		ValaArrayLengthField* __temp4 = NULL;
		vala_symbol_add (vala_code_node_get_symbol (VALA_CODE_NODE (new_array_type)), vala_field_get_name (VALA_FIELD ((__temp4 = vala_array_get_length_field (new_array_type)))), vala_code_node_get_symbol (VALA_CODE_NODE ((__temp5 = vala_array_get_length_field (new_array_type)))));
		(__temp5 == NULL ? NULL : (__temp5 = (g_object_unref (__temp5), NULL)));
		(__temp4 == NULL ? NULL : (__temp4 = (g_object_unref (__temp4), NULL)));
		/* add internal resize method */
		ValaArrayResizeMethod* __temp7 = NULL;
		ValaArrayResizeMethod* __temp6 = NULL;
		vala_symbol_add (vala_code_node_get_symbol (VALA_CODE_NODE (new_array_type)), vala_method_get_name (VALA_METHOD ((__temp6 = vala_array_get_resize_method (new_array_type)))), vala_code_node_get_symbol (VALA_CODE_NODE ((__temp7 = vala_array_get_resize_method (new_array_type)))));
		(__temp7 == NULL ? NULL : (__temp7 = (g_object_unref (__temp7), NULL)));
		(__temp6 == NULL ? NULL : (__temp6 = (g_object_unref (__temp6), NULL)));
		/* link the array type to the same source as the container type */
		(vala_code_node_set_source_reference (VALA_CODE_NODE (new_array_type), vala_code_node_get_source_reference (VALA_CODE_NODE (self))), vala_code_node_get_source_reference (VALA_CODE_NODE (new_array_type)));
		ValaArray* __temp8 = NULL;
		g_hash_table_insert (self->priv->array_types, g_strdup_printf ("%i", rank), (__temp8 = new_array_type, (__temp8 == NULL ? NULL : g_object_ref (__temp8))));
		ValaArray* __temp10 = NULL;
		ValaArray* __temp9 = NULL;
		array_type = (__temp10 = (__temp9 = new_array_type, (__temp9 == NULL ? NULL : g_object_ref (__temp9))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp10);
		(new_array_type == NULL ? NULL : (new_array_type = (g_object_unref (new_array_type), NULL)));
	}
	return array_type;
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


/**
 * Checks two type parameters for equality.
 *
 * @param param2 a type parameter
 * @return      true if this type parameter is equal to param2, false
 *              otherwise
 */
gboolean vala_type_parameter_equals (ValaTypeParameter* self, ValaTypeParameter* param2)
{
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (self), FALSE);
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (param2), FALSE);
	return TRUE;
}


char* vala_type_parameter_get_name (ValaTypeParameter* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (self), NULL);
	return self->priv->_name;
}


void vala_type_parameter_set_name (ValaTypeParameter* self, const char* value)
{
	g_return_if_fail (VALA_IS_TYPE_PARAMETER (self));
	char* __temp14 = NULL;
	self->priv->_name = (__temp14 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp14);
}


static void vala_type_parameter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaTypeParameter * self = VALA_TYPE_PARAMETER (object);
	switch (property_id) {
		case VALA_TYPE_PARAMETER_NAME:
		g_value_set_string (value, vala_type_parameter_get_name (self));
		break;
	}
}


static void vala_type_parameter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaTypeParameter * self = VALA_TYPE_PARAMETER (object);
	switch (property_id) {
		case VALA_TYPE_PARAMETER_NAME:
		vala_type_parameter_set_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_type_parameter_class_init (ValaTypeParameterClass * klass)
{
	vala_type_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeParameterPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_type_parameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_type_parameter_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_type_parameter_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_type_parameter_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_PARAMETER_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_type_parameter_init (ValaTypeParameter * self)
{
	self->priv = VALA_TYPE_PARAMETER_GET_PRIVATE (self);
	self->priv->array_types = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
}


static void vala_type_parameter_dispose (GObject * obj)
{
	ValaTypeParameter * self = VALA_TYPE_PARAMETER (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->array_types == NULL ? NULL : (self->priv->array_types = (g_hash_table_unref (self->priv->array_types), NULL)));
	ValaTypeParameterClass * klass;
	GObjectClass * parent_class;
	klass = VALA_TYPE_PARAMETER_CLASS (g_type_class_peek (VALA_TYPE_TYPE_PARAMETER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_parameter_get_type ()
{
	static GType vala_type_parameter_type_id = 0;
	if (G_UNLIKELY (vala_type_parameter_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeParameter), 0, (GInstanceInitFunc) vala_type_parameter_init };
		vala_type_parameter_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaTypeParameter", &g_define_type_info, 0);
	}
	return vala_type_parameter_type_id;
}




