/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valapropertyaccessor.h"
#include <vala/valastatement.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valacodevisitor.h>

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	ValaStatement* _body;
	ValaFormalParameter* _value_parameter;
};
#define VALA_PROPERTY_ACCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorPrivate))
enum  {
	VALA_PROPERTY_ACCESSOR_DUMMY_PROPERTY,
	VALA_PROPERTY_ACCESSOR_READABLE,
	VALA_PROPERTY_ACCESSOR_WRITABLE,
	VALA_PROPERTY_ACCESSOR_CONSTRUCTION,
	VALA_PROPERTY_ACCESSOR_BODY,
	VALA_PROPERTY_ACCESSOR_VALUE_PARAMETER,
};
static void vala_property_accessor_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_property_accessor_parent_class = NULL;
static void vala_property_accessor_dispose (GObject * obj);


/**
 * Creates a new property accessor.
 *
 * @param readable     true if get accessor, false otherwise
 * @param writable     true if set accessor, false otherwise
 * @param construction true if construct accessor, false otherwise
 * @param body         accessor body
 * @param source       reference to source code
 * @return             newly created property accessor
 */
ValaPropertyAccessor* vala_property_accessor_new (gboolean _readable, gboolean _writable, gboolean _construction, ValaStatement* _body, ValaSourceReference* source)
{
	g_return_val_if_fail (_body == NULL || VALA_IS_STATEMENT (_body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 5);
	GParameter * __params_it = __params;
	(__params_it->name = "readable", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, _readable), __params_it++);
	(__params_it->name = "writable", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, _writable), __params_it++);
	(__params_it->name = "construction", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, _construction), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_STATEMENT), g_value_set_object (&__params_it->value, _body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaPropertyAccessor * self = g_object_newv (VALA_TYPE_PROPERTY_ACCESSOR, __params_it - __params, __params);
	return self;
}


static void vala_property_accessor_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self = VALA_PROPERTY_ACCESSOR (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_begin_property_accessor (visitor, self);
	if (vala_property_accessor_get_body (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_property_accessor_get_body (self)), visitor);
	}
	vala_code_visitor_visit_end_property_accessor (visitor, self);
}


gboolean vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (self), FALSE);
	return self->priv->_readable;
}


void vala_property_accessor_set_readable (ValaPropertyAccessor* self, gboolean value)
{
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (self));
	self->priv->_readable = value;
}


gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (self), FALSE);
	return self->priv->_writable;
}


void vala_property_accessor_set_writable (ValaPropertyAccessor* self, gboolean value)
{
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (self));
	self->priv->_writable = value;
}


gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (self), FALSE);
	return self->priv->_construction;
}


void vala_property_accessor_set_construction (ValaPropertyAccessor* self, gboolean value)
{
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (self));
	self->priv->_construction = value;
}


ValaStatement* vala_property_accessor_get_body (ValaPropertyAccessor* self)
{
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (self), NULL);
	return self->priv->_body;
}


void vala_property_accessor_set_body (ValaPropertyAccessor* self, ValaStatement* value)
{
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (self));
	ValaStatement* __temp5 = NULL;
	ValaStatement* __temp4 = NULL;
	self->priv->_body = (__temp5 = (__temp4 = value, (__temp4 == NULL ? NULL : g_object_ref (__temp4))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp5);
}


ValaFormalParameter* vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (self), NULL);
	return self->priv->_value_parameter;
}


void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self, ValaFormalParameter* value)
{
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (self));
	ValaFormalParameter* __temp8 = NULL;
	ValaFormalParameter* __temp7 = NULL;
	self->priv->_value_parameter = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_value_parameter == NULL ? NULL : (self->priv->_value_parameter = (g_object_unref (self->priv->_value_parameter), NULL))), __temp8);
}


static void vala_property_accessor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaPropertyAccessor * self = VALA_PROPERTY_ACCESSOR (object);
	switch (property_id) {
		case VALA_PROPERTY_ACCESSOR_READABLE:
		g_value_set_boolean (value, vala_property_accessor_get_readable (self));
		break;
		case VALA_PROPERTY_ACCESSOR_WRITABLE:
		g_value_set_boolean (value, vala_property_accessor_get_writable (self));
		break;
		case VALA_PROPERTY_ACCESSOR_CONSTRUCTION:
		g_value_set_boolean (value, vala_property_accessor_get_construction (self));
		break;
		case VALA_PROPERTY_ACCESSOR_BODY:
		g_value_set_object (value, vala_property_accessor_get_body (self));
		break;
		case VALA_PROPERTY_ACCESSOR_VALUE_PARAMETER:
		g_value_set_object (value, vala_property_accessor_get_value_parameter (self));
		break;
	}
}


static void vala_property_accessor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaPropertyAccessor * self = VALA_PROPERTY_ACCESSOR (object);
	switch (property_id) {
		case VALA_PROPERTY_ACCESSOR_READABLE:
		vala_property_accessor_set_readable (self, g_value_get_boolean (value));
		break;
		case VALA_PROPERTY_ACCESSOR_WRITABLE:
		vala_property_accessor_set_writable (self, g_value_get_boolean (value));
		break;
		case VALA_PROPERTY_ACCESSOR_CONSTRUCTION:
		vala_property_accessor_set_construction (self, g_value_get_boolean (value));
		break;
		case VALA_PROPERTY_ACCESSOR_BODY:
		vala_property_accessor_set_body (self, g_value_get_object (value));
		break;
		case VALA_PROPERTY_ACCESSOR_VALUE_PARAMETER:
		vala_property_accessor_set_value_parameter (self, g_value_get_object (value));
		break;
	}
}


static void vala_property_accessor_class_init (ValaPropertyAccessorClass * klass)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPropertyAccessorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_property_accessor_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_property_accessor_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_property_accessor_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_property_accessor_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_PROPERTY_ACCESSOR_READABLE, g_param_spec_boolean ("readable", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_PROPERTY_ACCESSOR_WRITABLE, g_param_spec_boolean ("writable", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_PROPERTY_ACCESSOR_CONSTRUCTION, g_param_spec_boolean ("construction", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_PROPERTY_ACCESSOR_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_PROPERTY_ACCESSOR_VALUE_PARAMETER, g_param_spec_object ("value-parameter", "foo", "bar", VALA_TYPE_FORMAL_PARAMETER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_property_accessor_init (ValaPropertyAccessor * self)
{
	self->priv = VALA_PROPERTY_ACCESSOR_GET_PRIVATE (self);
}


static void vala_property_accessor_dispose (GObject * obj)
{
	ValaPropertyAccessor * self = VALA_PROPERTY_ACCESSOR (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_value_parameter == NULL ? NULL : (self->priv->_value_parameter = (g_object_unref (self->priv->_value_parameter), NULL)));
	ValaPropertyAccessorClass * klass;
	GObjectClass * parent_class;
	klass = VALA_PROPERTY_ACCESSOR_CLASS (g_type_class_peek (VALA_TYPE_PROPERTY_ACCESSOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_property_accessor_get_type ()
{
	static GType vala_property_accessor_type_id = 0;
	if (G_UNLIKELY (vala_property_accessor_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_init };
		vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaPropertyAccessor", &g_define_type_info, 0);
	}
	return vala_property_accessor_type_id;
}




