/* valamember.vala
 *
 * Copyright (C) 2006  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valamember.h"
#include <vala/valacodevisitor.h>
#include <vala/valamember.h>

struct _ValaMemberPrivate {
};
#define VALA_MEMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER, ValaMemberPrivate))
enum  {
	VALA_MEMBER_DUMMY_PROPERTY,
};
static void vala_member_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_member_parent_class = NULL;


static void vala_member_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaMember * self = VALA_MEMBER (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_member (visitor, self);
}


static void vala_member_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaMember * self = VALA_MEMBER (object);
	switch (property_id) {
	}
}


static void vala_member_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaMember * self = VALA_MEMBER (object);
	switch (property_id) {
	}
}


static void vala_member_class_init (ValaMemberClass * klass)
{
	vala_member_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_member_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_member_set_property;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_member_real_accept;
}


static void vala_member_init (ValaMember * self)
{
}


GType vala_member_get_type ()
{
	static GType vala_member_type_id = 0;
	if (G_UNLIKELY (vala_member_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMember), 0, (GInstanceInitFunc) vala_member_init };
		vala_member_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaMember", &g_define_type_info, 0);
	}
	return vala_member_type_id;
}




