/* valacontinuestatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacontinuestatement.h"
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valacontinuestatement.h>

struct _ValaContinueStatementPrivate {
};
#define VALA_CONTINUE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementPrivate))
enum  {
	VALA_CONTINUE_STATEMENT_DUMMY_PROPERTY,
};
static void vala_continue_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_continue_statement_parent_class = NULL;


/**
 * Creates a new continue statement.
 *
 * @param source reference to source code
 * @return       newly created continue statement
 */
ValaContinueStatement* vala_continue_statement_new (ValaSourceReference* source)
{
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaContinueStatement * self = g_object_newv (VALA_TYPE_CONTINUE_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_continue_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaContinueStatement * self = VALA_CONTINUE_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_continue_statement (visitor, self);
}


static void vala_continue_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaContinueStatement * self = VALA_CONTINUE_STATEMENT (object);
	switch (property_id) {
	}
}


static void vala_continue_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaContinueStatement * self = VALA_CONTINUE_STATEMENT (object);
	switch (property_id) {
	}
}


static void vala_continue_statement_class_init (ValaContinueStatementClass * klass)
{
	vala_continue_statement_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_continue_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_continue_statement_set_property;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_continue_statement_real_accept;
}


static void vala_continue_statement_init (ValaContinueStatement * self)
{
}


GType vala_continue_statement_get_type ()
{
	static GType vala_continue_statement_type_id = 0;
	if (G_UNLIKELY (vala_continue_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaContinueStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_continue_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaContinueStatement), 0, (GInstanceInitFunc) vala_continue_statement_init };
		vala_continue_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaContinueStatement", &g_define_type_info, 0);
	}
	return vala_continue_statement_type_id;
}




